/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* eslint-disable object-curly-newline, no-empty-function, no-restricted-syntax */

'use strict';

var Float64Array = require( '@stdlib/array/float64' );
var isArrayLikeObject = require( './../lib' );

console.log( isArrayLikeObject( { 'length': 10 } ) );
// => true

console.log( isArrayLikeObject( [] ) );
// => true

console.log( isArrayLikeObject( new Float64Array( 10 ) ) );
// => true

console.log( (function test() {
	return isArrayLikeObject( arguments );
})() );
// => true

console.log( isArrayLikeObject( 'beep' ) );
// => false

console.log( isArrayLikeObject( null ) );
// => false

console.log( isArrayLikeObject( void 0 ) );
// => false

console.log( isArrayLikeObject( 5 ) );
// => false

console.log( isArrayLikeObject( true ) );
// => false

console.log( isArrayLikeObject( {} ) );
// => false

console.log( isArrayLikeObject( function noop() {} ) );
// => false
