import { KeySet } from './KeySet';
import { Pick } from './Pick';
import { List } from './List';
/**
 * Pick a range of entries (portion) from `L`
 * @param L to pick from
 * @param From to start with
 * @param To to end with
 * @returns [[List]]
 * @example
 * ```ts
 * ```
 */
export declare type Extract<L extends List, From extends number, To extends number> = Pick<L, KeySet<From, To>>;
