/**
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { test, expect } from './npmTest';

test(`playwright-core should work`, async ({ exec, installedSoftwareOnDisk }) => {
  const result1 = await exec('npm i --foreground-scripts playwright-core');
  expect(result1).toHaveLoggedSoftwareDownload([]);
  expect(await installedSoftwareOnDisk()).toEqual([]);
  const stdio = await exec('npx playwright-core', 'test', '-c', '.', { expectToExitWithError: true });
  expect(stdio).toContain(`Please install @playwright/test package`);
});
