// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package omics

import (
	"fmt"
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/signer/v4"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAbortMultipartReadSetUpload = "AbortMultipartReadSetUpload"

// AbortMultipartReadSetUploadRequest generates a "aws/request.Request" representing the
// client's request for the AbortMultipartReadSetUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AbortMultipartReadSetUpload for more information on using the AbortMultipartReadSetUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AbortMultipartReadSetUploadRequest method.
//	req, resp := client.AbortMultipartReadSetUploadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/AbortMultipartReadSetUpload
func (c *Omics) AbortMultipartReadSetUploadRequest(input *AbortMultipartReadSetUploadInput) (req *request.Request, output *AbortMultipartReadSetUploadOutput) {
	op := &request.Operation{
		Name:       opAbortMultipartReadSetUpload,
		HTTPMethod: "DELETE",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/upload/{uploadId}/abort",
	}

	if input == nil {
		input = &AbortMultipartReadSetUploadInput{}
	}

	output = &AbortMultipartReadSetUploadOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// AbortMultipartReadSetUpload API operation for Amazon Omics.
//
// Stops a multipart upload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation AbortMultipartReadSetUpload for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - NotSupportedOperationException
//     The operation is not supported by Amazon Omics, or the API does not exist.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/AbortMultipartReadSetUpload
func (c *Omics) AbortMultipartReadSetUpload(input *AbortMultipartReadSetUploadInput) (*AbortMultipartReadSetUploadOutput, error) {
	req, out := c.AbortMultipartReadSetUploadRequest(input)
	return out, req.Send()
}

// AbortMultipartReadSetUploadWithContext is the same as AbortMultipartReadSetUpload with the addition of
// the ability to pass a context and additional request options.
//
// See AbortMultipartReadSetUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) AbortMultipartReadSetUploadWithContext(ctx aws.Context, input *AbortMultipartReadSetUploadInput, opts ...request.Option) (*AbortMultipartReadSetUploadOutput, error) {
	req, out := c.AbortMultipartReadSetUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAcceptShare = "AcceptShare"

// AcceptShareRequest generates a "aws/request.Request" representing the
// client's request for the AcceptShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptShare for more information on using the AcceptShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptShareRequest method.
//	req, resp := client.AcceptShareRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/AcceptShare
func (c *Omics) AcceptShareRequest(input *AcceptShareInput) (req *request.Request, output *AcceptShareOutput) {
	op := &request.Operation{
		Name:       opAcceptShare,
		HTTPMethod: "POST",
		HTTPPath:   "/share/{shareId}",
	}

	if input == nil {
		input = &AcceptShareInput{}
	}

	output = &AcceptShareOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// AcceptShare API operation for Amazon Omics.
//
// Accepts a share for an analytics store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation AcceptShare for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/AcceptShare
func (c *Omics) AcceptShare(input *AcceptShareInput) (*AcceptShareOutput, error) {
	req, out := c.AcceptShareRequest(input)
	return out, req.Send()
}

// AcceptShareWithContext is the same as AcceptShare with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) AcceptShareWithContext(ctx aws.Context, input *AcceptShareInput, opts ...request.Option) (*AcceptShareOutput, error) {
	req, out := c.AcceptShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteReadSet = "BatchDeleteReadSet"

// BatchDeleteReadSetRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteReadSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteReadSet for more information on using the BatchDeleteReadSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDeleteReadSetRequest method.
//	req, resp := client.BatchDeleteReadSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/BatchDeleteReadSet
func (c *Omics) BatchDeleteReadSetRequest(input *BatchDeleteReadSetInput) (req *request.Request, output *BatchDeleteReadSetOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteReadSet,
		HTTPMethod: "POST",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/readset/batch/delete",
	}

	if input == nil {
		input = &BatchDeleteReadSetInput{}
	}

	output = &BatchDeleteReadSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchDeleteReadSet API operation for Amazon Omics.
//
// Deletes one or more read sets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation BatchDeleteReadSet for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/BatchDeleteReadSet
func (c *Omics) BatchDeleteReadSet(input *BatchDeleteReadSetInput) (*BatchDeleteReadSetOutput, error) {
	req, out := c.BatchDeleteReadSetRequest(input)
	return out, req.Send()
}

// BatchDeleteReadSetWithContext is the same as BatchDeleteReadSet with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteReadSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) BatchDeleteReadSetWithContext(ctx aws.Context, input *BatchDeleteReadSetInput, opts ...request.Option) (*BatchDeleteReadSetOutput, error) {
	req, out := c.BatchDeleteReadSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelAnnotationImportJob = "CancelAnnotationImportJob"

// CancelAnnotationImportJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelAnnotationImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelAnnotationImportJob for more information on using the CancelAnnotationImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelAnnotationImportJobRequest method.
//	req, resp := client.CancelAnnotationImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelAnnotationImportJob
func (c *Omics) CancelAnnotationImportJobRequest(input *CancelAnnotationImportJobInput) (req *request.Request, output *CancelAnnotationImportJobOutput) {
	op := &request.Operation{
		Name:       opCancelAnnotationImportJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/import/annotation/{jobId}",
	}

	if input == nil {
		input = &CancelAnnotationImportJobInput{}
	}

	output = &CancelAnnotationImportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CancelAnnotationImportJob API operation for Amazon Omics.
//
// Cancels an annotation import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation CancelAnnotationImportJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelAnnotationImportJob
func (c *Omics) CancelAnnotationImportJob(input *CancelAnnotationImportJobInput) (*CancelAnnotationImportJobOutput, error) {
	req, out := c.CancelAnnotationImportJobRequest(input)
	return out, req.Send()
}

// CancelAnnotationImportJobWithContext is the same as CancelAnnotationImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelAnnotationImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) CancelAnnotationImportJobWithContext(ctx aws.Context, input *CancelAnnotationImportJobInput, opts ...request.Option) (*CancelAnnotationImportJobOutput, error) {
	req, out := c.CancelAnnotationImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelRun = "CancelRun"

// CancelRunRequest generates a "aws/request.Request" representing the
// client's request for the CancelRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelRun for more information on using the CancelRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelRunRequest method.
//	req, resp := client.CancelRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelRun
func (c *Omics) CancelRunRequest(input *CancelRunInput) (req *request.Request, output *CancelRunOutput) {
	op := &request.Operation{
		Name:       opCancelRun,
		HTTPMethod: "POST",
		HTTPPath:   "/run/{id}/cancel",
	}

	if input == nil {
		input = &CancelRunInput{}
	}

	output = &CancelRunOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("workflows-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CancelRun API operation for Amazon Omics.
//
// Cancels a run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation CancelRun for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelRun
func (c *Omics) CancelRun(input *CancelRunInput) (*CancelRunOutput, error) {
	req, out := c.CancelRunRequest(input)
	return out, req.Send()
}

// CancelRunWithContext is the same as CancelRun with the addition of
// the ability to pass a context and additional request options.
//
// See CancelRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) CancelRunWithContext(ctx aws.Context, input *CancelRunInput, opts ...request.Option) (*CancelRunOutput, error) {
	req, out := c.CancelRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelVariantImportJob = "CancelVariantImportJob"

// CancelVariantImportJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelVariantImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelVariantImportJob for more information on using the CancelVariantImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelVariantImportJobRequest method.
//	req, resp := client.CancelVariantImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelVariantImportJob
func (c *Omics) CancelVariantImportJobRequest(input *CancelVariantImportJobInput) (req *request.Request, output *CancelVariantImportJobOutput) {
	op := &request.Operation{
		Name:       opCancelVariantImportJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/import/variant/{jobId}",
	}

	if input == nil {
		input = &CancelVariantImportJobInput{}
	}

	output = &CancelVariantImportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CancelVariantImportJob API operation for Amazon Omics.
//
// Cancels a variant import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation CancelVariantImportJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelVariantImportJob
func (c *Omics) CancelVariantImportJob(input *CancelVariantImportJobInput) (*CancelVariantImportJobOutput, error) {
	req, out := c.CancelVariantImportJobRequest(input)
	return out, req.Send()
}

// CancelVariantImportJobWithContext is the same as CancelVariantImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelVariantImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) CancelVariantImportJobWithContext(ctx aws.Context, input *CancelVariantImportJobInput, opts ...request.Option) (*CancelVariantImportJobOutput, error) {
	req, out := c.CancelVariantImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCompleteMultipartReadSetUpload = "CompleteMultipartReadSetUpload"

// CompleteMultipartReadSetUploadRequest generates a "aws/request.Request" representing the
// client's request for the CompleteMultipartReadSetUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CompleteMultipartReadSetUpload for more information on using the CompleteMultipartReadSetUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CompleteMultipartReadSetUploadRequest method.
//	req, resp := client.CompleteMultipartReadSetUploadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CompleteMultipartReadSetUpload
func (c *Omics) CompleteMultipartReadSetUploadRequest(input *CompleteMultipartReadSetUploadInput) (req *request.Request, output *CompleteMultipartReadSetUploadOutput) {
	op := &request.Operation{
		Name:       opCompleteMultipartReadSetUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/upload/{uploadId}/complete",
	}

	if input == nil {
		input = &CompleteMultipartReadSetUploadInput{}
	}

	output = &CompleteMultipartReadSetUploadOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CompleteMultipartReadSetUpload API operation for Amazon Omics.
//
// Concludes a multipart upload once you have uploaded all the components.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation CompleteMultipartReadSetUpload for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - NotSupportedOperationException
//     The operation is not supported by Amazon Omics, or the API does not exist.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CompleteMultipartReadSetUpload
func (c *Omics) CompleteMultipartReadSetUpload(input *CompleteMultipartReadSetUploadInput) (*CompleteMultipartReadSetUploadOutput, error) {
	req, out := c.CompleteMultipartReadSetUploadRequest(input)
	return out, req.Send()
}

// CompleteMultipartReadSetUploadWithContext is the same as CompleteMultipartReadSetUpload with the addition of
// the ability to pass a context and additional request options.
//
// See CompleteMultipartReadSetUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) CompleteMultipartReadSetUploadWithContext(ctx aws.Context, input *CompleteMultipartReadSetUploadInput, opts ...request.Option) (*CompleteMultipartReadSetUploadOutput, error) {
	req, out := c.CompleteMultipartReadSetUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAnnotationStore = "CreateAnnotationStore"

// CreateAnnotationStoreRequest generates a "aws/request.Request" representing the
// client's request for the CreateAnnotationStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAnnotationStore for more information on using the CreateAnnotationStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAnnotationStoreRequest method.
//	req, resp := client.CreateAnnotationStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateAnnotationStore
func (c *Omics) CreateAnnotationStoreRequest(input *CreateAnnotationStoreInput) (req *request.Request, output *CreateAnnotationStoreOutput) {
	op := &request.Operation{
		Name:       opCreateAnnotationStore,
		HTTPMethod: "POST",
		HTTPPath:   "/annotationStore",
	}

	if input == nil {
		input = &CreateAnnotationStoreInput{}
	}

	output = &CreateAnnotationStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateAnnotationStore API operation for Amazon Omics.
//
// Creates an annotation store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation CreateAnnotationStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateAnnotationStore
func (c *Omics) CreateAnnotationStore(input *CreateAnnotationStoreInput) (*CreateAnnotationStoreOutput, error) {
	req, out := c.CreateAnnotationStoreRequest(input)
	return out, req.Send()
}

// CreateAnnotationStoreWithContext is the same as CreateAnnotationStore with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAnnotationStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) CreateAnnotationStoreWithContext(ctx aws.Context, input *CreateAnnotationStoreInput, opts ...request.Option) (*CreateAnnotationStoreOutput, error) {
	req, out := c.CreateAnnotationStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAnnotationStoreVersion = "CreateAnnotationStoreVersion"

// CreateAnnotationStoreVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateAnnotationStoreVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAnnotationStoreVersion for more information on using the CreateAnnotationStoreVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAnnotationStoreVersionRequest method.
//	req, resp := client.CreateAnnotationStoreVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateAnnotationStoreVersion
func (c *Omics) CreateAnnotationStoreVersionRequest(input *CreateAnnotationStoreVersionInput) (req *request.Request, output *CreateAnnotationStoreVersionOutput) {
	op := &request.Operation{
		Name:       opCreateAnnotationStoreVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/annotationStore/{name}/version",
	}

	if input == nil {
		input = &CreateAnnotationStoreVersionInput{}
	}

	output = &CreateAnnotationStoreVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateAnnotationStoreVersion API operation for Amazon Omics.
//
// Creates a new version of an annotation store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation CreateAnnotationStoreVersion for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateAnnotationStoreVersion
func (c *Omics) CreateAnnotationStoreVersion(input *CreateAnnotationStoreVersionInput) (*CreateAnnotationStoreVersionOutput, error) {
	req, out := c.CreateAnnotationStoreVersionRequest(input)
	return out, req.Send()
}

// CreateAnnotationStoreVersionWithContext is the same as CreateAnnotationStoreVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAnnotationStoreVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) CreateAnnotationStoreVersionWithContext(ctx aws.Context, input *CreateAnnotationStoreVersionInput, opts ...request.Option) (*CreateAnnotationStoreVersionOutput, error) {
	req, out := c.CreateAnnotationStoreVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMultipartReadSetUpload = "CreateMultipartReadSetUpload"

// CreateMultipartReadSetUploadRequest generates a "aws/request.Request" representing the
// client's request for the CreateMultipartReadSetUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMultipartReadSetUpload for more information on using the CreateMultipartReadSetUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMultipartReadSetUploadRequest method.
//	req, resp := client.CreateMultipartReadSetUploadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateMultipartReadSetUpload
func (c *Omics) CreateMultipartReadSetUploadRequest(input *CreateMultipartReadSetUploadInput) (req *request.Request, output *CreateMultipartReadSetUploadOutput) {
	op := &request.Operation{
		Name:       opCreateMultipartReadSetUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/upload",
	}

	if input == nil {
		input = &CreateMultipartReadSetUploadInput{}
	}

	output = &CreateMultipartReadSetUploadOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateMultipartReadSetUpload API operation for Amazon Omics.
//
// Begins a multipart read set upload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation CreateMultipartReadSetUpload for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - NotSupportedOperationException
//     The operation is not supported by Amazon Omics, or the API does not exist.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateMultipartReadSetUpload
func (c *Omics) CreateMultipartReadSetUpload(input *CreateMultipartReadSetUploadInput) (*CreateMultipartReadSetUploadOutput, error) {
	req, out := c.CreateMultipartReadSetUploadRequest(input)
	return out, req.Send()
}

// CreateMultipartReadSetUploadWithContext is the same as CreateMultipartReadSetUpload with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMultipartReadSetUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) CreateMultipartReadSetUploadWithContext(ctx aws.Context, input *CreateMultipartReadSetUploadInput, opts ...request.Option) (*CreateMultipartReadSetUploadOutput, error) {
	req, out := c.CreateMultipartReadSetUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReferenceStore = "CreateReferenceStore"

// CreateReferenceStoreRequest generates a "aws/request.Request" representing the
// client's request for the CreateReferenceStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReferenceStore for more information on using the CreateReferenceStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateReferenceStoreRequest method.
//	req, resp := client.CreateReferenceStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateReferenceStore
func (c *Omics) CreateReferenceStoreRequest(input *CreateReferenceStoreInput) (req *request.Request, output *CreateReferenceStoreOutput) {
	op := &request.Operation{
		Name:       opCreateReferenceStore,
		HTTPMethod: "POST",
		HTTPPath:   "/referencestore",
	}

	if input == nil {
		input = &CreateReferenceStoreInput{}
	}

	output = &CreateReferenceStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateReferenceStore API operation for Amazon Omics.
//
// Creates a reference store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation CreateReferenceStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateReferenceStore
func (c *Omics) CreateReferenceStore(input *CreateReferenceStoreInput) (*CreateReferenceStoreOutput, error) {
	req, out := c.CreateReferenceStoreRequest(input)
	return out, req.Send()
}

// CreateReferenceStoreWithContext is the same as CreateReferenceStore with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReferenceStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) CreateReferenceStoreWithContext(ctx aws.Context, input *CreateReferenceStoreInput, opts ...request.Option) (*CreateReferenceStoreOutput, error) {
	req, out := c.CreateReferenceStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRunGroup = "CreateRunGroup"

// CreateRunGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateRunGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRunGroup for more information on using the CreateRunGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRunGroupRequest method.
//	req, resp := client.CreateRunGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateRunGroup
func (c *Omics) CreateRunGroupRequest(input *CreateRunGroupInput) (req *request.Request, output *CreateRunGroupOutput) {
	op := &request.Operation{
		Name:       opCreateRunGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/runGroup",
	}

	if input == nil {
		input = &CreateRunGroupInput{}
	}

	output = &CreateRunGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("workflows-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateRunGroup API operation for Amazon Omics.
//
// Creates a run group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation CreateRunGroup for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateRunGroup
func (c *Omics) CreateRunGroup(input *CreateRunGroupInput) (*CreateRunGroupOutput, error) {
	req, out := c.CreateRunGroupRequest(input)
	return out, req.Send()
}

// CreateRunGroupWithContext is the same as CreateRunGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRunGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) CreateRunGroupWithContext(ctx aws.Context, input *CreateRunGroupInput, opts ...request.Option) (*CreateRunGroupOutput, error) {
	req, out := c.CreateRunGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSequenceStore = "CreateSequenceStore"

// CreateSequenceStoreRequest generates a "aws/request.Request" representing the
// client's request for the CreateSequenceStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSequenceStore for more information on using the CreateSequenceStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSequenceStoreRequest method.
//	req, resp := client.CreateSequenceStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateSequenceStore
func (c *Omics) CreateSequenceStoreRequest(input *CreateSequenceStoreInput) (req *request.Request, output *CreateSequenceStoreOutput) {
	op := &request.Operation{
		Name:       opCreateSequenceStore,
		HTTPMethod: "POST",
		HTTPPath:   "/sequencestore",
	}

	if input == nil {
		input = &CreateSequenceStoreInput{}
	}

	output = &CreateSequenceStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateSequenceStore API operation for Amazon Omics.
//
// Creates a sequence store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation CreateSequenceStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateSequenceStore
func (c *Omics) CreateSequenceStore(input *CreateSequenceStoreInput) (*CreateSequenceStoreOutput, error) {
	req, out := c.CreateSequenceStoreRequest(input)
	return out, req.Send()
}

// CreateSequenceStoreWithContext is the same as CreateSequenceStore with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSequenceStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) CreateSequenceStoreWithContext(ctx aws.Context, input *CreateSequenceStoreInput, opts ...request.Option) (*CreateSequenceStoreOutput, error) {
	req, out := c.CreateSequenceStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateShare = "CreateShare"

// CreateShareRequest generates a "aws/request.Request" representing the
// client's request for the CreateShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateShare for more information on using the CreateShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateShareRequest method.
//	req, resp := client.CreateShareRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateShare
func (c *Omics) CreateShareRequest(input *CreateShareInput) (req *request.Request, output *CreateShareOutput) {
	op := &request.Operation{
		Name:       opCreateShare,
		HTTPMethod: "POST",
		HTTPPath:   "/share",
	}

	if input == nil {
		input = &CreateShareInput{}
	}

	output = &CreateShareOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateShare API operation for Amazon Omics.
//
// Creates a share offer that can be accepted outside the account by a subscriber.
// The share is created by the owner and accepted by the principal subscriber.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation CreateShare for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateShare
func (c *Omics) CreateShare(input *CreateShareInput) (*CreateShareOutput, error) {
	req, out := c.CreateShareRequest(input)
	return out, req.Send()
}

// CreateShareWithContext is the same as CreateShare with the addition of
// the ability to pass a context and additional request options.
//
// See CreateShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) CreateShareWithContext(ctx aws.Context, input *CreateShareInput, opts ...request.Option) (*CreateShareOutput, error) {
	req, out := c.CreateShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVariantStore = "CreateVariantStore"

// CreateVariantStoreRequest generates a "aws/request.Request" representing the
// client's request for the CreateVariantStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVariantStore for more information on using the CreateVariantStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVariantStoreRequest method.
//	req, resp := client.CreateVariantStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateVariantStore
func (c *Omics) CreateVariantStoreRequest(input *CreateVariantStoreInput) (req *request.Request, output *CreateVariantStoreOutput) {
	op := &request.Operation{
		Name:       opCreateVariantStore,
		HTTPMethod: "POST",
		HTTPPath:   "/variantStore",
	}

	if input == nil {
		input = &CreateVariantStoreInput{}
	}

	output = &CreateVariantStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateVariantStore API operation for Amazon Omics.
//
// Creates a variant store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation CreateVariantStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateVariantStore
func (c *Omics) CreateVariantStore(input *CreateVariantStoreInput) (*CreateVariantStoreOutput, error) {
	req, out := c.CreateVariantStoreRequest(input)
	return out, req.Send()
}

// CreateVariantStoreWithContext is the same as CreateVariantStore with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVariantStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) CreateVariantStoreWithContext(ctx aws.Context, input *CreateVariantStoreInput, opts ...request.Option) (*CreateVariantStoreOutput, error) {
	req, out := c.CreateVariantStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkflow = "CreateWorkflow"

// CreateWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkflow for more information on using the CreateWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWorkflowRequest method.
//	req, resp := client.CreateWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateWorkflow
func (c *Omics) CreateWorkflowRequest(input *CreateWorkflowInput) (req *request.Request, output *CreateWorkflowOutput) {
	op := &request.Operation{
		Name:       opCreateWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/workflow",
	}

	if input == nil {
		input = &CreateWorkflowInput{}
	}

	output = &CreateWorkflowOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("workflows-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateWorkflow API operation for Amazon Omics.
//
// Creates a workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation CreateWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateWorkflow
func (c *Omics) CreateWorkflow(input *CreateWorkflowInput) (*CreateWorkflowOutput, error) {
	req, out := c.CreateWorkflowRequest(input)
	return out, req.Send()
}

// CreateWorkflowWithContext is the same as CreateWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) CreateWorkflowWithContext(ctx aws.Context, input *CreateWorkflowInput, opts ...request.Option) (*CreateWorkflowOutput, error) {
	req, out := c.CreateWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAnnotationStore = "DeleteAnnotationStore"

// DeleteAnnotationStoreRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAnnotationStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAnnotationStore for more information on using the DeleteAnnotationStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAnnotationStoreRequest method.
//	req, resp := client.DeleteAnnotationStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteAnnotationStore
func (c *Omics) DeleteAnnotationStoreRequest(input *DeleteAnnotationStoreInput) (req *request.Request, output *DeleteAnnotationStoreOutput) {
	op := &request.Operation{
		Name:       opDeleteAnnotationStore,
		HTTPMethod: "DELETE",
		HTTPPath:   "/annotationStore/{name}",
	}

	if input == nil {
		input = &DeleteAnnotationStoreInput{}
	}

	output = &DeleteAnnotationStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAnnotationStore API operation for Amazon Omics.
//
// Deletes an annotation store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation DeleteAnnotationStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteAnnotationStore
func (c *Omics) DeleteAnnotationStore(input *DeleteAnnotationStoreInput) (*DeleteAnnotationStoreOutput, error) {
	req, out := c.DeleteAnnotationStoreRequest(input)
	return out, req.Send()
}

// DeleteAnnotationStoreWithContext is the same as DeleteAnnotationStore with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAnnotationStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) DeleteAnnotationStoreWithContext(ctx aws.Context, input *DeleteAnnotationStoreInput, opts ...request.Option) (*DeleteAnnotationStoreOutput, error) {
	req, out := c.DeleteAnnotationStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAnnotationStoreVersions = "DeleteAnnotationStoreVersions"

// DeleteAnnotationStoreVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAnnotationStoreVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAnnotationStoreVersions for more information on using the DeleteAnnotationStoreVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAnnotationStoreVersionsRequest method.
//	req, resp := client.DeleteAnnotationStoreVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteAnnotationStoreVersions
func (c *Omics) DeleteAnnotationStoreVersionsRequest(input *DeleteAnnotationStoreVersionsInput) (req *request.Request, output *DeleteAnnotationStoreVersionsOutput) {
	op := &request.Operation{
		Name:       opDeleteAnnotationStoreVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/annotationStore/{name}/versions/delete",
	}

	if input == nil {
		input = &DeleteAnnotationStoreVersionsInput{}
	}

	output = &DeleteAnnotationStoreVersionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAnnotationStoreVersions API operation for Amazon Omics.
//
// Deletes one or multiple versions of an annotation store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation DeleteAnnotationStoreVersions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteAnnotationStoreVersions
func (c *Omics) DeleteAnnotationStoreVersions(input *DeleteAnnotationStoreVersionsInput) (*DeleteAnnotationStoreVersionsOutput, error) {
	req, out := c.DeleteAnnotationStoreVersionsRequest(input)
	return out, req.Send()
}

// DeleteAnnotationStoreVersionsWithContext is the same as DeleteAnnotationStoreVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAnnotationStoreVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) DeleteAnnotationStoreVersionsWithContext(ctx aws.Context, input *DeleteAnnotationStoreVersionsInput, opts ...request.Option) (*DeleteAnnotationStoreVersionsOutput, error) {
	req, out := c.DeleteAnnotationStoreVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReference = "DeleteReference"

// DeleteReferenceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReference operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReference for more information on using the DeleteReference
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteReferenceRequest method.
//	req, resp := client.DeleteReferenceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteReference
func (c *Omics) DeleteReferenceRequest(input *DeleteReferenceInput) (req *request.Request, output *DeleteReferenceOutput) {
	op := &request.Operation{
		Name:       opDeleteReference,
		HTTPMethod: "DELETE",
		HTTPPath:   "/referencestore/{referenceStoreId}/reference/{id}",
	}

	if input == nil {
		input = &DeleteReferenceInput{}
	}

	output = &DeleteReferenceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteReference API operation for Amazon Omics.
//
// Deletes a genome reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation DeleteReference for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteReference
func (c *Omics) DeleteReference(input *DeleteReferenceInput) (*DeleteReferenceOutput, error) {
	req, out := c.DeleteReferenceRequest(input)
	return out, req.Send()
}

// DeleteReferenceWithContext is the same as DeleteReference with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReference for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) DeleteReferenceWithContext(ctx aws.Context, input *DeleteReferenceInput, opts ...request.Option) (*DeleteReferenceOutput, error) {
	req, out := c.DeleteReferenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReferenceStore = "DeleteReferenceStore"

// DeleteReferenceStoreRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReferenceStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReferenceStore for more information on using the DeleteReferenceStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteReferenceStoreRequest method.
//	req, resp := client.DeleteReferenceStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteReferenceStore
func (c *Omics) DeleteReferenceStoreRequest(input *DeleteReferenceStoreInput) (req *request.Request, output *DeleteReferenceStoreOutput) {
	op := &request.Operation{
		Name:       opDeleteReferenceStore,
		HTTPMethod: "DELETE",
		HTTPPath:   "/referencestore/{id}",
	}

	if input == nil {
		input = &DeleteReferenceStoreInput{}
	}

	output = &DeleteReferenceStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteReferenceStore API operation for Amazon Omics.
//
// Deletes a genome reference store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation DeleteReferenceStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteReferenceStore
func (c *Omics) DeleteReferenceStore(input *DeleteReferenceStoreInput) (*DeleteReferenceStoreOutput, error) {
	req, out := c.DeleteReferenceStoreRequest(input)
	return out, req.Send()
}

// DeleteReferenceStoreWithContext is the same as DeleteReferenceStore with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReferenceStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) DeleteReferenceStoreWithContext(ctx aws.Context, input *DeleteReferenceStoreInput, opts ...request.Option) (*DeleteReferenceStoreOutput, error) {
	req, out := c.DeleteReferenceStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRun = "DeleteRun"

// DeleteRunRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRun for more information on using the DeleteRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRunRequest method.
//	req, resp := client.DeleteRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRun
func (c *Omics) DeleteRunRequest(input *DeleteRunInput) (req *request.Request, output *DeleteRunOutput) {
	op := &request.Operation{
		Name:       opDeleteRun,
		HTTPMethod: "DELETE",
		HTTPPath:   "/run/{id}",
	}

	if input == nil {
		input = &DeleteRunInput{}
	}

	output = &DeleteRunOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("workflows-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteRun API operation for Amazon Omics.
//
// Deletes a workflow run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation DeleteRun for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRun
func (c *Omics) DeleteRun(input *DeleteRunInput) (*DeleteRunOutput, error) {
	req, out := c.DeleteRunRequest(input)
	return out, req.Send()
}

// DeleteRunWithContext is the same as DeleteRun with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) DeleteRunWithContext(ctx aws.Context, input *DeleteRunInput, opts ...request.Option) (*DeleteRunOutput, error) {
	req, out := c.DeleteRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRunGroup = "DeleteRunGroup"

// DeleteRunGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRunGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRunGroup for more information on using the DeleteRunGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRunGroupRequest method.
//	req, resp := client.DeleteRunGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRunGroup
func (c *Omics) DeleteRunGroupRequest(input *DeleteRunGroupInput) (req *request.Request, output *DeleteRunGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteRunGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/runGroup/{id}",
	}

	if input == nil {
		input = &DeleteRunGroupInput{}
	}

	output = &DeleteRunGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("workflows-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteRunGroup API operation for Amazon Omics.
//
// Deletes a workflow run group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation DeleteRunGroup for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRunGroup
func (c *Omics) DeleteRunGroup(input *DeleteRunGroupInput) (*DeleteRunGroupOutput, error) {
	req, out := c.DeleteRunGroupRequest(input)
	return out, req.Send()
}

// DeleteRunGroupWithContext is the same as DeleteRunGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRunGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) DeleteRunGroupWithContext(ctx aws.Context, input *DeleteRunGroupInput, opts ...request.Option) (*DeleteRunGroupOutput, error) {
	req, out := c.DeleteRunGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSequenceStore = "DeleteSequenceStore"

// DeleteSequenceStoreRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSequenceStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSequenceStore for more information on using the DeleteSequenceStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSequenceStoreRequest method.
//	req, resp := client.DeleteSequenceStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteSequenceStore
func (c *Omics) DeleteSequenceStoreRequest(input *DeleteSequenceStoreInput) (req *request.Request, output *DeleteSequenceStoreOutput) {
	op := &request.Operation{
		Name:       opDeleteSequenceStore,
		HTTPMethod: "DELETE",
		HTTPPath:   "/sequencestore/{id}",
	}

	if input == nil {
		input = &DeleteSequenceStoreInput{}
	}

	output = &DeleteSequenceStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteSequenceStore API operation for Amazon Omics.
//
// Deletes a sequence store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation DeleteSequenceStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteSequenceStore
func (c *Omics) DeleteSequenceStore(input *DeleteSequenceStoreInput) (*DeleteSequenceStoreOutput, error) {
	req, out := c.DeleteSequenceStoreRequest(input)
	return out, req.Send()
}

// DeleteSequenceStoreWithContext is the same as DeleteSequenceStore with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSequenceStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) DeleteSequenceStoreWithContext(ctx aws.Context, input *DeleteSequenceStoreInput, opts ...request.Option) (*DeleteSequenceStoreOutput, error) {
	req, out := c.DeleteSequenceStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteShare = "DeleteShare"

// DeleteShareRequest generates a "aws/request.Request" representing the
// client's request for the DeleteShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteShare for more information on using the DeleteShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteShareRequest method.
//	req, resp := client.DeleteShareRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteShare
func (c *Omics) DeleteShareRequest(input *DeleteShareInput) (req *request.Request, output *DeleteShareOutput) {
	op := &request.Operation{
		Name:       opDeleteShare,
		HTTPMethod: "DELETE",
		HTTPPath:   "/share/{shareId}",
	}

	if input == nil {
		input = &DeleteShareInput{}
	}

	output = &DeleteShareOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteShare API operation for Amazon Omics.
//
// Deletes a share of an analytics store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation DeleteShare for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteShare
func (c *Omics) DeleteShare(input *DeleteShareInput) (*DeleteShareOutput, error) {
	req, out := c.DeleteShareRequest(input)
	return out, req.Send()
}

// DeleteShareWithContext is the same as DeleteShare with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) DeleteShareWithContext(ctx aws.Context, input *DeleteShareInput, opts ...request.Option) (*DeleteShareOutput, error) {
	req, out := c.DeleteShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVariantStore = "DeleteVariantStore"

// DeleteVariantStoreRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVariantStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVariantStore for more information on using the DeleteVariantStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVariantStoreRequest method.
//	req, resp := client.DeleteVariantStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteVariantStore
func (c *Omics) DeleteVariantStoreRequest(input *DeleteVariantStoreInput) (req *request.Request, output *DeleteVariantStoreOutput) {
	op := &request.Operation{
		Name:       opDeleteVariantStore,
		HTTPMethod: "DELETE",
		HTTPPath:   "/variantStore/{name}",
	}

	if input == nil {
		input = &DeleteVariantStoreInput{}
	}

	output = &DeleteVariantStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteVariantStore API operation for Amazon Omics.
//
// Deletes a variant store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation DeleteVariantStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteVariantStore
func (c *Omics) DeleteVariantStore(input *DeleteVariantStoreInput) (*DeleteVariantStoreOutput, error) {
	req, out := c.DeleteVariantStoreRequest(input)
	return out, req.Send()
}

// DeleteVariantStoreWithContext is the same as DeleteVariantStore with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVariantStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) DeleteVariantStoreWithContext(ctx aws.Context, input *DeleteVariantStoreInput, opts ...request.Option) (*DeleteVariantStoreOutput, error) {
	req, out := c.DeleteVariantStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkflow = "DeleteWorkflow"

// DeleteWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkflow for more information on using the DeleteWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWorkflowRequest method.
//	req, resp := client.DeleteWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteWorkflow
func (c *Omics) DeleteWorkflowRequest(input *DeleteWorkflowInput) (req *request.Request, output *DeleteWorkflowOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkflow,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workflow/{id}",
	}

	if input == nil {
		input = &DeleteWorkflowInput{}
	}

	output = &DeleteWorkflowOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("workflows-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteWorkflow API operation for Amazon Omics.
//
// Deletes a workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation DeleteWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteWorkflow
func (c *Omics) DeleteWorkflow(input *DeleteWorkflowInput) (*DeleteWorkflowOutput, error) {
	req, out := c.DeleteWorkflowRequest(input)
	return out, req.Send()
}

// DeleteWorkflowWithContext is the same as DeleteWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) DeleteWorkflowWithContext(ctx aws.Context, input *DeleteWorkflowInput, opts ...request.Option) (*DeleteWorkflowOutput, error) {
	req, out := c.DeleteWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAnnotationImportJob = "GetAnnotationImportJob"

// GetAnnotationImportJobRequest generates a "aws/request.Request" representing the
// client's request for the GetAnnotationImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAnnotationImportJob for more information on using the GetAnnotationImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAnnotationImportJobRequest method.
//	req, resp := client.GetAnnotationImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationImportJob
func (c *Omics) GetAnnotationImportJobRequest(input *GetAnnotationImportJobInput) (req *request.Request, output *GetAnnotationImportJobOutput) {
	op := &request.Operation{
		Name:       opGetAnnotationImportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/import/annotation/{jobId}",
	}

	if input == nil {
		input = &GetAnnotationImportJobInput{}
	}

	output = &GetAnnotationImportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAnnotationImportJob API operation for Amazon Omics.
//
// Gets information about an annotation import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetAnnotationImportJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationImportJob
func (c *Omics) GetAnnotationImportJob(input *GetAnnotationImportJobInput) (*GetAnnotationImportJobOutput, error) {
	req, out := c.GetAnnotationImportJobRequest(input)
	return out, req.Send()
}

// GetAnnotationImportJobWithContext is the same as GetAnnotationImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetAnnotationImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetAnnotationImportJobWithContext(ctx aws.Context, input *GetAnnotationImportJobInput, opts ...request.Option) (*GetAnnotationImportJobOutput, error) {
	req, out := c.GetAnnotationImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAnnotationStore = "GetAnnotationStore"

// GetAnnotationStoreRequest generates a "aws/request.Request" representing the
// client's request for the GetAnnotationStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAnnotationStore for more information on using the GetAnnotationStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAnnotationStoreRequest method.
//	req, resp := client.GetAnnotationStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationStore
func (c *Omics) GetAnnotationStoreRequest(input *GetAnnotationStoreInput) (req *request.Request, output *GetAnnotationStoreOutput) {
	op := &request.Operation{
		Name:       opGetAnnotationStore,
		HTTPMethod: "GET",
		HTTPPath:   "/annotationStore/{name}",
	}

	if input == nil {
		input = &GetAnnotationStoreInput{}
	}

	output = &GetAnnotationStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAnnotationStore API operation for Amazon Omics.
//
// Gets information about an annotation store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetAnnotationStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationStore
func (c *Omics) GetAnnotationStore(input *GetAnnotationStoreInput) (*GetAnnotationStoreOutput, error) {
	req, out := c.GetAnnotationStoreRequest(input)
	return out, req.Send()
}

// GetAnnotationStoreWithContext is the same as GetAnnotationStore with the addition of
// the ability to pass a context and additional request options.
//
// See GetAnnotationStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetAnnotationStoreWithContext(ctx aws.Context, input *GetAnnotationStoreInput, opts ...request.Option) (*GetAnnotationStoreOutput, error) {
	req, out := c.GetAnnotationStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAnnotationStoreVersion = "GetAnnotationStoreVersion"

// GetAnnotationStoreVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetAnnotationStoreVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAnnotationStoreVersion for more information on using the GetAnnotationStoreVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAnnotationStoreVersionRequest method.
//	req, resp := client.GetAnnotationStoreVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationStoreVersion
func (c *Omics) GetAnnotationStoreVersionRequest(input *GetAnnotationStoreVersionInput) (req *request.Request, output *GetAnnotationStoreVersionOutput) {
	op := &request.Operation{
		Name:       opGetAnnotationStoreVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/annotationStore/{name}/version/{versionName}",
	}

	if input == nil {
		input = &GetAnnotationStoreVersionInput{}
	}

	output = &GetAnnotationStoreVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAnnotationStoreVersion API operation for Amazon Omics.
//
// Retrieves the metadata for an annotation store version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetAnnotationStoreVersion for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationStoreVersion
func (c *Omics) GetAnnotationStoreVersion(input *GetAnnotationStoreVersionInput) (*GetAnnotationStoreVersionOutput, error) {
	req, out := c.GetAnnotationStoreVersionRequest(input)
	return out, req.Send()
}

// GetAnnotationStoreVersionWithContext is the same as GetAnnotationStoreVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetAnnotationStoreVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetAnnotationStoreVersionWithContext(ctx aws.Context, input *GetAnnotationStoreVersionInput, opts ...request.Option) (*GetAnnotationStoreVersionOutput, error) {
	req, out := c.GetAnnotationStoreVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReadSet = "GetReadSet"

// GetReadSetRequest generates a "aws/request.Request" representing the
// client's request for the GetReadSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReadSet for more information on using the GetReadSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReadSetRequest method.
//	req, resp := client.GetReadSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSet
func (c *Omics) GetReadSetRequest(input *GetReadSetInput) (req *request.Request, output *GetReadSetOutput) {
	op := &request.Operation{
		Name:       opGetReadSet,
		HTTPMethod: "GET",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/readset/{id}",
	}

	if input == nil {
		input = &GetReadSetInput{}
	}

	output = &GetReadSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetReadSet API operation for Amazon Omics.
//
// Gets a file from a read set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetReadSet for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - RangeNotSatisfiableException
//     The ranges specified in the request are not valid.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSet
func (c *Omics) GetReadSet(input *GetReadSetInput) (*GetReadSetOutput, error) {
	req, out := c.GetReadSetRequest(input)
	return out, req.Send()
}

// GetReadSetWithContext is the same as GetReadSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetReadSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetReadSetWithContext(ctx aws.Context, input *GetReadSetInput, opts ...request.Option) (*GetReadSetOutput, error) {
	req, out := c.GetReadSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReadSetActivationJob = "GetReadSetActivationJob"

// GetReadSetActivationJobRequest generates a "aws/request.Request" representing the
// client's request for the GetReadSetActivationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReadSetActivationJob for more information on using the GetReadSetActivationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReadSetActivationJobRequest method.
//	req, resp := client.GetReadSetActivationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetActivationJob
func (c *Omics) GetReadSetActivationJobRequest(input *GetReadSetActivationJobInput) (req *request.Request, output *GetReadSetActivationJobOutput) {
	op := &request.Operation{
		Name:       opGetReadSetActivationJob,
		HTTPMethod: "GET",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/activationjob/{id}",
	}

	if input == nil {
		input = &GetReadSetActivationJobInput{}
	}

	output = &GetReadSetActivationJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetReadSetActivationJob API operation for Amazon Omics.
//
// Gets information about a read set activation job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetReadSetActivationJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetActivationJob
func (c *Omics) GetReadSetActivationJob(input *GetReadSetActivationJobInput) (*GetReadSetActivationJobOutput, error) {
	req, out := c.GetReadSetActivationJobRequest(input)
	return out, req.Send()
}

// GetReadSetActivationJobWithContext is the same as GetReadSetActivationJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetReadSetActivationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetReadSetActivationJobWithContext(ctx aws.Context, input *GetReadSetActivationJobInput, opts ...request.Option) (*GetReadSetActivationJobOutput, error) {
	req, out := c.GetReadSetActivationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReadSetExportJob = "GetReadSetExportJob"

// GetReadSetExportJobRequest generates a "aws/request.Request" representing the
// client's request for the GetReadSetExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReadSetExportJob for more information on using the GetReadSetExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReadSetExportJobRequest method.
//	req, resp := client.GetReadSetExportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetExportJob
func (c *Omics) GetReadSetExportJobRequest(input *GetReadSetExportJobInput) (req *request.Request, output *GetReadSetExportJobOutput) {
	op := &request.Operation{
		Name:       opGetReadSetExportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/exportjob/{id}",
	}

	if input == nil {
		input = &GetReadSetExportJobInput{}
	}

	output = &GetReadSetExportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetReadSetExportJob API operation for Amazon Omics.
//
// Gets information about a read set export job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetReadSetExportJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetExportJob
func (c *Omics) GetReadSetExportJob(input *GetReadSetExportJobInput) (*GetReadSetExportJobOutput, error) {
	req, out := c.GetReadSetExportJobRequest(input)
	return out, req.Send()
}

// GetReadSetExportJobWithContext is the same as GetReadSetExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetReadSetExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetReadSetExportJobWithContext(ctx aws.Context, input *GetReadSetExportJobInput, opts ...request.Option) (*GetReadSetExportJobOutput, error) {
	req, out := c.GetReadSetExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReadSetImportJob = "GetReadSetImportJob"

// GetReadSetImportJobRequest generates a "aws/request.Request" representing the
// client's request for the GetReadSetImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReadSetImportJob for more information on using the GetReadSetImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReadSetImportJobRequest method.
//	req, resp := client.GetReadSetImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetImportJob
func (c *Omics) GetReadSetImportJobRequest(input *GetReadSetImportJobInput) (req *request.Request, output *GetReadSetImportJobOutput) {
	op := &request.Operation{
		Name:       opGetReadSetImportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/importjob/{id}",
	}

	if input == nil {
		input = &GetReadSetImportJobInput{}
	}

	output = &GetReadSetImportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetReadSetImportJob API operation for Amazon Omics.
//
// Gets information about a read set import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetReadSetImportJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetImportJob
func (c *Omics) GetReadSetImportJob(input *GetReadSetImportJobInput) (*GetReadSetImportJobOutput, error) {
	req, out := c.GetReadSetImportJobRequest(input)
	return out, req.Send()
}

// GetReadSetImportJobWithContext is the same as GetReadSetImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetReadSetImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetReadSetImportJobWithContext(ctx aws.Context, input *GetReadSetImportJobInput, opts ...request.Option) (*GetReadSetImportJobOutput, error) {
	req, out := c.GetReadSetImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReadSetMetadata = "GetReadSetMetadata"

// GetReadSetMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetReadSetMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReadSetMetadata for more information on using the GetReadSetMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReadSetMetadataRequest method.
//	req, resp := client.GetReadSetMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetMetadata
func (c *Omics) GetReadSetMetadataRequest(input *GetReadSetMetadataInput) (req *request.Request, output *GetReadSetMetadataOutput) {
	op := &request.Operation{
		Name:       opGetReadSetMetadata,
		HTTPMethod: "GET",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/readset/{id}/metadata",
	}

	if input == nil {
		input = &GetReadSetMetadataInput{}
	}

	output = &GetReadSetMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetReadSetMetadata API operation for Amazon Omics.
//
// Gets details about a read set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetReadSetMetadata for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetMetadata
func (c *Omics) GetReadSetMetadata(input *GetReadSetMetadataInput) (*GetReadSetMetadataOutput, error) {
	req, out := c.GetReadSetMetadataRequest(input)
	return out, req.Send()
}

// GetReadSetMetadataWithContext is the same as GetReadSetMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetReadSetMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetReadSetMetadataWithContext(ctx aws.Context, input *GetReadSetMetadataInput, opts ...request.Option) (*GetReadSetMetadataOutput, error) {
	req, out := c.GetReadSetMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReference = "GetReference"

// GetReferenceRequest generates a "aws/request.Request" representing the
// client's request for the GetReference operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReference for more information on using the GetReference
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReferenceRequest method.
//	req, resp := client.GetReferenceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReference
func (c *Omics) GetReferenceRequest(input *GetReferenceInput) (req *request.Request, output *GetReferenceOutput) {
	op := &request.Operation{
		Name:       opGetReference,
		HTTPMethod: "GET",
		HTTPPath:   "/referencestore/{referenceStoreId}/reference/{id}",
	}

	if input == nil {
		input = &GetReferenceInput{}
	}

	output = &GetReferenceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetReference API operation for Amazon Omics.
//
// Gets a reference file.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetReference for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - RangeNotSatisfiableException
//     The ranges specified in the request are not valid.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReference
func (c *Omics) GetReference(input *GetReferenceInput) (*GetReferenceOutput, error) {
	req, out := c.GetReferenceRequest(input)
	return out, req.Send()
}

// GetReferenceWithContext is the same as GetReference with the addition of
// the ability to pass a context and additional request options.
//
// See GetReference for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetReferenceWithContext(ctx aws.Context, input *GetReferenceInput, opts ...request.Option) (*GetReferenceOutput, error) {
	req, out := c.GetReferenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReferenceImportJob = "GetReferenceImportJob"

// GetReferenceImportJobRequest generates a "aws/request.Request" representing the
// client's request for the GetReferenceImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReferenceImportJob for more information on using the GetReferenceImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReferenceImportJobRequest method.
//	req, resp := client.GetReferenceImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceImportJob
func (c *Omics) GetReferenceImportJobRequest(input *GetReferenceImportJobInput) (req *request.Request, output *GetReferenceImportJobOutput) {
	op := &request.Operation{
		Name:       opGetReferenceImportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/referencestore/{referenceStoreId}/importjob/{id}",
	}

	if input == nil {
		input = &GetReferenceImportJobInput{}
	}

	output = &GetReferenceImportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetReferenceImportJob API operation for Amazon Omics.
//
// Gets information about a reference import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetReferenceImportJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceImportJob
func (c *Omics) GetReferenceImportJob(input *GetReferenceImportJobInput) (*GetReferenceImportJobOutput, error) {
	req, out := c.GetReferenceImportJobRequest(input)
	return out, req.Send()
}

// GetReferenceImportJobWithContext is the same as GetReferenceImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetReferenceImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetReferenceImportJobWithContext(ctx aws.Context, input *GetReferenceImportJobInput, opts ...request.Option) (*GetReferenceImportJobOutput, error) {
	req, out := c.GetReferenceImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReferenceMetadata = "GetReferenceMetadata"

// GetReferenceMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetReferenceMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReferenceMetadata for more information on using the GetReferenceMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReferenceMetadataRequest method.
//	req, resp := client.GetReferenceMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceMetadata
func (c *Omics) GetReferenceMetadataRequest(input *GetReferenceMetadataInput) (req *request.Request, output *GetReferenceMetadataOutput) {
	op := &request.Operation{
		Name:       opGetReferenceMetadata,
		HTTPMethod: "GET",
		HTTPPath:   "/referencestore/{referenceStoreId}/reference/{id}/metadata",
	}

	if input == nil {
		input = &GetReferenceMetadataInput{}
	}

	output = &GetReferenceMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetReferenceMetadata API operation for Amazon Omics.
//
// Gets information about a genome reference's metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetReferenceMetadata for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceMetadata
func (c *Omics) GetReferenceMetadata(input *GetReferenceMetadataInput) (*GetReferenceMetadataOutput, error) {
	req, out := c.GetReferenceMetadataRequest(input)
	return out, req.Send()
}

// GetReferenceMetadataWithContext is the same as GetReferenceMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetReferenceMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetReferenceMetadataWithContext(ctx aws.Context, input *GetReferenceMetadataInput, opts ...request.Option) (*GetReferenceMetadataOutput, error) {
	req, out := c.GetReferenceMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReferenceStore = "GetReferenceStore"

// GetReferenceStoreRequest generates a "aws/request.Request" representing the
// client's request for the GetReferenceStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReferenceStore for more information on using the GetReferenceStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReferenceStoreRequest method.
//	req, resp := client.GetReferenceStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceStore
func (c *Omics) GetReferenceStoreRequest(input *GetReferenceStoreInput) (req *request.Request, output *GetReferenceStoreOutput) {
	op := &request.Operation{
		Name:       opGetReferenceStore,
		HTTPMethod: "GET",
		HTTPPath:   "/referencestore/{id}",
	}

	if input == nil {
		input = &GetReferenceStoreInput{}
	}

	output = &GetReferenceStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetReferenceStore API operation for Amazon Omics.
//
// Gets information about a reference store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetReferenceStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceStore
func (c *Omics) GetReferenceStore(input *GetReferenceStoreInput) (*GetReferenceStoreOutput, error) {
	req, out := c.GetReferenceStoreRequest(input)
	return out, req.Send()
}

// GetReferenceStoreWithContext is the same as GetReferenceStore with the addition of
// the ability to pass a context and additional request options.
//
// See GetReferenceStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetReferenceStoreWithContext(ctx aws.Context, input *GetReferenceStoreInput, opts ...request.Option) (*GetReferenceStoreOutput, error) {
	req, out := c.GetReferenceStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRun = "GetRun"

// GetRunRequest generates a "aws/request.Request" representing the
// client's request for the GetRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRun for more information on using the GetRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRunRequest method.
//	req, resp := client.GetRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRun
func (c *Omics) GetRunRequest(input *GetRunInput) (req *request.Request, output *GetRunOutput) {
	op := &request.Operation{
		Name:       opGetRun,
		HTTPMethod: "GET",
		HTTPPath:   "/run/{id}",
	}

	if input == nil {
		input = &GetRunInput{}
	}

	output = &GetRunOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("workflows-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetRun API operation for Amazon Omics.
//
// Gets information about a workflow run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetRun for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRun
func (c *Omics) GetRun(input *GetRunInput) (*GetRunOutput, error) {
	req, out := c.GetRunRequest(input)
	return out, req.Send()
}

// GetRunWithContext is the same as GetRun with the addition of
// the ability to pass a context and additional request options.
//
// See GetRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetRunWithContext(ctx aws.Context, input *GetRunInput, opts ...request.Option) (*GetRunOutput, error) {
	req, out := c.GetRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRunGroup = "GetRunGroup"

// GetRunGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetRunGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRunGroup for more information on using the GetRunGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRunGroupRequest method.
//	req, resp := client.GetRunGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunGroup
func (c *Omics) GetRunGroupRequest(input *GetRunGroupInput) (req *request.Request, output *GetRunGroupOutput) {
	op := &request.Operation{
		Name:       opGetRunGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/runGroup/{id}",
	}

	if input == nil {
		input = &GetRunGroupInput{}
	}

	output = &GetRunGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("workflows-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetRunGroup API operation for Amazon Omics.
//
// Gets information about a workflow run group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetRunGroup for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunGroup
func (c *Omics) GetRunGroup(input *GetRunGroupInput) (*GetRunGroupOutput, error) {
	req, out := c.GetRunGroupRequest(input)
	return out, req.Send()
}

// GetRunGroupWithContext is the same as GetRunGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetRunGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetRunGroupWithContext(ctx aws.Context, input *GetRunGroupInput, opts ...request.Option) (*GetRunGroupOutput, error) {
	req, out := c.GetRunGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRunTask = "GetRunTask"

// GetRunTaskRequest generates a "aws/request.Request" representing the
// client's request for the GetRunTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRunTask for more information on using the GetRunTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRunTaskRequest method.
//	req, resp := client.GetRunTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunTask
func (c *Omics) GetRunTaskRequest(input *GetRunTaskInput) (req *request.Request, output *GetRunTaskOutput) {
	op := &request.Operation{
		Name:       opGetRunTask,
		HTTPMethod: "GET",
		HTTPPath:   "/run/{id}/task/{taskId}",
	}

	if input == nil {
		input = &GetRunTaskInput{}
	}

	output = &GetRunTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("workflows-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetRunTask API operation for Amazon Omics.
//
// Gets information about a workflow run task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetRunTask for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunTask
func (c *Omics) GetRunTask(input *GetRunTaskInput) (*GetRunTaskOutput, error) {
	req, out := c.GetRunTaskRequest(input)
	return out, req.Send()
}

// GetRunTaskWithContext is the same as GetRunTask with the addition of
// the ability to pass a context and additional request options.
//
// See GetRunTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetRunTaskWithContext(ctx aws.Context, input *GetRunTaskInput, opts ...request.Option) (*GetRunTaskOutput, error) {
	req, out := c.GetRunTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSequenceStore = "GetSequenceStore"

// GetSequenceStoreRequest generates a "aws/request.Request" representing the
// client's request for the GetSequenceStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSequenceStore for more information on using the GetSequenceStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSequenceStoreRequest method.
//	req, resp := client.GetSequenceStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetSequenceStore
func (c *Omics) GetSequenceStoreRequest(input *GetSequenceStoreInput) (req *request.Request, output *GetSequenceStoreOutput) {
	op := &request.Operation{
		Name:       opGetSequenceStore,
		HTTPMethod: "GET",
		HTTPPath:   "/sequencestore/{id}",
	}

	if input == nil {
		input = &GetSequenceStoreInput{}
	}

	output = &GetSequenceStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetSequenceStore API operation for Amazon Omics.
//
// Gets information about a sequence store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetSequenceStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetSequenceStore
func (c *Omics) GetSequenceStore(input *GetSequenceStoreInput) (*GetSequenceStoreOutput, error) {
	req, out := c.GetSequenceStoreRequest(input)
	return out, req.Send()
}

// GetSequenceStoreWithContext is the same as GetSequenceStore with the addition of
// the ability to pass a context and additional request options.
//
// See GetSequenceStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetSequenceStoreWithContext(ctx aws.Context, input *GetSequenceStoreInput, opts ...request.Option) (*GetSequenceStoreOutput, error) {
	req, out := c.GetSequenceStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetShare = "GetShare"

// GetShareRequest generates a "aws/request.Request" representing the
// client's request for the GetShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetShare for more information on using the GetShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetShareRequest method.
//	req, resp := client.GetShareRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetShare
func (c *Omics) GetShareRequest(input *GetShareInput) (req *request.Request, output *GetShareOutput) {
	op := &request.Operation{
		Name:       opGetShare,
		HTTPMethod: "GET",
		HTTPPath:   "/share/{shareId}",
	}

	if input == nil {
		input = &GetShareInput{}
	}

	output = &GetShareOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetShare API operation for Amazon Omics.
//
// Retrieves the metadata for a share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetShare for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetShare
func (c *Omics) GetShare(input *GetShareInput) (*GetShareOutput, error) {
	req, out := c.GetShareRequest(input)
	return out, req.Send()
}

// GetShareWithContext is the same as GetShare with the addition of
// the ability to pass a context and additional request options.
//
// See GetShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetShareWithContext(ctx aws.Context, input *GetShareInput, opts ...request.Option) (*GetShareOutput, error) {
	req, out := c.GetShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVariantImportJob = "GetVariantImportJob"

// GetVariantImportJobRequest generates a "aws/request.Request" representing the
// client's request for the GetVariantImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVariantImportJob for more information on using the GetVariantImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVariantImportJobRequest method.
//	req, resp := client.GetVariantImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetVariantImportJob
func (c *Omics) GetVariantImportJobRequest(input *GetVariantImportJobInput) (req *request.Request, output *GetVariantImportJobOutput) {
	op := &request.Operation{
		Name:       opGetVariantImportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/import/variant/{jobId}",
	}

	if input == nil {
		input = &GetVariantImportJobInput{}
	}

	output = &GetVariantImportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetVariantImportJob API operation for Amazon Omics.
//
// Gets information about a variant import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetVariantImportJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetVariantImportJob
func (c *Omics) GetVariantImportJob(input *GetVariantImportJobInput) (*GetVariantImportJobOutput, error) {
	req, out := c.GetVariantImportJobRequest(input)
	return out, req.Send()
}

// GetVariantImportJobWithContext is the same as GetVariantImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetVariantImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetVariantImportJobWithContext(ctx aws.Context, input *GetVariantImportJobInput, opts ...request.Option) (*GetVariantImportJobOutput, error) {
	req, out := c.GetVariantImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVariantStore = "GetVariantStore"

// GetVariantStoreRequest generates a "aws/request.Request" representing the
// client's request for the GetVariantStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVariantStore for more information on using the GetVariantStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVariantStoreRequest method.
//	req, resp := client.GetVariantStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetVariantStore
func (c *Omics) GetVariantStoreRequest(input *GetVariantStoreInput) (req *request.Request, output *GetVariantStoreOutput) {
	op := &request.Operation{
		Name:       opGetVariantStore,
		HTTPMethod: "GET",
		HTTPPath:   "/variantStore/{name}",
	}

	if input == nil {
		input = &GetVariantStoreInput{}
	}

	output = &GetVariantStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetVariantStore API operation for Amazon Omics.
//
// Gets information about a variant store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetVariantStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetVariantStore
func (c *Omics) GetVariantStore(input *GetVariantStoreInput) (*GetVariantStoreOutput, error) {
	req, out := c.GetVariantStoreRequest(input)
	return out, req.Send()
}

// GetVariantStoreWithContext is the same as GetVariantStore with the addition of
// the ability to pass a context and additional request options.
//
// See GetVariantStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetVariantStoreWithContext(ctx aws.Context, input *GetVariantStoreInput, opts ...request.Option) (*GetVariantStoreOutput, error) {
	req, out := c.GetVariantStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkflow = "GetWorkflow"

// GetWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkflow for more information on using the GetWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetWorkflowRequest method.
//	req, resp := client.GetWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetWorkflow
func (c *Omics) GetWorkflowRequest(input *GetWorkflowInput) (req *request.Request, output *GetWorkflowOutput) {
	op := &request.Operation{
		Name:       opGetWorkflow,
		HTTPMethod: "GET",
		HTTPPath:   "/workflow/{id}",
	}

	if input == nil {
		input = &GetWorkflowInput{}
	}

	output = &GetWorkflowOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("workflows-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetWorkflow API operation for Amazon Omics.
//
// Gets information about a workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation GetWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetWorkflow
func (c *Omics) GetWorkflow(input *GetWorkflowInput) (*GetWorkflowOutput, error) {
	req, out := c.GetWorkflowRequest(input)
	return out, req.Send()
}

// GetWorkflowWithContext is the same as GetWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) GetWorkflowWithContext(ctx aws.Context, input *GetWorkflowInput, opts ...request.Option) (*GetWorkflowOutput, error) {
	req, out := c.GetWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAnnotationImportJobs = "ListAnnotationImportJobs"

// ListAnnotationImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListAnnotationImportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnnotationImportJobs for more information on using the ListAnnotationImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAnnotationImportJobsRequest method.
//	req, resp := client.ListAnnotationImportJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationImportJobs
func (c *Omics) ListAnnotationImportJobsRequest(input *ListAnnotationImportJobsInput) (req *request.Request, output *ListAnnotationImportJobsOutput) {
	op := &request.Operation{
		Name:       opListAnnotationImportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/import/annotations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnnotationImportJobsInput{}
	}

	output = &ListAnnotationImportJobsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAnnotationImportJobs API operation for Amazon Omics.
//
// Retrieves a list of annotation import jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListAnnotationImportJobs for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationImportJobs
func (c *Omics) ListAnnotationImportJobs(input *ListAnnotationImportJobsInput) (*ListAnnotationImportJobsOutput, error) {
	req, out := c.ListAnnotationImportJobsRequest(input)
	return out, req.Send()
}

// ListAnnotationImportJobsWithContext is the same as ListAnnotationImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnnotationImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListAnnotationImportJobsWithContext(ctx aws.Context, input *ListAnnotationImportJobsInput, opts ...request.Option) (*ListAnnotationImportJobsOutput, error) {
	req, out := c.ListAnnotationImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnnotationImportJobsPages iterates over the pages of a ListAnnotationImportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnnotationImportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAnnotationImportJobs operation.
//	pageNum := 0
//	err := client.ListAnnotationImportJobsPages(params,
//	    func(page *omics.ListAnnotationImportJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListAnnotationImportJobsPages(input *ListAnnotationImportJobsInput, fn func(*ListAnnotationImportJobsOutput, bool) bool) error {
	return c.ListAnnotationImportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnnotationImportJobsPagesWithContext same as ListAnnotationImportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListAnnotationImportJobsPagesWithContext(ctx aws.Context, input *ListAnnotationImportJobsInput, fn func(*ListAnnotationImportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnnotationImportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnnotationImportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnnotationImportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAnnotationStoreVersions = "ListAnnotationStoreVersions"

// ListAnnotationStoreVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListAnnotationStoreVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnnotationStoreVersions for more information on using the ListAnnotationStoreVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAnnotationStoreVersionsRequest method.
//	req, resp := client.ListAnnotationStoreVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStoreVersions
func (c *Omics) ListAnnotationStoreVersionsRequest(input *ListAnnotationStoreVersionsInput) (req *request.Request, output *ListAnnotationStoreVersionsOutput) {
	op := &request.Operation{
		Name:       opListAnnotationStoreVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/annotationStore/{name}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnnotationStoreVersionsInput{}
	}

	output = &ListAnnotationStoreVersionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAnnotationStoreVersions API operation for Amazon Omics.
//
// Lists the versions of an annotation store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListAnnotationStoreVersions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStoreVersions
func (c *Omics) ListAnnotationStoreVersions(input *ListAnnotationStoreVersionsInput) (*ListAnnotationStoreVersionsOutput, error) {
	req, out := c.ListAnnotationStoreVersionsRequest(input)
	return out, req.Send()
}

// ListAnnotationStoreVersionsWithContext is the same as ListAnnotationStoreVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnnotationStoreVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListAnnotationStoreVersionsWithContext(ctx aws.Context, input *ListAnnotationStoreVersionsInput, opts ...request.Option) (*ListAnnotationStoreVersionsOutput, error) {
	req, out := c.ListAnnotationStoreVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnnotationStoreVersionsPages iterates over the pages of a ListAnnotationStoreVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnnotationStoreVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAnnotationStoreVersions operation.
//	pageNum := 0
//	err := client.ListAnnotationStoreVersionsPages(params,
//	    func(page *omics.ListAnnotationStoreVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListAnnotationStoreVersionsPages(input *ListAnnotationStoreVersionsInput, fn func(*ListAnnotationStoreVersionsOutput, bool) bool) error {
	return c.ListAnnotationStoreVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnnotationStoreVersionsPagesWithContext same as ListAnnotationStoreVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListAnnotationStoreVersionsPagesWithContext(ctx aws.Context, input *ListAnnotationStoreVersionsInput, fn func(*ListAnnotationStoreVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnnotationStoreVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnnotationStoreVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnnotationStoreVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAnnotationStores = "ListAnnotationStores"

// ListAnnotationStoresRequest generates a "aws/request.Request" representing the
// client's request for the ListAnnotationStores operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnnotationStores for more information on using the ListAnnotationStores
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAnnotationStoresRequest method.
//	req, resp := client.ListAnnotationStoresRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStores
func (c *Omics) ListAnnotationStoresRequest(input *ListAnnotationStoresInput) (req *request.Request, output *ListAnnotationStoresOutput) {
	op := &request.Operation{
		Name:       opListAnnotationStores,
		HTTPMethod: "POST",
		HTTPPath:   "/annotationStores",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnnotationStoresInput{}
	}

	output = &ListAnnotationStoresOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAnnotationStores API operation for Amazon Omics.
//
// Retrieves a list of annotation stores.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListAnnotationStores for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStores
func (c *Omics) ListAnnotationStores(input *ListAnnotationStoresInput) (*ListAnnotationStoresOutput, error) {
	req, out := c.ListAnnotationStoresRequest(input)
	return out, req.Send()
}

// ListAnnotationStoresWithContext is the same as ListAnnotationStores with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnnotationStores for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListAnnotationStoresWithContext(ctx aws.Context, input *ListAnnotationStoresInput, opts ...request.Option) (*ListAnnotationStoresOutput, error) {
	req, out := c.ListAnnotationStoresRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnnotationStoresPages iterates over the pages of a ListAnnotationStores operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnnotationStores method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAnnotationStores operation.
//	pageNum := 0
//	err := client.ListAnnotationStoresPages(params,
//	    func(page *omics.ListAnnotationStoresOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListAnnotationStoresPages(input *ListAnnotationStoresInput, fn func(*ListAnnotationStoresOutput, bool) bool) error {
	return c.ListAnnotationStoresPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnnotationStoresPagesWithContext same as ListAnnotationStoresPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListAnnotationStoresPagesWithContext(ctx aws.Context, input *ListAnnotationStoresInput, fn func(*ListAnnotationStoresOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnnotationStoresInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnnotationStoresRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnnotationStoresOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMultipartReadSetUploads = "ListMultipartReadSetUploads"

// ListMultipartReadSetUploadsRequest generates a "aws/request.Request" representing the
// client's request for the ListMultipartReadSetUploads operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMultipartReadSetUploads for more information on using the ListMultipartReadSetUploads
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMultipartReadSetUploadsRequest method.
//	req, resp := client.ListMultipartReadSetUploadsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListMultipartReadSetUploads
func (c *Omics) ListMultipartReadSetUploadsRequest(input *ListMultipartReadSetUploadsInput) (req *request.Request, output *ListMultipartReadSetUploadsOutput) {
	op := &request.Operation{
		Name:       opListMultipartReadSetUploads,
		HTTPMethod: "POST",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/uploads",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMultipartReadSetUploadsInput{}
	}

	output = &ListMultipartReadSetUploadsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListMultipartReadSetUploads API operation for Amazon Omics.
//
// Lists all multipart read set uploads and their statuses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListMultipartReadSetUploads for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - NotSupportedOperationException
//     The operation is not supported by Amazon Omics, or the API does not exist.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListMultipartReadSetUploads
func (c *Omics) ListMultipartReadSetUploads(input *ListMultipartReadSetUploadsInput) (*ListMultipartReadSetUploadsOutput, error) {
	req, out := c.ListMultipartReadSetUploadsRequest(input)
	return out, req.Send()
}

// ListMultipartReadSetUploadsWithContext is the same as ListMultipartReadSetUploads with the addition of
// the ability to pass a context and additional request options.
//
// See ListMultipartReadSetUploads for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListMultipartReadSetUploadsWithContext(ctx aws.Context, input *ListMultipartReadSetUploadsInput, opts ...request.Option) (*ListMultipartReadSetUploadsOutput, error) {
	req, out := c.ListMultipartReadSetUploadsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMultipartReadSetUploadsPages iterates over the pages of a ListMultipartReadSetUploads operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMultipartReadSetUploads method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMultipartReadSetUploads operation.
//	pageNum := 0
//	err := client.ListMultipartReadSetUploadsPages(params,
//	    func(page *omics.ListMultipartReadSetUploadsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListMultipartReadSetUploadsPages(input *ListMultipartReadSetUploadsInput, fn func(*ListMultipartReadSetUploadsOutput, bool) bool) error {
	return c.ListMultipartReadSetUploadsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMultipartReadSetUploadsPagesWithContext same as ListMultipartReadSetUploadsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListMultipartReadSetUploadsPagesWithContext(ctx aws.Context, input *ListMultipartReadSetUploadsInput, fn func(*ListMultipartReadSetUploadsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMultipartReadSetUploadsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMultipartReadSetUploadsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMultipartReadSetUploadsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReadSetActivationJobs = "ListReadSetActivationJobs"

// ListReadSetActivationJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListReadSetActivationJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReadSetActivationJobs for more information on using the ListReadSetActivationJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReadSetActivationJobsRequest method.
//	req, resp := client.ListReadSetActivationJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetActivationJobs
func (c *Omics) ListReadSetActivationJobsRequest(input *ListReadSetActivationJobsInput) (req *request.Request, output *ListReadSetActivationJobsOutput) {
	op := &request.Operation{
		Name:       opListReadSetActivationJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/activationjobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReadSetActivationJobsInput{}
	}

	output = &ListReadSetActivationJobsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListReadSetActivationJobs API operation for Amazon Omics.
//
// Retrieves a list of read set activation jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListReadSetActivationJobs for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetActivationJobs
func (c *Omics) ListReadSetActivationJobs(input *ListReadSetActivationJobsInput) (*ListReadSetActivationJobsOutput, error) {
	req, out := c.ListReadSetActivationJobsRequest(input)
	return out, req.Send()
}

// ListReadSetActivationJobsWithContext is the same as ListReadSetActivationJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListReadSetActivationJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListReadSetActivationJobsWithContext(ctx aws.Context, input *ListReadSetActivationJobsInput, opts ...request.Option) (*ListReadSetActivationJobsOutput, error) {
	req, out := c.ListReadSetActivationJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReadSetActivationJobsPages iterates over the pages of a ListReadSetActivationJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReadSetActivationJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListReadSetActivationJobs operation.
//	pageNum := 0
//	err := client.ListReadSetActivationJobsPages(params,
//	    func(page *omics.ListReadSetActivationJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListReadSetActivationJobsPages(input *ListReadSetActivationJobsInput, fn func(*ListReadSetActivationJobsOutput, bool) bool) error {
	return c.ListReadSetActivationJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReadSetActivationJobsPagesWithContext same as ListReadSetActivationJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListReadSetActivationJobsPagesWithContext(ctx aws.Context, input *ListReadSetActivationJobsInput, fn func(*ListReadSetActivationJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReadSetActivationJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReadSetActivationJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReadSetActivationJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReadSetExportJobs = "ListReadSetExportJobs"

// ListReadSetExportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListReadSetExportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReadSetExportJobs for more information on using the ListReadSetExportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReadSetExportJobsRequest method.
//	req, resp := client.ListReadSetExportJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetExportJobs
func (c *Omics) ListReadSetExportJobsRequest(input *ListReadSetExportJobsInput) (req *request.Request, output *ListReadSetExportJobsOutput) {
	op := &request.Operation{
		Name:       opListReadSetExportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/exportjobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReadSetExportJobsInput{}
	}

	output = &ListReadSetExportJobsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListReadSetExportJobs API operation for Amazon Omics.
//
// Retrieves a list of read set export jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListReadSetExportJobs for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetExportJobs
func (c *Omics) ListReadSetExportJobs(input *ListReadSetExportJobsInput) (*ListReadSetExportJobsOutput, error) {
	req, out := c.ListReadSetExportJobsRequest(input)
	return out, req.Send()
}

// ListReadSetExportJobsWithContext is the same as ListReadSetExportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListReadSetExportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListReadSetExportJobsWithContext(ctx aws.Context, input *ListReadSetExportJobsInput, opts ...request.Option) (*ListReadSetExportJobsOutput, error) {
	req, out := c.ListReadSetExportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReadSetExportJobsPages iterates over the pages of a ListReadSetExportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReadSetExportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListReadSetExportJobs operation.
//	pageNum := 0
//	err := client.ListReadSetExportJobsPages(params,
//	    func(page *omics.ListReadSetExportJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListReadSetExportJobsPages(input *ListReadSetExportJobsInput, fn func(*ListReadSetExportJobsOutput, bool) bool) error {
	return c.ListReadSetExportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReadSetExportJobsPagesWithContext same as ListReadSetExportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListReadSetExportJobsPagesWithContext(ctx aws.Context, input *ListReadSetExportJobsInput, fn func(*ListReadSetExportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReadSetExportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReadSetExportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReadSetExportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReadSetImportJobs = "ListReadSetImportJobs"

// ListReadSetImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListReadSetImportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReadSetImportJobs for more information on using the ListReadSetImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReadSetImportJobsRequest method.
//	req, resp := client.ListReadSetImportJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetImportJobs
func (c *Omics) ListReadSetImportJobsRequest(input *ListReadSetImportJobsInput) (req *request.Request, output *ListReadSetImportJobsOutput) {
	op := &request.Operation{
		Name:       opListReadSetImportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/importjobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReadSetImportJobsInput{}
	}

	output = &ListReadSetImportJobsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListReadSetImportJobs API operation for Amazon Omics.
//
// Retrieves a list of read set import jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListReadSetImportJobs for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetImportJobs
func (c *Omics) ListReadSetImportJobs(input *ListReadSetImportJobsInput) (*ListReadSetImportJobsOutput, error) {
	req, out := c.ListReadSetImportJobsRequest(input)
	return out, req.Send()
}

// ListReadSetImportJobsWithContext is the same as ListReadSetImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListReadSetImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListReadSetImportJobsWithContext(ctx aws.Context, input *ListReadSetImportJobsInput, opts ...request.Option) (*ListReadSetImportJobsOutput, error) {
	req, out := c.ListReadSetImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReadSetImportJobsPages iterates over the pages of a ListReadSetImportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReadSetImportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListReadSetImportJobs operation.
//	pageNum := 0
//	err := client.ListReadSetImportJobsPages(params,
//	    func(page *omics.ListReadSetImportJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListReadSetImportJobsPages(input *ListReadSetImportJobsInput, fn func(*ListReadSetImportJobsOutput, bool) bool) error {
	return c.ListReadSetImportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReadSetImportJobsPagesWithContext same as ListReadSetImportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListReadSetImportJobsPagesWithContext(ctx aws.Context, input *ListReadSetImportJobsInput, fn func(*ListReadSetImportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReadSetImportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReadSetImportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReadSetImportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReadSetUploadParts = "ListReadSetUploadParts"

// ListReadSetUploadPartsRequest generates a "aws/request.Request" representing the
// client's request for the ListReadSetUploadParts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReadSetUploadParts for more information on using the ListReadSetUploadParts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReadSetUploadPartsRequest method.
//	req, resp := client.ListReadSetUploadPartsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetUploadParts
func (c *Omics) ListReadSetUploadPartsRequest(input *ListReadSetUploadPartsInput) (req *request.Request, output *ListReadSetUploadPartsOutput) {
	op := &request.Operation{
		Name:       opListReadSetUploadParts,
		HTTPMethod: "POST",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/upload/{uploadId}/parts",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReadSetUploadPartsInput{}
	}

	output = &ListReadSetUploadPartsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListReadSetUploadParts API operation for Amazon Omics.
//
// This operation will list all parts in a requested multipart upload for a
// sequence store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListReadSetUploadParts for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - NotSupportedOperationException
//     The operation is not supported by Amazon Omics, or the API does not exist.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetUploadParts
func (c *Omics) ListReadSetUploadParts(input *ListReadSetUploadPartsInput) (*ListReadSetUploadPartsOutput, error) {
	req, out := c.ListReadSetUploadPartsRequest(input)
	return out, req.Send()
}

// ListReadSetUploadPartsWithContext is the same as ListReadSetUploadParts with the addition of
// the ability to pass a context and additional request options.
//
// See ListReadSetUploadParts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListReadSetUploadPartsWithContext(ctx aws.Context, input *ListReadSetUploadPartsInput, opts ...request.Option) (*ListReadSetUploadPartsOutput, error) {
	req, out := c.ListReadSetUploadPartsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReadSetUploadPartsPages iterates over the pages of a ListReadSetUploadParts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReadSetUploadParts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListReadSetUploadParts operation.
//	pageNum := 0
//	err := client.ListReadSetUploadPartsPages(params,
//	    func(page *omics.ListReadSetUploadPartsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListReadSetUploadPartsPages(input *ListReadSetUploadPartsInput, fn func(*ListReadSetUploadPartsOutput, bool) bool) error {
	return c.ListReadSetUploadPartsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReadSetUploadPartsPagesWithContext same as ListReadSetUploadPartsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListReadSetUploadPartsPagesWithContext(ctx aws.Context, input *ListReadSetUploadPartsInput, fn func(*ListReadSetUploadPartsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReadSetUploadPartsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReadSetUploadPartsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReadSetUploadPartsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReadSets = "ListReadSets"

// ListReadSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListReadSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReadSets for more information on using the ListReadSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReadSetsRequest method.
//	req, resp := client.ListReadSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSets
func (c *Omics) ListReadSetsRequest(input *ListReadSetsInput) (req *request.Request, output *ListReadSetsOutput) {
	op := &request.Operation{
		Name:       opListReadSets,
		HTTPMethod: "POST",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/readsets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReadSetsInput{}
	}

	output = &ListReadSetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListReadSets API operation for Amazon Omics.
//
// Retrieves a list of read sets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListReadSets for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSets
func (c *Omics) ListReadSets(input *ListReadSetsInput) (*ListReadSetsOutput, error) {
	req, out := c.ListReadSetsRequest(input)
	return out, req.Send()
}

// ListReadSetsWithContext is the same as ListReadSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListReadSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListReadSetsWithContext(ctx aws.Context, input *ListReadSetsInput, opts ...request.Option) (*ListReadSetsOutput, error) {
	req, out := c.ListReadSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReadSetsPages iterates over the pages of a ListReadSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReadSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListReadSets operation.
//	pageNum := 0
//	err := client.ListReadSetsPages(params,
//	    func(page *omics.ListReadSetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListReadSetsPages(input *ListReadSetsInput, fn func(*ListReadSetsOutput, bool) bool) error {
	return c.ListReadSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReadSetsPagesWithContext same as ListReadSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListReadSetsPagesWithContext(ctx aws.Context, input *ListReadSetsInput, fn func(*ListReadSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReadSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReadSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReadSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReferenceImportJobs = "ListReferenceImportJobs"

// ListReferenceImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListReferenceImportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReferenceImportJobs for more information on using the ListReferenceImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReferenceImportJobsRequest method.
//	req, resp := client.ListReferenceImportJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceImportJobs
func (c *Omics) ListReferenceImportJobsRequest(input *ListReferenceImportJobsInput) (req *request.Request, output *ListReferenceImportJobsOutput) {
	op := &request.Operation{
		Name:       opListReferenceImportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/referencestore/{referenceStoreId}/importjobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReferenceImportJobsInput{}
	}

	output = &ListReferenceImportJobsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListReferenceImportJobs API operation for Amazon Omics.
//
// Retrieves a list of reference import jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListReferenceImportJobs for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceImportJobs
func (c *Omics) ListReferenceImportJobs(input *ListReferenceImportJobsInput) (*ListReferenceImportJobsOutput, error) {
	req, out := c.ListReferenceImportJobsRequest(input)
	return out, req.Send()
}

// ListReferenceImportJobsWithContext is the same as ListReferenceImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListReferenceImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListReferenceImportJobsWithContext(ctx aws.Context, input *ListReferenceImportJobsInput, opts ...request.Option) (*ListReferenceImportJobsOutput, error) {
	req, out := c.ListReferenceImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReferenceImportJobsPages iterates over the pages of a ListReferenceImportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReferenceImportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListReferenceImportJobs operation.
//	pageNum := 0
//	err := client.ListReferenceImportJobsPages(params,
//	    func(page *omics.ListReferenceImportJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListReferenceImportJobsPages(input *ListReferenceImportJobsInput, fn func(*ListReferenceImportJobsOutput, bool) bool) error {
	return c.ListReferenceImportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReferenceImportJobsPagesWithContext same as ListReferenceImportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListReferenceImportJobsPagesWithContext(ctx aws.Context, input *ListReferenceImportJobsInput, fn func(*ListReferenceImportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReferenceImportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReferenceImportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReferenceImportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReferenceStores = "ListReferenceStores"

// ListReferenceStoresRequest generates a "aws/request.Request" representing the
// client's request for the ListReferenceStores operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReferenceStores for more information on using the ListReferenceStores
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReferenceStoresRequest method.
//	req, resp := client.ListReferenceStoresRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceStores
func (c *Omics) ListReferenceStoresRequest(input *ListReferenceStoresInput) (req *request.Request, output *ListReferenceStoresOutput) {
	op := &request.Operation{
		Name:       opListReferenceStores,
		HTTPMethod: "POST",
		HTTPPath:   "/referencestores",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReferenceStoresInput{}
	}

	output = &ListReferenceStoresOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListReferenceStores API operation for Amazon Omics.
//
// Retrieves a list of reference stores.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListReferenceStores for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceStores
func (c *Omics) ListReferenceStores(input *ListReferenceStoresInput) (*ListReferenceStoresOutput, error) {
	req, out := c.ListReferenceStoresRequest(input)
	return out, req.Send()
}

// ListReferenceStoresWithContext is the same as ListReferenceStores with the addition of
// the ability to pass a context and additional request options.
//
// See ListReferenceStores for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListReferenceStoresWithContext(ctx aws.Context, input *ListReferenceStoresInput, opts ...request.Option) (*ListReferenceStoresOutput, error) {
	req, out := c.ListReferenceStoresRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReferenceStoresPages iterates over the pages of a ListReferenceStores operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReferenceStores method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListReferenceStores operation.
//	pageNum := 0
//	err := client.ListReferenceStoresPages(params,
//	    func(page *omics.ListReferenceStoresOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListReferenceStoresPages(input *ListReferenceStoresInput, fn func(*ListReferenceStoresOutput, bool) bool) error {
	return c.ListReferenceStoresPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReferenceStoresPagesWithContext same as ListReferenceStoresPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListReferenceStoresPagesWithContext(ctx aws.Context, input *ListReferenceStoresInput, fn func(*ListReferenceStoresOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReferenceStoresInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReferenceStoresRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReferenceStoresOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReferences = "ListReferences"

// ListReferencesRequest generates a "aws/request.Request" representing the
// client's request for the ListReferences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReferences for more information on using the ListReferences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReferencesRequest method.
//	req, resp := client.ListReferencesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferences
func (c *Omics) ListReferencesRequest(input *ListReferencesInput) (req *request.Request, output *ListReferencesOutput) {
	op := &request.Operation{
		Name:       opListReferences,
		HTTPMethod: "POST",
		HTTPPath:   "/referencestore/{referenceStoreId}/references",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReferencesInput{}
	}

	output = &ListReferencesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListReferences API operation for Amazon Omics.
//
// Retrieves a list of references.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListReferences for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferences
func (c *Omics) ListReferences(input *ListReferencesInput) (*ListReferencesOutput, error) {
	req, out := c.ListReferencesRequest(input)
	return out, req.Send()
}

// ListReferencesWithContext is the same as ListReferences with the addition of
// the ability to pass a context and additional request options.
//
// See ListReferences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListReferencesWithContext(ctx aws.Context, input *ListReferencesInput, opts ...request.Option) (*ListReferencesOutput, error) {
	req, out := c.ListReferencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReferencesPages iterates over the pages of a ListReferences operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReferences method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListReferences operation.
//	pageNum := 0
//	err := client.ListReferencesPages(params,
//	    func(page *omics.ListReferencesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListReferencesPages(input *ListReferencesInput, fn func(*ListReferencesOutput, bool) bool) error {
	return c.ListReferencesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReferencesPagesWithContext same as ListReferencesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListReferencesPagesWithContext(ctx aws.Context, input *ListReferencesInput, fn func(*ListReferencesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReferencesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReferencesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReferencesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRunGroups = "ListRunGroups"

// ListRunGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListRunGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRunGroups for more information on using the ListRunGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRunGroupsRequest method.
//	req, resp := client.ListRunGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunGroups
func (c *Omics) ListRunGroupsRequest(input *ListRunGroupsInput) (req *request.Request, output *ListRunGroupsOutput) {
	op := &request.Operation{
		Name:       opListRunGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/runGroup",
		Paginator: &request.Paginator{
			InputTokens:     []string{"startingToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRunGroupsInput{}
	}

	output = &ListRunGroupsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("workflows-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListRunGroups API operation for Amazon Omics.
//
// Retrieves a list of run groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListRunGroups for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunGroups
func (c *Omics) ListRunGroups(input *ListRunGroupsInput) (*ListRunGroupsOutput, error) {
	req, out := c.ListRunGroupsRequest(input)
	return out, req.Send()
}

// ListRunGroupsWithContext is the same as ListRunGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListRunGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListRunGroupsWithContext(ctx aws.Context, input *ListRunGroupsInput, opts ...request.Option) (*ListRunGroupsOutput, error) {
	req, out := c.ListRunGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRunGroupsPages iterates over the pages of a ListRunGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRunGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRunGroups operation.
//	pageNum := 0
//	err := client.ListRunGroupsPages(params,
//	    func(page *omics.ListRunGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListRunGroupsPages(input *ListRunGroupsInput, fn func(*ListRunGroupsOutput, bool) bool) error {
	return c.ListRunGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRunGroupsPagesWithContext same as ListRunGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListRunGroupsPagesWithContext(ctx aws.Context, input *ListRunGroupsInput, fn func(*ListRunGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRunGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRunGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRunGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRunTasks = "ListRunTasks"

// ListRunTasksRequest generates a "aws/request.Request" representing the
// client's request for the ListRunTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRunTasks for more information on using the ListRunTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRunTasksRequest method.
//	req, resp := client.ListRunTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunTasks
func (c *Omics) ListRunTasksRequest(input *ListRunTasksInput) (req *request.Request, output *ListRunTasksOutput) {
	op := &request.Operation{
		Name:       opListRunTasks,
		HTTPMethod: "GET",
		HTTPPath:   "/run/{id}/task",
		Paginator: &request.Paginator{
			InputTokens:     []string{"startingToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRunTasksInput{}
	}

	output = &ListRunTasksOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("workflows-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListRunTasks API operation for Amazon Omics.
//
// Retrieves a list of tasks for a run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListRunTasks for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunTasks
func (c *Omics) ListRunTasks(input *ListRunTasksInput) (*ListRunTasksOutput, error) {
	req, out := c.ListRunTasksRequest(input)
	return out, req.Send()
}

// ListRunTasksWithContext is the same as ListRunTasks with the addition of
// the ability to pass a context and additional request options.
//
// See ListRunTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListRunTasksWithContext(ctx aws.Context, input *ListRunTasksInput, opts ...request.Option) (*ListRunTasksOutput, error) {
	req, out := c.ListRunTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRunTasksPages iterates over the pages of a ListRunTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRunTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRunTasks operation.
//	pageNum := 0
//	err := client.ListRunTasksPages(params,
//	    func(page *omics.ListRunTasksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListRunTasksPages(input *ListRunTasksInput, fn func(*ListRunTasksOutput, bool) bool) error {
	return c.ListRunTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRunTasksPagesWithContext same as ListRunTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListRunTasksPagesWithContext(ctx aws.Context, input *ListRunTasksInput, fn func(*ListRunTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRunTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRunTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRunTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRuns = "ListRuns"

// ListRunsRequest generates a "aws/request.Request" representing the
// client's request for the ListRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRuns for more information on using the ListRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRunsRequest method.
//	req, resp := client.ListRunsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRuns
func (c *Omics) ListRunsRequest(input *ListRunsInput) (req *request.Request, output *ListRunsOutput) {
	op := &request.Operation{
		Name:       opListRuns,
		HTTPMethod: "GET",
		HTTPPath:   "/run",
		Paginator: &request.Paginator{
			InputTokens:     []string{"startingToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRunsInput{}
	}

	output = &ListRunsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("workflows-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListRuns API operation for Amazon Omics.
//
// Retrieves a list of runs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListRuns for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRuns
func (c *Omics) ListRuns(input *ListRunsInput) (*ListRunsOutput, error) {
	req, out := c.ListRunsRequest(input)
	return out, req.Send()
}

// ListRunsWithContext is the same as ListRuns with the addition of
// the ability to pass a context and additional request options.
//
// See ListRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListRunsWithContext(ctx aws.Context, input *ListRunsInput, opts ...request.Option) (*ListRunsOutput, error) {
	req, out := c.ListRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRunsPages iterates over the pages of a ListRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRuns operation.
//	pageNum := 0
//	err := client.ListRunsPages(params,
//	    func(page *omics.ListRunsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListRunsPages(input *ListRunsInput, fn func(*ListRunsOutput, bool) bool) error {
	return c.ListRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRunsPagesWithContext same as ListRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListRunsPagesWithContext(ctx aws.Context, input *ListRunsInput, fn func(*ListRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRunsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSequenceStores = "ListSequenceStores"

// ListSequenceStoresRequest generates a "aws/request.Request" representing the
// client's request for the ListSequenceStores operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSequenceStores for more information on using the ListSequenceStores
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSequenceStoresRequest method.
//	req, resp := client.ListSequenceStoresRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListSequenceStores
func (c *Omics) ListSequenceStoresRequest(input *ListSequenceStoresInput) (req *request.Request, output *ListSequenceStoresOutput) {
	op := &request.Operation{
		Name:       opListSequenceStores,
		HTTPMethod: "POST",
		HTTPPath:   "/sequencestores",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSequenceStoresInput{}
	}

	output = &ListSequenceStoresOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListSequenceStores API operation for Amazon Omics.
//
// Retrieves a list of sequence stores.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListSequenceStores for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListSequenceStores
func (c *Omics) ListSequenceStores(input *ListSequenceStoresInput) (*ListSequenceStoresOutput, error) {
	req, out := c.ListSequenceStoresRequest(input)
	return out, req.Send()
}

// ListSequenceStoresWithContext is the same as ListSequenceStores with the addition of
// the ability to pass a context and additional request options.
//
// See ListSequenceStores for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListSequenceStoresWithContext(ctx aws.Context, input *ListSequenceStoresInput, opts ...request.Option) (*ListSequenceStoresOutput, error) {
	req, out := c.ListSequenceStoresRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSequenceStoresPages iterates over the pages of a ListSequenceStores operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSequenceStores method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSequenceStores operation.
//	pageNum := 0
//	err := client.ListSequenceStoresPages(params,
//	    func(page *omics.ListSequenceStoresOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListSequenceStoresPages(input *ListSequenceStoresInput, fn func(*ListSequenceStoresOutput, bool) bool) error {
	return c.ListSequenceStoresPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSequenceStoresPagesWithContext same as ListSequenceStoresPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListSequenceStoresPagesWithContext(ctx aws.Context, input *ListSequenceStoresInput, fn func(*ListSequenceStoresOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSequenceStoresInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSequenceStoresRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSequenceStoresOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListShares = "ListShares"

// ListSharesRequest generates a "aws/request.Request" representing the
// client's request for the ListShares operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListShares for more information on using the ListShares
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSharesRequest method.
//	req, resp := client.ListSharesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListShares
func (c *Omics) ListSharesRequest(input *ListSharesInput) (req *request.Request, output *ListSharesOutput) {
	op := &request.Operation{
		Name:       opListShares,
		HTTPMethod: "POST",
		HTTPPath:   "/shares",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSharesInput{}
	}

	output = &ListSharesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListShares API operation for Amazon Omics.
//
// Lists all shares associated with an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListShares for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListShares
func (c *Omics) ListShares(input *ListSharesInput) (*ListSharesOutput, error) {
	req, out := c.ListSharesRequest(input)
	return out, req.Send()
}

// ListSharesWithContext is the same as ListShares with the addition of
// the ability to pass a context and additional request options.
//
// See ListShares for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListSharesWithContext(ctx aws.Context, input *ListSharesInput, opts ...request.Option) (*ListSharesOutput, error) {
	req, out := c.ListSharesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSharesPages iterates over the pages of a ListShares operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListShares method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListShares operation.
//	pageNum := 0
//	err := client.ListSharesPages(params,
//	    func(page *omics.ListSharesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListSharesPages(input *ListSharesInput, fn func(*ListSharesOutput, bool) bool) error {
	return c.ListSharesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSharesPagesWithContext same as ListSharesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListSharesPagesWithContext(ctx aws.Context, input *ListSharesInput, fn func(*ListSharesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSharesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSharesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSharesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListTagsForResource
func (c *Omics) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tags-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListTagsForResource API operation for Amazon Omics.
//
// Retrieves a list of tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListTagsForResource
func (c *Omics) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVariantImportJobs = "ListVariantImportJobs"

// ListVariantImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListVariantImportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVariantImportJobs for more information on using the ListVariantImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVariantImportJobsRequest method.
//	req, resp := client.ListVariantImportJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantImportJobs
func (c *Omics) ListVariantImportJobsRequest(input *ListVariantImportJobsInput) (req *request.Request, output *ListVariantImportJobsOutput) {
	op := &request.Operation{
		Name:       opListVariantImportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/import/variants",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVariantImportJobsInput{}
	}

	output = &ListVariantImportJobsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListVariantImportJobs API operation for Amazon Omics.
//
// Retrieves a list of variant import jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListVariantImportJobs for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantImportJobs
func (c *Omics) ListVariantImportJobs(input *ListVariantImportJobsInput) (*ListVariantImportJobsOutput, error) {
	req, out := c.ListVariantImportJobsRequest(input)
	return out, req.Send()
}

// ListVariantImportJobsWithContext is the same as ListVariantImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListVariantImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListVariantImportJobsWithContext(ctx aws.Context, input *ListVariantImportJobsInput, opts ...request.Option) (*ListVariantImportJobsOutput, error) {
	req, out := c.ListVariantImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVariantImportJobsPages iterates over the pages of a ListVariantImportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVariantImportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVariantImportJobs operation.
//	pageNum := 0
//	err := client.ListVariantImportJobsPages(params,
//	    func(page *omics.ListVariantImportJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListVariantImportJobsPages(input *ListVariantImportJobsInput, fn func(*ListVariantImportJobsOutput, bool) bool) error {
	return c.ListVariantImportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVariantImportJobsPagesWithContext same as ListVariantImportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListVariantImportJobsPagesWithContext(ctx aws.Context, input *ListVariantImportJobsInput, fn func(*ListVariantImportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVariantImportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVariantImportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVariantImportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVariantStores = "ListVariantStores"

// ListVariantStoresRequest generates a "aws/request.Request" representing the
// client's request for the ListVariantStores operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVariantStores for more information on using the ListVariantStores
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVariantStoresRequest method.
//	req, resp := client.ListVariantStoresRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantStores
func (c *Omics) ListVariantStoresRequest(input *ListVariantStoresInput) (req *request.Request, output *ListVariantStoresOutput) {
	op := &request.Operation{
		Name:       opListVariantStores,
		HTTPMethod: "POST",
		HTTPPath:   "/variantStores",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVariantStoresInput{}
	}

	output = &ListVariantStoresOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListVariantStores API operation for Amazon Omics.
//
// Retrieves a list of variant stores.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListVariantStores for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantStores
func (c *Omics) ListVariantStores(input *ListVariantStoresInput) (*ListVariantStoresOutput, error) {
	req, out := c.ListVariantStoresRequest(input)
	return out, req.Send()
}

// ListVariantStoresWithContext is the same as ListVariantStores with the addition of
// the ability to pass a context and additional request options.
//
// See ListVariantStores for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListVariantStoresWithContext(ctx aws.Context, input *ListVariantStoresInput, opts ...request.Option) (*ListVariantStoresOutput, error) {
	req, out := c.ListVariantStoresRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVariantStoresPages iterates over the pages of a ListVariantStores operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVariantStores method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVariantStores operation.
//	pageNum := 0
//	err := client.ListVariantStoresPages(params,
//	    func(page *omics.ListVariantStoresOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListVariantStoresPages(input *ListVariantStoresInput, fn func(*ListVariantStoresOutput, bool) bool) error {
	return c.ListVariantStoresPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVariantStoresPagesWithContext same as ListVariantStoresPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListVariantStoresPagesWithContext(ctx aws.Context, input *ListVariantStoresInput, fn func(*ListVariantStoresOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVariantStoresInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVariantStoresRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVariantStoresOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkflows = "ListWorkflows"

// ListWorkflowsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkflows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkflows for more information on using the ListWorkflows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWorkflowsRequest method.
//	req, resp := client.ListWorkflowsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflows
func (c *Omics) ListWorkflowsRequest(input *ListWorkflowsInput) (req *request.Request, output *ListWorkflowsOutput) {
	op := &request.Operation{
		Name:       opListWorkflows,
		HTTPMethod: "GET",
		HTTPPath:   "/workflow",
		Paginator: &request.Paginator{
			InputTokens:     []string{"startingToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkflowsInput{}
	}

	output = &ListWorkflowsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("workflows-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListWorkflows API operation for Amazon Omics.
//
// Retrieves a list of workflows.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation ListWorkflows for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflows
func (c *Omics) ListWorkflows(input *ListWorkflowsInput) (*ListWorkflowsOutput, error) {
	req, out := c.ListWorkflowsRequest(input)
	return out, req.Send()
}

// ListWorkflowsWithContext is the same as ListWorkflows with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkflows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListWorkflowsWithContext(ctx aws.Context, input *ListWorkflowsInput, opts ...request.Option) (*ListWorkflowsOutput, error) {
	req, out := c.ListWorkflowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkflowsPages iterates over the pages of a ListWorkflows operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkflows method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListWorkflows operation.
//	pageNum := 0
//	err := client.ListWorkflowsPages(params,
//	    func(page *omics.ListWorkflowsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Omics) ListWorkflowsPages(input *ListWorkflowsInput, fn func(*ListWorkflowsOutput, bool) bool) error {
	return c.ListWorkflowsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkflowsPagesWithContext same as ListWorkflowsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) ListWorkflowsPagesWithContext(ctx aws.Context, input *ListWorkflowsInput, fn func(*ListWorkflowsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkflowsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkflowsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkflowsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartAnnotationImportJob = "StartAnnotationImportJob"

// StartAnnotationImportJobRequest generates a "aws/request.Request" representing the
// client's request for the StartAnnotationImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartAnnotationImportJob for more information on using the StartAnnotationImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartAnnotationImportJobRequest method.
//	req, resp := client.StartAnnotationImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartAnnotationImportJob
func (c *Omics) StartAnnotationImportJobRequest(input *StartAnnotationImportJobInput) (req *request.Request, output *StartAnnotationImportJobOutput) {
	op := &request.Operation{
		Name:       opStartAnnotationImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/import/annotation",
	}

	if input == nil {
		input = &StartAnnotationImportJobInput{}
	}

	output = &StartAnnotationImportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// StartAnnotationImportJob API operation for Amazon Omics.
//
// Starts an annotation import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation StartAnnotationImportJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartAnnotationImportJob
func (c *Omics) StartAnnotationImportJob(input *StartAnnotationImportJobInput) (*StartAnnotationImportJobOutput, error) {
	req, out := c.StartAnnotationImportJobRequest(input)
	return out, req.Send()
}

// StartAnnotationImportJobWithContext is the same as StartAnnotationImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartAnnotationImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) StartAnnotationImportJobWithContext(ctx aws.Context, input *StartAnnotationImportJobInput, opts ...request.Option) (*StartAnnotationImportJobOutput, error) {
	req, out := c.StartAnnotationImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartReadSetActivationJob = "StartReadSetActivationJob"

// StartReadSetActivationJobRequest generates a "aws/request.Request" representing the
// client's request for the StartReadSetActivationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartReadSetActivationJob for more information on using the StartReadSetActivationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartReadSetActivationJobRequest method.
//	req, resp := client.StartReadSetActivationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetActivationJob
func (c *Omics) StartReadSetActivationJobRequest(input *StartReadSetActivationJobInput) (req *request.Request, output *StartReadSetActivationJobOutput) {
	op := &request.Operation{
		Name:       opStartReadSetActivationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/activationjob",
	}

	if input == nil {
		input = &StartReadSetActivationJobInput{}
	}

	output = &StartReadSetActivationJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// StartReadSetActivationJob API operation for Amazon Omics.
//
// Activates an archived read set. To reduce storage charges, Amazon Omics archives
// unused read sets after 30 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation StartReadSetActivationJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetActivationJob
func (c *Omics) StartReadSetActivationJob(input *StartReadSetActivationJobInput) (*StartReadSetActivationJobOutput, error) {
	req, out := c.StartReadSetActivationJobRequest(input)
	return out, req.Send()
}

// StartReadSetActivationJobWithContext is the same as StartReadSetActivationJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartReadSetActivationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) StartReadSetActivationJobWithContext(ctx aws.Context, input *StartReadSetActivationJobInput, opts ...request.Option) (*StartReadSetActivationJobOutput, error) {
	req, out := c.StartReadSetActivationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartReadSetExportJob = "StartReadSetExportJob"

// StartReadSetExportJobRequest generates a "aws/request.Request" representing the
// client's request for the StartReadSetExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartReadSetExportJob for more information on using the StartReadSetExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartReadSetExportJobRequest method.
//	req, resp := client.StartReadSetExportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetExportJob
func (c *Omics) StartReadSetExportJobRequest(input *StartReadSetExportJobInput) (req *request.Request, output *StartReadSetExportJobOutput) {
	op := &request.Operation{
		Name:       opStartReadSetExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/exportjob",
	}

	if input == nil {
		input = &StartReadSetExportJobInput{}
	}

	output = &StartReadSetExportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// StartReadSetExportJob API operation for Amazon Omics.
//
// Exports a read set to Amazon S3.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation StartReadSetExportJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetExportJob
func (c *Omics) StartReadSetExportJob(input *StartReadSetExportJobInput) (*StartReadSetExportJobOutput, error) {
	req, out := c.StartReadSetExportJobRequest(input)
	return out, req.Send()
}

// StartReadSetExportJobWithContext is the same as StartReadSetExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartReadSetExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) StartReadSetExportJobWithContext(ctx aws.Context, input *StartReadSetExportJobInput, opts ...request.Option) (*StartReadSetExportJobOutput, error) {
	req, out := c.StartReadSetExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartReadSetImportJob = "StartReadSetImportJob"

// StartReadSetImportJobRequest generates a "aws/request.Request" representing the
// client's request for the StartReadSetImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartReadSetImportJob for more information on using the StartReadSetImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartReadSetImportJobRequest method.
//	req, resp := client.StartReadSetImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetImportJob
func (c *Omics) StartReadSetImportJobRequest(input *StartReadSetImportJobInput) (req *request.Request, output *StartReadSetImportJobOutput) {
	op := &request.Operation{
		Name:       opStartReadSetImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/importjob",
	}

	if input == nil {
		input = &StartReadSetImportJobInput{}
	}

	output = &StartReadSetImportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// StartReadSetImportJob API operation for Amazon Omics.
//
// Starts a read set import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation StartReadSetImportJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetImportJob
func (c *Omics) StartReadSetImportJob(input *StartReadSetImportJobInput) (*StartReadSetImportJobOutput, error) {
	req, out := c.StartReadSetImportJobRequest(input)
	return out, req.Send()
}

// StartReadSetImportJobWithContext is the same as StartReadSetImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartReadSetImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) StartReadSetImportJobWithContext(ctx aws.Context, input *StartReadSetImportJobInput, opts ...request.Option) (*StartReadSetImportJobOutput, error) {
	req, out := c.StartReadSetImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartReferenceImportJob = "StartReferenceImportJob"

// StartReferenceImportJobRequest generates a "aws/request.Request" representing the
// client's request for the StartReferenceImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartReferenceImportJob for more information on using the StartReferenceImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartReferenceImportJobRequest method.
//	req, resp := client.StartReferenceImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReferenceImportJob
func (c *Omics) StartReferenceImportJobRequest(input *StartReferenceImportJobInput) (req *request.Request, output *StartReferenceImportJobOutput) {
	op := &request.Operation{
		Name:       opStartReferenceImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/referencestore/{referenceStoreId}/importjob",
	}

	if input == nil {
		input = &StartReferenceImportJobInput{}
	}

	output = &StartReferenceImportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("control-storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// StartReferenceImportJob API operation for Amazon Omics.
//
// Starts a reference import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation StartReferenceImportJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReferenceImportJob
func (c *Omics) StartReferenceImportJob(input *StartReferenceImportJobInput) (*StartReferenceImportJobOutput, error) {
	req, out := c.StartReferenceImportJobRequest(input)
	return out, req.Send()
}

// StartReferenceImportJobWithContext is the same as StartReferenceImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartReferenceImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) StartReferenceImportJobWithContext(ctx aws.Context, input *StartReferenceImportJobInput, opts ...request.Option) (*StartReferenceImportJobOutput, error) {
	req, out := c.StartReferenceImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartRun = "StartRun"

// StartRunRequest generates a "aws/request.Request" representing the
// client's request for the StartRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartRun for more information on using the StartRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartRunRequest method.
//	req, resp := client.StartRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartRun
func (c *Omics) StartRunRequest(input *StartRunInput) (req *request.Request, output *StartRunOutput) {
	op := &request.Operation{
		Name:       opStartRun,
		HTTPMethod: "POST",
		HTTPPath:   "/run",
	}

	if input == nil {
		input = &StartRunInput{}
	}

	output = &StartRunOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("workflows-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// StartRun API operation for Amazon Omics.
//
// Starts a workflow run. To duplicate a run, specify the run's ID and a role
// ARN. The remaining parameters are copied from the previous run.
//
// The total number of runs in your account is subject to a quota per Region.
// To avoid needing to delete runs manually, you can set the retention mode
// to REMOVE. Runs with this setting are deleted automatically when the run
// quoata is exceeded.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation StartRun for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartRun
func (c *Omics) StartRun(input *StartRunInput) (*StartRunOutput, error) {
	req, out := c.StartRunRequest(input)
	return out, req.Send()
}

// StartRunWithContext is the same as StartRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) StartRunWithContext(ctx aws.Context, input *StartRunInput, opts ...request.Option) (*StartRunOutput, error) {
	req, out := c.StartRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartVariantImportJob = "StartVariantImportJob"

// StartVariantImportJobRequest generates a "aws/request.Request" representing the
// client's request for the StartVariantImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartVariantImportJob for more information on using the StartVariantImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartVariantImportJobRequest method.
//	req, resp := client.StartVariantImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartVariantImportJob
func (c *Omics) StartVariantImportJobRequest(input *StartVariantImportJobInput) (req *request.Request, output *StartVariantImportJobOutput) {
	op := &request.Operation{
		Name:       opStartVariantImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/import/variant",
	}

	if input == nil {
		input = &StartVariantImportJobInput{}
	}

	output = &StartVariantImportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// StartVariantImportJob API operation for Amazon Omics.
//
// Starts a variant import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation StartVariantImportJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartVariantImportJob
func (c *Omics) StartVariantImportJob(input *StartVariantImportJobInput) (*StartVariantImportJobOutput, error) {
	req, out := c.StartVariantImportJobRequest(input)
	return out, req.Send()
}

// StartVariantImportJobWithContext is the same as StartVariantImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartVariantImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) StartVariantImportJobWithContext(ctx aws.Context, input *StartVariantImportJobInput, opts ...request.Option) (*StartVariantImportJobOutput, error) {
	req, out := c.StartVariantImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/TagResource
func (c *Omics) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tags-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// TagResource API operation for Amazon Omics.
//
// Tags a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/TagResource
func (c *Omics) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UntagResource
func (c *Omics) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tags-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UntagResource API operation for Amazon Omics.
//
// Removes tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UntagResource
func (c *Omics) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAnnotationStore = "UpdateAnnotationStore"

// UpdateAnnotationStoreRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAnnotationStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAnnotationStore for more information on using the UpdateAnnotationStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAnnotationStoreRequest method.
//	req, resp := client.UpdateAnnotationStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateAnnotationStore
func (c *Omics) UpdateAnnotationStoreRequest(input *UpdateAnnotationStoreInput) (req *request.Request, output *UpdateAnnotationStoreOutput) {
	op := &request.Operation{
		Name:       opUpdateAnnotationStore,
		HTTPMethod: "POST",
		HTTPPath:   "/annotationStore/{name}",
	}

	if input == nil {
		input = &UpdateAnnotationStoreInput{}
	}

	output = &UpdateAnnotationStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateAnnotationStore API operation for Amazon Omics.
//
// Updates an annotation store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation UpdateAnnotationStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateAnnotationStore
func (c *Omics) UpdateAnnotationStore(input *UpdateAnnotationStoreInput) (*UpdateAnnotationStoreOutput, error) {
	req, out := c.UpdateAnnotationStoreRequest(input)
	return out, req.Send()
}

// UpdateAnnotationStoreWithContext is the same as UpdateAnnotationStore with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAnnotationStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) UpdateAnnotationStoreWithContext(ctx aws.Context, input *UpdateAnnotationStoreInput, opts ...request.Option) (*UpdateAnnotationStoreOutput, error) {
	req, out := c.UpdateAnnotationStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAnnotationStoreVersion = "UpdateAnnotationStoreVersion"

// UpdateAnnotationStoreVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAnnotationStoreVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAnnotationStoreVersion for more information on using the UpdateAnnotationStoreVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAnnotationStoreVersionRequest method.
//	req, resp := client.UpdateAnnotationStoreVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateAnnotationStoreVersion
func (c *Omics) UpdateAnnotationStoreVersionRequest(input *UpdateAnnotationStoreVersionInput) (req *request.Request, output *UpdateAnnotationStoreVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateAnnotationStoreVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/annotationStore/{name}/version/{versionName}",
	}

	if input == nil {
		input = &UpdateAnnotationStoreVersionInput{}
	}

	output = &UpdateAnnotationStoreVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateAnnotationStoreVersion API operation for Amazon Omics.
//
// Updates the description of an annotation store version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation UpdateAnnotationStoreVersion for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateAnnotationStoreVersion
func (c *Omics) UpdateAnnotationStoreVersion(input *UpdateAnnotationStoreVersionInput) (*UpdateAnnotationStoreVersionOutput, error) {
	req, out := c.UpdateAnnotationStoreVersionRequest(input)
	return out, req.Send()
}

// UpdateAnnotationStoreVersionWithContext is the same as UpdateAnnotationStoreVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAnnotationStoreVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) UpdateAnnotationStoreVersionWithContext(ctx aws.Context, input *UpdateAnnotationStoreVersionInput, opts ...request.Option) (*UpdateAnnotationStoreVersionOutput, error) {
	req, out := c.UpdateAnnotationStoreVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRunGroup = "UpdateRunGroup"

// UpdateRunGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRunGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRunGroup for more information on using the UpdateRunGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRunGroupRequest method.
//	req, resp := client.UpdateRunGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateRunGroup
func (c *Omics) UpdateRunGroupRequest(input *UpdateRunGroupInput) (req *request.Request, output *UpdateRunGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateRunGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/runGroup/{id}",
	}

	if input == nil {
		input = &UpdateRunGroupInput{}
	}

	output = &UpdateRunGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("workflows-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateRunGroup API operation for Amazon Omics.
//
// Updates a run group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation UpdateRunGroup for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateRunGroup
func (c *Omics) UpdateRunGroup(input *UpdateRunGroupInput) (*UpdateRunGroupOutput, error) {
	req, out := c.UpdateRunGroupRequest(input)
	return out, req.Send()
}

// UpdateRunGroupWithContext is the same as UpdateRunGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRunGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) UpdateRunGroupWithContext(ctx aws.Context, input *UpdateRunGroupInput, opts ...request.Option) (*UpdateRunGroupOutput, error) {
	req, out := c.UpdateRunGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVariantStore = "UpdateVariantStore"

// UpdateVariantStoreRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVariantStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVariantStore for more information on using the UpdateVariantStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateVariantStoreRequest method.
//	req, resp := client.UpdateVariantStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateVariantStore
func (c *Omics) UpdateVariantStoreRequest(input *UpdateVariantStoreInput) (req *request.Request, output *UpdateVariantStoreOutput) {
	op := &request.Operation{
		Name:       opUpdateVariantStore,
		HTTPMethod: "POST",
		HTTPPath:   "/variantStore/{name}",
	}

	if input == nil {
		input = &UpdateVariantStoreInput{}
	}

	output = &UpdateVariantStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("analytics-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateVariantStore API operation for Amazon Omics.
//
// Updates a variant store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation UpdateVariantStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateVariantStore
func (c *Omics) UpdateVariantStore(input *UpdateVariantStoreInput) (*UpdateVariantStoreOutput, error) {
	req, out := c.UpdateVariantStoreRequest(input)
	return out, req.Send()
}

// UpdateVariantStoreWithContext is the same as UpdateVariantStore with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVariantStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) UpdateVariantStoreWithContext(ctx aws.Context, input *UpdateVariantStoreInput, opts ...request.Option) (*UpdateVariantStoreOutput, error) {
	req, out := c.UpdateVariantStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkflow = "UpdateWorkflow"

// UpdateWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkflow for more information on using the UpdateWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkflowRequest method.
//	req, resp := client.UpdateWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateWorkflow
func (c *Omics) UpdateWorkflowRequest(input *UpdateWorkflowInput) (req *request.Request, output *UpdateWorkflowOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/workflow/{id}",
	}

	if input == nil {
		input = &UpdateWorkflowInput{}
	}

	output = &UpdateWorkflowOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("workflows-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateWorkflow API operation for Amazon Omics.
//
// Updates a workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation UpdateWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     The request cannot be applied to the target resource in its current state.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateWorkflow
func (c *Omics) UpdateWorkflow(input *UpdateWorkflowInput) (*UpdateWorkflowOutput, error) {
	req, out := c.UpdateWorkflowRequest(input)
	return out, req.Send()
}

// UpdateWorkflowWithContext is the same as UpdateWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) UpdateWorkflowWithContext(ctx aws.Context, input *UpdateWorkflowInput, opts ...request.Option) (*UpdateWorkflowOutput, error) {
	req, out := c.UpdateWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUploadReadSetPart = "UploadReadSetPart"

// UploadReadSetPartRequest generates a "aws/request.Request" representing the
// client's request for the UploadReadSetPart operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UploadReadSetPart for more information on using the UploadReadSetPart
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UploadReadSetPartRequest method.
//	req, resp := client.UploadReadSetPartRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UploadReadSetPart
func (c *Omics) UploadReadSetPartRequest(input *UploadReadSetPartInput) (req *request.Request, output *UploadReadSetPartOutput) {
	op := &request.Operation{
		Name:       opUploadReadSetPart,
		HTTPMethod: "PUT",
		HTTPPath:   "/sequencestore/{sequenceStoreId}/upload/{uploadId}/part",
	}

	if input == nil {
		input = &UploadReadSetPartInput{}
	}

	output = &UploadReadSetPartOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Sign.Remove(v4.SignRequestHandler)
	handler := v4.BuildNamedHandler("v4.CustomSignerHandler", v4.WithUnsignedPayload)
	req.Handlers.Sign.PushFrontNamed(handler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("storage-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UploadReadSetPart API operation for Amazon Omics.
//
// This operation uploads a specific part of a read set. If you upload a new
// part using a previously used part number, the previously uploaded part will
// be overwritten.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Omics's
// API operation UploadReadSetPart for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred. Try the request again.
//
//   - NotSupportedOperationException
//     The operation is not supported by Amazon Omics, or the API does not exist.
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The target resource was not found in the current Region.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - RequestTimeoutException
//     The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UploadReadSetPart
func (c *Omics) UploadReadSetPart(input *UploadReadSetPartInput) (*UploadReadSetPartOutput, error) {
	req, out := c.UploadReadSetPartRequest(input)
	return out, req.Send()
}

// UploadReadSetPartWithContext is the same as UploadReadSetPart with the addition of
// the ability to pass a context and additional request options.
//
// See UploadReadSetPart for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) UploadReadSetPartWithContext(ctx aws.Context, input *UploadReadSetPartInput, opts ...request.Option) (*UploadReadSetPartOutput, error) {
	req, out := c.UploadReadSetPartRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AbortMultipartReadSetUploadInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The sequence store ID for the store involved in the multipart upload.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The ID for the multipart upload.
	//
	// UploadId is a required field
	UploadId *string `location:"uri" locationName:"uploadId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AbortMultipartReadSetUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AbortMultipartReadSetUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AbortMultipartReadSetUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AbortMultipartReadSetUploadInput"}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}
	if s.UploadId != nil && len(*s.UploadId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("UploadId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *AbortMultipartReadSetUploadInput) SetSequenceStoreId(v string) *AbortMultipartReadSetUploadInput {
	s.SequenceStoreId = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *AbortMultipartReadSetUploadInput) SetUploadId(v string) *AbortMultipartReadSetUploadInput {
	s.UploadId = &v
	return s
}

type AbortMultipartReadSetUploadOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AbortMultipartReadSetUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AbortMultipartReadSetUploadOutput) GoString() string {
	return s.String()
}

type AcceptShareInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for a share offer for analytics store data.
	//
	// ShareId is a required field
	ShareId *string `location:"uri" locationName:"shareId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptShareInput"}
	if s.ShareId == nil {
		invalidParams.Add(request.NewErrParamRequired("ShareId"))
	}
	if s.ShareId != nil && len(*s.ShareId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShareId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShareId sets the ShareId field's value.
func (s *AcceptShareInput) SetShareId(v string) *AcceptShareInput {
	s.ShareId = &v
	return s
}

type AcceptShareOutput struct {
	_ struct{} `type:"structure"`

	// The status of an analytics store share.
	Status *string `locationName:"status" type:"string" enum:"ShareStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptShareOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *AcceptShareOutput) SetStatus(v string) *AcceptShareOutput {
	s.Status = &v
	return s
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A read set activation job filter.
type ActivateReadSetFilter struct {
	_ struct{} `type:"structure"`

	// The filter's start date.
	CreatedAfter *time.Time `locationName:"createdAfter" type:"timestamp" timestampFormat:"iso8601"`

	// The filter's end date.
	CreatedBefore *time.Time `locationName:"createdBefore" type:"timestamp" timestampFormat:"iso8601"`

	// The filter's status.
	Status *string `locationName:"status" type:"string" enum:"ReadSetActivationJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateReadSetFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateReadSetFilter) GoString() string {
	return s.String()
}

// SetCreatedAfter sets the CreatedAfter field's value.
func (s *ActivateReadSetFilter) SetCreatedAfter(v time.Time) *ActivateReadSetFilter {
	s.CreatedAfter = &v
	return s
}

// SetCreatedBefore sets the CreatedBefore field's value.
func (s *ActivateReadSetFilter) SetCreatedBefore(v time.Time) *ActivateReadSetFilter {
	s.CreatedBefore = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ActivateReadSetFilter) SetStatus(v string) *ActivateReadSetFilter {
	s.Status = &v
	return s
}

// A read set activation job.
type ActivateReadSetJobItem struct {
	_ struct{} `type:"structure"`

	// When the job completed.
	CompletionTime *time.Time `locationName:"completionTime" type:"timestamp" timestampFormat:"iso8601"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The job's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The job's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReadSetActivationJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateReadSetJobItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateReadSetJobItem) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *ActivateReadSetJobItem) SetCompletionTime(v time.Time) *ActivateReadSetJobItem {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ActivateReadSetJobItem) SetCreationTime(v time.Time) *ActivateReadSetJobItem {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *ActivateReadSetJobItem) SetId(v string) *ActivateReadSetJobItem {
	s.Id = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *ActivateReadSetJobItem) SetSequenceStoreId(v string) *ActivateReadSetJobItem {
	s.SequenceStoreId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ActivateReadSetJobItem) SetStatus(v string) *ActivateReadSetJobItem {
	s.Status = &v
	return s
}

// A source for a read set activation job.
type ActivateReadSetSourceItem struct {
	_ struct{} `type:"structure"`

	// The source's read set ID.
	//
	// ReadSetId is a required field
	ReadSetId *string `locationName:"readSetId" min:"10" type:"string" required:"true"`

	// The source's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReadSetActivationJobItemStatus"`

	// The source's status message.
	StatusMessage *string `locationName:"statusMessage" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateReadSetSourceItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateReadSetSourceItem) GoString() string {
	return s.String()
}

// SetReadSetId sets the ReadSetId field's value.
func (s *ActivateReadSetSourceItem) SetReadSetId(v string) *ActivateReadSetSourceItem {
	s.ReadSetId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ActivateReadSetSourceItem) SetStatus(v string) *ActivateReadSetSourceItem {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ActivateReadSetSourceItem) SetStatusMessage(v string) *ActivateReadSetSourceItem {
	s.StatusMessage = &v
	return s
}

// Details about an imported annotation item.
type AnnotationImportItemDetail struct {
	_ struct{} `type:"structure"`

	// The item's job status.
	//
	// JobStatus is a required field
	JobStatus *string `locationName:"jobStatus" type:"string" required:"true" enum:"JobStatus"`

	// The source file's location in Amazon S3.
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnnotationImportItemDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnnotationImportItemDetail) GoString() string {
	return s.String()
}

// SetJobStatus sets the JobStatus field's value.
func (s *AnnotationImportItemDetail) SetJobStatus(v string) *AnnotationImportItemDetail {
	s.JobStatus = &v
	return s
}

// SetSource sets the Source field's value.
func (s *AnnotationImportItemDetail) SetSource(v string) *AnnotationImportItemDetail {
	s.Source = &v
	return s
}

// A source for an annotation import job.
type AnnotationImportItemSource struct {
	_ struct{} `type:"structure"`

	// The source file's location in Amazon S3.
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnnotationImportItemSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnnotationImportItemSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnnotationImportItemSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnnotationImportItemSource"}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSource sets the Source field's value.
func (s *AnnotationImportItemSource) SetSource(v string) *AnnotationImportItemSource {
	s.Source = &v
	return s
}

// An annotation import job.
type AnnotationImportJobItem struct {
	_ struct{} `type:"structure"`

	// The annotation schema generated by the parsed annotation data.
	AnnotationFields map[string]*string `locationName:"annotationFields" type:"map"`

	// When the job completed.
	CompletionTime *time.Time `locationName:"completionTime" type:"timestamp" timestampFormat:"iso8601"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The job's destination annotation store.
	//
	// DestinationName is a required field
	DestinationName *string `locationName:"destinationName" type:"string" required:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The job's service role ARN.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The job's left normalization setting.
	RunLeftNormalization *bool `locationName:"runLeftNormalization" type:"boolean"`

	// The job's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"JobStatus"`

	// When the job was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the annotation store version.
	//
	// VersionName is a required field
	VersionName *string `locationName:"versionName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnnotationImportJobItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnnotationImportJobItem) GoString() string {
	return s.String()
}

// SetAnnotationFields sets the AnnotationFields field's value.
func (s *AnnotationImportJobItem) SetAnnotationFields(v map[string]*string) *AnnotationImportJobItem {
	s.AnnotationFields = v
	return s
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *AnnotationImportJobItem) SetCompletionTime(v time.Time) *AnnotationImportJobItem {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AnnotationImportJobItem) SetCreationTime(v time.Time) *AnnotationImportJobItem {
	s.CreationTime = &v
	return s
}

// SetDestinationName sets the DestinationName field's value.
func (s *AnnotationImportJobItem) SetDestinationName(v string) *AnnotationImportJobItem {
	s.DestinationName = &v
	return s
}

// SetId sets the Id field's value.
func (s *AnnotationImportJobItem) SetId(v string) *AnnotationImportJobItem {
	s.Id = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AnnotationImportJobItem) SetRoleArn(v string) *AnnotationImportJobItem {
	s.RoleArn = &v
	return s
}

// SetRunLeftNormalization sets the RunLeftNormalization field's value.
func (s *AnnotationImportJobItem) SetRunLeftNormalization(v bool) *AnnotationImportJobItem {
	s.RunLeftNormalization = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AnnotationImportJobItem) SetStatus(v string) *AnnotationImportJobItem {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *AnnotationImportJobItem) SetUpdateTime(v time.Time) *AnnotationImportJobItem {
	s.UpdateTime = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *AnnotationImportJobItem) SetVersionName(v string) *AnnotationImportJobItem {
	s.VersionName = &v
	return s
}

// An annotation store.
type AnnotationStoreItem struct {
	_ struct{} `type:"structure"`

	// The store's creation time.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The store's description.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The store's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The store's name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The store's genome reference.
	//
	// Reference is a required field
	Reference *ReferenceItem `locationName:"reference" type:"structure" required:"true"`

	// The store's server-side encryption (SSE) settings.
	//
	// SseConfig is a required field
	SseConfig *SseConfig `locationName:"sseConfig" type:"structure" required:"true"`

	// The store's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"StoreStatus"`

	// The store's status message.
	//
	// StatusMessage is a required field
	StatusMessage *string `locationName:"statusMessage" type:"string" required:"true"`

	// The store's ARN.
	//
	// StoreArn is a required field
	StoreArn *string `locationName:"storeArn" min:"20" type:"string" required:"true"`

	// The store's file format.
	//
	// StoreFormat is a required field
	StoreFormat *string `locationName:"storeFormat" type:"string" required:"true" enum:"StoreFormat"`

	// The store's size in bytes.
	//
	// StoreSizeBytes is a required field
	StoreSizeBytes *int64 `locationName:"storeSizeBytes" type:"long" required:"true"`

	// When the store was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnnotationStoreItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnnotationStoreItem) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *AnnotationStoreItem) SetCreationTime(v time.Time) *AnnotationStoreItem {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AnnotationStoreItem) SetDescription(v string) *AnnotationStoreItem {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *AnnotationStoreItem) SetId(v string) *AnnotationStoreItem {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AnnotationStoreItem) SetName(v string) *AnnotationStoreItem {
	s.Name = &v
	return s
}

// SetReference sets the Reference field's value.
func (s *AnnotationStoreItem) SetReference(v *ReferenceItem) *AnnotationStoreItem {
	s.Reference = v
	return s
}

// SetSseConfig sets the SseConfig field's value.
func (s *AnnotationStoreItem) SetSseConfig(v *SseConfig) *AnnotationStoreItem {
	s.SseConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AnnotationStoreItem) SetStatus(v string) *AnnotationStoreItem {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *AnnotationStoreItem) SetStatusMessage(v string) *AnnotationStoreItem {
	s.StatusMessage = &v
	return s
}

// SetStoreArn sets the StoreArn field's value.
func (s *AnnotationStoreItem) SetStoreArn(v string) *AnnotationStoreItem {
	s.StoreArn = &v
	return s
}

// SetStoreFormat sets the StoreFormat field's value.
func (s *AnnotationStoreItem) SetStoreFormat(v string) *AnnotationStoreItem {
	s.StoreFormat = &v
	return s
}

// SetStoreSizeBytes sets the StoreSizeBytes field's value.
func (s *AnnotationStoreItem) SetStoreSizeBytes(v int64) *AnnotationStoreItem {
	s.StoreSizeBytes = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *AnnotationStoreItem) SetUpdateTime(v time.Time) *AnnotationStoreItem {
	s.UpdateTime = &v
	return s
}

// Annotation store versions.
type AnnotationStoreVersionItem struct {
	_ struct{} `type:"structure"`

	// The time stamp for when an annotation store version was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of an annotation store version.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The annotation store version ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// A name given to an annotation store version to distinguish it from others.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The status of an annotation store version.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"VersionStatus"`

	// The status of an annotation store version.
	//
	// StatusMessage is a required field
	StatusMessage *string `locationName:"statusMessage" type:"string" required:"true"`

	// The store ID for an annotation store version.
	//
	// StoreId is a required field
	StoreId *string `locationName:"storeId" type:"string" required:"true"`

	// The time stamp for when an annotation store version was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Arn for an annotation store version.
	//
	// VersionArn is a required field
	VersionArn *string `locationName:"versionArn" min:"20" type:"string" required:"true"`

	// The name of an annotation store version.
	//
	// VersionName is a required field
	VersionName *string `locationName:"versionName" min:"3" type:"string" required:"true"`

	// The size of an annotation store version in Bytes.
	//
	// VersionSizeBytes is a required field
	VersionSizeBytes *int64 `locationName:"versionSizeBytes" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnnotationStoreVersionItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnnotationStoreVersionItem) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *AnnotationStoreVersionItem) SetCreationTime(v time.Time) *AnnotationStoreVersionItem {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AnnotationStoreVersionItem) SetDescription(v string) *AnnotationStoreVersionItem {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *AnnotationStoreVersionItem) SetId(v string) *AnnotationStoreVersionItem {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AnnotationStoreVersionItem) SetName(v string) *AnnotationStoreVersionItem {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AnnotationStoreVersionItem) SetStatus(v string) *AnnotationStoreVersionItem {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *AnnotationStoreVersionItem) SetStatusMessage(v string) *AnnotationStoreVersionItem {
	s.StatusMessage = &v
	return s
}

// SetStoreId sets the StoreId field's value.
func (s *AnnotationStoreVersionItem) SetStoreId(v string) *AnnotationStoreVersionItem {
	s.StoreId = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *AnnotationStoreVersionItem) SetUpdateTime(v time.Time) *AnnotationStoreVersionItem {
	s.UpdateTime = &v
	return s
}

// SetVersionArn sets the VersionArn field's value.
func (s *AnnotationStoreVersionItem) SetVersionArn(v string) *AnnotationStoreVersionItem {
	s.VersionArn = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *AnnotationStoreVersionItem) SetVersionName(v string) *AnnotationStoreVersionItem {
	s.VersionName = &v
	return s
}

// SetVersionSizeBytes sets the VersionSizeBytes field's value.
func (s *AnnotationStoreVersionItem) SetVersionSizeBytes(v int64) *AnnotationStoreVersionItem {
	s.VersionSizeBytes = &v
	return s
}

type BatchDeleteReadSetInput struct {
	_ struct{} `type:"structure"`

	// The read sets' IDs.
	//
	// Ids is a required field
	Ids []*string `locationName:"ids" min:"1" type:"list" required:"true"`

	// The read sets' sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteReadSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteReadSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteReadSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteReadSetInput"}
	if s.Ids == nil {
		invalidParams.Add(request.NewErrParamRequired("Ids"))
	}
	if s.Ids != nil && len(s.Ids) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ids", 1))
	}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIds sets the Ids field's value.
func (s *BatchDeleteReadSetInput) SetIds(v []*string) *BatchDeleteReadSetInput {
	s.Ids = v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *BatchDeleteReadSetInput) SetSequenceStoreId(v string) *BatchDeleteReadSetInput {
	s.SequenceStoreId = &v
	return s
}

type BatchDeleteReadSetOutput struct {
	_ struct{} `type:"structure"`

	// Errors returned by individual delete operations.
	Errors []*ReadSetBatchError `locationName:"errors" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteReadSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteReadSetOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDeleteReadSetOutput) SetErrors(v []*ReadSetBatchError) *BatchDeleteReadSetOutput {
	s.Errors = v
	return s
}

type CancelAnnotationImportJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The job's ID.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelAnnotationImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelAnnotationImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelAnnotationImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelAnnotationImportJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *CancelAnnotationImportJobInput) SetJobId(v string) *CancelAnnotationImportJobInput {
	s.JobId = &v
	return s
}

type CancelAnnotationImportJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelAnnotationImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelAnnotationImportJobOutput) GoString() string {
	return s.String()
}

type CancelRunInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The run's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelRunInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *CancelRunInput) SetId(v string) *CancelRunInput {
	s.Id = &v
	return s
}

type CancelRunOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelRunOutput) GoString() string {
	return s.String()
}

type CancelVariantImportJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The job's ID.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelVariantImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelVariantImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelVariantImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelVariantImportJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *CancelVariantImportJobInput) SetJobId(v string) *CancelVariantImportJobInput {
	s.JobId = &v
	return s
}

type CancelVariantImportJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelVariantImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelVariantImportJobOutput) GoString() string {
	return s.String()
}

type CompleteMultipartReadSetUploadInput struct {
	_ struct{} `type:"structure"`

	// The individual uploads or parts of a multipart upload.
	//
	// Parts is a required field
	Parts []*CompleteReadSetUploadPartListItem `locationName:"parts" type:"list" required:"true"`

	// The sequence store ID for the store involved in the multipart upload.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The ID for the multipart upload.
	//
	// UploadId is a required field
	UploadId *string `location:"uri" locationName:"uploadId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteMultipartReadSetUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteMultipartReadSetUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteMultipartReadSetUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompleteMultipartReadSetUploadInput"}
	if s.Parts == nil {
		invalidParams.Add(request.NewErrParamRequired("Parts"))
	}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}
	if s.UploadId != nil && len(*s.UploadId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("UploadId", 10))
	}
	if s.Parts != nil {
		for i, v := range s.Parts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Parts", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParts sets the Parts field's value.
func (s *CompleteMultipartReadSetUploadInput) SetParts(v []*CompleteReadSetUploadPartListItem) *CompleteMultipartReadSetUploadInput {
	s.Parts = v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *CompleteMultipartReadSetUploadInput) SetSequenceStoreId(v string) *CompleteMultipartReadSetUploadInput {
	s.SequenceStoreId = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *CompleteMultipartReadSetUploadInput) SetUploadId(v string) *CompleteMultipartReadSetUploadInput {
	s.UploadId = &v
	return s
}

type CompleteMultipartReadSetUploadOutput struct {
	_ struct{} `type:"structure"`

	// The read set ID created for an uploaded read set.
	//
	// ReadSetId is a required field
	ReadSetId *string `locationName:"readSetId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteMultipartReadSetUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteMultipartReadSetUploadOutput) GoString() string {
	return s.String()
}

// SetReadSetId sets the ReadSetId field's value.
func (s *CompleteMultipartReadSetUploadOutput) SetReadSetId(v string) *CompleteMultipartReadSetUploadOutput {
	s.ReadSetId = &v
	return s
}

// Part of the response to the CompleteReadSetUpload API, including metadata.
type CompleteReadSetUploadPartListItem struct {
	_ struct{} `type:"structure"`

	// A unique identifier used to confirm that parts are being added to the correct
	// upload.
	//
	// Checksum is a required field
	Checksum *string `locationName:"checksum" type:"string" required:"true"`

	// A number identifying the part in a read set upload.
	//
	// PartNumber is a required field
	PartNumber *int64 `locationName:"partNumber" min:"1" type:"integer" required:"true"`

	// The source file of the part being uploaded.
	//
	// PartSource is a required field
	PartSource *string `locationName:"partSource" type:"string" required:"true" enum:"ReadSetPartSource"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteReadSetUploadPartListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteReadSetUploadPartListItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteReadSetUploadPartListItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompleteReadSetUploadPartListItem"}
	if s.Checksum == nil {
		invalidParams.Add(request.NewErrParamRequired("Checksum"))
	}
	if s.PartNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PartNumber"))
	}
	if s.PartNumber != nil && *s.PartNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PartNumber", 1))
	}
	if s.PartSource == nil {
		invalidParams.Add(request.NewErrParamRequired("PartSource"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChecksum sets the Checksum field's value.
func (s *CompleteReadSetUploadPartListItem) SetChecksum(v string) *CompleteReadSetUploadPartListItem {
	s.Checksum = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *CompleteReadSetUploadPartListItem) SetPartNumber(v int64) *CompleteReadSetUploadPartListItem {
	s.PartNumber = &v
	return s
}

// SetPartSource sets the PartSource field's value.
func (s *CompleteReadSetUploadPartListItem) SetPartSource(v string) *CompleteReadSetUploadPartListItem {
	s.PartSource = &v
	return s
}

// The request cannot be applied to the target resource in its current state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAnnotationStoreInput struct {
	_ struct{} `type:"structure"`

	// A description for the store.
	Description *string `locationName:"description" type:"string"`

	// A name for the store.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The genome reference for the store's annotations.
	Reference *ReferenceItem `locationName:"reference" type:"structure"`

	// Server-side encryption (SSE) settings for the store.
	SseConfig *SseConfig `locationName:"sseConfig" type:"structure"`

	// The annotation file format of the store.
	//
	// StoreFormat is a required field
	StoreFormat *string `locationName:"storeFormat" type:"string" required:"true" enum:"StoreFormat"`

	// File parsing options for the annotation store.
	StoreOptions *StoreOptions `locationName:"storeOptions" type:"structure"`

	// Tags for the store.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The name given to an annotation store version to distinguish it from other
	// versions.
	VersionName *string `locationName:"versionName" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnnotationStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnnotationStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAnnotationStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAnnotationStoreInput"}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.StoreFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("StoreFormat"))
	}
	if s.VersionName != nil && len(*s.VersionName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("VersionName", 3))
	}
	if s.Reference != nil {
		if err := s.Reference.Validate(); err != nil {
			invalidParams.AddNested("Reference", err.(request.ErrInvalidParams))
		}
	}
	if s.SseConfig != nil {
		if err := s.SseConfig.Validate(); err != nil {
			invalidParams.AddNested("SseConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.StoreOptions != nil {
		if err := s.StoreOptions.Validate(); err != nil {
			invalidParams.AddNested("StoreOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateAnnotationStoreInput) SetDescription(v string) *CreateAnnotationStoreInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAnnotationStoreInput) SetName(v string) *CreateAnnotationStoreInput {
	s.Name = &v
	return s
}

// SetReference sets the Reference field's value.
func (s *CreateAnnotationStoreInput) SetReference(v *ReferenceItem) *CreateAnnotationStoreInput {
	s.Reference = v
	return s
}

// SetSseConfig sets the SseConfig field's value.
func (s *CreateAnnotationStoreInput) SetSseConfig(v *SseConfig) *CreateAnnotationStoreInput {
	s.SseConfig = v
	return s
}

// SetStoreFormat sets the StoreFormat field's value.
func (s *CreateAnnotationStoreInput) SetStoreFormat(v string) *CreateAnnotationStoreInput {
	s.StoreFormat = &v
	return s
}

// SetStoreOptions sets the StoreOptions field's value.
func (s *CreateAnnotationStoreInput) SetStoreOptions(v *StoreOptions) *CreateAnnotationStoreInput {
	s.StoreOptions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAnnotationStoreInput) SetTags(v map[string]*string) *CreateAnnotationStoreInput {
	s.Tags = v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *CreateAnnotationStoreInput) SetVersionName(v string) *CreateAnnotationStoreInput {
	s.VersionName = &v
	return s
}

type CreateAnnotationStoreOutput struct {
	_ struct{} `type:"structure"`

	// When the store was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The store's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The store's name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The store's genome reference. Required for all stores except TSV format with
	// generic annotations.
	Reference *ReferenceItem `locationName:"reference" type:"structure"`

	// The store's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"StoreStatus"`

	// The annotation file format of the store.
	StoreFormat *string `locationName:"storeFormat" type:"string" enum:"StoreFormat"`

	// The store's file parsing options.
	StoreOptions *StoreOptions `locationName:"storeOptions" type:"structure"`

	// The name given to an annotation store version to distinguish it from other
	// versions.
	//
	// VersionName is a required field
	VersionName *string `locationName:"versionName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnnotationStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnnotationStoreOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateAnnotationStoreOutput) SetCreationTime(v time.Time) *CreateAnnotationStoreOutput {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateAnnotationStoreOutput) SetId(v string) *CreateAnnotationStoreOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAnnotationStoreOutput) SetName(v string) *CreateAnnotationStoreOutput {
	s.Name = &v
	return s
}

// SetReference sets the Reference field's value.
func (s *CreateAnnotationStoreOutput) SetReference(v *ReferenceItem) *CreateAnnotationStoreOutput {
	s.Reference = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateAnnotationStoreOutput) SetStatus(v string) *CreateAnnotationStoreOutput {
	s.Status = &v
	return s
}

// SetStoreFormat sets the StoreFormat field's value.
func (s *CreateAnnotationStoreOutput) SetStoreFormat(v string) *CreateAnnotationStoreOutput {
	s.StoreFormat = &v
	return s
}

// SetStoreOptions sets the StoreOptions field's value.
func (s *CreateAnnotationStoreOutput) SetStoreOptions(v *StoreOptions) *CreateAnnotationStoreOutput {
	s.StoreOptions = v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *CreateAnnotationStoreOutput) SetVersionName(v string) *CreateAnnotationStoreOutput {
	s.VersionName = &v
	return s
}

type CreateAnnotationStoreVersionInput struct {
	_ struct{} `type:"structure"`

	// The description of an annotation store version.
	Description *string `locationName:"description" type:"string"`

	// The name of an annotation store version from which versions are being created.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// Any tags added to annotation store version.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The name given to an annotation store version to distinguish it from other
	// versions.
	//
	// VersionName is a required field
	VersionName *string `locationName:"versionName" min:"3" type:"string" required:"true"`

	// The options for an annotation store version.
	VersionOptions *VersionOptions `locationName:"versionOptions" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnnotationStoreVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnnotationStoreVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAnnotationStoreVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAnnotationStoreVersionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.VersionName == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionName"))
	}
	if s.VersionName != nil && len(*s.VersionName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("VersionName", 3))
	}
	if s.VersionOptions != nil {
		if err := s.VersionOptions.Validate(); err != nil {
			invalidParams.AddNested("VersionOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateAnnotationStoreVersionInput) SetDescription(v string) *CreateAnnotationStoreVersionInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAnnotationStoreVersionInput) SetName(v string) *CreateAnnotationStoreVersionInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAnnotationStoreVersionInput) SetTags(v map[string]*string) *CreateAnnotationStoreVersionInput {
	s.Tags = v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *CreateAnnotationStoreVersionInput) SetVersionName(v string) *CreateAnnotationStoreVersionInput {
	s.VersionName = &v
	return s
}

// SetVersionOptions sets the VersionOptions field's value.
func (s *CreateAnnotationStoreVersionInput) SetVersionOptions(v *VersionOptions) *CreateAnnotationStoreVersionInput {
	s.VersionOptions = v
	return s
}

type CreateAnnotationStoreVersionOutput struct {
	_ struct{} `type:"structure"`

	// The time stamp for the creation of an annotation store version.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A generated ID for the annotation store
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name given to an annotation store version to distinguish it from other
	// versions.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The status of a annotation store version.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"VersionStatus"`

	// The ID for the annotation store from which new versions are being created.
	//
	// StoreId is a required field
	StoreId *string `locationName:"storeId" type:"string" required:"true"`

	// The name given to an annotation store version to distinguish it from other
	// versions.
	//
	// VersionName is a required field
	VersionName *string `locationName:"versionName" min:"3" type:"string" required:"true"`

	// The options for an annotation store version.
	VersionOptions *VersionOptions `locationName:"versionOptions" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnnotationStoreVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnnotationStoreVersionOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateAnnotationStoreVersionOutput) SetCreationTime(v time.Time) *CreateAnnotationStoreVersionOutput {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateAnnotationStoreVersionOutput) SetId(v string) *CreateAnnotationStoreVersionOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAnnotationStoreVersionOutput) SetName(v string) *CreateAnnotationStoreVersionOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateAnnotationStoreVersionOutput) SetStatus(v string) *CreateAnnotationStoreVersionOutput {
	s.Status = &v
	return s
}

// SetStoreId sets the StoreId field's value.
func (s *CreateAnnotationStoreVersionOutput) SetStoreId(v string) *CreateAnnotationStoreVersionOutput {
	s.StoreId = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *CreateAnnotationStoreVersionOutput) SetVersionName(v string) *CreateAnnotationStoreVersionOutput {
	s.VersionName = &v
	return s
}

// SetVersionOptions sets the VersionOptions field's value.
func (s *CreateAnnotationStoreVersionOutput) SetVersionOptions(v *VersionOptions) *CreateAnnotationStoreVersionOutput {
	s.VersionOptions = v
	return s
}

type CreateMultipartReadSetUploadInput struct {
	_ struct{} `type:"structure"`

	// An idempotency token that can be used to avoid triggering multiple multipart
	// uploads.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The description of the read set.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Where the source originated.
	GeneratedFrom *string `locationName:"generatedFrom" min:"1" type:"string"`

	// The name of the read set.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The ARN of the reference.
	ReferenceArn *string `locationName:"referenceArn" min:"1" type:"string"`

	// The source's sample ID.
	//
	// SampleId is a required field
	SampleId *string `locationName:"sampleId" min:"1" type:"string" required:"true"`

	// The sequence store ID for the store that is the destination of the multipart
	// uploads.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The type of file being uploaded.
	//
	// SourceFileType is a required field
	SourceFileType *string `locationName:"sourceFileType" type:"string" required:"true" enum:"FileType"`

	// The source's subject ID.
	//
	// SubjectId is a required field
	SubjectId *string `locationName:"subjectId" min:"1" type:"string" required:"true"`

	// Any tags to add to the read set.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultipartReadSetUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultipartReadSetUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMultipartReadSetUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMultipartReadSetUploadInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.GeneratedFrom != nil && len(*s.GeneratedFrom) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GeneratedFrom", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ReferenceArn != nil && len(*s.ReferenceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReferenceArn", 1))
	}
	if s.SampleId == nil {
		invalidParams.Add(request.NewErrParamRequired("SampleId"))
	}
	if s.SampleId != nil && len(*s.SampleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SampleId", 1))
	}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}
	if s.SourceFileType == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceFileType"))
	}
	if s.SubjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubjectId"))
	}
	if s.SubjectId != nil && len(*s.SubjectId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubjectId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateMultipartReadSetUploadInput) SetClientToken(v string) *CreateMultipartReadSetUploadInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateMultipartReadSetUploadInput) SetDescription(v string) *CreateMultipartReadSetUploadInput {
	s.Description = &v
	return s
}

// SetGeneratedFrom sets the GeneratedFrom field's value.
func (s *CreateMultipartReadSetUploadInput) SetGeneratedFrom(v string) *CreateMultipartReadSetUploadInput {
	s.GeneratedFrom = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateMultipartReadSetUploadInput) SetName(v string) *CreateMultipartReadSetUploadInput {
	s.Name = &v
	return s
}

// SetReferenceArn sets the ReferenceArn field's value.
func (s *CreateMultipartReadSetUploadInput) SetReferenceArn(v string) *CreateMultipartReadSetUploadInput {
	s.ReferenceArn = &v
	return s
}

// SetSampleId sets the SampleId field's value.
func (s *CreateMultipartReadSetUploadInput) SetSampleId(v string) *CreateMultipartReadSetUploadInput {
	s.SampleId = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *CreateMultipartReadSetUploadInput) SetSequenceStoreId(v string) *CreateMultipartReadSetUploadInput {
	s.SequenceStoreId = &v
	return s
}

// SetSourceFileType sets the SourceFileType field's value.
func (s *CreateMultipartReadSetUploadInput) SetSourceFileType(v string) *CreateMultipartReadSetUploadInput {
	s.SourceFileType = &v
	return s
}

// SetSubjectId sets the SubjectId field's value.
func (s *CreateMultipartReadSetUploadInput) SetSubjectId(v string) *CreateMultipartReadSetUploadInput {
	s.SubjectId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMultipartReadSetUploadInput) SetTags(v map[string]*string) *CreateMultipartReadSetUploadInput {
	s.Tags = v
	return s
}

type CreateMultipartReadSetUploadOutput struct {
	_ struct{} `type:"structure"`

	// The creation time of the multipart upload.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the read set.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The source of the read set.
	GeneratedFrom *string `locationName:"generatedFrom" min:"1" type:"string"`

	// The name of the read set.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The read set source's reference ARN.
	//
	// ReferenceArn is a required field
	ReferenceArn *string `locationName:"referenceArn" min:"1" type:"string" required:"true"`

	// The source's sample ID.
	//
	// SampleId is a required field
	SampleId *string `locationName:"sampleId" min:"1" type:"string" required:"true"`

	// The sequence store ID for the store that the read set will be created in.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The file type of the read set source.
	//
	// SourceFileType is a required field
	SourceFileType *string `locationName:"sourceFileType" type:"string" required:"true" enum:"FileType"`

	// The source's subject ID.
	//
	// SubjectId is a required field
	SubjectId *string `locationName:"subjectId" min:"1" type:"string" required:"true"`

	// The tags to add to the read set.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// he ID for the initiated multipart upload.
	//
	// UploadId is a required field
	UploadId *string `locationName:"uploadId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultipartReadSetUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultipartReadSetUploadOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateMultipartReadSetUploadOutput) SetCreationTime(v time.Time) *CreateMultipartReadSetUploadOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateMultipartReadSetUploadOutput) SetDescription(v string) *CreateMultipartReadSetUploadOutput {
	s.Description = &v
	return s
}

// SetGeneratedFrom sets the GeneratedFrom field's value.
func (s *CreateMultipartReadSetUploadOutput) SetGeneratedFrom(v string) *CreateMultipartReadSetUploadOutput {
	s.GeneratedFrom = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateMultipartReadSetUploadOutput) SetName(v string) *CreateMultipartReadSetUploadOutput {
	s.Name = &v
	return s
}

// SetReferenceArn sets the ReferenceArn field's value.
func (s *CreateMultipartReadSetUploadOutput) SetReferenceArn(v string) *CreateMultipartReadSetUploadOutput {
	s.ReferenceArn = &v
	return s
}

// SetSampleId sets the SampleId field's value.
func (s *CreateMultipartReadSetUploadOutput) SetSampleId(v string) *CreateMultipartReadSetUploadOutput {
	s.SampleId = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *CreateMultipartReadSetUploadOutput) SetSequenceStoreId(v string) *CreateMultipartReadSetUploadOutput {
	s.SequenceStoreId = &v
	return s
}

// SetSourceFileType sets the SourceFileType field's value.
func (s *CreateMultipartReadSetUploadOutput) SetSourceFileType(v string) *CreateMultipartReadSetUploadOutput {
	s.SourceFileType = &v
	return s
}

// SetSubjectId sets the SubjectId field's value.
func (s *CreateMultipartReadSetUploadOutput) SetSubjectId(v string) *CreateMultipartReadSetUploadOutput {
	s.SubjectId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMultipartReadSetUploadOutput) SetTags(v map[string]*string) *CreateMultipartReadSetUploadOutput {
	s.Tags = v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *CreateMultipartReadSetUploadOutput) SetUploadId(v string) *CreateMultipartReadSetUploadOutput {
	s.UploadId = &v
	return s
}

type CreateReferenceStoreInput struct {
	_ struct{} `type:"structure"`

	// To ensure that requests don't run multiple times, specify a unique token
	// for each request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// A description for the store.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A name for the store.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Server-side encryption (SSE) settings for the store.
	SseConfig *SseConfig `locationName:"sseConfig" type:"structure"`

	// Tags for the store.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReferenceStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReferenceStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReferenceStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReferenceStoreInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SseConfig != nil {
		if err := s.SseConfig.Validate(); err != nil {
			invalidParams.AddNested("SseConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateReferenceStoreInput) SetClientToken(v string) *CreateReferenceStoreInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateReferenceStoreInput) SetDescription(v string) *CreateReferenceStoreInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateReferenceStoreInput) SetName(v string) *CreateReferenceStoreInput {
	s.Name = &v
	return s
}

// SetSseConfig sets the SseConfig field's value.
func (s *CreateReferenceStoreInput) SetSseConfig(v *SseConfig) *CreateReferenceStoreInput {
	s.SseConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReferenceStoreInput) SetTags(v map[string]*string) *CreateReferenceStoreInput {
	s.Tags = v
	return s
}

type CreateReferenceStoreOutput struct {
	_ struct{} `type:"structure"`

	// The store's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// When the store was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The store's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The store's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The store's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The store's SSE settings.
	SseConfig *SseConfig `locationName:"sseConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReferenceStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReferenceStoreOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateReferenceStoreOutput) SetArn(v string) *CreateReferenceStoreOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateReferenceStoreOutput) SetCreationTime(v time.Time) *CreateReferenceStoreOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateReferenceStoreOutput) SetDescription(v string) *CreateReferenceStoreOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateReferenceStoreOutput) SetId(v string) *CreateReferenceStoreOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateReferenceStoreOutput) SetName(v string) *CreateReferenceStoreOutput {
	s.Name = &v
	return s
}

// SetSseConfig sets the SseConfig field's value.
func (s *CreateReferenceStoreOutput) SetSseConfig(v *SseConfig) *CreateReferenceStoreOutput {
	s.SseConfig = v
	return s
}

type CreateRunGroupInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of CPUs to use in the group.
	MaxCpus *int64 `locationName:"maxCpus" min:"1" type:"integer"`

	// A maximum run time for the group in minutes.
	MaxDuration *int64 `locationName:"maxDuration" min:"1" type:"integer"`

	// The maximum GPUs that can be used by a run group.
	MaxGpus *int64 `locationName:"maxGpus" min:"1" type:"integer"`

	// The maximum number of concurrent runs for the group.
	MaxRuns *int64 `locationName:"maxRuns" min:"1" type:"integer"`

	// A name for the group.
	Name *string `locationName:"name" min:"1" type:"string"`

	// To ensure that requests don't run multiple times, specify a unique ID for
	// each request.
	RequestId *string `locationName:"requestId" min:"1" type:"string" idempotencyToken:"true"`

	// Tags for the group.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRunGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRunGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRunGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRunGroupInput"}
	if s.MaxCpus != nil && *s.MaxCpus < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxCpus", 1))
	}
	if s.MaxDuration != nil && *s.MaxDuration < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxDuration", 1))
	}
	if s.MaxGpus != nil && *s.MaxGpus < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxGpus", 1))
	}
	if s.MaxRuns != nil && *s.MaxRuns < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRuns", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RequestId != nil && len(*s.RequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxCpus sets the MaxCpus field's value.
func (s *CreateRunGroupInput) SetMaxCpus(v int64) *CreateRunGroupInput {
	s.MaxCpus = &v
	return s
}

// SetMaxDuration sets the MaxDuration field's value.
func (s *CreateRunGroupInput) SetMaxDuration(v int64) *CreateRunGroupInput {
	s.MaxDuration = &v
	return s
}

// SetMaxGpus sets the MaxGpus field's value.
func (s *CreateRunGroupInput) SetMaxGpus(v int64) *CreateRunGroupInput {
	s.MaxGpus = &v
	return s
}

// SetMaxRuns sets the MaxRuns field's value.
func (s *CreateRunGroupInput) SetMaxRuns(v int64) *CreateRunGroupInput {
	s.MaxRuns = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRunGroupInput) SetName(v string) *CreateRunGroupInput {
	s.Name = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateRunGroupInput) SetRequestId(v string) *CreateRunGroupInput {
	s.RequestId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRunGroupInput) SetTags(v map[string]*string) *CreateRunGroupInput {
	s.Tags = v
	return s
}

type CreateRunGroupOutput struct {
	_ struct{} `type:"structure"`

	// The group's ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The group's ID.
	Id *string `locationName:"id" min:"1" type:"string"`

	// Tags for the run group.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRunGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRunGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateRunGroupOutput) SetArn(v string) *CreateRunGroupOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateRunGroupOutput) SetId(v string) *CreateRunGroupOutput {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRunGroupOutput) SetTags(v map[string]*string) *CreateRunGroupOutput {
	s.Tags = v
	return s
}

type CreateSequenceStoreInput struct {
	_ struct{} `type:"structure"`

	// To ensure that requests don't run multiple times, specify a unique token
	// for each request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// A description for the store.
	Description *string `locationName:"description" min:"1" type:"string"`

	// An S3 location that is used to store files that have failed a direct upload.
	FallbackLocation *string `locationName:"fallbackLocation" type:"string"`

	// A name for the store.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Server-side encryption (SSE) settings for the store.
	SseConfig *SseConfig `locationName:"sseConfig" type:"structure"`

	// Tags for the store.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSequenceStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSequenceStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSequenceStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSequenceStoreInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SseConfig != nil {
		if err := s.SseConfig.Validate(); err != nil {
			invalidParams.AddNested("SseConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateSequenceStoreInput) SetClientToken(v string) *CreateSequenceStoreInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSequenceStoreInput) SetDescription(v string) *CreateSequenceStoreInput {
	s.Description = &v
	return s
}

// SetFallbackLocation sets the FallbackLocation field's value.
func (s *CreateSequenceStoreInput) SetFallbackLocation(v string) *CreateSequenceStoreInput {
	s.FallbackLocation = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSequenceStoreInput) SetName(v string) *CreateSequenceStoreInput {
	s.Name = &v
	return s
}

// SetSseConfig sets the SseConfig field's value.
func (s *CreateSequenceStoreInput) SetSseConfig(v *SseConfig) *CreateSequenceStoreInput {
	s.SseConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSequenceStoreInput) SetTags(v map[string]*string) *CreateSequenceStoreInput {
	s.Tags = v
	return s
}

type CreateSequenceStoreOutput struct {
	_ struct{} `type:"structure"`

	// The store's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// When the store was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The store's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// An S3 location that is used to store files that have failed a direct upload.
	FallbackLocation *string `locationName:"fallbackLocation" type:"string"`

	// The store's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The store's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The store's SSE settings.
	SseConfig *SseConfig `locationName:"sseConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSequenceStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSequenceStoreOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateSequenceStoreOutput) SetArn(v string) *CreateSequenceStoreOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateSequenceStoreOutput) SetCreationTime(v time.Time) *CreateSequenceStoreOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSequenceStoreOutput) SetDescription(v string) *CreateSequenceStoreOutput {
	s.Description = &v
	return s
}

// SetFallbackLocation sets the FallbackLocation field's value.
func (s *CreateSequenceStoreOutput) SetFallbackLocation(v string) *CreateSequenceStoreOutput {
	s.FallbackLocation = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateSequenceStoreOutput) SetId(v string) *CreateSequenceStoreOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSequenceStoreOutput) SetName(v string) *CreateSequenceStoreOutput {
	s.Name = &v
	return s
}

// SetSseConfig sets the SseConfig field's value.
func (s *CreateSequenceStoreOutput) SetSseConfig(v *SseConfig) *CreateSequenceStoreOutput {
	s.SseConfig = v
	return s
}

type CreateShareInput struct {
	_ struct{} `type:"structure"`

	// The principal subscriber is the account being given access to the analytics
	// store data through the share offer.
	//
	// PrincipalSubscriber is a required field
	PrincipalSubscriber *string `locationName:"principalSubscriber" type:"string" required:"true"`

	// The resource ARN for the analytics store to be shared.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// A name given to the share.
	ShareName *string `locationName:"shareName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateShareInput"}
	if s.PrincipalSubscriber == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalSubscriber"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ShareName != nil && len(*s.ShareName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShareName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrincipalSubscriber sets the PrincipalSubscriber field's value.
func (s *CreateShareInput) SetPrincipalSubscriber(v string) *CreateShareInput {
	s.PrincipalSubscriber = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CreateShareInput) SetResourceArn(v string) *CreateShareInput {
	s.ResourceArn = &v
	return s
}

// SetShareName sets the ShareName field's value.
func (s *CreateShareInput) SetShareName(v string) *CreateShareInput {
	s.ShareName = &v
	return s
}

type CreateShareOutput struct {
	_ struct{} `type:"structure"`

	// An ID generated for the share.
	ShareId *string `locationName:"shareId" type:"string"`

	// A name given to the share.
	ShareName *string `locationName:"shareName" min:"1" type:"string"`

	// The status of a share.
	Status *string `locationName:"status" type:"string" enum:"ShareStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateShareOutput) GoString() string {
	return s.String()
}

// SetShareId sets the ShareId field's value.
func (s *CreateShareOutput) SetShareId(v string) *CreateShareOutput {
	s.ShareId = &v
	return s
}

// SetShareName sets the ShareName field's value.
func (s *CreateShareOutput) SetShareName(v string) *CreateShareOutput {
	s.ShareName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateShareOutput) SetStatus(v string) *CreateShareOutput {
	s.Status = &v
	return s
}

type CreateVariantStoreInput struct {
	_ struct{} `type:"structure"`

	// A description for the store.
	Description *string `locationName:"description" type:"string"`

	// A name for the store.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The genome reference for the store's variants.
	//
	// Reference is a required field
	Reference *ReferenceItem `locationName:"reference" type:"structure" required:"true"`

	// Server-side encryption (SSE) settings for the store.
	SseConfig *SseConfig `locationName:"sseConfig" type:"structure"`

	// Tags for the store.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVariantStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVariantStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVariantStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVariantStoreInput"}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Reference == nil {
		invalidParams.Add(request.NewErrParamRequired("Reference"))
	}
	if s.Reference != nil {
		if err := s.Reference.Validate(); err != nil {
			invalidParams.AddNested("Reference", err.(request.ErrInvalidParams))
		}
	}
	if s.SseConfig != nil {
		if err := s.SseConfig.Validate(); err != nil {
			invalidParams.AddNested("SseConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateVariantStoreInput) SetDescription(v string) *CreateVariantStoreInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateVariantStoreInput) SetName(v string) *CreateVariantStoreInput {
	s.Name = &v
	return s
}

// SetReference sets the Reference field's value.
func (s *CreateVariantStoreInput) SetReference(v *ReferenceItem) *CreateVariantStoreInput {
	s.Reference = v
	return s
}

// SetSseConfig sets the SseConfig field's value.
func (s *CreateVariantStoreInput) SetSseConfig(v *SseConfig) *CreateVariantStoreInput {
	s.SseConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVariantStoreInput) SetTags(v map[string]*string) *CreateVariantStoreInput {
	s.Tags = v
	return s
}

type CreateVariantStoreOutput struct {
	_ struct{} `type:"structure"`

	// When the store was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The store's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The store's name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The store's genome reference.
	Reference *ReferenceItem `locationName:"reference" type:"structure"`

	// The store's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"StoreStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVariantStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVariantStoreOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateVariantStoreOutput) SetCreationTime(v time.Time) *CreateVariantStoreOutput {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateVariantStoreOutput) SetId(v string) *CreateVariantStoreOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateVariantStoreOutput) SetName(v string) *CreateVariantStoreOutput {
	s.Name = &v
	return s
}

// SetReference sets the Reference field's value.
func (s *CreateVariantStoreOutput) SetReference(v *ReferenceItem) *CreateVariantStoreOutput {
	s.Reference = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateVariantStoreOutput) SetStatus(v string) *CreateVariantStoreOutput {
	s.Status = &v
	return s
}

type CreateWorkflowInput struct {
	_ struct{} `type:"structure"`

	// The computational accelerator specified to run the workflow.
	Accelerators *string `locationName:"accelerators" min:"1" type:"string" enum:"Accelerators"`

	// The URI of a definition for the workflow.
	DefinitionUri *string `locationName:"definitionUri" min:"1" type:"string"`

	// A ZIP archive for the workflow.
	// DefinitionZip is automatically base64 encoded/decoded by the SDK.
	DefinitionZip []byte `locationName:"definitionZip" type:"blob"`

	// A description for the workflow.
	Description *string `locationName:"description" min:"1" type:"string"`

	// An engine for the workflow.
	Engine *string `locationName:"engine" min:"1" type:"string" enum:"WorkflowEngine"`

	// The path of the main definition file for the workflow.
	Main *string `locationName:"main" min:"1" type:"string"`

	// A name for the workflow.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A parameter template for the workflow.
	ParameterTemplate map[string]*WorkflowParameter `locationName:"parameterTemplate" min:"1" type:"map"`

	// To ensure that requests don't run multiple times, specify a unique ID for
	// each request.
	RequestId *string `locationName:"requestId" min:"1" type:"string" idempotencyToken:"true"`

	// A storage capacity for the workflow in gigabytes.
	StorageCapacity *int64 `locationName:"storageCapacity" type:"integer"`

	// Tags for the workflow.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkflowInput"}
	if s.Accelerators != nil && len(*s.Accelerators) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Accelerators", 1))
	}
	if s.DefinitionUri != nil && len(*s.DefinitionUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefinitionUri", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Engine != nil && len(*s.Engine) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Engine", 1))
	}
	if s.Main != nil && len(*s.Main) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Main", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ParameterTemplate != nil && len(s.ParameterTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParameterTemplate", 1))
	}
	if s.RequestId != nil && len(*s.RequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccelerators sets the Accelerators field's value.
func (s *CreateWorkflowInput) SetAccelerators(v string) *CreateWorkflowInput {
	s.Accelerators = &v
	return s
}

// SetDefinitionUri sets the DefinitionUri field's value.
func (s *CreateWorkflowInput) SetDefinitionUri(v string) *CreateWorkflowInput {
	s.DefinitionUri = &v
	return s
}

// SetDefinitionZip sets the DefinitionZip field's value.
func (s *CreateWorkflowInput) SetDefinitionZip(v []byte) *CreateWorkflowInput {
	s.DefinitionZip = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateWorkflowInput) SetDescription(v string) *CreateWorkflowInput {
	s.Description = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *CreateWorkflowInput) SetEngine(v string) *CreateWorkflowInput {
	s.Engine = &v
	return s
}

// SetMain sets the Main field's value.
func (s *CreateWorkflowInput) SetMain(v string) *CreateWorkflowInput {
	s.Main = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorkflowInput) SetName(v string) *CreateWorkflowInput {
	s.Name = &v
	return s
}

// SetParameterTemplate sets the ParameterTemplate field's value.
func (s *CreateWorkflowInput) SetParameterTemplate(v map[string]*WorkflowParameter) *CreateWorkflowInput {
	s.ParameterTemplate = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateWorkflowInput) SetRequestId(v string) *CreateWorkflowInput {
	s.RequestId = &v
	return s
}

// SetStorageCapacity sets the StorageCapacity field's value.
func (s *CreateWorkflowInput) SetStorageCapacity(v int64) *CreateWorkflowInput {
	s.StorageCapacity = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkflowInput) SetTags(v map[string]*string) *CreateWorkflowInput {
	s.Tags = v
	return s
}

type CreateWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// The workflow's ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The workflow's ID.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The workflow's status.
	Status *string `locationName:"status" min:"1" type:"string" enum:"WorkflowStatus"`

	// The workflow's tags.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateWorkflowOutput) SetArn(v string) *CreateWorkflowOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateWorkflowOutput) SetId(v string) *CreateWorkflowOutput {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateWorkflowOutput) SetStatus(v string) *CreateWorkflowOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkflowOutput) SetTags(v map[string]*string) *CreateWorkflowOutput {
	s.Tags = v
	return s
}

type DeleteAnnotationStoreInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Whether to force deletion.
	Force *bool `location:"querystring" locationName:"force" type:"boolean"`

	// The store's name.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnnotationStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnnotationStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAnnotationStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAnnotationStoreInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForce sets the Force field's value.
func (s *DeleteAnnotationStoreInput) SetForce(v bool) *DeleteAnnotationStoreInput {
	s.Force = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteAnnotationStoreInput) SetName(v string) *DeleteAnnotationStoreInput {
	s.Name = &v
	return s
}

type DeleteAnnotationStoreOutput struct {
	_ struct{} `type:"structure"`

	// The store's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"StoreStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnnotationStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnnotationStoreOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DeleteAnnotationStoreOutput) SetStatus(v string) *DeleteAnnotationStoreOutput {
	s.Status = &v
	return s
}

type DeleteAnnotationStoreVersionsInput struct {
	_ struct{} `type:"structure"`

	// Forces the deletion of an annotation store version when imports are in-progress..
	Force *bool `location:"querystring" locationName:"force" type:"boolean"`

	// The name of the annotation store from which versions are being deleted.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The versions of an annotation store to be deleted.
	//
	// Versions is a required field
	Versions []*string `locationName:"versions" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnnotationStoreVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnnotationStoreVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAnnotationStoreVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAnnotationStoreVersionsInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Versions == nil {
		invalidParams.Add(request.NewErrParamRequired("Versions"))
	}
	if s.Versions != nil && len(s.Versions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Versions", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForce sets the Force field's value.
func (s *DeleteAnnotationStoreVersionsInput) SetForce(v bool) *DeleteAnnotationStoreVersionsInput {
	s.Force = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteAnnotationStoreVersionsInput) SetName(v string) *DeleteAnnotationStoreVersionsInput {
	s.Name = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *DeleteAnnotationStoreVersionsInput) SetVersions(v []*string) *DeleteAnnotationStoreVersionsInput {
	s.Versions = v
	return s
}

type DeleteAnnotationStoreVersionsOutput struct {
	_ struct{} `type:"structure"`

	// Any errors that occur when attempting to delete an annotation store version.
	Errors []*VersionDeleteError `locationName:"errors" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnnotationStoreVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnnotationStoreVersionsOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *DeleteAnnotationStoreVersionsOutput) SetErrors(v []*VersionDeleteError) *DeleteAnnotationStoreVersionsOutput {
	s.Errors = v
	return s
}

type DeleteReferenceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The reference's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"10" type:"string" required:"true"`

	// The reference's store ID.
	//
	// ReferenceStoreId is a required field
	ReferenceStoreId *string `location:"uri" locationName:"referenceStoreId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReferenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReferenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReferenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReferenceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 10))
	}
	if s.ReferenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceStoreId"))
	}
	if s.ReferenceStoreId != nil && len(*s.ReferenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ReferenceStoreId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteReferenceInput) SetId(v string) *DeleteReferenceInput {
	s.Id = &v
	return s
}

// SetReferenceStoreId sets the ReferenceStoreId field's value.
func (s *DeleteReferenceInput) SetReferenceStoreId(v string) *DeleteReferenceInput {
	s.ReferenceStoreId = &v
	return s
}

type DeleteReferenceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReferenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReferenceOutput) GoString() string {
	return s.String()
}

type DeleteReferenceStoreInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The store's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReferenceStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReferenceStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReferenceStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReferenceStoreInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteReferenceStoreInput) SetId(v string) *DeleteReferenceStoreInput {
	s.Id = &v
	return s
}

type DeleteReferenceStoreOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReferenceStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReferenceStoreOutput) GoString() string {
	return s.String()
}

type DeleteRunGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The run group's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRunGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRunGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRunGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRunGroupInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteRunGroupInput) SetId(v string) *DeleteRunGroupInput {
	s.Id = &v
	return s
}

type DeleteRunGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRunGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRunGroupOutput) GoString() string {
	return s.String()
}

type DeleteRunInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The run's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRunInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteRunInput) SetId(v string) *DeleteRunInput {
	s.Id = &v
	return s
}

type DeleteRunOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRunOutput) GoString() string {
	return s.String()
}

type DeleteSequenceStoreInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The sequence store's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSequenceStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSequenceStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSequenceStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSequenceStoreInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteSequenceStoreInput) SetId(v string) *DeleteSequenceStoreInput {
	s.Id = &v
	return s
}

type DeleteSequenceStoreOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSequenceStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSequenceStoreOutput) GoString() string {
	return s.String()
}

type DeleteShareInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the share request to be deleted.
	//
	// ShareId is a required field
	ShareId *string `location:"uri" locationName:"shareId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteShareInput"}
	if s.ShareId == nil {
		invalidParams.Add(request.NewErrParamRequired("ShareId"))
	}
	if s.ShareId != nil && len(*s.ShareId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShareId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShareId sets the ShareId field's value.
func (s *DeleteShareInput) SetShareId(v string) *DeleteShareInput {
	s.ShareId = &v
	return s
}

type DeleteShareOutput struct {
	_ struct{} `type:"structure"`

	// The status of the share being deleted.
	Status *string `locationName:"status" type:"string" enum:"ShareStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteShareOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DeleteShareOutput) SetStatus(v string) *DeleteShareOutput {
	s.Status = &v
	return s
}

type DeleteVariantStoreInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Whether to force deletion.
	Force *bool `location:"querystring" locationName:"force" type:"boolean"`

	// The store's name.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVariantStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVariantStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVariantStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVariantStoreInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForce sets the Force field's value.
func (s *DeleteVariantStoreInput) SetForce(v bool) *DeleteVariantStoreInput {
	s.Force = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteVariantStoreInput) SetName(v string) *DeleteVariantStoreInput {
	s.Name = &v
	return s
}

type DeleteVariantStoreOutput struct {
	_ struct{} `type:"structure"`

	// The store's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"StoreStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVariantStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVariantStoreOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DeleteVariantStoreOutput) SetStatus(v string) *DeleteVariantStoreOutput {
	s.Status = &v
	return s
}

type DeleteWorkflowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The workflow's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkflowInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteWorkflowInput) SetId(v string) *DeleteWorkflowInput {
	s.Id = &v
	return s
}

type DeleteWorkflowOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowOutput) GoString() string {
	return s.String()
}

// The entity tag (ETag) is a hash of the object representing its semantic content.
type ETag struct {
	_ struct{} `type:"structure"`

	// The algorithm used to calculate the read set’s ETag(s).
	Algorithm *string `locationName:"algorithm" type:"string" enum:"ETagAlgorithm"`

	// The ETag hash calculated on Source1 of the read set.
	Source1 *string `locationName:"source1" type:"string"`

	// The ETag hash calculated on Source2 of the read set.
	Source2 *string `locationName:"source2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ETag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ETag) GoString() string {
	return s.String()
}

// SetAlgorithm sets the Algorithm field's value.
func (s *ETag) SetAlgorithm(v string) *ETag {
	s.Algorithm = &v
	return s
}

// SetSource1 sets the Source1 field's value.
func (s *ETag) SetSource1(v string) *ETag {
	s.Source1 = &v
	return s
}

// SetSource2 sets the Source2 field's value.
func (s *ETag) SetSource2(v string) *ETag {
	s.Source2 = &v
	return s
}

// A read set.
type ExportReadSet struct {
	_ struct{} `type:"structure"`

	// The set's ID.
	//
	// ReadSetId is a required field
	ReadSetId *string `locationName:"readSetId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportReadSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportReadSet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportReadSet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportReadSet"}
	if s.ReadSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReadSetId"))
	}
	if s.ReadSetId != nil && len(*s.ReadSetId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ReadSetId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReadSetId sets the ReadSetId field's value.
func (s *ExportReadSet) SetReadSetId(v string) *ExportReadSet {
	s.ReadSetId = &v
	return s
}

// Details about a read set.
type ExportReadSetDetail struct {
	_ struct{} `type:"structure"`

	// The set's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The set's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReadSetExportJobItemStatus"`

	// The set's status message.
	StatusMessage *string `locationName:"statusMessage" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportReadSetDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportReadSetDetail) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ExportReadSetDetail) SetId(v string) *ExportReadSetDetail {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ExportReadSetDetail) SetStatus(v string) *ExportReadSetDetail {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ExportReadSetDetail) SetStatusMessage(v string) *ExportReadSetDetail {
	s.StatusMessage = &v
	return s
}

// An read set export job filter.
type ExportReadSetFilter struct {
	_ struct{} `type:"structure"`

	// The filter's start date.
	CreatedAfter *time.Time `locationName:"createdAfter" type:"timestamp" timestampFormat:"iso8601"`

	// The filter's end date.
	CreatedBefore *time.Time `locationName:"createdBefore" type:"timestamp" timestampFormat:"iso8601"`

	// A status to filter on.
	Status *string `locationName:"status" type:"string" enum:"ReadSetExportJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportReadSetFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportReadSetFilter) GoString() string {
	return s.String()
}

// SetCreatedAfter sets the CreatedAfter field's value.
func (s *ExportReadSetFilter) SetCreatedAfter(v time.Time) *ExportReadSetFilter {
	s.CreatedAfter = &v
	return s
}

// SetCreatedBefore sets the CreatedBefore field's value.
func (s *ExportReadSetFilter) SetCreatedBefore(v time.Time) *ExportReadSetFilter {
	s.CreatedBefore = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ExportReadSetFilter) SetStatus(v string) *ExportReadSetFilter {
	s.Status = &v
	return s
}

// Details about a read set export job.
type ExportReadSetJobDetail struct {
	_ struct{} `type:"structure"`

	// When the job completed.
	CompletionTime *time.Time `locationName:"completionTime" type:"timestamp" timestampFormat:"iso8601"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The job's destination in Amazon S3.
	//
	// Destination is a required field
	Destination *string `locationName:"destination" type:"string" required:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The job's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The job's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReadSetExportJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportReadSetJobDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportReadSetJobDetail) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *ExportReadSetJobDetail) SetCompletionTime(v time.Time) *ExportReadSetJobDetail {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ExportReadSetJobDetail) SetCreationTime(v time.Time) *ExportReadSetJobDetail {
	s.CreationTime = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *ExportReadSetJobDetail) SetDestination(v string) *ExportReadSetJobDetail {
	s.Destination = &v
	return s
}

// SetId sets the Id field's value.
func (s *ExportReadSetJobDetail) SetId(v string) *ExportReadSetJobDetail {
	s.Id = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *ExportReadSetJobDetail) SetSequenceStoreId(v string) *ExportReadSetJobDetail {
	s.SequenceStoreId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ExportReadSetJobDetail) SetStatus(v string) *ExportReadSetJobDetail {
	s.Status = &v
	return s
}

// Details about a file.
type FileInformation struct {
	_ struct{} `type:"structure"`

	// The file's content length.
	ContentLength *int64 `locationName:"contentLength" min:"1" type:"long"`

	// The file's part size.
	PartSize *int64 `locationName:"partSize" min:"1" type:"long"`

	// The file's total parts.
	TotalParts *int64 `locationName:"totalParts" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileInformation) GoString() string {
	return s.String()
}

// SetContentLength sets the ContentLength field's value.
func (s *FileInformation) SetContentLength(v int64) *FileInformation {
	s.ContentLength = &v
	return s
}

// SetPartSize sets the PartSize field's value.
func (s *FileInformation) SetPartSize(v int64) *FileInformation {
	s.PartSize = &v
	return s
}

// SetTotalParts sets the TotalParts field's value.
func (s *FileInformation) SetTotalParts(v int64) *FileInformation {
	s.TotalParts = &v
	return s
}

// Use filters to focus the returned annotation store versions on a specific
// parameter, such as the status of the annotation store.
type Filter struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (Arn) for an analytics store.
	ResourceArns []*string `locationName:"resourceArns" min:"1" type:"list"`

	// The status of an annotation store version.
	Status []*string `locationName:"status" type:"list" enum:"ShareStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.ResourceArns != nil && len(s.ResourceArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArns sets the ResourceArns field's value.
func (s *Filter) SetResourceArns(v []*string) *Filter {
	s.ResourceArns = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Filter) SetStatus(v []*string) *Filter {
	s.Status = v
	return s
}

// Formatting options for a file.
type FormatOptions struct {
	_ struct{} `type:"structure"`

	// Options for a TSV file.
	TsvOptions *TsvOptions `locationName:"tsvOptions" type:"structure"`

	// Options for a VCF file.
	VcfOptions *VcfOptions `locationName:"vcfOptions" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FormatOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FormatOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FormatOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FormatOptions"}
	if s.TsvOptions != nil {
		if err := s.TsvOptions.Validate(); err != nil {
			invalidParams.AddNested("TsvOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTsvOptions sets the TsvOptions field's value.
func (s *FormatOptions) SetTsvOptions(v *TsvOptions) *FormatOptions {
	s.TsvOptions = v
	return s
}

// SetVcfOptions sets the VcfOptions field's value.
func (s *FormatOptions) SetVcfOptions(v *VcfOptions) *FormatOptions {
	s.VcfOptions = v
	return s
}

type GetAnnotationImportJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The job's ID.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnnotationImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnnotationImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAnnotationImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAnnotationImportJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetAnnotationImportJobInput) SetJobId(v string) *GetAnnotationImportJobInput {
	s.JobId = &v
	return s
}

type GetAnnotationImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The annotation schema generated by the parsed annotation data.
	AnnotationFields map[string]*string `locationName:"annotationFields" type:"map"`

	// When the job completed.
	//
	// CompletionTime is a required field
	CompletionTime *time.Time `locationName:"completionTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The job's destination annotation store.
	//
	// DestinationName is a required field
	DestinationName *string `locationName:"destinationName" min:"3" type:"string" required:"true"`

	// Formatting options for a file.
	//
	// FormatOptions is a required field
	FormatOptions *FormatOptions `locationName:"formatOptions" type:"structure" required:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The job's imported items.
	//
	// Items is a required field
	Items []*AnnotationImportItemDetail `locationName:"items" min:"1" type:"list" required:"true"`

	// The job's service role ARN.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The job's left normalization setting.
	//
	// RunLeftNormalization is a required field
	RunLeftNormalization *bool `locationName:"runLeftNormalization" type:"boolean" required:"true"`

	// The job's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"JobStatus"`

	// The job's status message.
	//
	// StatusMessage is a required field
	StatusMessage *string `locationName:"statusMessage" type:"string" required:"true"`

	// When the job was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the annotation store version.
	//
	// VersionName is a required field
	VersionName *string `locationName:"versionName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnnotationImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnnotationImportJobOutput) GoString() string {
	return s.String()
}

// SetAnnotationFields sets the AnnotationFields field's value.
func (s *GetAnnotationImportJobOutput) SetAnnotationFields(v map[string]*string) *GetAnnotationImportJobOutput {
	s.AnnotationFields = v
	return s
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *GetAnnotationImportJobOutput) SetCompletionTime(v time.Time) *GetAnnotationImportJobOutput {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetAnnotationImportJobOutput) SetCreationTime(v time.Time) *GetAnnotationImportJobOutput {
	s.CreationTime = &v
	return s
}

// SetDestinationName sets the DestinationName field's value.
func (s *GetAnnotationImportJobOutput) SetDestinationName(v string) *GetAnnotationImportJobOutput {
	s.DestinationName = &v
	return s
}

// SetFormatOptions sets the FormatOptions field's value.
func (s *GetAnnotationImportJobOutput) SetFormatOptions(v *FormatOptions) *GetAnnotationImportJobOutput {
	s.FormatOptions = v
	return s
}

// SetId sets the Id field's value.
func (s *GetAnnotationImportJobOutput) SetId(v string) *GetAnnotationImportJobOutput {
	s.Id = &v
	return s
}

// SetItems sets the Items field's value.
func (s *GetAnnotationImportJobOutput) SetItems(v []*AnnotationImportItemDetail) *GetAnnotationImportJobOutput {
	s.Items = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetAnnotationImportJobOutput) SetRoleArn(v string) *GetAnnotationImportJobOutput {
	s.RoleArn = &v
	return s
}

// SetRunLeftNormalization sets the RunLeftNormalization field's value.
func (s *GetAnnotationImportJobOutput) SetRunLeftNormalization(v bool) *GetAnnotationImportJobOutput {
	s.RunLeftNormalization = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetAnnotationImportJobOutput) SetStatus(v string) *GetAnnotationImportJobOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetAnnotationImportJobOutput) SetStatusMessage(v string) *GetAnnotationImportJobOutput {
	s.StatusMessage = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetAnnotationImportJobOutput) SetUpdateTime(v time.Time) *GetAnnotationImportJobOutput {
	s.UpdateTime = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *GetAnnotationImportJobOutput) SetVersionName(v string) *GetAnnotationImportJobOutput {
	s.VersionName = &v
	return s
}

type GetAnnotationStoreInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The store's name.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnnotationStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnnotationStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAnnotationStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAnnotationStoreInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetAnnotationStoreInput) SetName(v string) *GetAnnotationStoreInput {
	s.Name = &v
	return s
}

type GetAnnotationStoreOutput struct {
	_ struct{} `type:"structure"`

	// When the store was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The store's description.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The store's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The store's name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// An integer indicating how many versions of an annotation store exist.
	//
	// NumVersions is a required field
	NumVersions *int64 `locationName:"numVersions" type:"integer" required:"true"`

	// The store's genome reference.
	//
	// Reference is a required field
	Reference *ReferenceItem `locationName:"reference" type:"structure" required:"true"`

	// The store's server-side encryption (SSE) settings.
	//
	// SseConfig is a required field
	SseConfig *SseConfig `locationName:"sseConfig" type:"structure" required:"true"`

	// The store's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"StoreStatus"`

	// A status message.
	//
	// StatusMessage is a required field
	StatusMessage *string `locationName:"statusMessage" type:"string" required:"true"`

	// The store's ARN.
	//
	// StoreArn is a required field
	StoreArn *string `locationName:"storeArn" min:"20" type:"string" required:"true"`

	// The store's annotation file format.
	StoreFormat *string `locationName:"storeFormat" type:"string" enum:"StoreFormat"`

	// The store's parsing options.
	StoreOptions *StoreOptions `locationName:"storeOptions" type:"structure"`

	// The store's size in bytes.
	//
	// StoreSizeBytes is a required field
	StoreSizeBytes *int64 `locationName:"storeSizeBytes" type:"long" required:"true"`

	// The store's tags.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`

	// When the store was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnnotationStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnnotationStoreOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetAnnotationStoreOutput) SetCreationTime(v time.Time) *GetAnnotationStoreOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetAnnotationStoreOutput) SetDescription(v string) *GetAnnotationStoreOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetAnnotationStoreOutput) SetId(v string) *GetAnnotationStoreOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAnnotationStoreOutput) SetName(v string) *GetAnnotationStoreOutput {
	s.Name = &v
	return s
}

// SetNumVersions sets the NumVersions field's value.
func (s *GetAnnotationStoreOutput) SetNumVersions(v int64) *GetAnnotationStoreOutput {
	s.NumVersions = &v
	return s
}

// SetReference sets the Reference field's value.
func (s *GetAnnotationStoreOutput) SetReference(v *ReferenceItem) *GetAnnotationStoreOutput {
	s.Reference = v
	return s
}

// SetSseConfig sets the SseConfig field's value.
func (s *GetAnnotationStoreOutput) SetSseConfig(v *SseConfig) *GetAnnotationStoreOutput {
	s.SseConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetAnnotationStoreOutput) SetStatus(v string) *GetAnnotationStoreOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetAnnotationStoreOutput) SetStatusMessage(v string) *GetAnnotationStoreOutput {
	s.StatusMessage = &v
	return s
}

// SetStoreArn sets the StoreArn field's value.
func (s *GetAnnotationStoreOutput) SetStoreArn(v string) *GetAnnotationStoreOutput {
	s.StoreArn = &v
	return s
}

// SetStoreFormat sets the StoreFormat field's value.
func (s *GetAnnotationStoreOutput) SetStoreFormat(v string) *GetAnnotationStoreOutput {
	s.StoreFormat = &v
	return s
}

// SetStoreOptions sets the StoreOptions field's value.
func (s *GetAnnotationStoreOutput) SetStoreOptions(v *StoreOptions) *GetAnnotationStoreOutput {
	s.StoreOptions = v
	return s
}

// SetStoreSizeBytes sets the StoreSizeBytes field's value.
func (s *GetAnnotationStoreOutput) SetStoreSizeBytes(v int64) *GetAnnotationStoreOutput {
	s.StoreSizeBytes = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetAnnotationStoreOutput) SetTags(v map[string]*string) *GetAnnotationStoreOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetAnnotationStoreOutput) SetUpdateTime(v time.Time) *GetAnnotationStoreOutput {
	s.UpdateTime = &v
	return s
}

type GetAnnotationStoreVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name given to an annotation store version to distinguish it from others.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name given to an annotation store version to distinguish it from others.
	//
	// VersionName is a required field
	VersionName *string `location:"uri" locationName:"versionName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnnotationStoreVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnnotationStoreVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAnnotationStoreVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAnnotationStoreVersionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.VersionName == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionName"))
	}
	if s.VersionName != nil && len(*s.VersionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetAnnotationStoreVersionInput) SetName(v string) *GetAnnotationStoreVersionInput {
	s.Name = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *GetAnnotationStoreVersionInput) SetVersionName(v string) *GetAnnotationStoreVersionInput {
	s.VersionName = &v
	return s
}

type GetAnnotationStoreVersionOutput struct {
	_ struct{} `type:"structure"`

	// The time stamp for when an annotation store version was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description for an annotation store version.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The annotation store version ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the annotation store.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The status of an annotation store version.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"VersionStatus"`

	// The status of an annotation store version.
	//
	// StatusMessage is a required field
	StatusMessage *string `locationName:"statusMessage" type:"string" required:"true"`

	// The store ID for annotation store version.
	//
	// StoreId is a required field
	StoreId *string `locationName:"storeId" type:"string" required:"true"`

	// Any tags associated with an annotation store version.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`

	// The time stamp for when an annotation store version was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Arn for the annotation store.
	//
	// VersionArn is a required field
	VersionArn *string `locationName:"versionArn" min:"20" type:"string" required:"true"`

	// The name given to an annotation store version to distinguish it from others.
	//
	// VersionName is a required field
	VersionName *string `locationName:"versionName" min:"3" type:"string" required:"true"`

	// The options for an annotation store version.
	VersionOptions *VersionOptions `locationName:"versionOptions" type:"structure"`

	// The size of the annotation store version in Bytes.
	//
	// VersionSizeBytes is a required field
	VersionSizeBytes *int64 `locationName:"versionSizeBytes" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnnotationStoreVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnnotationStoreVersionOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetAnnotationStoreVersionOutput) SetCreationTime(v time.Time) *GetAnnotationStoreVersionOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetAnnotationStoreVersionOutput) SetDescription(v string) *GetAnnotationStoreVersionOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetAnnotationStoreVersionOutput) SetId(v string) *GetAnnotationStoreVersionOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAnnotationStoreVersionOutput) SetName(v string) *GetAnnotationStoreVersionOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetAnnotationStoreVersionOutput) SetStatus(v string) *GetAnnotationStoreVersionOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetAnnotationStoreVersionOutput) SetStatusMessage(v string) *GetAnnotationStoreVersionOutput {
	s.StatusMessage = &v
	return s
}

// SetStoreId sets the StoreId field's value.
func (s *GetAnnotationStoreVersionOutput) SetStoreId(v string) *GetAnnotationStoreVersionOutput {
	s.StoreId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetAnnotationStoreVersionOutput) SetTags(v map[string]*string) *GetAnnotationStoreVersionOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetAnnotationStoreVersionOutput) SetUpdateTime(v time.Time) *GetAnnotationStoreVersionOutput {
	s.UpdateTime = &v
	return s
}

// SetVersionArn sets the VersionArn field's value.
func (s *GetAnnotationStoreVersionOutput) SetVersionArn(v string) *GetAnnotationStoreVersionOutput {
	s.VersionArn = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *GetAnnotationStoreVersionOutput) SetVersionName(v string) *GetAnnotationStoreVersionOutput {
	s.VersionName = &v
	return s
}

// SetVersionOptions sets the VersionOptions field's value.
func (s *GetAnnotationStoreVersionOutput) SetVersionOptions(v *VersionOptions) *GetAnnotationStoreVersionOutput {
	s.VersionOptions = v
	return s
}

// SetVersionSizeBytes sets the VersionSizeBytes field's value.
func (s *GetAnnotationStoreVersionOutput) SetVersionSizeBytes(v int64) *GetAnnotationStoreVersionOutput {
	s.VersionSizeBytes = &v
	return s
}

type GetReadSetActivationJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"10" type:"string" required:"true"`

	// The job's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetActivationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetActivationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReadSetActivationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReadSetActivationJobInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 10))
	}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetReadSetActivationJobInput) SetId(v string) *GetReadSetActivationJobInput {
	s.Id = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *GetReadSetActivationJobInput) SetSequenceStoreId(v string) *GetReadSetActivationJobInput {
	s.SequenceStoreId = &v
	return s
}

type GetReadSetActivationJobOutput struct {
	_ struct{} `type:"structure"`

	// When the job completed.
	CompletionTime *time.Time `locationName:"completionTime" type:"timestamp" timestampFormat:"iso8601"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The job's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The job's source files.
	Sources []*ActivateReadSetSourceItem `locationName:"sources" type:"list"`

	// The job's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReadSetActivationJobStatus"`

	// The job's status message.
	StatusMessage *string `locationName:"statusMessage" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetActivationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetActivationJobOutput) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *GetReadSetActivationJobOutput) SetCompletionTime(v time.Time) *GetReadSetActivationJobOutput {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetReadSetActivationJobOutput) SetCreationTime(v time.Time) *GetReadSetActivationJobOutput {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetReadSetActivationJobOutput) SetId(v string) *GetReadSetActivationJobOutput {
	s.Id = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *GetReadSetActivationJobOutput) SetSequenceStoreId(v string) *GetReadSetActivationJobOutput {
	s.SequenceStoreId = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *GetReadSetActivationJobOutput) SetSources(v []*ActivateReadSetSourceItem) *GetReadSetActivationJobOutput {
	s.Sources = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetReadSetActivationJobOutput) SetStatus(v string) *GetReadSetActivationJobOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetReadSetActivationJobOutput) SetStatusMessage(v string) *GetReadSetActivationJobOutput {
	s.StatusMessage = &v
	return s
}

type GetReadSetExportJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"10" type:"string" required:"true"`

	// The job's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReadSetExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReadSetExportJobInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 10))
	}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetReadSetExportJobInput) SetId(v string) *GetReadSetExportJobInput {
	s.Id = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *GetReadSetExportJobInput) SetSequenceStoreId(v string) *GetReadSetExportJobInput {
	s.SequenceStoreId = &v
	return s
}

type GetReadSetExportJobOutput struct {
	_ struct{} `type:"structure"`

	// When the job completed.
	CompletionTime *time.Time `locationName:"completionTime" type:"timestamp" timestampFormat:"iso8601"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The job's destination in Amazon S3.
	//
	// Destination is a required field
	Destination *string `locationName:"destination" type:"string" required:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The job's read sets.
	ReadSets []*ExportReadSetDetail `locationName:"readSets" type:"list"`

	// The job's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The job's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReadSetExportJobStatus"`

	// The job's status message.
	StatusMessage *string `locationName:"statusMessage" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetExportJobOutput) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *GetReadSetExportJobOutput) SetCompletionTime(v time.Time) *GetReadSetExportJobOutput {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetReadSetExportJobOutput) SetCreationTime(v time.Time) *GetReadSetExportJobOutput {
	s.CreationTime = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *GetReadSetExportJobOutput) SetDestination(v string) *GetReadSetExportJobOutput {
	s.Destination = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetReadSetExportJobOutput) SetId(v string) *GetReadSetExportJobOutput {
	s.Id = &v
	return s
}

// SetReadSets sets the ReadSets field's value.
func (s *GetReadSetExportJobOutput) SetReadSets(v []*ExportReadSetDetail) *GetReadSetExportJobOutput {
	s.ReadSets = v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *GetReadSetExportJobOutput) SetSequenceStoreId(v string) *GetReadSetExportJobOutput {
	s.SequenceStoreId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetReadSetExportJobOutput) SetStatus(v string) *GetReadSetExportJobOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetReadSetExportJobOutput) SetStatusMessage(v string) *GetReadSetExportJobOutput {
	s.StatusMessage = &v
	return s
}

type GetReadSetImportJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"10" type:"string" required:"true"`

	// The job's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReadSetImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReadSetImportJobInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 10))
	}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetReadSetImportJobInput) SetId(v string) *GetReadSetImportJobInput {
	s.Id = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *GetReadSetImportJobInput) SetSequenceStoreId(v string) *GetReadSetImportJobInput {
	s.SequenceStoreId = &v
	return s
}

type GetReadSetImportJobOutput struct {
	_ struct{} `type:"structure"`

	// When the job completed.
	CompletionTime *time.Time `locationName:"completionTime" type:"timestamp" timestampFormat:"iso8601"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The job's service role ARN.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The job's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The job's source files.
	//
	// Sources is a required field
	Sources []*ImportReadSetSourceItem `locationName:"sources" type:"list" required:"true"`

	// The job's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReadSetImportJobStatus"`

	// The job's status message.
	StatusMessage *string `locationName:"statusMessage" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetImportJobOutput) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *GetReadSetImportJobOutput) SetCompletionTime(v time.Time) *GetReadSetImportJobOutput {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetReadSetImportJobOutput) SetCreationTime(v time.Time) *GetReadSetImportJobOutput {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetReadSetImportJobOutput) SetId(v string) *GetReadSetImportJobOutput {
	s.Id = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetReadSetImportJobOutput) SetRoleArn(v string) *GetReadSetImportJobOutput {
	s.RoleArn = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *GetReadSetImportJobOutput) SetSequenceStoreId(v string) *GetReadSetImportJobOutput {
	s.SequenceStoreId = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *GetReadSetImportJobOutput) SetSources(v []*ImportReadSetSourceItem) *GetReadSetImportJobOutput {
	s.Sources = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetReadSetImportJobOutput) SetStatus(v string) *GetReadSetImportJobOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetReadSetImportJobOutput) SetStatusMessage(v string) *GetReadSetImportJobOutput {
	s.StatusMessage = &v
	return s
}

type GetReadSetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The file to retrieve.
	File *string `location:"querystring" locationName:"file" type:"string" enum:"ReadSetFile"`

	// The read set's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"10" type:"string" required:"true"`

	// The part number to retrieve.
	//
	// PartNumber is a required field
	PartNumber *int64 `location:"querystring" locationName:"partNumber" min:"1" type:"integer" required:"true"`

	// The read set's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReadSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReadSetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 10))
	}
	if s.PartNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PartNumber"))
	}
	if s.PartNumber != nil && *s.PartNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PartNumber", 1))
	}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFile sets the File field's value.
func (s *GetReadSetInput) SetFile(v string) *GetReadSetInput {
	s.File = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetReadSetInput) SetId(v string) *GetReadSetInput {
	s.Id = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *GetReadSetInput) SetPartNumber(v int64) *GetReadSetInput {
	s.PartNumber = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *GetReadSetInput) SetSequenceStoreId(v string) *GetReadSetInput {
	s.SequenceStoreId = &v
	return s
}

type GetReadSetMetadataInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The read set's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"10" type:"string" required:"true"`

	// The read set's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReadSetMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReadSetMetadataInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 10))
	}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetReadSetMetadataInput) SetId(v string) *GetReadSetMetadataInput {
	s.Id = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *GetReadSetMetadataInput) SetSequenceStoreId(v string) *GetReadSetMetadataInput {
	s.SequenceStoreId = &v
	return s
}

type GetReadSetMetadataOutput struct {
	_ struct{} `type:"structure"`

	// The read set's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// When the read set was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The creation type of the read set.
	CreationType *string `locationName:"creationType" type:"string" enum:"CreationType"`

	// The read set's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The entity tag (ETag) is a hash of the object meant to represent its semantic
	// content.
	Etag *ETag `locationName:"etag" type:"structure"`

	// The read set's file type.
	//
	// FileType is a required field
	FileType *string `locationName:"fileType" type:"string" required:"true" enum:"FileType"`

	// The read set's files.
	Files *ReadSetFiles `locationName:"files" type:"structure"`

	// The read set's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The read set's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The read set's genome reference ARN.
	ReferenceArn *string `locationName:"referenceArn" min:"1" type:"string"`

	// The read set's sample ID.
	SampleId *string `locationName:"sampleId" min:"1" type:"string"`

	// The read set's sequence information.
	SequenceInformation *SequenceInformation `locationName:"sequenceInformation" type:"structure"`

	// The read set's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The read set's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReadSetStatus"`

	// The status message for a read set. It provides more detail as to why the
	// read set has a status.
	StatusMessage *string `locationName:"statusMessage" min:"1" type:"string"`

	// The read set's subject ID.
	SubjectId *string `locationName:"subjectId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetMetadataOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetReadSetMetadataOutput) SetArn(v string) *GetReadSetMetadataOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetReadSetMetadataOutput) SetCreationTime(v time.Time) *GetReadSetMetadataOutput {
	s.CreationTime = &v
	return s
}

// SetCreationType sets the CreationType field's value.
func (s *GetReadSetMetadataOutput) SetCreationType(v string) *GetReadSetMetadataOutput {
	s.CreationType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetReadSetMetadataOutput) SetDescription(v string) *GetReadSetMetadataOutput {
	s.Description = &v
	return s
}

// SetEtag sets the Etag field's value.
func (s *GetReadSetMetadataOutput) SetEtag(v *ETag) *GetReadSetMetadataOutput {
	s.Etag = v
	return s
}

// SetFileType sets the FileType field's value.
func (s *GetReadSetMetadataOutput) SetFileType(v string) *GetReadSetMetadataOutput {
	s.FileType = &v
	return s
}

// SetFiles sets the Files field's value.
func (s *GetReadSetMetadataOutput) SetFiles(v *ReadSetFiles) *GetReadSetMetadataOutput {
	s.Files = v
	return s
}

// SetId sets the Id field's value.
func (s *GetReadSetMetadataOutput) SetId(v string) *GetReadSetMetadataOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetReadSetMetadataOutput) SetName(v string) *GetReadSetMetadataOutput {
	s.Name = &v
	return s
}

// SetReferenceArn sets the ReferenceArn field's value.
func (s *GetReadSetMetadataOutput) SetReferenceArn(v string) *GetReadSetMetadataOutput {
	s.ReferenceArn = &v
	return s
}

// SetSampleId sets the SampleId field's value.
func (s *GetReadSetMetadataOutput) SetSampleId(v string) *GetReadSetMetadataOutput {
	s.SampleId = &v
	return s
}

// SetSequenceInformation sets the SequenceInformation field's value.
func (s *GetReadSetMetadataOutput) SetSequenceInformation(v *SequenceInformation) *GetReadSetMetadataOutput {
	s.SequenceInformation = v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *GetReadSetMetadataOutput) SetSequenceStoreId(v string) *GetReadSetMetadataOutput {
	s.SequenceStoreId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetReadSetMetadataOutput) SetStatus(v string) *GetReadSetMetadataOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetReadSetMetadataOutput) SetStatusMessage(v string) *GetReadSetMetadataOutput {
	s.StatusMessage = &v
	return s
}

// SetSubjectId sets the SubjectId field's value.
func (s *GetReadSetMetadataOutput) SetSubjectId(v string) *GetReadSetMetadataOutput {
	s.SubjectId = &v
	return s
}

type GetReadSetOutput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// The read set file payload.
	Payload io.ReadCloser `locationName:"payload" type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadSetOutput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *GetReadSetOutput) SetPayload(v io.ReadCloser) *GetReadSetOutput {
	s.Payload = v
	return s
}

type GetReferenceImportJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"10" type:"string" required:"true"`

	// The job's reference store ID.
	//
	// ReferenceStoreId is a required field
	ReferenceStoreId *string `location:"uri" locationName:"referenceStoreId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReferenceImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReferenceImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReferenceImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReferenceImportJobInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 10))
	}
	if s.ReferenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceStoreId"))
	}
	if s.ReferenceStoreId != nil && len(*s.ReferenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ReferenceStoreId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetReferenceImportJobInput) SetId(v string) *GetReferenceImportJobInput {
	s.Id = &v
	return s
}

// SetReferenceStoreId sets the ReferenceStoreId field's value.
func (s *GetReferenceImportJobInput) SetReferenceStoreId(v string) *GetReferenceImportJobInput {
	s.ReferenceStoreId = &v
	return s
}

type GetReferenceImportJobOutput struct {
	_ struct{} `type:"structure"`

	// When the job completed.
	CompletionTime *time.Time `locationName:"completionTime" type:"timestamp" timestampFormat:"iso8601"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The job's reference store ID.
	//
	// ReferenceStoreId is a required field
	ReferenceStoreId *string `locationName:"referenceStoreId" min:"10" type:"string" required:"true"`

	// The job's service role ARN.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The job's source files.
	//
	// Sources is a required field
	Sources []*ImportReferenceSourceItem `locationName:"sources" type:"list" required:"true"`

	// The job's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReferenceImportJobStatus"`

	// The job's status message.
	StatusMessage *string `locationName:"statusMessage" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReferenceImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReferenceImportJobOutput) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *GetReferenceImportJobOutput) SetCompletionTime(v time.Time) *GetReferenceImportJobOutput {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetReferenceImportJobOutput) SetCreationTime(v time.Time) *GetReferenceImportJobOutput {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetReferenceImportJobOutput) SetId(v string) *GetReferenceImportJobOutput {
	s.Id = &v
	return s
}

// SetReferenceStoreId sets the ReferenceStoreId field's value.
func (s *GetReferenceImportJobOutput) SetReferenceStoreId(v string) *GetReferenceImportJobOutput {
	s.ReferenceStoreId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetReferenceImportJobOutput) SetRoleArn(v string) *GetReferenceImportJobOutput {
	s.RoleArn = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *GetReferenceImportJobOutput) SetSources(v []*ImportReferenceSourceItem) *GetReferenceImportJobOutput {
	s.Sources = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetReferenceImportJobOutput) SetStatus(v string) *GetReferenceImportJobOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetReferenceImportJobOutput) SetStatusMessage(v string) *GetReferenceImportJobOutput {
	s.StatusMessage = &v
	return s
}

type GetReferenceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The file to retrieve.
	File *string `location:"querystring" locationName:"file" type:"string" enum:"ReferenceFile"`

	// The reference's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"10" type:"string" required:"true"`

	// The part number to retrieve.
	//
	// PartNumber is a required field
	PartNumber *int64 `location:"querystring" locationName:"partNumber" min:"1" type:"integer" required:"true"`

	// The range to retrieve.
	Range *string `location:"header" locationName:"Range" min:"1" type:"string"`

	// The reference's store ID.
	//
	// ReferenceStoreId is a required field
	ReferenceStoreId *string `location:"uri" locationName:"referenceStoreId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReferenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReferenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReferenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReferenceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 10))
	}
	if s.PartNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PartNumber"))
	}
	if s.PartNumber != nil && *s.PartNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PartNumber", 1))
	}
	if s.Range != nil && len(*s.Range) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Range", 1))
	}
	if s.ReferenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceStoreId"))
	}
	if s.ReferenceStoreId != nil && len(*s.ReferenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ReferenceStoreId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFile sets the File field's value.
func (s *GetReferenceInput) SetFile(v string) *GetReferenceInput {
	s.File = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetReferenceInput) SetId(v string) *GetReferenceInput {
	s.Id = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *GetReferenceInput) SetPartNumber(v int64) *GetReferenceInput {
	s.PartNumber = &v
	return s
}

// SetRange sets the Range field's value.
func (s *GetReferenceInput) SetRange(v string) *GetReferenceInput {
	s.Range = &v
	return s
}

// SetReferenceStoreId sets the ReferenceStoreId field's value.
func (s *GetReferenceInput) SetReferenceStoreId(v string) *GetReferenceInput {
	s.ReferenceStoreId = &v
	return s
}

type GetReferenceMetadataInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The reference's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"10" type:"string" required:"true"`

	// The reference's reference store ID.
	//
	// ReferenceStoreId is a required field
	ReferenceStoreId *string `location:"uri" locationName:"referenceStoreId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReferenceMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReferenceMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReferenceMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReferenceMetadataInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 10))
	}
	if s.ReferenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceStoreId"))
	}
	if s.ReferenceStoreId != nil && len(*s.ReferenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ReferenceStoreId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetReferenceMetadataInput) SetId(v string) *GetReferenceMetadataInput {
	s.Id = &v
	return s
}

// SetReferenceStoreId sets the ReferenceStoreId field's value.
func (s *GetReferenceMetadataInput) SetReferenceStoreId(v string) *GetReferenceMetadataInput {
	s.ReferenceStoreId = &v
	return s
}

type GetReferenceMetadataOutput struct {
	_ struct{} `type:"structure"`

	// The reference's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// When the reference was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The reference's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The reference's files.
	Files *ReferenceFiles `locationName:"files" type:"structure"`

	// The reference's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The reference's MD5 checksum.
	//
	// Md5 is a required field
	Md5 *string `locationName:"md5" min:"1" type:"string" required:"true"`

	// The reference's name.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The reference's reference store ID.
	//
	// ReferenceStoreId is a required field
	ReferenceStoreId *string `locationName:"referenceStoreId" min:"10" type:"string" required:"true"`

	// The reference's status.
	Status *string `locationName:"status" type:"string" enum:"ReferenceStatus"`

	// When the reference was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReferenceMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReferenceMetadataOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetReferenceMetadataOutput) SetArn(v string) *GetReferenceMetadataOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetReferenceMetadataOutput) SetCreationTime(v time.Time) *GetReferenceMetadataOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetReferenceMetadataOutput) SetDescription(v string) *GetReferenceMetadataOutput {
	s.Description = &v
	return s
}

// SetFiles sets the Files field's value.
func (s *GetReferenceMetadataOutput) SetFiles(v *ReferenceFiles) *GetReferenceMetadataOutput {
	s.Files = v
	return s
}

// SetId sets the Id field's value.
func (s *GetReferenceMetadataOutput) SetId(v string) *GetReferenceMetadataOutput {
	s.Id = &v
	return s
}

// SetMd5 sets the Md5 field's value.
func (s *GetReferenceMetadataOutput) SetMd5(v string) *GetReferenceMetadataOutput {
	s.Md5 = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetReferenceMetadataOutput) SetName(v string) *GetReferenceMetadataOutput {
	s.Name = &v
	return s
}

// SetReferenceStoreId sets the ReferenceStoreId field's value.
func (s *GetReferenceMetadataOutput) SetReferenceStoreId(v string) *GetReferenceMetadataOutput {
	s.ReferenceStoreId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetReferenceMetadataOutput) SetStatus(v string) *GetReferenceMetadataOutput {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetReferenceMetadataOutput) SetUpdateTime(v time.Time) *GetReferenceMetadataOutput {
	s.UpdateTime = &v
	return s
}

type GetReferenceOutput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// The reference file payload.
	Payload io.ReadCloser `locationName:"payload" type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReferenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReferenceOutput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *GetReferenceOutput) SetPayload(v io.ReadCloser) *GetReferenceOutput {
	s.Payload = v
	return s
}

type GetReferenceStoreInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The store's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReferenceStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReferenceStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReferenceStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReferenceStoreInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetReferenceStoreInput) SetId(v string) *GetReferenceStoreInput {
	s.Id = &v
	return s
}

type GetReferenceStoreOutput struct {
	_ struct{} `type:"structure"`

	// The store's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// When the store was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The store's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The store's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The store's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The store's server-side encryption (SSE) settings.
	SseConfig *SseConfig `locationName:"sseConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReferenceStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReferenceStoreOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetReferenceStoreOutput) SetArn(v string) *GetReferenceStoreOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetReferenceStoreOutput) SetCreationTime(v time.Time) *GetReferenceStoreOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetReferenceStoreOutput) SetDescription(v string) *GetReferenceStoreOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetReferenceStoreOutput) SetId(v string) *GetReferenceStoreOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetReferenceStoreOutput) SetName(v string) *GetReferenceStoreOutput {
	s.Name = &v
	return s
}

// SetSseConfig sets the SseConfig field's value.
func (s *GetReferenceStoreOutput) SetSseConfig(v *SseConfig) *GetReferenceStoreOutput {
	s.SseConfig = v
	return s
}

type GetRunGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The group's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRunGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRunGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRunGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRunGroupInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetRunGroupInput) SetId(v string) *GetRunGroupInput {
	s.Id = &v
	return s
}

type GetRunGroupOutput struct {
	_ struct{} `type:"structure"`

	// The group's ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// When the group was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The group's ID.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The group's maximum number of CPUs to use.
	MaxCpus *int64 `locationName:"maxCpus" min:"1" type:"integer"`

	// The group's maximum run time in minutes.
	MaxDuration *int64 `locationName:"maxDuration" min:"1" type:"integer"`

	// The maximum GPUs that can be used by a run group.
	MaxGpus *int64 `locationName:"maxGpus" min:"1" type:"integer"`

	// The maximum number of concurrent runs for the group.
	MaxRuns *int64 `locationName:"maxRuns" min:"1" type:"integer"`

	// The group's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The group's tags.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRunGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRunGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetRunGroupOutput) SetArn(v string) *GetRunGroupOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetRunGroupOutput) SetCreationTime(v time.Time) *GetRunGroupOutput {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetRunGroupOutput) SetId(v string) *GetRunGroupOutput {
	s.Id = &v
	return s
}

// SetMaxCpus sets the MaxCpus field's value.
func (s *GetRunGroupOutput) SetMaxCpus(v int64) *GetRunGroupOutput {
	s.MaxCpus = &v
	return s
}

// SetMaxDuration sets the MaxDuration field's value.
func (s *GetRunGroupOutput) SetMaxDuration(v int64) *GetRunGroupOutput {
	s.MaxDuration = &v
	return s
}

// SetMaxGpus sets the MaxGpus field's value.
func (s *GetRunGroupOutput) SetMaxGpus(v int64) *GetRunGroupOutput {
	s.MaxGpus = &v
	return s
}

// SetMaxRuns sets the MaxRuns field's value.
func (s *GetRunGroupOutput) SetMaxRuns(v int64) *GetRunGroupOutput {
	s.MaxRuns = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetRunGroupOutput) SetName(v string) *GetRunGroupOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetRunGroupOutput) SetTags(v map[string]*string) *GetRunGroupOutput {
	s.Tags = v
	return s
}

type GetRunInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The run's export format.
	Export []*string `location:"querystring" locationName:"export" type:"list" enum:"RunExport"`

	// The run's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRunInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExport sets the Export field's value.
func (s *GetRunInput) SetExport(v []*string) *GetRunInput {
	s.Export = v
	return s
}

// SetId sets the Id field's value.
func (s *GetRunInput) SetId(v string) *GetRunInput {
	s.Id = &v
	return s
}

type GetRunOutput struct {
	_ struct{} `type:"structure"`

	// The computational accelerator used to run the workflow.
	Accelerators *string `locationName:"accelerators" min:"1" type:"string" enum:"Accelerators"`

	// The run's ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// When the run was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The run's definition.
	Definition *string `locationName:"definition" min:"1" type:"string"`

	// The run's digest.
	Digest *string `locationName:"digest" min:"1" type:"string"`

	// The reason a run has failed.
	FailureReason *string `locationName:"failureReason" min:"1" type:"string"`

	// The run's ID.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The run's log level.
	LogLevel *string `locationName:"logLevel" min:"1" type:"string" enum:"RunLogLevel"`

	// The location of the run log.
	LogLocation *RunLogLocation `locationName:"logLocation" type:"structure"`

	// The run's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The run's output URI.
	OutputUri *string `locationName:"outputUri" min:"1" type:"string"`

	// The run's priority.
	Priority *int64 `locationName:"priority" type:"integer"`

	// The run's resource digests.
	ResourceDigests map[string]*string `locationName:"resourceDigests" type:"map"`

	// The run's retention mode.
	RetentionMode *string `locationName:"retentionMode" min:"1" type:"string" enum:"RunRetentionMode"`

	// The run's service role ARN.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`

	// The run's group ID.
	RunGroupId *string `locationName:"runGroupId" min:"1" type:"string"`

	// The run's ID.
	RunId *string `locationName:"runId" min:"1" type:"string"`

	// The destination for workflow outputs.
	RunOutputUri *string `locationName:"runOutputUri" min:"1" type:"string"`

	// When the run started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// Who started the run.
	StartedBy *string `locationName:"startedBy" min:"1" type:"string"`

	// The run's status.
	Status *string `locationName:"status" min:"1" type:"string" enum:"RunStatus"`

	// The run's status message.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The run's stop time.
	StopTime *time.Time `locationName:"stopTime" type:"timestamp" timestampFormat:"iso8601"`

	// The run's storage capacity in gigabytes.
	StorageCapacity *int64 `locationName:"storageCapacity" type:"integer"`

	// The run's tags.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The universally unique identifier for a run.
	Uuid *string `locationName:"uuid" min:"1" type:"string"`

	// The run's workflow ID.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string"`

	// The run's workflow type.
	WorkflowType *string `locationName:"workflowType" min:"1" type:"string" enum:"WorkflowType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRunOutput) GoString() string {
	return s.String()
}

// SetAccelerators sets the Accelerators field's value.
func (s *GetRunOutput) SetAccelerators(v string) *GetRunOutput {
	s.Accelerators = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetRunOutput) SetArn(v string) *GetRunOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetRunOutput) SetCreationTime(v time.Time) *GetRunOutput {
	s.CreationTime = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetRunOutput) SetDefinition(v string) *GetRunOutput {
	s.Definition = &v
	return s
}

// SetDigest sets the Digest field's value.
func (s *GetRunOutput) SetDigest(v string) *GetRunOutput {
	s.Digest = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *GetRunOutput) SetFailureReason(v string) *GetRunOutput {
	s.FailureReason = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetRunOutput) SetId(v string) *GetRunOutput {
	s.Id = &v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *GetRunOutput) SetLogLevel(v string) *GetRunOutput {
	s.LogLevel = &v
	return s
}

// SetLogLocation sets the LogLocation field's value.
func (s *GetRunOutput) SetLogLocation(v *RunLogLocation) *GetRunOutput {
	s.LogLocation = v
	return s
}

// SetName sets the Name field's value.
func (s *GetRunOutput) SetName(v string) *GetRunOutput {
	s.Name = &v
	return s
}

// SetOutputUri sets the OutputUri field's value.
func (s *GetRunOutput) SetOutputUri(v string) *GetRunOutput {
	s.OutputUri = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *GetRunOutput) SetPriority(v int64) *GetRunOutput {
	s.Priority = &v
	return s
}

// SetResourceDigests sets the ResourceDigests field's value.
func (s *GetRunOutput) SetResourceDigests(v map[string]*string) *GetRunOutput {
	s.ResourceDigests = v
	return s
}

// SetRetentionMode sets the RetentionMode field's value.
func (s *GetRunOutput) SetRetentionMode(v string) *GetRunOutput {
	s.RetentionMode = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetRunOutput) SetRoleArn(v string) *GetRunOutput {
	s.RoleArn = &v
	return s
}

// SetRunGroupId sets the RunGroupId field's value.
func (s *GetRunOutput) SetRunGroupId(v string) *GetRunOutput {
	s.RunGroupId = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *GetRunOutput) SetRunId(v string) *GetRunOutput {
	s.RunId = &v
	return s
}

// SetRunOutputUri sets the RunOutputUri field's value.
func (s *GetRunOutput) SetRunOutputUri(v string) *GetRunOutput {
	s.RunOutputUri = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetRunOutput) SetStartTime(v time.Time) *GetRunOutput {
	s.StartTime = &v
	return s
}

// SetStartedBy sets the StartedBy field's value.
func (s *GetRunOutput) SetStartedBy(v string) *GetRunOutput {
	s.StartedBy = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetRunOutput) SetStatus(v string) *GetRunOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetRunOutput) SetStatusMessage(v string) *GetRunOutput {
	s.StatusMessage = &v
	return s
}

// SetStopTime sets the StopTime field's value.
func (s *GetRunOutput) SetStopTime(v time.Time) *GetRunOutput {
	s.StopTime = &v
	return s
}

// SetStorageCapacity sets the StorageCapacity field's value.
func (s *GetRunOutput) SetStorageCapacity(v int64) *GetRunOutput {
	s.StorageCapacity = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetRunOutput) SetTags(v map[string]*string) *GetRunOutput {
	s.Tags = v
	return s
}

// SetUuid sets the Uuid field's value.
func (s *GetRunOutput) SetUuid(v string) *GetRunOutput {
	s.Uuid = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *GetRunOutput) SetWorkflowId(v string) *GetRunOutput {
	s.WorkflowId = &v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *GetRunOutput) SetWorkflowType(v string) *GetRunOutput {
	s.WorkflowType = &v
	return s
}

type GetRunTaskInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The workflow run ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The task's ID.
	//
	// TaskId is a required field
	TaskId *string `location:"uri" locationName:"taskId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRunTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRunTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRunTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRunTaskInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetRunTaskInput) SetId(v string) *GetRunTaskInput {
	s.Id = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *GetRunTaskInput) SetTaskId(v string) *GetRunTaskInput {
	s.TaskId = &v
	return s
}

type GetRunTaskOutput struct {
	_ struct{} `type:"structure"`

	// The task's CPU usage.
	Cpus *int64 `locationName:"cpus" min:"1" type:"integer"`

	// When the task was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The reason a task has failed.
	FailureReason *string `locationName:"failureReason" min:"1" type:"string"`

	// The number of Graphics Processing Units (GPU) specified in the task.
	Gpus *int64 `locationName:"gpus" type:"integer"`

	// The instance type for a task.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The task's log stream.
	LogStream *string `locationName:"logStream" type:"string"`

	// The task's memory use in gigabytes.
	Memory *int64 `locationName:"memory" min:"1" type:"integer"`

	// The task's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The task's start time.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// The task's status.
	Status *string `locationName:"status" min:"1" type:"string" enum:"TaskStatus"`

	// The task's status message.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The task's stop time.
	StopTime *time.Time `locationName:"stopTime" type:"timestamp" timestampFormat:"iso8601"`

	// The task's ID.
	TaskId *string `locationName:"taskId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRunTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRunTaskOutput) GoString() string {
	return s.String()
}

// SetCpus sets the Cpus field's value.
func (s *GetRunTaskOutput) SetCpus(v int64) *GetRunTaskOutput {
	s.Cpus = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetRunTaskOutput) SetCreationTime(v time.Time) *GetRunTaskOutput {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *GetRunTaskOutput) SetFailureReason(v string) *GetRunTaskOutput {
	s.FailureReason = &v
	return s
}

// SetGpus sets the Gpus field's value.
func (s *GetRunTaskOutput) SetGpus(v int64) *GetRunTaskOutput {
	s.Gpus = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *GetRunTaskOutput) SetInstanceType(v string) *GetRunTaskOutput {
	s.InstanceType = &v
	return s
}

// SetLogStream sets the LogStream field's value.
func (s *GetRunTaskOutput) SetLogStream(v string) *GetRunTaskOutput {
	s.LogStream = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *GetRunTaskOutput) SetMemory(v int64) *GetRunTaskOutput {
	s.Memory = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetRunTaskOutput) SetName(v string) *GetRunTaskOutput {
	s.Name = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetRunTaskOutput) SetStartTime(v time.Time) *GetRunTaskOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetRunTaskOutput) SetStatus(v string) *GetRunTaskOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetRunTaskOutput) SetStatusMessage(v string) *GetRunTaskOutput {
	s.StatusMessage = &v
	return s
}

// SetStopTime sets the StopTime field's value.
func (s *GetRunTaskOutput) SetStopTime(v time.Time) *GetRunTaskOutput {
	s.StopTime = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *GetRunTaskOutput) SetTaskId(v string) *GetRunTaskOutput {
	s.TaskId = &v
	return s
}

type GetSequenceStoreInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The store's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSequenceStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSequenceStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSequenceStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSequenceStoreInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetSequenceStoreInput) SetId(v string) *GetSequenceStoreInput {
	s.Id = &v
	return s
}

type GetSequenceStoreOutput struct {
	_ struct{} `type:"structure"`

	// The store's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// When the store was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The store's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// An S3 location that is used to store files that have failed a direct upload.
	FallbackLocation *string `locationName:"fallbackLocation" type:"string"`

	// The store's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The store's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The store's server-side encryption (SSE) settings.
	SseConfig *SseConfig `locationName:"sseConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSequenceStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSequenceStoreOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetSequenceStoreOutput) SetArn(v string) *GetSequenceStoreOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetSequenceStoreOutput) SetCreationTime(v time.Time) *GetSequenceStoreOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetSequenceStoreOutput) SetDescription(v string) *GetSequenceStoreOutput {
	s.Description = &v
	return s
}

// SetFallbackLocation sets the FallbackLocation field's value.
func (s *GetSequenceStoreOutput) SetFallbackLocation(v string) *GetSequenceStoreOutput {
	s.FallbackLocation = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetSequenceStoreOutput) SetId(v string) *GetSequenceStoreOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetSequenceStoreOutput) SetName(v string) *GetSequenceStoreOutput {
	s.Name = &v
	return s
}

// SetSseConfig sets the SseConfig field's value.
func (s *GetSequenceStoreOutput) SetSseConfig(v *SseConfig) *GetSequenceStoreOutput {
	s.SseConfig = v
	return s
}

type GetShareInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The generated ID for a share.
	//
	// ShareId is a required field
	ShareId *string `location:"uri" locationName:"shareId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetShareInput"}
	if s.ShareId == nil {
		invalidParams.Add(request.NewErrParamRequired("ShareId"))
	}
	if s.ShareId != nil && len(*s.ShareId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShareId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShareId sets the ShareId field's value.
func (s *GetShareInput) SetShareId(v string) *GetShareInput {
	s.ShareId = &v
	return s
}

type GetShareOutput struct {
	_ struct{} `type:"structure"`

	// An analytic store share details object. contains status, resourceArn, ownerId,
	// etc.
	Share *ShareDetails `locationName:"share" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetShareOutput) GoString() string {
	return s.String()
}

// SetShare sets the Share field's value.
func (s *GetShareOutput) SetShare(v *ShareDetails) *GetShareOutput {
	s.Share = v
	return s
}

type GetVariantImportJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The job's ID.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVariantImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVariantImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVariantImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVariantImportJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetVariantImportJobInput) SetJobId(v string) *GetVariantImportJobInput {
	s.JobId = &v
	return s
}

type GetVariantImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The annotation schema generated by the parsed annotation data.
	AnnotationFields map[string]*string `locationName:"annotationFields" type:"map"`

	// When the job completed.
	CompletionTime *time.Time `locationName:"completionTime" type:"timestamp" timestampFormat:"iso8601"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The job's destination variant store.
	//
	// DestinationName is a required field
	DestinationName *string `locationName:"destinationName" min:"3" type:"string" required:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The job's items.
	//
	// Items is a required field
	Items []*VariantImportItemDetail `locationName:"items" min:"1" type:"list" required:"true"`

	// The job's service role ARN.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The job's left normalization setting.
	//
	// RunLeftNormalization is a required field
	RunLeftNormalization *bool `locationName:"runLeftNormalization" type:"boolean" required:"true"`

	// The job's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"JobStatus"`

	// The job's status message.
	//
	// StatusMessage is a required field
	StatusMessage *string `locationName:"statusMessage" type:"string" required:"true"`

	// When the job was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVariantImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVariantImportJobOutput) GoString() string {
	return s.String()
}

// SetAnnotationFields sets the AnnotationFields field's value.
func (s *GetVariantImportJobOutput) SetAnnotationFields(v map[string]*string) *GetVariantImportJobOutput {
	s.AnnotationFields = v
	return s
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *GetVariantImportJobOutput) SetCompletionTime(v time.Time) *GetVariantImportJobOutput {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetVariantImportJobOutput) SetCreationTime(v time.Time) *GetVariantImportJobOutput {
	s.CreationTime = &v
	return s
}

// SetDestinationName sets the DestinationName field's value.
func (s *GetVariantImportJobOutput) SetDestinationName(v string) *GetVariantImportJobOutput {
	s.DestinationName = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetVariantImportJobOutput) SetId(v string) *GetVariantImportJobOutput {
	s.Id = &v
	return s
}

// SetItems sets the Items field's value.
func (s *GetVariantImportJobOutput) SetItems(v []*VariantImportItemDetail) *GetVariantImportJobOutput {
	s.Items = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetVariantImportJobOutput) SetRoleArn(v string) *GetVariantImportJobOutput {
	s.RoleArn = &v
	return s
}

// SetRunLeftNormalization sets the RunLeftNormalization field's value.
func (s *GetVariantImportJobOutput) SetRunLeftNormalization(v bool) *GetVariantImportJobOutput {
	s.RunLeftNormalization = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetVariantImportJobOutput) SetStatus(v string) *GetVariantImportJobOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetVariantImportJobOutput) SetStatusMessage(v string) *GetVariantImportJobOutput {
	s.StatusMessage = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetVariantImportJobOutput) SetUpdateTime(v time.Time) *GetVariantImportJobOutput {
	s.UpdateTime = &v
	return s
}

type GetVariantStoreInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The store's name.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVariantStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVariantStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVariantStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVariantStoreInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetVariantStoreInput) SetName(v string) *GetVariantStoreInput {
	s.Name = &v
	return s
}

type GetVariantStoreOutput struct {
	_ struct{} `type:"structure"`

	// When the store was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The store's description.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The store's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The store's name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The store's genome reference.
	//
	// Reference is a required field
	Reference *ReferenceItem `locationName:"reference" type:"structure" required:"true"`

	// The store's server-side encryption (SSE) settings.
	//
	// SseConfig is a required field
	SseConfig *SseConfig `locationName:"sseConfig" type:"structure" required:"true"`

	// The store's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"StoreStatus"`

	// The store's status message.
	//
	// StatusMessage is a required field
	StatusMessage *string `locationName:"statusMessage" type:"string" required:"true"`

	// The store's ARN.
	//
	// StoreArn is a required field
	StoreArn *string `locationName:"storeArn" min:"20" type:"string" required:"true"`

	// The store's size in bytes.
	//
	// StoreSizeBytes is a required field
	StoreSizeBytes *int64 `locationName:"storeSizeBytes" type:"long" required:"true"`

	// The store's tags.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`

	// When the store was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVariantStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVariantStoreOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetVariantStoreOutput) SetCreationTime(v time.Time) *GetVariantStoreOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetVariantStoreOutput) SetDescription(v string) *GetVariantStoreOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetVariantStoreOutput) SetId(v string) *GetVariantStoreOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetVariantStoreOutput) SetName(v string) *GetVariantStoreOutput {
	s.Name = &v
	return s
}

// SetReference sets the Reference field's value.
func (s *GetVariantStoreOutput) SetReference(v *ReferenceItem) *GetVariantStoreOutput {
	s.Reference = v
	return s
}

// SetSseConfig sets the SseConfig field's value.
func (s *GetVariantStoreOutput) SetSseConfig(v *SseConfig) *GetVariantStoreOutput {
	s.SseConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetVariantStoreOutput) SetStatus(v string) *GetVariantStoreOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetVariantStoreOutput) SetStatusMessage(v string) *GetVariantStoreOutput {
	s.StatusMessage = &v
	return s
}

// SetStoreArn sets the StoreArn field's value.
func (s *GetVariantStoreOutput) SetStoreArn(v string) *GetVariantStoreOutput {
	s.StoreArn = &v
	return s
}

// SetStoreSizeBytes sets the StoreSizeBytes field's value.
func (s *GetVariantStoreOutput) SetStoreSizeBytes(v int64) *GetVariantStoreOutput {
	s.StoreSizeBytes = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetVariantStoreOutput) SetTags(v map[string]*string) *GetVariantStoreOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetVariantStoreOutput) SetUpdateTime(v time.Time) *GetVariantStoreOutput {
	s.UpdateTime = &v
	return s
}

type GetWorkflowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The export format for the workflow.
	Export []*string `location:"querystring" locationName:"export" type:"list" enum:"WorkflowExport"`

	// The workflow's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The workflow's type.
	Type *string `location:"querystring" locationName:"type" min:"1" type:"string" enum:"WorkflowType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkflowInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExport sets the Export field's value.
func (s *GetWorkflowInput) SetExport(v []*string) *GetWorkflowInput {
	s.Export = v
	return s
}

// SetId sets the Id field's value.
func (s *GetWorkflowInput) SetId(v string) *GetWorkflowInput {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetWorkflowInput) SetType(v string) *GetWorkflowInput {
	s.Type = &v
	return s
}

type GetWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// The computational accelerator specified to run the workflow.
	Accelerators *string `locationName:"accelerators" min:"1" type:"string" enum:"Accelerators"`

	// The workflow's ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// When the workflow was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The workflow's definition.
	Definition *string `locationName:"definition" min:"1" type:"string"`

	// The workflow's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The workflow's digest.
	Digest *string `locationName:"digest" min:"1" type:"string"`

	// The workflow's engine.
	Engine *string `locationName:"engine" min:"1" type:"string" enum:"WorkflowEngine"`

	// The workflow's ID.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The path of the main definition file for the workflow.
	Main *string `locationName:"main" min:"1" type:"string"`

	// Gets metadata for workflow.
	Metadata map[string]*string `locationName:"metadata" type:"map"`

	// The workflow's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The workflow's parameter template.
	ParameterTemplate map[string]*WorkflowParameter `locationName:"parameterTemplate" min:"1" type:"map"`

	// The workflow's status.
	Status *string `locationName:"status" min:"1" type:"string" enum:"WorkflowStatus"`

	// The workflow's status message.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The workflow's storage capacity in gigabytes.
	StorageCapacity *int64 `locationName:"storageCapacity" type:"integer"`

	// The workflow's tags.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The workflow's type.
	Type *string `locationName:"type" min:"1" type:"string" enum:"WorkflowType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowOutput) GoString() string {
	return s.String()
}

// SetAccelerators sets the Accelerators field's value.
func (s *GetWorkflowOutput) SetAccelerators(v string) *GetWorkflowOutput {
	s.Accelerators = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetWorkflowOutput) SetArn(v string) *GetWorkflowOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetWorkflowOutput) SetCreationTime(v time.Time) *GetWorkflowOutput {
	s.CreationTime = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetWorkflowOutput) SetDefinition(v string) *GetWorkflowOutput {
	s.Definition = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetWorkflowOutput) SetDescription(v string) *GetWorkflowOutput {
	s.Description = &v
	return s
}

// SetDigest sets the Digest field's value.
func (s *GetWorkflowOutput) SetDigest(v string) *GetWorkflowOutput {
	s.Digest = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *GetWorkflowOutput) SetEngine(v string) *GetWorkflowOutput {
	s.Engine = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetWorkflowOutput) SetId(v string) *GetWorkflowOutput {
	s.Id = &v
	return s
}

// SetMain sets the Main field's value.
func (s *GetWorkflowOutput) SetMain(v string) *GetWorkflowOutput {
	s.Main = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetWorkflowOutput) SetMetadata(v map[string]*string) *GetWorkflowOutput {
	s.Metadata = v
	return s
}

// SetName sets the Name field's value.
func (s *GetWorkflowOutput) SetName(v string) *GetWorkflowOutput {
	s.Name = &v
	return s
}

// SetParameterTemplate sets the ParameterTemplate field's value.
func (s *GetWorkflowOutput) SetParameterTemplate(v map[string]*WorkflowParameter) *GetWorkflowOutput {
	s.ParameterTemplate = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetWorkflowOutput) SetStatus(v string) *GetWorkflowOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetWorkflowOutput) SetStatusMessage(v string) *GetWorkflowOutput {
	s.StatusMessage = &v
	return s
}

// SetStorageCapacity sets the StorageCapacity field's value.
func (s *GetWorkflowOutput) SetStorageCapacity(v int64) *GetWorkflowOutput {
	s.StorageCapacity = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetWorkflowOutput) SetTags(v map[string]*string) *GetWorkflowOutput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *GetWorkflowOutput) SetType(v string) *GetWorkflowOutput {
	s.Type = &v
	return s
}

// A filter for import read set jobs.
type ImportReadSetFilter struct {
	_ struct{} `type:"structure"`

	// The filter's start date.
	CreatedAfter *time.Time `locationName:"createdAfter" type:"timestamp" timestampFormat:"iso8601"`

	// The filter's end date.
	CreatedBefore *time.Time `locationName:"createdBefore" type:"timestamp" timestampFormat:"iso8601"`

	// A status to filter on.
	Status *string `locationName:"status" type:"string" enum:"ReadSetImportJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportReadSetFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportReadSetFilter) GoString() string {
	return s.String()
}

// SetCreatedAfter sets the CreatedAfter field's value.
func (s *ImportReadSetFilter) SetCreatedAfter(v time.Time) *ImportReadSetFilter {
	s.CreatedAfter = &v
	return s
}

// SetCreatedBefore sets the CreatedBefore field's value.
func (s *ImportReadSetFilter) SetCreatedBefore(v time.Time) *ImportReadSetFilter {
	s.CreatedBefore = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ImportReadSetFilter) SetStatus(v string) *ImportReadSetFilter {
	s.Status = &v
	return s
}

// An import read set job.
type ImportReadSetJobItem struct {
	_ struct{} `type:"structure"`

	// When the job completed.
	CompletionTime *time.Time `locationName:"completionTime" type:"timestamp" timestampFormat:"iso8601"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The job's service role ARN.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The job's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The job's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReadSetImportJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportReadSetJobItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportReadSetJobItem) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *ImportReadSetJobItem) SetCompletionTime(v time.Time) *ImportReadSetJobItem {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ImportReadSetJobItem) SetCreationTime(v time.Time) *ImportReadSetJobItem {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *ImportReadSetJobItem) SetId(v string) *ImportReadSetJobItem {
	s.Id = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ImportReadSetJobItem) SetRoleArn(v string) *ImportReadSetJobItem {
	s.RoleArn = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *ImportReadSetJobItem) SetSequenceStoreId(v string) *ImportReadSetJobItem {
	s.SequenceStoreId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ImportReadSetJobItem) SetStatus(v string) *ImportReadSetJobItem {
	s.Status = &v
	return s
}

// A source for an import read set job.
type ImportReadSetSourceItem struct {
	_ struct{} `type:"structure"`

	// The source's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Where the source originated.
	GeneratedFrom *string `locationName:"generatedFrom" min:"1" type:"string"`

	// The source's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The source's genome reference ARN.
	ReferenceArn *string `locationName:"referenceArn" min:"1" type:"string"`

	// The source's sample ID.
	//
	// SampleId is a required field
	SampleId *string `locationName:"sampleId" min:"1" type:"string" required:"true"`

	// The source's file type.
	//
	// SourceFileType is a required field
	SourceFileType *string `locationName:"sourceFileType" type:"string" required:"true" enum:"FileType"`

	// The source files' location in Amazon S3.
	//
	// SourceFiles is a required field
	SourceFiles *SourceFiles `locationName:"sourceFiles" type:"structure" required:"true"`

	// The source's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReadSetImportJobItemStatus"`

	// The source's status message.
	StatusMessage *string `locationName:"statusMessage" min:"1" type:"string"`

	// The source's subject ID.
	//
	// SubjectId is a required field
	SubjectId *string `locationName:"subjectId" min:"1" type:"string" required:"true"`

	// The source's tags.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportReadSetSourceItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportReadSetSourceItem) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ImportReadSetSourceItem) SetDescription(v string) *ImportReadSetSourceItem {
	s.Description = &v
	return s
}

// SetGeneratedFrom sets the GeneratedFrom field's value.
func (s *ImportReadSetSourceItem) SetGeneratedFrom(v string) *ImportReadSetSourceItem {
	s.GeneratedFrom = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImportReadSetSourceItem) SetName(v string) *ImportReadSetSourceItem {
	s.Name = &v
	return s
}

// SetReferenceArn sets the ReferenceArn field's value.
func (s *ImportReadSetSourceItem) SetReferenceArn(v string) *ImportReadSetSourceItem {
	s.ReferenceArn = &v
	return s
}

// SetSampleId sets the SampleId field's value.
func (s *ImportReadSetSourceItem) SetSampleId(v string) *ImportReadSetSourceItem {
	s.SampleId = &v
	return s
}

// SetSourceFileType sets the SourceFileType field's value.
func (s *ImportReadSetSourceItem) SetSourceFileType(v string) *ImportReadSetSourceItem {
	s.SourceFileType = &v
	return s
}

// SetSourceFiles sets the SourceFiles field's value.
func (s *ImportReadSetSourceItem) SetSourceFiles(v *SourceFiles) *ImportReadSetSourceItem {
	s.SourceFiles = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ImportReadSetSourceItem) SetStatus(v string) *ImportReadSetSourceItem {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ImportReadSetSourceItem) SetStatusMessage(v string) *ImportReadSetSourceItem {
	s.StatusMessage = &v
	return s
}

// SetSubjectId sets the SubjectId field's value.
func (s *ImportReadSetSourceItem) SetSubjectId(v string) *ImportReadSetSourceItem {
	s.SubjectId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportReadSetSourceItem) SetTags(v map[string]*string) *ImportReadSetSourceItem {
	s.Tags = v
	return s
}

// A filter for import references.
type ImportReferenceFilter struct {
	_ struct{} `type:"structure"`

	// The filter's start date.
	CreatedAfter *time.Time `locationName:"createdAfter" type:"timestamp" timestampFormat:"iso8601"`

	// The filter's end date.
	CreatedBefore *time.Time `locationName:"createdBefore" type:"timestamp" timestampFormat:"iso8601"`

	// A status to filter on.
	Status *string `locationName:"status" type:"string" enum:"ReferenceImportJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportReferenceFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportReferenceFilter) GoString() string {
	return s.String()
}

// SetCreatedAfter sets the CreatedAfter field's value.
func (s *ImportReferenceFilter) SetCreatedAfter(v time.Time) *ImportReferenceFilter {
	s.CreatedAfter = &v
	return s
}

// SetCreatedBefore sets the CreatedBefore field's value.
func (s *ImportReferenceFilter) SetCreatedBefore(v time.Time) *ImportReferenceFilter {
	s.CreatedBefore = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ImportReferenceFilter) SetStatus(v string) *ImportReferenceFilter {
	s.Status = &v
	return s
}

// An import reference job.
type ImportReferenceJobItem struct {
	_ struct{} `type:"structure"`

	// When the job completed.
	CompletionTime *time.Time `locationName:"completionTime" type:"timestamp" timestampFormat:"iso8601"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The job's reference store ID.
	//
	// ReferenceStoreId is a required field
	ReferenceStoreId *string `locationName:"referenceStoreId" min:"10" type:"string" required:"true"`

	// The job's service role ARN.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The job's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReferenceImportJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportReferenceJobItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportReferenceJobItem) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *ImportReferenceJobItem) SetCompletionTime(v time.Time) *ImportReferenceJobItem {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ImportReferenceJobItem) SetCreationTime(v time.Time) *ImportReferenceJobItem {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *ImportReferenceJobItem) SetId(v string) *ImportReferenceJobItem {
	s.Id = &v
	return s
}

// SetReferenceStoreId sets the ReferenceStoreId field's value.
func (s *ImportReferenceJobItem) SetReferenceStoreId(v string) *ImportReferenceJobItem {
	s.ReferenceStoreId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ImportReferenceJobItem) SetRoleArn(v string) *ImportReferenceJobItem {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ImportReferenceJobItem) SetStatus(v string) *ImportReferenceJobItem {
	s.Status = &v
	return s
}

// An genome reference source.
type ImportReferenceSourceItem struct {
	_ struct{} `type:"structure"`

	// The source's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The source's name.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The source file's location in Amazon S3.
	SourceFile *string `locationName:"sourceFile" type:"string"`

	// The source's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReferenceImportJobItemStatus"`

	// The source's status message.
	StatusMessage *string `locationName:"statusMessage" min:"1" type:"string"`

	// The source's tags.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportReferenceSourceItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportReferenceSourceItem) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ImportReferenceSourceItem) SetDescription(v string) *ImportReferenceSourceItem {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImportReferenceSourceItem) SetName(v string) *ImportReferenceSourceItem {
	s.Name = &v
	return s
}

// SetSourceFile sets the SourceFile field's value.
func (s *ImportReferenceSourceItem) SetSourceFile(v string) *ImportReferenceSourceItem {
	s.SourceFile = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ImportReferenceSourceItem) SetStatus(v string) *ImportReferenceSourceItem {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ImportReferenceSourceItem) SetStatusMessage(v string) *ImportReferenceSourceItem {
	s.StatusMessage = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportReferenceSourceItem) SetTags(v map[string]*string) *ImportReferenceSourceItem {
	s.Tags = v
	return s
}

// An unexpected error occurred. Try the request again.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A filter for annotation import jobs.
type ListAnnotationImportJobsFilter struct {
	_ struct{} `type:"structure"`

	// A status to filter on.
	Status *string `locationName:"status" type:"string" enum:"JobStatus"`

	// A store name to filter on.
	StoreName *string `locationName:"storeName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnnotationImportJobsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnnotationImportJobsFilter) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *ListAnnotationImportJobsFilter) SetStatus(v string) *ListAnnotationImportJobsFilter {
	s.Status = &v
	return s
}

// SetStoreName sets the StoreName field's value.
func (s *ListAnnotationImportJobsFilter) SetStoreName(v string) *ListAnnotationImportJobsFilter {
	s.StoreName = &v
	return s
}

type ListAnnotationImportJobsInput struct {
	_ struct{} `type:"structure"`

	// A filter to apply to the list.
	Filter *ListAnnotationImportJobsFilter `locationName:"filter" type:"structure"`

	// IDs of annotation import jobs to retrieve.
	Ids []*string `locationName:"ids" min:"1" type:"list"`

	// The maximum number of jobs to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Specifies the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnnotationImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnnotationImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAnnotationImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAnnotationImportJobsInput"}
	if s.Ids != nil && len(s.Ids) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ids", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListAnnotationImportJobsInput) SetFilter(v *ListAnnotationImportJobsFilter) *ListAnnotationImportJobsInput {
	s.Filter = v
	return s
}

// SetIds sets the Ids field's value.
func (s *ListAnnotationImportJobsInput) SetIds(v []*string) *ListAnnotationImportJobsInput {
	s.Ids = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAnnotationImportJobsInput) SetMaxResults(v int64) *ListAnnotationImportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnnotationImportJobsInput) SetNextToken(v string) *ListAnnotationImportJobsInput {
	s.NextToken = &v
	return s
}

type ListAnnotationImportJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of jobs.
	AnnotationImportJobs []*AnnotationImportJobItem `locationName:"annotationImportJobs" type:"list"`

	// Specifies the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnnotationImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnnotationImportJobsOutput) GoString() string {
	return s.String()
}

// SetAnnotationImportJobs sets the AnnotationImportJobs field's value.
func (s *ListAnnotationImportJobsOutput) SetAnnotationImportJobs(v []*AnnotationImportJobItem) *ListAnnotationImportJobsOutput {
	s.AnnotationImportJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnnotationImportJobsOutput) SetNextToken(v string) *ListAnnotationImportJobsOutput {
	s.NextToken = &v
	return s
}

// Use filters to focus the returned annotation store versions on a specific
// parameter, such as the status of the annotation store.
type ListAnnotationStoreVersionsFilter struct {
	_ struct{} `type:"structure"`

	// The status of an annotation store version.
	Status *string `locationName:"status" type:"string" enum:"VersionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnnotationStoreVersionsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnnotationStoreVersionsFilter) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *ListAnnotationStoreVersionsFilter) SetStatus(v string) *ListAnnotationStoreVersionsFilter {
	s.Status = &v
	return s
}

type ListAnnotationStoreVersionsInput struct {
	_ struct{} `type:"structure"`

	// A filter to apply to the list of annotation store versions.
	Filter *ListAnnotationStoreVersionsFilter `locationName:"filter" type:"structure"`

	// The maximum number of annotation store versions to return in one page of
	// results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The name of an annotation store.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// Specifies the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnnotationStoreVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnnotationStoreVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAnnotationStoreVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAnnotationStoreVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListAnnotationStoreVersionsInput) SetFilter(v *ListAnnotationStoreVersionsFilter) *ListAnnotationStoreVersionsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAnnotationStoreVersionsInput) SetMaxResults(v int64) *ListAnnotationStoreVersionsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListAnnotationStoreVersionsInput) SetName(v string) *ListAnnotationStoreVersionsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnnotationStoreVersionsInput) SetNextToken(v string) *ListAnnotationStoreVersionsInput {
	s.NextToken = &v
	return s
}

type ListAnnotationStoreVersionsOutput struct {
	_ struct{} `type:"structure"`

	// Lists all versions of an annotation store.
	AnnotationStoreVersions []*AnnotationStoreVersionItem `locationName:"annotationStoreVersions" type:"list"`

	// Specifies the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnnotationStoreVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnnotationStoreVersionsOutput) GoString() string {
	return s.String()
}

// SetAnnotationStoreVersions sets the AnnotationStoreVersions field's value.
func (s *ListAnnotationStoreVersionsOutput) SetAnnotationStoreVersions(v []*AnnotationStoreVersionItem) *ListAnnotationStoreVersionsOutput {
	s.AnnotationStoreVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnnotationStoreVersionsOutput) SetNextToken(v string) *ListAnnotationStoreVersionsOutput {
	s.NextToken = &v
	return s
}

// A filter for annotation stores.
type ListAnnotationStoresFilter struct {
	_ struct{} `type:"structure"`

	// A status to filter on.
	Status *string `locationName:"status" type:"string" enum:"StoreStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnnotationStoresFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnnotationStoresFilter) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *ListAnnotationStoresFilter) SetStatus(v string) *ListAnnotationStoresFilter {
	s.Status = &v
	return s
}

type ListAnnotationStoresInput struct {
	_ struct{} `type:"structure"`

	// A filter to apply to the list.
	Filter *ListAnnotationStoresFilter `locationName:"filter" type:"structure"`

	// IDs of stores to list.
	Ids []*string `locationName:"ids" min:"1" type:"list"`

	// The maximum number of stores to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnnotationStoresInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnnotationStoresInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAnnotationStoresInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAnnotationStoresInput"}
	if s.Ids != nil && len(s.Ids) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ids", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListAnnotationStoresInput) SetFilter(v *ListAnnotationStoresFilter) *ListAnnotationStoresInput {
	s.Filter = v
	return s
}

// SetIds sets the Ids field's value.
func (s *ListAnnotationStoresInput) SetIds(v []*string) *ListAnnotationStoresInput {
	s.Ids = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAnnotationStoresInput) SetMaxResults(v int64) *ListAnnotationStoresInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnnotationStoresInput) SetNextToken(v string) *ListAnnotationStoresInput {
	s.NextToken = &v
	return s
}

type ListAnnotationStoresOutput struct {
	_ struct{} `type:"structure"`

	// A list of stores.
	AnnotationStores []*AnnotationStoreItem `locationName:"annotationStores" type:"list"`

	// A pagination token that's included if more results are available.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnnotationStoresOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnnotationStoresOutput) GoString() string {
	return s.String()
}

// SetAnnotationStores sets the AnnotationStores field's value.
func (s *ListAnnotationStoresOutput) SetAnnotationStores(v []*AnnotationStoreItem) *ListAnnotationStoresOutput {
	s.AnnotationStores = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnnotationStoresOutput) SetNextToken(v string) *ListAnnotationStoresOutput {
	s.NextToken = &v
	return s
}

type ListMultipartReadSetUploadsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of multipart uploads returned in a page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Next token returned in the response of a previous ListMultipartReadSetUploads
	// call. Used to get the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The Sequence Store ID used for the multipart uploads.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMultipartReadSetUploadsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMultipartReadSetUploadsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMultipartReadSetUploadsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMultipartReadSetUploadsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMultipartReadSetUploadsInput) SetMaxResults(v int64) *ListMultipartReadSetUploadsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMultipartReadSetUploadsInput) SetNextToken(v string) *ListMultipartReadSetUploadsInput {
	s.NextToken = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *ListMultipartReadSetUploadsInput) SetSequenceStoreId(v string) *ListMultipartReadSetUploadsInput {
	s.SequenceStoreId = &v
	return s
}

type ListMultipartReadSetUploadsOutput struct {
	_ struct{} `type:"structure"`

	// Next token returned in the response of a previous ListMultipartReadSetUploads
	// call. Used to get the next page of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// An array of multipart uploads.
	Uploads []*MultipartReadSetUploadListItem `locationName:"uploads" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMultipartReadSetUploadsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMultipartReadSetUploadsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListMultipartReadSetUploadsOutput) SetNextToken(v string) *ListMultipartReadSetUploadsOutput {
	s.NextToken = &v
	return s
}

// SetUploads sets the Uploads field's value.
func (s *ListMultipartReadSetUploadsOutput) SetUploads(v []*MultipartReadSetUploadListItem) *ListMultipartReadSetUploadsOutput {
	s.Uploads = v
	return s
}

type ListReadSetActivationJobsInput struct {
	_ struct{} `type:"structure"`

	// A filter to apply to the list.
	Filter *ActivateReadSetFilter `locationName:"filter" type:"structure"`

	// The maximum number of read set activation jobs to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The read set's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetActivationJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetActivationJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReadSetActivationJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReadSetActivationJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListReadSetActivationJobsInput) SetFilter(v *ActivateReadSetFilter) *ListReadSetActivationJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReadSetActivationJobsInput) SetMaxResults(v int64) *ListReadSetActivationJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReadSetActivationJobsInput) SetNextToken(v string) *ListReadSetActivationJobsInput {
	s.NextToken = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *ListReadSetActivationJobsInput) SetSequenceStoreId(v string) *ListReadSetActivationJobsInput {
	s.SequenceStoreId = &v
	return s
}

type ListReadSetActivationJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of jobs.
	ActivationJobs []*ActivateReadSetJobItem `locationName:"activationJobs" type:"list"`

	// A pagination token that's included if more results are available.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetActivationJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetActivationJobsOutput) GoString() string {
	return s.String()
}

// SetActivationJobs sets the ActivationJobs field's value.
func (s *ListReadSetActivationJobsOutput) SetActivationJobs(v []*ActivateReadSetJobItem) *ListReadSetActivationJobsOutput {
	s.ActivationJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReadSetActivationJobsOutput) SetNextToken(v string) *ListReadSetActivationJobsOutput {
	s.NextToken = &v
	return s
}

type ListReadSetExportJobsInput struct {
	_ struct{} `type:"structure"`

	// A filter to apply to the list.
	Filter *ExportReadSetFilter `locationName:"filter" type:"structure"`

	// The maximum number of jobs to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The jobs' sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetExportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetExportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReadSetExportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReadSetExportJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListReadSetExportJobsInput) SetFilter(v *ExportReadSetFilter) *ListReadSetExportJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReadSetExportJobsInput) SetMaxResults(v int64) *ListReadSetExportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReadSetExportJobsInput) SetNextToken(v string) *ListReadSetExportJobsInput {
	s.NextToken = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *ListReadSetExportJobsInput) SetSequenceStoreId(v string) *ListReadSetExportJobsInput {
	s.SequenceStoreId = &v
	return s
}

type ListReadSetExportJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of jobs.
	ExportJobs []*ExportReadSetJobDetail `locationName:"exportJobs" type:"list"`

	// A pagination token that's included if more results are available.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetExportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetExportJobsOutput) GoString() string {
	return s.String()
}

// SetExportJobs sets the ExportJobs field's value.
func (s *ListReadSetExportJobsOutput) SetExportJobs(v []*ExportReadSetJobDetail) *ListReadSetExportJobsOutput {
	s.ExportJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReadSetExportJobsOutput) SetNextToken(v string) *ListReadSetExportJobsOutput {
	s.NextToken = &v
	return s
}

type ListReadSetImportJobsInput struct {
	_ struct{} `type:"structure"`

	// A filter to apply to the list.
	Filter *ImportReadSetFilter `locationName:"filter" type:"structure"`

	// The maximum number of jobs to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The jobs' sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReadSetImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReadSetImportJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListReadSetImportJobsInput) SetFilter(v *ImportReadSetFilter) *ListReadSetImportJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReadSetImportJobsInput) SetMaxResults(v int64) *ListReadSetImportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReadSetImportJobsInput) SetNextToken(v string) *ListReadSetImportJobsInput {
	s.NextToken = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *ListReadSetImportJobsInput) SetSequenceStoreId(v string) *ListReadSetImportJobsInput {
	s.SequenceStoreId = &v
	return s
}

type ListReadSetImportJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of jobs.
	ImportJobs []*ImportReadSetJobItem `locationName:"importJobs" type:"list"`

	// A pagination token that's included if more results are available.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetImportJobsOutput) GoString() string {
	return s.String()
}

// SetImportJobs sets the ImportJobs field's value.
func (s *ListReadSetImportJobsOutput) SetImportJobs(v []*ImportReadSetJobItem) *ListReadSetImportJobsOutput {
	s.ImportJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReadSetImportJobsOutput) SetNextToken(v string) *ListReadSetImportJobsOutput {
	s.NextToken = &v
	return s
}

type ListReadSetUploadPartsInput struct {
	_ struct{} `type:"structure"`

	// Attributes used to filter for a specific subset of read set part uploads.
	Filter *ReadSetUploadPartListFilter `locationName:"filter" type:"structure"`

	// The maximum number of read set upload parts returned in a page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Next token returned in the response of a previous ListReadSetUploadPartsRequest
	// call. Used to get the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The source file for the upload part.
	//
	// PartSource is a required field
	PartSource *string `locationName:"partSource" type:"string" required:"true" enum:"ReadSetPartSource"`

	// The Sequence Store ID used for the multipart uploads.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The ID for the initiated multipart upload.
	//
	// UploadId is a required field
	UploadId *string `location:"uri" locationName:"uploadId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetUploadPartsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetUploadPartsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReadSetUploadPartsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReadSetUploadPartsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PartSource == nil {
		invalidParams.Add(request.NewErrParamRequired("PartSource"))
	}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}
	if s.UploadId != nil && len(*s.UploadId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("UploadId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListReadSetUploadPartsInput) SetFilter(v *ReadSetUploadPartListFilter) *ListReadSetUploadPartsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReadSetUploadPartsInput) SetMaxResults(v int64) *ListReadSetUploadPartsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReadSetUploadPartsInput) SetNextToken(v string) *ListReadSetUploadPartsInput {
	s.NextToken = &v
	return s
}

// SetPartSource sets the PartSource field's value.
func (s *ListReadSetUploadPartsInput) SetPartSource(v string) *ListReadSetUploadPartsInput {
	s.PartSource = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *ListReadSetUploadPartsInput) SetSequenceStoreId(v string) *ListReadSetUploadPartsInput {
	s.SequenceStoreId = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *ListReadSetUploadPartsInput) SetUploadId(v string) *ListReadSetUploadPartsInput {
	s.UploadId = &v
	return s
}

type ListReadSetUploadPartsOutput struct {
	_ struct{} `type:"structure"`

	// Next token returned in the response of a previous ListReadSetUploadParts
	// call. Used to get the next page of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// An array of upload parts.
	Parts []*ReadSetUploadPartListItem `locationName:"parts" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetUploadPartsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetUploadPartsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReadSetUploadPartsOutput) SetNextToken(v string) *ListReadSetUploadPartsOutput {
	s.NextToken = &v
	return s
}

// SetParts sets the Parts field's value.
func (s *ListReadSetUploadPartsOutput) SetParts(v []*ReadSetUploadPartListItem) *ListReadSetUploadPartsOutput {
	s.Parts = v
	return s
}

type ListReadSetsInput struct {
	_ struct{} `type:"structure"`

	// A filter to apply to the list.
	Filter *ReadSetFilter `locationName:"filter" type:"structure"`

	// The maximum number of read sets to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The jobs' sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReadSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReadSetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListReadSetsInput) SetFilter(v *ReadSetFilter) *ListReadSetsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReadSetsInput) SetMaxResults(v int64) *ListReadSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReadSetsInput) SetNextToken(v string) *ListReadSetsInput {
	s.NextToken = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *ListReadSetsInput) SetSequenceStoreId(v string) *ListReadSetsInput {
	s.SequenceStoreId = &v
	return s
}

type ListReadSetsOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that's included if more results are available.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of read sets.
	//
	// ReadSets is a required field
	ReadSets []*ReadSetListItem `locationName:"readSets" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReadSetsOutput) SetNextToken(v string) *ListReadSetsOutput {
	s.NextToken = &v
	return s
}

// SetReadSets sets the ReadSets field's value.
func (s *ListReadSetsOutput) SetReadSets(v []*ReadSetListItem) *ListReadSetsOutput {
	s.ReadSets = v
	return s
}

type ListReferenceImportJobsInput struct {
	_ struct{} `type:"structure"`

	// A filter to apply to the list.
	Filter *ImportReferenceFilter `locationName:"filter" type:"structure"`

	// The maximum number of jobs to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The job's reference store ID.
	//
	// ReferenceStoreId is a required field
	ReferenceStoreId *string `location:"uri" locationName:"referenceStoreId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReferenceImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReferenceImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReferenceImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReferenceImportJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ReferenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceStoreId"))
	}
	if s.ReferenceStoreId != nil && len(*s.ReferenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ReferenceStoreId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListReferenceImportJobsInput) SetFilter(v *ImportReferenceFilter) *ListReferenceImportJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReferenceImportJobsInput) SetMaxResults(v int64) *ListReferenceImportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReferenceImportJobsInput) SetNextToken(v string) *ListReferenceImportJobsInput {
	s.NextToken = &v
	return s
}

// SetReferenceStoreId sets the ReferenceStoreId field's value.
func (s *ListReferenceImportJobsInput) SetReferenceStoreId(v string) *ListReferenceImportJobsInput {
	s.ReferenceStoreId = &v
	return s
}

type ListReferenceImportJobsOutput struct {
	_ struct{} `type:"structure"`

	// A lis of jobs.
	ImportJobs []*ImportReferenceJobItem `locationName:"importJobs" type:"list"`

	// A pagination token that's included if more results are available.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReferenceImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReferenceImportJobsOutput) GoString() string {
	return s.String()
}

// SetImportJobs sets the ImportJobs field's value.
func (s *ListReferenceImportJobsOutput) SetImportJobs(v []*ImportReferenceJobItem) *ListReferenceImportJobsOutput {
	s.ImportJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReferenceImportJobsOutput) SetNextToken(v string) *ListReferenceImportJobsOutput {
	s.NextToken = &v
	return s
}

type ListReferenceStoresInput struct {
	_ struct{} `type:"structure"`

	// A filter to apply to the list.
	Filter *ReferenceStoreFilter `locationName:"filter" type:"structure"`

	// The maximum number of stores to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReferenceStoresInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReferenceStoresInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReferenceStoresInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReferenceStoresInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListReferenceStoresInput) SetFilter(v *ReferenceStoreFilter) *ListReferenceStoresInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReferenceStoresInput) SetMaxResults(v int64) *ListReferenceStoresInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReferenceStoresInput) SetNextToken(v string) *ListReferenceStoresInput {
	s.NextToken = &v
	return s
}

type ListReferenceStoresOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that's included if more results are available.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of reference stores.
	//
	// ReferenceStores is a required field
	ReferenceStores []*ReferenceStoreDetail `locationName:"referenceStores" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReferenceStoresOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReferenceStoresOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReferenceStoresOutput) SetNextToken(v string) *ListReferenceStoresOutput {
	s.NextToken = &v
	return s
}

// SetReferenceStores sets the ReferenceStores field's value.
func (s *ListReferenceStoresOutput) SetReferenceStores(v []*ReferenceStoreDetail) *ListReferenceStoresOutput {
	s.ReferenceStores = v
	return s
}

type ListReferencesInput struct {
	_ struct{} `type:"structure"`

	// A filter to apply to the list.
	Filter *ReferenceFilter `locationName:"filter" type:"structure"`

	// The maximum number of references to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The references' reference store ID.
	//
	// ReferenceStoreId is a required field
	ReferenceStoreId *string `location:"uri" locationName:"referenceStoreId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReferencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReferencesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReferencesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReferencesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ReferenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceStoreId"))
	}
	if s.ReferenceStoreId != nil && len(*s.ReferenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ReferenceStoreId", 10))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListReferencesInput) SetFilter(v *ReferenceFilter) *ListReferencesInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReferencesInput) SetMaxResults(v int64) *ListReferencesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReferencesInput) SetNextToken(v string) *ListReferencesInput {
	s.NextToken = &v
	return s
}

// SetReferenceStoreId sets the ReferenceStoreId field's value.
func (s *ListReferencesInput) SetReferenceStoreId(v string) *ListReferencesInput {
	s.ReferenceStoreId = &v
	return s
}

type ListReferencesOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that's included if more results are available.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of references.
	//
	// References is a required field
	References []*ReferenceListItem `locationName:"references" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReferencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReferencesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReferencesOutput) SetNextToken(v string) *ListReferencesOutput {
	s.NextToken = &v
	return s
}

// SetReferences sets the References field's value.
func (s *ListReferencesOutput) SetReferences(v []*ReferenceListItem) *ListReferencesOutput {
	s.References = v
	return s
}

type ListRunGroupsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of run groups to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The run groups' name.
	Name *string `location:"querystring" locationName:"name" min:"1" type:"string"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	StartingToken *string `location:"querystring" locationName:"startingToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRunGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRunGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRunGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRunGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.StartingToken != nil && len(*s.StartingToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StartingToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRunGroupsInput) SetMaxResults(v int64) *ListRunGroupsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListRunGroupsInput) SetName(v string) *ListRunGroupsInput {
	s.Name = &v
	return s
}

// SetStartingToken sets the StartingToken field's value.
func (s *ListRunGroupsInput) SetStartingToken(v string) *ListRunGroupsInput {
	s.StartingToken = &v
	return s
}

type ListRunGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of groups.
	Items []*RunGroupListItem `locationName:"items" type:"list"`

	// A pagination token that's included if more results are available.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRunGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRunGroupsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListRunGroupsOutput) SetItems(v []*RunGroupListItem) *ListRunGroupsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRunGroupsOutput) SetNextToken(v string) *ListRunGroupsOutput {
	s.NextToken = &v
	return s
}

type ListRunTasksInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The run's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The maximum number of run tasks to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	StartingToken *string `location:"querystring" locationName:"startingToken" min:"1" type:"string"`

	// Filter the list by status.
	Status *string `location:"querystring" locationName:"status" min:"1" type:"string" enum:"TaskStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRunTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRunTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRunTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRunTasksInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StartingToken != nil && len(*s.StartingToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StartingToken", 1))
	}
	if s.Status != nil && len(*s.Status) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Status", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *ListRunTasksInput) SetId(v string) *ListRunTasksInput {
	s.Id = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRunTasksInput) SetMaxResults(v int64) *ListRunTasksInput {
	s.MaxResults = &v
	return s
}

// SetStartingToken sets the StartingToken field's value.
func (s *ListRunTasksInput) SetStartingToken(v string) *ListRunTasksInput {
	s.StartingToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListRunTasksInput) SetStatus(v string) *ListRunTasksInput {
	s.Status = &v
	return s
}

type ListRunTasksOutput struct {
	_ struct{} `type:"structure"`

	// A list of tasks.
	Items []*TaskListItem `locationName:"items" type:"list"`

	// A pagination token that's included if more results are available.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRunTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRunTasksOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListRunTasksOutput) SetItems(v []*TaskListItem) *ListRunTasksOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRunTasksOutput) SetNextToken(v string) *ListRunTasksOutput {
	s.NextToken = &v
	return s
}

type ListRunsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of runs to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Filter the list by run name.
	Name *string `location:"querystring" locationName:"name" min:"1" type:"string"`

	// Filter the list by run group ID.
	RunGroupId *string `location:"querystring" locationName:"runGroupId" min:"1" type:"string"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	StartingToken *string `location:"querystring" locationName:"startingToken" min:"1" type:"string"`

	// The status of a run.
	Status *string `location:"querystring" locationName:"status" min:"1" type:"string" enum:"RunStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRunsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRunsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRunsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRunsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RunGroupId != nil && len(*s.RunGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RunGroupId", 1))
	}
	if s.StartingToken != nil && len(*s.StartingToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StartingToken", 1))
	}
	if s.Status != nil && len(*s.Status) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Status", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRunsInput) SetMaxResults(v int64) *ListRunsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListRunsInput) SetName(v string) *ListRunsInput {
	s.Name = &v
	return s
}

// SetRunGroupId sets the RunGroupId field's value.
func (s *ListRunsInput) SetRunGroupId(v string) *ListRunsInput {
	s.RunGroupId = &v
	return s
}

// SetStartingToken sets the StartingToken field's value.
func (s *ListRunsInput) SetStartingToken(v string) *ListRunsInput {
	s.StartingToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListRunsInput) SetStatus(v string) *ListRunsInput {
	s.Status = &v
	return s
}

type ListRunsOutput struct {
	_ struct{} `type:"structure"`

	// A list of runs.
	Items []*RunListItem `locationName:"items" type:"list"`

	// A pagination token that's included if more results are available.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRunsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRunsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListRunsOutput) SetItems(v []*RunListItem) *ListRunsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRunsOutput) SetNextToken(v string) *ListRunsOutput {
	s.NextToken = &v
	return s
}

type ListSequenceStoresInput struct {
	_ struct{} `type:"structure"`

	// A filter to apply to the list.
	Filter *SequenceStoreFilter `locationName:"filter" type:"structure"`

	// The maximum number of stores to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSequenceStoresInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSequenceStoresInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSequenceStoresInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSequenceStoresInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListSequenceStoresInput) SetFilter(v *SequenceStoreFilter) *ListSequenceStoresInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSequenceStoresInput) SetMaxResults(v int64) *ListSequenceStoresInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSequenceStoresInput) SetNextToken(v string) *ListSequenceStoresInput {
	s.NextToken = &v
	return s
}

type ListSequenceStoresOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that's included if more results are available.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of sequence stores.
	//
	// SequenceStores is a required field
	SequenceStores []*SequenceStoreDetail `locationName:"sequenceStores" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSequenceStoresOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSequenceStoresOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSequenceStoresOutput) SetNextToken(v string) *ListSequenceStoresOutput {
	s.NextToken = &v
	return s
}

// SetSequenceStores sets the SequenceStores field's value.
func (s *ListSequenceStoresOutput) SetSequenceStores(v []*SequenceStoreDetail) *ListSequenceStoresOutput {
	s.SequenceStores = v
	return s
}

type ListSharesInput struct {
	_ struct{} `type:"structure"`

	// Attributes used to filter for a specific subset of shares.
	Filter *Filter `locationName:"filter" type:"structure"`

	// The maximum number of shares to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Next token returned in the response of a previous ListReadSetUploadPartsRequest
	// call. Used to get the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The account that owns the analytics store shared.
	//
	// ResourceOwner is a required field
	ResourceOwner *string `locationName:"resourceOwner" type:"string" required:"true" enum:"ResourceOwner"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSharesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSharesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSharesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSharesInput"}
	if s.ResourceOwner == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceOwner"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListSharesInput) SetFilter(v *Filter) *ListSharesInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSharesInput) SetMaxResults(v int64) *ListSharesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSharesInput) SetNextToken(v string) *ListSharesInput {
	s.NextToken = &v
	return s
}

// SetResourceOwner sets the ResourceOwner field's value.
func (s *ListSharesInput) SetResourceOwner(v string) *ListSharesInput {
	s.ResourceOwner = &v
	return s
}

type ListSharesOutput struct {
	_ struct{} `type:"structure"`

	// Next token returned in the response of a previous ListSharesResponse call.
	// Used to get the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The shares available and their meta details.
	//
	// Shares is a required field
	Shares []*ShareDetails `locationName:"shares" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSharesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSharesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSharesOutput) SetNextToken(v string) *ListSharesOutput {
	s.NextToken = &v
	return s
}

// SetShares sets the Shares field's value.
func (s *ListSharesOutput) SetShares(v []*ShareDetails) *ListSharesOutput {
	s.Shares = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The resource's ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A filter for variant import jobs.
type ListVariantImportJobsFilter struct {
	_ struct{} `type:"structure"`

	// A status to filter on.
	Status *string `locationName:"status" type:"string" enum:"JobStatus"`

	// A store name to filter on.
	StoreName *string `locationName:"storeName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVariantImportJobsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVariantImportJobsFilter) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *ListVariantImportJobsFilter) SetStatus(v string) *ListVariantImportJobsFilter {
	s.Status = &v
	return s
}

// SetStoreName sets the StoreName field's value.
func (s *ListVariantImportJobsFilter) SetStoreName(v string) *ListVariantImportJobsFilter {
	s.StoreName = &v
	return s
}

type ListVariantImportJobsInput struct {
	_ struct{} `type:"structure"`

	// A filter to apply to the list.
	Filter *ListVariantImportJobsFilter `locationName:"filter" type:"structure"`

	// A list of job IDs.
	Ids []*string `locationName:"ids" min:"1" type:"list"`

	// The maximum number of import jobs to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVariantImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVariantImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVariantImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVariantImportJobsInput"}
	if s.Ids != nil && len(s.Ids) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ids", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListVariantImportJobsInput) SetFilter(v *ListVariantImportJobsFilter) *ListVariantImportJobsInput {
	s.Filter = v
	return s
}

// SetIds sets the Ids field's value.
func (s *ListVariantImportJobsInput) SetIds(v []*string) *ListVariantImportJobsInput {
	s.Ids = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVariantImportJobsInput) SetMaxResults(v int64) *ListVariantImportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVariantImportJobsInput) SetNextToken(v string) *ListVariantImportJobsInput {
	s.NextToken = &v
	return s
}

type ListVariantImportJobsOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that's included if more results are available.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of jobs.
	VariantImportJobs []*VariantImportJobItem `locationName:"variantImportJobs" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVariantImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVariantImportJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVariantImportJobsOutput) SetNextToken(v string) *ListVariantImportJobsOutput {
	s.NextToken = &v
	return s
}

// SetVariantImportJobs sets the VariantImportJobs field's value.
func (s *ListVariantImportJobsOutput) SetVariantImportJobs(v []*VariantImportJobItem) *ListVariantImportJobsOutput {
	s.VariantImportJobs = v
	return s
}

// A filter for variant stores.
type ListVariantStoresFilter struct {
	_ struct{} `type:"structure"`

	// A status to filter on.
	Status *string `locationName:"status" type:"string" enum:"StoreStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVariantStoresFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVariantStoresFilter) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *ListVariantStoresFilter) SetStatus(v string) *ListVariantStoresFilter {
	s.Status = &v
	return s
}

type ListVariantStoresInput struct {
	_ struct{} `type:"structure"`

	// A filter to apply to the list.
	Filter *ListVariantStoresFilter `locationName:"filter" type:"structure"`

	// A list of store IDs.
	Ids []*string `locationName:"ids" min:"1" type:"list"`

	// The maximum number of stores to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVariantStoresInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVariantStoresInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVariantStoresInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVariantStoresInput"}
	if s.Ids != nil && len(s.Ids) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ids", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListVariantStoresInput) SetFilter(v *ListVariantStoresFilter) *ListVariantStoresInput {
	s.Filter = v
	return s
}

// SetIds sets the Ids field's value.
func (s *ListVariantStoresInput) SetIds(v []*string) *ListVariantStoresInput {
	s.Ids = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVariantStoresInput) SetMaxResults(v int64) *ListVariantStoresInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVariantStoresInput) SetNextToken(v string) *ListVariantStoresInput {
	s.NextToken = &v
	return s
}

type ListVariantStoresOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that's included if more results are available.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of variant stores.
	VariantStores []*VariantStoreItem `locationName:"variantStores" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVariantStoresOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVariantStoresOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVariantStoresOutput) SetNextToken(v string) *ListVariantStoresOutput {
	s.NextToken = &v
	return s
}

// SetVariantStores sets the VariantStores field's value.
func (s *ListVariantStoresOutput) SetVariantStores(v []*VariantStoreItem) *ListVariantStoresOutput {
	s.VariantStores = v
	return s
}

type ListWorkflowsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of workflows to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The workflows' name.
	Name *string `location:"querystring" locationName:"name" min:"1" type:"string"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	StartingToken *string `location:"querystring" locationName:"startingToken" min:"1" type:"string"`

	// The workflows' type.
	Type *string `location:"querystring" locationName:"type" min:"1" type:"string" enum:"WorkflowType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkflowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkflowsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.StartingToken != nil && len(*s.StartingToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StartingToken", 1))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkflowsInput) SetMaxResults(v int64) *ListWorkflowsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListWorkflowsInput) SetName(v string) *ListWorkflowsInput {
	s.Name = &v
	return s
}

// SetStartingToken sets the StartingToken field's value.
func (s *ListWorkflowsInput) SetStartingToken(v string) *ListWorkflowsInput {
	s.StartingToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListWorkflowsInput) SetType(v string) *ListWorkflowsInput {
	s.Type = &v
	return s
}

type ListWorkflowsOutput struct {
	_ struct{} `type:"structure"`

	// The workflows' items.
	Items []*WorkflowListItem `locationName:"items" type:"list"`

	// A pagination token that's included if more results are available.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListWorkflowsOutput) SetItems(v []*WorkflowListItem) *ListWorkflowsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkflowsOutput) SetNextToken(v string) *ListWorkflowsOutput {
	s.NextToken = &v
	return s
}

// Part of the response to ListMultipartReadSetUploads, excluding completed
// and aborted multipart uploads.
type MultipartReadSetUploadListItem struct {
	_ struct{} `type:"structure"`

	// The time stamp for when a direct upload was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of a read set.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The source of an uploaded part.
	//
	// GeneratedFrom is a required field
	GeneratedFrom *string `locationName:"generatedFrom" min:"1" type:"string" required:"true"`

	// The name of a read set.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The source's reference ARN.
	//
	// ReferenceArn is a required field
	ReferenceArn *string `locationName:"referenceArn" min:"1" type:"string" required:"true"`

	// The read set source's sample ID.
	//
	// SampleId is a required field
	SampleId *string `locationName:"sampleId" min:"1" type:"string" required:"true"`

	// The sequence store ID used for the multipart upload.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The type of file the read set originated from.
	//
	// SourceFileType is a required field
	SourceFileType *string `locationName:"sourceFileType" type:"string" required:"true" enum:"FileType"`

	// The read set source's subject ID.
	//
	// SubjectId is a required field
	SubjectId *string `locationName:"subjectId" min:"1" type:"string" required:"true"`

	// Any tags you wish to add to a read set.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The ID for the initiated multipart upload.
	//
	// UploadId is a required field
	UploadId *string `locationName:"uploadId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultipartReadSetUploadListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultipartReadSetUploadListItem) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *MultipartReadSetUploadListItem) SetCreationTime(v time.Time) *MultipartReadSetUploadListItem {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *MultipartReadSetUploadListItem) SetDescription(v string) *MultipartReadSetUploadListItem {
	s.Description = &v
	return s
}

// SetGeneratedFrom sets the GeneratedFrom field's value.
func (s *MultipartReadSetUploadListItem) SetGeneratedFrom(v string) *MultipartReadSetUploadListItem {
	s.GeneratedFrom = &v
	return s
}

// SetName sets the Name field's value.
func (s *MultipartReadSetUploadListItem) SetName(v string) *MultipartReadSetUploadListItem {
	s.Name = &v
	return s
}

// SetReferenceArn sets the ReferenceArn field's value.
func (s *MultipartReadSetUploadListItem) SetReferenceArn(v string) *MultipartReadSetUploadListItem {
	s.ReferenceArn = &v
	return s
}

// SetSampleId sets the SampleId field's value.
func (s *MultipartReadSetUploadListItem) SetSampleId(v string) *MultipartReadSetUploadListItem {
	s.SampleId = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *MultipartReadSetUploadListItem) SetSequenceStoreId(v string) *MultipartReadSetUploadListItem {
	s.SequenceStoreId = &v
	return s
}

// SetSourceFileType sets the SourceFileType field's value.
func (s *MultipartReadSetUploadListItem) SetSourceFileType(v string) *MultipartReadSetUploadListItem {
	s.SourceFileType = &v
	return s
}

// SetSubjectId sets the SubjectId field's value.
func (s *MultipartReadSetUploadListItem) SetSubjectId(v string) *MultipartReadSetUploadListItem {
	s.SubjectId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *MultipartReadSetUploadListItem) SetTags(v map[string]*string) *MultipartReadSetUploadListItem {
	s.Tags = v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *MultipartReadSetUploadListItem) SetUploadId(v string) *MultipartReadSetUploadListItem {
	s.UploadId = &v
	return s
}

// The operation is not supported by Amazon Omics, or the API does not exist.
type NotSupportedOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotSupportedOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotSupportedOperationException) GoString() string {
	return s.String()
}

func newErrorNotSupportedOperationException(v protocol.ResponseMetadata) error {
	return &NotSupportedOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotSupportedOperationException) Code() string {
	return "NotSupportedOperationException"
}

// Message returns the exception's message.
func (s *NotSupportedOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotSupportedOperationException) OrigErr() error {
	return nil
}

func (s *NotSupportedOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotSupportedOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotSupportedOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The ranges specified in the request are not valid.
type RangeNotSatisfiableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RangeNotSatisfiableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RangeNotSatisfiableException) GoString() string {
	return s.String()
}

func newErrorRangeNotSatisfiableException(v protocol.ResponseMetadata) error {
	return &RangeNotSatisfiableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RangeNotSatisfiableException) Code() string {
	return "RangeNotSatisfiableException"
}

// Message returns the exception's message.
func (s *RangeNotSatisfiableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RangeNotSatisfiableException) OrigErr() error {
	return nil
}

func (s *RangeNotSatisfiableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RangeNotSatisfiableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RangeNotSatisfiableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Read options for an annotation import job.
type ReadOptions struct {
	_ struct{} `type:"structure"`

	// The file's comment character.
	Comment *string `locationName:"comment" min:"1" type:"string"`

	// The file's encoding.
	Encoding *string `locationName:"encoding" min:"1" type:"string"`

	// A character for escaping quotes in the file.
	Escape *string `locationName:"escape" min:"1" type:"string"`

	// Whether quotes need to be escaped in the file.
	EscapeQuotes *bool `locationName:"escapeQuotes" type:"boolean"`

	// Whether the file has a header row.
	Header *bool `locationName:"header" type:"boolean"`

	// A line separator for the file.
	LineSep *string `locationName:"lineSep" min:"1" type:"string"`

	// The file's quote character.
	Quote *string `locationName:"quote" min:"1" type:"string"`

	// Whether all values need to be quoted, or just those that contain quotes.
	QuoteAll *bool `locationName:"quoteAll" type:"boolean"`

	// The file's field separator.
	Sep *string `locationName:"sep" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReadOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReadOptions"}
	if s.Comment != nil && len(*s.Comment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Comment", 1))
	}
	if s.Encoding != nil && len(*s.Encoding) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Encoding", 1))
	}
	if s.Escape != nil && len(*s.Escape) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Escape", 1))
	}
	if s.LineSep != nil && len(*s.LineSep) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LineSep", 1))
	}
	if s.Quote != nil && len(*s.Quote) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Quote", 1))
	}
	if s.Sep != nil && len(*s.Sep) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sep", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *ReadOptions) SetComment(v string) *ReadOptions {
	s.Comment = &v
	return s
}

// SetEncoding sets the Encoding field's value.
func (s *ReadOptions) SetEncoding(v string) *ReadOptions {
	s.Encoding = &v
	return s
}

// SetEscape sets the Escape field's value.
func (s *ReadOptions) SetEscape(v string) *ReadOptions {
	s.Escape = &v
	return s
}

// SetEscapeQuotes sets the EscapeQuotes field's value.
func (s *ReadOptions) SetEscapeQuotes(v bool) *ReadOptions {
	s.EscapeQuotes = &v
	return s
}

// SetHeader sets the Header field's value.
func (s *ReadOptions) SetHeader(v bool) *ReadOptions {
	s.Header = &v
	return s
}

// SetLineSep sets the LineSep field's value.
func (s *ReadOptions) SetLineSep(v string) *ReadOptions {
	s.LineSep = &v
	return s
}

// SetQuote sets the Quote field's value.
func (s *ReadOptions) SetQuote(v string) *ReadOptions {
	s.Quote = &v
	return s
}

// SetQuoteAll sets the QuoteAll field's value.
func (s *ReadOptions) SetQuoteAll(v bool) *ReadOptions {
	s.QuoteAll = &v
	return s
}

// SetSep sets the Sep field's value.
func (s *ReadOptions) SetSep(v string) *ReadOptions {
	s.Sep = &v
	return s
}

// An error from a batch read set operation.
type ReadSetBatchError struct {
	_ struct{} `type:"structure"`

	// The error's code.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true"`

	// The error's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The error's message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadSetBatchError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadSetBatchError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ReadSetBatchError) SetCode(v string) *ReadSetBatchError {
	s.Code = &v
	return s
}

// SetId sets the Id field's value.
func (s *ReadSetBatchError) SetId(v string) *ReadSetBatchError {
	s.Id = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ReadSetBatchError) SetMessage(v string) *ReadSetBatchError {
	s.Message = &v
	return s
}

// Files in a read set.
type ReadSetFiles struct {
	_ struct{} `type:"structure"`

	// The files' index.
	Index *FileInformation `locationName:"index" type:"structure"`

	// The location of the first file in Amazon S3.
	Source1 *FileInformation `locationName:"source1" type:"structure"`

	// The location of the second file in Amazon S3.
	Source2 *FileInformation `locationName:"source2" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadSetFiles) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadSetFiles) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *ReadSetFiles) SetIndex(v *FileInformation) *ReadSetFiles {
	s.Index = v
	return s
}

// SetSource1 sets the Source1 field's value.
func (s *ReadSetFiles) SetSource1(v *FileInformation) *ReadSetFiles {
	s.Source1 = v
	return s
}

// SetSource2 sets the Source2 field's value.
func (s *ReadSetFiles) SetSource2(v *FileInformation) *ReadSetFiles {
	s.Source2 = v
	return s
}

// A filter for read sets.
type ReadSetFilter struct {
	_ struct{} `type:"structure"`

	// The filter's start date.
	CreatedAfter *time.Time `locationName:"createdAfter" type:"timestamp" timestampFormat:"iso8601"`

	// The filter's end date.
	CreatedBefore *time.Time `locationName:"createdBefore" type:"timestamp" timestampFormat:"iso8601"`

	// The creation type of the read set.
	CreationType *string `locationName:"creationType" type:"string" enum:"CreationType"`

	// Where the source originated.
	GeneratedFrom *string `locationName:"generatedFrom" min:"1" type:"string"`

	// A name to filter on.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A genome reference ARN to filter on.
	ReferenceArn *string `locationName:"referenceArn" type:"string"`

	// The read set source's sample ID.
	SampleId *string `locationName:"sampleId" min:"1" type:"string"`

	// A status to filter on.
	Status *string `locationName:"status" type:"string" enum:"ReadSetStatus"`

	// The read set source's subject ID.
	SubjectId *string `locationName:"subjectId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadSetFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadSetFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReadSetFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReadSetFilter"}
	if s.GeneratedFrom != nil && len(*s.GeneratedFrom) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GeneratedFrom", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SampleId != nil && len(*s.SampleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SampleId", 1))
	}
	if s.SubjectId != nil && len(*s.SubjectId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubjectId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatedAfter sets the CreatedAfter field's value.
func (s *ReadSetFilter) SetCreatedAfter(v time.Time) *ReadSetFilter {
	s.CreatedAfter = &v
	return s
}

// SetCreatedBefore sets the CreatedBefore field's value.
func (s *ReadSetFilter) SetCreatedBefore(v time.Time) *ReadSetFilter {
	s.CreatedBefore = &v
	return s
}

// SetCreationType sets the CreationType field's value.
func (s *ReadSetFilter) SetCreationType(v string) *ReadSetFilter {
	s.CreationType = &v
	return s
}

// SetGeneratedFrom sets the GeneratedFrom field's value.
func (s *ReadSetFilter) SetGeneratedFrom(v string) *ReadSetFilter {
	s.GeneratedFrom = &v
	return s
}

// SetName sets the Name field's value.
func (s *ReadSetFilter) SetName(v string) *ReadSetFilter {
	s.Name = &v
	return s
}

// SetReferenceArn sets the ReferenceArn field's value.
func (s *ReadSetFilter) SetReferenceArn(v string) *ReadSetFilter {
	s.ReferenceArn = &v
	return s
}

// SetSampleId sets the SampleId field's value.
func (s *ReadSetFilter) SetSampleId(v string) *ReadSetFilter {
	s.SampleId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReadSetFilter) SetStatus(v string) *ReadSetFilter {
	s.Status = &v
	return s
}

// SetSubjectId sets the SubjectId field's value.
func (s *ReadSetFilter) SetSubjectId(v string) *ReadSetFilter {
	s.SubjectId = &v
	return s
}

// A read set.
type ReadSetListItem struct {
	_ struct{} `type:"structure"`

	// The read set's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// When the read set was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The creation type of the read set.
	CreationType *string `locationName:"creationType" type:"string" enum:"CreationType"`

	// The read set's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The entity tag (ETag) is a hash of the object representing its semantic content.
	Etag *ETag `locationName:"etag" type:"structure"`

	// The read set's file type.
	//
	// FileType is a required field
	FileType *string `locationName:"fileType" type:"string" required:"true" enum:"FileType"`

	// The read set's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The read set's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The read set's genome reference ARN.
	ReferenceArn *string `locationName:"referenceArn" min:"1" type:"string"`

	// The read set's sample ID.
	SampleId *string `locationName:"sampleId" min:"1" type:"string"`

	// Details about a sequence.
	SequenceInformation *SequenceInformation `locationName:"sequenceInformation" type:"structure"`

	// The read set's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The read set's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReadSetStatus"`

	// The status for a read set. It provides more detail as to why the read set
	// has a status.
	StatusMessage *string `locationName:"statusMessage" min:"1" type:"string"`

	// The read set's subject ID.
	SubjectId *string `locationName:"subjectId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadSetListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadSetListItem) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ReadSetListItem) SetArn(v string) *ReadSetListItem {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ReadSetListItem) SetCreationTime(v time.Time) *ReadSetListItem {
	s.CreationTime = &v
	return s
}

// SetCreationType sets the CreationType field's value.
func (s *ReadSetListItem) SetCreationType(v string) *ReadSetListItem {
	s.CreationType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ReadSetListItem) SetDescription(v string) *ReadSetListItem {
	s.Description = &v
	return s
}

// SetEtag sets the Etag field's value.
func (s *ReadSetListItem) SetEtag(v *ETag) *ReadSetListItem {
	s.Etag = v
	return s
}

// SetFileType sets the FileType field's value.
func (s *ReadSetListItem) SetFileType(v string) *ReadSetListItem {
	s.FileType = &v
	return s
}

// SetId sets the Id field's value.
func (s *ReadSetListItem) SetId(v string) *ReadSetListItem {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ReadSetListItem) SetName(v string) *ReadSetListItem {
	s.Name = &v
	return s
}

// SetReferenceArn sets the ReferenceArn field's value.
func (s *ReadSetListItem) SetReferenceArn(v string) *ReadSetListItem {
	s.ReferenceArn = &v
	return s
}

// SetSampleId sets the SampleId field's value.
func (s *ReadSetListItem) SetSampleId(v string) *ReadSetListItem {
	s.SampleId = &v
	return s
}

// SetSequenceInformation sets the SequenceInformation field's value.
func (s *ReadSetListItem) SetSequenceInformation(v *SequenceInformation) *ReadSetListItem {
	s.SequenceInformation = v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *ReadSetListItem) SetSequenceStoreId(v string) *ReadSetListItem {
	s.SequenceStoreId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReadSetListItem) SetStatus(v string) *ReadSetListItem {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ReadSetListItem) SetStatusMessage(v string) *ReadSetListItem {
	s.StatusMessage = &v
	return s
}

// SetSubjectId sets the SubjectId field's value.
func (s *ReadSetListItem) SetSubjectId(v string) *ReadSetListItem {
	s.SubjectId = &v
	return s
}

// Filter settings that select for read set upload parts of interest.
type ReadSetUploadPartListFilter struct {
	_ struct{} `type:"structure"`

	// Filters for read set uploads after a specified time.
	CreatedAfter *time.Time `locationName:"createdAfter" type:"timestamp" timestampFormat:"iso8601"`

	// Filters for read set part uploads before a specified time.
	CreatedBefore *time.Time `locationName:"createdBefore" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadSetUploadPartListFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadSetUploadPartListFilter) GoString() string {
	return s.String()
}

// SetCreatedAfter sets the CreatedAfter field's value.
func (s *ReadSetUploadPartListFilter) SetCreatedAfter(v time.Time) *ReadSetUploadPartListFilter {
	s.CreatedAfter = &v
	return s
}

// SetCreatedBefore sets the CreatedBefore field's value.
func (s *ReadSetUploadPartListFilter) SetCreatedBefore(v time.Time) *ReadSetUploadPartListFilter {
	s.CreatedBefore = &v
	return s
}

// The metadata of a single part of a file that was added to a multipart upload.
// A list of these parts is returned in the response to the ListReadSetUploadParts
// API.
type ReadSetUploadPartListItem struct {
	_ struct{} `type:"structure"`

	// A unique identifier used to confirm that parts are being added to the correct
	// upload.
	//
	// Checksum is a required field
	Checksum *string `locationName:"checksum" type:"string" required:"true"`

	// The time stamp for when a direct upload was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The time stamp for the most recent update to an uploaded part.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp" timestampFormat:"iso8601"`

	// The number identifying the part in an upload.
	//
	// PartNumber is a required field
	PartNumber *int64 `locationName:"partNumber" min:"1" type:"integer" required:"true"`

	// The size of the the part in an upload.
	//
	// PartSize is a required field
	PartSize *int64 `locationName:"partSize" min:"1" type:"long" required:"true"`

	// The origin of the part being direct uploaded.
	//
	// PartSource is a required field
	PartSource *string `locationName:"partSource" type:"string" required:"true" enum:"ReadSetPartSource"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadSetUploadPartListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadSetUploadPartListItem) GoString() string {
	return s.String()
}

// SetChecksum sets the Checksum field's value.
func (s *ReadSetUploadPartListItem) SetChecksum(v string) *ReadSetUploadPartListItem {
	s.Checksum = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ReadSetUploadPartListItem) SetCreationTime(v time.Time) *ReadSetUploadPartListItem {
	s.CreationTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ReadSetUploadPartListItem) SetLastUpdatedTime(v time.Time) *ReadSetUploadPartListItem {
	s.LastUpdatedTime = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *ReadSetUploadPartListItem) SetPartNumber(v int64) *ReadSetUploadPartListItem {
	s.PartNumber = &v
	return s
}

// SetPartSize sets the PartSize field's value.
func (s *ReadSetUploadPartListItem) SetPartSize(v int64) *ReadSetUploadPartListItem {
	s.PartSize = &v
	return s
}

// SetPartSource sets the PartSource field's value.
func (s *ReadSetUploadPartListItem) SetPartSource(v string) *ReadSetUploadPartListItem {
	s.PartSource = &v
	return s
}

// A set of genome reference files.
type ReferenceFiles struct {
	_ struct{} `type:"structure"`

	// The files' index.
	Index *FileInformation `locationName:"index" type:"structure"`

	// The source file's location in Amazon S3.
	Source *FileInformation `locationName:"source" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferenceFiles) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferenceFiles) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *ReferenceFiles) SetIndex(v *FileInformation) *ReferenceFiles {
	s.Index = v
	return s
}

// SetSource sets the Source field's value.
func (s *ReferenceFiles) SetSource(v *FileInformation) *ReferenceFiles {
	s.Source = v
	return s
}

// A filter for references.
type ReferenceFilter struct {
	_ struct{} `type:"structure"`

	// The filter's start date.
	CreatedAfter *time.Time `locationName:"createdAfter" type:"timestamp" timestampFormat:"iso8601"`

	// The filter's end date.
	CreatedBefore *time.Time `locationName:"createdBefore" type:"timestamp" timestampFormat:"iso8601"`

	// An MD5 checksum to filter on.
	Md5 *string `locationName:"md5" min:"1" type:"string"`

	// A name to filter on.
	Name *string `locationName:"name" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferenceFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferenceFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReferenceFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReferenceFilter"}
	if s.Md5 != nil && len(*s.Md5) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Md5", 1))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatedAfter sets the CreatedAfter field's value.
func (s *ReferenceFilter) SetCreatedAfter(v time.Time) *ReferenceFilter {
	s.CreatedAfter = &v
	return s
}

// SetCreatedBefore sets the CreatedBefore field's value.
func (s *ReferenceFilter) SetCreatedBefore(v time.Time) *ReferenceFilter {
	s.CreatedBefore = &v
	return s
}

// SetMd5 sets the Md5 field's value.
func (s *ReferenceFilter) SetMd5(v string) *ReferenceFilter {
	s.Md5 = &v
	return s
}

// SetName sets the Name field's value.
func (s *ReferenceFilter) SetName(v string) *ReferenceFilter {
	s.Name = &v
	return s
}

// A genome reference.
type ReferenceItem struct {
	_ struct{} `type:"structure"`

	// The reference's ARN.
	ReferenceArn *string `locationName:"referenceArn" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferenceItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferenceItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReferenceItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReferenceItem"}
	if s.ReferenceArn != nil && len(*s.ReferenceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReferenceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReferenceArn sets the ReferenceArn field's value.
func (s *ReferenceItem) SetReferenceArn(v string) *ReferenceItem {
	s.ReferenceArn = &v
	return s
}

// A genome reference.
type ReferenceListItem struct {
	_ struct{} `type:"structure"`

	// The reference's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// When the reference was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The reference's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The reference's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The reference's MD5 checksum.
	//
	// Md5 is a required field
	Md5 *string `locationName:"md5" min:"1" type:"string" required:"true"`

	// The reference's name.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The reference's store ID.
	//
	// ReferenceStoreId is a required field
	ReferenceStoreId *string `locationName:"referenceStoreId" min:"10" type:"string" required:"true"`

	// The reference's status.
	Status *string `locationName:"status" type:"string" enum:"ReferenceStatus"`

	// When the reference was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferenceListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferenceListItem) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ReferenceListItem) SetArn(v string) *ReferenceListItem {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ReferenceListItem) SetCreationTime(v time.Time) *ReferenceListItem {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ReferenceListItem) SetDescription(v string) *ReferenceListItem {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ReferenceListItem) SetId(v string) *ReferenceListItem {
	s.Id = &v
	return s
}

// SetMd5 sets the Md5 field's value.
func (s *ReferenceListItem) SetMd5(v string) *ReferenceListItem {
	s.Md5 = &v
	return s
}

// SetName sets the Name field's value.
func (s *ReferenceListItem) SetName(v string) *ReferenceListItem {
	s.Name = &v
	return s
}

// SetReferenceStoreId sets the ReferenceStoreId field's value.
func (s *ReferenceListItem) SetReferenceStoreId(v string) *ReferenceListItem {
	s.ReferenceStoreId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReferenceListItem) SetStatus(v string) *ReferenceListItem {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ReferenceListItem) SetUpdateTime(v time.Time) *ReferenceListItem {
	s.UpdateTime = &v
	return s
}

// Details about a reference store.
type ReferenceStoreDetail struct {
	_ struct{} `type:"structure"`

	// The store's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// When the store was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The store's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The store's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The store's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The store's server-side encryption (SSE) settings.
	SseConfig *SseConfig `locationName:"sseConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferenceStoreDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferenceStoreDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ReferenceStoreDetail) SetArn(v string) *ReferenceStoreDetail {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ReferenceStoreDetail) SetCreationTime(v time.Time) *ReferenceStoreDetail {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ReferenceStoreDetail) SetDescription(v string) *ReferenceStoreDetail {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ReferenceStoreDetail) SetId(v string) *ReferenceStoreDetail {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ReferenceStoreDetail) SetName(v string) *ReferenceStoreDetail {
	s.Name = &v
	return s
}

// SetSseConfig sets the SseConfig field's value.
func (s *ReferenceStoreDetail) SetSseConfig(v *SseConfig) *ReferenceStoreDetail {
	s.SseConfig = v
	return s
}

// A filter for reference stores.
type ReferenceStoreFilter struct {
	_ struct{} `type:"structure"`

	// The filter's start date.
	CreatedAfter *time.Time `locationName:"createdAfter" type:"timestamp" timestampFormat:"iso8601"`

	// The filter's end date.
	CreatedBefore *time.Time `locationName:"createdBefore" type:"timestamp" timestampFormat:"iso8601"`

	// The name to filter on.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferenceStoreFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferenceStoreFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReferenceStoreFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReferenceStoreFilter"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatedAfter sets the CreatedAfter field's value.
func (s *ReferenceStoreFilter) SetCreatedAfter(v time.Time) *ReferenceStoreFilter {
	s.CreatedAfter = &v
	return s
}

// SetCreatedBefore sets the CreatedBefore field's value.
func (s *ReferenceStoreFilter) SetCreatedBefore(v time.Time) *ReferenceStoreFilter {
	s.CreatedBefore = &v
	return s
}

// SetName sets the Name field's value.
func (s *ReferenceStoreFilter) SetName(v string) *ReferenceStoreFilter {
	s.Name = &v
	return s
}

// The request timed out.
type RequestTimeoutException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestTimeoutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestTimeoutException) GoString() string {
	return s.String()
}

func newErrorRequestTimeoutException(v protocol.ResponseMetadata) error {
	return &RequestTimeoutException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RequestTimeoutException) Code() string {
	return "RequestTimeoutException"
}

// Message returns the exception's message.
func (s *RequestTimeoutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RequestTimeoutException) OrigErr() error {
	return nil
}

func (s *RequestTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RequestTimeoutException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RequestTimeoutException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The target resource was not found in the current Region.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A run group.
type RunGroupListItem struct {
	_ struct{} `type:"structure"`

	// The group's ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// When the group was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The group's ID.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The group's maximum CPU count setting.
	MaxCpus *int64 `locationName:"maxCpus" min:"1" type:"integer"`

	// The group's maximum duration setting in minutes.
	MaxDuration *int64 `locationName:"maxDuration" min:"1" type:"integer"`

	// The maximum GPUs that can be used by a run group.
	MaxGpus *int64 `locationName:"maxGpus" min:"1" type:"integer"`

	// The group's maximum concurrent run setting.
	MaxRuns *int64 `locationName:"maxRuns" min:"1" type:"integer"`

	// The group's name.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunGroupListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunGroupListItem) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RunGroupListItem) SetArn(v string) *RunGroupListItem {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *RunGroupListItem) SetCreationTime(v time.Time) *RunGroupListItem {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *RunGroupListItem) SetId(v string) *RunGroupListItem {
	s.Id = &v
	return s
}

// SetMaxCpus sets the MaxCpus field's value.
func (s *RunGroupListItem) SetMaxCpus(v int64) *RunGroupListItem {
	s.MaxCpus = &v
	return s
}

// SetMaxDuration sets the MaxDuration field's value.
func (s *RunGroupListItem) SetMaxDuration(v int64) *RunGroupListItem {
	s.MaxDuration = &v
	return s
}

// SetMaxGpus sets the MaxGpus field's value.
func (s *RunGroupListItem) SetMaxGpus(v int64) *RunGroupListItem {
	s.MaxGpus = &v
	return s
}

// SetMaxRuns sets the MaxRuns field's value.
func (s *RunGroupListItem) SetMaxRuns(v int64) *RunGroupListItem {
	s.MaxRuns = &v
	return s
}

// SetName sets the Name field's value.
func (s *RunGroupListItem) SetName(v string) *RunGroupListItem {
	s.Name = &v
	return s
}

// A workflow run.
type RunListItem struct {
	_ struct{} `type:"structure"`

	// The run's ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// When the run was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The run's ID.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The run's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The run's priority.
	Priority *int64 `locationName:"priority" type:"integer"`

	// When the run started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// The run's status.
	Status *string `locationName:"status" min:"1" type:"string" enum:"RunStatus"`

	// When the run stopped.
	StopTime *time.Time `locationName:"stopTime" type:"timestamp" timestampFormat:"iso8601"`

	// The run's storage capacity.
	StorageCapacity *int64 `locationName:"storageCapacity" type:"integer"`

	// The run's workflow ID.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunListItem) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RunListItem) SetArn(v string) *RunListItem {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *RunListItem) SetCreationTime(v time.Time) *RunListItem {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *RunListItem) SetId(v string) *RunListItem {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *RunListItem) SetName(v string) *RunListItem {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *RunListItem) SetPriority(v int64) *RunListItem {
	s.Priority = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *RunListItem) SetStartTime(v time.Time) *RunListItem {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RunListItem) SetStatus(v string) *RunListItem {
	s.Status = &v
	return s
}

// SetStopTime sets the StopTime field's value.
func (s *RunListItem) SetStopTime(v time.Time) *RunListItem {
	s.StopTime = &v
	return s
}

// SetStorageCapacity sets the StorageCapacity field's value.
func (s *RunListItem) SetStorageCapacity(v int64) *RunListItem {
	s.StorageCapacity = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *RunListItem) SetWorkflowId(v string) *RunListItem {
	s.WorkflowId = &v
	return s
}

// The URI for the run log.
type RunLogLocation struct {
	_ struct{} `type:"structure"`

	// The log stream ARN for the engine log.
	EngineLogStream *string `locationName:"engineLogStream" type:"string"`

	// The log stream ARN for the run log.
	RunLogStream *string `locationName:"runLogStream" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunLogLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunLogLocation) GoString() string {
	return s.String()
}

// SetEngineLogStream sets the EngineLogStream field's value.
func (s *RunLogLocation) SetEngineLogStream(v string) *RunLogLocation {
	s.EngineLogStream = &v
	return s
}

// SetRunLogStream sets the RunLogStream field's value.
func (s *RunLogLocation) SetRunLogStream(v string) *RunLogLocation {
	s.RunLogStream = &v
	return s
}

// Details about a sequence.
type SequenceInformation struct {
	_ struct{} `type:"structure"`

	// The sequence's alignment setting.
	Alignment *string `locationName:"alignment" type:"string"`

	// Where the sequence originated.
	GeneratedFrom *string `locationName:"generatedFrom" min:"1" type:"string"`

	// The sequence's total base count.
	TotalBaseCount *int64 `locationName:"totalBaseCount" type:"long"`

	// The sequence's total read count.
	TotalReadCount *int64 `locationName:"totalReadCount" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SequenceInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SequenceInformation) GoString() string {
	return s.String()
}

// SetAlignment sets the Alignment field's value.
func (s *SequenceInformation) SetAlignment(v string) *SequenceInformation {
	s.Alignment = &v
	return s
}

// SetGeneratedFrom sets the GeneratedFrom field's value.
func (s *SequenceInformation) SetGeneratedFrom(v string) *SequenceInformation {
	s.GeneratedFrom = &v
	return s
}

// SetTotalBaseCount sets the TotalBaseCount field's value.
func (s *SequenceInformation) SetTotalBaseCount(v int64) *SequenceInformation {
	s.TotalBaseCount = &v
	return s
}

// SetTotalReadCount sets the TotalReadCount field's value.
func (s *SequenceInformation) SetTotalReadCount(v int64) *SequenceInformation {
	s.TotalReadCount = &v
	return s
}

// Details about a sequence store.
type SequenceStoreDetail struct {
	_ struct{} `type:"structure"`

	// The store's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// When the store was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The store's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// An S3 location that is used to store files that have failed a direct upload.
	FallbackLocation *string `locationName:"fallbackLocation" type:"string"`

	// The store's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The store's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The store's server-side encryption (SSE) settings.
	SseConfig *SseConfig `locationName:"sseConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SequenceStoreDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SequenceStoreDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SequenceStoreDetail) SetArn(v string) *SequenceStoreDetail {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *SequenceStoreDetail) SetCreationTime(v time.Time) *SequenceStoreDetail {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SequenceStoreDetail) SetDescription(v string) *SequenceStoreDetail {
	s.Description = &v
	return s
}

// SetFallbackLocation sets the FallbackLocation field's value.
func (s *SequenceStoreDetail) SetFallbackLocation(v string) *SequenceStoreDetail {
	s.FallbackLocation = &v
	return s
}

// SetId sets the Id field's value.
func (s *SequenceStoreDetail) SetId(v string) *SequenceStoreDetail {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *SequenceStoreDetail) SetName(v string) *SequenceStoreDetail {
	s.Name = &v
	return s
}

// SetSseConfig sets the SseConfig field's value.
func (s *SequenceStoreDetail) SetSseConfig(v *SseConfig) *SequenceStoreDetail {
	s.SseConfig = v
	return s
}

// A filter for a sequence store.
type SequenceStoreFilter struct {
	_ struct{} `type:"structure"`

	// The filter's start date.
	CreatedAfter *time.Time `locationName:"createdAfter" type:"timestamp" timestampFormat:"iso8601"`

	// The filter's end date.
	CreatedBefore *time.Time `locationName:"createdBefore" type:"timestamp" timestampFormat:"iso8601"`

	// A name to filter on.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SequenceStoreFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SequenceStoreFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SequenceStoreFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SequenceStoreFilter"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatedAfter sets the CreatedAfter field's value.
func (s *SequenceStoreFilter) SetCreatedAfter(v time.Time) *SequenceStoreFilter {
	s.CreatedAfter = &v
	return s
}

// SetCreatedBefore sets the CreatedBefore field's value.
func (s *SequenceStoreFilter) SetCreatedBefore(v time.Time) *SequenceStoreFilter {
	s.CreatedBefore = &v
	return s
}

// SetName sets the Name field's value.
func (s *SequenceStoreFilter) SetName(v string) *SequenceStoreFilter {
	s.Name = &v
	return s
}

// The request exceeds a service quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The details of a share.
type ShareDetails struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the share was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The account ID for the data owner. The owner creates the share offer.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// The principal subscriber is the account the analytics store data is being
	// shared with.
	PrincipalSubscriber *string `locationName:"principalSubscriber" type:"string"`

	// The resource Arn of the analytics store being shared.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// The ID for a share offer for an analytics store .
	ShareId *string `locationName:"shareId" type:"string"`

	// The name of the share.
	ShareName *string `locationName:"shareName" min:"1" type:"string"`

	// The status of a share.
	Status *string `locationName:"status" type:"string" enum:"ShareStatus"`

	// The status message for a share. It provides more details on the status of
	// the share.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The timestamp of the share update.
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShareDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShareDetails) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ShareDetails) SetCreationTime(v time.Time) *ShareDetails {
	s.CreationTime = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *ShareDetails) SetOwnerId(v string) *ShareDetails {
	s.OwnerId = &v
	return s
}

// SetPrincipalSubscriber sets the PrincipalSubscriber field's value.
func (s *ShareDetails) SetPrincipalSubscriber(v string) *ShareDetails {
	s.PrincipalSubscriber = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ShareDetails) SetResourceArn(v string) *ShareDetails {
	s.ResourceArn = &v
	return s
}

// SetShareId sets the ShareId field's value.
func (s *ShareDetails) SetShareId(v string) *ShareDetails {
	s.ShareId = &v
	return s
}

// SetShareName sets the ShareName field's value.
func (s *ShareDetails) SetShareName(v string) *ShareDetails {
	s.ShareName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ShareDetails) SetStatus(v string) *ShareDetails {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ShareDetails) SetStatusMessage(v string) *ShareDetails {
	s.StatusMessage = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ShareDetails) SetUpdateTime(v time.Time) *ShareDetails {
	s.UpdateTime = &v
	return s
}

// Source files for a sequence.
type SourceFiles struct {
	_ struct{} `type:"structure"`

	// The location of the first file in Amazon S3.
	//
	// Source1 is a required field
	Source1 *string `locationName:"source1" type:"string" required:"true"`

	// The location of the second file in Amazon S3.
	Source2 *string `locationName:"source2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceFiles) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceFiles) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceFiles) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceFiles"}
	if s.Source1 == nil {
		invalidParams.Add(request.NewErrParamRequired("Source1"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSource1 sets the Source1 field's value.
func (s *SourceFiles) SetSource1(v string) *SourceFiles {
	s.Source1 = &v
	return s
}

// SetSource2 sets the Source2 field's value.
func (s *SourceFiles) SetSource2(v string) *SourceFiles {
	s.Source2 = &v
	return s
}

// Server-side encryption (SSE) settings for a store.
type SseConfig struct {
	_ struct{} `type:"structure"`

	// An encryption key ARN.
	KeyArn *string `locationName:"keyArn" min:"20" type:"string"`

	// The encryption type.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"EncryptionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SseConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SseConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SseConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SseConfig"}
	if s.KeyArn != nil && len(*s.KeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KeyArn", 20))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyArn sets the KeyArn field's value.
func (s *SseConfig) SetKeyArn(v string) *SseConfig {
	s.KeyArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *SseConfig) SetType(v string) *SseConfig {
	s.Type = &v
	return s
}

type StartAnnotationImportJobInput struct {
	_ struct{} `type:"structure"`

	// The annotation schema generated by the parsed annotation data.
	AnnotationFields map[string]*string `locationName:"annotationFields" type:"map"`

	// A destination annotation store for the job.
	//
	// DestinationName is a required field
	DestinationName *string `locationName:"destinationName" min:"3" type:"string" required:"true"`

	// Formatting options for the annotation file.
	FormatOptions *FormatOptions `locationName:"formatOptions" type:"structure"`

	// Items to import.
	//
	// Items is a required field
	Items []*AnnotationImportItemSource `locationName:"items" min:"1" type:"list" required:"true"`

	// A service role for the job.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The job's left normalization setting.
	RunLeftNormalization *bool `locationName:"runLeftNormalization" type:"boolean"`

	// The name of the annotation store version.
	VersionName *string `locationName:"versionName" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAnnotationImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAnnotationImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartAnnotationImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartAnnotationImportJobInput"}
	if s.DestinationName == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationName"))
	}
	if s.DestinationName != nil && len(*s.DestinationName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationName", 3))
	}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.Items != nil && len(s.Items) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Items", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.VersionName != nil && len(*s.VersionName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("VersionName", 3))
	}
	if s.FormatOptions != nil {
		if err := s.FormatOptions.Validate(); err != nil {
			invalidParams.AddNested("FormatOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnnotationFields sets the AnnotationFields field's value.
func (s *StartAnnotationImportJobInput) SetAnnotationFields(v map[string]*string) *StartAnnotationImportJobInput {
	s.AnnotationFields = v
	return s
}

// SetDestinationName sets the DestinationName field's value.
func (s *StartAnnotationImportJobInput) SetDestinationName(v string) *StartAnnotationImportJobInput {
	s.DestinationName = &v
	return s
}

// SetFormatOptions sets the FormatOptions field's value.
func (s *StartAnnotationImportJobInput) SetFormatOptions(v *FormatOptions) *StartAnnotationImportJobInput {
	s.FormatOptions = v
	return s
}

// SetItems sets the Items field's value.
func (s *StartAnnotationImportJobInput) SetItems(v []*AnnotationImportItemSource) *StartAnnotationImportJobInput {
	s.Items = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *StartAnnotationImportJobInput) SetRoleArn(v string) *StartAnnotationImportJobInput {
	s.RoleArn = &v
	return s
}

// SetRunLeftNormalization sets the RunLeftNormalization field's value.
func (s *StartAnnotationImportJobInput) SetRunLeftNormalization(v bool) *StartAnnotationImportJobInput {
	s.RunLeftNormalization = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *StartAnnotationImportJobInput) SetVersionName(v string) *StartAnnotationImportJobInput {
	s.VersionName = &v
	return s
}

type StartAnnotationImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The job's ID.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAnnotationImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAnnotationImportJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartAnnotationImportJobOutput) SetJobId(v string) *StartAnnotationImportJobOutput {
	s.JobId = &v
	return s
}

type StartReadSetActivationJobInput struct {
	_ struct{} `type:"structure"`

	// To ensure that jobs don't run multiple times, specify a unique token for
	// each job.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The read set's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The job's source files.
	//
	// Sources is a required field
	Sources []*StartReadSetActivationJobSourceItem `locationName:"sources" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReadSetActivationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReadSetActivationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReadSetActivationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartReadSetActivationJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.Sources != nil && len(s.Sources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sources", 1))
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartReadSetActivationJobInput) SetClientToken(v string) *StartReadSetActivationJobInput {
	s.ClientToken = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *StartReadSetActivationJobInput) SetSequenceStoreId(v string) *StartReadSetActivationJobInput {
	s.SequenceStoreId = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *StartReadSetActivationJobInput) SetSources(v []*StartReadSetActivationJobSourceItem) *StartReadSetActivationJobInput {
	s.Sources = v
	return s
}

type StartReadSetActivationJobOutput struct {
	_ struct{} `type:"structure"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The read set's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The job's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReadSetActivationJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReadSetActivationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReadSetActivationJobOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *StartReadSetActivationJobOutput) SetCreationTime(v time.Time) *StartReadSetActivationJobOutput {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *StartReadSetActivationJobOutput) SetId(v string) *StartReadSetActivationJobOutput {
	s.Id = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *StartReadSetActivationJobOutput) SetSequenceStoreId(v string) *StartReadSetActivationJobOutput {
	s.SequenceStoreId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StartReadSetActivationJobOutput) SetStatus(v string) *StartReadSetActivationJobOutput {
	s.Status = &v
	return s
}

// A source for a read set activation job.
type StartReadSetActivationJobSourceItem struct {
	_ struct{} `type:"structure"`

	// The source's read set ID.
	//
	// ReadSetId is a required field
	ReadSetId *string `locationName:"readSetId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReadSetActivationJobSourceItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReadSetActivationJobSourceItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReadSetActivationJobSourceItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartReadSetActivationJobSourceItem"}
	if s.ReadSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReadSetId"))
	}
	if s.ReadSetId != nil && len(*s.ReadSetId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ReadSetId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReadSetId sets the ReadSetId field's value.
func (s *StartReadSetActivationJobSourceItem) SetReadSetId(v string) *StartReadSetActivationJobSourceItem {
	s.ReadSetId = &v
	return s
}

type StartReadSetExportJobInput struct {
	_ struct{} `type:"structure"`

	// To ensure that jobs don't run multiple times, specify a unique token for
	// each job.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// A location for exported files in Amazon S3.
	//
	// Destination is a required field
	Destination *string `locationName:"destination" type:"string" required:"true"`

	// A service role for the job.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The read set's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The job's source files.
	//
	// Sources is a required field
	Sources []*ExportReadSet `locationName:"sources" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReadSetExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReadSetExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReadSetExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartReadSetExportJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.Sources != nil && len(s.Sources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sources", 1))
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartReadSetExportJobInput) SetClientToken(v string) *StartReadSetExportJobInput {
	s.ClientToken = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *StartReadSetExportJobInput) SetDestination(v string) *StartReadSetExportJobInput {
	s.Destination = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *StartReadSetExportJobInput) SetRoleArn(v string) *StartReadSetExportJobInput {
	s.RoleArn = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *StartReadSetExportJobInput) SetSequenceStoreId(v string) *StartReadSetExportJobInput {
	s.SequenceStoreId = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *StartReadSetExportJobInput) SetSources(v []*ExportReadSet) *StartReadSetExportJobInput {
	s.Sources = v
	return s
}

type StartReadSetExportJobOutput struct {
	_ struct{} `type:"structure"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The job's output location.
	//
	// Destination is a required field
	Destination *string `locationName:"destination" type:"string" required:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The read set's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The job's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReadSetExportJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReadSetExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReadSetExportJobOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *StartReadSetExportJobOutput) SetCreationTime(v time.Time) *StartReadSetExportJobOutput {
	s.CreationTime = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *StartReadSetExportJobOutput) SetDestination(v string) *StartReadSetExportJobOutput {
	s.Destination = &v
	return s
}

// SetId sets the Id field's value.
func (s *StartReadSetExportJobOutput) SetId(v string) *StartReadSetExportJobOutput {
	s.Id = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *StartReadSetExportJobOutput) SetSequenceStoreId(v string) *StartReadSetExportJobOutput {
	s.SequenceStoreId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StartReadSetExportJobOutput) SetStatus(v string) *StartReadSetExportJobOutput {
	s.Status = &v
	return s
}

type StartReadSetImportJobInput struct {
	_ struct{} `type:"structure"`

	// To ensure that jobs don't run multiple times, specify a unique token for
	// each job.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// A service role for the job.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The read set's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The job's source files.
	//
	// Sources is a required field
	Sources []*StartReadSetImportJobSourceItem `locationName:"sources" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReadSetImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReadSetImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReadSetImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartReadSetImportJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.Sources != nil && len(s.Sources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sources", 1))
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartReadSetImportJobInput) SetClientToken(v string) *StartReadSetImportJobInput {
	s.ClientToken = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *StartReadSetImportJobInput) SetRoleArn(v string) *StartReadSetImportJobInput {
	s.RoleArn = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *StartReadSetImportJobInput) SetSequenceStoreId(v string) *StartReadSetImportJobInput {
	s.SequenceStoreId = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *StartReadSetImportJobInput) SetSources(v []*StartReadSetImportJobSourceItem) *StartReadSetImportJobInput {
	s.Sources = v
	return s
}

type StartReadSetImportJobOutput struct {
	_ struct{} `type:"structure"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The job's service role ARN.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The read set's sequence store ID.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The job's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReadSetImportJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReadSetImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReadSetImportJobOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *StartReadSetImportJobOutput) SetCreationTime(v time.Time) *StartReadSetImportJobOutput {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *StartReadSetImportJobOutput) SetId(v string) *StartReadSetImportJobOutput {
	s.Id = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *StartReadSetImportJobOutput) SetRoleArn(v string) *StartReadSetImportJobOutput {
	s.RoleArn = &v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *StartReadSetImportJobOutput) SetSequenceStoreId(v string) *StartReadSetImportJobOutput {
	s.SequenceStoreId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StartReadSetImportJobOutput) SetStatus(v string) *StartReadSetImportJobOutput {
	s.Status = &v
	return s
}

// A source for a read set import job.
type StartReadSetImportJobSourceItem struct {
	_ struct{} `type:"structure"`

	// The source's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Where the source originated.
	GeneratedFrom *string `locationName:"generatedFrom" min:"1" type:"string"`

	// The source's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The source's reference ARN.
	ReferenceArn *string `locationName:"referenceArn" min:"1" type:"string"`

	// The source's sample ID.
	//
	// SampleId is a required field
	SampleId *string `locationName:"sampleId" min:"1" type:"string" required:"true"`

	// The source's file type.
	//
	// SourceFileType is a required field
	SourceFileType *string `locationName:"sourceFileType" type:"string" required:"true" enum:"FileType"`

	// The source files' location in Amazon S3.
	//
	// SourceFiles is a required field
	SourceFiles *SourceFiles `locationName:"sourceFiles" type:"structure" required:"true"`

	// The source's subject ID.
	//
	// SubjectId is a required field
	SubjectId *string `locationName:"subjectId" min:"1" type:"string" required:"true"`

	// The source's tags.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReadSetImportJobSourceItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReadSetImportJobSourceItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReadSetImportJobSourceItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartReadSetImportJobSourceItem"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.GeneratedFrom != nil && len(*s.GeneratedFrom) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GeneratedFrom", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ReferenceArn != nil && len(*s.ReferenceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReferenceArn", 1))
	}
	if s.SampleId == nil {
		invalidParams.Add(request.NewErrParamRequired("SampleId"))
	}
	if s.SampleId != nil && len(*s.SampleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SampleId", 1))
	}
	if s.SourceFileType == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceFileType"))
	}
	if s.SourceFiles == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceFiles"))
	}
	if s.SubjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubjectId"))
	}
	if s.SubjectId != nil && len(*s.SubjectId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubjectId", 1))
	}
	if s.SourceFiles != nil {
		if err := s.SourceFiles.Validate(); err != nil {
			invalidParams.AddNested("SourceFiles", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *StartReadSetImportJobSourceItem) SetDescription(v string) *StartReadSetImportJobSourceItem {
	s.Description = &v
	return s
}

// SetGeneratedFrom sets the GeneratedFrom field's value.
func (s *StartReadSetImportJobSourceItem) SetGeneratedFrom(v string) *StartReadSetImportJobSourceItem {
	s.GeneratedFrom = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartReadSetImportJobSourceItem) SetName(v string) *StartReadSetImportJobSourceItem {
	s.Name = &v
	return s
}

// SetReferenceArn sets the ReferenceArn field's value.
func (s *StartReadSetImportJobSourceItem) SetReferenceArn(v string) *StartReadSetImportJobSourceItem {
	s.ReferenceArn = &v
	return s
}

// SetSampleId sets the SampleId field's value.
func (s *StartReadSetImportJobSourceItem) SetSampleId(v string) *StartReadSetImportJobSourceItem {
	s.SampleId = &v
	return s
}

// SetSourceFileType sets the SourceFileType field's value.
func (s *StartReadSetImportJobSourceItem) SetSourceFileType(v string) *StartReadSetImportJobSourceItem {
	s.SourceFileType = &v
	return s
}

// SetSourceFiles sets the SourceFiles field's value.
func (s *StartReadSetImportJobSourceItem) SetSourceFiles(v *SourceFiles) *StartReadSetImportJobSourceItem {
	s.SourceFiles = v
	return s
}

// SetSubjectId sets the SubjectId field's value.
func (s *StartReadSetImportJobSourceItem) SetSubjectId(v string) *StartReadSetImportJobSourceItem {
	s.SubjectId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartReadSetImportJobSourceItem) SetTags(v map[string]*string) *StartReadSetImportJobSourceItem {
	s.Tags = v
	return s
}

type StartReferenceImportJobInput struct {
	_ struct{} `type:"structure"`

	// To ensure that jobs don't run multiple times, specify a unique token for
	// each job.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The job's reference store ID.
	//
	// ReferenceStoreId is a required field
	ReferenceStoreId *string `location:"uri" locationName:"referenceStoreId" min:"10" type:"string" required:"true"`

	// A service role for the job.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The job's source files.
	//
	// Sources is a required field
	Sources []*StartReferenceImportJobSourceItem `locationName:"sources" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReferenceImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReferenceImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReferenceImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartReferenceImportJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ReferenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceStoreId"))
	}
	if s.ReferenceStoreId != nil && len(*s.ReferenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ReferenceStoreId", 10))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.Sources != nil && len(s.Sources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sources", 1))
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartReferenceImportJobInput) SetClientToken(v string) *StartReferenceImportJobInput {
	s.ClientToken = &v
	return s
}

// SetReferenceStoreId sets the ReferenceStoreId field's value.
func (s *StartReferenceImportJobInput) SetReferenceStoreId(v string) *StartReferenceImportJobInput {
	s.ReferenceStoreId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *StartReferenceImportJobInput) SetRoleArn(v string) *StartReferenceImportJobInput {
	s.RoleArn = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *StartReferenceImportJobInput) SetSources(v []*StartReferenceImportJobSourceItem) *StartReferenceImportJobInput {
	s.Sources = v
	return s
}

type StartReferenceImportJobOutput struct {
	_ struct{} `type:"structure"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"10" type:"string" required:"true"`

	// The job's reference store ID.
	//
	// ReferenceStoreId is a required field
	ReferenceStoreId *string `locationName:"referenceStoreId" min:"10" type:"string" required:"true"`

	// The job's service role ARN.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The job's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReferenceImportJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReferenceImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReferenceImportJobOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *StartReferenceImportJobOutput) SetCreationTime(v time.Time) *StartReferenceImportJobOutput {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *StartReferenceImportJobOutput) SetId(v string) *StartReferenceImportJobOutput {
	s.Id = &v
	return s
}

// SetReferenceStoreId sets the ReferenceStoreId field's value.
func (s *StartReferenceImportJobOutput) SetReferenceStoreId(v string) *StartReferenceImportJobOutput {
	s.ReferenceStoreId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *StartReferenceImportJobOutput) SetRoleArn(v string) *StartReferenceImportJobOutput {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StartReferenceImportJobOutput) SetStatus(v string) *StartReferenceImportJobOutput {
	s.Status = &v
	return s
}

// A source for a reference import job.
type StartReferenceImportJobSourceItem struct {
	_ struct{} `type:"structure"`

	// The source's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The source's name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The source file's location in Amazon S3.
	//
	// SourceFile is a required field
	SourceFile *string `locationName:"sourceFile" type:"string" required:"true"`

	// The source's tags.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReferenceImportJobSourceItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReferenceImportJobSourceItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReferenceImportJobSourceItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartReferenceImportJobSourceItem"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.SourceFile == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceFile"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *StartReferenceImportJobSourceItem) SetDescription(v string) *StartReferenceImportJobSourceItem {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartReferenceImportJobSourceItem) SetName(v string) *StartReferenceImportJobSourceItem {
	s.Name = &v
	return s
}

// SetSourceFile sets the SourceFile field's value.
func (s *StartReferenceImportJobSourceItem) SetSourceFile(v string) *StartReferenceImportJobSourceItem {
	s.SourceFile = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartReferenceImportJobSourceItem) SetTags(v map[string]*string) *StartReferenceImportJobSourceItem {
	s.Tags = v
	return s
}

type StartRunInput struct {
	_ struct{} `type:"structure"`

	// A log level for the run.
	LogLevel *string `locationName:"logLevel" min:"1" type:"string" enum:"RunLogLevel"`

	// A name for the run.
	Name *string `locationName:"name" min:"1" type:"string"`

	// An output URI for the run.
	OutputUri *string `locationName:"outputUri" min:"1" type:"string"`

	// A priority for the run.
	Priority *int64 `locationName:"priority" type:"integer"`

	// To ensure that requests don't run multiple times, specify a unique ID for
	// each request.
	RequestId *string `locationName:"requestId" min:"1" type:"string" idempotencyToken:"true"`

	// The retention mode for the run.
	RetentionMode *string `locationName:"retentionMode" min:"1" type:"string" enum:"RunRetentionMode"`

	// A service role for the run.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`

	// The run's group ID.
	RunGroupId *string `locationName:"runGroupId" min:"1" type:"string"`

	// The ID of a run to duplicate.
	RunId *string `locationName:"runId" min:"1" type:"string"`

	// A storage capacity for the run in gigabytes.
	StorageCapacity *int64 `locationName:"storageCapacity" type:"integer"`

	// Tags for the run.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The run's workflow ID.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string"`

	// The run's workflow type.
	WorkflowType *string `locationName:"workflowType" min:"1" type:"string" enum:"WorkflowType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartRunInput"}
	if s.LogLevel != nil && len(*s.LogLevel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogLevel", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OutputUri != nil && len(*s.OutputUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputUri", 1))
	}
	if s.RequestId != nil && len(*s.RequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestId", 1))
	}
	if s.RetentionMode != nil && len(*s.RetentionMode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RetentionMode", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.RunGroupId != nil && len(*s.RunGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RunGroupId", 1))
	}
	if s.RunId != nil && len(*s.RunId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RunId", 1))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}
	if s.WorkflowType != nil && len(*s.WorkflowType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogLevel sets the LogLevel field's value.
func (s *StartRunInput) SetLogLevel(v string) *StartRunInput {
	s.LogLevel = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartRunInput) SetName(v string) *StartRunInput {
	s.Name = &v
	return s
}

// SetOutputUri sets the OutputUri field's value.
func (s *StartRunInput) SetOutputUri(v string) *StartRunInput {
	s.OutputUri = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *StartRunInput) SetPriority(v int64) *StartRunInput {
	s.Priority = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *StartRunInput) SetRequestId(v string) *StartRunInput {
	s.RequestId = &v
	return s
}

// SetRetentionMode sets the RetentionMode field's value.
func (s *StartRunInput) SetRetentionMode(v string) *StartRunInput {
	s.RetentionMode = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *StartRunInput) SetRoleArn(v string) *StartRunInput {
	s.RoleArn = &v
	return s
}

// SetRunGroupId sets the RunGroupId field's value.
func (s *StartRunInput) SetRunGroupId(v string) *StartRunInput {
	s.RunGroupId = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *StartRunInput) SetRunId(v string) *StartRunInput {
	s.RunId = &v
	return s
}

// SetStorageCapacity sets the StorageCapacity field's value.
func (s *StartRunInput) SetStorageCapacity(v int64) *StartRunInput {
	s.StorageCapacity = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartRunInput) SetTags(v map[string]*string) *StartRunInput {
	s.Tags = v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *StartRunInput) SetWorkflowId(v string) *StartRunInput {
	s.WorkflowId = &v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *StartRunInput) SetWorkflowType(v string) *StartRunInput {
	s.WorkflowType = &v
	return s
}

type StartRunOutput struct {
	_ struct{} `type:"structure"`

	// The run's ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The run's ID.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The destination for workflow outputs.
	RunOutputUri *string `locationName:"runOutputUri" min:"1" type:"string"`

	// The run's status.
	Status *string `locationName:"status" min:"1" type:"string" enum:"RunStatus"`

	// The run's tags.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The universally unique identifier for a run.
	Uuid *string `locationName:"uuid" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRunOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StartRunOutput) SetArn(v string) *StartRunOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *StartRunOutput) SetId(v string) *StartRunOutput {
	s.Id = &v
	return s
}

// SetRunOutputUri sets the RunOutputUri field's value.
func (s *StartRunOutput) SetRunOutputUri(v string) *StartRunOutput {
	s.RunOutputUri = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StartRunOutput) SetStatus(v string) *StartRunOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartRunOutput) SetTags(v map[string]*string) *StartRunOutput {
	s.Tags = v
	return s
}

// SetUuid sets the Uuid field's value.
func (s *StartRunOutput) SetUuid(v string) *StartRunOutput {
	s.Uuid = &v
	return s
}

type StartVariantImportJobInput struct {
	_ struct{} `type:"structure"`

	// The annotation schema generated by the parsed annotation data.
	AnnotationFields map[string]*string `locationName:"annotationFields" type:"map"`

	// The destination variant store for the job.
	//
	// DestinationName is a required field
	DestinationName *string `locationName:"destinationName" min:"3" type:"string" required:"true"`

	// Items to import.
	//
	// Items is a required field
	Items []*VariantImportItemSource `locationName:"items" min:"1" type:"list" required:"true"`

	// A service role for the job.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The job's left normalization setting.
	RunLeftNormalization *bool `locationName:"runLeftNormalization" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartVariantImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartVariantImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartVariantImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartVariantImportJobInput"}
	if s.DestinationName == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationName"))
	}
	if s.DestinationName != nil && len(*s.DestinationName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationName", 3))
	}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.Items != nil && len(s.Items) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Items", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnnotationFields sets the AnnotationFields field's value.
func (s *StartVariantImportJobInput) SetAnnotationFields(v map[string]*string) *StartVariantImportJobInput {
	s.AnnotationFields = v
	return s
}

// SetDestinationName sets the DestinationName field's value.
func (s *StartVariantImportJobInput) SetDestinationName(v string) *StartVariantImportJobInput {
	s.DestinationName = &v
	return s
}

// SetItems sets the Items field's value.
func (s *StartVariantImportJobInput) SetItems(v []*VariantImportItemSource) *StartVariantImportJobInput {
	s.Items = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *StartVariantImportJobInput) SetRoleArn(v string) *StartVariantImportJobInput {
	s.RoleArn = &v
	return s
}

// SetRunLeftNormalization sets the RunLeftNormalization field's value.
func (s *StartVariantImportJobInput) SetRunLeftNormalization(v bool) *StartVariantImportJobInput {
	s.RunLeftNormalization = &v
	return s
}

type StartVariantImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The job's ID.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartVariantImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartVariantImportJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartVariantImportJobOutput) SetJobId(v string) *StartVariantImportJobOutput {
	s.JobId = &v
	return s
}

// Settings for a store.
type StoreOptions struct {
	_ struct{} `type:"structure"`

	// File settings for a TSV store.
	TsvStoreOptions *TsvStoreOptions `locationName:"tsvStoreOptions" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StoreOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StoreOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StoreOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StoreOptions"}
	if s.TsvStoreOptions != nil {
		if err := s.TsvStoreOptions.Validate(); err != nil {
			invalidParams.AddNested("TsvStoreOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTsvStoreOptions sets the TsvStoreOptions field's value.
func (s *StoreOptions) SetTsvStoreOptions(v *TsvStoreOptions) *StoreOptions {
	s.TsvStoreOptions = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource's ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// Tags for the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// A workflow run task.
type TaskListItem struct {
	_ struct{} `type:"structure"`

	// The task's CPU count.
	Cpus *int64 `locationName:"cpus" min:"1" type:"integer"`

	// When the task was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The number of Graphics Processing Units (GPU) specified for the task.
	Gpus *int64 `locationName:"gpus" type:"integer"`

	// The instance type for a task.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The task's memory use in gigabyes.
	Memory *int64 `locationName:"memory" min:"1" type:"integer"`

	// The task's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// When the task started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// The task's status.
	Status *string `locationName:"status" min:"1" type:"string" enum:"TaskStatus"`

	// When the task stopped.
	StopTime *time.Time `locationName:"stopTime" type:"timestamp" timestampFormat:"iso8601"`

	// The task's ID.
	TaskId *string `locationName:"taskId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskListItem) GoString() string {
	return s.String()
}

// SetCpus sets the Cpus field's value.
func (s *TaskListItem) SetCpus(v int64) *TaskListItem {
	s.Cpus = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *TaskListItem) SetCreationTime(v time.Time) *TaskListItem {
	s.CreationTime = &v
	return s
}

// SetGpus sets the Gpus field's value.
func (s *TaskListItem) SetGpus(v int64) *TaskListItem {
	s.Gpus = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *TaskListItem) SetInstanceType(v string) *TaskListItem {
	s.InstanceType = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *TaskListItem) SetMemory(v int64) *TaskListItem {
	s.Memory = &v
	return s
}

// SetName sets the Name field's value.
func (s *TaskListItem) SetName(v string) *TaskListItem {
	s.Name = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TaskListItem) SetStartTime(v time.Time) *TaskListItem {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TaskListItem) SetStatus(v string) *TaskListItem {
	s.Status = &v
	return s
}

// SetStopTime sets the StopTime field's value.
func (s *TaskListItem) SetStopTime(v time.Time) *TaskListItem {
	s.StopTime = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *TaskListItem) SetTaskId(v string) *TaskListItem {
	s.TaskId = &v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Formatting options for a TSV file.
type TsvOptions struct {
	_ struct{} `type:"structure"`

	// The file's read options.
	ReadOptions *ReadOptions `locationName:"readOptions" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TsvOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TsvOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TsvOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TsvOptions"}
	if s.ReadOptions != nil {
		if err := s.ReadOptions.Validate(); err != nil {
			invalidParams.AddNested("ReadOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReadOptions sets the ReadOptions field's value.
func (s *TsvOptions) SetReadOptions(v *ReadOptions) *TsvOptions {
	s.ReadOptions = v
	return s
}

// File settings for a TSV store.
type TsvStoreOptions struct {
	_ struct{} `type:"structure"`

	// The store's annotation type.
	AnnotationType *string `locationName:"annotationType" type:"string" enum:"AnnotationType"`

	// The store's header key to column name mapping.
	FormatToHeader map[string]*string `locationName:"formatToHeader" type:"map"`

	// The store's schema.
	Schema []map[string]*string `locationName:"schema" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TsvStoreOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TsvStoreOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TsvStoreOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TsvStoreOptions"}
	if s.Schema != nil && len(s.Schema) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Schema", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnnotationType sets the AnnotationType field's value.
func (s *TsvStoreOptions) SetAnnotationType(v string) *TsvStoreOptions {
	s.AnnotationType = &v
	return s
}

// SetFormatToHeader sets the FormatToHeader field's value.
func (s *TsvStoreOptions) SetFormatToHeader(v map[string]*string) *TsvStoreOptions {
	s.FormatToHeader = v
	return s
}

// SetSchema sets the Schema field's value.
func (s *TsvStoreOptions) SetSchema(v []map[string]*string) *TsvStoreOptions {
	s.Schema = v
	return s
}

// The options for a TSV file.
type TsvVersionOptions struct {
	_ struct{} `type:"structure"`

	// The store version's annotation type.
	AnnotationType *string `locationName:"annotationType" type:"string" enum:"AnnotationType"`

	// The annotation store version's header key to column name mapping.
	FormatToHeader map[string]*string `locationName:"formatToHeader" type:"map"`

	// The TSV schema for an annotation store version.
	Schema []map[string]*string `locationName:"schema" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TsvVersionOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TsvVersionOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TsvVersionOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TsvVersionOptions"}
	if s.Schema != nil && len(s.Schema) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Schema", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnnotationType sets the AnnotationType field's value.
func (s *TsvVersionOptions) SetAnnotationType(v string) *TsvVersionOptions {
	s.AnnotationType = &v
	return s
}

// SetFormatToHeader sets the FormatToHeader field's value.
func (s *TsvVersionOptions) SetFormatToHeader(v map[string]*string) *TsvVersionOptions {
	s.FormatToHeader = v
	return s
}

// SetSchema sets the Schema field's value.
func (s *TsvVersionOptions) SetSchema(v []map[string]*string) *TsvVersionOptions {
	s.Schema = v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The resource's ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// Keys of tags to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAnnotationStoreInput struct {
	_ struct{} `type:"structure"`

	// A description for the store.
	Description *string `locationName:"description" type:"string"`

	// A name for the store.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnnotationStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnnotationStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAnnotationStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAnnotationStoreInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateAnnotationStoreInput) SetDescription(v string) *UpdateAnnotationStoreInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAnnotationStoreInput) SetName(v string) *UpdateAnnotationStoreInput {
	s.Name = &v
	return s
}

type UpdateAnnotationStoreOutput struct {
	_ struct{} `type:"structure"`

	// When the store was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The store's description.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The store's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The store's name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The store's genome reference.
	//
	// Reference is a required field
	Reference *ReferenceItem `locationName:"reference" type:"structure" required:"true"`

	// The store's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"StoreStatus"`

	// The annotation file format of the store.
	StoreFormat *string `locationName:"storeFormat" type:"string" enum:"StoreFormat"`

	// Parsing options for the store.
	StoreOptions *StoreOptions `locationName:"storeOptions" type:"structure"`

	// When the store was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnnotationStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnnotationStoreOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *UpdateAnnotationStoreOutput) SetCreationTime(v time.Time) *UpdateAnnotationStoreOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAnnotationStoreOutput) SetDescription(v string) *UpdateAnnotationStoreOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateAnnotationStoreOutput) SetId(v string) *UpdateAnnotationStoreOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAnnotationStoreOutput) SetName(v string) *UpdateAnnotationStoreOutput {
	s.Name = &v
	return s
}

// SetReference sets the Reference field's value.
func (s *UpdateAnnotationStoreOutput) SetReference(v *ReferenceItem) *UpdateAnnotationStoreOutput {
	s.Reference = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateAnnotationStoreOutput) SetStatus(v string) *UpdateAnnotationStoreOutput {
	s.Status = &v
	return s
}

// SetStoreFormat sets the StoreFormat field's value.
func (s *UpdateAnnotationStoreOutput) SetStoreFormat(v string) *UpdateAnnotationStoreOutput {
	s.StoreFormat = &v
	return s
}

// SetStoreOptions sets the StoreOptions field's value.
func (s *UpdateAnnotationStoreOutput) SetStoreOptions(v *StoreOptions) *UpdateAnnotationStoreOutput {
	s.StoreOptions = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *UpdateAnnotationStoreOutput) SetUpdateTime(v time.Time) *UpdateAnnotationStoreOutput {
	s.UpdateTime = &v
	return s
}

type UpdateAnnotationStoreVersionInput struct {
	_ struct{} `type:"structure"`

	// The description of an annotation store.
	Description *string `locationName:"description" type:"string"`

	// The name of an annotation store.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of an annotation store version.
	//
	// VersionName is a required field
	VersionName *string `location:"uri" locationName:"versionName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnnotationStoreVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnnotationStoreVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAnnotationStoreVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAnnotationStoreVersionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.VersionName == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionName"))
	}
	if s.VersionName != nil && len(*s.VersionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateAnnotationStoreVersionInput) SetDescription(v string) *UpdateAnnotationStoreVersionInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAnnotationStoreVersionInput) SetName(v string) *UpdateAnnotationStoreVersionInput {
	s.Name = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *UpdateAnnotationStoreVersionInput) SetVersionName(v string) *UpdateAnnotationStoreVersionInput {
	s.VersionName = &v
	return s
}

type UpdateAnnotationStoreVersionOutput struct {
	_ struct{} `type:"structure"`

	// The time stamp for when an annotation store version was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of an annotation store version.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The annotation store version ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of an annotation store.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The status of an annotation store version.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"VersionStatus"`

	// The annotation store ID.
	//
	// StoreId is a required field
	StoreId *string `locationName:"storeId" type:"string" required:"true"`

	// The time stamp for when an annotation store version was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of an annotation store version.
	//
	// VersionName is a required field
	VersionName *string `locationName:"versionName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnnotationStoreVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnnotationStoreVersionOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *UpdateAnnotationStoreVersionOutput) SetCreationTime(v time.Time) *UpdateAnnotationStoreVersionOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAnnotationStoreVersionOutput) SetDescription(v string) *UpdateAnnotationStoreVersionOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateAnnotationStoreVersionOutput) SetId(v string) *UpdateAnnotationStoreVersionOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAnnotationStoreVersionOutput) SetName(v string) *UpdateAnnotationStoreVersionOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateAnnotationStoreVersionOutput) SetStatus(v string) *UpdateAnnotationStoreVersionOutput {
	s.Status = &v
	return s
}

// SetStoreId sets the StoreId field's value.
func (s *UpdateAnnotationStoreVersionOutput) SetStoreId(v string) *UpdateAnnotationStoreVersionOutput {
	s.StoreId = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *UpdateAnnotationStoreVersionOutput) SetUpdateTime(v time.Time) *UpdateAnnotationStoreVersionOutput {
	s.UpdateTime = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *UpdateAnnotationStoreVersionOutput) SetVersionName(v string) *UpdateAnnotationStoreVersionOutput {
	s.VersionName = &v
	return s
}

type UpdateRunGroupInput struct {
	_ struct{} `type:"structure"`

	// The group's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The maximum number of CPUs to use.
	MaxCpus *int64 `locationName:"maxCpus" min:"1" type:"integer"`

	// A maximum run time for the group in minutes.
	MaxDuration *int64 `locationName:"maxDuration" min:"1" type:"integer"`

	// The maximum GPUs that can be used by a run group.
	MaxGpus *int64 `locationName:"maxGpus" min:"1" type:"integer"`

	// The maximum number of concurrent runs for the group.
	MaxRuns *int64 `locationName:"maxRuns" min:"1" type:"integer"`

	// A name for the group.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRunGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRunGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRunGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRunGroupInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.MaxCpus != nil && *s.MaxCpus < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxCpus", 1))
	}
	if s.MaxDuration != nil && *s.MaxDuration < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxDuration", 1))
	}
	if s.MaxGpus != nil && *s.MaxGpus < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxGpus", 1))
	}
	if s.MaxRuns != nil && *s.MaxRuns < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRuns", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdateRunGroupInput) SetId(v string) *UpdateRunGroupInput {
	s.Id = &v
	return s
}

// SetMaxCpus sets the MaxCpus field's value.
func (s *UpdateRunGroupInput) SetMaxCpus(v int64) *UpdateRunGroupInput {
	s.MaxCpus = &v
	return s
}

// SetMaxDuration sets the MaxDuration field's value.
func (s *UpdateRunGroupInput) SetMaxDuration(v int64) *UpdateRunGroupInput {
	s.MaxDuration = &v
	return s
}

// SetMaxGpus sets the MaxGpus field's value.
func (s *UpdateRunGroupInput) SetMaxGpus(v int64) *UpdateRunGroupInput {
	s.MaxGpus = &v
	return s
}

// SetMaxRuns sets the MaxRuns field's value.
func (s *UpdateRunGroupInput) SetMaxRuns(v int64) *UpdateRunGroupInput {
	s.MaxRuns = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateRunGroupInput) SetName(v string) *UpdateRunGroupInput {
	s.Name = &v
	return s
}

type UpdateRunGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRunGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRunGroupOutput) GoString() string {
	return s.String()
}

type UpdateVariantStoreInput struct {
	_ struct{} `type:"structure"`

	// A description for the store.
	Description *string `locationName:"description" type:"string"`

	// A name for the store.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVariantStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVariantStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVariantStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVariantStoreInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateVariantStoreInput) SetDescription(v string) *UpdateVariantStoreInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateVariantStoreInput) SetName(v string) *UpdateVariantStoreInput {
	s.Name = &v
	return s
}

type UpdateVariantStoreOutput struct {
	_ struct{} `type:"structure"`

	// When the store was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The store's description.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The store's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The store's name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The store's genome reference.
	//
	// Reference is a required field
	Reference *ReferenceItem `locationName:"reference" type:"structure" required:"true"`

	// The store's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"StoreStatus"`

	// When the store was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVariantStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVariantStoreOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *UpdateVariantStoreOutput) SetCreationTime(v time.Time) *UpdateVariantStoreOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateVariantStoreOutput) SetDescription(v string) *UpdateVariantStoreOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateVariantStoreOutput) SetId(v string) *UpdateVariantStoreOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateVariantStoreOutput) SetName(v string) *UpdateVariantStoreOutput {
	s.Name = &v
	return s
}

// SetReference sets the Reference field's value.
func (s *UpdateVariantStoreOutput) SetReference(v *ReferenceItem) *UpdateVariantStoreOutput {
	s.Reference = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateVariantStoreOutput) SetStatus(v string) *UpdateVariantStoreOutput {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *UpdateVariantStoreOutput) SetUpdateTime(v time.Time) *UpdateVariantStoreOutput {
	s.UpdateTime = &v
	return s
}

type UpdateWorkflowInput struct {
	_ struct{} `type:"structure"`

	// A description for the workflow.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The workflow's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// A name for the workflow.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkflowInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateWorkflowInput) SetDescription(v string) *UpdateWorkflowInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateWorkflowInput) SetId(v string) *UpdateWorkflowInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateWorkflowInput) SetName(v string) *UpdateWorkflowInput {
	s.Name = &v
	return s
}

type UpdateWorkflowOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkflowOutput) GoString() string {
	return s.String()
}

type UploadReadSetPartInput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// The number of the part being uploaded.
	//
	// PartNumber is a required field
	PartNumber *int64 `location:"querystring" locationName:"partNumber" min:"1" type:"integer" required:"true"`

	// The source file for an upload part.
	//
	// PartSource is a required field
	PartSource *string `location:"querystring" locationName:"partSource" type:"string" required:"true" enum:"ReadSetPartSource"`

	// The read set data to upload for a part.
	//
	// To use an non-seekable io.Reader for this request wrap the io.Reader with
	// "aws.ReadSeekCloser". The SDK will not retry request errors for non-seekable
	// readers. This will allow the SDK to send the reader's payload as chunked
	// transfer encoding.
	//
	// Payload is a required field
	Payload io.ReadSeeker `locationName:"payload" type:"blob" required:"true"`

	// The Sequence Store ID used for the multipart upload.
	//
	// SequenceStoreId is a required field
	SequenceStoreId *string `location:"uri" locationName:"sequenceStoreId" min:"10" type:"string" required:"true"`

	// The ID for the initiated multipart upload.
	//
	// UploadId is a required field
	UploadId *string `location:"uri" locationName:"uploadId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UploadReadSetPartInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UploadReadSetPartInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadReadSetPartInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UploadReadSetPartInput"}
	if s.PartNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PartNumber"))
	}
	if s.PartNumber != nil && *s.PartNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PartNumber", 1))
	}
	if s.PartSource == nil {
		invalidParams.Add(request.NewErrParamRequired("PartSource"))
	}
	if s.Payload == nil {
		invalidParams.Add(request.NewErrParamRequired("Payload"))
	}
	if s.SequenceStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("SequenceStoreId"))
	}
	if s.SequenceStoreId != nil && len(*s.SequenceStoreId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SequenceStoreId", 10))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}
	if s.UploadId != nil && len(*s.UploadId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("UploadId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPartNumber sets the PartNumber field's value.
func (s *UploadReadSetPartInput) SetPartNumber(v int64) *UploadReadSetPartInput {
	s.PartNumber = &v
	return s
}

// SetPartSource sets the PartSource field's value.
func (s *UploadReadSetPartInput) SetPartSource(v string) *UploadReadSetPartInput {
	s.PartSource = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *UploadReadSetPartInput) SetPayload(v io.ReadSeeker) *UploadReadSetPartInput {
	s.Payload = v
	return s
}

// SetSequenceStoreId sets the SequenceStoreId field's value.
func (s *UploadReadSetPartInput) SetSequenceStoreId(v string) *UploadReadSetPartInput {
	s.SequenceStoreId = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *UploadReadSetPartInput) SetUploadId(v string) *UploadReadSetPartInput {
	s.UploadId = &v
	return s
}

type UploadReadSetPartOutput struct {
	_ struct{} `type:"structure"`

	// An identifier used to confirm that parts are being added to the intended
	// upload.
	//
	// Checksum is a required field
	Checksum *string `locationName:"checksum" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UploadReadSetPartOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UploadReadSetPartOutput) GoString() string {
	return s.String()
}

// SetChecksum sets the Checksum field's value.
func (s *UploadReadSetPartOutput) SetChecksum(v string) *UploadReadSetPartOutput {
	s.Checksum = &v
	return s
}

// The input fails to satisfy the constraints specified by an AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about an imported variant item.
type VariantImportItemDetail struct {
	_ struct{} `type:"structure"`

	// The item's job status.
	//
	// JobStatus is a required field
	JobStatus *string `locationName:"jobStatus" type:"string" required:"true" enum:"JobStatus"`

	// The source file's location in Amazon S3.
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true"`

	// A message that provides additional context about a job
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariantImportItemDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariantImportItemDetail) GoString() string {
	return s.String()
}

// SetJobStatus sets the JobStatus field's value.
func (s *VariantImportItemDetail) SetJobStatus(v string) *VariantImportItemDetail {
	s.JobStatus = &v
	return s
}

// SetSource sets the Source field's value.
func (s *VariantImportItemDetail) SetSource(v string) *VariantImportItemDetail {
	s.Source = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *VariantImportItemDetail) SetStatusMessage(v string) *VariantImportItemDetail {
	s.StatusMessage = &v
	return s
}

// A imported variant item's source.
type VariantImportItemSource struct {
	_ struct{} `type:"structure"`

	// The source file's location in Amazon S3.
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariantImportItemSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariantImportItemSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VariantImportItemSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VariantImportItemSource"}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSource sets the Source field's value.
func (s *VariantImportItemSource) SetSource(v string) *VariantImportItemSource {
	s.Source = &v
	return s
}

// A variant import job.
type VariantImportJobItem struct {
	_ struct{} `type:"structure"`

	// The annotation schema generated by the parsed annotation data.
	AnnotationFields map[string]*string `locationName:"annotationFields" type:"map"`

	// When the job completed.
	CompletionTime *time.Time `locationName:"completionTime" type:"timestamp" timestampFormat:"iso8601"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The job's destination variant store.
	//
	// DestinationName is a required field
	DestinationName *string `locationName:"destinationName" type:"string" required:"true"`

	// The job's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The job's service role ARN.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The job's left normalization setting.
	RunLeftNormalization *bool `locationName:"runLeftNormalization" type:"boolean"`

	// The job's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"JobStatus"`

	// When the job was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariantImportJobItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariantImportJobItem) GoString() string {
	return s.String()
}

// SetAnnotationFields sets the AnnotationFields field's value.
func (s *VariantImportJobItem) SetAnnotationFields(v map[string]*string) *VariantImportJobItem {
	s.AnnotationFields = v
	return s
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *VariantImportJobItem) SetCompletionTime(v time.Time) *VariantImportJobItem {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *VariantImportJobItem) SetCreationTime(v time.Time) *VariantImportJobItem {
	s.CreationTime = &v
	return s
}

// SetDestinationName sets the DestinationName field's value.
func (s *VariantImportJobItem) SetDestinationName(v string) *VariantImportJobItem {
	s.DestinationName = &v
	return s
}

// SetId sets the Id field's value.
func (s *VariantImportJobItem) SetId(v string) *VariantImportJobItem {
	s.Id = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *VariantImportJobItem) SetRoleArn(v string) *VariantImportJobItem {
	s.RoleArn = &v
	return s
}

// SetRunLeftNormalization sets the RunLeftNormalization field's value.
func (s *VariantImportJobItem) SetRunLeftNormalization(v bool) *VariantImportJobItem {
	s.RunLeftNormalization = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *VariantImportJobItem) SetStatus(v string) *VariantImportJobItem {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *VariantImportJobItem) SetUpdateTime(v time.Time) *VariantImportJobItem {
	s.UpdateTime = &v
	return s
}

// A variant store.
type VariantStoreItem struct {
	_ struct{} `type:"structure"`

	// When the store was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The store's description.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The store's ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The store's name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The store's genome reference.
	//
	// Reference is a required field
	Reference *ReferenceItem `locationName:"reference" type:"structure" required:"true"`

	// The store's server-side encryption (SSE) settings.
	//
	// SseConfig is a required field
	SseConfig *SseConfig `locationName:"sseConfig" type:"structure" required:"true"`

	// The store's status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"StoreStatus"`

	// The store's status message.
	//
	// StatusMessage is a required field
	StatusMessage *string `locationName:"statusMessage" type:"string" required:"true"`

	// The store's ARN.
	//
	// StoreArn is a required field
	StoreArn *string `locationName:"storeArn" min:"20" type:"string" required:"true"`

	// The store's size in bytes.
	//
	// StoreSizeBytes is a required field
	StoreSizeBytes *int64 `locationName:"storeSizeBytes" type:"long" required:"true"`

	// When the store was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariantStoreItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariantStoreItem) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *VariantStoreItem) SetCreationTime(v time.Time) *VariantStoreItem {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *VariantStoreItem) SetDescription(v string) *VariantStoreItem {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *VariantStoreItem) SetId(v string) *VariantStoreItem {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *VariantStoreItem) SetName(v string) *VariantStoreItem {
	s.Name = &v
	return s
}

// SetReference sets the Reference field's value.
func (s *VariantStoreItem) SetReference(v *ReferenceItem) *VariantStoreItem {
	s.Reference = v
	return s
}

// SetSseConfig sets the SseConfig field's value.
func (s *VariantStoreItem) SetSseConfig(v *SseConfig) *VariantStoreItem {
	s.SseConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *VariantStoreItem) SetStatus(v string) *VariantStoreItem {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *VariantStoreItem) SetStatusMessage(v string) *VariantStoreItem {
	s.StatusMessage = &v
	return s
}

// SetStoreArn sets the StoreArn field's value.
func (s *VariantStoreItem) SetStoreArn(v string) *VariantStoreItem {
	s.StoreArn = &v
	return s
}

// SetStoreSizeBytes sets the StoreSizeBytes field's value.
func (s *VariantStoreItem) SetStoreSizeBytes(v int64) *VariantStoreItem {
	s.StoreSizeBytes = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *VariantStoreItem) SetUpdateTime(v time.Time) *VariantStoreItem {
	s.UpdateTime = &v
	return s
}

// Formatting options for a VCF file.
type VcfOptions struct {
	_ struct{} `type:"structure"`

	// The file's ignore filter field setting.
	IgnoreFilterField *bool `locationName:"ignoreFilterField" type:"boolean"`

	// The file's ignore qual field setting.
	IgnoreQualField *bool `locationName:"ignoreQualField" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VcfOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VcfOptions) GoString() string {
	return s.String()
}

// SetIgnoreFilterField sets the IgnoreFilterField field's value.
func (s *VcfOptions) SetIgnoreFilterField(v bool) *VcfOptions {
	s.IgnoreFilterField = &v
	return s
}

// SetIgnoreQualField sets the IgnoreQualField field's value.
func (s *VcfOptions) SetIgnoreQualField(v bool) *VcfOptions {
	s.IgnoreQualField = &v
	return s
}

// The error preventing deletion of the annotation store version.
type VersionDeleteError struct {
	_ struct{} `type:"structure"`

	// The message explaining the error in annotation store deletion.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name given to an annotation store version.
	//
	// VersionName is a required field
	VersionName *string `locationName:"versionName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VersionDeleteError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VersionDeleteError) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *VersionDeleteError) SetMessage(v string) *VersionDeleteError {
	s.Message = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *VersionDeleteError) SetVersionName(v string) *VersionDeleteError {
	s.VersionName = &v
	return s
}

// The options for an annotation store version.
type VersionOptions struct {
	_ struct{} `type:"structure"`

	// File settings for a version of a TSV store.
	TsvVersionOptions *TsvVersionOptions `locationName:"tsvVersionOptions" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VersionOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VersionOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VersionOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VersionOptions"}
	if s.TsvVersionOptions != nil {
		if err := s.TsvVersionOptions.Validate(); err != nil {
			invalidParams.AddNested("TsvVersionOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTsvVersionOptions sets the TsvVersionOptions field's value.
func (s *VersionOptions) SetTsvVersionOptions(v *TsvVersionOptions) *VersionOptions {
	s.TsvVersionOptions = v
	return s
}

// A workflow.
type WorkflowListItem struct {
	_ struct{} `type:"structure"`

	// The workflow's ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// When the workflow was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The workflow's digest.
	Digest *string `locationName:"digest" min:"1" type:"string"`

	// The workflow's ID.
	Id *string `locationName:"id" min:"1" type:"string"`

	// Any metadata available for workflow. The information listed may vary depending
	// on the workflow, and there may also be no metadata to return.
	Metadata map[string]*string `locationName:"metadata" type:"map"`

	// The workflow's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The workflow's status.
	Status *string `locationName:"status" min:"1" type:"string" enum:"WorkflowStatus"`

	// The workflow's type.
	Type *string `locationName:"type" min:"1" type:"string" enum:"WorkflowType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowListItem) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *WorkflowListItem) SetArn(v string) *WorkflowListItem {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *WorkflowListItem) SetCreationTime(v time.Time) *WorkflowListItem {
	s.CreationTime = &v
	return s
}

// SetDigest sets the Digest field's value.
func (s *WorkflowListItem) SetDigest(v string) *WorkflowListItem {
	s.Digest = &v
	return s
}

// SetId sets the Id field's value.
func (s *WorkflowListItem) SetId(v string) *WorkflowListItem {
	s.Id = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *WorkflowListItem) SetMetadata(v map[string]*string) *WorkflowListItem {
	s.Metadata = v
	return s
}

// SetName sets the Name field's value.
func (s *WorkflowListItem) SetName(v string) *WorkflowListItem {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *WorkflowListItem) SetStatus(v string) *WorkflowListItem {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *WorkflowListItem) SetType(v string) *WorkflowListItem {
	s.Type = &v
	return s
}

// A workflow parameter.
type WorkflowParameter struct {
	_ struct{} `type:"structure"`

	// The parameter's description.
	Description *string `locationName:"description" type:"string"`

	// Whether the parameter is optional.
	Optional *bool `locationName:"optional" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowParameter) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *WorkflowParameter) SetDescription(v string) *WorkflowParameter {
	s.Description = &v
	return s
}

// SetOptional sets the Optional field's value.
func (s *WorkflowParameter) SetOptional(v bool) *WorkflowParameter {
	s.Optional = &v
	return s
}

const (
	// AcceleratorsGpu is a Accelerators enum value
	AcceleratorsGpu = "GPU"
)

// Accelerators_Values returns all elements of the Accelerators enum
func Accelerators_Values() []string {
	return []string{
		AcceleratorsGpu,
	}
}

const (
	// AnnotationTypeGeneric is a AnnotationType enum value
	AnnotationTypeGeneric = "GENERIC"

	// AnnotationTypeChrPos is a AnnotationType enum value
	AnnotationTypeChrPos = "CHR_POS"

	// AnnotationTypeChrPosRefAlt is a AnnotationType enum value
	AnnotationTypeChrPosRefAlt = "CHR_POS_REF_ALT"

	// AnnotationTypeChrStartEndOneBase is a AnnotationType enum value
	AnnotationTypeChrStartEndOneBase = "CHR_START_END_ONE_BASE"

	// AnnotationTypeChrStartEndRefAltOneBase is a AnnotationType enum value
	AnnotationTypeChrStartEndRefAltOneBase = "CHR_START_END_REF_ALT_ONE_BASE"

	// AnnotationTypeChrStartEndZeroBase is a AnnotationType enum value
	AnnotationTypeChrStartEndZeroBase = "CHR_START_END_ZERO_BASE"

	// AnnotationTypeChrStartEndRefAltZeroBase is a AnnotationType enum value
	AnnotationTypeChrStartEndRefAltZeroBase = "CHR_START_END_REF_ALT_ZERO_BASE"
)

// AnnotationType_Values returns all elements of the AnnotationType enum
func AnnotationType_Values() []string {
	return []string{
		AnnotationTypeGeneric,
		AnnotationTypeChrPos,
		AnnotationTypeChrPosRefAlt,
		AnnotationTypeChrStartEndOneBase,
		AnnotationTypeChrStartEndRefAltOneBase,
		AnnotationTypeChrStartEndZeroBase,
		AnnotationTypeChrStartEndRefAltZeroBase,
	}
}

const (
	// CreationTypeImport is a CreationType enum value
	CreationTypeImport = "IMPORT"

	// CreationTypeUpload is a CreationType enum value
	CreationTypeUpload = "UPLOAD"
)

// CreationType_Values returns all elements of the CreationType enum
func CreationType_Values() []string {
	return []string{
		CreationTypeImport,
		CreationTypeUpload,
	}
}

const (
	// ETagAlgorithmFastqMd5up is a ETagAlgorithm enum value
	ETagAlgorithmFastqMd5up = "FASTQ_MD5up"

	// ETagAlgorithmBamMd5up is a ETagAlgorithm enum value
	ETagAlgorithmBamMd5up = "BAM_MD5up"

	// ETagAlgorithmCramMd5up is a ETagAlgorithm enum value
	ETagAlgorithmCramMd5up = "CRAM_MD5up"
)

// ETagAlgorithm_Values returns all elements of the ETagAlgorithm enum
func ETagAlgorithm_Values() []string {
	return []string{
		ETagAlgorithmFastqMd5up,
		ETagAlgorithmBamMd5up,
		ETagAlgorithmCramMd5up,
	}
}

const (
	// EncryptionTypeKms is a EncryptionType enum value
	EncryptionTypeKms = "KMS"
)

// EncryptionType_Values returns all elements of the EncryptionType enum
func EncryptionType_Values() []string {
	return []string{
		EncryptionTypeKms,
	}
}

const (
	// FileTypeFastq is a FileType enum value
	FileTypeFastq = "FASTQ"

	// FileTypeBam is a FileType enum value
	FileTypeBam = "BAM"

	// FileTypeCram is a FileType enum value
	FileTypeCram = "CRAM"

	// FileTypeUbam is a FileType enum value
	FileTypeUbam = "UBAM"
)

// FileType_Values returns all elements of the FileType enum
func FileType_Values() []string {
	return []string{
		FileTypeFastq,
		FileTypeBam,
		FileTypeCram,
		FileTypeUbam,
	}
}

const (
	// FormatToHeaderKeyChr is a FormatToHeaderKey enum value
	FormatToHeaderKeyChr = "CHR"

	// FormatToHeaderKeyStart is a FormatToHeaderKey enum value
	FormatToHeaderKeyStart = "START"

	// FormatToHeaderKeyEnd is a FormatToHeaderKey enum value
	FormatToHeaderKeyEnd = "END"

	// FormatToHeaderKeyRef is a FormatToHeaderKey enum value
	FormatToHeaderKeyRef = "REF"

	// FormatToHeaderKeyAlt is a FormatToHeaderKey enum value
	FormatToHeaderKeyAlt = "ALT"

	// FormatToHeaderKeyPos is a FormatToHeaderKey enum value
	FormatToHeaderKeyPos = "POS"
)

// FormatToHeaderKey_Values returns all elements of the FormatToHeaderKey enum
func FormatToHeaderKey_Values() []string {
	return []string{
		FormatToHeaderKeyChr,
		FormatToHeaderKeyStart,
		FormatToHeaderKeyEnd,
		FormatToHeaderKeyRef,
		FormatToHeaderKeyAlt,
		FormatToHeaderKeyPos,
	}
}

const (
	// JobStatusSubmitted is a JobStatus enum value
	JobStatusSubmitted = "SUBMITTED"

	// JobStatusInProgress is a JobStatus enum value
	JobStatusInProgress = "IN_PROGRESS"

	// JobStatusCancelled is a JobStatus enum value
	JobStatusCancelled = "CANCELLED"

	// JobStatusCompleted is a JobStatus enum value
	JobStatusCompleted = "COMPLETED"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"

	// JobStatusCompletedWithFailures is a JobStatus enum value
	JobStatusCompletedWithFailures = "COMPLETED_WITH_FAILURES"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusSubmitted,
		JobStatusInProgress,
		JobStatusCancelled,
		JobStatusCompleted,
		JobStatusFailed,
		JobStatusCompletedWithFailures,
	}
}

const (
	// ReadSetActivationJobItemStatusNotStarted is a ReadSetActivationJobItemStatus enum value
	ReadSetActivationJobItemStatusNotStarted = "NOT_STARTED"

	// ReadSetActivationJobItemStatusInProgress is a ReadSetActivationJobItemStatus enum value
	ReadSetActivationJobItemStatusInProgress = "IN_PROGRESS"

	// ReadSetActivationJobItemStatusFinished is a ReadSetActivationJobItemStatus enum value
	ReadSetActivationJobItemStatusFinished = "FINISHED"

	// ReadSetActivationJobItemStatusFailed is a ReadSetActivationJobItemStatus enum value
	ReadSetActivationJobItemStatusFailed = "FAILED"
)

// ReadSetActivationJobItemStatus_Values returns all elements of the ReadSetActivationJobItemStatus enum
func ReadSetActivationJobItemStatus_Values() []string {
	return []string{
		ReadSetActivationJobItemStatusNotStarted,
		ReadSetActivationJobItemStatusInProgress,
		ReadSetActivationJobItemStatusFinished,
		ReadSetActivationJobItemStatusFailed,
	}
}

const (
	// ReadSetActivationJobStatusSubmitted is a ReadSetActivationJobStatus enum value
	ReadSetActivationJobStatusSubmitted = "SUBMITTED"

	// ReadSetActivationJobStatusInProgress is a ReadSetActivationJobStatus enum value
	ReadSetActivationJobStatusInProgress = "IN_PROGRESS"

	// ReadSetActivationJobStatusCancelling is a ReadSetActivationJobStatus enum value
	ReadSetActivationJobStatusCancelling = "CANCELLING"

	// ReadSetActivationJobStatusCancelled is a ReadSetActivationJobStatus enum value
	ReadSetActivationJobStatusCancelled = "CANCELLED"

	// ReadSetActivationJobStatusFailed is a ReadSetActivationJobStatus enum value
	ReadSetActivationJobStatusFailed = "FAILED"

	// ReadSetActivationJobStatusCompleted is a ReadSetActivationJobStatus enum value
	ReadSetActivationJobStatusCompleted = "COMPLETED"

	// ReadSetActivationJobStatusCompletedWithFailures is a ReadSetActivationJobStatus enum value
	ReadSetActivationJobStatusCompletedWithFailures = "COMPLETED_WITH_FAILURES"
)

// ReadSetActivationJobStatus_Values returns all elements of the ReadSetActivationJobStatus enum
func ReadSetActivationJobStatus_Values() []string {
	return []string{
		ReadSetActivationJobStatusSubmitted,
		ReadSetActivationJobStatusInProgress,
		ReadSetActivationJobStatusCancelling,
		ReadSetActivationJobStatusCancelled,
		ReadSetActivationJobStatusFailed,
		ReadSetActivationJobStatusCompleted,
		ReadSetActivationJobStatusCompletedWithFailures,
	}
}

const (
	// ReadSetExportJobItemStatusNotStarted is a ReadSetExportJobItemStatus enum value
	ReadSetExportJobItemStatusNotStarted = "NOT_STARTED"

	// ReadSetExportJobItemStatusInProgress is a ReadSetExportJobItemStatus enum value
	ReadSetExportJobItemStatusInProgress = "IN_PROGRESS"

	// ReadSetExportJobItemStatusFinished is a ReadSetExportJobItemStatus enum value
	ReadSetExportJobItemStatusFinished = "FINISHED"

	// ReadSetExportJobItemStatusFailed is a ReadSetExportJobItemStatus enum value
	ReadSetExportJobItemStatusFailed = "FAILED"
)

// ReadSetExportJobItemStatus_Values returns all elements of the ReadSetExportJobItemStatus enum
func ReadSetExportJobItemStatus_Values() []string {
	return []string{
		ReadSetExportJobItemStatusNotStarted,
		ReadSetExportJobItemStatusInProgress,
		ReadSetExportJobItemStatusFinished,
		ReadSetExportJobItemStatusFailed,
	}
}

const (
	// ReadSetExportJobStatusSubmitted is a ReadSetExportJobStatus enum value
	ReadSetExportJobStatusSubmitted = "SUBMITTED"

	// ReadSetExportJobStatusInProgress is a ReadSetExportJobStatus enum value
	ReadSetExportJobStatusInProgress = "IN_PROGRESS"

	// ReadSetExportJobStatusCancelling is a ReadSetExportJobStatus enum value
	ReadSetExportJobStatusCancelling = "CANCELLING"

	// ReadSetExportJobStatusCancelled is a ReadSetExportJobStatus enum value
	ReadSetExportJobStatusCancelled = "CANCELLED"

	// ReadSetExportJobStatusFailed is a ReadSetExportJobStatus enum value
	ReadSetExportJobStatusFailed = "FAILED"

	// ReadSetExportJobStatusCompleted is a ReadSetExportJobStatus enum value
	ReadSetExportJobStatusCompleted = "COMPLETED"

	// ReadSetExportJobStatusCompletedWithFailures is a ReadSetExportJobStatus enum value
	ReadSetExportJobStatusCompletedWithFailures = "COMPLETED_WITH_FAILURES"
)

// ReadSetExportJobStatus_Values returns all elements of the ReadSetExportJobStatus enum
func ReadSetExportJobStatus_Values() []string {
	return []string{
		ReadSetExportJobStatusSubmitted,
		ReadSetExportJobStatusInProgress,
		ReadSetExportJobStatusCancelling,
		ReadSetExportJobStatusCancelled,
		ReadSetExportJobStatusFailed,
		ReadSetExportJobStatusCompleted,
		ReadSetExportJobStatusCompletedWithFailures,
	}
}

const (
	// ReadSetFileSource1 is a ReadSetFile enum value
	ReadSetFileSource1 = "SOURCE1"

	// ReadSetFileSource2 is a ReadSetFile enum value
	ReadSetFileSource2 = "SOURCE2"

	// ReadSetFileIndex is a ReadSetFile enum value
	ReadSetFileIndex = "INDEX"
)

// ReadSetFile_Values returns all elements of the ReadSetFile enum
func ReadSetFile_Values() []string {
	return []string{
		ReadSetFileSource1,
		ReadSetFileSource2,
		ReadSetFileIndex,
	}
}

const (
	// ReadSetImportJobItemStatusNotStarted is a ReadSetImportJobItemStatus enum value
	ReadSetImportJobItemStatusNotStarted = "NOT_STARTED"

	// ReadSetImportJobItemStatusInProgress is a ReadSetImportJobItemStatus enum value
	ReadSetImportJobItemStatusInProgress = "IN_PROGRESS"

	// ReadSetImportJobItemStatusFinished is a ReadSetImportJobItemStatus enum value
	ReadSetImportJobItemStatusFinished = "FINISHED"

	// ReadSetImportJobItemStatusFailed is a ReadSetImportJobItemStatus enum value
	ReadSetImportJobItemStatusFailed = "FAILED"
)

// ReadSetImportJobItemStatus_Values returns all elements of the ReadSetImportJobItemStatus enum
func ReadSetImportJobItemStatus_Values() []string {
	return []string{
		ReadSetImportJobItemStatusNotStarted,
		ReadSetImportJobItemStatusInProgress,
		ReadSetImportJobItemStatusFinished,
		ReadSetImportJobItemStatusFailed,
	}
}

const (
	// ReadSetImportJobStatusSubmitted is a ReadSetImportJobStatus enum value
	ReadSetImportJobStatusSubmitted = "SUBMITTED"

	// ReadSetImportJobStatusInProgress is a ReadSetImportJobStatus enum value
	ReadSetImportJobStatusInProgress = "IN_PROGRESS"

	// ReadSetImportJobStatusCancelling is a ReadSetImportJobStatus enum value
	ReadSetImportJobStatusCancelling = "CANCELLING"

	// ReadSetImportJobStatusCancelled is a ReadSetImportJobStatus enum value
	ReadSetImportJobStatusCancelled = "CANCELLED"

	// ReadSetImportJobStatusFailed is a ReadSetImportJobStatus enum value
	ReadSetImportJobStatusFailed = "FAILED"

	// ReadSetImportJobStatusCompleted is a ReadSetImportJobStatus enum value
	ReadSetImportJobStatusCompleted = "COMPLETED"

	// ReadSetImportJobStatusCompletedWithFailures is a ReadSetImportJobStatus enum value
	ReadSetImportJobStatusCompletedWithFailures = "COMPLETED_WITH_FAILURES"
)

// ReadSetImportJobStatus_Values returns all elements of the ReadSetImportJobStatus enum
func ReadSetImportJobStatus_Values() []string {
	return []string{
		ReadSetImportJobStatusSubmitted,
		ReadSetImportJobStatusInProgress,
		ReadSetImportJobStatusCancelling,
		ReadSetImportJobStatusCancelled,
		ReadSetImportJobStatusFailed,
		ReadSetImportJobStatusCompleted,
		ReadSetImportJobStatusCompletedWithFailures,
	}
}

const (
	// ReadSetPartSourceSource1 is a ReadSetPartSource enum value
	ReadSetPartSourceSource1 = "SOURCE1"

	// ReadSetPartSourceSource2 is a ReadSetPartSource enum value
	ReadSetPartSourceSource2 = "SOURCE2"
)

// ReadSetPartSource_Values returns all elements of the ReadSetPartSource enum
func ReadSetPartSource_Values() []string {
	return []string{
		ReadSetPartSourceSource1,
		ReadSetPartSourceSource2,
	}
}

const (
	// ReadSetStatusArchived is a ReadSetStatus enum value
	ReadSetStatusArchived = "ARCHIVED"

	// ReadSetStatusActivating is a ReadSetStatus enum value
	ReadSetStatusActivating = "ACTIVATING"

	// ReadSetStatusActive is a ReadSetStatus enum value
	ReadSetStatusActive = "ACTIVE"

	// ReadSetStatusDeleting is a ReadSetStatus enum value
	ReadSetStatusDeleting = "DELETING"

	// ReadSetStatusDeleted is a ReadSetStatus enum value
	ReadSetStatusDeleted = "DELETED"

	// ReadSetStatusProcessingUpload is a ReadSetStatus enum value
	ReadSetStatusProcessingUpload = "PROCESSING_UPLOAD"

	// ReadSetStatusUploadFailed is a ReadSetStatus enum value
	ReadSetStatusUploadFailed = "UPLOAD_FAILED"
)

// ReadSetStatus_Values returns all elements of the ReadSetStatus enum
func ReadSetStatus_Values() []string {
	return []string{
		ReadSetStatusArchived,
		ReadSetStatusActivating,
		ReadSetStatusActive,
		ReadSetStatusDeleting,
		ReadSetStatusDeleted,
		ReadSetStatusProcessingUpload,
		ReadSetStatusUploadFailed,
	}
}

const (
	// ReferenceFileSource is a ReferenceFile enum value
	ReferenceFileSource = "SOURCE"

	// ReferenceFileIndex is a ReferenceFile enum value
	ReferenceFileIndex = "INDEX"
)

// ReferenceFile_Values returns all elements of the ReferenceFile enum
func ReferenceFile_Values() []string {
	return []string{
		ReferenceFileSource,
		ReferenceFileIndex,
	}
}

const (
	// ReferenceImportJobItemStatusNotStarted is a ReferenceImportJobItemStatus enum value
	ReferenceImportJobItemStatusNotStarted = "NOT_STARTED"

	// ReferenceImportJobItemStatusInProgress is a ReferenceImportJobItemStatus enum value
	ReferenceImportJobItemStatusInProgress = "IN_PROGRESS"

	// ReferenceImportJobItemStatusFinished is a ReferenceImportJobItemStatus enum value
	ReferenceImportJobItemStatusFinished = "FINISHED"

	// ReferenceImportJobItemStatusFailed is a ReferenceImportJobItemStatus enum value
	ReferenceImportJobItemStatusFailed = "FAILED"
)

// ReferenceImportJobItemStatus_Values returns all elements of the ReferenceImportJobItemStatus enum
func ReferenceImportJobItemStatus_Values() []string {
	return []string{
		ReferenceImportJobItemStatusNotStarted,
		ReferenceImportJobItemStatusInProgress,
		ReferenceImportJobItemStatusFinished,
		ReferenceImportJobItemStatusFailed,
	}
}

const (
	// ReferenceImportJobStatusSubmitted is a ReferenceImportJobStatus enum value
	ReferenceImportJobStatusSubmitted = "SUBMITTED"

	// ReferenceImportJobStatusInProgress is a ReferenceImportJobStatus enum value
	ReferenceImportJobStatusInProgress = "IN_PROGRESS"

	// ReferenceImportJobStatusCancelling is a ReferenceImportJobStatus enum value
	ReferenceImportJobStatusCancelling = "CANCELLING"

	// ReferenceImportJobStatusCancelled is a ReferenceImportJobStatus enum value
	ReferenceImportJobStatusCancelled = "CANCELLED"

	// ReferenceImportJobStatusFailed is a ReferenceImportJobStatus enum value
	ReferenceImportJobStatusFailed = "FAILED"

	// ReferenceImportJobStatusCompleted is a ReferenceImportJobStatus enum value
	ReferenceImportJobStatusCompleted = "COMPLETED"

	// ReferenceImportJobStatusCompletedWithFailures is a ReferenceImportJobStatus enum value
	ReferenceImportJobStatusCompletedWithFailures = "COMPLETED_WITH_FAILURES"
)

// ReferenceImportJobStatus_Values returns all elements of the ReferenceImportJobStatus enum
func ReferenceImportJobStatus_Values() []string {
	return []string{
		ReferenceImportJobStatusSubmitted,
		ReferenceImportJobStatusInProgress,
		ReferenceImportJobStatusCancelling,
		ReferenceImportJobStatusCancelled,
		ReferenceImportJobStatusFailed,
		ReferenceImportJobStatusCompleted,
		ReferenceImportJobStatusCompletedWithFailures,
	}
}

const (
	// ReferenceStatusActive is a ReferenceStatus enum value
	ReferenceStatusActive = "ACTIVE"

	// ReferenceStatusDeleting is a ReferenceStatus enum value
	ReferenceStatusDeleting = "DELETING"

	// ReferenceStatusDeleted is a ReferenceStatus enum value
	ReferenceStatusDeleted = "DELETED"
)

// ReferenceStatus_Values returns all elements of the ReferenceStatus enum
func ReferenceStatus_Values() []string {
	return []string{
		ReferenceStatusActive,
		ReferenceStatusDeleting,
		ReferenceStatusDeleted,
	}
}

const (
	// ResourceOwnerSelf is a ResourceOwner enum value
	ResourceOwnerSelf = "SELF"

	// ResourceOwnerOther is a ResourceOwner enum value
	ResourceOwnerOther = "OTHER"
)

// ResourceOwner_Values returns all elements of the ResourceOwner enum
func ResourceOwner_Values() []string {
	return []string{
		ResourceOwnerSelf,
		ResourceOwnerOther,
	}
}

const (
	// RunExportDefinition is a RunExport enum value
	RunExportDefinition = "DEFINITION"
)

// RunExport_Values returns all elements of the RunExport enum
func RunExport_Values() []string {
	return []string{
		RunExportDefinition,
	}
}

const (
	// RunLogLevelOff is a RunLogLevel enum value
	RunLogLevelOff = "OFF"

	// RunLogLevelFatal is a RunLogLevel enum value
	RunLogLevelFatal = "FATAL"

	// RunLogLevelError is a RunLogLevel enum value
	RunLogLevelError = "ERROR"

	// RunLogLevelAll is a RunLogLevel enum value
	RunLogLevelAll = "ALL"
)

// RunLogLevel_Values returns all elements of the RunLogLevel enum
func RunLogLevel_Values() []string {
	return []string{
		RunLogLevelOff,
		RunLogLevelFatal,
		RunLogLevelError,
		RunLogLevelAll,
	}
}

const (
	// RunRetentionModeRetain is a RunRetentionMode enum value
	RunRetentionModeRetain = "RETAIN"

	// RunRetentionModeRemove is a RunRetentionMode enum value
	RunRetentionModeRemove = "REMOVE"
)

// RunRetentionMode_Values returns all elements of the RunRetentionMode enum
func RunRetentionMode_Values() []string {
	return []string{
		RunRetentionModeRetain,
		RunRetentionModeRemove,
	}
}

const (
	// RunStatusPending is a RunStatus enum value
	RunStatusPending = "PENDING"

	// RunStatusStarting is a RunStatus enum value
	RunStatusStarting = "STARTING"

	// RunStatusRunning is a RunStatus enum value
	RunStatusRunning = "RUNNING"

	// RunStatusStopping is a RunStatus enum value
	RunStatusStopping = "STOPPING"

	// RunStatusCompleted is a RunStatus enum value
	RunStatusCompleted = "COMPLETED"

	// RunStatusDeleted is a RunStatus enum value
	RunStatusDeleted = "DELETED"

	// RunStatusCancelled is a RunStatus enum value
	RunStatusCancelled = "CANCELLED"

	// RunStatusFailed is a RunStatus enum value
	RunStatusFailed = "FAILED"
)

// RunStatus_Values returns all elements of the RunStatus enum
func RunStatus_Values() []string {
	return []string{
		RunStatusPending,
		RunStatusStarting,
		RunStatusRunning,
		RunStatusStopping,
		RunStatusCompleted,
		RunStatusDeleted,
		RunStatusCancelled,
		RunStatusFailed,
	}
}

const (
	// SchemaValueTypeLong is a SchemaValueType enum value
	SchemaValueTypeLong = "LONG"

	// SchemaValueTypeInt is a SchemaValueType enum value
	SchemaValueTypeInt = "INT"

	// SchemaValueTypeString is a SchemaValueType enum value
	SchemaValueTypeString = "STRING"

	// SchemaValueTypeFloat is a SchemaValueType enum value
	SchemaValueTypeFloat = "FLOAT"

	// SchemaValueTypeDouble is a SchemaValueType enum value
	SchemaValueTypeDouble = "DOUBLE"

	// SchemaValueTypeBoolean is a SchemaValueType enum value
	SchemaValueTypeBoolean = "BOOLEAN"
)

// SchemaValueType_Values returns all elements of the SchemaValueType enum
func SchemaValueType_Values() []string {
	return []string{
		SchemaValueTypeLong,
		SchemaValueTypeInt,
		SchemaValueTypeString,
		SchemaValueTypeFloat,
		SchemaValueTypeDouble,
		SchemaValueTypeBoolean,
	}
}

const (
	// ShareStatusPending is a ShareStatus enum value
	ShareStatusPending = "PENDING"

	// ShareStatusActivating is a ShareStatus enum value
	ShareStatusActivating = "ACTIVATING"

	// ShareStatusActive is a ShareStatus enum value
	ShareStatusActive = "ACTIVE"

	// ShareStatusDeleting is a ShareStatus enum value
	ShareStatusDeleting = "DELETING"

	// ShareStatusDeleted is a ShareStatus enum value
	ShareStatusDeleted = "DELETED"

	// ShareStatusFailed is a ShareStatus enum value
	ShareStatusFailed = "FAILED"
)

// ShareStatus_Values returns all elements of the ShareStatus enum
func ShareStatus_Values() []string {
	return []string{
		ShareStatusPending,
		ShareStatusActivating,
		ShareStatusActive,
		ShareStatusDeleting,
		ShareStatusDeleted,
		ShareStatusFailed,
	}
}

const (
	// StoreFormatGff is a StoreFormat enum value
	StoreFormatGff = "GFF"

	// StoreFormatTsv is a StoreFormat enum value
	StoreFormatTsv = "TSV"

	// StoreFormatVcf is a StoreFormat enum value
	StoreFormatVcf = "VCF"
)

// StoreFormat_Values returns all elements of the StoreFormat enum
func StoreFormat_Values() []string {
	return []string{
		StoreFormatGff,
		StoreFormatTsv,
		StoreFormatVcf,
	}
}

const (
	// StoreStatusCreating is a StoreStatus enum value
	StoreStatusCreating = "CREATING"

	// StoreStatusUpdating is a StoreStatus enum value
	StoreStatusUpdating = "UPDATING"

	// StoreStatusDeleting is a StoreStatus enum value
	StoreStatusDeleting = "DELETING"

	// StoreStatusActive is a StoreStatus enum value
	StoreStatusActive = "ACTIVE"

	// StoreStatusFailed is a StoreStatus enum value
	StoreStatusFailed = "FAILED"
)

// StoreStatus_Values returns all elements of the StoreStatus enum
func StoreStatus_Values() []string {
	return []string{
		StoreStatusCreating,
		StoreStatusUpdating,
		StoreStatusDeleting,
		StoreStatusActive,
		StoreStatusFailed,
	}
}

const (
	// TaskStatusPending is a TaskStatus enum value
	TaskStatusPending = "PENDING"

	// TaskStatusStarting is a TaskStatus enum value
	TaskStatusStarting = "STARTING"

	// TaskStatusRunning is a TaskStatus enum value
	TaskStatusRunning = "RUNNING"

	// TaskStatusStopping is a TaskStatus enum value
	TaskStatusStopping = "STOPPING"

	// TaskStatusCompleted is a TaskStatus enum value
	TaskStatusCompleted = "COMPLETED"

	// TaskStatusCancelled is a TaskStatus enum value
	TaskStatusCancelled = "CANCELLED"

	// TaskStatusFailed is a TaskStatus enum value
	TaskStatusFailed = "FAILED"
)

// TaskStatus_Values returns all elements of the TaskStatus enum
func TaskStatus_Values() []string {
	return []string{
		TaskStatusPending,
		TaskStatusStarting,
		TaskStatusRunning,
		TaskStatusStopping,
		TaskStatusCompleted,
		TaskStatusCancelled,
		TaskStatusFailed,
	}
}

const (
	// VersionStatusCreating is a VersionStatus enum value
	VersionStatusCreating = "CREATING"

	// VersionStatusUpdating is a VersionStatus enum value
	VersionStatusUpdating = "UPDATING"

	// VersionStatusDeleting is a VersionStatus enum value
	VersionStatusDeleting = "DELETING"

	// VersionStatusActive is a VersionStatus enum value
	VersionStatusActive = "ACTIVE"

	// VersionStatusFailed is a VersionStatus enum value
	VersionStatusFailed = "FAILED"
)

// VersionStatus_Values returns all elements of the VersionStatus enum
func VersionStatus_Values() []string {
	return []string{
		VersionStatusCreating,
		VersionStatusUpdating,
		VersionStatusDeleting,
		VersionStatusActive,
		VersionStatusFailed,
	}
}

const (
	// WorkflowEngineWdl is a WorkflowEngine enum value
	WorkflowEngineWdl = "WDL"

	// WorkflowEngineNextflow is a WorkflowEngine enum value
	WorkflowEngineNextflow = "NEXTFLOW"

	// WorkflowEngineCwl is a WorkflowEngine enum value
	WorkflowEngineCwl = "CWL"
)

// WorkflowEngine_Values returns all elements of the WorkflowEngine enum
func WorkflowEngine_Values() []string {
	return []string{
		WorkflowEngineWdl,
		WorkflowEngineNextflow,
		WorkflowEngineCwl,
	}
}

const (
	// WorkflowExportDefinition is a WorkflowExport enum value
	WorkflowExportDefinition = "DEFINITION"
)

// WorkflowExport_Values returns all elements of the WorkflowExport enum
func WorkflowExport_Values() []string {
	return []string{
		WorkflowExportDefinition,
	}
}

const (
	// WorkflowStatusCreating is a WorkflowStatus enum value
	WorkflowStatusCreating = "CREATING"

	// WorkflowStatusActive is a WorkflowStatus enum value
	WorkflowStatusActive = "ACTIVE"

	// WorkflowStatusUpdating is a WorkflowStatus enum value
	WorkflowStatusUpdating = "UPDATING"

	// WorkflowStatusDeleted is a WorkflowStatus enum value
	WorkflowStatusDeleted = "DELETED"

	// WorkflowStatusFailed is a WorkflowStatus enum value
	WorkflowStatusFailed = "FAILED"

	// WorkflowStatusInactive is a WorkflowStatus enum value
	WorkflowStatusInactive = "INACTIVE"
)

// WorkflowStatus_Values returns all elements of the WorkflowStatus enum
func WorkflowStatus_Values() []string {
	return []string{
		WorkflowStatusCreating,
		WorkflowStatusActive,
		WorkflowStatusUpdating,
		WorkflowStatusDeleted,
		WorkflowStatusFailed,
		WorkflowStatusInactive,
	}
}

const (
	// WorkflowTypePrivate is a WorkflowType enum value
	WorkflowTypePrivate = "PRIVATE"

	// WorkflowTypeReady2run is a WorkflowType enum value
	WorkflowTypeReady2run = "READY2RUN"
)

// WorkflowType_Values returns all elements of the WorkflowType enum
func WorkflowType_Values() []string {
	return []string{
		WorkflowTypePrivate,
		WorkflowTypeReady2run,
	}
}
