//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armreservations

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// CalculateRefundClient contains the methods for the CalculateRefund group.
// Don't use this type directly, use NewCalculateRefundClient() instead.
type CalculateRefundClient struct {
	host string
	pl   runtime.Pipeline
}

// NewCalculateRefundClient creates a new instance of CalculateRefundClient with the specified values.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewCalculateRefundClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*CalculateRefundClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &CalculateRefundClient{
		host: ep,
		pl:   pl,
	}
	return client, nil
}

// Post - Calculate price for returning Reservations if there are no policy errors.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// reservationOrderID - Order Id of the reservation
// body - Information needed for calculating refund of a reservation.
// options - CalculateRefundClientPostOptions contains the optional parameters for the CalculateRefundClient.Post method.
func (client *CalculateRefundClient) Post(ctx context.Context, reservationOrderID string, body CalculateRefundRequest, options *CalculateRefundClientPostOptions) (CalculateRefundClientPostResponse, error) {
	req, err := client.postCreateRequest(ctx, reservationOrderID, body, options)
	if err != nil {
		return CalculateRefundClientPostResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CalculateRefundClientPostResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return CalculateRefundClientPostResponse{}, runtime.NewResponseError(resp)
	}
	return client.postHandleResponse(resp)
}

// postCreateRequest creates the Post request.
func (client *CalculateRefundClient) postCreateRequest(ctx context.Context, reservationOrderID string, body CalculateRefundRequest, options *CalculateRefundClientPostOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/calculateRefund"
	if reservationOrderID == "" {
		return nil, errors.New("parameter reservationOrderID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{reservationOrderId}", url.PathEscape(reservationOrderID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, body)
}

// postHandleResponse handles the Post response.
func (client *CalculateRefundClient) postHandleResponse(resp *http.Response) (CalculateRefundClientPostResponse, error) {
	result := CalculateRefundClientPostResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CalculateRefundResponse); err != nil {
		return CalculateRefundClientPostResponse{}, err
	}
	return result, nil
}
