//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmanagementgroups

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type CreateManagementGroupChildInfo.
func (c CreateManagementGroupChildInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "children", c.Children)
	populate(objectMap, "displayName", c.DisplayName)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CreateManagementGroupDetails.
func (c CreateManagementGroupDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "parent", c.Parent)
	populate(objectMap, "updatedBy", c.UpdatedBy)
	populateTimeRFC3339(objectMap, "updatedTime", c.UpdatedTime)
	populate(objectMap, "version", c.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateManagementGroupDetails.
func (c *CreateManagementGroupDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parent":
			err = unpopulate(val, "Parent", &c.Parent)
			delete(rawMsg, key)
		case "updatedBy":
			err = unpopulate(val, "UpdatedBy", &c.UpdatedBy)
			delete(rawMsg, key)
		case "updatedTime":
			err = unpopulateTimeRFC3339(val, "UpdatedTime", &c.UpdatedTime)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &c.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateManagementGroupProperties.
func (c CreateManagementGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "children", c.Children)
	populate(objectMap, "details", c.Details)
	populate(objectMap, "displayName", c.DisplayName)
	populate(objectMap, "tenantId", c.TenantID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CreateOrUpdateSettingsRequest.
func (c CreateOrUpdateSettingsRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagementGroupDetails.
func (m *ManagementGroupDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "managementGroupAncestors":
			err = unpopulate(val, "ManagementGroupAncestors", &m.ManagementGroupAncestors)
			delete(rawMsg, key)
		case "managementGroupAncestorsChain":
			err = unpopulate(val, "ManagementGroupAncestorsChain", &m.ManagementGroupAncestorsChain)
			delete(rawMsg, key)
		case "parent":
			err = unpopulate(val, "Parent", &m.Parent)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &m.Path)
			delete(rawMsg, key)
		case "updatedBy":
			err = unpopulate(val, "UpdatedBy", &m.UpdatedBy)
			delete(rawMsg, key)
		case "updatedTime":
			err = unpopulateTimeRFC3339(val, "UpdatedTime", &m.UpdatedTime)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &m.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PatchManagementGroupRequest.
func (p PatchManagementGroupRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "parentGroupId", p.ParentGroupID)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
