{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetChannels: String;
    procedure SetChannels(const Value: String);
    function GetDescription: String;
    procedure SetDescription(const Value: String);
    function GetEnabled: Boolean;
    procedure SetEnabled(const Value: Boolean);
    function GetEndFrame: Integer;
    procedure SetEndFrame(const Value: Integer);
    function GetFrameDuration: TFloatTime;
    procedure SetFrameDuration(const Value: TFloatTime);
    function GetFrameIncrement: Integer;
    procedure SetFrameIncrement(const Value: Integer);
    function GetFrameIndex: Integer;
    procedure SetFrameIndex(const Value: Integer);
    function GetJoints: String;
    procedure SetJoints(const Value: String);
    function GetLoa: Integer;
    procedure SetLoa(const Value: Integer);
    function GetLoop: Boolean;
    procedure SetLoop(const Value: Boolean);
    function GetNameField: String;
    procedure SetNameField(const Value: String);
    function GetStartFrame: Integer;
    procedure SetStartFrame(const Value: Integer);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FEventNext: TSFBoolEvent;
    {  }
    public property EventNext: TSFBoolEvent read FEventNext;

    strict private FEventPrevious: TSFBoolEvent;
    {  }
    public property EventPrevious: TSFBoolEvent read FEventPrevious;

    strict private FFdChannels: TSFString;
    { Internal wrapper for property @code(Channels). This wrapper API may change, we advise to access simpler @code(Channels) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdChannels: TSFString read FFdChannels;
    {  }
    property Channels: String read GetChannels write SetChannels;

    strict private FFdChannelsEnabled: TMFBool;
    { Internal wrapper for property @code(ChannelsEnabled). This wrapper API may change, we advise to access simpler @code(ChannelsEnabled) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdChannelsEnabled: TMFBool read FFdChannelsEnabled;
    {  }
    procedure SetChannelsEnabled(const Value: array of boolean); overload;
    {  }
    procedure SetChannelsEnabled(const Value: TBooleanList); overload;

    strict private FFdDescription: TSFString;
    { Internal wrapper for property @code(Description). This wrapper API may change, we advise to access simpler @code(Description) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDescription: TSFString read FFdDescription;
    {  }
    property Description: String read GetDescription write SetDescription;

    strict private FFdEnabled: TSFBool;
    { Internal wrapper for property @code(Enabled). This wrapper API may change, we advise to access simpler @code(Enabled) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEnabled: TSFBool read FFdEnabled;
    {  }
    property Enabled: Boolean read GetEnabled write SetEnabled;

    strict private FFdEndFrame: TSFInt32;
    { Internal wrapper for property @code(EndFrame). This wrapper API may change, we advise to access simpler @code(EndFrame) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEndFrame: TSFInt32 read FFdEndFrame;
    {  }
    property EndFrame: Integer read GetEndFrame write SetEndFrame;

    strict private FFdFrameDuration: TSFTime;
    { Internal wrapper for property @code(FrameDuration). This wrapper API may change, we advise to access simpler @code(FrameDuration) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFrameDuration: TSFTime read FFdFrameDuration;
    {  }
    property FrameDuration: TFloatTime read GetFrameDuration write SetFrameDuration;

    strict private FFdFrameIncrement: TSFInt32;
    { Internal wrapper for property @code(FrameIncrement). This wrapper API may change, we advise to access simpler @code(FrameIncrement) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFrameIncrement: TSFInt32 read FFdFrameIncrement;
    {  }
    property FrameIncrement: Integer read GetFrameIncrement write SetFrameIncrement;

    strict private FFdFrameIndex: TSFInt32;
    { Internal wrapper for property @code(FrameIndex). This wrapper API may change, we advise to access simpler @code(FrameIndex) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFrameIndex: TSFInt32 read FFdFrameIndex;
    {  }
    property FrameIndex: Integer read GetFrameIndex write SetFrameIndex;

    strict private FFdJoints: TSFString;
    { Internal wrapper for property @code(Joints). This wrapper API may change, we advise to access simpler @code(Joints) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdJoints: TSFString read FFdJoints;
    {  }
    property Joints: String read GetJoints write SetJoints;

    strict private FFdLoa: TSFInt32;
    { Internal wrapper for property @code(Loa). This wrapper API may change, we advise to access simpler @code(Loa) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLoa: TSFInt32 read FFdLoa;
    {  }
    property Loa: Integer read GetLoa write SetLoa;

    strict private FFdLoop: TSFBool;
    { Internal wrapper for property @code(Loop). This wrapper API may change, we advise to access simpler @code(Loop) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLoop: TSFBool read FFdLoop;
    {  }
    property Loop: Boolean read GetLoop write SetLoop;

    strict private FFdName: TSFString;
    { Internal wrapper for property @code(NameField). This wrapper API may change, we advise to access simpler @code(NameField) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdName: TSFString read FFdName;
    {  }
    property NameField: String read GetNameField write SetNameField;

    strict private FFdStartFrame: TSFInt32;
    { Internal wrapper for property @code(StartFrame). This wrapper API may change, we advise to access simpler @code(StartFrame) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdStartFrame: TSFInt32 read FFdStartFrame;
    {  }
    property StartFrame: Integer read GetStartFrame write SetStartFrame;

    strict private FFdValues: TMFFloat;
    { Internal wrapper for property @code(Values). This wrapper API may change, we advise to access simpler @code(Values) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdValues: TMFFloat read FFdValues;
    {  }
    procedure SetValues(const Value: array of Single); overload;
    {  }
    procedure SetValues(const Value: TSingleList); overload;

    strict private FEventCycleTime: TSFTimeEvent;
    {  }
    public property EventCycleTime: TSFTimeEvent read FEventCycleTime;

    strict private FEventElapsedTime: TSFTimeEvent;
    {  }
    public property EventElapsedTime: TSFTimeEvent read FEventElapsedTime;

    strict private FEventFrameCount: TSFInt32Event;
    {  }
    public property EventFrameCount: TSFInt32Event read FEventFrameCount;

{$endif read_interface}

{$ifdef read_implementation}

{ THAnimMotionNode ----------------------------------------------- }

function THAnimMotionNode.GetChannels: String;
begin
  Result := FdChannels.Value;
end;

procedure THAnimMotionNode.SetChannels(const Value: String);
begin
  FdChannels.Send(Value);
end;

procedure THAnimMotionNode.SetChannelsEnabled(const Value: array of boolean);
begin
  FdChannelsEnabled.Send(Value);
end;

procedure THAnimMotionNode.SetChannelsEnabled(const Value: TBooleanList);
begin
  FdChannelsEnabled.Send(Value);
end;

function THAnimMotionNode.GetDescription: String;
begin
  Result := FdDescription.Value;
end;

procedure THAnimMotionNode.SetDescription(const Value: String);
begin
  FdDescription.Send(Value);
end;

function THAnimMotionNode.GetEnabled: Boolean;
begin
  Result := FdEnabled.Value;
end;

procedure THAnimMotionNode.SetEnabled(const Value: Boolean);
begin
  FdEnabled.Send(Value);
end;

function THAnimMotionNode.GetEndFrame: Integer;
begin
  Result := FdEndFrame.Value;
end;

procedure THAnimMotionNode.SetEndFrame(const Value: Integer);
begin
  FdEndFrame.Send(Value);
end;

function THAnimMotionNode.GetFrameDuration: TFloatTime;
begin
  Result := FdFrameDuration.Value;
end;

procedure THAnimMotionNode.SetFrameDuration(const Value: TFloatTime);
begin
  FdFrameDuration.Send(Value);
end;

function THAnimMotionNode.GetFrameIncrement: Integer;
begin
  Result := FdFrameIncrement.Value;
end;

procedure THAnimMotionNode.SetFrameIncrement(const Value: Integer);
begin
  FdFrameIncrement.Send(Value);
end;

function THAnimMotionNode.GetFrameIndex: Integer;
begin
  Result := FdFrameIndex.Value;
end;

procedure THAnimMotionNode.SetFrameIndex(const Value: Integer);
begin
  FdFrameIndex.Send(Value);
end;

function THAnimMotionNode.GetJoints: String;
begin
  Result := FdJoints.Value;
end;

procedure THAnimMotionNode.SetJoints(const Value: String);
begin
  FdJoints.Send(Value);
end;

function THAnimMotionNode.GetLoa: Integer;
begin
  Result := FdLoa.Value;
end;

procedure THAnimMotionNode.SetLoa(const Value: Integer);
begin
  FdLoa.Send(Value);
end;

function THAnimMotionNode.GetLoop: Boolean;
begin
  Result := FdLoop.Value;
end;

procedure THAnimMotionNode.SetLoop(const Value: Boolean);
begin
  FdLoop.Send(Value);
end;

function THAnimMotionNode.GetNameField: String;
begin
  Result := FdName.Value;
end;

procedure THAnimMotionNode.SetNameField(const Value: String);
begin
  FdName.Send(Value);
end;

function THAnimMotionNode.GetStartFrame: Integer;
begin
  Result := FdStartFrame.Value;
end;

procedure THAnimMotionNode.SetStartFrame(const Value: Integer);
begin
  FdStartFrame.Send(Value);
end;

procedure THAnimMotionNode.SetValues(const Value: array of Single);
begin
  FdValues.Send(Value);
end;

procedure THAnimMotionNode.SetValues(const Value: TSingleList);
begin
  FdValues.Send(Value);
end;

class function THAnimMotionNode.ClassX3DType: String;
begin
  Result := 'HAnimMotion';
end;

procedure THAnimMotionNode.CreateNode;
begin
  inherited;

  FEventNext := TSFBoolEvent.Create(Self, 'next', true);
  AddEvent(FEventNext);

  FEventPrevious := TSFBoolEvent.Create(Self, 'previous', true);
  AddEvent(FEventPrevious);

  FFdChannels := TSFString.Create(Self, True, 'channels', '');
   FdChannels.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdChannels);

  FFdChannelsEnabled := TMFBool.Create(Self, True, 'channelsEnabled', []);
   FdChannelsEnabled.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdChannelsEnabled);

  FFdDescription := TSFString.Create(Self, True, 'description', '');
   FdDescription.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDescription);

  FFdEnabled := TSFBool.Create(Self, True, 'enabled', true);
   FdEnabled.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEnabled);

  FFdEndFrame := TSFInt32.Create(Self, True, 'endFrame', 0);
   FdEndFrame.ChangeAlways := chVisibleNonGeometry;
   FdEndFrame.MustBeNonnegative := true;
  AddField(FFdEndFrame);

  FFdFrameDuration := TSFTime.Create(Self, True, 'frameDuration', 0.1);
   FdFrameDuration.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFrameDuration);

  FFdFrameIncrement := TSFInt32.Create(Self, True, 'frameIncrement', 1);
   FdFrameIncrement.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFrameIncrement);

  FFdFrameIndex := TSFInt32.Create(Self, True, 'frameIndex', 0);
   FdFrameIndex.ChangeAlways := chVisibleNonGeometry;
   FdFrameIndex.MustBeNonnegative := true;
  AddField(FFdFrameIndex);

  FFdJoints := TSFString.Create(Self, True, 'joints', '');
   FdJoints.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdJoints);

  FFdLoa := TSFInt32.Create(Self, True, 'loa', -1);
   FdLoa.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLoa);

  FFdLoop := TSFBool.Create(Self, True, 'loop', false);
   FdLoop.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLoop);

  FFdName := TSFString.Create(Self, True, 'name', '');
   FdName.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdName);

  FFdStartFrame := TSFInt32.Create(Self, True, 'startFrame', 0);
   FdStartFrame.ChangeAlways := chVisibleNonGeometry;
   FdStartFrame.MustBeNonnegative := true;
  AddField(FFdStartFrame);

  FFdValues := TMFFloat.Create(Self, True, 'values', []);
   FdValues.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdValues);

  FEventCycleTime := TSFTimeEvent.Create(Self, 'cycleTime', false);
  AddEvent(FEventCycleTime);

  FEventElapsedTime := TSFTimeEvent.Create(Self, 'elapsedTime', false);
  AddEvent(FEventElapsedTime);

  FEventFrameCount := TSFInt32Event.Create(Self, 'frameCount', false);
  AddEvent(FEventFrameCount);
end;

{$endif read_implementation}
