// Copyright 2025 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0
import React from 'react';
import { BasePath, BaseSVG, BaseSVGProps } from './utils';

export const BHELogoFull: React.FC<BaseSVGProps> = (props) => {
    return (
        <BaseSVG name='bhe-logo-full' viewBox='0 0 1387 250' fill='none' xmlns='http://www.w3.org/2000/svg' {...props}>
            <BasePath d='M321.424 214.794C321.424 214.794 321.385 214.794 321.363 214.794L315.15 197.819C316.16 196.969 316.825 195.721 316.825 194.291C316.825 192.612 315.918 191.156 314.575 190.345L315.335 186.545C317.615 186.273 319.377 184.347 319.377 181.989C319.377 179.437 317.322 177.377 314.782 177.377C314.502 177.377 314.217 177.416 313.945 177.464L294.945 149.011C295.502 148.251 295.839 147.31 295.839 146.295C295.839 143.743 293.783 141.683 291.244 141.683C290.571 141.683 289.931 141.839 289.357 142.102L271.467 123.417C271.778 122.791 271.972 122.096 271.972 121.353C271.972 118.801 269.917 116.742 267.378 116.742C266.618 116.742 265.909 116.944 265.275 117.277L250.485 103.394C250.727 102.828 250.874 102.202 250.874 101.546C250.874 98.9939 248.818 96.9341 246.279 96.9341C245.519 96.9341 244.811 97.1414 244.176 97.4696L232.431 86.4496C232.673 85.8839 232.819 85.2578 232.819 84.6014C232.819 82.0494 230.764 79.9896 228.225 79.9896C226.882 79.9896 225.682 80.5769 224.844 81.4923L185.842 64.9322C185.842 62.3931 183.778 60.3377 181.248 60.3377C179.611 60.3377 178.182 61.2056 177.361 62.4968L141.361 56.9868C140.972 54.8363 139.102 53.2041 136.853 53.2041C134.845 53.2041 133.161 54.4952 132.53 56.2916H110.883C110.248 54.4952 108.564 53.2041 106.569 53.2041C104.203 53.2041 102.286 55.0004 102.022 57.2977L82.6424 61.8231C81.8263 60.545 80.4013 59.6943 78.7776 59.6943C76.6358 59.6943 74.8438 61.1711 74.3386 63.1618L60.4729 64.4227C59.7432 62.8379 58.1541 61.7368 56.3059 61.7368C54.9414 61.7368 53.7366 62.3413 52.8859 63.2913L36.8483 56.7147C36.8569 56.5679 36.8958 56.4211 36.8958 56.2656C36.8958 53.7136 34.8403 51.6539 32.3013 51.6539C31.5024 51.6539 30.764 51.8784 30.1119 52.2325L18.0988 40.1805L12.9948 28.7287C14.0182 27.8781 14.6788 26.6171 14.6788 25.1835C14.6788 22.9769 13.1286 21.1374 11.0645 20.6797L10.5118 1.045L7.90364 0L3.48184 4.43475L3.05435 5.24657L0.161177 21.3015V21.8283L2.33321 35.0376C0.977309 35.8407 0.0532227 37.3089 0.0532227 38.9973C0.0532227 41.5494 2.10867 43.6091 4.64775 43.6091C4.88956 43.6091 5.12274 43.5703 5.36888 43.54L10.2398 51.7791C9.57909 52.5823 9.16023 53.597 9.16023 54.7111C9.16023 57.2631 11.2157 59.3229 13.7548 59.3229C14.6486 59.3229 15.4777 59.0595 16.1902 58.6104L38.5496 76.4056C38.3726 76.8849 38.269 77.4031 38.269 77.9385C38.269 80.4905 40.3244 82.5503 42.8635 82.5503C44.3619 82.5503 45.6876 81.8162 46.5253 80.7021L59.9807 85.0117C60.0411 86.7216 61.0214 88.1855 62.455 88.9412L59.5618 109.811C57.4675 110.243 55.8914 112.099 55.8914 114.323C55.8914 116.547 57.3898 118.3 59.3977 118.788L60.5679 130.408C59.0091 131.151 57.9295 132.723 57.9295 134.563C57.9295 135.815 58.4348 136.955 59.2423 137.788L52.1518 152.289C52.005 152.28 51.8582 152.241 51.7157 152.241C49.1723 152.241 47.1212 154.305 47.1212 156.853C47.1212 157.548 47.2853 158.192 47.5487 158.779L34.2703 172.122C33.6744 171.837 33.0138 171.664 32.3013 171.664C29.7579 171.664 27.7067 173.724 27.7067 176.276C27.7067 177.8 28.4451 179.13 29.5765 179.968L23.8981 198.692C21.4627 198.8 19.5152 200.803 19.5152 203.282C19.5152 205.765 21.5706 207.894 24.1097 207.894C24.3731 207.894 24.6365 207.855 24.887 207.816L36.2221 228.064C35.4881 228.884 35.0303 229.959 35.0303 231.143C35.0303 233.695 37.0858 235.754 39.6249 235.754C41.6026 235.754 43.278 234.493 43.9171 232.736L69.0488 233.068L70.5299 231.056L67.9995 223.279C69.0099 222.429 69.6663 221.181 69.6663 219.751C69.6663 217.199 67.6109 215.139 65.0718 215.139C64.0397 215.139 63.0941 215.489 62.3254 216.077L49.6948 209.491C49.725 209.284 49.7553 209.081 49.7553 208.865C49.7553 207.172 48.8398 205.709 47.4839 204.91L50.4332 189.705C52.6441 189.373 54.3455 187.477 54.3455 185.163C54.3455 184.584 54.2289 184.049 54.0432 183.539L69.3899 170.554C70.0722 170.956 70.8495 171.198 71.6958 171.198C74.2392 171.198 76.2904 169.138 76.2904 166.586C76.2904 165.727 76.0356 164.924 75.6297 164.241L85.9242 151.939C86.4208 152.125 86.9562 152.241 87.5219 152.241C87.7378 152.241 87.9321 152.202 88.1351 152.181L96.1798 167.795C95.4112 168.616 94.9232 169.721 94.9232 170.943C94.9232 172.359 95.5753 173.612 96.5771 174.462L91.4169 188.376C91.4169 188.376 91.3694 188.376 91.3478 188.376C88.8087 188.376 86.7533 190.44 86.7533 192.987C86.7533 195.535 88.8001 197.577 91.3219 197.599L100.843 225.162C100.027 225.991 99.5178 227.135 99.5178 228.405C99.5178 230.957 101.573 233.017 104.112 233.017C104.717 233.017 105.291 232.887 105.818 232.684L117.045 243.493C116.782 244.071 116.626 244.715 116.626 245.388C116.626 247.94 118.682 250 121.221 250C123.216 250 124.9 248.709 125.535 246.921H143.179L144.569 244.753L141.318 237.495C142.147 236.666 142.661 235.513 142.661 234.239C142.661 231.687 140.605 229.627 138.066 229.627C136.896 229.627 135.838 230.076 135.03 230.797L127.296 227.045C127.314 226.881 127.344 226.721 127.344 226.548C127.344 224.048 125.358 222.014 122.875 221.945L114.295 195.345C115.387 194.503 116.104 193.195 116.104 191.7C116.104 190.487 115.629 189.395 114.869 188.574L124.909 169.345C125.124 169.376 125.327 169.414 125.552 169.414C128.095 169.414 130.146 167.35 130.146 164.803C130.146 163.062 129.184 161.577 127.771 160.787L130.945 141.666C131.891 141.502 132.746 141.048 133.398 140.396L159.933 153.118C159.925 153.256 159.894 153.39 159.894 153.537C159.894 154.914 160.507 156.127 161.453 156.978L152.942 179.929C152.942 179.929 152.895 179.929 152.873 179.929C150.33 179.929 148.278 181.993 148.278 184.541C148.278 186.337 149.31 187.875 150.8 188.635L147.294 215.653C145.23 216.102 143.68 217.951 143.68 220.157C143.68 222.709 145.735 224.769 148.274 224.769C148.585 224.769 148.896 224.739 149.19 224.67L159.618 242.884C159.152 243.605 158.867 244.468 158.867 245.384C158.867 247.936 160.922 249.996 163.461 249.996C165.456 249.996 167.14 248.705 167.775 246.917H194.211L195.545 244.62L190.169 235.18C190.86 234.368 191.296 233.332 191.296 232.192C191.296 229.64 189.241 227.58 186.701 227.58C185.436 227.58 184.288 228.098 183.45 228.927L172.028 223.443C172.05 223.288 172.076 223.132 172.076 222.964C172.076 221.077 170.944 219.458 169.321 218.741L170.996 195.721C173.138 195.332 174.753 193.454 174.753 191.195C174.753 190.129 174.382 189.174 173.782 188.393L185.406 172.29C185.816 172.407 186.244 172.498 186.693 172.498C188.99 172.498 190.881 170.796 191.223 168.59L194.854 167.894C195.567 169.108 196.802 169.954 198.261 170.131L200.032 178.025C198.689 178.828 197.782 180.292 197.782 181.972C197.782 184.524 199.837 186.583 202.376 186.583C202.471 186.583 202.562 186.562 202.648 186.553L214.48 218.387C213.457 219.237 212.787 220.498 212.787 221.932C212.787 224.484 214.843 226.544 217.382 226.544C218.056 226.544 218.686 226.388 219.26 226.133L231.226 239.187C231.049 239.675 230.932 240.202 230.932 240.759C230.932 243.311 232.988 245.371 235.527 245.371C237.379 245.371 238.964 244.265 239.694 242.685H264.942L266.199 240.263L257.135 227.317C257.532 226.634 257.778 225.853 257.778 225.011C257.778 222.459 255.723 220.399 253.184 220.399C251.888 220.399 250.718 220.947 249.885 221.815L239.871 217.635C239.88 217.497 239.91 217.372 239.91 217.247C239.91 214.842 238.079 212.898 235.743 212.674L227.836 180.154C229.006 179.381 229.784 178.09 229.892 176.609L237.906 174.35C238.744 175.525 240.096 176.293 241.646 176.293C242.911 176.293 244.051 175.775 244.889 174.955L253.262 178.94C253.253 179.066 253.223 179.195 253.223 179.32C253.223 180.689 253.827 181.898 254.76 182.74L249.393 195.57C249.306 195.57 249.228 195.539 249.138 195.539C246.594 195.539 244.543 197.603 244.543 200.151C244.543 202.699 246.599 204.763 249.138 204.763C249.665 204.763 250.17 204.655 250.636 204.491L264.89 222.334C264.45 223.037 264.191 223.858 264.191 224.756C264.191 227.308 266.246 229.368 268.785 229.368C271.324 229.368 273.38 227.308 273.38 224.756C273.38 223.603 272.944 222.567 272.249 221.755L278.19 211.288C278.424 211.348 278.657 211.365 278.903 211.387L281.865 223.698C280.609 224.519 279.771 225.935 279.771 227.559C279.771 230.111 281.826 232.17 284.365 232.17C285.941 232.17 287.345 231.367 288.174 230.145L307.269 235.158C307.796 237.123 309.566 238.57 311.691 238.57C314.234 238.57 316.285 236.51 316.285 233.958C316.285 233.038 316.013 232.201 315.555 231.475L320.374 223.845C320.707 223.923 321.048 223.97 321.398 223.97C323.941 223.97 325.992 221.91 325.992 219.358C325.992 216.806 323.937 214.747 321.398 214.747L321.424 214.794ZM268.833 220.179C268.833 220.179 268.794 220.179 268.764 220.179L259.873 183.47C261.393 182.719 262.442 181.164 262.442 179.346C262.442 178.478 262.187 177.675 261.768 176.98L288.8 150.186C288.986 150.302 289.189 150.419 289.396 150.51L283.389 180.594C280.928 180.672 278.95 182.693 278.95 185.184C278.95 187.05 280.06 188.643 281.636 189.369L279.067 202.245C276.632 202.362 274.693 204.366 274.693 206.836C274.693 207.889 275.064 208.848 275.647 209.63L269.619 220.239C269.355 220.192 269.083 220.161 268.811 220.161L268.833 220.179ZM237.116 171.427L229.123 173.676C228.294 172.493 226.921 171.712 225.375 171.712C223.825 171.712 222.434 172.493 221.605 173.694L203.404 166.327C203.443 166.094 203.473 165.848 203.473 165.606C203.473 164.725 203.218 163.926 202.791 163.222L219.55 146.925C220.271 147.396 221.126 147.677 222.054 147.677C222.698 147.677 223.311 147.539 223.864 147.305L238.312 168.598C237.621 169.35 237.181 170.343 237.116 171.427ZM222.033 221.768L231.343 219.471C231.956 220.593 233.018 221.444 234.301 221.746L234.193 236.441C233.873 236.549 233.571 236.674 233.277 236.851L221.532 224.039C221.843 223.413 222.037 222.718 222.037 221.975C222.037 221.906 222.02 221.837 222.02 221.768H222.033ZM206.414 184.308C206.803 183.626 207.044 182.853 207.044 182.011C207.044 179.696 205.33 177.787 203.11 177.468L201.318 169.505C201.832 169.173 202.29 168.754 202.644 168.244L220.845 175.611C220.806 175.844 220.776 176.09 220.776 176.332C220.776 178.716 222.585 180.659 224.904 180.896L232.711 213.024L206.414 184.308ZM182.37 233.487L166.743 242.124C165.914 241.312 164.787 240.815 163.539 240.815C163.051 240.815 162.593 240.915 162.157 241.048L151.875 223.098C152.208 222.688 152.48 222.23 152.657 221.72L162.999 223.331C163.176 225.723 165.132 227.61 167.568 227.61C168.833 227.61 169.982 227.092 170.819 226.263L182.241 231.747C182.219 231.903 182.193 232.058 182.193 232.226C182.193 232.667 182.271 233.086 182.388 233.487H182.37ZM156.703 187.188L165.681 190.794C165.672 190.94 165.633 191.087 165.633 191.234C165.633 192.279 165.992 193.238 166.579 194.011L150.463 215.468L153.883 189.075C155.054 188.833 156.051 188.138 156.703 187.188ZM163.284 221.301L152.873 219.678C152.765 218.711 152.368 217.83 151.763 217.139L168.017 195.505L166.341 218.564C164.951 218.944 163.82 219.963 163.293 221.289L163.284 221.301ZM170.228 186.622C170.228 186.622 170.21 186.622 170.197 186.622L166.069 157.902C167.853 157.267 169.135 155.575 169.135 153.575C169.135 152.707 168.88 151.913 168.474 151.222L176.731 143.592C177.327 144.024 178.026 144.313 178.786 144.421L184.521 163.926C183.117 164.716 182.163 166.202 182.163 167.933C182.163 168.909 182.465 169.807 182.979 170.55L171.277 186.769C170.936 186.691 170.586 186.631 170.223 186.631L170.228 186.622ZM99.561 166.387C99.345 166.387 99.1507 166.426 98.9478 166.448L90.903 150.833C91.011 150.717 91.1189 150.587 91.2139 150.462L121.1 163.948C121.039 164.241 121.014 164.544 121.014 164.854C121.014 164.863 121.014 164.876 121.014 164.885L103.672 168.978C102.92 167.45 101.375 166.387 99.561 166.387ZM71.7304 162.026C71.644 162.026 71.5663 162.048 71.4756 162.056L64.7566 138.635C66.1686 137.844 67.1316 136.359 67.1316 134.619C67.1316 132.451 65.6331 130.642 63.6252 130.154L62.455 118.534C62.455 118.534 62.5025 118.503 62.5241 118.495L83.9465 144.857C83.3419 145.639 82.9619 146.606 82.9619 147.681C82.9619 148.532 83.2038 149.322 83.614 150.017L73.3324 162.337C72.8358 162.151 72.3004 162.035 71.7347 162.035L71.7304 162.026ZM18.1161 56.1836L27.806 57.0818C28.186 59.2495 30.0558 60.8947 32.3228 60.8947C32.6251 60.8947 32.9058 60.8645 33.1908 60.8084L39.4046 73.1885L18.0988 56.2225C18.0988 56.2225 18.1075 56.1836 18.1204 56.175L18.1161 56.1836ZM46.9398 75.8744L53.6114 70.0795C54.3714 70.6365 55.3041 70.9776 56.3189 70.9776C56.6211 70.9776 56.9234 70.9474 57.2127 70.8913L61.8202 81.229C61.4791 81.4837 61.1854 81.786 60.9264 82.1185L47.4494 77.809C47.4191 77.1137 47.2335 76.4617 46.9312 75.8744H46.9398ZM226.433 88.8591C226.977 89.0923 227.581 89.2219 228.216 89.2219C228.976 89.2219 229.684 89.0146 230.319 88.6864L242.065 99.7064C241.823 100.272 241.676 100.898 241.676 101.555C241.676 103.558 242.95 105.247 244.733 105.886L242.708 123.094C241.248 123.249 240.001 124.082 239.271 125.291L210.222 115.757C210.222 115.649 210.253 115.55 210.253 115.442C210.253 114.418 209.912 113.477 209.346 112.717L226.433 88.8591ZM201.698 113.14L172.689 104.806C172.689 104.72 172.719 104.642 172.719 104.56C172.719 102.889 171.821 101.434 170.491 100.63L180.734 69.5181C180.911 69.5397 181.075 69.5656 181.261 69.5656C181.671 69.5656 182.059 69.4965 182.431 69.4015L203.024 111.672C202.48 112.056 202.031 112.566 201.698 113.14ZM141.309 84.3467C141.533 83.8069 141.659 83.211 141.659 82.5978C141.659 82.343 141.62 82.1098 141.581 81.8637L177.348 67.3547C177.72 67.9592 178.216 68.4688 178.808 68.8488L168.552 99.9914C168.405 99.9827 168.272 99.9525 168.125 99.9525C166.946 99.9525 165.875 100.41 165.067 101.144L141.318 84.3467H141.309ZM140.821 79.9594C140.169 79.0137 139.167 78.3271 138.006 78.0853L137.751 62.3543C139.102 62.0909 140.225 61.2099 140.868 60.0397L176.489 65.4936L140.821 79.9594ZM135.708 62.2722L135.963 78.1199C133.955 78.6165 132.457 80.4171 132.457 82.5848C132.457 82.8396 132.496 83.0728 132.534 83.3189L119.779 88.4964C119.01 87.2657 117.676 86.4323 116.138 86.3546L108.836 61.8188C109.791 61.2704 110.52 60.4111 110.892 59.3575H132.547C133.048 60.7868 134.227 61.8922 135.708 62.2722ZM88.5971 143.182L88.8001 107.065C89.2664 106.957 89.7069 106.771 90.1042 106.538L126.057 135.167C125.764 135.772 125.591 136.437 125.591 137.149C125.591 137.179 125.591 137.197 125.591 137.227L91.6371 145.591C91.0326 144.391 89.9314 143.493 88.5885 143.177L88.5971 143.182ZM127.335 133.574L91.6285 105.139C92.1164 104.405 92.4057 103.528 92.4057 102.578C92.4057 102.323 92.3669 102.09 92.328 101.844L112.269 93.7516C113.107 94.8355 114.411 95.548 115.892 95.548C116.173 95.548 116.449 95.5091 116.708 95.4616L127.927 133.151C127.711 133.267 127.517 133.405 127.322 133.561L127.335 133.574ZM106.574 62.4406C106.673 62.4406 106.768 62.419 106.876 62.4104L114.113 86.7001C112.468 87.4039 111.311 89.0362 111.311 90.9491C111.311 91.273 111.35 91.5925 111.41 91.8991L91.5853 99.9395C90.7562 98.7477 89.383 97.9661 87.8155 97.9661C86.4899 97.9661 85.311 98.5318 84.4647 99.43L68.7077 86.8857C69.0013 86.2812 69.174 85.6162 69.174 84.9037C69.174 83.7033 68.7077 82.628 67.9563 81.8076L77.0806 68.5983C77.6074 68.8142 78.1817 68.9395 78.7949 68.9395C81.1613 68.9395 83.0872 67.1431 83.3419 64.8372L102.722 60.3247C103.538 61.6072 104.963 62.4536 106.587 62.4536L106.574 62.4406ZM75.4052 67.4108L66.2809 80.6201C65.7541 80.4042 65.1797 80.2789 64.5666 80.2789C64.2643 80.2789 63.962 80.3092 63.6684 80.3653L59.0609 70.0276C59.877 69.4015 60.4816 68.5206 60.745 67.4972L74.6106 66.2363C74.8049 66.6681 75.077 67.0654 75.3879 67.4108H75.4052ZM67.4295 88.4791L83.4283 101.222C83.3031 101.654 83.2038 102.103 83.2038 102.569C83.2038 104.759 84.7237 106.577 86.749 107.056L86.546 143.173C86.1876 143.251 85.8335 143.389 85.514 143.553L64.0916 117.191C64.6961 116.409 65.0761 115.442 65.0761 114.367C65.0761 112.587 64.0613 111.063 62.5932 110.29L65.4863 89.4205C66.2161 89.2737 66.8681 88.9325 67.4252 88.4835L67.4295 88.4791ZM121.938 162.056L92.0517 148.571C92.1121 148.277 92.138 147.975 92.138 147.66C92.138 147.629 92.138 147.612 92.138 147.582L126.092 139.218C126.511 140.047 127.154 140.72 127.962 141.174L124.788 160.294C123.635 160.502 122.629 161.149 121.938 162.056ZM132.914 133.466C132.146 132.9 131.209 132.546 130.19 132.546C130.09 132.546 129.995 132.568 129.887 132.576L118.6 94.6541C119.74 93.8121 120.491 92.4734 120.491 90.9491C120.491 90.7721 120.461 90.6166 120.444 90.4396L133.299 85.2232C134.128 86.4151 135.501 87.1966 137.068 87.1966C138.247 87.1966 139.318 86.7389 140.126 86.0048L163.876 102.802C163.651 103.338 163.526 103.938 163.526 104.551C163.526 105.324 163.729 106.045 164.07 106.68L132.919 133.453L132.914 133.466ZM172.119 106.771L201.09 115.096C201.09 115.213 201.051 115.321 201.051 115.437C201.051 116.267 201.284 117.039 201.673 117.713L181.895 135.988C181.174 135.517 180.319 135.236 179.391 135.236C178.994 135.236 178.614 135.305 178.242 135.4L170.344 108.559C171.083 108.14 171.696 107.522 172.106 106.771H172.119ZM186.753 163.287C186.658 163.287 186.568 163.309 186.473 163.317L180.846 144.205C182.677 143.6 184.003 141.89 184.003 139.848C184.003 138.967 183.748 138.16 183.32 137.464L203.05 119.233C203.788 119.743 204.687 120.045 205.65 120.045C206.245 120.045 206.798 119.928 207.316 119.721L219.001 139.615C218.056 140.457 217.442 141.675 217.442 143.052C217.442 143.933 217.706 144.745 218.125 145.444L201.357 161.745C200.636 161.275 199.781 160.994 198.857 160.994C196.56 160.994 194.668 162.695 194.327 164.902L190.696 165.597C189.897 164.228 188.437 163.3 186.74 163.3L186.753 163.287ZM225.051 139.593C224.244 138.881 223.203 138.44 222.041 138.44C221.605 138.44 221.195 138.518 220.793 138.635L209 118.564C209.242 118.309 209.437 118.015 209.614 117.713L238.623 127.23C238.614 127.369 238.584 127.502 238.584 127.649C238.584 128.293 238.722 128.901 238.956 129.458L225.042 139.593H225.051ZM244.733 123.314L246.758 106.106C247.333 106.045 247.877 105.881 248.365 105.627L263.155 119.514C262.913 120.079 262.766 120.706 262.766 121.362C262.766 123.288 263.945 124.937 265.62 125.624L262.161 146.347C261.518 146.386 260.913 146.554 260.369 146.826L246.823 130.439C247.419 129.657 247.786 128.699 247.786 127.645C247.79 125.641 246.512 123.949 244.733 123.314ZM262.727 155.51C265.124 155.355 267.032 153.368 267.032 150.928C267.032 149.003 265.853 147.353 264.178 146.666L267.637 125.939C268.211 125.9 268.755 125.775 269.26 125.551L287.159 144.214C286.84 144.84 286.645 145.544 286.645 146.295C286.645 147.193 286.909 148.027 287.358 148.739L260.356 175.494C260.115 175.326 259.851 175.192 259.579 175.084L262.727 155.51ZM307.619 194.291C307.619 194.408 307.649 194.516 307.649 194.624L302.048 196.355C301.249 194.978 299.79 194.041 298.084 194.041C297.208 194.041 296.409 194.296 295.709 194.723L287.578 187.348C287.859 186.812 288.036 186.212 288.092 185.569L310.305 183.03C310.577 184.23 311.328 185.258 312.338 185.893L311.57 189.753C309.35 190.077 307.627 191.981 307.627 194.296L307.619 194.291ZM310.296 180.966L287.803 183.535C287.362 182.403 286.486 181.484 285.376 180.983L291.382 150.898C291.732 150.89 292.065 150.829 292.384 150.751L311.263 179.031C310.797 179.588 310.447 180.244 310.279 180.966H310.296ZM281.062 202.6L283.614 189.8C284.599 189.783 285.505 189.451 286.244 188.902L294.228 196.144C293.762 196.865 293.477 197.729 293.477 198.657C293.477 200.125 294.168 201.412 295.238 202.263L285.376 223.115C285.212 223.076 285.035 223.068 284.858 223.046L281.878 210.644C283.074 209.815 283.864 208.425 283.864 206.853C283.869 204.936 282.707 203.303 281.062 202.6ZM287.215 224L297.078 203.148C297.398 203.217 297.73 203.265 298.071 203.265C298.287 203.265 298.49 203.226 298.693 203.204L308.927 230.348C308.322 230.806 307.835 231.402 307.524 232.097L288.938 227.213C288.835 225.913 288.191 224.769 287.215 224ZM311.699 229.394C311.388 229.394 311.086 229.424 310.792 229.48L300.619 202.483C300.736 202.405 300.835 202.306 300.938 202.22L317.404 217.152C317.032 217.817 316.799 218.577 316.799 219.389C316.799 220.464 317.179 221.44 317.792 222.221L313.12 229.627C312.671 229.48 312.196 229.372 311.699 229.372V229.394ZM318.202 215.118L302.221 200.626C302.502 200.03 302.679 199.365 302.679 198.653C302.679 198.536 302.648 198.428 302.648 198.32L308.249 196.589C309.048 197.966 310.507 198.903 312.213 198.903C312.235 198.903 312.252 198.903 312.269 198.903L318.211 215.122L318.202 215.118ZM224.77 87.6501L207.77 111.374C207.126 111.033 206.418 110.826 205.637 110.826C205.382 110.826 205.14 110.864 204.898 110.903L184.206 68.4472C184.421 68.2615 184.616 68.0672 184.788 67.8426L223.63 84.338C223.63 84.4244 223.6 84.5151 223.6 84.6101C223.6 85.7803 224.049 86.8382 224.757 87.6501H224.77ZM51.7287 66.1499C51.7287 66.219 51.7114 66.2881 51.7114 66.3658C51.7114 67.1474 51.9273 67.8729 52.2684 68.5163L45.6055 74.3026C44.8369 73.7283 43.8912 73.3656 42.8592 73.3656C42.5008 73.3656 42.1596 73.4131 41.8271 73.4908L35.039 59.9663C35.2247 59.8281 35.4103 59.6813 35.5658 59.5172L51.72 66.1413L51.7287 66.1499ZM28.0608 54.5427C27.9917 54.6982 27.9529 54.8752 27.9054 55.0393L18.2931 54.1497C17.9909 51.8914 16.0909 50.1425 13.7548 50.1425C13.4525 50.1425 13.1502 50.1727 12.8609 50.2289L8.05909 42.1064C8.37864 41.7437 8.655 41.3421 8.84932 40.9059L15.577 41.9423L15.7411 42.1884L28.0695 54.56L28.0608 54.5427ZM7.23001 28.7849L5.28252 34.1783L3.52934 23.5297L5.57615 24.3976C5.52433 24.661 5.49843 24.9287 5.49843 25.2008C5.49843 26.656 6.18069 27.9385 7.23001 28.7762V28.7849ZM14.5234 39.7012L9.225 38.8894C9.1775 37.3176 8.34841 35.9487 7.10478 35.1585L9.07386 29.696C9.40636 29.7737 9.7475 29.8212 10.0973 29.8212C10.0973 29.8212 10.1189 29.8212 10.1275 29.8212L14.5277 39.7098L14.5234 39.7012ZM6.00365 6.31315L7.57978 4.72839L8.04614 21.1072C7.3941 21.4397 6.83274 21.919 6.40092 22.5149L3.32639 21.2022L6.01229 6.31315H6.00365ZM62.0145 139.161C62.1916 139.183 62.3557 139.209 62.5413 139.209C62.6277 139.209 62.7054 139.187 62.7961 139.179L69.5152 162.6C68.1031 163.391 67.1402 164.876 67.1402 166.616C67.1402 167.195 67.2568 167.73 67.4425 168.24L52.0957 181.225C51.7848 181.039 51.4523 180.901 51.1025 180.793L52.3764 161.426C54.6046 161.115 56.3318 159.206 56.3318 156.883C56.3318 155.592 55.805 154.439 54.9587 153.601L62.0188 139.148V139.161H62.0145ZM60.542 220.287L43.278 228.396C42.8808 227.869 42.3626 227.438 41.7796 227.127L45.1089 213.507C45.1089 213.507 45.1564 213.507 45.1866 213.507C46.3957 213.507 47.4969 213.028 48.313 212.255L60.6414 218.685C60.555 219.034 60.4945 219.406 60.4945 219.79C60.4945 219.954 60.5248 220.123 60.542 220.278V220.287ZM28.186 205.48C34.2315 207.103 38.1178 208.127 40.6008 208.783C40.6008 208.822 40.5921 208.861 40.5921 208.908C40.5921 210.705 41.6328 212.251 43.1355 213.011L39.8062 226.604C39.7458 226.604 39.6983 226.583 39.6508 226.583C39.409 226.583 39.1844 226.621 38.9512 226.652L27.5858 206.348C27.819 206.084 28.0133 205.791 28.1817 205.467L28.186 205.48ZM41.1189 206.801C37.8199 205.933 33.0872 204.672 28.7129 203.498C28.7129 203.437 28.7345 203.39 28.7345 203.334C28.7345 201.809 27.996 200.479 26.8647 199.642L32.5431 180.918C33.8774 180.858 35.0476 180.223 35.8421 179.268L45.3378 184.096C45.2514 184.459 45.191 184.817 45.191 185.21C45.191 186.899 46.1064 188.367 47.4623 189.166L44.513 204.37C43.0276 204.59 41.7796 205.519 41.1189 206.801ZM50.3296 161.275L49.0557 180.672C47.9373 180.849 46.9614 181.432 46.2619 182.274L36.7662 177.446C36.8526 177.083 36.9131 176.725 36.9131 176.332C36.9131 175.62 36.736 174.955 36.4553 174.35L49.7078 161.02C49.9107 161.119 50.118 161.197 50.3296 161.266V161.275ZM66.9718 230.016L45.2557 229.731L61.207 222.234C62.0145 223.534 63.4482 224.402 65.0934 224.402C65.115 224.402 65.1322 224.402 65.1409 224.402L66.9718 230.016ZM99.4832 175.602C99.4832 175.602 99.5307 175.602 99.5523 175.602C102.091 175.602 104.147 173.538 104.147 170.991C104.147 170.982 104.147 170.969 104.147 170.96L121.489 166.867C121.683 167.268 121.938 167.64 122.24 167.972L112.2 187.201C111.984 187.171 111.781 187.132 111.557 187.132C109.268 187.132 107.39 188.812 107.04 191.001L95.7739 191.713C95.5105 190.833 95.0053 190.073 94.323 189.507L99.4832 175.594V175.602ZM133.636 235.305L122.983 241.148C122.447 240.932 121.873 240.807 121.26 240.807C120.521 240.807 119.83 241.001 119.204 241.316L108.154 230.676C108.435 230.167 108.62 229.592 108.698 228.988L118.457 228.038C119.062 229.873 120.767 231.203 122.801 231.203C124.067 231.203 125.207 230.693 126.036 229.864L133.601 233.526C133.562 233.772 133.523 234.014 133.523 234.269C133.523 234.619 133.571 234.964 133.649 235.297L133.636 235.305ZM95.8991 193.765L107.165 193.052C107.545 194.322 108.43 195.358 109.609 195.915L103.603 223.707L94.2453 196.619C95.1132 195.924 95.7264 194.926 95.9121 193.773L95.8991 193.765ZM118.25 225.991L108.474 226.941C108.007 225.589 106.954 224.544 105.611 224.087L111.531 196.679L120.003 222.947C119.057 223.681 118.414 224.756 118.25 226.004V225.991ZM125.574 243.873C125.388 243.363 125.124 242.897 124.783 242.486L134.529 237.132C135.367 238.186 136.654 238.872 138.105 238.872C138.269 238.872 138.424 238.842 138.58 238.825L140.838 243.868H125.561L125.574 243.873ZM134.745 137.65C134.767 137.495 134.793 137.339 134.793 137.171C134.793 136.398 134.59 135.677 134.249 135.042L165.4 108.269C166.169 108.835 167.106 109.189 168.125 109.189C168.224 109.189 168.31 109.172 168.405 109.159L176.42 136.402C175.448 137.253 174.822 138.483 174.822 139.87C174.822 140.66 175.038 141.394 175.388 142.037L167.062 149.728C166.333 149.249 165.465 148.968 164.532 148.968C163.245 148.968 162.079 149.503 161.25 150.367L134.745 137.663V137.65ZM164.122 158.753L168.202 187.11C167.425 187.499 166.769 188.099 166.311 188.842L157.442 185.284C157.48 185.051 157.511 184.813 157.511 184.571C157.511 183.155 156.859 181.894 155.857 181.052L164.122 158.753ZM167.844 243.881C167.844 243.881 167.844 243.864 167.844 243.851L183.355 235.279C184.193 236.229 185.41 236.834 186.775 236.834C187.056 236.834 187.319 236.795 187.591 236.756L191.65 243.881H167.853H167.844ZM206.15 187.054L231.515 214.747C231.036 215.468 230.764 216.34 230.764 217.268C230.764 217.346 230.786 217.424 230.786 217.501L221.489 219.794C220.711 218.348 219.209 217.363 217.455 217.363C217.447 217.363 217.438 217.363 217.425 217.363L206.15 187.054ZM240.048 239.654C239.962 239.313 239.823 238.98 239.668 238.665L250.874 228.962C251.573 229.394 252.385 229.657 253.262 229.657C253.827 229.657 254.371 229.541 254.868 229.355L262.075 239.654H240.048ZM248.706 224.652C248.697 224.778 248.667 224.907 248.667 225.041C248.667 225.961 248.939 226.811 249.405 227.533L238.342 237.11C237.738 236.661 237.025 236.368 236.248 236.26L236.356 221.768C237.25 221.574 238.049 221.111 238.666 220.468L248.706 224.661V224.652ZM246.232 172.2C246.253 172.031 246.279 171.876 246.279 171.712C246.279 169.16 244.224 167.1 241.685 167.1C241.089 167.1 240.527 167.225 240.001 167.432L225.513 146.083C226.213 145.272 226.662 144.227 226.662 143.065C226.662 142.422 226.524 141.813 226.29 141.256L240.203 131.121C241.011 131.833 242.052 132.274 243.213 132.274C243.965 132.274 244.656 132.08 245.277 131.764L258.823 148.152C258.232 148.933 257.86 149.892 257.86 150.946C257.86 152.88 259.048 154.53 260.732 155.216L257.575 174.778C256.388 174.855 255.326 175.365 254.548 176.164L246.232 172.2ZM257.636 183.945C257.714 183.945 257.783 183.967 257.86 183.967C257.882 183.967 257.891 183.967 257.908 183.967L266.475 219.38L253.076 202.612C253.512 201.909 253.775 201.088 253.775 200.19C253.775 198.843 253.18 197.638 252.268 196.792L257.645 183.941L257.636 183.945Z' />
            <BasePath d='M438.503 107.448C442.6 105.6 445.774 102.801 447.998 99.0274C450.222 95.2533 451.323 91.1554 451.323 86.7077C451.323 83.9354 450.848 81.1848 449.872 78.46C448.896 75.7352 447.549 73.3127 445.774 71.1623C444.025 69.0119 441.875 67.2889 439.349 65.9373C436.827 64.5901 434.029 63.9121 430.928 63.9121H386.546V153.229H428.929C432.531 153.229 435.903 152.681 439.051 151.605C442.199 150.504 444.975 148.958 447.346 146.959C449.747 144.934 451.621 142.511 453.02 139.661C454.393 136.811 455.097 133.663 455.097 130.213C455.097 124.664 453.595 119.867 450.624 115.821C447.648 111.749 443.598 108.972 438.477 107.448H438.503ZM397.869 73.7359H427.055C428.903 73.7359 430.631 74.1116 432.28 74.8587C433.93 75.61 435.303 76.6593 436.425 78.0066C437.553 79.3539 438.451 80.93 439.124 82.7782C439.802 84.6263 440.126 86.5997 440.126 88.7027C440.126 90.8013 439.776 92.6279 439.051 94.4242C438.325 96.2206 437.375 97.7967 436.153 99.1483C434.927 100.496 433.476 101.549 431.805 102.348C430.13 103.147 428.281 103.549 426.282 103.549H397.869V73.7359ZM442.523 133.987C441.776 135.835 440.726 137.437 439.375 138.837C438.028 140.21 436.477 141.337 434.728 142.162C432.98 142.986 431.028 143.409 428.929 143.409H397.864V112.72H429.827C431.853 112.72 433.679 113.143 435.376 113.968C437.052 114.819 438.503 115.942 439.725 117.367C440.951 118.792 441.901 120.441 442.626 122.341C443.326 124.215 443.697 126.189 443.697 128.188C443.697 130.187 443.326 132.135 442.575 133.987H442.523Z' />
            <BasePath d='M494.959 63.9395H483.637V153.256H544.791V143.186H494.959V63.9395Z' />
            <BasePath d='M632.477 77.6379C628.776 73.3629 624.38 69.8911 619.255 67.2657C614.133 64.6186 608.433 63.293 602.137 63.293C595.837 63.293 590.491 64.5409 585.344 67.0152C580.197 69.4895 575.723 72.8145 571.949 77.0118C568.175 81.209 565.226 86.0324 563.075 91.4819C560.929 96.9314 559.88 102.627 559.88 108.599C559.88 114.571 560.877 119.87 562.903 125.345C564.928 130.794 567.773 135.639 571.448 139.863C575.149 144.112 579.571 147.484 584.718 150.058C589.865 152.606 595.591 153.905 601.887 153.905C608.183 153.905 613.533 152.679 618.68 150.183C623.827 147.709 628.275 144.384 632.028 140.238C635.75 136.089 638.699 131.291 640.824 125.842C642.97 120.392 644.019 114.696 644.019 108.724C644.019 103.102 643.022 97.5792 640.997 92.1815C638.971 86.7579 636.126 81.9345 632.451 77.6638L632.477 77.6379ZM630.525 121.295C629.152 125.492 627.127 129.24 624.48 132.565C621.828 135.89 618.628 138.563 614.859 140.614C611.085 142.665 606.81 143.689 602.038 143.689C597.262 143.689 593.242 142.713 589.468 140.791C585.694 138.865 582.468 136.27 579.769 132.992C577.096 129.719 575.024 125.971 573.547 121.722C572.074 117.499 571.349 113.099 571.349 108.578C571.349 104.056 572.048 99.9326 573.499 95.7569C574.92 91.5597 576.945 87.8331 579.597 84.5599C582.244 81.2868 585.443 78.6354 589.217 76.6361C592.992 74.6109 597.262 73.6134 602.064 73.6134C606.585 73.6134 610.709 74.5893 614.457 76.5109C618.179 78.4368 621.431 81.0104 624.151 84.2576C626.876 87.4833 628.975 91.2315 630.452 95.4546C631.924 99.7037 632.65 104.078 632.65 108.599C632.65 112.874 631.95 117.123 630.577 121.295H630.525Z' />
            <BasePath d='M739.541 77.6379C735.841 73.3629 731.445 69.8911 726.319 67.2657C721.198 64.6186 715.498 63.293 709.202 63.293C702.902 63.293 697.556 64.5409 692.409 67.0152C687.261 69.4895 682.788 72.8145 679.014 77.0118C675.24 81.209 672.29 86.0324 670.14 91.4819C667.994 96.9314 666.944 102.627 666.944 108.599C666.944 114.571 667.942 119.87 669.967 125.345C671.992 130.794 674.838 135.639 678.513 139.863C682.213 144.112 686.635 147.484 691.782 150.058C696.93 152.606 702.656 153.905 708.951 153.905C715.247 153.905 720.597 152.679 725.745 150.183C730.892 147.709 735.34 144.384 739.088 140.238C742.814 136.089 745.764 131.291 747.888 125.842C750.034 120.392 751.084 114.696 751.084 108.724C751.084 103.102 750.086 97.5792 748.061 92.1815C746.036 86.7579 743.19 81.9345 739.515 77.6638L739.541 77.6379ZM737.589 121.295C736.216 125.492 734.191 129.24 731.544 132.565C728.893 135.89 725.693 138.563 721.923 140.614C718.149 142.665 713.874 143.689 709.103 143.689C704.327 143.689 700.306 142.713 696.532 140.791C692.758 138.865 689.533 136.27 686.834 132.992C684.161 129.719 682.088 125.971 680.611 121.722C679.139 117.499 678.413 113.099 678.413 108.578C678.413 104.056 679.113 99.9326 680.564 95.7569C681.984 91.5597 684.01 87.8331 686.661 84.5599C689.308 81.2868 692.508 78.6354 696.282 76.6361C700.056 74.6109 704.327 73.6134 709.124 73.6134C713.65 73.6134 717.773 74.5893 721.522 76.5109C725.244 78.4368 728.495 81.0104 731.216 84.2576C733.941 87.4833 736.039 91.2315 737.516 95.4546C738.989 99.7037 739.714 104.078 739.714 108.599C739.714 112.874 739.014 117.123 737.641 121.295H737.589Z' />
            <BasePath d='M842.807 77.0091C839.21 72.9846 834.685 69.7848 829.287 67.4357C823.889 65.0866 817.619 63.9121 810.469 63.9121H779.533V153.229H810.469C817.019 153.229 822.939 152.154 828.264 150.029C833.588 147.879 838.135 144.882 841.909 140.983C845.683 137.083 848.581 132.385 850.58 126.888C852.605 121.391 853.603 115.242 853.603 108.445C853.603 102.322 852.704 96.5488 850.904 91.1511C849.107 85.7534 846.409 81.0293 842.781 77.0048L842.807 77.0091ZM840.108 122.242C838.735 126.491 836.71 130.14 834.063 133.236C831.412 136.336 828.113 138.785 824.114 140.534C820.141 142.282 815.568 143.181 810.469 143.181H790.851V73.9864H810.469C815.495 73.9864 819.99 74.863 823.941 76.56C827.888 78.283 831.213 80.6579 833.938 83.6591C836.662 86.6818 838.709 90.3047 840.108 94.5279C841.482 98.777 842.185 103.402 842.185 108.424C842.185 113.446 841.482 117.971 840.108 122.194V122.242Z' />
            <BasePath d='M942.971 102.552H893.761V63.9438H882.443V153.261H893.761V112.627H942.971V153.261H954.289V63.9395H942.971V102.552Z' />
            <BasePath d='M1055.3 77.6379C1051.6 73.3629 1047.21 69.8911 1042.08 67.2657C1036.96 64.6186 1031.26 63.293 1024.96 63.293C1018.66 63.293 1013.32 64.5409 1008.17 67.0152C1003.02 69.4895 998.549 72.8145 994.775 77.0118C991.001 81.209 988.052 86.0324 985.901 91.4819C983.755 96.9314 982.702 102.627 982.702 108.599C982.702 114.571 983.703 119.87 985.729 125.341C987.754 130.79 990.6 135.635 994.274 139.858C997.975 144.107 1002.4 147.48 1007.54 150.053C1012.69 152.627 1018.42 153.901 1024.71 153.901C1031.01 153.901 1036.36 152.675 1041.51 150.179C1046.65 147.704 1051.1 144.379 1054.85 140.234C1058.6 136.084 1061.53 131.287 1063.65 125.837C1065.8 120.388 1066.85 114.692 1066.85 108.72C1066.85 103.098 1065.85 97.5749 1063.82 92.1772C1061.8 86.7535 1058.95 81.9302 1055.28 77.6595L1055.3 77.6379ZM1053.35 121.295C1051.98 125.492 1049.95 129.24 1047.31 132.565C1044.65 135.89 1041.45 138.563 1037.68 140.614C1033.91 142.665 1029.64 143.689 1024.84 143.689C1020.04 143.689 1016.04 142.713 1012.27 140.791C1008.49 138.865 1005.27 136.266 1002.57 132.992C999.897 129.719 997.824 125.971 996.347 121.722C994.875 117.499 994.149 113.099 994.149 108.578C994.149 104.052 994.849 99.9326 996.3 95.7569C997.725 91.5597 999.745 87.8331 1002.4 84.5599C1005.04 81.2868 1008.24 78.6354 1012.02 76.6361C1015.79 74.6109 1020.07 73.6134 1024.84 73.6134C1029.36 73.6134 1033.48 74.5893 1037.23 76.5109C1040.96 78.4368 1044.18 81.0104 1046.93 84.2576C1049.65 87.4833 1051.75 91.2315 1053.23 95.4546C1054.7 99.7037 1055.43 104.078 1055.43 108.599C1055.43 112.874 1054.73 117.123 1053.35 121.295Z' />
            <BasePath d='M1158.7 109.098C1158.7 113.373 1158.27 117.596 1157.45 121.742C1156.6 125.892 1155.17 129.588 1153.1 132.814C1151.05 136.039 1148.3 138.66 1144.85 140.686C1141.4 142.711 1137.11 143.708 1131.88 143.708C1126.66 143.708 1122.51 142.732 1119.11 140.759C1115.71 138.786 1112.99 136.212 1110.94 133.012C1108.89 129.812 1107.41 126.164 1106.54 122.018C1105.67 117.868 1105.22 113.572 1105.22 109.124V63.9648H1093.89V109.124C1093.89 114.82 1094.55 120.395 1095.85 125.792C1097.15 131.216 1099.3 135.987 1102.27 140.137C1105.24 144.287 1109.17 147.608 1114.04 150.134C1118.91 152.656 1124.91 153.908 1132.03 153.908C1139.15 153.908 1144.75 152.707 1149.58 150.332C1154.4 147.932 1158.32 144.684 1161.34 140.586C1164.37 136.488 1166.57 131.717 1167.94 126.315C1169.32 120.891 1170.02 115.17 1170.02 109.146V63.9908H1158.7V109.15V109.098Z' />
            <BasePath d='M1266.76 133.488L1211.41 63.9395H1202.61V153.256H1213.93V85.0596L1268.54 153.261H1278.08V64.0647H1266.76V133.488Z' />
            <BasePath d='M1383.43 91.1554C1381.63 85.7577 1378.93 81.0336 1375.31 77.0091C1371.68 72.9846 1367.19 69.7848 1361.79 67.4357C1356.37 65.0866 1350.12 63.9121 1342.97 63.9121H1312.03V153.229H1342.97C1349.52 153.229 1355.44 152.154 1360.76 150.029C1366.09 147.879 1370.63 144.882 1374.41 140.983C1378.18 137.083 1381.08 132.385 1383.08 126.888C1385.1 121.391 1386.11 115.242 1386.11 108.445C1386.11 102.322 1385.2 96.5488 1383.41 91.1511H1383.43V91.1554ZM1372.61 122.216C1371.23 126.465 1369.21 130.114 1366.56 133.21C1363.92 136.31 1360.62 138.759 1356.62 140.508C1352.62 142.257 1348.09 143.155 1342.97 143.155H1323.35V73.9605H1342.97C1347.99 73.9605 1352.49 74.8327 1356.44 76.5341C1360.39 78.257 1363.71 80.632 1366.44 83.6288C1369.16 86.6256 1371.21 90.2788 1372.61 94.4977C1373.99 98.7467 1374.68 103.371 1374.68 108.393C1374.68 113.416 1373.99 117.941 1372.61 122.164V122.216Z' />
            <BasePath d='M386.551 241.273V198.277H415.164V204.503H394.047V216.345H413.817V222.57H394.047V235.073H415.164V241.298H386.551V241.273Z' />
            <BasePath d='M437.602 241.273V198.277H443.447L466.571 228.288V198.277H473.838V241.273H468.045L444.87 211.135V241.273H437.602Z' />
            <BasePath d='M508.244 241.273V204.808H493.48V198.277H530.809V204.808H516.046V241.273H508.244Z' />
            <BasePath d='M550.376 241.273V198.277H578.989V204.503H557.873V216.345H577.643V222.57H557.873V235.073H578.989V241.298H550.376V241.273Z' />
            <BasePath d='M601.426 241.273V198.277H620.103C624.83 198.277 628.464 199.395 631.03 201.657C633.597 203.919 634.867 207.07 634.867 211.135C634.867 214.337 634.029 217.005 632.377 219.089C630.7 221.173 628.311 222.596 625.186 223.333C627.269 223.993 628.972 225.543 630.319 228.034L637.51 241.273H628.921L621.476 227.551C620.739 226.204 619.875 225.289 618.884 224.807C617.893 224.324 616.622 224.07 615.072 224.07H609.278V241.273H601.477H601.426ZM609.253 218.276H618.757C624.449 218.276 627.295 215.963 627.295 211.313C627.295 206.663 624.449 204.427 618.757 204.427H609.253V218.276Z' />
            <BasePath d='M657.916 241.273V198.277H676.593C681.319 198.277 684.953 199.446 687.519 201.81C690.086 204.173 691.357 207.476 691.357 211.694C691.357 215.913 690.086 219.216 687.519 221.605C684.953 223.993 681.319 225.162 676.593 225.162H665.742V241.273H657.941H657.916ZM665.717 219.013H675.348C680.963 219.013 683.759 216.573 683.759 211.694C683.759 206.815 680.963 204.427 675.348 204.427H665.717V219.013Z' />
            <BasePath d='M712.322 241.273V198.277H730.999C735.725 198.277 739.359 199.395 741.926 201.657C744.492 203.919 745.763 207.07 745.763 211.135C745.763 214.337 744.924 217.005 743.272 219.089C741.595 221.173 739.207 222.596 736.081 223.333C738.165 223.993 739.867 225.543 741.214 228.034L748.406 241.273H739.817L732.371 227.551C731.634 226.204 730.77 225.289 729.779 224.807C728.788 224.324 727.518 224.07 725.968 224.07H720.174V241.273H712.373H712.322ZM720.123 218.276H729.627C735.319 218.276 738.165 215.963 738.165 211.313C738.165 206.663 735.319 204.427 729.627 204.427H720.123V218.276Z' />
            <BasePath d='M768.811 241.273V198.277H776.612V241.273H768.811Z' />
            <BasePath d='M815.414 241.883C812.034 241.883 808.909 241.451 806.012 240.562C803.115 239.698 800.675 238.504 798.693 237.004L801.082 230.855C803.064 232.278 805.249 233.371 807.638 234.158C810.027 234.921 812.619 235.327 815.414 235.327C818.616 235.327 820.953 234.794 822.427 233.701C823.901 232.634 824.613 231.236 824.613 229.534C824.613 228.11 824.104 226.992 823.063 226.179C822.021 225.366 820.242 224.705 817.726 224.172L811.018 222.774C803.369 221.148 799.557 217.235 799.557 211.009C799.557 208.315 800.269 205.977 801.692 203.995C803.115 202.013 805.097 200.463 807.613 199.37C810.128 198.278 813.051 197.719 816.329 197.719C819.251 197.719 821.995 198.151 824.562 199.04C827.128 199.904 829.263 201.149 830.965 202.725L828.577 208.569C825.197 205.723 821.106 204.3 816.252 204.3C813.457 204.3 811.246 204.885 809.671 206.079C808.095 207.248 807.282 208.798 807.282 210.704C807.282 212.178 807.765 213.347 808.756 214.211C809.747 215.075 811.399 215.761 813.762 216.243L820.42 217.641C824.435 218.505 827.433 219.826 829.415 221.656C831.397 223.486 832.363 225.925 832.363 228.974C832.363 231.541 831.677 233.802 830.279 235.734C828.882 237.665 826.925 239.215 824.384 240.282C821.843 241.35 818.844 241.909 815.388 241.909L815.414 241.883Z' />
            <BasePath d='M853.708 241.273V198.277H882.321V204.503H861.204V216.345H880.974V222.57H861.204V235.073H882.321V241.298H853.708V241.273Z' />
        </BaseSVG>
    );
};
