# Message Catalog

Instructions for adding to the ttkbootstrap message catalog

1. Open the file **src/ttkbootstrap/localization/msgs.py**
2. If adding to an existing catalog, locate the language and add the message as a tuple `("original", "translated")`
3. If adding a new language to the catalog, append a new instance of `LocaleMsgs` to the `MESSAGES` list using the same pattern demonstrated in the file for other languages:
```python
MESSAGES.append(
    LocaleMsgs(
        "language_code",
        ("original", "translated"),
        ("original", "translated")
    )
)
```
4. Use the language code as presented in the **LCID string** [on this site](https://wiki.freepascal.org/Language_Codes), except replace the dash with an undercore. For example: **zh-cn** should be **zh_cn**.

5. The following words / phrases should be translated for a new language in ttkbootstrap at a minimum:

    - "OK"
    - "Ok"
    - "Retry"
    - "Delete"
    - "Next"
    - "Prev"
    - "Yes"
    - "No"
    - "Open"
    - "Close"
    - "Add"
    - "Remove"
    - "Submit"
    - "Family"
    - "Weight"
    - "Slant"
    - "Effects"
    - "Preview"
    - "Size"
    - "Should be of data type"
    - "Invalid data type"
    - "Number cannot be greater than"
    - "Out of range"
    - "Previous"
    - "The quick brown fox jumps over the lazy dog."
    - "Font Selector"
    - "normal"
    - "bold"  "negrito"
    - "roman"
    - "italic"
    - "underline"
    - "overstrike"
    - "Color Chooser"
    - "Advanced"
    - "Themed"
    - "Standard"
    - "Current"
    - "New"
    - "Hue"
    - "Sat"
    - "Lum"
    - "Hex"
    - "Red"
    - "Green"
    - "Blue"
    - "color dropper"
    - "Cancel"
    - "Search"
    - "Page"
    - "of"
    - "⎌"
    - "Reset table"
    - "Columns"
    - "Move"
    - "Align"
    - "Hide column"
    - "Delete column"
    - "Show All"
    - "Move to left"
    - "Move to right"
    - "Move to first"
    - "Move to last"
    - "Align left"
    - "Align center"
    - "Align right"
    - "Sort"
    - "Filter"
    - "Export"
    - "Delete selected rows"
    - "Sort Ascending"
    - "Sort Descending"
    - "Clear filters"
    - "Filter by cell's value"
    - "Hide select rows"
    - "Show only select rows"
    - "Export all records"
    - "Export current page"
    - "Export current selection"
    - "Export records in filter"
    - "Move up"
    - "Move down"
    - "Move to top"
    - "Move to bottom"
    - "Mo"
    - "Tu"
    - "We"
    - "Th"
    - "Fr"
    - "Sa"
    - "Su"
