// Instruction handlers for the m68000 (indirect, partial, cpu)
//
// Generated by m68000gen.py sip8 m68000.lst m68008-sip8.cpp

#include "emu.h"
#include "m68008.h"

void m68008_device::state_reset_ip8()
{
	switch(m_inst_substate) {
	case 0:
	// 002 rstp3
	m_icount -= 2;
	// 296 rstp4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_ftu_const();
	m_icount -= 2;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 27e rstp5
	debugger_exception_hook(0x00);
	m_ftu = 0x0000;
	m_icount -= 2;
	// 27f rstp6
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_sr |= 0x0700;
	update_interrupt();
	m_au = ext32(m_ftu);
	m_icount -= 2;
	// 2fb rstp7
	m_aob = m_au;
	set_16h(m_da[16], m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2ff rstp8
	m_aob = m_au;
	set_16h(m_da[16], m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 300 rstp9
	m_aob = m_au;
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	set_16l(m_da[16], m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 11e rstpa
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::state_bus_error_ip8()
{
	switch(m_inst_substate) {
	case 0:
	// 003 bser1
	m_ssw = m_base_ssw | (m_sr & SR_S ? SSW_S : 0);
	m_at = m_aob;
	m_ftu = m_sr;
	m_au = m_pc;
	m_icount -= 2;
	// 3a7 bser2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... 1 a=10:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3ca bser3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 1:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0a2 bser4
	m_aob = m_au;
	m_dbout = m_aluo;
	m_ftu = m_ird;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 5:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 3c6 bser5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 9:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 088 bser6
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_pc = m_at;
	m_ftu = (m_ftu & ~0x1f) | m_ssw;
	m_au = m_au - 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=11:m_at d=-1
	alu_and(m_at, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 13:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 17:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x02);
	m_da[16] = m_au;
	m_ftu = 0x0008;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 29:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 33:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 33;
		} else
			m_inst_substate = 34;
		return;
	}
	[[fallthrough]]; case 34:
	[[fallthrough]]; case 35:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 35;
		} else
			m_inst_substate = 36;
		return;
	}
	[[fallthrough]]; case 36:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 37:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 37;
		} else
			m_inst_substate = 38;
		return;
	}
	[[fallthrough]]; case 38:
	[[fallthrough]]; case 39:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 39;
		} else
			m_inst_substate = 40;
		return;
	}
	[[fallthrough]]; case 40:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 41:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 41;
		} else
			m_inst_substate = 42;
		return;
	}
	[[fallthrough]]; case 42:
	[[fallthrough]]; case 43:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 43;
		} else
			m_inst_substate = 44;
		return;
	}
	[[fallthrough]]; case 44:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::state_address_error_ip8()
{
	switch(m_inst_substate) {
	case 0:
	// 003 bser1
	m_ssw = m_base_ssw | (m_sr & SR_S ? SSW_S : 0);
	m_at = m_aob;
	m_ftu = m_sr;
	m_au = m_pc;
	m_icount -= 2;
	// 3a7 bser2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... 1 a=10:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3ca bser3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 1:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0a2 bser4
	m_aob = m_au;
	m_dbout = m_aluo;
	m_ftu = m_ird;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 5:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 3c6 bser5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 9:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 088 bser6
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_pc = m_at;
	m_ftu = (m_ftu & ~0x1f) | m_ssw;
	m_au = m_au - 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=11:m_at d=-1
	alu_and(m_at, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 13:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 17:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x03);
	m_da[16] = m_au;
	m_ftu = 0x000c;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 29:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 33:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 33;
		} else
			m_inst_substate = 34;
		return;
	}
	[[fallthrough]]; case 34:
	[[fallthrough]]; case 35:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 35;
		} else
			m_inst_substate = 36;
		return;
	}
	[[fallthrough]]; case 36:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 37:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 37;
		} else
			m_inst_substate = 38;
		return;
	}
	[[fallthrough]]; case 38:
	[[fallthrough]]; case 39:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 39;
		} else
			m_inst_substate = 40;
		return;
	}
	[[fallthrough]]; case 40:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 41:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 41;
		} else
			m_inst_substate = 42;
		return;
	}
	[[fallthrough]]; case 42:
	[[fallthrough]]; case 43:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 43;
		} else
			m_inst_substate = 44;
		return;
	}
	[[fallthrough]]; case 44:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::state_double_fault_ip8()
{
	switch(m_inst_substate) {
	case 0:
	// 001 halt1
	m_icount = 0;
	}
}

void m68008_device::state_interrupt_ip8()
{
	switch(m_inst_substate) {
	case 0:
	// 1c4 itlx1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	m_icount -= 2;
	// 234 itlx2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_alub = m_ftu;
	m_pc = m_au;
	m_sr = (m_sr & ~SR_I) | ((m_next_state >> 16) & SR_I);
	update_interrupt();
	// alu r=0 c=1 m=.....  i=....... 1 a=10:m_au d=-1
	alu_and(m_au, 0xffff);
	m_icount -= 2;
	// 235 itlx3
	m_ftu = 0xfff1 | ((m_next_state >> 23) & 0xe);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	// 0eb itlx4
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 1:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 236 itlx5
	m_aob = m_at;
	m_base_ssw = SSW_CPU | SSW_R | SSW_N;
	start_interrupt_vector_lookup();
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_cpu(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	end_interrupt_vector_lookup();
	m_irc = m_edb;
	// 118 itlx6
	m_ir = m_irc;
	m_icount -= 2;
	// 292 itlx7
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_ftu_const();
	m_icount -= 2;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook((m_int_vector) >> 2);
	m_da[16] = m_au;
	m_ftu = m_int_vector;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 15:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	[[fallthrough]]; case 17:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 19:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	[[fallthrough]]; case 21:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 23:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	[[fallthrough]]; case 25:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 27:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	[[fallthrough]]; case 29:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::state_trace_ip8()
{
	switch(m_inst_substate) {
	case 0:
	// 1c0 trac1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	m_icount -= 2;
	// 3a3 trac2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... 1 a=10:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 1:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x09);
	m_da[16] = m_au;
	m_ftu = 0x0024;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 5:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 9:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 25:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::state_illegal_ip8()
{
	switch(m_inst_substate) {
	case 0:
	// 1c0 trac1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	m_icount -= 2;
	// 3a3 trac2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... 1 a=10:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 1:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x04);
	m_da[16] = m_au;
	m_ftu = 0x0010;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 5:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 9:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 25:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::state_priviledge_ip8()
{
	switch(m_inst_substate) {
	case 0:
	// 1c0 trac1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	m_icount -= 2;
	// 3a3 trac2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... 1 a=10:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 1:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x08);
	m_da[16] = m_au;
	m_ftu = 0x0020;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 5:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 9:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 25:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::state_linea_ip8()
{
	switch(m_inst_substate) {
	case 0:
	// 1c0 trac1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	m_icount -= 2;
	// 3a3 trac2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... 1 a=10:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 1:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x0a);
	m_da[16] = m_au;
	m_ftu = 0x0028;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 5:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 9:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 25:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::state_linef_ip8()
{
	switch(m_inst_substate) {
	case 0:
	// 1c0 trac1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	m_icount -= 2;
	// 3a3 trac2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... 1 a=10:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 1:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x0b);
	m_da[16] = m_au;
	m_ftu = 0x002c;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 5:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 9:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 25:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_b_imm8_ds_ip8() // 0000 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=14 c=2 m=.nzvc  i=b....i. 8 a=9:m_dt d=4:m_da[ry]
	alu_or8(m_dt, m_da[ry]);
	sr_nzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=33:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_b_imm8_ais_ip8() // 0010 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_b_imm8_aips_ip8() // 0018 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_b_imm8_pais_ip8() // 0020 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=14 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_b_imm8_das_ip8() // 0028 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_b_imm8_dais_ip8() // 0030 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=14 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=b...... 8 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_b_imm8_adr16_ip8() // 0038 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_b_imm8_adr32_ip8() // 0039 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 15:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	[[fallthrough]]; case 17:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_imm8_ccr_ip8() // 003c ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1cc stiw1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_icount -= 2;
	// 307 stiw2
	// alu r=14 c=2 m=.....  i=b...... 8 a=37:m_ftu d=9:m_dt
	alu_or8(m_ftu, m_dt);
	m_icount -= 2;
	// 320 stiw3
	m_movemr = m_dbin;
	m_ftu = m_aluo;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=33:m_aluo d=none
	m_icount -= 2;
	// 321 stiw4
	m_sr = m_isr = (m_ftu & SR_CCR) | (m_sr & SR_SR);
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_icount -= 2;
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_w_imm16_ds_ip8() // 0040 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=14 c=2 m=.nzvc  i=.....i. 8 a=9:m_dt d=4:m_da[ry]
	alu_or(m_dt, m_da[ry]);
	sr_nzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=33:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_w_imm16_ais_ip8() // 0050 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=14 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=....... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_w_imm16_aips_ip8() // 0058 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_w_imm16_pais_ip8() // 0060 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=14 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_w_imm16_das_ip8() // 0068 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=....... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_w_imm16_dais_ip8() // 0070 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=14 c=5 m=.....  i=....... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=....... 8 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=....... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_w_imm16_adr16_ip8() // 0078 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=....... 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_w_imm16_adr32_ip8() // 0079 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=....... 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_i16u_sr_ip8() // 007c ffff
{
	switch(m_inst_substate) {
	case 0:
	if(!(m_sr & SR_S)) {
		m_inst_state = S_PRIVILEDGE;
		return;
	}
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1cc stiw1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_icount -= 2;
	// 307 stiw2
	// alu r=14 c=2 m=.....  i=....... 8 a=37:m_ftu d=9:m_dt
	alu_or(m_ftu, m_dt);
	m_icount -= 2;
	// 320 stiw3
	m_movemr = m_dbin;
	m_ftu = m_aluo;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=33:m_aluo d=none
	m_icount -= 2;
	// 321 stiw4
	m_sr = m_isr = m_ftu & (SR_CCR|SR_SR);
	update_user_super();
	update_interrupt();
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_icount -= 2;
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_l_imm32_ds_ip8() // 0080 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 10c roal1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=14 c=2 m=.nzvc  i=.l...i. 8 a=9:m_dt d=4:m_da[ry]
	alu_or(m_dt, m_da[ry]);
	sr_nzvc();
	// 259 roal2
	set_16l(m_da[ry], m_aluo);
	// alu r=14 c=0 m=.....  i=.l..... 8 a=33:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 25a roal3
	// alu r=14 c=3 m=.nzvc  i=.l....f 8 a=23:m_dt d=18:m_da[ry]
	alu_or(high16(m_dt), high16(m_da[ry]));
	sr_nzvc_u();
	m_icount -= 2;
	// 25b roal4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=33:m_aluo d=none
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_l_imm32_ais_ip8() // 0090 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=14 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f 8 a=23:m_dt d=29:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_l_imm32_aips_ip8() // 0098 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=14 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=31:m_dbin
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f 8 a=23:m_dt d=29:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_l_imm32_pais_ip8() // 00a0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=14 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f 8 a=23:m_dt d=29:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_l_imm32_das_ip8() // 00a8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=14 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f 8 a=23:m_dt d=29:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_l_imm32_dais_ip8() // 00b0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e7 aixw0
	// alu r=14 c=5 m=.....  i=.l..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=.l..... 8 a=33:m_aluo d=none
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 33:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 33;
		} else
			m_inst_substate = 34;
		return;
	}
	[[fallthrough]]; case 34:
	[[fallthrough]]; case 35:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 35;
		} else
			m_inst_substate = 36;
		return;
	}
	[[fallthrough]]; case 36:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=14 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f 8 a=23:m_dt d=29:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_l_imm32_adr16_ip8() // 00b8 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=.l..... 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=14 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f 8 a=23:m_dt d=29:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::ori_l_imm32_adr32_ip8() // 00b9 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=.l..... 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=14 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 25:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f 8 a=23:m_dt d=29:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 33:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 33;
		} else
			m_inst_substate = 34;
		return;
	}
	[[fallthrough]]; case 34:
	[[fallthrough]]; case 35:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 35;
		} else
			m_inst_substate = 36;
		return;
	}
	[[fallthrough]]; case 36:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_dd_ds_ip8() // 0100 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3e7 btsr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = m_da[rx];
	m_au = m_da[ry];
	// alu r=13 c=0 m=.....  i=....... 9 a=2:m_da[rx] d=4:m_da[ry]
	alu_eor(m_da[rx], m_da[ry]);
	// 0e7 btsr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=....... 1 a=4:m_da[ry] d=-1
	alu_and(m_da[ry], 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto btsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=13 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
btsr3:
	// 044 btsr3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=1 m=..z..  i=.....i. 1 a=18:m_da[ry] d=35:m_dcro
	alu_and(high16(m_da[ry]), 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::movep_w_das_dd_ip8() // 0108 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1d2 mpiw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 29a mpiw2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_8h(m_dbin, m_edb);
	// 368 mpiw3
	m_aob = m_au;
	m_ir = m_irc;
	m_au = m_pc + 4;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_8(m_dbin, m_edb);
	// 36a mpiw4
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_dd_ais_ip8() // 0110 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	[[fallthrough]]; case 5:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_dd_aips_ip8() // 0118 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_da[rx];
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=31:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	[[fallthrough]]; case 5:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_dd_pais_ip8() // 0120 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=31:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	[[fallthrough]]; case 5:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_dd_das_ip8() // 0128 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_dd_dais_ip8() // 0130 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... 9 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_dd_adr16_ip8() // 0138 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=31:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_dd_adr32_ip8() // 0139 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=31:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_dd_dpc_ip8() // 013a f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_dd_dpci_ip8() // 013b f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... 9 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_dd_imm_ip8() // 013c f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 0ab btsi1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16h(m_dt, high16(m_at));
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=none
	// 0e7 btsr2
	m_t = m_dcr & 0x10;
	m_alub = m_dt;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=9:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto btsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_dt, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
btsr3:
	// 044 btsr3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=23:m_dt d=36:m_dcro8
	alu_and8(high16(m_dt), 1 << (m_dcr & 7));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bchg_dd_ds_ip8() // 0140 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3ef bcsr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = m_da[rx];
	m_au = m_da[ry];
	// alu r=13 c=0 m=.....  i=....... 9 a=2:m_da[rx] d=4:m_da[ry]
	alu_eor(m_da[rx], m_da[ry]);
	// 06a bcsr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=13 c=2 m=.....  i=....... 9 a=4:m_da[ry] d=35:m_dcro
	alu_eor(m_da[ry], 1 << (m_dcr & 15));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto bcsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=13 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
bcsr3:
	// 084 bcsr3
	m_alub = high16(m_da[ry]);
	// alu r=13 c=2 m=.....  i=....... 9 a=18:m_da[ry] d=35:m_dcro
	alu_eor(high16(m_da[ry]), 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0a1 bcsr5
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	// alu r=13 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::movep_l_das_dd_ip8() // 0148 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1d6 mpil1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 29e mpil2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_8h(m_dbin, m_edb);
	// 34e mpil3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_8(m_dbin, m_edb);
	// 34f mpil4
	m_aob = m_au;
	set_16h(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_8h(m_dbin, m_edb);
	// 368 mpiw3
	m_aob = m_au;
	m_ir = m_irc;
	m_au = m_pc + 4;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_8(m_dbin, m_edb);
	// 36a mpiw4
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bchg_dd_ais_ip8() // 0150 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	[[fallthrough]]; case 5:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bchg_dd_aips_ip8() // 0158 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_da[rx];
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=31:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	[[fallthrough]]; case 5:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bchg_dd_pais_ip8() // 0160 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=31:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	[[fallthrough]]; case 5:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bchg_dd_das_ip8() // 0168 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bchg_dd_dais_ip8() // 0170 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... 9 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bchg_dd_adr16_ip8() // 0178 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=31:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bchg_dd_adr32_ip8() // 0179 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=31:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bclr_dd_ds_ip8() // 0180 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3eb bclr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = m_da[rx];
	m_au = m_da[ry];
	// alu r=14 c=0 m=.....  i=.l..... 8 a=2:m_da[rx] d=4:m_da[ry]
	alu_or(m_da[rx], m_da[ry]);
	// 06e bclr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=14 c=2 m=.....  i=.l..... 8 a=4:m_da[ry] d=35:m_dcro
	alu_or(m_da[ry], 1 << (m_dcr & 15));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto bclr3;
	else
		goto bclr4;
bclr4:
	// 0cc bclr4
	// alu r=14 c=4 m=.....  i=.l..... 9 a=33:m_aluo d=35:m_dcro
	alu_eor(m_aluo, 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.l...i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
bclr3:
	// 08c bclr3
	m_alub = high16(m_da[ry]);
	// alu r=14 c=2 m=.....  i=.l..... 8 a=18:m_da[ry] d=35:m_dcro
	alu_or(high16(m_da[ry]), 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0c8 bclr5
	// alu r=14 c=4 m=.....  i=.l..... 9 a=33:m_aluo d=35:m_dcro
	alu_eor(m_aluo, 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0a1 bcsr5
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.l...i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::movep_w_dd_das_ip8() // 0188 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1ca mpow1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 36d mpow2
	m_aob = m_au;
	m_ir = m_irc;
	set_8xh(m_dbout, m_da[rx]);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=2:m_da[rx]
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 36e mpow3
	m_aob = m_au;
	set_8xl(m_dbout, m_da[rx]);
	m_au = m_pc + 4;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bclr_dd_ais_ip8() // 0190 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=14 c=0 m=.....  i=bl..... 8 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	[[fallthrough]]; case 5:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bclr_dd_aips_ip8() // 0198 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_da[rx];
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=2:m_da[rx] d=31:m_dbin
	alu_or8(m_da[rx], m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	[[fallthrough]]; case 5:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bclr_dd_pais_ip8() // 01a0 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=2:m_da[rx] d=31:m_dbin
	alu_or8(m_da[rx], m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	[[fallthrough]]; case 5:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bclr_dd_das_ip8() // 01a8 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=bl..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=14 c=0 m=.....  i=bl..... 8 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bclr_dd_dais_ip8() // 01b0 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=14 c=5 m=.....  i=bl..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=14 c=0 m=.....  i=bl..... 8 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bclr_dd_adr16_ip8() // 01b8 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=2:m_da[rx] d=31:m_dbin
	alu_or8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bclr_dd_adr32_ip8() // 01b9 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=2:m_da[rx] d=31:m_dbin
	alu_or8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bset_dd_ds_ip8() // 01c0 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3ef bcsr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = m_da[rx];
	m_au = m_da[ry];
	// alu r=14 c=0 m=.....  i=....... 8 a=2:m_da[rx] d=4:m_da[ry]
	alu_or(m_da[rx], m_da[ry]);
	// 06a bcsr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=14 c=2 m=.....  i=....... 8 a=4:m_da[ry] d=35:m_dcro
	alu_or(m_da[ry], 1 << (m_dcr & 15));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto bcsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
bcsr3:
	// 084 bcsr3
	m_alub = high16(m_da[ry]);
	// alu r=14 c=2 m=.....  i=....... 8 a=18:m_da[ry] d=35:m_dcro
	alu_or(high16(m_da[ry]), 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0a1 bcsr5
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::movep_l_dd_das_ip8() // 01c8 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1ce mpol1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 36b mpol2
	m_aob = m_au;
	set_8xh(m_dbout, high16(m_da[rx]));
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=16:m_da[rx] d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 36c mpol3
	m_aob = m_au;
	set_8xl(m_dbout, high16(m_da[rx]));
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=16:m_da[rx] d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	// 36d mpow2
	m_aob = m_au;
	m_ir = m_irc;
	set_8xh(m_dbout, m_da[rx]);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=2:m_da[rx]
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	// 36e mpow3
	m_aob = m_au;
	set_8xl(m_dbout, m_da[rx]);
	m_au = m_pc + 4;
	// alu r=14 c=0 m=.....  i=....... 8 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bset_dd_ais_ip8() // 01d0 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=14 c=0 m=.....  i=b...... 8 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	[[fallthrough]]; case 5:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bset_dd_aips_ip8() // 01d8 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_da[rx];
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=b...... 8 a=2:m_da[rx] d=31:m_dbin
	alu_or8(m_da[rx], m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	[[fallthrough]]; case 5:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bset_dd_pais_ip8() // 01e0 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=b...... 8 a=2:m_da[rx] d=31:m_dbin
	alu_or8(m_da[rx], m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=14 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	[[fallthrough]]; case 5:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bset_dd_das_ip8() // 01e8 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=14 c=0 m=.....  i=b...... 8 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bset_dd_dais_ip8() // 01f0 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=14 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=b...... 8 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=14 c=0 m=.....  i=b...... 8 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bset_dd_adr16_ip8() // 01f8 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=b...... 8 a=2:m_da[rx] d=31:m_dbin
	alu_or8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bset_dd_adr32_ip8() // 01f9 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=b...... 8 a=2:m_da[rx] d=31:m_dbin
	alu_or8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_b_imm8_ds_ip8() // 0200 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=4 c=2 m=.nzvc  i=b....i. 1 a=9:m_dt d=4:m_da[ry]
	alu_and8(m_dt, m_da[ry]);
	sr_nzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=33:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_b_imm8_ais_ip8() // 0210 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=4 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=4 c=0 m=.....  i=b...... 1 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_b_imm8_aips_ip8() // 0218 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=4 c=0 m=.....  i=b...... 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_b_imm8_pais_ip8() // 0220 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=4 c=0 m=.....  i=b...... 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=4 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_b_imm8_das_ip8() // 0228 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=4 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=4 c=0 m=.....  i=b...... 1 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_b_imm8_dais_ip8() // 0230 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=4 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=4 c=0 m=.....  i=b...... 1 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=4 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=4 c=0 m=.....  i=b...... 1 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_b_imm8_adr16_ip8() // 0238 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=4 c=0 m=.....  i=b...... 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=4 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_b_imm8_adr32_ip8() // 0239 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=4 c=0 m=.....  i=b...... 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=4 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 15:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	[[fallthrough]]; case 17:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_imm8_ccr_ip8() // 023c ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1cc stiw1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_icount -= 2;
	// 307 stiw2
	// alu r=4 c=2 m=.....  i=b...... 1 a=37:m_ftu d=9:m_dt
	alu_and8(m_ftu, m_dt);
	m_icount -= 2;
	// 320 stiw3
	m_movemr = m_dbin;
	m_ftu = m_aluo;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=33:m_aluo d=none
	m_icount -= 2;
	// 321 stiw4
	m_sr = m_isr = (m_ftu & SR_CCR) | (m_sr & SR_SR);
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_icount -= 2;
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_w_imm16_ds_ip8() // 0240 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=4 c=2 m=.nzvc  i=.....i. 1 a=9:m_dt d=4:m_da[ry]
	alu_and(m_dt, m_da[ry]);
	sr_nzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=33:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_w_imm16_ais_ip8() // 0250 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=4 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=4 c=0 m=.....  i=....... 1 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_w_imm16_aips_ip8() // 0258 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_w_imm16_pais_ip8() // 0260 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=4 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_w_imm16_das_ip8() // 0268 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=4 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=4 c=0 m=.....  i=....... 1 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_w_imm16_dais_ip8() // 0270 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=4 c=5 m=.....  i=....... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=4 c=0 m=.....  i=....... 1 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=4 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=4 c=0 m=.....  i=....... 1 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_w_imm16_adr16_ip8() // 0278 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=4 c=0 m=.....  i=....... 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=4 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_w_imm16_adr32_ip8() // 0279 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=4 c=0 m=.....  i=....... 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=4 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_i16u_sr_ip8() // 027c ffff
{
	switch(m_inst_substate) {
	case 0:
	if(!(m_sr & SR_S)) {
		m_inst_state = S_PRIVILEDGE;
		return;
	}
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1cc stiw1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_icount -= 2;
	// 307 stiw2
	// alu r=4 c=2 m=.....  i=....... 1 a=37:m_ftu d=9:m_dt
	alu_and(m_ftu, m_dt);
	m_icount -= 2;
	// 320 stiw3
	m_movemr = m_dbin;
	m_ftu = m_aluo;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=33:m_aluo d=none
	m_icount -= 2;
	// 321 stiw4
	m_sr = m_isr = m_ftu & (SR_CCR|SR_SR);
	update_user_super();
	update_interrupt();
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_icount -= 2;
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_l_imm32_ds_ip8() // 0280 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 10c roal1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=4 c=2 m=.nzvc  i=.l...i. 1 a=9:m_dt d=4:m_da[ry]
	alu_and(m_dt, m_da[ry]);
	sr_nzvc();
	// 259 roal2
	set_16l(m_da[ry], m_aluo);
	// alu r=4 c=0 m=.....  i=.l..... 1 a=33:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 25a roal3
	// alu r=4 c=3 m=.nzvc  i=.l....f 1 a=23:m_dt d=18:m_da[ry]
	alu_and(high16(m_dt), high16(m_da[ry]));
	sr_nzvc_u();
	m_icount -= 2;
	// 25b roal4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=33:m_aluo d=none
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_l_imm32_ais_ip8() // 0290 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=4 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f 1 a=23:m_dt d=29:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_l_imm32_aips_ip8() // 0298 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=4 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=31:m_dbin
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f 1 a=23:m_dt d=29:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_l_imm32_pais_ip8() // 02a0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=4 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f 1 a=23:m_dt d=29:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_l_imm32_das_ip8() // 02a8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=4 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f 1 a=23:m_dt d=29:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_l_imm32_dais_ip8() // 02b0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e7 aixw0
	// alu r=4 c=5 m=.....  i=.l..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=4 c=0 m=.....  i=.l..... 1 a=33:m_aluo d=none
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 33:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 33;
		} else
			m_inst_substate = 34;
		return;
	}
	[[fallthrough]]; case 34:
	[[fallthrough]]; case 35:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 35;
		} else
			m_inst_substate = 36;
		return;
	}
	[[fallthrough]]; case 36:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=4 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f 1 a=23:m_dt d=29:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_l_imm32_adr16_ip8() // 02b8 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=4 c=0 m=.....  i=.l..... 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=4 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f 1 a=23:m_dt d=29:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::andi_l_imm32_adr32_ip8() // 02b9 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=4 c=0 m=.....  i=.l..... 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=4 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 25:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f 1 a=23:m_dt d=29:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 33:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 33;
		} else
			m_inst_substate = 34;
		return;
	}
	[[fallthrough]]; case 34:
	[[fallthrough]]; case 35:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 35;
		} else
			m_inst_substate = 36;
		return;
	}
	[[fallthrough]]; case 36:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_b_imm8_ds_ip8() // 0400 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=5 c=2 m=xnzvc  i=b....i. 2 a=9:m_dt d=4:m_da[ry]
	alu_sub8(m_dt, m_da[ry]);
	sr_xnzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_b_imm8_ais_ip8() // 0410 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=5 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_b_imm8_aips_ip8() // 0418 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=5 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_b_imm8_pais_ip8() // 0420 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=5 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_b_imm8_das_ip8() // 0428 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=5 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_b_imm8_dais_ip8() // 0430 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=5 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=5 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_b_imm8_adr16_ip8() // 0438 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=5 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_b_imm8_adr32_ip8() // 0439 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=5 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 15:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	[[fallthrough]]; case 17:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_w_imm16_ds_ip8() // 0440 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=5 c=2 m=xnzvc  i=.....i. 2 a=9:m_dt d=4:m_da[ry]
	alu_sub(m_dt, m_da[ry]);
	sr_xnzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_w_imm16_ais_ip8() // 0450 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=5 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_w_imm16_aips_ip8() // 0458 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + 2;
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=5 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_w_imm16_pais_ip8() // 0460 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - 2;
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=5 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_w_imm16_das_ip8() // 0468 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=5 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_w_imm16_dais_ip8() // 0470 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=5 c=5 m=.....  i=....... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=5 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_w_imm16_adr16_ip8() // 0478 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=5 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_w_imm16_adr32_ip8() // 0479 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=5 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_l_imm32_ds_ip8() // 0480 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 10c roal1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=5 c=2 m=xnzvc  i=.l...i. 2 a=9:m_dt d=4:m_da[ry]
	alu_sub(m_dt, m_da[ry]);
	sr_xnzvc();
	// 259 roal2
	set_16l(m_da[ry], m_aluo);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 25a roal3
	// alu r=5 c=3 m=xnzvc  i=.l....f 10 a=23:m_dt d=18:m_da[ry]
	alu_subc(high16(m_dt), high16(m_da[ry]));
	sr_xnzvc_u();
	m_icount -= 2;
	// 25b roal4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_l_imm32_ais_ip8() // 0490 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=5 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_l_imm32_aips_ip8() // 0498 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=5 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_l_imm32_pais_ip8() // 04a0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=5 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_l_imm32_das_ip8() // 04a8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=5 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_l_imm32_dais_ip8() // 04b0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e7 aixw0
	// alu r=5 c=5 m=.....  i=.l..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 33:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 33;
		} else
			m_inst_substate = 34;
		return;
	}
	[[fallthrough]]; case 34:
	[[fallthrough]]; case 35:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 35;
		} else
			m_inst_substate = 36;
		return;
	}
	[[fallthrough]]; case 36:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=5 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_l_imm32_adr16_ip8() // 04b8 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=5 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::subi_l_imm32_adr32_ip8() // 04b9 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=5 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 25:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 33:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 33;
		} else
			m_inst_substate = 34;
		return;
	}
	[[fallthrough]]; case 34:
	[[fallthrough]]; case 35:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 35;
		} else
			m_inst_substate = 36;
		return;
	}
	[[fallthrough]]; case 36:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_b_imm8_ds_ip8() // 0600 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=2 c=2 m=xnzvc  i=b....i. 4 a=9:m_dt d=4:m_da[ry]
	alu_add8(m_dt, m_da[ry]);
	sr_xnzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_b_imm8_ais_ip8() // 0610 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. 4 a=9:m_dt d=31:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_b_imm8_aips_ip8() // 0618 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. 4 a=9:m_dt d=31:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_b_imm8_pais_ip8() // 0620 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. 4 a=9:m_dt d=31:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_b_imm8_das_ip8() // 0628 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. 4 a=9:m_dt d=31:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_b_imm8_dais_ip8() // 0630 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. 4 a=9:m_dt d=31:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_b_imm8_adr16_ip8() // 0638 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. 4 a=9:m_dt d=31:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_b_imm8_adr32_ip8() // 0639 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. 4 a=9:m_dt d=31:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 15:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	[[fallthrough]]; case 17:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_w_imm16_ds_ip8() // 0640 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=2 c=2 m=xnzvc  i=.....i. 4 a=9:m_dt d=4:m_da[ry]
	alu_add(m_dt, m_da[ry]);
	sr_xnzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_w_imm16_ais_ip8() // 0650 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_w_imm16_aips_ip8() // 0658 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + 2;
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_w_imm16_pais_ip8() // 0660 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - 2;
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_w_imm16_das_ip8() // 0668 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_w_imm16_dais_ip8() // 0670 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=....... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_w_imm16_adr16_ip8() // 0678 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_w_imm16_adr32_ip8() // 0679 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_l_imm32_ds_ip8() // 0680 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 10c roal1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=2 c=2 m=xnzvc  i=.l...i. 4 a=9:m_dt d=4:m_da[ry]
	alu_add(m_dt, m_da[ry]);
	sr_xnzvc();
	// 259 roal2
	set_16l(m_da[ry], m_aluo);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 25a roal3
	// alu r=2 c=3 m=xnzvc  i=.l....f 11 a=23:m_dt d=18:m_da[ry]
	alu_addc(high16(m_dt), high16(m_da[ry]));
	sr_xnzvc_u();
	m_icount -= 2;
	// 25b roal4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_l_imm32_ais_ip8() // 0690 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f 11 a=23:m_dt d=29:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_l_imm32_aips_ip8() // 0698 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f 11 a=23:m_dt d=29:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_l_imm32_pais_ip8() // 06a0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f 11 a=23:m_dt d=29:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_l_imm32_das_ip8() // 06a8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f 11 a=23:m_dt d=29:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_l_imm32_dais_ip8() // 06b0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e7 aixw0
	// alu r=2 c=5 m=.....  i=.l..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 33:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 33;
		} else
			m_inst_substate = 34;
		return;
	}
	[[fallthrough]]; case 34:
	[[fallthrough]]; case 35:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 35;
		} else
			m_inst_substate = 36;
		return;
	}
	[[fallthrough]]; case 36:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f 11 a=23:m_dt d=29:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_l_imm32_adr16_ip8() // 06b8 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f 11 a=23:m_dt d=29:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::addi_l_imm32_adr32_ip8() // 06b9 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 25:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f 11 a=23:m_dt d=29:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 33:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 33;
		} else
			m_inst_substate = 34;
		return;
	}
	[[fallthrough]]; case 34:
	[[fallthrough]]; case 35:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 35;
		} else
			m_inst_substate = 36;
		return;
	}
	[[fallthrough]]; case 36:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_imm8_ds_ip8() // 0800 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 3e7 btsr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = m_dt;
	m_au = m_da[ry];
	// alu r=13 c=0 m=.....  i=....... 9 a=9:m_dt d=4:m_da[ry]
	alu_eor(m_dt, m_da[ry]);
	// 0e7 btsr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=....... 1 a=4:m_da[ry] d=-1
	alu_and(m_da[ry], 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto btsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=13 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
btsr3:
	// 044 btsr3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=1 m=..z..  i=.....i. 1 a=18:m_da[ry] d=35:m_dcro
	alu_and(high16(m_da[ry]), 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_imm8_ais_ip8() // 0810 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_imm8_aips_ip8() // 0818 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_imm8_pais_ip8() // 0820 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_imm8_das_ip8() // 0828 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_imm8_dais_ip8() // 0830 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... 9 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 15:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	[[fallthrough]]; case 17:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_imm8_adr16_ip8() // 0838 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_imm8_adr32_ip8() // 0839 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 15:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	[[fallthrough]]; case 17:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_imm8_dpc_ip8() // 083a ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::btst_imm8_dpci_ip8() // 083b ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... 9 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 15:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	[[fallthrough]]; case 17:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bchg_imm8_ds_ip8() // 0840 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 3ef bcsr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = m_dt;
	m_au = m_da[ry];
	// alu r=13 c=0 m=.....  i=....... 9 a=9:m_dt d=4:m_da[ry]
	alu_eor(m_dt, m_da[ry]);
	// 06a bcsr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=13 c=2 m=.....  i=....... 9 a=4:m_da[ry] d=35:m_dcro
	alu_eor(m_da[ry], 1 << (m_dcr & 15));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto bcsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=13 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
bcsr3:
	// 084 bcsr3
	m_alub = high16(m_da[ry]);
	// alu r=13 c=2 m=.....  i=....... 9 a=18:m_da[ry] d=35:m_dcro
	alu_eor(high16(m_da[ry]), 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0a1 bcsr5
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	// alu r=13 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bchg_imm8_ais_ip8() // 0850 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bchg_imm8_aips_ip8() // 0858 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bchg_imm8_pais_ip8() // 0860 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bchg_imm8_das_ip8() // 0868 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bchg_imm8_dais_ip8() // 0870 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... 9 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bchg_imm8_adr16_ip8() // 0878 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bchg_imm8_adr32_ip8() // 0879 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 15:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	[[fallthrough]]; case 17:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bclr_imm8_ds_ip8() // 0880 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 3eb bclr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = m_dt;
	m_au = m_da[ry];
	// alu r=14 c=0 m=.....  i=.l..... 8 a=9:m_dt d=4:m_da[ry]
	alu_or(m_dt, m_da[ry]);
	// 06e bclr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=14 c=2 m=.....  i=.l..... 8 a=4:m_da[ry] d=35:m_dcro
	alu_or(m_da[ry], 1 << (m_dcr & 15));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto bclr3;
	else
		goto bclr4;
bclr4:
	// 0cc bclr4
	// alu r=14 c=4 m=.....  i=.l..... 9 a=33:m_aluo d=35:m_dcro
	alu_eor(m_aluo, 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.l...i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
bclr3:
	// 08c bclr3
	m_alub = high16(m_da[ry]);
	// alu r=14 c=2 m=.....  i=.l..... 8 a=18:m_da[ry] d=35:m_dcro
	alu_or(high16(m_da[ry]), 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0c8 bclr5
	// alu r=14 c=4 m=.....  i=.l..... 9 a=33:m_aluo d=35:m_dcro
	alu_eor(m_aluo, 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0a1 bcsr5
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.l...i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bclr_imm8_ais_ip8() // 0890 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bclr_imm8_aips_ip8() // 0898 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bclr_imm8_pais_ip8() // 08a0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bclr_imm8_das_ip8() // 08a8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=bl..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bclr_imm8_dais_ip8() // 08b0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=14 c=5 m=.....  i=bl..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bclr_imm8_adr16_ip8() // 08b8 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bclr_imm8_adr32_ip8() // 08b9 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 15:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	[[fallthrough]]; case 17:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bset_imm8_ds_ip8() // 08c0 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 3ef bcsr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = m_dt;
	m_au = m_da[ry];
	// alu r=14 c=0 m=.....  i=....... 8 a=9:m_dt d=4:m_da[ry]
	alu_or(m_dt, m_da[ry]);
	// 06a bcsr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=14 c=2 m=.....  i=....... 8 a=4:m_da[ry] d=35:m_dcro
	alu_or(m_da[ry], 1 << (m_dcr & 15));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto bcsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
bcsr3:
	// 084 bcsr3
	m_alub = high16(m_da[ry]);
	// alu r=14 c=2 m=.....  i=....... 8 a=18:m_da[ry] d=35:m_dcro
	alu_or(high16(m_da[ry]), 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0a1 bcsr5
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bset_imm8_ais_ip8() // 08d0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bset_imm8_aips_ip8() // 08d8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bset_imm8_pais_ip8() // 08e0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=14 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bset_imm8_das_ip8() // 08e8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bset_imm8_dais_ip8() // 08f0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=14 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=b...... 8 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bset_imm8_adr16_ip8() // 08f8 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::bset_imm8_adr32_ip8() // 08f9 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 15:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	[[fallthrough]]; case 17:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_b_imm8_ds_ip8() // 0a00 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=13 c=2 m=.nzvc  i=b....i. 9 a=9:m_dt d=4:m_da[ry]
	alu_eor8(m_dt, m_da[ry]);
	sr_nzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=33:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_b_imm8_ais_ip8() // 0a10 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_b_imm8_aips_ip8() // 0a18 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_b_imm8_pais_ip8() // 0a20 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_b_imm8_das_ip8() // 0a28 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_b_imm8_dais_ip8() // 0a30 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... 9 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_b_imm8_adr16_ip8() // 0a38 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_b_imm8_adr32_ip8() // 0a39 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 15:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	[[fallthrough]]; case 17:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_imm8_ccr_ip8() // 0a3c ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1cc stiw1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_icount -= 2;
	// 307 stiw2
	// alu r=13 c=2 m=.....  i=b...... 9 a=37:m_ftu d=9:m_dt
	alu_eor8(m_ftu, m_dt);
	m_icount -= 2;
	// 320 stiw3
	m_movemr = m_dbin;
	m_ftu = m_aluo;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=33:m_aluo d=none
	m_icount -= 2;
	// 321 stiw4
	m_sr = m_isr = (m_ftu & SR_CCR) | (m_sr & SR_SR);
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_icount -= 2;
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_w_imm16_ds_ip8() // 0a40 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=13 c=2 m=.nzvc  i=.....i. 9 a=9:m_dt d=4:m_da[ry]
	alu_eor(m_dt, m_da[ry]);
	sr_nzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=33:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_w_imm16_ais_ip8() // 0a50 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=13 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=....... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_w_imm16_aips_ip8() // 0a58 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_w_imm16_pais_ip8() // 0a60 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=13 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_w_imm16_das_ip8() // 0a68 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=....... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_w_imm16_dais_ip8() // 0a70 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=....... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=....... 9 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=....... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_w_imm16_adr16_ip8() // 0a78 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=....... 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_w_imm16_adr32_ip8() // 0a79 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=....... 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_i16u_sr_ip8() // 0a7c ffff
{
	switch(m_inst_substate) {
	case 0:
	if(!(m_sr & SR_S)) {
		m_inst_state = S_PRIVILEDGE;
		return;
	}
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1cc stiw1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_icount -= 2;
	// 307 stiw2
	// alu r=13 c=2 m=.....  i=....... 9 a=37:m_ftu d=9:m_dt
	alu_eor(m_ftu, m_dt);
	m_icount -= 2;
	// 320 stiw3
	m_movemr = m_dbin;
	m_ftu = m_aluo;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=33:m_aluo d=none
	m_icount -= 2;
	// 321 stiw4
	m_sr = m_isr = m_ftu & (SR_CCR|SR_SR);
	update_user_super();
	update_interrupt();
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_icount -= 2;
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_l_imm32_ds_ip8() // 0a80 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 10c roal1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=13 c=2 m=.nzvc  i=.l...i. 9 a=9:m_dt d=4:m_da[ry]
	alu_eor(m_dt, m_da[ry]);
	sr_nzvc();
	// 259 roal2
	set_16l(m_da[ry], m_aluo);
	// alu r=13 c=0 m=.....  i=.l..... 9 a=33:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 25a roal3
	// alu r=13 c=3 m=.nzvc  i=.l....f 9 a=23:m_dt d=18:m_da[ry]
	alu_eor(high16(m_dt), high16(m_da[ry]));
	sr_nzvc_u();
	m_icount -= 2;
	// 25b roal4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=33:m_aluo d=none
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_l_imm32_ais_ip8() // 0a90 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=13 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f 9 a=23:m_dt d=29:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_l_imm32_aips_ip8() // 0a98 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=13 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=31:m_dbin
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f 9 a=23:m_dt d=29:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_l_imm32_pais_ip8() // 0aa0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=13 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f 9 a=23:m_dt d=29:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 21:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_l_imm32_das_ip8() // 0aa8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f 9 a=23:m_dt d=29:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_l_imm32_dais_ip8() // 0ab0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e7 aixw0
	// alu r=13 c=5 m=.....  i=.l..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=.l..... 9 a=33:m_aluo d=none
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 33:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 33;
		} else
			m_inst_substate = 34;
		return;
	}
	[[fallthrough]]; case 34:
	[[fallthrough]]; case 35:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 35;
		} else
			m_inst_substate = 36;
		return;
	}
	[[fallthrough]]; case 36:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f 9 a=23:m_dt d=29:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_l_imm32_adr16_ip8() // 0ab8 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=.l..... 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f 9 a=23:m_dt d=29:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 25:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::eori_l_imm32_adr32_ip8() // 0ab9 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=.l..... 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 25:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f 9 a=23:m_dt d=29:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 29:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 29;
		} else
			m_inst_substate = 30;
		return;
	}
	[[fallthrough]]; case 30:
	[[fallthrough]]; case 31:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 31;
		} else
			m_inst_substate = 32;
		return;
	}
	[[fallthrough]]; case 32:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 33:
	m_mmu8->write_data(m_aob & ~1, m_dbout >> 8);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 33;
		} else
			m_inst_substate = 34;
		return;
	}
	[[fallthrough]]; case 34:
	[[fallthrough]]; case 35:
	m_mmu8->write_data(m_aob | 1, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 35;
		} else
			m_inst_substate = 36;
		return;
	}
	[[fallthrough]]; case 36:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_b_imm8_ds_ip8() // 0c00 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 108 rcaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=6 c=2 m=.nzvc  i=b....i. 2 a=9:m_dt d=4:m_da[ry]
	alu_sub8(m_dt, m_da[ry]);
	sr_nzvc();
	// 23a rcaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_b_imm8_ais_ip8() // 0c10 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=6 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_b_imm8_aips_ip8() // 0c18 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=6 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_b_imm8_pais_ip8() // 0c20 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=6 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_b_imm8_das_ip8() // 0c28 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=6 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_b_imm8_dais_ip8() // 0c30 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=6 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 15:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	[[fallthrough]]; case 17:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=6 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_b_imm8_adr16_ip8() // 0c38 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=6 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_b_imm8_adr32_ip8() // 0c39 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=6 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 15:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	[[fallthrough]]; case 17:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_w_imm16_ds_ip8() // 0c40 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 108 rcaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=6 c=2 m=.nzvc  i=.....i. 2 a=9:m_dt d=4:m_da[ry]
	alu_sub(m_dt, m_da[ry]);
	sr_nzvc();
	// 23a rcaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_w_imm16_ais_ip8() // 0c50 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=6 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_w_imm16_aips_ip8() // 0c58 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + 2;
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=6 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_w_imm16_pais_ip8() // 0c60 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - 2;
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=6 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_w_imm16_das_ip8() // 0c68 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=6 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_w_imm16_dais_ip8() // 0c70 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=6 c=5 m=.....  i=....... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=6 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_w_imm16_adr16_ip8() // 0c78 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=6 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_w_imm16_adr32_ip8() // 0c79 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=6 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_l_imm32_ds_ip8() // 0c80 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	if(!m_cmpild_instr_callback.isnull()) (m_cmpild_instr_callback)(ry, (m_dt & 0xffff0000) | m_dbin);
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 104 rcal1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=6 c=2 m=.nzvc  i=.l...i. 2 a=9:m_dt d=4:m_da[ry]
	alu_sub(m_dt, m_da[ry]);
	sr_nzvc();
	// 239 rcal2
	// alu r=6 c=3 m=.nzvc  i=.l....f 10 a=23:m_dt d=18:m_da[ry]
	alu_subc(high16(m_dt), high16(m_da[ry]));
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 08d rcal3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_au = m_pc + 2;
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_l_imm32_ais_ip8() // 0c90 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=6 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_l_imm32_aips_ip8() // 0c98 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=6 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_l_imm32_pais_ip8() // 0ca0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=6 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_l_imm32_das_ip8() // 0ca8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=6 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_l_imm32_dais_ip8() // 0cb0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e7 aixw0
	// alu r=6 c=5 m=.....  i=.l..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 25:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=6 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_l_imm32_adr16_ip8() // 0cb8 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=6 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::cmpi_l_imm32_adr32_ip8() // 0cb9 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=6 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	[[fallthrough]]; case 19:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 21:
	m_edb = m_mmu8->read_data(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	[[fallthrough]]; case 23:
	m_edb |= m_mmu8->read_data(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 23;
		} else
			m_inst_substate = 24;
		return;
	}
	[[fallthrough]]; case 24:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 25:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 25;
		} else
			m_inst_substate = 26;
		return;
	}
	[[fallthrough]]; case 26:
	[[fallthrough]]; case 27:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 27;
		} else
			m_inst_substate = 28;
		return;
	}
	[[fallthrough]]; case 28:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::move_b_ds_dd_ip8() // 1000 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 121 rrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_at = m_da[ry];
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=4:m_da[ry] d=-1
	alu_and8(m_da[ry], 0xffff);
	sr_nzvc();
	// 27a rrgw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[rx], m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::move_b_ais_dd_ip8() // 1010 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	[[fallthrough]]; case 5:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::move_b_aips_dd_ip8() // 1018 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_da[rx];
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	[[fallthrough]]; case 5:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::move_b_pais_dd_ip8() // 1020 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	[[fallthrough]]; case 5:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::move_b_das_dd_ip8() // 1028 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::move_b_dais_dd_ip8() // 1030 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::move_b_adr16_dd_ip8() // 1038 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::move_b_adr32_dd_ip8() // 1039 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::move_b_dpc_dd_ip8() // 103a f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::move_b_dpci_dd_ip8() // 103b f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	[[fallthrough]]; case 13:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	[[fallthrough]]; case 9:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::move_b_imm8_dd_ip8() // 103c f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 121 rrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_at = m_dt;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=9:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	sr_nzvc();
	// 27a rrgw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[rx], m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::move_b_ds_aid_ip8() // 1080 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2fa rmrw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_da[ry]);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=4:m_da[ry] d=-1
	alu_and8(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 1:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	[[fallthrough]]; case 5:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::move_b_ais_aid_ip8() // 1090 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 3:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::move_b_aips_aid_ip8() // 1098 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = 0;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 3:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::move_b_pais_aid_ip8() // 10a0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = 0;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 3:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	[[fallthrough]]; case 7:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::move_b_das_aid_ip8() // 10a8 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::move_b_dais_aid_ip8() // 10b0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=bl..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	[[fallthrough]]; case 15:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu8->read_data(m_aob);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu8->write_data(m_aob, m_dbout);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	[[fallthrough]]; case 11:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68008_device::move_b_adr16_aid_ip8() // 10b8 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu8->read_program(m_aob & ~1) << 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	[[fallthrough]]; case 3:
	m_edb |= m_mmu8->read_program(m_aob | 1);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate