/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.recoverykey;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Named;
import javax.inject.Provider;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.DefaultSceneFactory;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxControllerKey;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlLoaderFactory;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.NewPasswordController;
import org.cryptomator.ui.common.PasswordStrengthUtil;
import org.cryptomator.ui.common.StageFactory;
import org.cryptomator.ui.recoverykey.RecoveryKeyCreationController;
import org.cryptomator.ui.recoverykey.RecoveryKeyDisplayController;
import org.cryptomator.ui.recoverykey.RecoveryKeyRecoverController;
import org.cryptomator.ui.recoverykey.RecoveryKeyResetPasswordController;
import org.cryptomator.ui.recoverykey.RecoveryKeyScoped;
import org.cryptomator.ui.recoverykey.RecoveryKeySuccessController;
import org.cryptomator.ui.recoverykey.RecoveryKeyWindow;

@Module
abstract class RecoveryKeyModule {
    RecoveryKeyModule() {
    }

    @Provides
    @RecoveryKeyWindow
    @RecoveryKeyScoped
    static FxmlLoaderFactory provideFxmlLoaderFactory(Map<Class<? extends FxController>, Provider<FxController>> factories, DefaultSceneFactory sceneFactory, ResourceBundle resourceBundle) {
        return new FxmlLoaderFactory(factories, sceneFactory, resourceBundle);
    }

    @Provides
    @RecoveryKeyWindow
    @RecoveryKeyScoped
    static Stage provideStage(StageFactory factory, ResourceBundle resourceBundle, @Named(value="keyRecoveryOwner") Stage owner) {
        Stage stage = factory.create();
        stage.setTitle(resourceBundle.getString("recoveryKey.title"));
        stage.setResizable(false);
        stage.initModality(Modality.WINDOW_MODAL);
        stage.initOwner((Window)owner);
        return stage;
    }

    @Provides
    @RecoveryKeyWindow
    @RecoveryKeyScoped
    static StringProperty provideRecoveryKeyProperty() {
        return new SimpleStringProperty();
    }

    @Provides
    @FxmlScene(value=FxmlFile.RECOVERYKEY_CREATE)
    @RecoveryKeyScoped
    static Scene provideRecoveryKeyCreationScene(@RecoveryKeyWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.RECOVERYKEY_CREATE);
    }

    @Provides
    @FxmlScene(value=FxmlFile.RECOVERYKEY_SUCCESS)
    @RecoveryKeyScoped
    static Scene provideRecoveryKeySuccessScene(@RecoveryKeyWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.RECOVERYKEY_SUCCESS);
    }

    @Provides
    @FxmlScene(value=FxmlFile.RECOVERYKEY_RECOVER)
    @RecoveryKeyScoped
    static Scene provideRecoveryKeyRecoverScene(@RecoveryKeyWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.RECOVERYKEY_RECOVER);
    }

    @Provides
    @FxmlScene(value=FxmlFile.RECOVERYKEY_RESET_PASSWORD)
    @RecoveryKeyScoped
    static Scene provideRecoveryKeyResetPasswordScene(@RecoveryKeyWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.RECOVERYKEY_RESET_PASSWORD);
    }

    @Binds
    @IntoMap
    @FxControllerKey(value=RecoveryKeyCreationController.class)
    abstract FxController bindRecoveryKeyCreationController(RecoveryKeyCreationController var1);

    @Provides
    @IntoMap
    @FxControllerKey(value=RecoveryKeyDisplayController.class)
    static FxController provideRecoveryKeyDisplayController(@RecoveryKeyWindow Stage window, @RecoveryKeyWindow Vault vault, @RecoveryKeyWindow StringProperty recoveryKey, ResourceBundle localization) {
        return new RecoveryKeyDisplayController(window, vault.getDisplayName(), (String)recoveryKey.get(), localization);
    }

    @Binds
    @IntoMap
    @FxControllerKey(value=RecoveryKeyRecoverController.class)
    abstract FxController provideRecoveryKeyRecoverController(RecoveryKeyRecoverController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=RecoveryKeySuccessController.class)
    abstract FxController bindRecoveryKeySuccessController(RecoveryKeySuccessController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=RecoveryKeyResetPasswordController.class)
    abstract FxController bindRecoveryKeyResetPasswordController(RecoveryKeyResetPasswordController var1);

    @Provides
    @IntoMap
    @FxControllerKey(value=NewPasswordController.class)
    static FxController provideNewPasswordController(ResourceBundle resourceBundle, PasswordStrengthUtil strengthRater) {
        return new NewPasswordController(resourceBundle, strengthRater);
    }
}

