/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.mainwindow;

import java.util.EnumSet;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.ListView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultListManager;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardComponent;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.mainwindow.MainWindow;
import org.cryptomator.ui.mainwindow.MainWindowScoped;
import org.cryptomator.ui.mainwindow.VaultListCellFactory;
import org.cryptomator.ui.removevault.RemoveVaultComponent;

@MainWindowScoped
public class VaultListController
implements FxController {
    private final Stage mainWindow;
    private final ObservableList<Vault> vaults;
    private final ObjectProperty<Vault> selectedVault;
    private final VaultListCellFactory cellFactory;
    private final AddVaultWizardComponent.Builder addVaultWizard;
    private final BooleanBinding emptyVaultList;
    private final RemoveVaultComponent.Builder removeVaultDialogue;
    public ListView<Vault> vaultList;

    @Inject
    VaultListController(@MainWindow Stage mainWindow, ObservableList<Vault> vaults, ObjectProperty<Vault> selectedVault, VaultListCellFactory cellFactory, AddVaultWizardComponent.Builder addVaultWizard, RemoveVaultComponent.Builder removeVaultDialogue) {
        this.mainWindow = mainWindow;
        this.vaults = vaults;
        this.selectedVault = selectedVault;
        this.cellFactory = cellFactory;
        this.addVaultWizard = addVaultWizard;
        this.removeVaultDialogue = removeVaultDialogue;
        this.emptyVaultList = Bindings.isEmpty(vaults);
        selectedVault.addListener(this::selectedVaultDidChange);
    }

    public void initialize() {
        this.vaultList.setItems(this.vaults);
        this.vaultList.setCellFactory((Callback)this.cellFactory);
        this.selectedVault.bind((ObservableValue)this.vaultList.getSelectionModel().selectedItemProperty());
        this.vaults.addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                Vault anyAddedVault = (Vault)c.getAddedSubList().get(0);
                this.vaultList.getSelectionModel().select((Object)anyAddedVault);
            }
        });
        this.vaultList.addEventFilter(MouseEvent.MOUSE_RELEASED, this::deselect);
        this.vaultList.addEventFilter(ContextMenuEvent.CONTEXT_MENU_REQUESTED, request -> {
            if (this.selectedVault.get() == null) {
                request.consume();
            }
        });
        this.vaultList.addEventFilter(KeyEvent.KEY_PRESSED, keyEvent -> {
            if (keyEvent.getCode() == KeyCode.DELETE) {
                this.pressedShortcutToRemoveVault();
                keyEvent.consume();
            }
        });
        if (SystemUtils.IS_OS_MAC) {
            this.vaultList.addEventFilter(KeyEvent.KEY_PRESSED, keyEvent -> {
                if (keyEvent.getCode() == KeyCode.BACK_SPACE) {
                    this.pressedShortcutToRemoveVault();
                    keyEvent.consume();
                }
            });
        }
        this.mainWindow.addEventFilter(KeyEvent.KEY_RELEASED, keyEvent -> {
            if (keyEvent.isShortcutDown() && keyEvent.getCode().isDigitKey()) {
                this.vaultList.getSelectionModel().select(Integer.parseInt(keyEvent.getText()) - 1);
                keyEvent.consume();
            }
        });
    }

    private void deselect(MouseEvent released) {
        if (released.getY() > (double)this.vaultList.getItems().size() * this.vaultList.fixedCellSizeProperty().get()) {
            this.vaultList.getSelectionModel().clearSelection();
            released.consume();
        }
    }

    private void selectedVaultDidChange(ObservableValue<? extends Vault> observableValue, Vault oldValue, Vault newValue) {
        if (newValue == null) {
            return;
        }
        VaultListManager.redetermineVaultState(newValue);
    }

    @FXML
    public void didClickAddVault() {
        this.addVaultWizard.build().showAddVaultWizard();
    }

    private void pressedShortcutToRemoveVault() {
        Vault vault = (Vault)this.selectedVault.get();
        if (vault != null && EnumSet.of(VaultState.Value.LOCKED, VaultState.Value.MISSING, VaultState.Value.ERROR, VaultState.Value.NEEDS_MIGRATION).contains((Object)vault.getState())) {
            this.removeVaultDialogue.vault(vault).build().showRemoveVault();
        }
    }

    public BooleanBinding emptyVaultListProperty() {
        return this.emptyVaultList;
    }

    public boolean isEmptyVaultList() {
        return this.emptyVaultList.get();
    }
}

