/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.launcher;

import dagger.Lazy;
import java.awt.Desktop;
import java.awt.SystemTray;
import java.util.Collection;
import java.util.Optional;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.integrations.tray.TrayIntegrationProvider;
import org.cryptomator.ui.fxapp.FxApplication;
import org.cryptomator.ui.launcher.AppLaunchEventHandler;
import org.cryptomator.ui.launcher.FxApplicationStarter;
import org.cryptomator.ui.traymenu.TrayMenuComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UiLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(UiLauncher.class);
    private final Settings settings;
    private final ObservableList<Vault> vaults;
    private final Lazy<TrayMenuComponent> trayMenu;
    private final FxApplicationStarter fxApplicationStarter;
    private final AppLaunchEventHandler launchEventHandler;
    private final Optional<TrayIntegrationProvider> trayIntegration;

    @Inject
    public UiLauncher(Settings settings, ObservableList<Vault> vaults, Lazy<TrayMenuComponent> trayMenu, FxApplicationStarter fxApplicationStarter, AppLaunchEventHandler launchEventHandler, Optional<TrayIntegrationProvider> trayIntegration) {
        this.settings = settings;
        this.vaults = vaults;
        this.trayMenu = trayMenu;
        this.fxApplicationStarter = fxApplicationStarter;
        this.launchEventHandler = launchEventHandler;
        this.trayIntegration = trayIntegration;
    }

    public void launch() {
        boolean hidden = this.settings.startHidden().get();
        if (SystemTray.isSupported() && this.settings.showTrayIcon().get()) {
            ((TrayMenuComponent)this.trayMenu.get()).initializeTrayIcon();
            this.launch(true, hidden);
        } else {
            this.launch(false, hidden);
        }
    }

    private void launch(boolean withTrayIcon, boolean hidden) {
        if (withTrayIcon && hidden) {
            LOG.debug("Hiding application...");
            this.trayIntegration.ifPresent(TrayIntegrationProvider::minimizedToTray);
        } else if (!withTrayIcon && hidden) {
            LOG.debug("Minimizing application...");
            this.showMainWindowAsync(true);
        } else {
            LOG.debug("Showing application...");
            this.showMainWindowAsync(false);
        }
        Desktop.getDesktop().addAppEventListener(e -> this.showMainWindowAsync(false));
        FilteredList vaultsToAutoUnlock = this.vaults.filtered(this::shouldAttemptAutoUnlock);
        if (!vaultsToAutoUnlock.isEmpty()) {
            this.fxApplicationStarter.get().thenAccept(arg_0 -> UiLauncher.lambda$launch$1((Collection)vaultsToAutoUnlock, arg_0));
        }
        this.launchEventHandler.startHandlingLaunchEvents();
    }

    private boolean shouldAttemptAutoUnlock(Vault vault) {
        return vault.isLocked() && vault.getVaultSettings().unlockAfterStartup().get();
    }

    private void showMainWindowAsync(boolean minimize) {
        this.fxApplicationStarter.get().thenCompose(FxApplication::showMainWindow).thenAccept(win -> win.setIconified(minimize));
    }

    private static /* synthetic */ void lambda$launch$1(Collection vaultsToAutoUnlock, FxApplication app) {
        for (Vault vault : vaultsToAutoUnlock) {
            app.startUnlockWorkflow(vault, Optional.empty());
        }
    }
}

