/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.keyloading.masterkeyfile;

import java.io.File;
import java.nio.file.Path;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import javafx.fxml.FXML;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.inject.Inject;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.UserInteractionLock;
import org.cryptomator.ui.keyloading.KeyLoading;
import org.cryptomator.ui.keyloading.KeyLoadingScoped;
import org.cryptomator.ui.keyloading.masterkeyfile.MasterkeyFileLoadingModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeyLoadingScoped
public class SelectMasterkeyFileController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(SelectMasterkeyFileController.class);
    private final Stage window;
    private final AtomicReference<Path> masterkeyPath;
    private final UserInteractionLock<MasterkeyFileLoadingModule.MasterkeyFileProvision> masterkeyFileProvisionLock;
    private final ResourceBundle resourceBundle;

    @Inject
    public SelectMasterkeyFileController(@KeyLoading Stage window, AtomicReference<Path> masterkeyPath, UserInteractionLock<MasterkeyFileLoadingModule.MasterkeyFileProvision> masterkeyFileProvisionLock, ResourceBundle resourceBundle) {
        this.window = window;
        this.masterkeyPath = masterkeyPath;
        this.masterkeyFileProvisionLock = masterkeyFileProvisionLock;
        this.resourceBundle = resourceBundle;
        this.window.setOnHiding(this::windowClosed);
    }

    @FXML
    public void cancel() {
        this.window.close();
    }

    private void windowClosed(WindowEvent windowEvent) {
        if (this.masterkeyFileProvisionLock.awaitingInteraction().get()) {
            LOG.debug("Unlock canceled by user.");
            this.masterkeyFileProvisionLock.interacted(MasterkeyFileLoadingModule.MasterkeyFileProvision.CANCELED);
        }
    }

    @FXML
    public void proceed() {
        LOG.trace("proceed()");
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(this.resourceBundle.getString("unlock.chooseMasterkey.filePickerTitle"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Cryptomator Masterkey", new String[]{"*.cryptomator"}));
        File masterkeyFile = fileChooser.showOpenDialog((Window)this.window);
        if (masterkeyFile != null) {
            LOG.debug("Chose masterkey file: {}", (Object)masterkeyFile);
            this.masterkeyPath.set(masterkeyFile.toPath());
            this.masterkeyFileProvisionLock.interacted(MasterkeyFileLoadingModule.MasterkeyFileProvision.MASTERKEYFILE_PROVIDED);
        }
    }
}

