/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.keyloading.masterkeyfile;

import com.google.common.base.Preconditions;
import dagger.Lazy;
import java.net.URI;
import java.nio.CharBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.api.MasterkeyLoadingFailedException;
import org.cryptomator.cryptolib.common.MasterkeyFileAccess;
import org.cryptomator.ui.common.Animations;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.UserInteractionLock;
import org.cryptomator.ui.keyloading.KeyLoading;
import org.cryptomator.ui.keyloading.KeyLoadingStrategy;
import org.cryptomator.ui.keyloading.masterkeyfile.MasterkeyFileLoadingFinisher;
import org.cryptomator.ui.keyloading.masterkeyfile.MasterkeyFileLoadingModule;
import org.cryptomator.ui.unlock.UnlockCancelledException;

@KeyLoading
public class MasterkeyFileLoadingStrategy
implements KeyLoadingStrategy {
    public static final String SCHEME = "masterkeyfile";
    private final Vault vault;
    private final MasterkeyFileAccess masterkeyFileAccess;
    private final Stage window;
    private final Lazy<Scene> passphraseEntryScene;
    private final Lazy<Scene> selectMasterkeyFileScene;
    private final UserInteractionLock<MasterkeyFileLoadingModule.PasswordEntry> passwordEntryLock;
    private final UserInteractionLock<MasterkeyFileLoadingModule.MasterkeyFileProvision> masterkeyFileProvisionLock;
    private final AtomicReference<char[]> password;
    private final AtomicReference<Path> filePath;
    private final MasterkeyFileLoadingFinisher finisher;
    private boolean wrongPassword;

    @Inject
    public MasterkeyFileLoadingStrategy(@KeyLoading Vault vault, MasterkeyFileAccess masterkeyFileAccess, @KeyLoading Stage window, @FxmlScene(value=FxmlFile.UNLOCK_ENTER_PASSWORD) Lazy<Scene> passphraseEntryScene, @FxmlScene(value=FxmlFile.UNLOCK_SELECT_MASTERKEYFILE) Lazy<Scene> selectMasterkeyFileScene, UserInteractionLock<MasterkeyFileLoadingModule.PasswordEntry> passwordEntryLock, UserInteractionLock<MasterkeyFileLoadingModule.MasterkeyFileProvision> masterkeyFileProvisionLock, AtomicReference<char[]> password, AtomicReference<Path> filePath, MasterkeyFileLoadingFinisher finisher) {
        this.vault = vault;
        this.masterkeyFileAccess = masterkeyFileAccess;
        this.window = window;
        this.passphraseEntryScene = passphraseEntryScene;
        this.selectMasterkeyFileScene = selectMasterkeyFileScene;
        this.passwordEntryLock = passwordEntryLock;
        this.masterkeyFileProvisionLock = masterkeyFileProvisionLock;
        this.password = password;
        this.filePath = filePath;
        this.finisher = finisher;
    }

    @Override
    public Masterkey loadKey(URI keyId) throws MasterkeyLoadingFailedException {
        Preconditions.checkArgument((boolean)SCHEME.equalsIgnoreCase(keyId.getScheme()), (Object)"Only supports keys with scheme masterkeyfile");
        try {
            Path filePath = this.vault.getPath().resolve(keyId.getSchemeSpecificPart());
            if (!Files.exists(filePath, new LinkOption[0])) {
                filePath = this.getAlternateMasterkeyFilePath();
            }
            CharSequence passphrase = this.getPassphrase();
            return this.masterkeyFileAccess.load(filePath, passphrase);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UnlockCancelledException("Unlock interrupted", e);
        }
    }

    @Override
    public boolean recoverFromException(MasterkeyLoadingFailedException exception) {
        if (exception instanceof InvalidPassphraseException) {
            this.wrongPassword = true;
            this.password.set(null);
            return true;
        }
        return false;
    }

    @Override
    public void cleanup(boolean unlockedSuccessfully) {
        this.finisher.cleanup(unlockedSuccessfully);
    }

    private Path getAlternateMasterkeyFilePath() throws UnlockCancelledException, InterruptedException {
        if (this.filePath.get() == null) {
            switch (this.askUserForMasterkeyFilePath()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case MASTERKEYFILE_PROVIDED: {
                    break;
                }
                case CANCELED: {
                    throw new UnlockCancelledException("Choosing masterkey file cancelled.");
                }
            }
            return this.filePath.get();
        }
        return this.filePath.get();
    }

    private MasterkeyFileLoadingModule.MasterkeyFileProvision askUserForMasterkeyFilePath() throws InterruptedException {
        Platform.runLater(() -> {
            this.window.setScene((Scene)this.selectMasterkeyFileScene.get());
            this.window.show();
            Window owner = this.window.getOwner();
            if (owner != null) {
                this.window.setX(owner.getX() + (owner.getWidth() - this.window.getWidth()) / 2.0);
                this.window.setY(owner.getY() + (owner.getHeight() - this.window.getHeight()) / 2.0);
            } else {
                this.window.centerOnScreen();
            }
        });
        return this.masterkeyFileProvisionLock.awaitInteraction();
    }

    private CharSequence getPassphrase() throws UnlockCancelledException, InterruptedException {
        if (this.password.get() == null) {
            switch (this.askForPassphrase()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case PASSWORD_ENTERED: {
                    break;
                }
                case CANCELED: {
                    throw new UnlockCancelledException("Password entry cancelled.");
                }
            }
            return CharBuffer.wrap(this.password.get());
        }
        return CharBuffer.wrap(this.password.get());
    }

    private MasterkeyFileLoadingModule.PasswordEntry askForPassphrase() throws InterruptedException {
        Platform.runLater(() -> {
            this.window.setScene((Scene)this.passphraseEntryScene.get());
            this.window.show();
            Window owner = this.window.getOwner();
            if (owner != null) {
                this.window.setX(owner.getX() + (owner.getWidth() - this.window.getWidth()) / 2.0);
                this.window.setY(owner.getY() + (owner.getHeight() - this.window.getHeight()) / 2.0);
            } else {
                this.window.centerOnScreen();
            }
            if (this.wrongPassword) {
                Animations.createShakeWindowAnimation((Window)this.window).play();
            }
        });
        return this.passwordEntryLock.awaitInteraction();
    }
}

