/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.health;

import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.EasyObservableList;
import com.tobiasdiez.easybind.Subscription;
import com.tobiasdiez.easybind.optional.OptionalBinding;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.beans.binding.Binding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import javax.inject.Inject;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.health.Check;
import org.cryptomator.ui.health.HealthCheckScoped;
import org.cryptomator.ui.health.Result;
import org.cryptomator.ui.health.ResultListCellFactory;

@HealthCheckScoped
public class CheckDetailController
implements FxController {
    private final EasyObservableList<Result> results;
    private final ObjectProperty<Check> check;
    private final OptionalBinding<Check.CheckState> checkState;
    private final Binding<String> checkName;
    private final Binding<Boolean> checkRunning;
    private final Binding<Boolean> checkScheduled;
    private final Binding<Boolean> checkFinished;
    private final Binding<Boolean> checkSkipped;
    private final Binding<Boolean> checkSucceeded;
    private final Binding<Boolean> checkFailed;
    private final Binding<Boolean> checkCancelled;
    private final Binding<Number> countOfWarnSeverity;
    private final Binding<Number> countOfCritSeverity;
    private final Binding<Boolean> warnOrCritsExist;
    private final ResultListCellFactory resultListCellFactory;
    public ListView<Result> resultsListView;
    private Subscription resultSubscription;

    @Inject
    public CheckDetailController(ObjectProperty<Check> selectedTask, ResultListCellFactory resultListCellFactory) {
        this.resultListCellFactory = resultListCellFactory;
        this.results = EasyBind.wrapList((ObservableList)FXCollections.observableArrayList());
        this.check = selectedTask;
        this.checkState = EasyBind.wrapNullable(selectedTask).mapObservable(Check::stateProperty);
        this.checkName = EasyBind.wrapNullable(selectedTask).map(Check::getName).orElse((Object)"");
        this.checkRunning = this.checkState.map(Check.CheckState.RUNNING::equals).orElse((Object)false);
        this.checkScheduled = this.checkState.map(Check.CheckState.SCHEDULED::equals).orElse((Object)false);
        this.checkSkipped = this.checkState.map(Check.CheckState.SKIPPED::equals).orElse((Object)false);
        this.checkSucceeded = this.checkState.map(Check.CheckState.SUCCEEDED::equals).orElse((Object)false);
        this.checkFailed = this.checkState.map(Check.CheckState.ERROR::equals).orElse((Object)false);
        this.checkCancelled = this.checkState.map(Check.CheckState.CANCELLED::equals).orElse((Object)false);
        this.checkFinished = EasyBind.combine(this.checkSucceeded, this.checkFailed, this.checkCancelled, (a, b, c) -> a != false || b != false || c != false);
        this.countOfWarnSeverity = this.results.reduce(this.countSeverity(DiagnosticResult.Severity.WARN));
        this.countOfCritSeverity = this.results.reduce(this.countSeverity(DiagnosticResult.Severity.CRITICAL));
        this.warnOrCritsExist = EasyBind.combine(this.checkSucceeded, this.countOfWarnSeverity, this.countOfCritSeverity, (suceeded, warns, crits) -> suceeded != false && (warns.longValue() > 0L || crits.longValue() > 0L));
        selectedTask.addListener(this::selectedTaskChanged);
    }

    private void selectedTaskChanged(ObservableValue<? extends Check> observable, Check oldValue, Check newValue) {
        if (this.resultSubscription != null) {
            this.resultSubscription.unsubscribe();
        }
        if (newValue != null) {
            this.resultSubscription = EasyBind.bindContent(this.results, newValue.getResults());
        }
    }

    private Function<Stream<? extends Result>, Long> countSeverity(DiagnosticResult.Severity severity) {
        return stream -> stream.filter(item -> severity.equals((Object)item.diagnosis().getSeverity())).count();
    }

    @FXML
    public void initialize() {
        this.resultsListView.setItems(this.results);
        this.resultsListView.setCellFactory((Callback)this.resultListCellFactory);
    }

    public String getCheckName() {
        return (String)this.checkName.getValue();
    }

    public Binding<String> checkNameProperty() {
        return this.checkName;
    }

    public long getCountOfWarnSeverity() {
        return ((Number)this.countOfWarnSeverity.getValue()).longValue();
    }

    public Binding<Number> countOfWarnSeverityProperty() {
        return this.countOfWarnSeverity;
    }

    public long getCountOfCritSeverity() {
        return ((Number)this.countOfCritSeverity.getValue()).longValue();
    }

    public Binding<Number> countOfCritSeverityProperty() {
        return this.countOfCritSeverity;
    }

    public boolean isCheckRunning() {
        return (Boolean)this.checkRunning.getValue();
    }

    public Binding<Boolean> checkRunningProperty() {
        return this.checkRunning;
    }

    public boolean isCheckFinished() {
        return (Boolean)this.checkFinished.getValue();
    }

    public Binding<Boolean> checkFinishedProperty() {
        return this.checkFinished;
    }

    public boolean isCheckScheduled() {
        return (Boolean)this.checkScheduled.getValue();
    }

    public Binding<Boolean> checkScheduledProperty() {
        return this.checkScheduled;
    }

    public boolean isCheckSkipped() {
        return (Boolean)this.checkSkipped.getValue();
    }

    public Binding<Boolean> checkSkippedProperty() {
        return this.checkSkipped;
    }

    public boolean isCheckSucceeded() {
        return (Boolean)this.checkSucceeded.getValue();
    }

    public Binding<Boolean> checkSucceededProperty() {
        return this.checkSucceeded;
    }

    public boolean isCheckFailed() {
        return (Boolean)this.checkFailed.getValue();
    }

    public Binding<Boolean> checkFailedProperty() {
        return this.checkFailed;
    }

    public boolean isCheckCancelled() {
        return (Boolean)this.checkCancelled.getValue();
    }

    public Binding<Boolean> warnOrCritsExistProperty() {
        return this.warnOrCritsExist;
    }

    public boolean isWarnOrCritsExist() {
        return (Boolean)this.warnOrCritsExist.getValue();
    }

    public Binding<Boolean> checkCancelledProperty() {
        return this.checkCancelled;
    }

    public ObjectProperty<Check> checkProperty() {
        return this.check;
    }

    public Check getCheck() {
        return (Check)this.check.get();
    }
}

