/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Provider;
import org.cryptomator.cryptofs.CopyOperation;
import org.cryptomator.cryptofs.CopyOperation_Factory;
import org.cryptomator.cryptofs.CryptoFileStore;
import org.cryptomator.cryptofs.CryptoFileStore_Factory;
import org.cryptomator.cryptofs.CryptoFileSystemComponent;
import org.cryptomator.cryptofs.CryptoFileSystemImpl;
import org.cryptomator.cryptofs.CryptoFileSystemImpl_Factory;
import org.cryptomator.cryptofs.CryptoFileSystemModule;
import org.cryptomator.cryptofs.CryptoFileSystemModule_ProvideNativeFileStoreFactory;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemProvider;
import org.cryptomator.cryptofs.CryptoFileSystemProviderComponent;
import org.cryptomator.cryptofs.CryptoFileSystemStats;
import org.cryptomator.cryptofs.CryptoFileSystemStats_Factory;
import org.cryptomator.cryptofs.CryptoFileSystems;
import org.cryptomator.cryptofs.CryptoFileSystems_Factory;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.CryptoPathFactory;
import org.cryptomator.cryptofs.CryptoPathFactory_Factory;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.CryptoPathMapper_Factory;
import org.cryptomator.cryptofs.DirectoryIdLoader;
import org.cryptomator.cryptofs.DirectoryIdLoader_Factory;
import org.cryptomator.cryptofs.DirectoryIdProvider;
import org.cryptomator.cryptofs.DirectoryIdProvider_Factory;
import org.cryptomator.cryptofs.EffectiveOpenOptions;
import org.cryptomator.cryptofs.GlobToRegexConverter;
import org.cryptomator.cryptofs.GlobToRegexConverter_Factory;
import org.cryptomator.cryptofs.LongFileNameProvider;
import org.cryptomator.cryptofs.LongFileNameProvider_Factory;
import org.cryptomator.cryptofs.MoveOperation;
import org.cryptomator.cryptofs.MoveOperation_Factory;
import org.cryptomator.cryptofs.PathMatcherFactory;
import org.cryptomator.cryptofs.PathMatcherFactory_Factory;
import org.cryptomator.cryptofs.ReadonlyFlag;
import org.cryptomator.cryptofs.ReadonlyFlag_Factory;
import org.cryptomator.cryptofs.Symlinks;
import org.cryptomator.cryptofs.Symlinks_Factory;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.attr.AttributeByNameProvider;
import org.cryptomator.cryptofs.attr.AttributeByNameProvider_Factory;
import org.cryptomator.cryptofs.attr.AttributeComponent;
import org.cryptomator.cryptofs.attr.AttributeModule_ProvideAttributesFactory;
import org.cryptomator.cryptofs.attr.AttributeModule_ProvideOpenCryptoFileFactory;
import org.cryptomator.cryptofs.attr.AttributeProvider;
import org.cryptomator.cryptofs.attr.AttributeProvider_Factory;
import org.cryptomator.cryptofs.attr.AttributeViewComponent;
import org.cryptomator.cryptofs.attr.AttributeViewModule_ProvideAttributeViewFactory;
import org.cryptomator.cryptofs.attr.AttributeViewProvider;
import org.cryptomator.cryptofs.attr.AttributeViewProvider_Factory;
import org.cryptomator.cryptofs.attr.CryptoBasicFileAttributeView_Factory;
import org.cryptomator.cryptofs.attr.CryptoDosFileAttributeView_Factory;
import org.cryptomator.cryptofs.attr.CryptoFileOwnerAttributeView_Factory;
import org.cryptomator.cryptofs.attr.CryptoPosixFileAttributeView_Factory;
import org.cryptomator.cryptofs.ch.ChannelCloseListener;
import org.cryptomator.cryptofs.ch.ChannelComponent;
import org.cryptomator.cryptofs.ch.CleartextFileChannel;
import org.cryptomator.cryptofs.ch.CleartextFileChannel_Factory;
import org.cryptomator.cryptofs.common.CiphertextFileType;
import org.cryptomator.cryptofs.common.FileSystemCapabilityChecker;
import org.cryptomator.cryptofs.common.FileSystemCapabilityChecker_Factory;
import org.cryptomator.cryptofs.common.FinallyUtil;
import org.cryptomator.cryptofs.common.FinallyUtil_Factory;
import org.cryptomator.cryptofs.dir.BrokenDirectoryFilter;
import org.cryptomator.cryptofs.dir.BrokenDirectoryFilter_Factory;
import org.cryptomator.cryptofs.dir.C9rConflictResolver;
import org.cryptomator.cryptofs.dir.C9rConflictResolver_Factory;
import org.cryptomator.cryptofs.dir.C9rDecryptor;
import org.cryptomator.cryptofs.dir.C9rDecryptor_Factory;
import org.cryptomator.cryptofs.dir.C9rProcessor;
import org.cryptomator.cryptofs.dir.C9rProcessor_Factory;
import org.cryptomator.cryptofs.dir.C9sInflator;
import org.cryptomator.cryptofs.dir.C9sInflator_Factory;
import org.cryptomator.cryptofs.dir.C9sProcessor;
import org.cryptomator.cryptofs.dir.C9sProcessor_Factory;
import org.cryptomator.cryptofs.dir.CiphertextDirectoryDeleter;
import org.cryptomator.cryptofs.dir.CiphertextDirectoryDeleter_Factory;
import org.cryptomator.cryptofs.dir.CryptoDirectoryStream;
import org.cryptomator.cryptofs.dir.CryptoDirectoryStream_Factory;
import org.cryptomator.cryptofs.dir.DirectoryStreamComponent;
import org.cryptomator.cryptofs.dir.DirectoryStreamFactory;
import org.cryptomator.cryptofs.dir.DirectoryStreamFactory_Factory;
import org.cryptomator.cryptofs.dir.NodeProcessor;
import org.cryptomator.cryptofs.dir.NodeProcessor_Factory;
import org.cryptomator.cryptofs.fh.ChunkCache;
import org.cryptomator.cryptofs.fh.ChunkCache_Factory;
import org.cryptomator.cryptofs.fh.ChunkIO;
import org.cryptomator.cryptofs.fh.ChunkIO_Factory;
import org.cryptomator.cryptofs.fh.ChunkLoader;
import org.cryptomator.cryptofs.fh.ChunkLoader_Factory;
import org.cryptomator.cryptofs.fh.ChunkSaver;
import org.cryptomator.cryptofs.fh.ChunkSaver_Factory;
import org.cryptomator.cryptofs.fh.ExceptionsDuringWrite;
import org.cryptomator.cryptofs.fh.ExceptionsDuringWrite_Factory;
import org.cryptomator.cryptofs.fh.FileCloseListener;
import org.cryptomator.cryptofs.fh.FileHeaderHolder;
import org.cryptomator.cryptofs.fh.FileHeaderHolder_Factory;
import org.cryptomator.cryptofs.fh.OpenCryptoFile;
import org.cryptomator.cryptofs.fh.OpenCryptoFileComponent;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideBasicFileAttributeViewSupplierFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideCurrentPathFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideFileSizeFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideLastModifiedDateFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideReadWriteLockFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFile_Factory;
import org.cryptomator.cryptofs.fh.OpenCryptoFiles;
import org.cryptomator.cryptofs.fh.OpenCryptoFiles_Factory;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileHeader;

@DaggerGenerated
final class DaggerCryptoFileSystemProviderComponent
implements CryptoFileSystemProviderComponent {
    private final DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent = this;
    private Provider<CryptoFileSystemComponent.Builder> cryptoFileSystemComponentBuilderProvider;
    private Provider<FileSystemCapabilityChecker> fileSystemCapabilityCheckerProvider;
    private Provider<SecureRandom> csprngProvider;
    private Provider<CryptoFileSystems> cryptoFileSystemsProvider;
    private Provider<CopyOperation> copyOperationProvider;
    private Provider<MoveOperation> moveOperationProvider;
    private Provider<GlobToRegexConverter> globToRegexConverterProvider;
    private Provider<PathMatcherFactory> pathMatcherFactoryProvider;
    private Provider<FinallyUtil> finallyUtilProvider;

    private DaggerCryptoFileSystemProviderComponent(SecureRandom csprngParam) {
        this.initialize(csprngParam);
    }

    public static CryptoFileSystemProviderComponent.Builder builder() {
        return new Builder();
    }

    private void initialize(SecureRandom csprngParam) {
        this.cryptoFileSystemComponentBuilderProvider = new Provider<CryptoFileSystemComponent.Builder>(){

            public CryptoFileSystemComponent.Builder get() {
                return new CryptoFileSystemComponentBuilder(DaggerCryptoFileSystemProviderComponent.this.cryptoFileSystemProviderComponent);
            }
        };
        this.fileSystemCapabilityCheckerProvider = DoubleCheck.provider((Provider)FileSystemCapabilityChecker_Factory.create());
        this.csprngProvider = InstanceFactory.create((Object)csprngParam);
        this.cryptoFileSystemsProvider = DoubleCheck.provider((Provider)CryptoFileSystems_Factory.create(this.cryptoFileSystemComponentBuilderProvider, this.fileSystemCapabilityCheckerProvider, this.csprngProvider));
        this.copyOperationProvider = DoubleCheck.provider((Provider)CopyOperation_Factory.create());
        this.moveOperationProvider = DoubleCheck.provider((Provider)MoveOperation_Factory.create(this.copyOperationProvider));
        this.globToRegexConverterProvider = DoubleCheck.provider((Provider)GlobToRegexConverter_Factory.create());
        this.pathMatcherFactoryProvider = DoubleCheck.provider((Provider)PathMatcherFactory_Factory.create(this.globToRegexConverterProvider));
        this.finallyUtilProvider = DoubleCheck.provider((Provider)FinallyUtil_Factory.create());
    }

    @Override
    public CryptoFileSystems fileSystems() {
        return (CryptoFileSystems)this.cryptoFileSystemsProvider.get();
    }

    @Override
    public MoveOperation moveOperation() {
        return (MoveOperation)this.moveOperationProvider.get();
    }

    @Override
    public CopyOperation copyOperation() {
        return (CopyOperation)this.copyOperationProvider.get();
    }

    private static final class Builder
    implements CryptoFileSystemProviderComponent.Builder {
        private SecureRandom csprng;

        private Builder() {
        }

        @Override
        public Builder csprng(SecureRandom csprng) {
            this.csprng = (SecureRandom)Preconditions.checkNotNull((Object)csprng);
            return this;
        }

        @Override
        public CryptoFileSystemProviderComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.csprng, SecureRandom.class);
            return new DaggerCryptoFileSystemProviderComponent(this.csprng);
        }
    }

    private static final class CryptoFileSystemComponentImpl
    implements CryptoFileSystemComponent {
        private final DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent;
        private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl = this;
        private Provider<CryptoFileSystemProvider> providerProvider;
        private Provider<Path> pathToVaultProvider;
        private Provider<Cryptor> cryptorProvider;
        private Provider<Optional<FileStore>> provideNativeFileStoreProvider;
        private Provider<CryptoFileSystemProperties> propertiesProvider;
        private Provider<ReadonlyFlag> readonlyFlagProvider;
        private Provider<CryptoFileStore> cryptoFileStoreProvider;
        private Provider<CryptoFileSystemStats> cryptoFileSystemStatsProvider;
        private Provider<DirectoryIdLoader> directoryIdLoaderProvider;
        private Provider<DirectoryIdProvider> directoryIdProvider;
        private Provider<LongFileNameProvider> longFileNameProvider;
        private Provider<VaultConfig> vaultConfigProvider;
        private Provider<CryptoPathMapper> cryptoPathMapperProvider;
        private Provider<OpenCryptoFileComponent.Builder> openCryptoFileComponentBuilderProvider;
        private Provider<OpenCryptoFiles> openCryptoFilesProvider;
        private Provider<Symlinks> symlinksProvider;
        private Provider<CryptoPathFactory> cryptoPathFactoryProvider;
        private Provider<DirectoryStreamComponent.Builder> directoryStreamComponentBuilderProvider;
        private Provider<DirectoryStreamFactory> directoryStreamFactoryProvider;
        private Provider<AttributeComponent.Builder> attributeComponentBuilderProvider;
        private Provider<AttributeProvider> attributeProvider;
        private Provider<AttributeViewComponent.Builder> attributeViewComponentBuilderProvider;
        private Provider<AttributeViewProvider> attributeViewProvider;
        private Provider<AttributeByNameProvider> attributeByNameProvider;
        private Provider<CiphertextDirectoryDeleter> ciphertextDirectoryDeleterProvider;
        private Provider<CryptoFileSystemImpl> cryptoFileSystemImplProvider;

        private CryptoFileSystemComponentImpl(DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent, CryptoFileSystemModule cryptoFileSystemModuleParam, Cryptor cryptorParam, VaultConfig vaultConfigParam, CryptoFileSystemProvider providerParam, Path pathToVaultParam, CryptoFileSystemProperties propertiesParam) {
            this.cryptoFileSystemProviderComponent = cryptoFileSystemProviderComponent;
            this.initialize(cryptoFileSystemModuleParam, cryptorParam, vaultConfigParam, providerParam, pathToVaultParam, propertiesParam);
        }

        private void initialize(CryptoFileSystemModule cryptoFileSystemModuleParam, Cryptor cryptorParam, VaultConfig vaultConfigParam, CryptoFileSystemProvider providerParam, Path pathToVaultParam, CryptoFileSystemProperties propertiesParam) {
            this.providerProvider = InstanceFactory.create((Object)providerParam);
            this.pathToVaultProvider = InstanceFactory.create((Object)pathToVaultParam);
            this.cryptorProvider = InstanceFactory.create((Object)cryptorParam);
            this.provideNativeFileStoreProvider = DoubleCheck.provider((Provider)CryptoFileSystemModule_ProvideNativeFileStoreFactory.create(cryptoFileSystemModuleParam, this.pathToVaultProvider));
            this.propertiesProvider = InstanceFactory.create((Object)propertiesParam);
            this.readonlyFlagProvider = DoubleCheck.provider((Provider)ReadonlyFlag_Factory.create(this.propertiesProvider));
            this.cryptoFileStoreProvider = DoubleCheck.provider((Provider)CryptoFileStore_Factory.create(this.provideNativeFileStoreProvider, this.readonlyFlagProvider));
            this.cryptoFileSystemStatsProvider = DoubleCheck.provider((Provider)CryptoFileSystemStats_Factory.create());
            this.directoryIdLoaderProvider = DoubleCheck.provider((Provider)DirectoryIdLoader_Factory.create());
            this.directoryIdProvider = DoubleCheck.provider((Provider)DirectoryIdProvider_Factory.create(this.directoryIdLoaderProvider));
            this.longFileNameProvider = DoubleCheck.provider((Provider)LongFileNameProvider_Factory.create(this.readonlyFlagProvider));
            this.vaultConfigProvider = InstanceFactory.create((Object)vaultConfigParam);
            this.cryptoPathMapperProvider = DoubleCheck.provider((Provider)CryptoPathMapper_Factory.create(this.pathToVaultProvider, this.cryptorProvider, this.directoryIdProvider, this.longFileNameProvider, this.vaultConfigProvider));
            this.openCryptoFileComponentBuilderProvider = new Provider<OpenCryptoFileComponent.Builder>(){

                public OpenCryptoFileComponent.Builder get() {
                    return new OpenCryptoFileComponentBuilder(cryptoFileSystemProviderComponent, cryptoFileSystemComponentImpl);
                }
            };
            this.openCryptoFilesProvider = DoubleCheck.provider((Provider)OpenCryptoFiles_Factory.create(this.openCryptoFileComponentBuilderProvider));
            this.symlinksProvider = DoubleCheck.provider((Provider)Symlinks_Factory.create(this.cryptoPathMapperProvider, this.longFileNameProvider, this.openCryptoFilesProvider, this.readonlyFlagProvider));
            this.cryptoPathFactoryProvider = DoubleCheck.provider((Provider)CryptoPathFactory_Factory.create(this.symlinksProvider));
            this.directoryStreamComponentBuilderProvider = new Provider<DirectoryStreamComponent.Builder>(){

                public DirectoryStreamComponent.Builder get() {
                    return new DirectoryStreamComponentBuilder(cryptoFileSystemProviderComponent, cryptoFileSystemComponentImpl);
                }
            };
            this.directoryStreamFactoryProvider = DoubleCheck.provider((Provider)DirectoryStreamFactory_Factory.create(this.cryptoPathMapperProvider, this.directoryStreamComponentBuilderProvider));
            this.attributeComponentBuilderProvider = new Provider<AttributeComponent.Builder>(){

                public AttributeComponent.Builder get() {
                    return new AttributeComponentBuilder(cryptoFileSystemProviderComponent, cryptoFileSystemComponentImpl);
                }
            };
            this.attributeProvider = DoubleCheck.provider((Provider)AttributeProvider_Factory.create(this.attributeComponentBuilderProvider, this.cryptoPathMapperProvider, this.symlinksProvider));
            this.attributeViewComponentBuilderProvider = new Provider<AttributeViewComponent.Builder>(){

                public AttributeViewComponent.Builder get() {
                    return new AttributeViewComponentBuilder(cryptoFileSystemProviderComponent, cryptoFileSystemComponentImpl);
                }
            };
            this.attributeViewProvider = DoubleCheck.provider((Provider)AttributeViewProvider_Factory.create(this.attributeViewComponentBuilderProvider));
            this.attributeByNameProvider = DoubleCheck.provider((Provider)AttributeByNameProvider_Factory.create(this.attributeProvider, this.attributeViewProvider));
            this.ciphertextDirectoryDeleterProvider = DoubleCheck.provider((Provider)CiphertextDirectoryDeleter_Factory.create(this.directoryStreamFactoryProvider));
            this.cryptoFileSystemImplProvider = DoubleCheck.provider((Provider)CryptoFileSystemImpl_Factory.create(this.providerProvider, this.cryptoFileSystemProviderComponent.cryptoFileSystemsProvider, this.pathToVaultProvider, this.cryptorProvider, this.cryptoFileStoreProvider, this.cryptoFileSystemStatsProvider, this.cryptoPathMapperProvider, this.cryptoPathFactoryProvider, this.cryptoFileSystemProviderComponent.pathMatcherFactoryProvider, this.directoryStreamFactoryProvider, this.directoryIdProvider, this.attributeProvider, this.attributeByNameProvider, this.attributeViewProvider, this.openCryptoFilesProvider, this.symlinksProvider, this.cryptoFileSystemProviderComponent.finallyUtilProvider, this.ciphertextDirectoryDeleterProvider, this.readonlyFlagProvider, this.propertiesProvider));
        }

        @Override
        public CryptoFileSystemImpl cryptoFileSystem() {
            return (CryptoFileSystemImpl)this.cryptoFileSystemImplProvider.get();
        }

        private static final class AttributeViewComponentImpl
        implements AttributeViewComponent {
            private final DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent;
            private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;
            private final AttributeViewComponentImpl attributeViewComponentImpl = this;
            private Provider<CryptoPath> cleartextPathProvider;
            private Provider<LinkOption[]> linkOptionsProvider;
            private Provider cryptoBasicFileAttributeViewProvider;
            private Provider cryptoPosixFileAttributeViewProvider;
            private Provider cryptoDosFileAttributeViewProvider;
            private Provider cryptoFileOwnerAttributeViewProvider;
            private Provider<Map<Class<?>, Provider<FileAttributeView>>> mapOfClassOfAndProviderOfFileAttributeViewProvider;
            private Provider<Class<? extends FileAttributeView>> viewTypeProvider;
            private Provider<Optional<FileAttributeView>> provideAttributeViewProvider;

            private AttributeViewComponentImpl(DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl, CryptoPath cleartextPathParam, Class<? extends FileAttributeView> viewTypeParam, LinkOption[] linkOptionsParam) {
                this.cryptoFileSystemProviderComponent = cryptoFileSystemProviderComponent;
                this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
                this.initialize(cleartextPathParam, viewTypeParam, linkOptionsParam);
            }

            private void initialize(CryptoPath cleartextPathParam, Class<? extends FileAttributeView> viewTypeParam, LinkOption[] linkOptionsParam) {
                this.cleartextPathProvider = InstanceFactory.create((Object)cleartextPathParam);
                this.linkOptionsProvider = InstanceFactory.create((Object)linkOptionsParam);
                this.cryptoBasicFileAttributeViewProvider = DoubleCheck.provider((Provider)CryptoBasicFileAttributeView_Factory.create(this.cleartextPathProvider, this.cryptoFileSystemComponentImpl.cryptoPathMapperProvider, this.linkOptionsProvider, this.cryptoFileSystemComponentImpl.symlinksProvider, this.cryptoFileSystemComponentImpl.openCryptoFilesProvider, this.cryptoFileSystemComponentImpl.attributeProvider, this.cryptoFileSystemComponentImpl.readonlyFlagProvider));
                this.cryptoPosixFileAttributeViewProvider = DoubleCheck.provider((Provider)CryptoPosixFileAttributeView_Factory.create(this.cleartextPathProvider, this.cryptoFileSystemComponentImpl.cryptoPathMapperProvider, this.linkOptionsProvider, this.cryptoFileSystemComponentImpl.symlinksProvider, this.cryptoFileSystemComponentImpl.openCryptoFilesProvider, this.cryptoFileSystemComponentImpl.attributeProvider, this.cryptoFileSystemComponentImpl.readonlyFlagProvider));
                this.cryptoDosFileAttributeViewProvider = DoubleCheck.provider((Provider)CryptoDosFileAttributeView_Factory.create(this.cleartextPathProvider, this.cryptoFileSystemComponentImpl.cryptoPathMapperProvider, this.linkOptionsProvider, this.cryptoFileSystemComponentImpl.symlinksProvider, this.cryptoFileSystemComponentImpl.openCryptoFilesProvider, this.cryptoFileSystemComponentImpl.attributeProvider, this.cryptoFileSystemComponentImpl.readonlyFlagProvider));
                this.cryptoFileOwnerAttributeViewProvider = DoubleCheck.provider((Provider)CryptoFileOwnerAttributeView_Factory.create(this.cleartextPathProvider, this.cryptoFileSystemComponentImpl.cryptoPathMapperProvider, this.linkOptionsProvider, this.cryptoFileSystemComponentImpl.symlinksProvider, this.cryptoFileSystemComponentImpl.openCryptoFilesProvider, this.cryptoFileSystemComponentImpl.readonlyFlagProvider));
                this.mapOfClassOfAndProviderOfFileAttributeViewProvider = MapProviderFactory.builder((int)4).put(BasicFileAttributeView.class, this.cryptoBasicFileAttributeViewProvider).put(PosixFileAttributeView.class, this.cryptoPosixFileAttributeViewProvider).put(DosFileAttributeView.class, this.cryptoDosFileAttributeViewProvider).put(FileOwnerAttributeView.class, this.cryptoFileOwnerAttributeViewProvider).build();
                this.viewTypeProvider = InstanceFactory.create(viewTypeParam);
                this.provideAttributeViewProvider = DoubleCheck.provider((Provider)AttributeViewModule_ProvideAttributeViewFactory.create(this.mapOfClassOfAndProviderOfFileAttributeViewProvider, this.viewTypeProvider));
            }

            @Override
            public Optional<FileAttributeView> attributeView() {
                return (Optional)this.provideAttributeViewProvider.get();
            }
        }

        private static final class AttributeViewComponentBuilder
        implements AttributeViewComponent.Builder {
            private final DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent;
            private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;
            private CryptoPath cleartextPath;
            private Class<? extends FileAttributeView> viewType;
            private LinkOption[] linkOptions;

            private AttributeViewComponentBuilder(DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl) {
                this.cryptoFileSystemProviderComponent = cryptoFileSystemProviderComponent;
                this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
            }

            @Override
            public AttributeViewComponentBuilder cleartextPath(CryptoPath cleartextPath) {
                this.cleartextPath = (CryptoPath)Preconditions.checkNotNull((Object)cleartextPath);
                return this;
            }

            @Override
            public AttributeViewComponentBuilder viewType(Class<? extends FileAttributeView> type) {
                this.viewType = (Class)Preconditions.checkNotNull(type);
                return this;
            }

            @Override
            public AttributeViewComponentBuilder linkOptions(LinkOption[] linkOptions) {
                this.linkOptions = (LinkOption[])Preconditions.checkNotNull((Object)linkOptions);
                return this;
            }

            @Override
            public AttributeViewComponent build() {
                Preconditions.checkBuilderRequirement((Object)this.cleartextPath, CryptoPath.class);
                Preconditions.checkBuilderRequirement(this.viewType, Class.class);
                Preconditions.checkBuilderRequirement((Object)this.linkOptions, LinkOption[].class);
                return new AttributeViewComponentImpl(this.cryptoFileSystemProviderComponent, this.cryptoFileSystemComponentImpl, this.cleartextPath, this.viewType, this.linkOptions);
            }
        }

        private static final class AttributeComponentImpl
        implements AttributeComponent {
            private final DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent;
            private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;
            private final AttributeComponentImpl attributeComponentImpl = this;
            private Provider<BasicFileAttributes> ciphertextAttributesProvider;
            private Provider<CiphertextFileType> ciphertextFileTypeProvider;
            private Provider<Path> ciphertextPathProvider;
            private Provider<Optional<OpenCryptoFile>> provideOpenCryptoFileProvider;
            private Provider<BasicFileAttributes> provideAttributesProvider;

            private AttributeComponentImpl(DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl, Path ciphertextPathParam, CiphertextFileType ciphertextFileTypeParam, BasicFileAttributes ciphertextAttributesParam) {
                this.cryptoFileSystemProviderComponent = cryptoFileSystemProviderComponent;
                this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
                this.initialize(ciphertextPathParam, ciphertextFileTypeParam, ciphertextAttributesParam);
            }

            private void initialize(Path ciphertextPathParam, CiphertextFileType ciphertextFileTypeParam, BasicFileAttributes ciphertextAttributesParam) {
                this.ciphertextAttributesProvider = InstanceFactory.create((Object)ciphertextAttributesParam);
                this.ciphertextFileTypeProvider = InstanceFactory.create((Object)((Object)ciphertextFileTypeParam));
                this.ciphertextPathProvider = InstanceFactory.create((Object)ciphertextPathParam);
                this.provideOpenCryptoFileProvider = DoubleCheck.provider((Provider)AttributeModule_ProvideOpenCryptoFileFactory.create(this.cryptoFileSystemComponentImpl.openCryptoFilesProvider, this.ciphertextPathProvider));
                this.provideAttributesProvider = DoubleCheck.provider((Provider)AttributeModule_ProvideAttributesFactory.create(this.ciphertextAttributesProvider, this.ciphertextFileTypeProvider, this.ciphertextPathProvider, this.cryptoFileSystemComponentImpl.cryptorProvider, this.provideOpenCryptoFileProvider, this.cryptoFileSystemComponentImpl.propertiesProvider));
            }

            @Override
            public BasicFileAttributes attributes() {
                return (BasicFileAttributes)this.provideAttributesProvider.get();
            }
        }

        private static final class AttributeComponentBuilder
        implements AttributeComponent.Builder {
            private final DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent;
            private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;
            private Path ciphertextPath;
            private CiphertextFileType ciphertextFileType;
            private BasicFileAttributes ciphertextAttributes;

            private AttributeComponentBuilder(DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl) {
                this.cryptoFileSystemProviderComponent = cryptoFileSystemProviderComponent;
                this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
            }

            @Override
            public AttributeComponentBuilder ciphertextPath(Path ciphertextPath) {
                this.ciphertextPath = (Path)Preconditions.checkNotNull((Object)ciphertextPath);
                return this;
            }

            @Override
            public AttributeComponentBuilder ciphertextFileType(CiphertextFileType ciphertextFileType) {
                this.ciphertextFileType = (CiphertextFileType)((Object)Preconditions.checkNotNull((Object)((Object)ciphertextFileType)));
                return this;
            }

            @Override
            public AttributeComponentBuilder ciphertextAttributes(BasicFileAttributes ciphertextAttributes) {
                this.ciphertextAttributes = (BasicFileAttributes)Preconditions.checkNotNull((Object)ciphertextAttributes);
                return this;
            }

            @Override
            public AttributeComponent build() {
                Preconditions.checkBuilderRequirement((Object)this.ciphertextPath, Path.class);
                Preconditions.checkBuilderRequirement((Object)((Object)this.ciphertextFileType), CiphertextFileType.class);
                Preconditions.checkBuilderRequirement((Object)this.ciphertextAttributes, BasicFileAttributes.class);
                return new AttributeComponentImpl(this.cryptoFileSystemProviderComponent, this.cryptoFileSystemComponentImpl, this.ciphertextPath, this.ciphertextFileType, this.ciphertextAttributes);
            }
        }

        private static final class DirectoryStreamComponentImpl
        implements DirectoryStreamComponent {
            private final DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent;
            private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;
            private final DirectoryStreamComponentImpl directoryStreamComponentImpl = this;
            private Provider<String> dirIdProvider;
            private Provider<DirectoryStream<Path>> ciphertextDirectoryStreamProvider;
            private Provider<Path> cleartextPathProvider;
            private Provider<DirectoryStream.Filter<? super Path>> filterProvider;
            private Provider<Consumer<CryptoDirectoryStream>> onCloseProvider;
            private Provider c9rDecryptorProvider;
            private Provider c9rConflictResolverProvider;
            private Provider c9rProcessorProvider;
            private Provider c9sInflatorProvider;
            private Provider c9sProcessorProvider;
            private Provider brokenDirectoryFilterProvider;
            private Provider nodeProcessorProvider;
            private Provider<CryptoDirectoryStream> cryptoDirectoryStreamProvider;

            private DirectoryStreamComponentImpl(DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl, Path cleartextPathParam, String dirIdParam, DirectoryStream<Path> ciphertextDirectoryStreamParam, DirectoryStream.Filter<? super Path> filterParam, Consumer<CryptoDirectoryStream> onCloseParam) {
                this.cryptoFileSystemProviderComponent = cryptoFileSystemProviderComponent;
                this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
                this.initialize(cleartextPathParam, dirIdParam, ciphertextDirectoryStreamParam, filterParam, onCloseParam);
            }

            private void initialize(Path cleartextPathParam, String dirIdParam, DirectoryStream<Path> ciphertextDirectoryStreamParam, DirectoryStream.Filter<? super Path> filterParam, Consumer<CryptoDirectoryStream> onCloseParam) {
                this.dirIdProvider = InstanceFactory.create((Object)dirIdParam);
                this.ciphertextDirectoryStreamProvider = InstanceFactory.create(ciphertextDirectoryStreamParam);
                this.cleartextPathProvider = InstanceFactory.create((Object)cleartextPathParam);
                this.filterProvider = InstanceFactory.create(filterParam);
                this.onCloseProvider = InstanceFactory.create(onCloseParam);
                this.c9rDecryptorProvider = DoubleCheck.provider((Provider)C9rDecryptor_Factory.create(this.cryptoFileSystemComponentImpl.cryptorProvider, this.dirIdProvider));
                this.c9rConflictResolverProvider = DoubleCheck.provider((Provider)C9rConflictResolver_Factory.create(this.cryptoFileSystemComponentImpl.cryptorProvider, this.dirIdProvider, this.cryptoFileSystemComponentImpl.vaultConfigProvider));
                this.c9rProcessorProvider = DoubleCheck.provider((Provider)C9rProcessor_Factory.create((Provider<C9rDecryptor>)this.c9rDecryptorProvider, (Provider<C9rConflictResolver>)this.c9rConflictResolverProvider));
                this.c9sInflatorProvider = DoubleCheck.provider((Provider)C9sInflator_Factory.create(this.cryptoFileSystemComponentImpl.longFileNameProvider, this.cryptoFileSystemComponentImpl.cryptorProvider, this.dirIdProvider));
                this.c9sProcessorProvider = DoubleCheck.provider((Provider)C9sProcessor_Factory.create((Provider<C9sInflator>)this.c9sInflatorProvider));
                this.brokenDirectoryFilterProvider = DoubleCheck.provider((Provider)BrokenDirectoryFilter_Factory.create(this.cryptoFileSystemComponentImpl.cryptoPathMapperProvider));
                this.nodeProcessorProvider = DoubleCheck.provider((Provider)NodeProcessor_Factory.create((Provider<C9rProcessor>)this.c9rProcessorProvider, (Provider<C9sProcessor>)this.c9sProcessorProvider, (Provider<BrokenDirectoryFilter>)this.brokenDirectoryFilterProvider));
                this.cryptoDirectoryStreamProvider = DoubleCheck.provider((Provider)CryptoDirectoryStream_Factory.create(this.dirIdProvider, this.ciphertextDirectoryStreamProvider, this.cleartextPathProvider, this.filterProvider, this.onCloseProvider, (Provider<NodeProcessor>)this.nodeProcessorProvider));
            }

            @Override
            public CryptoDirectoryStream directoryStream() {
                return (CryptoDirectoryStream)this.cryptoDirectoryStreamProvider.get();
            }
        }

        private static final class DirectoryStreamComponentBuilder
        implements DirectoryStreamComponent.Builder {
            private final DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent;
            private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;
            private Path cleartextPath;
            private String dirId;
            private DirectoryStream<Path> ciphertextDirectoryStream;
            private DirectoryStream.Filter<? super Path> filter;
            private Consumer<CryptoDirectoryStream> onClose;

            private DirectoryStreamComponentBuilder(DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl) {
                this.cryptoFileSystemProviderComponent = cryptoFileSystemProviderComponent;
                this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
            }

            @Override
            public DirectoryStreamComponentBuilder cleartextPath(Path cleartextPath) {
                this.cleartextPath = (Path)Preconditions.checkNotNull((Object)cleartextPath);
                return this;
            }

            @Override
            public DirectoryStreamComponentBuilder dirId(String dirId) {
                this.dirId = (String)Preconditions.checkNotNull((Object)dirId);
                return this;
            }

            @Override
            public DirectoryStreamComponentBuilder ciphertextDirectoryStream(DirectoryStream<Path> ciphertextDirectoryStream) {
                this.ciphertextDirectoryStream = (DirectoryStream)Preconditions.checkNotNull(ciphertextDirectoryStream);
                return this;
            }

            @Override
            public DirectoryStreamComponentBuilder filter(DirectoryStream.Filter<? super Path> filter) {
                this.filter = (DirectoryStream.Filter)Preconditions.checkNotNull(filter);
                return this;
            }

            @Override
            public DirectoryStreamComponentBuilder onClose(Consumer<CryptoDirectoryStream> onClose) {
                this.onClose = (Consumer)Preconditions.checkNotNull(onClose);
                return this;
            }

            @Override
            public DirectoryStreamComponent build() {
                Preconditions.checkBuilderRequirement((Object)this.cleartextPath, Path.class);
                Preconditions.checkBuilderRequirement((Object)this.dirId, String.class);
                Preconditions.checkBuilderRequirement(this.ciphertextDirectoryStream, DirectoryStream.class);
                Preconditions.checkBuilderRequirement(this.filter, DirectoryStream.Filter.class);
                Preconditions.checkBuilderRequirement(this.onClose, Consumer.class);
                return new DirectoryStreamComponentImpl(this.cryptoFileSystemProviderComponent, this.cryptoFileSystemComponentImpl, this.cleartextPath, this.dirId, this.ciphertextDirectoryStream, this.filter, this.onClose);
            }
        }

        private static final class OpenCryptoFileComponentImpl
        implements OpenCryptoFileComponent {
            private final DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent;
            private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;
            private final OpenCryptoFileComponentImpl openCryptoFileComponentImpl = this;
            private Provider<FileCloseListener> onCloseProvider;
            private Provider chunkIOProvider;
            private Provider<Path> pathProvider;
            private Provider<AtomicReference<Path>> provideCurrentPathProvider;
            private Provider<FileHeaderHolder> fileHeaderHolderProvider;
            private Provider chunkLoaderProvider;
            private Provider<ExceptionsDuringWrite> exceptionsDuringWriteProvider;
            private Provider chunkSaverProvider;
            private Provider<ChunkCache> chunkCacheProvider;
            private Provider<AtomicLong> provideFileSizeProvider;
            private Provider<AtomicReference<Instant>> provideLastModifiedDateProvider;
            private Provider<OpenCryptoFileComponent> openCryptoFileComponentProvider;
            private Provider<OpenCryptoFile> openCryptoFileProvider;
            private Provider<ReadWriteLock> provideReadWriteLockProvider;
            private Provider<Supplier<BasicFileAttributeView>> provideBasicFileAttributeViewSupplierProvider;

            private OpenCryptoFileComponentImpl(DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl, OpenCryptoFileModule openCryptoFileModuleParam, Path pathParam, FileCloseListener onCloseParam) {
                this.cryptoFileSystemProviderComponent = cryptoFileSystemProviderComponent;
                this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
                this.initialize(openCryptoFileModuleParam, pathParam, onCloseParam);
            }

            private void initialize(OpenCryptoFileModule openCryptoFileModuleParam, Path pathParam, FileCloseListener onCloseParam) {
                this.onCloseProvider = InstanceFactory.create((Object)onCloseParam);
                this.chunkIOProvider = DoubleCheck.provider((Provider)ChunkIO_Factory.create());
                this.pathProvider = InstanceFactory.create((Object)pathParam);
                this.provideCurrentPathProvider = DoubleCheck.provider((Provider)OpenCryptoFileModule_ProvideCurrentPathFactory.create(openCryptoFileModuleParam, this.pathProvider));
                this.fileHeaderHolderProvider = DoubleCheck.provider((Provider)FileHeaderHolder_Factory.create(this.cryptoFileSystemComponentImpl.cryptorProvider, this.provideCurrentPathProvider));
                this.chunkLoaderProvider = DoubleCheck.provider((Provider)ChunkLoader_Factory.create(this.cryptoFileSystemComponentImpl.cryptorProvider, (Provider<ChunkIO>)this.chunkIOProvider, this.fileHeaderHolderProvider, this.cryptoFileSystemComponentImpl.cryptoFileSystemStatsProvider));
                this.exceptionsDuringWriteProvider = DoubleCheck.provider((Provider)ExceptionsDuringWrite_Factory.create());
                this.chunkSaverProvider = DoubleCheck.provider((Provider)ChunkSaver_Factory.create(this.cryptoFileSystemComponentImpl.cryptorProvider, (Provider<ChunkIO>)this.chunkIOProvider, this.fileHeaderHolderProvider, this.exceptionsDuringWriteProvider, this.cryptoFileSystemComponentImpl.cryptoFileSystemStatsProvider));
                this.chunkCacheProvider = DoubleCheck.provider((Provider)ChunkCache_Factory.create((Provider<ChunkLoader>)this.chunkLoaderProvider, (Provider<ChunkSaver>)this.chunkSaverProvider, this.cryptoFileSystemComponentImpl.cryptoFileSystemStatsProvider));
                this.provideFileSizeProvider = DoubleCheck.provider((Provider)OpenCryptoFileModule_ProvideFileSizeFactory.create(openCryptoFileModuleParam));
                this.provideLastModifiedDateProvider = DoubleCheck.provider((Provider)OpenCryptoFileModule_ProvideLastModifiedDateFactory.create(openCryptoFileModuleParam, this.pathProvider));
                this.openCryptoFileComponentProvider = InstanceFactory.create((Object)this.openCryptoFileComponentImpl);
                this.openCryptoFileProvider = DoubleCheck.provider((Provider)OpenCryptoFile_Factory.create(this.onCloseProvider, this.chunkCacheProvider, this.cryptoFileSystemComponentImpl.cryptorProvider, this.fileHeaderHolderProvider, (Provider<ChunkIO>)this.chunkIOProvider, this.provideCurrentPathProvider, this.provideFileSizeProvider, this.provideLastModifiedDateProvider, this.openCryptoFileComponentProvider));
                this.provideReadWriteLockProvider = DoubleCheck.provider((Provider)OpenCryptoFileModule_ProvideReadWriteLockFactory.create(openCryptoFileModuleParam));
                this.provideBasicFileAttributeViewSupplierProvider = DoubleCheck.provider((Provider)OpenCryptoFileModule_ProvideBasicFileAttributeViewSupplierFactory.create(openCryptoFileModuleParam, this.provideCurrentPathProvider));
            }

            @Override
            public OpenCryptoFile openCryptoFile() {
                return (OpenCryptoFile)this.openCryptoFileProvider.get();
            }

            @Override
            public ChannelComponent.Builder newChannelComponent() {
                return new ChannelComponentBuilder(this.cryptoFileSystemProviderComponent, this.cryptoFileSystemComponentImpl, this.openCryptoFileComponentImpl);
            }

            private static final class ChannelComponentBuilder
            implements ChannelComponent.Builder {
                private final DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent;
                private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;
                private final OpenCryptoFileComponentImpl openCryptoFileComponentImpl;
                private EffectiveOpenOptions openOptions;
                private ChannelCloseListener onClose;
                private FileChannel ciphertextChannel;
                private Boolean mustWriteHeader;
                private FileHeader fileHeader;

                private ChannelComponentBuilder(DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl, OpenCryptoFileComponentImpl openCryptoFileComponentImpl) {
                    this.cryptoFileSystemProviderComponent = cryptoFileSystemProviderComponent;
                    this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
                    this.openCryptoFileComponentImpl = openCryptoFileComponentImpl;
                }

                @Override
                public ChannelComponentBuilder openOptions(EffectiveOpenOptions options) {
                    this.openOptions = (EffectiveOpenOptions)Preconditions.checkNotNull((Object)options);
                    return this;
                }

                @Override
                public ChannelComponentBuilder onClose(ChannelCloseListener listener) {
                    this.onClose = (ChannelCloseListener)Preconditions.checkNotNull((Object)listener);
                    return this;
                }

                @Override
                public ChannelComponentBuilder ciphertextChannel(FileChannel ciphertextChannel) {
                    this.ciphertextChannel = (FileChannel)Preconditions.checkNotNull((Object)ciphertextChannel);
                    return this;
                }

                @Override
                public ChannelComponentBuilder mustWriteHeader(boolean mustWriteHeader) {
                    this.mustWriteHeader = (Boolean)Preconditions.checkNotNull((Object)mustWriteHeader);
                    return this;
                }

                @Override
                public ChannelComponentBuilder fileHeader(FileHeader fileHeader) {
                    this.fileHeader = (FileHeader)Preconditions.checkNotNull((Object)fileHeader);
                    return this;
                }

                @Override
                public ChannelComponent build() {
                    Preconditions.checkBuilderRequirement((Object)this.openOptions, EffectiveOpenOptions.class);
                    Preconditions.checkBuilderRequirement((Object)this.onClose, ChannelCloseListener.class);
                    Preconditions.checkBuilderRequirement((Object)this.ciphertextChannel, FileChannel.class);
                    Preconditions.checkBuilderRequirement((Object)this.mustWriteHeader, Boolean.class);
                    Preconditions.checkBuilderRequirement((Object)this.fileHeader, FileHeader.class);
                    return new ChannelComponentI(this.cryptoFileSystemProviderComponent, this.cryptoFileSystemComponentImpl, this.openCryptoFileComponentImpl, this.openOptions, this.onClose, this.ciphertextChannel, this.mustWriteHeader, this.fileHeader);
                }
            }

            private static final class ChannelComponentI
            implements ChannelComponent {
                private final DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent;
                private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;
                private final OpenCryptoFileComponentImpl openCryptoFileComponentImpl;
                private final ChannelComponentI channelComponentI = this;
                private Provider<FileChannel> ciphertextChannelProvider;
                private Provider<FileHeader> fileHeaderProvider;
                private Provider<Boolean> mustWriteHeaderProvider;
                private Provider<EffectiveOpenOptions> openOptionsProvider;
                private Provider<ChannelCloseListener> onCloseProvider;
                private Provider<CleartextFileChannel> cleartextFileChannelProvider;

                private ChannelComponentI(DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl, OpenCryptoFileComponentImpl openCryptoFileComponentImpl, EffectiveOpenOptions openOptionsParam, ChannelCloseListener onCloseParam, FileChannel ciphertextChannelParam, Boolean mustWriteHeaderParam, FileHeader fileHeaderParam) {
                    this.cryptoFileSystemProviderComponent = cryptoFileSystemProviderComponent;
                    this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
                    this.openCryptoFileComponentImpl = openCryptoFileComponentImpl;
                    this.initialize(openOptionsParam, onCloseParam, ciphertextChannelParam, mustWriteHeaderParam, fileHeaderParam);
                }

                private void initialize(EffectiveOpenOptions openOptionsParam, ChannelCloseListener onCloseParam, FileChannel ciphertextChannelParam, Boolean mustWriteHeaderParam, FileHeader fileHeaderParam) {
                    this.ciphertextChannelProvider = InstanceFactory.create((Object)ciphertextChannelParam);
                    this.fileHeaderProvider = InstanceFactory.create((Object)fileHeaderParam);
                    this.mustWriteHeaderProvider = InstanceFactory.create((Object)mustWriteHeaderParam);
                    this.openOptionsProvider = InstanceFactory.create((Object)openOptionsParam);
                    this.onCloseProvider = InstanceFactory.create((Object)onCloseParam);
                    this.cleartextFileChannelProvider = DoubleCheck.provider((Provider)CleartextFileChannel_Factory.create(this.ciphertextChannelProvider, this.fileHeaderProvider, this.mustWriteHeaderProvider, this.openCryptoFileComponentImpl.provideReadWriteLockProvider, this.cryptoFileSystemComponentImpl.cryptorProvider, this.openCryptoFileComponentImpl.chunkCacheProvider, this.openOptionsProvider, this.openCryptoFileComponentImpl.provideFileSizeProvider, this.openCryptoFileComponentImpl.provideLastModifiedDateProvider, this.openCryptoFileComponentImpl.provideBasicFileAttributeViewSupplierProvider, this.openCryptoFileComponentImpl.exceptionsDuringWriteProvider, this.onCloseProvider, this.cryptoFileSystemComponentImpl.cryptoFileSystemStatsProvider));
                }

                @Override
                public CleartextFileChannel channel() {
                    return (CleartextFileChannel)this.cleartextFileChannelProvider.get();
                }
            }
        }

        private static final class OpenCryptoFileComponentBuilder
        implements OpenCryptoFileComponent.Builder {
            private final DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent;
            private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;
            private Path path;
            private FileCloseListener onClose;

            private OpenCryptoFileComponentBuilder(DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl) {
                this.cryptoFileSystemProviderComponent = cryptoFileSystemProviderComponent;
                this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
            }

            @Override
            public OpenCryptoFileComponentBuilder path(Path path) {
                this.path = (Path)Preconditions.checkNotNull((Object)path);
                return this;
            }

            @Override
            public OpenCryptoFileComponentBuilder onClose(FileCloseListener listener) {
                this.onClose = (FileCloseListener)Preconditions.checkNotNull((Object)listener);
                return this;
            }

            @Override
            public OpenCryptoFileComponent build() {
                Preconditions.checkBuilderRequirement((Object)this.path, Path.class);
                Preconditions.checkBuilderRequirement((Object)this.onClose, FileCloseListener.class);
                return new OpenCryptoFileComponentImpl(this.cryptoFileSystemProviderComponent, this.cryptoFileSystemComponentImpl, new OpenCryptoFileModule(), this.path, this.onClose);
            }
        }
    }

    private static final class CryptoFileSystemComponentBuilder
    implements CryptoFileSystemComponent.Builder {
        private final DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent;
        private Cryptor cryptor;
        private VaultConfig vaultConfig;
        private CryptoFileSystemProvider provider;
        private Path pathToVault;
        private CryptoFileSystemProperties properties;

        private CryptoFileSystemComponentBuilder(DaggerCryptoFileSystemProviderComponent cryptoFileSystemProviderComponent) {
            this.cryptoFileSystemProviderComponent = cryptoFileSystemProviderComponent;
        }

        @Override
        public CryptoFileSystemComponentBuilder cryptor(Cryptor cryptor) {
            this.cryptor = (Cryptor)Preconditions.checkNotNull((Object)cryptor);
            return this;
        }

        @Override
        public CryptoFileSystemComponentBuilder vaultConfig(VaultConfig vaultConfig) {
            this.vaultConfig = (VaultConfig)Preconditions.checkNotNull((Object)vaultConfig);
            return this;
        }

        @Override
        public CryptoFileSystemComponentBuilder provider(CryptoFileSystemProvider provider) {
            this.provider = (CryptoFileSystemProvider)Preconditions.checkNotNull((Object)provider);
            return this;
        }

        @Override
        public CryptoFileSystemComponentBuilder pathToVault(Path pathToVault) {
            this.pathToVault = (Path)Preconditions.checkNotNull((Object)pathToVault);
            return this;
        }

        @Override
        public CryptoFileSystemComponentBuilder properties(CryptoFileSystemProperties cryptoFileSystemProperties) {
            this.properties = (CryptoFileSystemProperties)Preconditions.checkNotNull((Object)cryptoFileSystemProperties);
            return this;
        }

        @Override
        public CryptoFileSystemComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.cryptor, Cryptor.class);
            Preconditions.checkBuilderRequirement((Object)this.vaultConfig, VaultConfig.class);
            Preconditions.checkBuilderRequirement((Object)this.provider, CryptoFileSystemProvider.class);
            Preconditions.checkBuilderRequirement((Object)this.pathToVault, Path.class);
            Preconditions.checkBuilderRequirement((Object)this.properties, CryptoFileSystemProperties.class);
            return new CryptoFileSystemComponentImpl(this.cryptoFileSystemProviderComponent, new CryptoFileSystemModule(), this.cryptor, this.vaultConfig, this.provider, this.pathToVault, this.properties);
        }
    }
}

