/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.webdav.core.servlet;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.DavSessionProvider;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.header.IfHeader;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.server.AbstractWebdavServlet;
import org.cryptomator.webdav.core.servlet.DavLocatorFactoryImpl;
import org.cryptomator.webdav.core.servlet.DavResourceFactoryImpl;
import org.cryptomator.webdav.core.servlet.DavSessionProviderImpl;
import org.cryptomator.webdav.core.servlet.UncheckedDavException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNioWebDavServlet
extends AbstractWebdavServlet {
    private static final String NO_LOCK = "DAV:no-lock";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNioWebDavServlet.class);
    private final DavSessionProvider davSessionProvider = new DavSessionProviderImpl();
    private final DavLocatorFactory davLocatorFactory = new DavLocatorFactoryImpl();
    private final DavResourceFactoryImpl davResourceFactory = new DavResourceFactoryImpl(this::resolveUrl);

    protected abstract Path resolveUrl(String var1) throws IllegalArgumentException;

    protected boolean isPreconditionValid(WebdavRequest request, DavResource resource) {
        IfHeader ifHeader = new IfHeader((HttpServletRequest)request);
        if (ifHeader.hasValue() && Iterators.all((Iterator)ifHeader.getAllTokens(), (Predicate)Predicates.equalTo((Object)NO_LOCK))) {
            return false;
        }
        if (ifHeader.hasValue() && Iterators.any((Iterator)ifHeader.getAllNotTokens(), (Predicate)Predicates.equalTo((Object)NO_LOCK))) {
            return true;
        }
        return request.matchesIfHeader(resource);
    }

    public DavSessionProvider getDavSessionProvider() {
        return this.davSessionProvider;
    }

    public void setDavSessionProvider(DavSessionProvider davSessionProvider) {
        throw new UnsupportedOperationException("Setting davSessionProvider not supported.");
    }

    public DavLocatorFactory getLocatorFactory() {
        return this.davLocatorFactory;
    }

    public void setLocatorFactory(DavLocatorFactory locatorFactory) {
        throw new UnsupportedOperationException("Setting locatorFactory not supported.");
    }

    public DavResourceFactory getResourceFactory() {
        return this.davResourceFactory;
    }

    public void setResourceFactory(DavResourceFactory resourceFactory) {
        throw new UnsupportedOperationException("Setting resourceFactory not supported.");
    }

    protected boolean execute(WebdavRequest request, WebdavResponse response, int method, DavResource resource) throws ServletException, IOException, DavException {
        try {
            try {
                return super.execute(request, response, method, resource);
            }
            catch (UncheckedDavException e) {
                throw e.toDavException();
            }
        }
        catch (DavException e) {
            if (e.getErrorCode() == 500) {
                LOG.error("Unexpected DavException.", (Throwable)e);
            }
            throw e;
        }
    }

    protected void doGet(WebdavRequest request, WebdavResponse response, DavResource resource) throws IOException, DavException {
        super.doGet(request, response, resource);
    }

    protected int validateDestination(DavResource destResource, WebdavRequest request, boolean checkHeader) throws DavException {
        if (this.isLocked(destResource) && !this.hasCorrectLockTokens(request.getDavSession(), destResource)) {
            throw new DavException(423, "The destination resource is locked");
        }
        return super.validateDestination(destResource, request, checkHeader);
    }

    protected void doPut(WebdavRequest request, WebdavResponse response, DavResource resource) throws IOException, DavException {
        if (this.isLocked(resource) && !this.hasCorrectLockTokens(request.getDavSession(), resource)) {
            throw new DavException(423, "The resource is locked");
        }
        super.doPut(request, response, resource);
    }

    protected void doDelete(WebdavRequest request, WebdavResponse response, DavResource resource) throws IOException, DavException {
        if (this.isLocked(resource) && !this.hasCorrectLockTokens(request.getDavSession(), resource)) {
            throw new DavException(423, "The resource is locked");
        }
        super.doDelete(request, response, resource);
    }

    protected void doMove(WebdavRequest request, WebdavResponse response, DavResource resource) throws IOException, DavException {
        if (this.isLocked(resource) && !this.hasCorrectLockTokens(request.getDavSession(), resource)) {
            throw new DavException(423, "The source resource is locked");
        }
        super.doMove(request, response, resource);
    }

    protected void doPropPatch(WebdavRequest request, WebdavResponse response, DavResource resource) throws IOException, DavException {
        if (this.isLocked(resource) && !this.hasCorrectLockTokens(request.getDavSession(), resource)) {
            throw new DavException(423, "The resource is locked");
        }
        super.doPropPatch(request, response, resource);
    }

    private boolean hasCorrectLockTokens(DavSession session, DavResource resource) {
        boolean access = false;
        ImmutableSet providedLockTokens = ImmutableSet.copyOf((Object[])session.getLockTokens());
        for (ActiveLock lock : resource.getLocks()) {
            access |= providedLockTokens.contains(lock.getToken());
        }
        return access;
    }

    private boolean isLocked(DavResource resource) {
        return resource.hasLock(Type.WRITE, Scope.EXCLUSIVE) || resource.hasLock(Type.WRITE, Scope.SHARED);
    }
}

