/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import com.nulabinc.zxcvbn.matchers.ResourceLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Keyboard {
    private static final String RESOURCES_PACKAGE_PATH = "com/nulabinc/zxcvbn/matchers/keyboards/";
    private static final ResourceLoader RESOURCE_LOADER = new ResourceLoader();
    public static final Keyboard QWERTY = new Keyboard("qwerty", new SlantedAdjacentGraphBuilder(Keyboard.loadAsString("qwerty.txt")));
    public static final Keyboard DVORAK = new Keyboard("dvorak", new SlantedAdjacentGraphBuilder(Keyboard.loadAsString("dvorak.txt")));
    public static final Keyboard JIS = new Keyboard("jis", new SlantedAdjacentGraphBuilder(Keyboard.loadAsString("jis.txt")));
    public static final Keyboard KEYPAD = new Keyboard("keypad", new AlignedAdjacentAdjacentGraphBuilder(Keyboard.loadAsString("keypad.txt")));
    public static final Keyboard MAC_KEYPAD = new Keyboard("mac_keypad", new AlignedAdjacentAdjacentGraphBuilder(Keyboard.loadAsString("mac_keypad.txt")));
    public static final List<Keyboard> ALL_KEYBOARDS = Arrays.asList(QWERTY, DVORAK, JIS, KEYPAD, MAC_KEYPAD);
    private final String name;
    private final Map<Character, List<String>> adjacencyGraph;
    private final boolean slanted;
    private final int startingPositions;
    private final double averageDegree;

    private Keyboard(String name, AdjacentGraphBuilder adjacentGraphBuilder) {
        this.name = name;
        this.adjacencyGraph = adjacentGraphBuilder.build();
        this.slanted = adjacentGraphBuilder.isSlanted();
        this.startingPositions = this.adjacencyGraph.size();
        this.averageDegree = Keyboard.calcAverageDegree(this.adjacencyGraph);
    }

    private static double calcAverageDegree(Map<Character, List<String>> adjacencyGraph) {
        double average = 0.0;
        for (Map.Entry<Character, List<String>> graphRef : adjacencyGraph.entrySet()) {
            List<String> neighbors = graphRef.getValue();
            ArrayList<String> results = new ArrayList<String>();
            for (String neighbor : neighbors) {
                if (neighbor == null) continue;
                results.add(neighbor);
            }
            average += (double)results.size();
        }
        ArrayList<Character> keys = new ArrayList<Character>();
        for (Map.Entry<Character, List<String>> graphRef : adjacencyGraph.entrySet()) {
            keys.add(graphRef.getKey());
        }
        return average /= (double)keys.size();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String loadAsString(String name) {
        try (InputStream input = RESOURCE_LOADER.getInputStream(RESOURCES_PACKAGE_PATH + name);){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                String str;
                StringBuilder sb = new StringBuilder(4096);
                while ((str = reader.readLine()) != null) {
                    sb.append(str);
                    sb.append('\n');
                }
                string = sb.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Keyboard of(String graph) {
        for (Keyboard keyboard : ALL_KEYBOARDS) {
            if (!keyboard.getName().equals(graph)) continue;
            return keyboard;
        }
        throw new IllegalArgumentException("Illegal graph " + graph);
    }

    public String getName() {
        return this.name;
    }

    public Map<Character, List<String>> getAdjacencyGraph() {
        return this.adjacencyGraph;
    }

    public boolean isSlanted() {
        return this.slanted;
    }

    public int getStartingPositions() {
        return this.startingPositions;
    }

    public double getAverageDegree() {
        return this.averageDegree;
    }

    static class Position {
        private final int x;
        private final int y;

        private Position(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public static Position of(int x, int y) {
            return new Position(x, y);
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.y;
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Position)) {
                return false;
            }
            Position position = (Position)o;
            return this.x == position.x && this.y == position.y;
        }

        public String toString() {
            return "[" + this.x + "," + this.y + ']';
        }
    }

    static class AlignedAdjacentAdjacentGraphBuilder
    extends AdjacentGraphBuilder {
        public AlignedAdjacentAdjacentGraphBuilder(String layout) {
            super(layout);
        }

        @Override
        public boolean isSlanted() {
            return false;
        }

        @Override
        protected int calcSlant(int y) {
            return 0;
        }

        @Override
        protected List<Position> getAdjacentCoords(Position position) {
            return Arrays.asList(Position.of(position.getX() - 1, position.getY()), Position.of(position.getX() - 1, position.getY() - 1), Position.of(position.getX(), position.getY() - 1), Position.of(position.getX() + 1, position.getY() - 1), Position.of(position.getX() + 1, position.getY()), Position.of(position.getX() + 1, position.getY() + 1), Position.of(position.getX(), position.getY() + 1), Position.of(position.getX() - 1, position.getY() + 1));
        }
    }

    static class SlantedAdjacentGraphBuilder
    extends AdjacentGraphBuilder {
        public SlantedAdjacentGraphBuilder(String layout) {
            super(layout);
        }

        @Override
        protected List<Position> getAdjacentCoords(Position position) {
            return Arrays.asList(Position.of(position.getX() - 1, position.getY()), Position.of(position.getX(), position.getY() - 1), Position.of(position.getX() + 1, position.getY() - 1), Position.of(position.getX() + 1, position.getY()), Position.of(position.getX(), position.getY() + 1), Position.of(position.getX() - 1, position.getY() + 1));
        }

        @Override
        public boolean isSlanted() {
            return true;
        }

        @Override
        protected int calcSlant(int y) {
            return y - 1;
        }
    }

    static abstract class AdjacentGraphBuilder {
        private static final SplitMatcher WHITESPACE_SPLIT_MATCHER = new SplitMatcher(){

            @Override
            public boolean match(char c) {
                return Character.isWhitespace(c);
            }
        };
        private static final SplitMatcher NEW_LINE_SPLIT_MATCHER = new SplitMatcher(){

            @Override
            public boolean match(char c) {
                return c == '\n';
            }
        };
        private final String layout;

        public AdjacentGraphBuilder(String layout) {
            this.layout = layout;
        }

        public Map<Character, List<String>> build() {
            Map<Position, String> positionTable = this.buildPositionTable(this.layout);
            HashMap<Character, List<String>> adjacencyGraph = new HashMap<Character, List<String>>();
            for (Map.Entry<Position, String> entry : positionTable.entrySet()) {
                for (char key : entry.getValue().toCharArray()) {
                    ArrayList<String> adjacencies = new ArrayList<String>();
                    Position position = entry.getKey();
                    for (Position coord : this.getAdjacentCoords(position)) {
                        adjacencies.add(positionTable.get(coord));
                    }
                    adjacencyGraph.put(Character.valueOf(key), adjacencies);
                }
            }
            return adjacencyGraph;
        }

        private Map<Position, String> buildPositionTable(String layout) {
            HashMap<Position, String> positionTable = new HashMap<Position, String>();
            List<String> tokens = AdjacentGraphBuilder.split(layout, WHITESPACE_SPLIT_MATCHER);
            int tokenSize = tokens.get(0).length();
            int xUnit = tokenSize + 1;
            for (String token : tokens) {
                assert (token.length() == tokenSize) : String.format("token [%s] length mismatch:\n%s", token, layout);
            }
            int y = 1;
            for (String line : AdjacentGraphBuilder.split(layout, NEW_LINE_SPLIT_MATCHER)) {
                int slant = this.calcSlant(y);
                for (String token : AdjacentGraphBuilder.split(line, WHITESPACE_SPLIT_MATCHER)) {
                    int index = line.indexOf(token) - slant;
                    int x = index / xUnit;
                    int remainder = index % xUnit;
                    assert (remainder == 0) : String.format("unexpected x offset [%d] for %s in:\n%s", x, token, layout);
                    positionTable.put(Position.of(x, y), token);
                }
                ++y;
            }
            return positionTable;
        }

        protected abstract List<Position> getAdjacentCoords(Position var1);

        private static List<String> split(String str, SplitMatcher splitMatcher) {
            int len = str.length();
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            int start = 0;
            boolean match = false;
            while (i < len) {
                if (splitMatcher.match(str.charAt(i))) {
                    if (match) {
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
            if (match) {
                list.add(str.substring(start, i));
            }
            return list;
        }

        protected abstract int calcSlant(int var1);

        public abstract boolean isSlanted();

        private static interface SplitMatcher {
            public boolean match(char var1);
        }
    }
}

