/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import org.cryptomator.cryptolib.common.CipherSupplier;
import org.cryptomator.cryptolib.common.DestroyableSecretKey;

public class AesKeyWrap {
    public static byte[] wrap(DestroyableSecretKey kek, SecretKey key) {
        DestroyableSecretKey kekCopy = kek.copy();
        try {
            Cipher cipher = CipherSupplier.RFC3394_KEYWRAP.forWrapping(kekCopy);
            byte[] byArray = cipher.wrap(key);
            if (kekCopy != null) {
                kekCopy.close();
            }
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                if (kekCopy != null) {
                    try {
                        kekCopy.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InvalidKeyException | IllegalBlockSizeException e) {
                throw new IllegalArgumentException("Unable to wrap key.", e);
            }
        }
    }

    public static DestroyableSecretKey unwrap(DestroyableSecretKey kek, byte[] wrappedKey, String wrappedKeyAlgorithm) throws InvalidKeyException {
        return AesKeyWrap.unwrap(kek, wrappedKey, wrappedKeyAlgorithm, 3);
    }

    static DestroyableSecretKey unwrap(DestroyableSecretKey kek, byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException {
        DestroyableSecretKey kekCopy = kek.copy();
        try {
            Cipher cipher = CipherSupplier.RFC3394_KEYWRAP.forUnwrapping(kekCopy);
            DestroyableSecretKey destroyableSecretKey = DestroyableSecretKey.from(cipher.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType));
            if (kekCopy != null) {
                kekCopy.close();
            }
            return destroyableSecretKey;
        }
        catch (Throwable throwable) {
            try {
                if (kekCopy != null) {
                    try {
                        kekCopy.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Invalid algorithm: " + wrappedKeyAlgorithm, e);
            }
        }
    }
}

