/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav.mount;

import java.util.HashMap;
import java.util.Map;
import org.cryptomator.frontend.webdav.mount.MountParam;

public class MountParams
extends HashMap<MountParam, String> {
    private MountParams(Map<MountParam, String> params) {
        super(params);
    }

    public static MountParamsBuilder create() {
        return new MountParamsBuilder();
    }

    public static class MountParamsBuilder {
        private final Map<MountParam, String> params = new HashMap<MountParam, String>();

        public MountParamsBuilder with(MountParam key, String value) {
            if (value != null) {
                this.params.put(key, value);
            }
            return this;
        }

        public MountParamsBuilder withWindowsDriveLetter(String value) {
            if (value == null) {
                return this;
            }
            return this.with(MountParam.WIN_DRIVE_LETTER, (String)(value.endsWith(":") ? value : value + ":"));
        }

        public MountParamsBuilder withPreferredGvfsScheme(String value) {
            return this.with(MountParam.PREFERRED_GVFS_SCHEME, value);
        }

        public MountParamsBuilder withWebdavHostname(String value) {
            return this.with(MountParam.WEBDAV_HOSTNAME, value);
        }

        public MountParams build() {
            return new MountParams(this.params);
        }
    }
}

