#ifndef ADDUSERAGENTDIALOG_H
#define ADDUSERAGENTDIALOG_H

#include <QDialog>

namespace Ui {
    class AddUserAgentDialog;
}

/**
 * @class AddUserAgentDialog
 * @brief Used to add a new user agent to the list of user agents that the browser can mimic
 */
class AddUserAgentDialog : public QDialog
{
    friend class UserAgentManager;

    Q_OBJECT

public:
    /// Constructs the "add user agent" dialog. As a dialog, the parent should be null
    explicit AddUserAgentDialog(QWidget *parent = 0);

    /// Deletes dialog resources that have been allocated on the heap
    ~AddUserAgentDialog();

    /// Returns the selected user agent category
    QString getCategory() const;

    /// Returns the user-assigned name of the new user agent
    QString getAgentName() const;

    /// Returns the value of the new user agent string
    QString getAgentValue() const;

    /// Hides the UI elements that allow the user to add a new category for user agents
    void hideNewCategoryOption();

    /// Clears the items in the user agent category combo box
    void clearAgentCategories();

Q_SIGNALS:
    /// Emitted when the user hits the "Ok" button to confirm the addition of a new user agent
    void userAgentAdded();

public Q_SLOTS:
    /// Adds a new category to the list of UA categories the user can choose from
    void addAgentCategory(const QString &name);

private Q_SLOTS:
    /// Shows a dialog to create a new category of user agents
    void showNewCategoryDialog();

private:
    /// Generated by .ui file
    Ui::AddUserAgentDialog *ui;
};

#endif // ADDUSERAGENTDIALOG_H
