#include "postgres.h"
#include "fmgr.h"
#include "utils/elog.h"
#include <regex.h>

//#include "executor/executor.h"  /* for GetAttributeByName() */
//gcc -I /usr/include/pgsql/server -fpic -shared -o  adate.so -c adate.c
#define BISS(i) ((i % 4 == 0) && (i % 100 != 0)) ^ (i % 400 == 0)

#ifdef PG_MODULE_MAGIC
PG_MODULE_MAGIC;
#endif

struct aDate
{
	char day, month;
  int year;
};

regex_t re;
bool isregex = false;
static const char months[12] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

PG_FUNCTION_INFO_V1(adate_input);

Datum adate_input(PG_FUNCTION_ARGS)
{
	char       *str = PG_GETARG_CSTRING(0), *c = str;
  struct aDate * result;
	char day, month;
	int year;
	bool bc = false;
	while(*c++) *c = tolower(*c);
	if(!isregex)
		{
			regcomp(&re, ".* bc$", REG_NOSUB);
			isregex = true;
		}
	if(regexec(&re, str, 0, 0, 0) == 0) bc = true;
	if(sscanf(str, " %d-%hhd-%hhd ",  &year, &month, &day) != 3)
		 ereport(ERROR, (errcode(ERRCODE_INVALID_TEXT_REPRESENTATION),
                 errmsg("invalid input syntax for adate: \"%s\"",
                        str)));
	//PG_RETURN_BOOL(false);
	if(bc) year = -year;
	if(day < 1 || day > 31) ereport(ERROR, (errcode(ERRCODE_DATETIME_VALUE_OUT_OF_RANGE), errmsg("invalid day value (1-31): %d", day)));
	if(month < 1 || month > 12) ereport(ERROR, (errcode(ERRCODE_DATETIME_VALUE_OUT_OF_RANGE), errmsg("invalid month value (1-12): %d", month)));
	if(day == 31 && months[month - 1] < 31) ereport(ERROR, (errcode(ERRCODE_DATETIME_FIELD_OVERFLOW), errmsg("invalid day value %d-%d-%d for this month", day, month, year)));
	if(month == 2)
		if(BISS(year) && day > 29) ereport(ERROR, (errcode(ERRCODE_DATETIME_FIELD_OVERFLOW), errmsg("invalid day value %d-%d-%d for Februar", day, month, year)));
		else if(!BISS(year) && day > 28) ereport(ERROR, (errcode(ERRCODE_DATETIME_FIELD_OVERFLOW), errmsg("invalid day value %d-%d-%d for Februar", day, month, year)));		
    if(year < -1000000 || year > 1000000) ereport(ERROR, (errcode(ERRCODE_DATETIME_VALUE_OUT_OF_RANGE), errmsg("invalid year value (-1000000-1000000): %d", year)));
    result = (struct aDate*) palloc(sizeof(struct aDate));
    result->day = day;
    result->month = month;
    result->year = year;
    PG_RETURN_POINTER(result);
}

PG_FUNCTION_INFO_V1(adate_output);

Datum adate_output(PG_FUNCTION_ARGS)
{
	struct aDate * a = (struct aDate *)PG_GETARG_POINTER(0);
	char *result = palloc(20);
	//result = psprintf("d-%d-%d%s", abs(a->year), a->month, a->day, (a->year < 0) ? " bc" : "");
    snprintf(result, 20, "%d-%d-%d%s", abs(a->year), a->month, a->day, a->year < 0 ? " BC" : "");
	PG_RETURN_CSTRING(result);
}

PG_FUNCTION_INFO_V1(extract);
Datum extract(PG_FUNCTION_ARGS)
{
	char *str = (char *)PG_GETARG_CSTRING(0), buf[10], *c = buf;
	const struct aDate * a = (const struct aDate *)PG_GETARG_POINTER(1);
	strncpy(buf, str, 10);
	while(*c) { *c = tolower(*c); c++; }
	if(strcmp(buf, "day") == 0) return a->day;
	if(strcmp(buf, "month") == 0) return a->month;
	if(strcmp(buf, "year") == 0) return a->year;
	ereport(ERROR, (errcode(ERRCODE_INVALID_PARAMETER_VALUE), errmsg("Unknow type %s", buf)));
}
