/***************************************************************
 * Name:      daydialog.h
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2020
 * License:   GPL3
 **************************************************************/

#ifndef DAYDIALOG_H
#define DAYDIALOG_H

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif
#include "widgets/dxlistctrl.h"
#include "data/engine.h"
#include "widgets/dxtoolbar.h"

class DayDialog: public wxDialog
{
    DECLARE_DYNAMIC_CLASS(DayDialog)
    DECLARE_EVENT_TABLE()
public:
    DayDialog() {}
    DayDialog(wxWindow *parent, const wxDateTime &date);
private:
    void OnOk(wxCommandEvent& event);
    void OnCancel(wxCommandEvent& event);
    void OnAdd(wxCommandEvent& event);
    void OnEdit(wxCommandEvent& event);
    void OnRemove(wxCommandEvent& event);
    void OnListRightClick(wxListEvent& event);
    void OnListActivated(wxListEvent& event);
    void OnListSelected(wxListEvent& event);
    void OnListDeselected(wxListEvent& event);
    void fillList();
    void enableTools();
    void updateHoliday(long id, const wxString &name, int day, wxDateTime::Month month);
    void OnRemindHoliday(wxCommandEvent& event);

    std::vector<Event> m_events;
    dxListCtrl *m_list;
    long m_index;
    dxToolBar *m_bar;
    wxPanel *m_panel;
    wxDateTime m_date;
};

#endif  /* DAYDIALOG_H */

