/* drotat.f -- translated by f2c (version 19980913).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* $Procedure DROTAT ( Derivative of a rotation matrix ) */
/* Subroutine */ int drotat_(doublereal *angle, integer *iaxis, doublereal *
	dmout)
{
    /* Initialized data */

    static integer indexs[5] = { 1,2,3,1,2 };

    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    double sin(doublereal), cos(doublereal);
    integer s_rnge(char *, integer, char *, integer);

    /* Local variables */
    doublereal c__, s;
    extern /* Subroutine */ int chkin_(char *, ftnlen);
    integer i1, i2, i3;
    extern /* Subroutine */ int sigerr_(char *, ftnlen), chkout_(char *, 
	    ftnlen), setmsg_(char *, ftnlen), errint_(char *, integer *, 
	    ftnlen);

/* $ Abstract */

/*     Calculate the derivative with respect to the angle of rotation */
/*     of a 3x3 coordinate system rotation matrix generated by a */
/*     rotation of a specified angle about a specified axis. */

/* $ Disclaimer */

/*     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE */
/*     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S. */
/*     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE */
/*     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE */
/*     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS" */
/*     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY */
/*     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A */
/*     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC */
/*     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE */
/*     SOFTWARE AND RELATED MATERIALS, HOWEVER USED. */

/*     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA */
/*     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT */
/*     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND, */
/*     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS, */
/*     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE */
/*     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY. */

/*     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF */
/*     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY */
/*     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE */
/*     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE. */

/* $ Required_Reading */

/*     ROTATION */

/* $ Keywords */

/*     DERIVATIVE */
/*     MATRIX */
/*     ROTATION */

/* $ Declarations */
/* $ Brief_I/O */

/*     VARIABLE  I/O  DESCRIPTION */
/*     --------  ---  -------------------------------------------------- */
/*     ANGLE      I   Angle of rotation (radians). */
/*     IAXIS      I   Coordinate axis number (X=1, Y=2, Z=3). */
/*     DMOUT      O   Derivative of rotation matrix [ANGLE] w.r.t. angle */
/*                                                         IAXIS */

/* $ Detailed_Input */

/*     ANGLE    is the angle given in radians, through which the rotation */
/*              is performed. */

/*     IAXIS    is the coordinate axis number of the rotation. The X, Y, */
/*              and Z axes have indices 1, 2 and 3 respectively. */

/*              Together ANGLE and IAXIS define the coordinate system */
/*              rotation [ANGLE]     . */
/*                              IAXIS */

/* $ Detailed_Output */

/*     DMOUT    is the derivative of the rotation matrix with respect to */
/*              the angle of rotation. That is, DMOUT is the derivative */
/*              with respect to ANGLE of the matrix [ANGLE]     . */
/*                                                         IAXIS */

/*              (The rotation matrix being differentiated describes */
/*              the rotation of the COORDINATE system through ANGLE */
/*              radians about the axis whose index is IAXIS.) */

/* $ Parameters */

/*     None. */

/* $ Exceptions */

/*     1)  If the axis index is not in the range 1 to 3, the error */
/*         SPICE(BADAXIS) is signaled. */

/* $ Files */

/*     None. */

/* $ Particulars */

/*     A coordinate system rotation by ANGLE radians rotation about */
/*     the first, i.e. x-axis, [ANGLE]  is described by */
/*                                    1 */

/*           |  1        0          0      | */
/*           |  0   cos(ANGLE) sin(ANGLE)  | */
/*           |  0  -sin(ANGLE) cos(ANGLE)  | */

/*     A coordinate system rotation by ANGLE radians rotation about the */
/*     second, i.e. y-axis, [ANGLE]  is described by */
/*                                 2 */

/*           |  cos(ANGLE)  0  -sin(ANGLE)  | */
/*           |      0       1        0      | */
/*           |  sin(ANGLE)  0   cos(ANGLE)  | */

/*     A coordinate system rotation by ANGLE radians rotation about */
/*     the third, i.e. z-axis, [ANGLE]  is described by */
/*                         3 */

/*           |  cos(ANGLE) sin(ANGLE)   0   | */
/*           | -sin(ANGLE) cos(ANGLE)   0   | */
/*           |       0          0       1   | */

/*     The derivatives of these matrices are: */

/*     about the x-axis */

/*           |  0        0           0      | */
/*           |  0  -sin(ANGLE)  cos(ANGLE)  | */
/*           |  0  -cos(ANGLE) -sin(ANGLE)  | */

/*     about the y-axis */

/*           | -sin(ANGLE)  0  -cos(ANGLE)  | */
/*           |      0       0        0      | */
/*           |  cos(ANGLE)  0  -sin(ANGLE)  | */

/*     about the z-axis */

/*           | -sin(ANGLE)  cos(ANGLE)   0   | */
/*           | -cos(ANGLE) -sin(ANGLE)   0   | */
/*           |       0           0       0   | */

/* $ Examples */

/*     If ROTATE is called from a FORTRAN program as follows: */

/*           CALL DROTAT (PI()/4, 3, DMOUT) */

/*     then DMOUT will be */

/*           |-SQRT(2)/2   SQRT(2)/2   0  | */
/*           |-SQRT(2)/2  -SQRT(2)/2   0  | */
/*           |     0           0       0  | */

/* $ Restrictions */

/*     None. */

/* $ Literature_References */

/*     None. */

/* $ Author_and_Institution */

/*     J. Diaz del Rio    (ODC Space) */
/*     W.L. Taber         (JPL) */

/* $ Version */

/* -    SPICELIB Version 1.1.0, 12-AUG-2021 (JDR) */

/*        Added IMPLICIT NONE statement. */

/*        Edited the header to comply with NAIF standard. */

/* -    SPICELIB Version 1.0.1, 10-MAR-1992 (WLT) */

/*        Comment section for permuted index source lines was added */
/*        following the header. */

/* -    SPICELIB Version 1.0.0, 05-NOV-1990 (WLT) */

/* -& */
/* $ Index_Entries */

/*     derivative of a rotation matrix */

/* -& */

/*     First make sure the input axis is reasonable. */

    if (*iaxis > 3 || *iaxis < 1) {
	chkin_("DROTAT", (ftnlen)6);
	setmsg_("The input axis is out of range.  Its value is #.", (ftnlen)
		48);
	errint_("#", iaxis, (ftnlen)1);
	sigerr_("SPICE(BADAXIS)", (ftnlen)14);
	chkout_("DROTAT", (ftnlen)6);
	return 0;
    }

/*     Get the sine and cosine of ANGLE */

    s = sin(*angle);
    c__ = cos(*angle);

/*     Get indices for axes. The first index is for the axis of rotation. */
/*     The next two axes follow in right hand order (XYZ). */

    i1 = indexs[(i__1 = *iaxis - 1) < 5 && 0 <= i__1 ? i__1 : s_rnge("indexs",
	     i__1, "drotat_", (ftnlen)234)];
    i2 = indexs[(i__1 = *iaxis) < 5 && 0 <= i__1 ? i__1 : s_rnge("indexs", 
	    i__1, "drotat_", (ftnlen)235)];
    i3 = indexs[(i__1 = *iaxis + 1) < 5 && 0 <= i__1 ? i__1 : s_rnge("indexs",
	     i__1, "drotat_", (ftnlen)236)];

/*  Construct the rotation matrix */

    dmout[(i__1 = i1 + i1 * 3 - 4) < 9 && 0 <= i__1 ? i__1 : s_rnge("dmout", 
	    i__1, "drotat_", (ftnlen)241)] = 0.;
    dmout[(i__1 = i2 + i1 * 3 - 4) < 9 && 0 <= i__1 ? i__1 : s_rnge("dmout", 
	    i__1, "drotat_", (ftnlen)242)] = 0.;
    dmout[(i__1 = i3 + i1 * 3 - 4) < 9 && 0 <= i__1 ? i__1 : s_rnge("dmout", 
	    i__1, "drotat_", (ftnlen)243)] = 0.;
    dmout[(i__1 = i1 + i2 * 3 - 4) < 9 && 0 <= i__1 ? i__1 : s_rnge("dmout", 
	    i__1, "drotat_", (ftnlen)244)] = 0.;
    dmout[(i__1 = i2 + i2 * 3 - 4) < 9 && 0 <= i__1 ? i__1 : s_rnge("dmout", 
	    i__1, "drotat_", (ftnlen)245)] = -s;
    dmout[(i__1 = i3 + i2 * 3 - 4) < 9 && 0 <= i__1 ? i__1 : s_rnge("dmout", 
	    i__1, "drotat_", (ftnlen)246)] = -c__;
    dmout[(i__1 = i1 + i3 * 3 - 4) < 9 && 0 <= i__1 ? i__1 : s_rnge("dmout", 
	    i__1, "drotat_", (ftnlen)247)] = 0.;
    dmout[(i__1 = i2 + i3 * 3 - 4) < 9 && 0 <= i__1 ? i__1 : s_rnge("dmout", 
	    i__1, "drotat_", (ftnlen)248)] = c__;
    dmout[(i__1 = i3 + i3 * 3 - 4) < 9 && 0 <= i__1 ? i__1 : s_rnge("dmout", 
	    i__1, "drotat_", (ftnlen)249)] = -s;

    return 0;
} /* drotat_ */

