# Contributing

Thanks for reading this document and showing your interest in contributing to this project.
Contributing is very easy however we have some very basic rules whe kindly ask to follow.

When contributing to this repository, please first discuss the change you wish to make via issue.
This ensures that everybody can see what you are actually working on and will prevent unnecessary work for everybody.

Please note we have a code of conduct, please follow it in all your interactions with the project.

## Contributor Agreement
By contributing code to Ásbrú Connection Manager, you assert that:

* You have the rights to include the code, either as its original author, or due to it being released to you under a compatible license.
* You are not aware of any third party claims on the code, including copyright, patent, trademark, or any other legal claim.

To agree with these assertions, when you submit your first pull request you will be asked after submitting to sign the CLA, you do this by following the link provided in the PR and agreeing to the CLA using your GitHub account.

## Pull Request Process

1. Please ensure to test the work you have done and the build process prior to making the pull request.
2. If enhancing or changing any interfaces, environment variables or requirements please update the README.md or any other document.
3. The versioning scheme we use is [SemVer](http://semver.org/).

## Pull request title

Try to be as more descriptive as you can in your Pull Request title.

Particularly if you are submitting a new script or guide, include in the title,
information about version, OS tested on and any other relevant info.

For example some good titles would be:

[Bugfix] - Fixed connection issue for old SSH versions
[Doc] - Correct typo in installation docs

## Pull request workflow
1. You clone the original repo to your github account.
2. You make changes in cloned repo.
3. If you made a pull request inside your cloned repo for your changes the best way is 'Squash and Merge' 
   (avoids your merge commit appear as separate commit in pull request to original repo later)
4. You create pull request to original repo.
5. If this is the 1st pull request to the repo the 'CLAassistant' asks you to sign committer agreement.
6. The pull request appears on the original repo awaiting someone with write access to the repo to merge it.

The detailed info on contributing to someones github repository (easy and with screenshots) is available here: 
https://guides.github.com/activities/forking/ .
