/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers;

import org.netbeans.jemmy.JemmyException;

public class UnsupportedOperatorException
extends JemmyException {
    public UnsupportedOperatorException(Class driver, Class operator) {
        super(driver.getName() + " operators are not supported by " + operator.getName() + " driver!");
    }

    public static void checkSupported(Class driver, Class[] supported, Class operator) {
        for (int i = 0; i < supported.length; ++i) {
            if (!supported[i].isAssignableFrom(operator)) continue;
            return;
        }
        throw new UnsupportedOperatorException(driver, operator);
    }

    public static void checkSupported(Class driver, String[] supported, Class operator) {
        Class opClass = operator;
        do {
            for (int i = 0; i < supported.length; ++i) {
                if (!opClass.getName().equals(supported[i])) continue;
                return;
            }
        } while ((opClass = opClass.getSuperclass()) != null);
        throw new UnsupportedOperatorException(driver, operator);
    }
}

