/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.imageBrowser;

import ancestris.util.swing.FileChooserBuilder;
import genj.io.FileAssociation;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileSystemView;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class BrowserOptionsPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger("ancestris.app");
    private JLabel autoExtracLabel;
    private JLabel autoExtractAPIKeyLabel;
    private JTextField autoExtractAPIKeyTextField;
    private JButton jButtonAddDirectory;
    private JButton jButtonHelp;
    private JButton jButtonRemoveDirectory;
    private JButton jButtonSwapNextDirectory;
    private JButton jButtonSwapPreviousDirectory;
    private JCheckBox jCheckBoxMenu;
    private JCheckBox jCheckBoxTwoSteps;
    private JLabel jLabelDirectory;
    private JList<String> jList1;
    private JScrollPane jScrollPane2;

    public BrowserOptionsPanel() {
        this.initComponents();
    }

    public void loadPreferences() {
        this.jCheckBoxMenu.setSelected(Boolean.parseBoolean(NbPreferences.forModule(BrowserOptionsPanel.class).get("ViewMenuVisible", "true")));
        this.autoExtractAPIKeyTextField.setText(NbPreferences.forModule(BrowserOptionsPanel.class).get("ExtractServiceAPIKey", ""));
        this.jCheckBoxTwoSteps.setSelected(Boolean.parseBoolean(NbPreferences.forModule(BrowserOptionsPanel.class).get("TwoStepProcess", "false")));
        this.jList1.setModel(ImageDirectoryModel.getModel());
        if (ImageDirectoryModel.getModel().size() > 0) {
            this.jList1.setSelectedIndex(0);
        }
    }

    public void savePreferences() {
        NbPreferences.forModule(BrowserOptionsPanel.class).put("ViewMenuVisible", String.valueOf(this.jCheckBoxMenu.isSelected()));
        NbPreferences.forModule(BrowserOptionsPanel.class).put("ExtractServiceAPIKey", this.autoExtractAPIKeyTextField.getText());
        NbPreferences.forModule(BrowserOptionsPanel.class).put("TwoStepProcess", String.valueOf(this.jCheckBoxTwoSteps.isSelected()));
        ImageDirectoryModel.getModel().savePreferences();
    }

    public static String getExtractionServiceAPIKey() {
        return NbPreferences.forModule(BrowserOptionsPanel.class).get("ExtractServiceAPIKey", "");
    }

    public static void setExtractionServiceAPIKey(String value) {
        NbPreferences.forModule(BrowserOptionsPanel.class).put("ExtractServiceAPIKey", value);
    }

    public static boolean getTwoStepProcess() {
        return Boolean.parseBoolean(NbPreferences.forModule(BrowserOptionsPanel.class).get("TwoStepProcess", "false"));
    }

    public static boolean getViewMenuVisible() {
        return Boolean.parseBoolean(NbPreferences.forModule(BrowserOptionsPanel.class).get("ViewMenuVisible", "true"));
    }

    private void initComponents() {
        this.jButtonHelp = new JButton();
        this.jCheckBoxMenu = new JCheckBox();
        this.jLabelDirectory = new JLabel();
        this.jButtonAddDirectory = new JButton();
        this.jButtonRemoveDirectory = new JButton();
        this.jButtonSwapPreviousDirectory = new JButton();
        this.jButtonSwapNextDirectory = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.autoExtracLabel = new JLabel();
        this.autoExtractAPIKeyLabel = new JLabel();
        this.autoExtractAPIKeyTextField = new JTextField();
        this.jCheckBoxTwoSteps = new JCheckBox();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(BrowserOptionsPanel.class, (String)"BrowserOptionsPanel.border.title")));
        this.jButtonHelp.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Information.png")));
        this.jButtonHelp.setBorder(null);
        this.jButtonHelp.setMargin(null);
        this.jButtonHelp.setPreferredSize(new Dimension(20, 20));
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserOptionsPanel.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jCheckBoxMenu.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxMenu, (String)NbBundle.getMessage(BrowserOptionsPanel.class, (String)"BrowserOptionsPanel.jCheckBoxMenu.text"));
        this.jCheckBoxMenu.setToolTipText(NbBundle.getMessage(BrowserOptionsPanel.class, (String)"BrowserOptionsPanel.jCheckBoxMenu.toolTipText"));
        this.jLabelDirectory.setFont(this.jLabelDirectory.getFont().deriveFont(this.jLabelDirectory.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelDirectory, (String)NbBundle.getMessage(BrowserOptionsPanel.class, (String)"BrowserOptionsPanel.jLabelDirectory.text"));
        this.jLabelDirectory.setToolTipText(NbBundle.getMessage(BrowserOptionsPanel.class, (String)"BrowserOptionsPanel.jLabelDirectory.toolTipText"));
        this.jButtonAddDirectory.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/edit_add.png")));
        this.jButtonAddDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserOptionsPanel.this.jButtonAddDirectoryActionPerformed(evt);
            }
        });
        this.jButtonRemoveDirectory.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/edit_delete.png")));
        this.jButtonRemoveDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserOptionsPanel.this.jButtonRemoveDirectoryActionPerformed(evt);
            }
        });
        this.jButtonSwapPreviousDirectory.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/arrowup16.png")));
        this.jButtonSwapPreviousDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserOptionsPanel.this.jButtonSwapPreviousDirectoryActionPerformed(evt);
            }
        });
        this.jButtonSwapNextDirectory.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/arrowdown16.png")));
        this.jButtonSwapNextDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserOptionsPanel.this.jButtonSwapNextDirectoryActionPerformed(evt);
            }
        });
        this.jScrollPane2.setMaximumSize(new Dimension(800, 130));
        this.jScrollPane2.setMinimumSize(new Dimension(50, 23));
        this.jScrollPane2.setPreferredSize(new Dimension(300, 60));
        this.jScrollPane2.setRequestFocusEnabled(false);
        this.jList1.setSelectionMode(0);
        this.jList1.setToolTipText(NbBundle.getMessage(BrowserOptionsPanel.class, (String)"BrowserOptionsPanel.jList1.toolTipText"));
        this.jList1.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jList1.setMinimumSize(new Dimension(100, 80));
        this.jScrollPane2.setViewportView(this.jList1);
        this.autoExtracLabel.setFont(this.autoExtracLabel.getFont().deriveFont(this.autoExtracLabel.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.autoExtracLabel, (String)NbBundle.getMessage(BrowserOptionsPanel.class, (String)"BrowserOptionsPanel.autoExtracLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.autoExtractAPIKeyLabel, (String)NbBundle.getMessage(BrowserOptionsPanel.class, (String)"BrowserOptionsPanel.autoExtractAPIKeyLabel.text"));
        this.autoExtractAPIKeyTextField.setText(NbBundle.getMessage(BrowserOptionsPanel.class, (String)"BrowserOptionsPanel.autoExtractAPIKeyTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxTwoSteps, (String)NbBundle.getMessage(BrowserOptionsPanel.class, (String)"BrowserOptionsPanel.jCheckBoxTwoSteps.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelDirectory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, -2, 16, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSwapNextDirectory, GroupLayout.Alignment.TRAILING).addComponent(this.jButtonRemoveDirectory, GroupLayout.Alignment.TRAILING).addComponent(this.jButtonAddDirectory, GroupLayout.Alignment.TRAILING).addComponent(this.jButtonSwapPreviousDirectory, GroupLayout.Alignment.TRAILING))).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxTwoSteps).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.autoExtractAPIKeyLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoExtractAPIKeyTextField)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoExtracLabel).addComponent(this.jCheckBoxMenu)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jButtonHelp, -2, 16, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelDirectory))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAddDirectory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRemoveDirectory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSwapPreviousDirectory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSwapNextDirectory)).addComponent(this.jScrollPane2, -2, 130, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxMenu).addGap(18, 18, 18).addComponent(this.autoExtracLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoExtractAPIKeyTextField, -2, -1, -2).addComponent(this.autoExtractAPIKeyLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxTwoSteps).addContainerGap()));
    }

    private void jButtonAddDirectoryActionPerformed(ActionEvent evt) {
        File defaultDirectory;
        if (this.jList1.getSelectedValue() != null) {
            defaultDirectory = new File(this.jList1.getSelectedValue());
        } else {
            FileSystemView fsv = FileSystemView.getFileSystemView();
            defaultDirectory = fsv.getDefaultDirectory();
        }
        File file = new FileChooserBuilder(BrowserOptionsPanel.class).setDirectoriesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(this.getClass(), (String)"BrowserOptionsPanel.dialogTitle.text")).setApproveText(NbBundle.getMessage(this.getClass(), (String)"BrowserOptionsPanel.dialogTitle.ok")).setSelectedFile(defaultDirectory).setFileHiding(true).showOpenDialog();
        if (file != null) {
            try {
                String directory = file.getCanonicalPath();
                ImageDirectoryModel.updateDirectory(directory);
                this.jList1.setSelectedValue(directory, true);
            }
            catch (IOException ex) {
                return;
            }
        }
    }

    private void jButtonRemoveDirectoryActionPerformed(ActionEvent evt) {
        for (String directory : this.jList1.getSelectedValuesList()) {
            ImageDirectoryModel.getModel().removeElement(directory);
        }
    }

    private void jButtonSwapPreviousDirectoryActionPerformed(ActionEvent evt) {
        int index = this.jList1.getSelectedIndex();
        if (ImageDirectoryModel.getModel().swapPrevious(index)) {
            this.jList1.setSelectedIndex(index - 1);
        }
    }

    private void jButtonSwapNextDirectoryActionPerformed(ActionEvent evt) {
        int index = this.jList1.getSelectedIndex();
        if (ImageDirectoryModel.getModel().swapNext(index)) {
            this.jList1.setSelectedIndex(index + 1);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        try {
            FileAssociation.getDefault().execute(new URL(NbBundle.getMessage(BrowserOptionsPanel.class, (String)"Releve.helpPage")));
        }
        catch (MalformedURLException ex) {
            LOG.log(Level.FINE, "Unable to open File", ex);
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static class ImageDirectoryModel
    extends DefaultListModel<String> {
        static final String ImageBrowserDirectoryPreference = "ImageBrowserDirectories";
        private static ImageDirectoryModel imageDirectoryModel = null;

        public File[] getImageBrowserDirectories() {
            ArrayList<File> directories = new ArrayList<File>();
            for (int i = 0; i < imageDirectoryModel.size(); ++i) {
                File directory = new File((String)imageDirectoryModel.get(i));
                if (!directory.exists()) continue;
                directories.add(directory);
            }
            return directories.toArray(new File[0]);
        }

        public static ImageDirectoryModel getModel() {
            if (imageDirectoryModel == null) {
                imageDirectoryModel = new ImageDirectoryModel();
                imageDirectoryModel.loadPreferences();
            }
            return imageDirectoryModel;
        }

        private void loadPreferences() {
            this.clear();
            String similarString = NbPreferences.forModule(ImageDirectoryModel.class).get(ImageBrowserDirectoryPreference, "");
            String[] values = similarString.split(";");
            for (int i = 0; i < values.length; ++i) {
                if (values[i].isEmpty()) continue;
                this.addElement(values[i]);
            }
        }

        private void savePreferences() {
            StringBuilder values = new StringBuilder();
            for (int i = 0; i < this.size(); ++i) {
                values.append((String)this.get(i)).append(";");
            }
            NbPreferences.forModule(ImageDirectoryModel.class).put(ImageBrowserDirectoryPreference, values.toString());
        }

        public static void updateDirectory(String directory) {
            int index = ImageDirectoryModel.getModel().indexOf(directory);
            if (index == -1) {
                ImageDirectoryModel.getModel().addElement(directory);
            }
        }

        private boolean swapNext(int index) {
            if (index < this.size() - 1 && index != -1) {
                String directory = (String)this.remove(index);
                this.insertElementAt(directory, index + 1);
                return true;
            }
            Toolkit.getDefaultToolkit().beep();
            return false;
        }

        private boolean swapPrevious(int index) {
            if (index > 0) {
                String directory = (String)this.remove(index);
                this.insertElementAt(directory, index - 1);
                return true;
            }
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
    }
}

