/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer.views;

import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.renderer.BlueprintRenderer;
import genj.renderer.views.MyView;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.util.HashMap;
import javax.swing.text.Element;

public class I18NView
extends MyView {
    private String txt = "?";
    private TagPath path = null;
    private boolean underline = false;

    public I18NView(Element elem, BlueprintRenderer rdr) {
        super(elem, rdr);
        Object o = elem.getAttributes().getAttribute("tag");
        if (o != null) {
            this.txt = Gedcom.getName(o.toString());
        } else {
            o = elem.getAttributes().getAttribute("path");
            if (o != null) {
                this.path = new TagPath(o.toString());
            } else {
                o = elem.getAttributes().getAttribute("entity");
                if (o != null) {
                    this.txt = Gedcom.getName(o.toString());
                }
            }
        }
        o = elem.getAttributes().getAttribute("underline");
        if (o != null && !"no".equals(o)) {
            this.underline = true;
        }
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        Rectangle r = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
        Font myFont = this.getFont();
        if (this.underline) {
            HashMap<TextAttribute, Integer> fontAttributes = new HashMap<TextAttribute, Integer>();
            fontAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            myFont = super.getFont().deriveFont(fontAttributes);
        }
        g.setFont(myFont);
        g.setColor(this.getForeground());
        this.render(this.getRenderedText(), (Graphics2D)g, r);
    }

    @Override
    protected Dimension2D getPreferredSpan() {
        FontMetrics fm = this.getRenderer().getGraphics().getFontMetrics(this.getFont());
        return new Dimension(fm.stringWidth(this.getRenderedText()), fm.getAscent() + fm.getDescent());
    }

    private String getRenderedText() {
        if (this.path != null) {
            String text;
            Property prop = this.getRenderer().getEntity().getProperty(this.path);
            String string = text = prop != null ? prop.getTag() : this.path.getLast();
            if ("EVEN".equals(text)) {
                String string2 = text = prop != null ? prop.getPropertyValue("TYPE") : "";
                if (text.isEmpty()) {
                    text = Gedcom.getName("EVEN");
                }
                return text;
            }
            return Gedcom.getName(text);
        }
        return this.txt;
    }

    @Override
    public String getHTMLValue(int width, int height, File imageDir) {
        return this.getRenderedText();
    }
}

