/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util.swing;

import ancestris.util.EventUsage;
import ancestris.util.GedcomUtilities;
import ancestris.util.swing.PotentialMatch;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyFamilyChild;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.PropertyHusband;
import genj.gedcom.PropertyWife;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import genj.util.Registry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.openide.util.NbBundle;

public class MergeEntityPanel
extends JPanel {
    private static final int DUPLICATE_THRESHOLD = 50;
    private static final Set<String> DISABLED_TAGS = new HashSet<String>(Arrays.asList("CREA", "CHAN"));
    private static final Set<String> DATED_TAGS = new HashSet<String>();
    private Registry registry = null;
    private final HashMap<String, Integer> tagMap = new HashMap();
    private final HashMap<String, Integer> tagMap2 = new HashMap();
    private final List<PropertyRow> propRows = new ArrayList<PropertyRow>();
    private boolean isMerged = false;
    private final JLabel dummyLabel = new JLabel();
    private final JButton entAButton = new JButton();
    private final JButton entBButton = new JButton();
    private final JSeparator dummySeparator = new JSeparator();
    private final Action goToLeft;
    private final Action goToRight;
    private List<PotentialMatch<? extends Entity>> duplicateList = null;
    private JScrollPane scrollPane;
    private static final TagPath SORT_SIBLINGS = new TagPath(".:BIRT:DATE");
    private static final TagPath SORT_SIBLINGS_CHR = new TagPath(".:CHR:DATE");
    private static final TagPath SORT_FAM = new TagPath(".:MARR:DATE");
    private static final TagPath SORT_FAM_MARC = new TagPath(".:MARC:DATE");

    public MergeEntityPanel(Gedcom gedcom, List<PotentialMatch<? extends Entity>> duplicateList) {
        this.registry = gedcom.getRegistry();
        this.duplicateList = duplicateList;
        this.initSortMaps();
        this.initComponents();
        this.setPreferredSize(new Dimension(this.registry.get("searchDuplicatesWindowWidth", this.getPreferredSize().width), this.registry.get("searchDuplicatesWindowHeight", this.getPreferredSize().height)));
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.goToLeft = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeEntityPanel.this.showLeftEntity();
            }
        };
        this.goToRight = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeEntityPanel.this.showRightEntity();
            }
        };
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.setMinimumSize(new Dimension(50, 30));
        this.setPreferredSize(new Dimension(300, 310));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                MergeEntityPanel.this.formComponentResized(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, GroupLayout.Alignment.TRAILING));
    }

    private void formComponentResized(ComponentEvent evt) {
        this.registry.put("searchDuplicatesWindowWidth", evt.getComponent().getWidth());
        this.registry.put("searchDuplicatesWindowHeight", evt.getComponent().getHeight());
    }

    public void setEntities(Entity leftEntity, Entity rightEntity, boolean isMerged) {
        this.isMerged = isMerged;
        this.propRows.clear();
        this.propRows.add(new PropertyRow(0, leftEntity.getPropertyName() + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ID"), leftEntity, rightEntity, false, true));
        this.entAButton.setAction(this.goToLeft);
        this.entBButton.setAction(this.goToRight);
        this.entAButton.setText(leftEntity.getId() + " = " + leftEntity.toString(false));
        this.entBButton.setText((String)(isMerged ? "  -  " : rightEntity.getId() + " = " + rightEntity.toString(false)));
        this.entBButton.setEnabled(!isMerged);
        List<TagPath> firstLevelTagPaths = this.getTagPaths(leftEntity, rightEntity);
        Collections.sort(firstLevelTagPaths, new CompareTagPath());
        for (TagPath tagPath : firstLevelTagPaths) {
            AlignedProperties lists = new AlignedProperties(leftEntity, rightEntity, tagPath);
            Property[] leftProperties = lists.getLeft();
            Property[] rightProperties = lists.getRight();
            for (int index = 0; index < Math.max(leftProperties.length, rightProperties.length); ++index) {
                Property leftP = index >= leftProperties.length ? null : leftProperties[index];
                Property rightP = index >= rightProperties.length ? null : rightProperties[index];
                String label = this.getLabelFromProperty(leftEntity, rightEntity, tagPath, leftP, rightP);
                this.propRows.add(new PropertyRow(1, label, leftP, rightP, true, DISABLED_TAGS.contains(tagPath.getLast())));
                List<TagPath> secondLevelTagPaths = this.getTagPaths(leftP, rightP);
                Collections.sort(secondLevelTagPaths, new CompareTagPath2());
                for (TagPath tagPath2 : secondLevelTagPaths) {
                    AlignedProperties lists2 = new AlignedProperties(leftP, rightP, tagPath2);
                    Property[] leftProperties2 = lists2.getLeft();
                    Property[] rightProperties2 = lists2.getRight();
                    for (int index2 = 0; index2 < Math.max(leftProperties2.length, rightProperties2.length); ++index2) {
                        Property leftP2 = index2 >= leftProperties2.length ? null : leftProperties2[index2];
                        Property rightP2 = index2 >= rightProperties2.length ? null : rightProperties2[index2];
                        String label2 = this.getLabelFromProperty(leftEntity, rightEntity, tagPath, leftP2, rightP2);
                        this.propRows.add(new PropertyRow(2, label2, leftP2, rightP2, false, tagPath2.contains("*")));
                    }
                }
            }
        }
        this.drawPanelElements();
    }

    private void showLeftEntity() {
        if (!this.propRows.isEmpty()) {
            SelectionDispatcher.fireSelection(new Context(this.propRows.get((int)0).propA));
        }
    }

    private void showRightEntity() {
        if (!this.propRows.isEmpty()) {
            SelectionDispatcher.fireSelection(new Context(this.propRows.get((int)0).propB));
        }
    }

    private void drawPanelElements() {
        JPanel panel = new JPanel();
        GroupLayout panelLayout = new GroupLayout(panel);
        panel.setLayout(panelLayout);
        GroupLayout.ParallelGroup pg = panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup sgH = panelLayout.createSequentialGroup();
        GroupLayout.ParallelGroup pgHH = panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup pgHHA = panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup pgHHB = panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        pgHH.addComponent(this.dummyLabel);
        pgHHA.addComponent(this.entAButton, -2, 0, Short.MAX_VALUE);
        pgHHB.addComponent(this.entBButton, -2, 0, Short.MAX_VALUE);
        for (PropertyRow row : this.propRows) {
            pgHH.addComponent(row.label);
            pgHHA.addComponent(row.compA, -2, 0, Short.MAX_VALUE);
            pgHHB.addComponent(row.compB, -2, 0, Short.MAX_VALUE);
        }
        sgH.addContainerGap();
        sgH.addGroup(pgHH);
        sgH.addGap(18, 18, 18);
        sgH.addGroup(pgHHA);
        sgH.addGap(18, 18, 18);
        sgH.addGroup(pgHHB);
        sgH.addContainerGap();
        pg.addGroup(sgH);
        sgH = panelLayout.createSequentialGroup();
        sgH.addContainerGap();
        sgH.addComponent(this.dummySeparator);
        sgH.addContainerGap();
        pg.addGroup(sgH);
        for (PropertyRow row : this.propRows) {
            if (!row.separator) continue;
            sgH = panelLayout.createSequentialGroup();
            sgH.addContainerGap();
            sgH.addComponent(row.jSeparator);
            sgH.addContainerGap();
            pg.addGroup(sgH);
        }
        panelLayout.setHorizontalGroup(pg);
        GroupLayout.SequentialGroup sgV = panelLayout.createSequentialGroup();
        sgV.addContainerGap();
        sgV.addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.dummyLabel).addComponent(this.entAButton, -2, -1, -2).addComponent(this.entBButton, -2, -1, -2));
        sgV.addComponent(this.dummySeparator, -2, 10, -2);
        for (PropertyRow row : this.propRows) {
            if (row.separator) {
                sgV.addComponent(row.jSeparator, -2, 10, -2);
            }
            sgV.addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(row.label).addComponent(row.compA, -2, -1, -2).addComponent(row.compB, -2, -1, -2));
            sgV.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        }
        sgV.addContainerGap(-1, Short.MAX_VALUE);
        panelLayout.setVerticalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sgV));
        this.scrollPane.setViewportView(panel);
    }

    public Map<Property, Boolean> getSelectedProperties() {
        HashMap<Property, Boolean> selectedProperties = new HashMap<Property, Boolean>();
        for (PropertyRow row : this.propRows) {
            if (!row.isBSelected()) continue;
            selectedProperties.put(row.propB, row.checkPropA.isSelected());
        }
        HashMap<Property, Boolean> ret = new HashMap<Property, Boolean>();
        boolean found = false;
        for (Property prop : selectedProperties.keySet()) {
            if (prop == null) continue;
            found = false;
            for (Property parent : MergeEntityPanel.getAncestors(prop)) {
                if (!selectedProperties.keySet().contains(parent)) continue;
                found = true;
                break;
            }
            if (found) continue;
            ret.put(prop, (Boolean)selectedProperties.get(prop));
        }
        return ret;
    }

    private static List<Property> getAncestors(Property prop) {
        ArrayList<Property> ancestors = new ArrayList<Property>();
        for (Property parent = prop.getParent(); parent != null; parent = parent.getParent()) {
            ancestors.add(parent);
        }
        return ancestors;
    }

    private List<TagPath> getTagPaths(Property pLeft, Property pRight) {
        HashSet<String> stringPaths = new HashSet<String>();
        Object pathPrefix = "";
        Object tmpStr = "";
        if (pLeft != null) {
            if (pLeft instanceof PropertyFamilySpouse || pLeft instanceof PropertyFamilyChild) {
                pathPrefix = "." + TagPath.SEPARATOR_STRING + "*" + TagPath.SEPARATOR_STRING + ".." + TagPath.SEPARATOR_STRING;
                pLeft = ((PropertyXRef)pLeft).getTargetParent().orElse(null);
            }
            if (pLeft != null) {
                for (Property property : pLeft.getProperties()) {
                    tmpStr = pLeft.getPathToNested(property).toString();
                    if (!((String)pathPrefix).isEmpty()) {
                        tmpStr = (String)pathPrefix + ((String)tmpStr).substring(((String)tmpStr).indexOf(TagPath.SEPARATOR_STRING) + 1);
                    }
                    stringPaths.add((String)tmpStr);
                }
            }
        }
        pathPrefix = "";
        tmpStr = "";
        if (pRight != null) {
            if (pRight instanceof PropertyFamilySpouse || pRight instanceof PropertyFamilyChild) {
                pathPrefix = "." + TagPath.SEPARATOR_STRING + "*" + TagPath.SEPARATOR_STRING + ".." + TagPath.SEPARATOR_STRING;
                pRight = ((PropertyXRef)pRight).getTargetParent().orElse(null);
            }
            if (pRight != null) {
                for (Property property : pRight.getProperties()) {
                    tmpStr = pRight.getPathToNested(property).toString();
                    if (!((String)pathPrefix).isEmpty()) {
                        tmpStr = (String)pathPrefix + ((String)tmpStr).substring(((String)tmpStr).indexOf(TagPath.SEPARATOR_STRING) + 1);
                    }
                    stringPaths.add((String)tmpStr);
                }
            }
        }
        ArrayList<TagPath> tagPaths = new ArrayList<TagPath>();
        for (String str : stringPaths) {
            tagPaths.add(new TagPath(str));
        }
        return tagPaths;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getLabelFromProperty(Entity leftEnt, Entity rightEnt, TagPath tagPath, Property leftP, Property rightP) {
        int i;
        String str;
        Property p;
        Object ret = "";
        Property property = p = leftP != null ? leftP : rightP;
        if (p.getTag().equals("FAMC")) {
            return NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.Parents");
        }
        if (p.getTag().equals("FAMS")) {
            return NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.Spouse");
        }
        if (p.getTag().equals("XREF")) {
            return NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.Reference");
        }
        if (p.getTag().equals("HUSB") && tagPath.contains("FAMC")) {
            return NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.Father");
        }
        if (p.getTag().equals("WIFE") && tagPath.contains("FAMC")) {
            return NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.Mother");
        }
        if (p instanceof PropertyChild) {
            PropertyChild pChild = (PropertyChild)p;
            if (tagPath.contains("FAMC")) {
                int childSex = pChild.getChild().getSex();
                Object object = childSex == 1 ? (ret = NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.Brother")) : (ret = childSex == 2 ? (ret = NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.Sister")) : NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.BrotherSister"));
                if (pChild.getChild().equals(leftEnt)) {
                    if (rightP == null) return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisLeft");
                    if (!(rightP instanceof PropertyChild)) return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisLeft");
                    PropertyChild rChild = (PropertyChild)rightP;
                    if (!rChild.getChild().equals(rightEnt)) return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisLeft");
                    return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisBoth");
                }
                if (!pChild.getChild().equals(rightEnt)) return ret;
                return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisRight");
            }
        }
        if (p instanceof PropertyChild) {
            PropertyChild pChild = (PropertyChild)p;
            if (tagPath.contains("FAMS")) {
                int childSex = pChild.getChild().getSex();
                Object object = childSex == 1 ? (ret = NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.Son")) : (ret = childSex == 2 ? (ret = NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.Daughter")) : NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.Child"));
                if (pChild.getChild().equals(leftEnt)) {
                    if (rightP == null) return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisLeft");
                    if (!(rightP instanceof PropertyChild)) return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisLeft");
                    PropertyChild rChild = (PropertyChild)rightP;
                    if (!rChild.getChild().equals(rightEnt)) return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisLeft");
                    return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisBoth");
                }
                if (!pChild.getChild().equals(rightEnt)) return ret;
                return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisRight");
            }
        }
        if (p instanceof PropertyHusband) {
            PropertyHusband pHusb = (PropertyHusband)p;
            if (tagPath.contains("FAMS")) {
                ret = p.getPropertyName();
                if (pHusb.getHusband().equals(leftEnt)) {
                    if (rightP == null) return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisLeft");
                    if (!(rightP instanceof PropertyHusband)) return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisLeft");
                    PropertyHusband rHusb = (PropertyHusband)rightP;
                    if (!rHusb.getHusband().equals(rightEnt)) return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisLeft");
                    return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisBoth");
                }
                if (!pHusb.getHusband().equals(rightEnt)) return ret;
                return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisRight");
            }
        }
        if (!(p instanceof PropertyWife)) return str.substring(0, (i = (str = p.getPropertyName()).indexOf(" ")) != -1 ? i : str.length());
        PropertyWife pWife = (PropertyWife)p;
        if (!tagPath.contains("FAMS")) return str.substring(0, (i = (str = p.getPropertyName()).indexOf(" ")) != -1 ? i : str.length());
        ret = p.getPropertyName();
        if (pWife.getWife().equals(leftEnt)) {
            if (rightP == null) return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisLeft");
            if (!(rightP instanceof PropertyWife)) return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisLeft");
            PropertyWife rWife = (PropertyWife)rightP;
            if (!rWife.getWife().equals(rightEnt)) return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisLeft");
            return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisBoth");
        }
        if (!pWife.getWife().equals(rightEnt)) return ret;
        return (String)ret + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ThisRight");
    }

    public String getTextFromProperty(int level, Property p) {
        Object ret = "-";
        if (p != null) {
            if (p instanceof Entity) {
                ret = ((Entity)p).getId();
            } else if (p instanceof PropertyFamilyChild || p instanceof PropertyFamilySpouse) {
                PropertyXRef xref = (PropertyXRef)p;
                ret = xref.isValid() ? xref.getTarget().getEntity().getId() : "";
            } else if ((p.getTag().equals("MARR") || p.getTag().equals("MARC") || p.getTag().equals("DIV")) && level == 2) {
                ret = "";
                ret = (String)ret + (String)(p.getProperty("DATE") != null ? p.getProperty("DATE") + "<br>" : "");
                if (((String)(ret = (String)ret + (Comparable)(p.getProperty("PLAC") != null ? p.getProperty("PLAC") : ""))).isBlank()) {
                    ret = p.getDisplayValue();
                }
            } else if (p.getTag().equals("ADDR") && level == 2) {
                ret = "";
                ret = (String)ret + (String)(p.getProperty("CITY") != null ? p.getProperty("CITY").getDisplayValue() + ", " : "");
                ret = (String)ret + (p.getProperty("CTRY") != null ? p.getProperty("CTRY").getDisplayValue() : "");
            } else if ((p.getTag().equals("HUSB") || p.getTag().equals("WIFE")) && !p.getParent().getTag().equals("FAM") && level == 2) {
                ret = "";
                ret = (String)ret + (Comparable)(p.getProperty("AGE") != null ? p.getProperty("AGE") : "");
            } else if (p.getTag().equals("EVEN") && p.getEntity() instanceof Source) {
                ret = p.getDisplayValue() + "<br>";
                ret = (String)ret + (String)(p.getProperty("DATE") != null ? p.getProperty("DATE") + "<br>" : "");
                if (((String)(ret = (String)ret + (Comparable)(p.getProperty("PLAC") != null ? p.getProperty("PLAC") : ""))).isBlank()) {
                    ret = p.getDisplayValue();
                }
            } else {
                ret = p.getDisplayValue();
            }
        }
        return "<html>" + (String)ret + "</html>";
    }

    private void initSortMaps() {
        DATED_TAGS.addAll(GedcomConstants.TAG_YES_EVENTS);
        DATED_TAGS.addAll((Collection<String>)GedcomConstants.TAG_ATTR_EVENTS_MAP.get(Grammar.V70));
        int i = 0;
        this.tagMap.put("INDI:NAME", i++);
        this.tagMap.put("INDI:SEX", i++);
        this.tagMap.put("INDI:FAMC", i++);
        this.tagMap.put("INDI:BIRT", i++);
        this.tagMap.put("INDI:CHR", i++);
        this.tagMap.put("INDI:FAMS", i++);
        this.tagMap.put("INDI:OCCU", i++);
        this.tagMap.put("INDI:DEAT", i++);
        this.tagMap.put("INDI:BURI", i++);
        this.tagMap.put("INDI:RETI", i++);
        this.tagMap.put("INDI:RESI", i++);
        for (String eventTag : EventUsage.otherEventsList) {
            String key = "INDI:" + eventTag;
            if (this.tagMap.get(key) != null) continue;
            this.tagMap.put(key, i++);
        }
        this.tagMap.put("INDI:OBJE", i++);
        this.tagMap.put("INDI:NOTE", i++);
        this.tagMap.put("INDI:ASSO", i++);
        this.tagMap.put("INDI:ALIA", i++);
        this.tagMap.put("INDI:XREF", i++);
        this.tagMap.put("FAM:HUSB", i++);
        this.tagMap.put("FAM:WIFE", i++);
        this.tagMap.put("FAM:CHIL", i++);
        this.tagMap.put("FAM:MARR", i++);
        this.tagMap.put("FAM:MARC", i++);
        this.tagMap.put("FAM:DIV", i++);
        this.tagMap.put("SUBM:NAME", i++);
        this.tagMap.put("SUBM:ADDR", i++);
        this.tagMap.put("SUBM:PHON", i++);
        this.tagMap.put("SUBM:EMAIL", i++);
        this.tagMap.put("SUBM:WWW", i++);
        this.tagMap.put("REPO:NAME", i++);
        this.tagMap.put("REPO:ADDR", i++);
        this.tagMap.put("REPO:PHON", i++);
        this.tagMap.put("REPO:EMAIL", i++);
        this.tagMap.put("REPO:WWW", i++);
        this.tagMap.put("SOUR:TITL", i++);
        this.tagMap.put("SOUR:ABBR", i++);
        this.tagMap.put("SOUR:AUTH", i++);
        this.tagMap.put("SOUR:TEXT", i++);
        this.tagMap.put("SOUR:PUBL", i++);
        this.tagMap.put("OBJE:FILE", i++);
        this.tagMap.put("OBJE:FILE:TITL", i++);
        this.tagMap2.put("TYPE", i++);
        this.tagMap2.put("DATE", i++);
        this.tagMap2.put("AGE", i++);
        this.tagMap2.put("PLAC", i++);
        this.tagMap2.put("ADDR", i++);
        this.tagMap2.put("HUSB", i++);
        this.tagMap2.put("WIFE", i++);
        this.tagMap2.put("MARR", i++);
        this.tagMap2.put("CHIL", i++);
    }

    private int sortTag(TagPath t1, TagPath t2, String tag1, String tag2, String tag) {
        if (tag1.equals(tag) && !tag2.startsWith(tag)) {
            return 1;
        }
        if (!tag1.startsWith(tag) && tag2.startsWith(tag)) {
            return -1;
        }
        if (tag1.startsWith(tag) && tag2.startsWith(tag)) {
            return t1.compareTo(t2);
        }
        return 5;
    }

    private class PropertyRow {
        public Property propA = null;
        public Property propB = null;
        public boolean separator = false;
        public JSeparator jSeparator;
        public JLabel label = new JLabel();
        public JComponent compA = null;
        public JComponent compB = null;
        private final JLabel labelA = new JLabel();
        private final JLabel labelB = new JLabel();
        private JCheckBox checkPropA = new JCheckBox();
        private JCheckBox checkPropB = new JCheckBox();
        private boolean same = false;
        private boolean duplicates = false;
        private boolean crea_or_chan = false;

        public PropertyRow(int level, String label, Property propA, Property propB, boolean separator, boolean forInfoOnly) {
            this.propA = propA;
            this.propB = propB;
            this.separator = separator;
            this.jSeparator = separator ? new JSeparator() : null;
            Property prop = propA != null ? propA : propB;
            boolean bold = separator || prop instanceof Entity;
            this.label.setText((bold ? "" : "   ") + label);
            this.label.setIcon(prop.getImage());
            if (bold) {
                this.label.setFont(new Font("Default", 1, 12));
            }
            if (forInfoOnly) {
                Color color;
                this.compA = this.labelA;
                this.compB = this.labelB;
                this.labelA.setText(MergeEntityPanel.this.getTextFromProperty(level, propA));
                this.labelB.setText(MergeEntityPanel.this.getTextFromProperty(level, propB));
                boolean bl = this.same = propA instanceof Entity || propA != null && propB != null && GedcomUtilities.normalizeString(this.labelA.getText()).equals(GedcomUtilities.normalizeString(this.labelB.getText()));
                if (this.same && propA != null && propB != null && propA.getNoOfProperties() != 0 && propB.getNoOfProperties() != 0) {
                    this.same = this.samePropChildren(propA, propB);
                }
                this.duplicates = this.areDuplicates(this.same, propA, propB);
                this.crea_or_chan = propA != null && DISABLED_TAGS.contains(propA.getTag());
                Color color2 = color = this.same || this.duplicates ? Color.BLUE : Color.red;
                if (MergeEntityPanel.this.isMerged) {
                    color = new Color(0, 94, 20);
                } else {
                    this.labelA.setIcon(propA == null ? prop.getImage() : propA.getImage());
                    this.labelB.setIcon(propB == null ? prop.getImage() : propB.getImage());
                }
                this.labelA.setBorder(BorderFactory.createEmptyBorder(0, 25, 0, 0));
                this.labelB.setBorder(BorderFactory.createEmptyBorder(0, 25, 0, 0));
                this.labelA.setEnabled(!this.crea_or_chan);
                this.labelB.setEnabled(!MergeEntityPanel.this.isMerged && !this.same && !this.crea_or_chan || propA instanceof Entity);
                this.labelA.setForeground(color);
                this.labelB.setForeground(color);
            } else {
                Color color;
                this.compA = this.checkPropA;
                this.compB = this.checkPropB;
                this.checkPropA.setText(MergeEntityPanel.this.getTextFromProperty(level, propA));
                this.checkPropB.setText(MergeEntityPanel.this.getTextFromProperty(level, propB));
                boolean bl = this.same = propA instanceof Entity || propA != null && propB != null && GedcomUtilities.normalizeString(this.checkPropA.getText()).equals(GedcomUtilities.normalizeString(this.checkPropB.getText()));
                if (this.same && propA != null && propB != null && propA.getNoOfProperties() != 0 && propB.getNoOfProperties() != 0) {
                    this.same = this.samePropChildren(propA, propB);
                }
                this.duplicates = this.areDuplicates(this.same, propA, propB);
                Color color3 = color = this.same || this.duplicates ? Color.BLUE : Color.red;
                if (MergeEntityPanel.this.isMerged) {
                    color = new Color(0, 94, 20);
                }
                this.checkPropA.setSelected(propA != null);
                this.checkPropB.setSelected(propA == null);
                this.checkPropA.setEnabled(!this.crea_or_chan);
                this.checkPropB.setEnabled(!MergeEntityPanel.this.isMerged && !this.same && !this.crea_or_chan);
                this.checkPropA.setForeground(color);
                this.checkPropB.setForeground(color);
                if (prop.getGedcom() != null) {
                    if (prop.getMetaProperty().isSingleton()) {
                        this.checkPropA.addActionListener(e -> this.checkPropB.setSelected(!MergeEntityPanel.this.isMerged && !this.checkPropA.isSelected()));
                        this.checkPropB.addActionListener(e -> this.checkPropA.setSelected(!MergeEntityPanel.this.isMerged && !this.checkPropB.isSelected()));
                    } else {
                        this.checkPropA.addActionListener(e -> {
                            if (!(MergeEntityPanel.this.isMerged || this.checkPropA.isSelected() || this.checkPropB.isSelected())) {
                                this.checkPropB.setSelected(true);
                            }
                        });
                        this.checkPropB.addActionListener(e -> {
                            if (!(MergeEntityPanel.this.isMerged || this.checkPropA.isSelected() || this.checkPropB.isSelected())) {
                                this.checkPropA.setSelected(true);
                            }
                        });
                    }
                } else {
                    this.checkPropA.addActionListener(e -> this.checkPropA.setSelected(true));
                }
            }
        }

        public boolean isBSelected() {
            return this.checkPropB.isSelected();
        }

        private boolean areDuplicates(boolean same, Property propA, Property propB) {
            Fam famA;
            if (same || MergeEntityPanel.this.duplicateList == null) {
                return false;
            }
            if (propA instanceof Entity) {
                Entity entA = (Entity)propA;
                if (propB instanceof Entity) {
                    Entity entB = (Entity)propB;
                    return this.isDuplicate(propA, propB) || entA.toString(false).equals(entB.toString(false));
                }
            }
            if (propA instanceof PropertyFamilyChild && propB instanceof PropertyFamilyChild) {
                famA = ((PropertyFamilyChild)propA).getFamily();
                Fam famB = ((PropertyFamilyChild)propB).getFamily();
                return this.isDuplicate(famA, famB);
            }
            if (propA instanceof PropertyFamilySpouse && propB instanceof PropertyFamilySpouse) {
                famA = ((PropertyFamilySpouse)propA).getFamily();
                Fam famB = ((PropertyFamilySpouse)propB).getFamily();
                return this.isDuplicate(famA, famB);
            }
            if (propA instanceof PropertyXRef) {
                PropertyXRef pxrefA = (PropertyXRef)propA;
                if (propB instanceof PropertyXRef) {
                    PropertyXRef pxrefB = (PropertyXRef)propB;
                    return pxrefA.isValid() && pxrefB.isValid() && this.isDuplicate(pxrefA.getTargetEntity().get(), pxrefB.getTargetEntity().get());
                }
            }
            return false;
        }

        private boolean isDuplicate(Fam famA, Fam famB) {
            return this.isDuplicate(famA.getHusband(), famB.getHusband()) && this.isDuplicate(famA.getWife(), famB.getWife());
        }

        private boolean isDuplicate(Property propA, Property propB) {
            for (PotentialMatch<? extends Entity> duplicateItem : MergeEntityPanel.this.duplicateList) {
                if (duplicateItem.getLeft().equals(propA) && duplicateItem.getRight().equals(propB) && duplicateItem.getCertainty() >= 50) {
                    return true;
                }
                if (!duplicateItem.getLeft().equals(propB) || !duplicateItem.getRight().equals(propA) || duplicateItem.getCertainty() < 50) continue;
                return true;
            }
            return GedcomUtilities.isSameValue(propA, propB);
        }

        private boolean samePropChildren(Property propA, Property propB) {
            List<Property> propertiesA = Arrays.asList(propA.getProperties());
            List<Property> propertiesB = Arrays.asList(propB.getProperties());
            if (propertiesA.size() != propertiesB.size()) {
                return false;
            }
            Comparator comparator = (o1, o2) -> {
                if (!o1.getTag().equals(o2.getTag())) {
                    return o1.getDisplayValue().compareTo(o2.getDisplayValue());
                }
                return o1.getTag().compareTo(o2.getTag());
            };
            Collections.sort(propertiesA, comparator);
            Collections.sort(propertiesB, comparator);
            for (int i = 0; i < propertiesA.size(); ++i) {
                if (propertiesA.get(i).getDisplayValue().equals(propertiesB.get(i).getDisplayValue())) continue;
                return false;
            }
            return true;
        }
    }

    private class CompareTagPath
    implements Comparator {
        private CompareTagPath() {
        }

        public int compare(Object o1, Object o2) {
            String tag2;
            TagPath t1 = (TagPath)o1;
            TagPath t2 = (TagPath)o2;
            String tag1 = t1.getLast();
            int s = MergeEntityPanel.this.sortTag(t1, t2, tag1, tag2 = t2.getLast(), "CHAN");
            if (s < 5) {
                return s;
            }
            s = MergeEntityPanel.this.sortTag(t1, t2, tag1, tag2, "CREA");
            if (s < 5) {
                return s;
            }
            s = MergeEntityPanel.this.sortTag(t1, t2, tag1, tag2, "_");
            if (s < 5) {
                return s;
            }
            Integer i1 = MergeEntityPanel.this.tagMap.get(t1.get(0) + ":" + t1.get(1));
            Integer i2 = MergeEntityPanel.this.tagMap.get(t2.get(0) + ":" + t2.get(1));
            if (i1 == null) {
                if (i2 != null) {
                    return 1;
                }
                return t1.compareTo(t2);
            }
            if (i2 == null) {
                return -1;
            }
            return i1.compareTo(i2);
        }
    }

    public static class AlignedProperties {
        public List<Property> leftProperties = new ArrayList<Property>();
        public List<Property> rightProperties = new ArrayList<Property>();
        private Map<Property, Property> map;

        public AlignedProperties(Property left, Property right, TagPath tagPath) {
            if (left != null) {
                this.leftProperties.addAll(this.validateProperties(left.getProperties(tagPath)));
            }
            if (right != null) {
                this.rightProperties.addAll(this.validateProperties(right.getProperties(tagPath)));
            }
            if (this.leftProperties.size() * this.rightProperties.size() > 1) {
                GedcomUtilities.initSimilarityBag();
                this.map = GedcomUtilities.getPropertiesMapping(left.getProperties(tagPath), right.getProperties(tagPath));
                GedcomUtilities.clearSimilarityBag();
                this.alignProperties();
            }
        }

        public Property[] getLeft() {
            return (Property[])this.leftProperties.toArray(Property[]::new);
        }

        public Property[] getRight() {
            return (Property[])this.rightProperties.toArray(Property[]::new);
        }

        private void alignProperties() {
            ArrayList<Property> listLR = new ArrayList<Property>();
            listLR.addAll(this.leftProperties);
            listLR.addAll(this.rightProperties);
            listLR.sort(new MergeComparator());
            HashSet<Property> seen = new HashSet<Property>();
            ArrayList<Property> newLeftList = new ArrayList<Property>();
            ArrayList<Property> newRightList = new ArrayList<Property>();
            for (Property prop : listLR) {
                Property pair;
                if (seen.contains(prop)) continue;
                if (this.leftProperties.contains(prop)) {
                    newLeftList.add(prop);
                    pair = this.map.get(prop);
                    newRightList.add(pair);
                    if (pair == null) continue;
                    seen.add(pair);
                    continue;
                }
                newRightList.add(prop);
                pair = null;
                for (Property key : this.map.keySet()) {
                    if (!this.map.get(key).equals(prop)) continue;
                    pair = key;
                    break;
                }
                if (pair != null) {
                    newLeftList.add(pair);
                    seen.add(pair);
                    continue;
                }
                newLeftList.add(null);
            }
            this.leftProperties = newLeftList;
            this.rightProperties = newRightList;
        }

        private List<Property> validateProperties(Property[] props) {
            ArrayList<Property> ret = new ArrayList<Property>();
            for (Property prop : props) {
                PropertyXRef pxref;
                if (prop instanceof PropertyXRef && !(pxref = (PropertyXRef)prop).isValid()) continue;
                ret.add(prop);
            }
            return ret;
        }
    }

    private class CompareTagPath2
    implements Comparator {
        private CompareTagPath2() {
        }

        public int compare(Object o1, Object o2) {
            String tag2;
            TagPath t1 = (TagPath)o1;
            TagPath t2 = (TagPath)o2;
            String tag1 = t1.getLast();
            int s = MergeEntityPanel.this.sortTag(t1, t2, tag1, tag2 = t2.getLast(), "CHAN");
            if (s < 5) {
                return s;
            }
            s = MergeEntityPanel.this.sortTag(t1, t2, tag1, tag2, "CREA");
            if (s < 5) {
                return s;
            }
            s = MergeEntityPanel.this.sortTag(t1, t2, tag1, tag2, "_");
            if (s < 5) {
                return s;
            }
            Integer i1 = MergeEntityPanel.this.tagMap2.get(tag1);
            Integer i2 = MergeEntityPanel.this.tagMap2.get(tag2);
            if (i1 == null) {
                if (i2 != null) {
                    return 1;
                }
                return t1.compareTo(t2);
            }
            if (i2 == null) {
                return -1;
            }
            return i1.compareTo(i2);
        }
    }

    private static class DateNameInfo
    implements Comparable {
        public String name;
        public int year;
        public int month;
        public int day;

        public DateNameInfo(Indi indi) {
            this.name = GedcomUtilities.normalizeString(indi.getLastName() + "-" + indi.getFirstName());
            Property pDate = indi.getProperty(SORT_SIBLINGS);
            if (pDate == null) {
                pDate = indi.getProperty(SORT_SIBLINGS_CHR);
            }
            this.setdateInfo(pDate);
        }

        public DateNameInfo(Fam fam) {
            Indi husb = fam.getHusband();
            Indi wife = fam.getWife();
            String husbName = husb != null ? husb.getLastName() : "";
            String wifeName = wife != null ? wife.getLastName() : "";
            this.name = GedcomUtilities.normalizeString(husbName + "-" + wifeName);
            Property pDate = fam.getProperty(SORT_FAM);
            if (pDate == null) {
                pDate = fam.getProperty(SORT_FAM_MARC);
            }
            this.setdateInfo(pDate);
        }

        public DateNameInfo(Property event) {
            Property pType;
            String eventStr = event.getDisplayValue();
            if (eventStr.isBlank() && (pType = event.getProperty("TYPE")) != null) {
                eventStr = pType.getDisplayValue();
            }
            this.name = GedcomUtilities.normalizeString(eventStr);
            this.setdateInfo(event.getProperty("DATE"));
        }

        private void setdateInfo(Property pDate) {
            if (pDate == null || !(pDate instanceof PropertyDate)) {
                this.year = Integer.MAX_VALUE;
                this.month = 13;
                this.day = 32;
                return;
            }
            PropertyDate propDate = (PropertyDate)pDate;
            try {
                this.year = propDate.getStart().getYear();
            }
            catch (Exception e) {
                this.year = Integer.MAX_VALUE;
            }
            try {
                this.month = propDate.getStart().getMonth();
            }
            catch (Exception e) {
                this.month = 13;
            }
            try {
                this.day = propDate.getStart().getDay();
            }
            catch (Exception e) {
                this.day = 32;
            }
        }

        public int compareTo(Object o) {
            DateNameInfo other = (DateNameInfo)o;
            if (this.year != other.year) {
                return Integer.compare(this.year, other.year);
            }
            if (this.month != other.month) {
                return Integer.compare(this.month, other.month);
            }
            if (this.day != other.day) {
                return Integer.compare(this.day, other.day);
            }
            return this.name.compareTo(other.name);
        }
    }

    private static class MergeComparator
    implements Comparator {
        private MergeComparator() {
        }

        public int compare(Object o1, Object o2) {
            Property p1 = (Property)o1;
            Property p2 = (Property)o2;
            if (p1 instanceof PropertyChild) {
                PropertyChild p1Child = (PropertyChild)p1;
                if (p2 instanceof PropertyChild) {
                    PropertyChild p2Child = (PropertyChild)p2;
                    DateNameInfo info1 = new DateNameInfo(p1Child.getChild());
                    DateNameInfo info2 = new DateNameInfo(p2Child.getChild());
                    return info1.compareTo(info2);
                }
            }
            if (p1 instanceof PropertyFamilySpouse) {
                PropertyFamilySpouse p1Spouse = (PropertyFamilySpouse)p1;
                if (p2 instanceof PropertyFamilySpouse) {
                    PropertyFamilySpouse p2Spouse = (PropertyFamilySpouse)p2;
                    DateNameInfo info1 = new DateNameInfo(p1Spouse.getFamily());
                    DateNameInfo info2 = new DateNameInfo(p2Spouse.getFamily());
                    return info1.compareTo(info2);
                }
            }
            if (p1 instanceof PropertyFamilyChild) {
                PropertyFamilyChild p1Parent = (PropertyFamilyChild)p1;
                if (p2 instanceof PropertyFamilyChild) {
                    PropertyFamilyChild p2Parent = (PropertyFamilyChild)p2;
                    DateNameInfo info1 = new DateNameInfo(p1Parent.getFamily());
                    DateNameInfo info2 = new DateNameInfo(p2Parent.getFamily());
                    return info1.compareTo(info2);
                }
            }
            if (DATED_TAGS.contains(p1.getTag()) && p1.getTag().equals(p2.getTag())) {
                DateNameInfo info1 = new DateNameInfo(p1);
                DateNameInfo info2 = new DateNameInfo(p2);
                return info1.compareTo(info2);
            }
            return p1.compareTo(p2);
        }
    }
}

