/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree;

import ancestris.report.svgtree.GraphicsTreeElements;
import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.filter.TreeFilterBase;
import ancestris.report.svgtree.graphics.GraphicsRenderer;
import ancestris.report.svgtree.graphics.GraphicsUtil;
import genj.gedcom.PropertyChange;
import genj.report.Translator;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;

public class FooterRenderer
implements GraphicsRenderer {
    public static final int MARGIN = 15;
    public int footer_mode = 1;
    public String[] footer_modes = new String[]{"none", "local", "global", "current"};
    private static final int FONT_SIZE = 10;
    public int fontNameFooter = 0;
    public String[] fontNameFooters = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private String displayDate;
    private final GraphicsRenderer renderer;
    private final Translator translator;

    public FooterRenderer(GraphicsRenderer renderer, Translator translator) {
        this.renderer = renderer;
        this.translator = translator;
        for (int i = 0; i < this.footer_modes.length; ++i) {
            this.footer_modes[i] = translator.translate("footer_mode." + this.footer_modes[i]);
        }
    }

    public void setFirstIndi(IndiBox firstIndi) {
        this.displayDate = null;
        switch (this.footer_mode) {
            case 1: {
                FindDateOfModification filter = new FindDateOfModification();
                filter.filter(firstIndi);
                this.displayDate = filter.mostRecent;
                if (this.displayDate != null) break;
            }
            case 2: {
                PropertyChange lastChange = firstIndi.individual.getGedcom().getLastChange();
                if (lastChange == null) break;
                this.displayDate = lastChange.getDisplayValue();
                break;
            }
            case 3: {
                PropertyChange currentTime = new PropertyChange();
                this.displayDate = currentTime.getDisplayValue();
            }
        }
        if (this.displayDate == null) {
            this.displayDate = this.translator.translate("date_not_available");
        }
    }

    @Override
    public int getImageHeight() {
        if (this.footer_mode == 0) {
            return this.renderer.getImageHeight() + 30;
        }
        return this.renderer.getImageHeight() + 10 + 30;
    }

    @Override
    public int getImageWidth() {
        return this.renderer.getImageWidth();
    }

    @Override
    public void render(Graphics2D graphics) {
        if (this.footer_mode != 0) {
            graphics.setBackground(Color.WHITE);
            graphics.clearRect(0, 0, this.getImageWidth(), this.getImageHeight());
            graphics.setColor(Color.BLACK);
            this.checkFont();
            graphics.setFont(new Font(this.fontNameFooters[this.fontNameFooter], 0, 10));
            String caption = this.footer_modes[this.footer_mode] + ": " + this.displayDate;
            GraphicsTreeElements.alignRightString(graphics, caption, this.getImageWidth() - 15, this.getImageHeight() - 2);
        }
        this.renderer.render(graphics);
    }

    private void checkFont() {
        if (!GraphicsUtil.checkFont(this.fontNameFooters[this.fontNameFooter])) {
            this.fontNameFooters[this.fontNameFooter] = "verdana";
        }
    }

    private static class FindDateOfModification
    extends TreeFilterBase {
        long mostRecentTime = 0L;
        String mostRecent = null;

        private FindDateOfModification() {
        }

        @Override
        protected void preFilter(IndiBox indibox) {
            this.checkDate(indibox.individual.getLastChange());
            if (indibox.family != null) {
                this.checkDate(indibox.family.family.getLastChange());
            }
        }

        private void checkDate(PropertyChange lastChange) {
            if (lastChange == null) {
                return;
            }
            long time = lastChange.getTime();
            if (time > this.mostRecentTime) {
                this.mostRecentTime = time;
                this.mostRecent = lastChange.getDisplayValue();
            }
        }
    }
}

