/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare.tools;

import ancestris.modules.gedcomcompare.GedcomCompareTopComponent;
import ancestris.modules.gedcomcompare.communication.Comm;
import ancestris.modules.gedcomcompare.communication.UserProfile;
import ancestris.modules.gedcomcompare.options.GedcomCompareOptionsPanel;
import ancestris.modules.gedcomcompare.tools.ComparedGedcom;
import ancestris.modules.gedcomcompare.tools.DataFrame;
import ancestris.modules.gedcomcompare.tools.ProfilePanel;
import ancestris.modules.gedcomcompare.tools.STFactory;
import ancestris.modules.gedcomcompare.tools.STMap;
import ancestris.modules.gedcomcompare.tools.STMapEventsCapsule;
import ancestris.util.swing.DialogManager;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ConnectedUserFrame
extends DataFrame
implements ComparedGedcom {
    private static String HIDDEN_VALUE = "yes";
    private String uniqueID;
    private UserProfile userProfile = null;
    private int nbIndis;
    private int nbFamilies;
    private int nbSTs;
    private int nbEvens;
    private String[] sTs;
    private STMap stMap;
    private int stats_nbOverlaps;
    private int stats_nbCityNames;
    private int stats_nbEvents;
    private boolean isMe = false;
    private boolean include;
    private int connections;
    private Date startDate;
    private Date endDate;
    private AbstractAction profileAction;
    private JLabel iconEvenLabel;
    private JLabel iconFamLabel;
    private JLabel iconIndiLabel;
    private JLabel iconSTLabel;
    private JCheckBox overviewCheckBox;
    private JCheckBox readyCheckBox;
    private JLabel visibleEvenLabel;
    private JLabel visibleFamLabel;
    private JLabel visibleIndiLabel;
    private JLabel visibleSTLabel;

    public ConnectedUserFrame(GedcomCompareTopComponent gctc, Comm.User user) {
        super(user.userProfile.pseudo);
        JButton menuButton;
        MouseListener[] mls;
        this.setName(user.userProfile.pseudo);
        this.initComponents();
        this.owner = gctc;
        this.type = DataFrame.GEDCOM_TYPE_REMOTE;
        this.uniqueID = UUID.randomUUID().toString();
        this.stMap = null;
        this.userProfile = new UserProfile();
        this.updateInfo(user);
        if (this.owner.getPreferredPseudo().equals(this.userProfile.pseudo)) {
            this.isMe = true;
        }
        this.overviewCheckBox.setEnabled(this.owner.isSharingOn());
        this.readyCheckBox.setEnabled(false);
        super.updateColor();
        this.include = !this.isPseudoHidden(this.userProfile.pseudo);
        this.connections = 0;
        this.startDate = new Date();
        this.endDate = new Date();
        JPopupMenu popup = new JPopupMenu();
        this.profileAction = new AbstractAction(NbBundle.getMessage(this.getClass(), (String)"ACT_ShowProfile"), this.getPhotoIcon(true)){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"TITL_ProfilePanel", (Object)((ConnectedUserFrame)ConnectedUserFrame.this).userProfile.pseudo), (JComponent)new ProfilePanel(ConnectedUserFrame.this.userProfile, ConnectedUserFrame.this.owner.getMyProfile(), ConnectedUserFrame.this.connections, ConnectedUserFrame.this.startDate, ConnectedUserFrame.this.endDate)).setMessageType(-1).setResizable(false).setOptionType(10).show();
            }
        };
        popup.add(new JMenuItem(this.profileAction));
        AbstractAction b = new AbstractAction(NbBundle.getMessage(this.getClass(), (String)"ACT_ContactUser"), new ImageIcon(ImageUtilities.loadImage((String)"ancestris/modules/gedcomcompare/resources/email.png"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilePanel panel = new ProfilePanel(ConnectedUserFrame.this.userProfile, ConnectedUserFrame.this.owner.getMyProfile(), ConnectedUserFrame.this.connections, ConnectedUserFrame.this.startDate, ConnectedUserFrame.this.endDate);
                panel.sendMail(((ConnectedUserFrame)ConnectedUserFrame.this).userProfile.email);
            }
        };
        popup.add(new JMenuItem(b));
        AbstractAction c = new AbstractAction(NbBundle.getMessage(this.getClass(), (String)"ACT_ResetFlags"), new ImageIcon(ImageUtilities.loadImage((String)"ancestris/modules/gedcomcompare/resources/reset.png"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectedUserFrame.this.reset();
            }
        };
        popup.add(new JMenuItem(c));
        AbstractAction d = new AbstractAction(NbBundle.getMessage(this.getClass(), (String)"ACT_HideUser"), new ImageIcon(ImageUtilities.loadImage((String)"ancestris/modules/gedcomcompare/resources/deleteuser.png"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectedUserFrame.this.showUser(false);
            }
        };
        popup.add(new JMenuItem(d));
        this.setComponentPopupMenu(popup);
        JComponent pane = ((BasicInternalFrameUI)this.getUI()).getNorthPane();
        if (pane.getComponent(0) instanceof JButton && (mls = (menuButton = (JButton)pane.getComponent(0)).getMouseListeners()).length > 1 && mls[1] instanceof MouseAdapter) {
            menuButton.removeMouseListener(mls[1]);
        }
    }

    @Override
    public String getID() {
        return this.uniqueID;
    }

    public void updateInfo(Comm.User user) {
        this.setActive(true);
        this.updateProfileConnection(user.userProfile);
        this.nbIndis = Integer.valueOf(user.f_NbIndis);
        this.nbFamilies = Integer.valueOf(user.f_NbFamilies);
        this.nbSTs = Integer.valueOf(user.f_NbSTs);
        this.nbEvens = Integer.valueOf(user.f_NbEvens);
        this.sTs = new String[Comm.TAG_STS.length];
        for (int i = 0; i < Comm.TAG_STS.length; ++i) {
            this.sTs[i] = user.f_STs[i];
        }
        this.stats_nbOverlaps = Integer.valueOf(user.stats_nbOveraps);
        this.stats_nbCityNames = Integer.valueOf(user.stats_nbCityNames);
        this.stats_nbEvents = Integer.valueOf(user.stats_nbEvents);
        this.visibleIndiLabel.setText("" + this.nbIndis);
        this.visibleFamLabel.setText("" + this.nbFamilies);
        this.visibleSTLabel.setText("" + this.nbSTs);
        this.visibleEvenLabel.setText("" + this.nbEvens);
    }

    private void updatePhoto(boolean set) {
        ImageIcon icon = this.getPhotoIcon(set);
        this.setFrameIcon(icon);
        this.profileAction.putValue("SmallIcon", icon);
    }

    private ImageIcon getPhotoIcon(boolean set) {
        if (this.userProfile.photoBytes == null || !set) {
            return new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/friend16.png"));
        }
        return GedcomCompareOptionsPanel.getPhoto(1, this.userProfile.photoBytes);
    }

    @Override
    public String getUserName() {
        return super.getTitle();
    }

    @Override
    public STMap getMap() {
        return this.stMap;
    }

    public final void setOpen(boolean set) {
        this.overviewCheckBox.setEnabled(set && this.isActive());
        this.readyCheckBox.setEnabled(this.overviewCheckBox.isSelected() && set && this.isActive());
    }

    public void setActive(boolean set) {
        this.type = set ? DataFrame.GEDCOM_TYPE_REMOTE : DataFrame.GEDCOM_TYPE_REMOTE_INACTIVE;
        this.updateColor();
        this.setOpen(this.owner.isSharingOn());
    }

    public boolean isActive() {
        return this.type == DataFrame.GEDCOM_TYPE_REMOTE;
    }

    public boolean isViewed() {
        return this.overviewCheckBox.isSelected();
    }

    public void setMap(STMap map) {
        this.stMap = map;
        if (this.owner.getComparisonFrame(this) != null) {
            this.owner.getComparisonFrame(this).reset();
        }
        this.overviewCheckBox.setSelected(map != null);
        if (map != null) {
            this.overviewCheckBox.setIcon(this.owner.SELECTEDON_ICON);
            this.owner.getComparisonFrame(this).launchCompare(true);
            this.overviewCheckBox.setEnabled(true);
            this.readyCheckBox.setEnabled(true);
        } else {
            this.updatePhoto(false);
            this.overviewCheckBox.setIcon(null);
            this.readyCheckBox.setIcon(null);
            this.readyCheckBox.setSelected(false);
            this.readyCheckBox.setEnabled(false);
            this.overviewCheckBox.setSelected(false);
        }
    }

    public void updateMap(STMapEventsCapsule capsule) {
        STFactory.updateMap(this.stMap, capsule);
        if (this.stMap != null) {
            this.stMap.setComplete(true);
        }
        this.readyCheckBox.setIcon(this.owner.SELECTEDON_ICON);
        if (this.owner.getComparisonFrame(this) != null) {
            this.owner.getComparisonFrame(this).launchCompare(true);
        }
    }

    public void updateProfileConnection(UserProfile profile) {
        this.userProfile.pseudo = profile.pseudo;
        this.userProfile.ipAddress = profile.ipAddress;
        this.userProfile.pipAddress = profile.pipAddress;
        this.userProfile.portAddress = profile.portAddress;
        this.userProfile.pportAddress = profile.pportAddress;
        this.userProfile.usePrivateIP = profile.usePrivateIP;
        this.userProfile.privacy = profile.privacy;
    }

    public void updateProfileInfo(UserProfile profile) {
        this.userProfile.name = profile.name;
        this.userProfile.email = profile.email;
        this.userProfile.city = profile.city;
        this.userProfile.country = profile.country;
        this.userProfile.photoBytes = profile.photoBytes;
        this.updatePhoto(true);
    }

    public void resetIcon(int step) {
        if (step == 1) {
            this.overviewCheckBox.setIcon(null);
            this.overviewCheckBox.setSelected(false);
        }
        if (step == 2) {
            this.readyCheckBox.setIcon(null);
            this.readyCheckBox.setSelected(false);
        }
        this.setOpen(this.owner.isSharingOn());
    }

    public void reset() {
        this.setMap(null);
        this.owner.updateStatsDisplay();
    }

    public void showUser(boolean show) {
        this.setInclude(show);
        this.owner.showUserFrame(this, show);
    }

    public void addConnection() {
        ++this.connections;
        this.endDate = new Date();
        this.owner.updateStatsDisplay();
    }

    public int getConnections() {
        return this.connections;
    }

    public boolean hasConnections() {
        return this.connections > 0;
    }

    public boolean hasOverlap() {
        if (this.owner != null && this.owner.getComparisonFrame(this) != null && this.owner.getComparisonFrame(this).getIntersectionKeys() != null) {
            return this.owner.getComparisonFrame(this).getIntersectionKeys().size() > 0;
        }
        return false;
    }

    public int[] getStats() {
        return new int[]{this.stats_nbOverlaps, this.stats_nbCityNames, this.stats_nbEvents};
    }

    private void initComponents() {
        this.iconIndiLabel = new JLabel();
        this.visibleIndiLabel = new JLabel();
        this.iconFamLabel = new JLabel();
        this.visibleFamLabel = new JLabel();
        this.iconEvenLabel = new JLabel();
        this.visibleEvenLabel = new JLabel();
        this.iconSTLabel = new JLabel();
        this.visibleSTLabel = new JLabel();
        this.overviewCheckBox = new JCheckBox();
        this.readyCheckBox = new JCheckBox();
        this.setBorder(new SoftBevelBorder(0));
        this.setToolTipText(NbBundle.getMessage(ConnectedUserFrame.class, (String)"ConnectedUserFrame.Form.toolTipText"));
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/friend16.png")));
        this.setRequestFocusEnabled(false);
        this.setVisible(true);
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
                ConnectedUserFrame.this.formInternalFrameActivated(evt);
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.iconIndiLabel.setFont(new Font("DejaVu Sans", 0, 11));
        this.iconIndiLabel.setHorizontalAlignment(0);
        this.iconIndiLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/indi.png")));
        Mnemonics.setLocalizedText((JLabel)this.iconIndiLabel, (String)NbBundle.getMessage(ConnectedUserFrame.class, (String)"ConnectedUserFrame.iconIndiLabel.text"));
        this.iconIndiLabel.setToolTipText(NbBundle.getMessage(ConnectedUserFrame.class, (String)"ConnectedUserFrame.iconIndiLabel.toolTipText"));
        this.iconIndiLabel.setPreferredSize(new Dimension(50, 14));
        this.visibleIndiLabel.setFont(this.visibleIndiLabel.getFont().deriveFont((float)this.visibleIndiLabel.getFont().getSize() - 1.0f));
        this.visibleIndiLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.visibleIndiLabel, (String)NbBundle.getMessage(ConnectedUserFrame.class, (String)"ConnectedUserFrame.visibleIndiLabel.text"));
        this.visibleIndiLabel.setHorizontalTextPosition(4);
        this.iconFamLabel.setFont(new Font("DejaVu Sans", 0, 11));
        this.iconFamLabel.setHorizontalAlignment(0);
        this.iconFamLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/fam.png")));
        Mnemonics.setLocalizedText((JLabel)this.iconFamLabel, (String)NbBundle.getMessage(ConnectedUserFrame.class, (String)"ConnectedUserFrame.iconFamLabel.text"));
        this.iconFamLabel.setToolTipText(NbBundle.getMessage(ConnectedUserFrame.class, (String)"ConnectedUserFrame.iconFamLabel.toolTipText"));
        this.iconFamLabel.setPreferredSize(new Dimension(50, 14));
        this.visibleFamLabel.setFont(this.visibleFamLabel.getFont().deriveFont((float)this.visibleFamLabel.getFont().getSize() - 1.0f));
        this.visibleFamLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.visibleFamLabel, (String)NbBundle.getMessage(ConnectedUserFrame.class, (String)"ConnectedUserFrame.visibleFamLabel.text"));
        this.visibleFamLabel.setHorizontalTextPosition(4);
        this.iconEvenLabel.setFont(new Font("DejaVu Sans", 0, 11));
        this.iconEvenLabel.setHorizontalAlignment(2);
        this.iconEvenLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/even.png")));
        Mnemonics.setLocalizedText((JLabel)this.iconEvenLabel, (String)NbBundle.getMessage(ConnectedUserFrame.class, (String)"ConnectedUserFrame.iconEvenLabel.text"));
        this.iconEvenLabel.setToolTipText(NbBundle.getMessage(ConnectedUserFrame.class, (String)"ConnectedUserFrame.iconEvenLabel.toolTipText"));
        this.iconEvenLabel.setPreferredSize(new Dimension(50, 14));
        this.visibleEvenLabel.setFont(this.visibleEvenLabel.getFont().deriveFont((float)this.visibleEvenLabel.getFont().getSize() - 1.0f));
        this.visibleEvenLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.visibleEvenLabel, (String)NbBundle.getMessage(ConnectedUserFrame.class, (String)"ConnectedUserFrame.visibleEvenLabel.text"));
        this.visibleEvenLabel.setHorizontalTextPosition(4);
        this.iconSTLabel.setFont(new Font("DejaVu Sans", 0, 11));
        this.iconSTLabel.setHorizontalAlignment(4);
        this.iconSTLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/geost.png")));
        Mnemonics.setLocalizedText((JLabel)this.iconSTLabel, (String)NbBundle.getMessage(ConnectedUserFrame.class, (String)"ConnectedUserFrame.iconSTLabel.text"));
        this.iconSTLabel.setToolTipText(NbBundle.getMessage(ConnectedUserFrame.class, (String)"ConnectedUserFrame.iconSTLabel.toolTipText"));
        this.iconSTLabel.setPreferredSize(new Dimension(50, 14));
        this.visibleSTLabel.setFont(this.visibleSTLabel.getFont().deriveFont((float)this.visibleSTLabel.getFont().getSize() - 1.0f));
        this.visibleSTLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.visibleSTLabel, (String)NbBundle.getMessage(ConnectedUserFrame.class, (String)"ConnectedUserFrame.visibleSTLabel.text"));
        this.visibleSTLabel.setHorizontalTextPosition(4);
        this.overviewCheckBox.setFont(this.overviewCheckBox.getFont().deriveFont((float)this.overviewCheckBox.getFont().getSize() - 1.0f));
        Mnemonics.setLocalizedText((AbstractButton)this.overviewCheckBox, (String)NbBundle.getMessage(ConnectedUserFrame.class, (String)"ConnectedUserFrame.overviewCheckBox.text"));
        this.overviewCheckBox.setToolTipText(NbBundle.getMessage(ConnectedUserFrame.class, (String)"ConnectedUserFrame.overviewCheckBox.toolTipText"));
        this.overviewCheckBox.setContentAreaFilled(false);
        this.overviewCheckBox.setHorizontalAlignment(4);
        this.overviewCheckBox.setHorizontalTextPosition(10);
        this.overviewCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectedUserFrame.this.overviewCheckBoxActionPerformed(evt);
            }
        });
        this.readyCheckBox.setFont(this.readyCheckBox.getFont().deriveFont((float)this.readyCheckBox.getFont().getSize() - 1.0f));
        Mnemonics.setLocalizedText((AbstractButton)this.readyCheckBox, (String)NbBundle.getMessage(ConnectedUserFrame.class, (String)"ConnectedUserFrame.readyCheckBox.text"));
        this.readyCheckBox.setToolTipText(NbBundle.getMessage(ConnectedUserFrame.class, (String)"ConnectedUserFrame.readyCheckBox.toolTipText"));
        this.readyCheckBox.setContentAreaFilled(false);
        this.readyCheckBox.setHorizontalAlignment(4);
        this.readyCheckBox.setHorizontalTextPosition(10);
        this.readyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectedUserFrame.this.readyCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconFamLabel, -2, 14, -2).addComponent(this.iconIndiLabel, -2, 14, -2)).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.visibleIndiLabel).addComponent(this.visibleFamLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconEvenLabel, -2, 14, -2).addComponent(this.iconSTLabel, -2, 14, -2)).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.visibleEvenLabel, GroupLayout.Alignment.TRAILING).addComponent(this.visibleSTLabel, GroupLayout.Alignment.TRAILING)).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.overviewCheckBox, GroupLayout.Alignment.TRAILING).addComponent(this.readyCheckBox, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.visibleSTLabel).addComponent(this.overviewCheckBox).addComponent(this.iconIndiLabel, -2, -1, -2).addComponent(this.iconSTLabel, -2, -1, -2).addComponent(this.visibleIndiLabel)).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.readyCheckBox).addComponent(this.iconFamLabel, -2, -1, -2).addComponent(this.visibleFamLabel).addComponent(this.iconEvenLabel, -2, -1, -2).addComponent(this.visibleEvenLabel)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void overviewCheckBoxActionPerformed(ActionEvent evt) {
        if (this.overviewCheckBox.isSelected()) {
            this.overviewCheckBox.setIcon(this.owner.ROTATING_ICON);
            this.owner.launchMapsSearch(this.getUserName());
        } else {
            this.overviewCheckBox.setSelected(true);
        }
    }

    private void readyCheckBoxActionPerformed(ActionEvent evt) {
        if (this.readyCheckBox.isSelected()) {
            this.readyCheckBox.setIcon(this.owner.ROTATING_ICON);
            this.owner.launchEventsSearch(this.getUserName());
        } else {
            this.readyCheckBox.setSelected(true);
        }
    }

    private void formInternalFrameActivated(InternalFrameEvent evt) {
        this.focusOther();
    }

    public boolean isMe() {
        return this.isMe;
    }

    public void setInclude(boolean b) {
        this.include = b;
        this.hidePseudo(!b, this.userProfile.pseudo);
    }

    public boolean isIncluded() {
        return this.include;
    }

    public boolean isComplete() {
        return this.stMap != null ? this.stMap.isComplete() : false;
    }

    public String getIPAddress() {
        return this.userProfile.usePrivateIP ? this.userProfile.pipAddress : this.userProfile.ipAddress;
    }

    public String getPortAddress() {
        return this.userProfile.usePrivateIP ? this.userProfile.pportAddress : this.userProfile.portAddress;
    }

    public boolean getUsePrivateIP() {
        return this.userProfile.usePrivateIP;
    }

    public void setUsePrivateIP(boolean flag) {
        this.userProfile.usePrivateIP = flag;
    }

    public String getxIPAddress() {
        return this.userProfile.ipAddress;
    }

    public String getxPortAddress() {
        return this.userProfile.portAddress;
    }

    public String getpIPAddress() {
        return this.userProfile.pipAddress;
    }

    public String getpPortAddress() {
        return this.userProfile.pportAddress;
    }

    public int getNbIndis() {
        return this.nbIndis;
    }

    public int getNbFams() {
        return this.nbFamilies;
    }

    public int getNbSTs() {
        return this.nbSTs;
    }

    public String getTopST() {
        return this.sTs[0];
    }

    public String[] getSTs() {
        return this.sTs;
    }

    public void setUserProfile(UserProfile userProfile) {
        this.userProfile = userProfile;
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    public void setIPAddress(String address) {
        String[] bits = address.split(":");
        if (bits.length != 2) {
            return;
        }
        if (!this.userProfile.usePrivateIP) {
            this.userProfile.ipAddress = bits[0];
            this.userProfile.portAddress = bits[1];
        } else {
            this.userProfile.pipAddress = bits[0];
            this.userProfile.pportAddress = bits[1];
        }
    }

    private boolean isPseudoHidden(String pseudo) {
        String pseudoKey = "HiddenUsers." + pseudo;
        String hiddenUser = NbPreferences.forModule(GedcomCompareOptionsPanel.class).get(pseudoKey, "");
        return hiddenUser.equals(HIDDEN_VALUE);
    }

    private void hidePseudo(boolean hide, String pseudo) {
        String pseudoKey = "HiddenUsers." + pseudo;
        if (hide) {
            NbPreferences.forModule(GedcomCompareOptionsPanel.class).put(pseudoKey, HIDDEN_VALUE);
        } else {
            NbPreferences.forModule(GedcomCompareOptionsPanel.class).remove(pseudoKey);
        }
    }
}

