/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.api.imports.ImportFix;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.FixesWindow;
import genj.gedcom.Context;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openide.util.NbBundle;

public class ImportMacFamilyTree
extends Import {
    private static HashMap<String, ImportPlace> hashPlaces;
    private static String PLACE_RECORD_TAG;
    protected static Pattern tag_plac_pattern;

    public ImportMacFamilyTree() {
        hashPlaces = new HashMap();
    }

    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importmacfamilytree_name();
    }

    protected String getImportComment() {
        return Bundle.importmacfamilytree_note();
    }

    public void showDetails(Context context, boolean extract) {
        new FixesWindow(this.summary, context, this.fixes).displayFixes(extract);
    }

    protected void init() {
        super.init();
        hashPlaces.clear();
        this.invalidPaths.add("_CRE:DATE");
        this.invalidPaths.add("_CRE:DATE:TIME");
        this.invalidPaths.add("INDI:ASSO:DATE");
    }

    protected void firstPass() {
        super.firstPass();
        if (this.input.getLevel() == 0 && this.input.getTag().equals(PLACE_RECORD_TAG)) {
            String key = "";
            ImportPlace importPlace = null;
            String tag = "";
            try {
                key = this.input.getValue();
                if (!hashPlaces.containsKey(key)) {
                    importPlace = new ImportPlace();
                    hashPlaces.put(key, importPlace);
                }
                importPlace = hashPlaces.get(key);
                importPlace.used = false;
                this.input.getNextLine(false);
                while (this.input.getLevel() != 0) {
                    this.input.getNextLine(true);
                    tag = this.input.getTag();
                    if (!tag.startsWith("_") && !tag_plac_pattern.matcher(tag).matches()) {
                        tag = "_" + tag;
                    }
                    importPlace.addLine(this.input.getLevel() - 1, tag, this.input.getValue());
                    this.input.getNextLine(false);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(Import.class, (String)"error.unknown") + e);
                return;
            }
            return;
        }
    }

    protected boolean process() throws IOException {
        if (this.beforeProcess()) {
            return true;
        }
        if (super.process()) {
            return true;
        }
        return this.afterProcess();
    }

    protected void finalise() throws IOException {
        super.finalise();
        int p = 0;
        String tag = "";
        for (String key : hashPlaces.keySet()) {
            ImportPlace importPlace = hashPlaces.get(key);
            if (importPlace.used) continue;
            String valueBefore = importPlace.values.get(0);
            String xref = "P" + ++p;
            this.output.writeLine(0, "P" + p, "NOTE", valueBefore);
            for (int i = 0; i < importPlace.levels.size(); ++i) {
                tag = importPlace.tags.get(i);
                if (!tag.startsWith("_")) {
                    tag = "_" + tag;
                }
                this.output.writeLine(1 + importPlace.levels.get(i), tag, importPlace.values.get(i));
            }
            this.fixes.add(new ImportFix(xref, "invalidEntity.07", PLACE_RECORD_TAG, "NOTE:..", valueBefore, valueBefore));
        }
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        this.incrementProgress();
        return ret |= this.processEntities(gedcom);
    }

    private boolean beforeProcess() throws IOException {
        String tag = this.input.getTag();
        TagPath path = this.input.getPath();
        if (this.input.getLevel() > 1 && "CHAN".equals(this.input.getTag())) {
            String valueBefore = this.input.getValue();
            this.output.writeLine(this.input.getLevel(), "_CHAN", valueBefore);
            String pathBefore = this.input.getPath().getShortName();
            this.fixes.add(new ImportFix(this.currentXref, "invalidTagLocation.1", pathBefore, path.getParent().getShortName() + ":_CHAN", valueBefore, valueBefore));
            return true;
        }
        if (this.input.getLevel() > 2 && path.toString().endsWith("CHAN:DATE")) {
            String valueBefore = this.input.getValue();
            this.output.writeLine(this.input.getLevel(), "_DATE", valueBefore);
            String pathBefore = this.input.getPath().getShortName();
            this.fixes.add(new ImportFix(this.currentXref, "invalidTagLocation.1", pathBefore, path.getParent().getShortName() + ":_DATE", valueBefore, valueBefore));
            return true;
        }
        if (this.input.getLevel() > 3 && path.toString().endsWith("CHAN:DATE:TIME")) {
            String valueBefore = this.input.getValue();
            this.output.writeLine(this.input.getLevel(), "_TIME", valueBefore);
            String pathBefore = this.input.getPath().getShortName();
            this.fixes.add(new ImportFix(this.currentXref, "invalidTagLocation.1", pathBefore, path.getParent().getShortName() + ":_TIME", valueBefore, valueBefore));
            return true;
        }
        if ("LABL".equals(this.input.getTag())) {
            String valueBefore = this.input.getValue();
            String newTag = "NOTE";
            if (this.input.getLevel() == 0) {
                this.output.writeLine(this.input.getLevel(), this.currentXref, newTag, valueBefore);
            } else {
                this.output.writeLine(this.input.getLevel(), newTag, valueBefore);
                newTag = ":" + newTag;
            }
            String pathBefore = this.input.getPath().getShortName();
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.2", pathBefore, path.getParent().getShortName() + newTag, valueBefore, valueBefore));
            return true;
        }
        if (this.input.getLevel() == 1 && path.toString().endsWith("LABL:TITL")) {
            String valueBefore = this.input.getValue();
            this.output.writeLine(this.input.getLevel(), "CONT", valueBefore);
            String pathBefore = this.input.getPath().getShortName();
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.2", pathBefore, path.getParent().getShortName() + ":CONT", valueBefore, valueBefore));
            return true;
        }
        if (this.input.getLevel() == 1 && path.toString().endsWith("LABL:COLR")) {
            String valueBefore = this.input.getValue();
            this.output.writeLine(this.input.getLevel(), "_COLR", valueBefore);
            String pathBefore = this.input.getPath().getShortName();
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.2", pathBefore, path.getParent().getShortName() + ":_COLR", valueBefore, valueBefore));
            return true;
        }
        return false;
    }

    private boolean afterProcess() throws IOException {
        if ("PLAC".equals(this.input.getTag()) && this.input.getLevel() > 1) {
            ImportPlace importPlace = hashPlaces.get(this.input.getValue());
            if (importPlace != null) {
                importPlace.used = true;
            }
            return false;
        }
        if (this.input.getLevel() == 0 && this.input.getTag().equals(PLACE_RECORD_TAG)) {
            this.input.getNextLine(false);
            while (this.input.getLevel() != 0) {
                this.input.getNextLine(true);
                this.input.getNextLine(false);
            }
            return true;
        }
        return false;
    }

    public boolean processEntities(Gedcom gedcom) {
        boolean hasErrors = false;
        String pathBefore = "";
        String pathAfter = "";
        String valueBefore = "";
        Object props = null;
        Property prop = null;
        Property prop2 = null;
        PropertyXRef host = null;
        for (Fam fam : gedcom.getFamilies()) {
            Property[] children;
            for (Property child : children = fam.getProperties("CHIL")) {
                prop = child.getProperty("PEDI");
                if (prop == null) continue;
                pathBefore = prop.getPath(true).getShortName();
                valueBefore = prop.getValue();
                host = ((PropertyChild)child).getTarget();
                prop2 = host.addProperty("PEDI", valueBefore);
                pathAfter = prop2.getPath(true).getShortName();
                prop.getParent().delProperty(prop);
                this.fixes.add(new ImportFix(prop2.getEntity().getId(), "invalidTagLocation.3", pathBefore, pathAfter, valueBefore, valueBefore));
                hasErrors = true;
            }
        }
        List placeList = gedcom.getPropertiesByClass(PropertyPlace.class);
        for (Property place : placeList) {
            Property pmap = place.getParent().getProperty("MAP");
            Property plong = place.getParent().getProperty("LONG");
            Property plati = place.getParent().getProperty("LATI");
            if ((plong != null || plati != null) && pmap == null) {
                pmap = place.addProperty("MAP", "");
            }
            if (plong != null) {
                pathBefore = plong.getPath(true).getShortName();
                valueBefore = plong.getValue();
                prop2 = pmap.addProperty("LONG", valueBefore);
                pathAfter = prop2.getPath(true).getShortName();
                plong.getParent().delProperty(plong);
                this.fixes.add(new ImportFix(place.getEntity().getId(), "invalidTagLocation.3", pathBefore, pathAfter, valueBefore, valueBefore));
                hasErrors = true;
            }
            if (plati == null) continue;
            pathBefore = plati.getPath(true).getShortName();
            valueBefore = plati.getValue();
            prop2 = pmap.addProperty("LATI", valueBefore);
            pathAfter = prop2.getPath(true).getShortName();
            plati.getParent().delProperty(plati);
            this.fixes.add(new ImportFix(place.getEntity().getId(), "invalidTagLocation.3", pathBefore, pathAfter, valueBefore, valueBefore));
            hasErrors = true;
        }
        for (Source sour : gedcom.getSources()) {
            Property p;
            Property even;
            Property plac = sour.getProperty("PLAC");
            Property date = sour.getProperty("DATE");
            Property agnc = sour.getProperty("AGNC");
            if (plac == null && date == null && agnc == null) continue;
            Property data = sour.getProperty("DATA");
            if (data == null) {
                data = sour.addProperty("DATA", "");
            }
            if (agnc != null) {
                pathBefore = agnc.getPath(true).getShortName();
                valueBefore = agnc.getValue();
                Property p2 = data.addProperty("AGNC", valueBefore);
                pathAfter = p2.getPath(true).getShortName();
                sour.delProperty(agnc);
                this.fixes.add(new ImportFix(sour.getEntity().getId(), "invalidTagLocation.3", pathBefore, pathAfter, valueBefore, valueBefore));
                hasErrors = true;
            }
            if ((even = data.getProperty("EVEN")) == null) {
                even = data.addProperty("EVEN", "");
            }
            if (date != null) {
                pathBefore = date.getPath(true).getShortName();
                valueBefore = date.getValue();
                p = even.addProperty("DATE", valueBefore);
                pathAfter = p.getPath(true).getShortName();
                sour.delProperty(date);
                this.fixes.add(new ImportFix(sour.getEntity().getId(), "invalidTagLocation.3", pathBefore, pathAfter, valueBefore, valueBefore));
                hasErrors = true;
            }
            if (plac == null) continue;
            pathBefore = plac.getPath(true).getShortName();
            valueBefore = plac.getValue();
            p = even.addProperty("PLAC", valueBefore);
            pathAfter = p.getPath(true).getShortName();
            sour.delProperty(plac);
            this.fixes.add(new ImportFix(sour.getEntity().getId(), "invalidTagLocation.3", pathBefore, pathAfter, valueBefore, valueBefore));
            hasErrors = true;
        }
        return hasErrors;
    }

    static {
        PLACE_RECORD_TAG = "_PLAC";
        tag_plac_pattern = Pattern.compile("(PLAC|FORM|FONE|TYPE|ROMN|MAP|LATI|LONG|NOTE|CONC|CONT)");
    }

    private class ImportPlace {
        protected boolean used = false;
        protected List<Integer> levels = new LinkedList<Integer>();
        protected List<String> tags = new LinkedList<String>();
        protected List<String> values = new LinkedList<String>();

        private ImportPlace() {
        }

        private void addLine(int level, String tag, String value) {
            this.levels.add(level);
            this.tags.add(tag);
            this.values.add(value);
        }
    }
}

