#!/bin/bash
# Thx to "Hardloaf" for improvements in this...

echo Setting up...
if [ ! -e "../mp3gain" ]; then
  echo mp3gain not found!
  exit 1
fi

if [ ! -e "../aacgain" ]; then
  echo aacgain not found!
  exit 1
fi

MPEG4IPDIR=`ls -1tF ..|grep -E 'mpeg4ip.*/'|head -n 1`
if [ ! "$MPEG4IPDIR" ]; then
  echo mpeg4ip not found!
  exit 1
fi


FAAD2DIR=`ls -1tF ..|grep -E 'faad2.*/'|head -n 1`
if [ ! "$FAAD2DIR" ]; then
  echo faad2 not found!
  exit 1
fi

# why doesn't ln -sf overwrite my links?
rm -f mp3gain
rm -f aacgain
rm -f mpeg4ip
rm -f faad2

ln -sf ../mp3gain mp3gain
ln -sf ../aacgain aacgain
ln -sf ../"${MPEG4IPDIR}" mpeg4ip
ln -sf ../"${FAAD2DIR}" faad2

patch -p0 -N <patches/faad2.patch
patch -p0 -N <patches/mpeg4ip.patch
patch -p0 -N <patches/mp3gain.patch

rm -f mp3gain/mpglibDBL/config.h
cp patches/Makefile.am.mpglibDBL mp3gain/mpglibDBL/Makefile.am
cp patches/Makefile.am.mp3gain mp3gain/Makefile.am

echo
echo Running automake and friends...
aclocal
# on macos we need glibtoolize
libtoolize -f 2>/dev/null || glibtoolize -f
autoheader
autoconf
automake -a

echo
echo
echo Following directories were used for faad2 and mpeg4ip:
echo ../"$MPEG4IPDIR"
echo ../"$FAAD2DIR"
echo
echo If this is not what you wanted, \"touch\" the wanted directories and
echo rerun this script.
echo
echo To build aacgain with faad2 and mp4v2 already installed system-wide, run:
echo "mkdir build && cd build && ../configure && make"
echo
echo To build aacgain including faad2 and mp4v2, run the following:
echo "mkdir build && cd build && ../configure --enable-static-build && make"
echo
echo
echo If everything goes right, your binary will be located in:  build/aacgain
echo
echo To reduce binary size, run strip -s on the executable.
echo
