.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH SIS __drivermansuffix__ __vendorversion__
.SH NAME
sis \- SiS and XGI video driver
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qsis\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B sis
is an __xservername__ driver for SiS (Silicon Integrated Systems) and XGI video
chips. The driver is accelerated and provides support for colordepths of 8, 16
and 24 bpp. XVideo, Render and other extensions are supported as well.
.SH SUPPORTED HARDWARE
The
.B sis
driver supports PCI, AGP and PCIe video cards based on the following chipsets:
.PP
.B SiS5597/5598
.B SiS530/620
.B SiS6326/AGP/DVD
.B SiS300/305
.B SiS540
.B SiS630/730
.B SiS315/E/H/PRO
.B SiS550/551/552
.B SiS650/651/661/741
.B SiS330 (Xabre)
.B SiS760/761
.B XGI Volari V3/V5/V8
.B XGI Volari Z7
.PP
In the following text, the following terms are used:
.PP
.B old series
for SiS5597/5598, 530/620 and 6326/AGP/DVD
.PP
.B 300 series
for SiS300/305, 540 and 630/730
.PP
.B 315/330/340 series
for SiS315, 55x, 330, 661/741/76x (plus M, FX, MX, GX variants thereof), 340
and all XGI chips.
.PP
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to this
driver.
.PP
Detailed information on all supported options can be obtained at
http://www.winischhofer.at/linuxsisvga.shtml
.PP
This manpage only covers a subset of the supported options.
.PP
.I "1. For all supported chipsets"
.PP
The following driver
.B options
are supported on all chipsets:
.TP
.BI "Option \*qNoAccel\*q \*q" boolean \*q
Disable or enable 2D acceleration. Default: acceleration is enabled.
.TP
.BI "Option \*qHWCursor\*q \*q" boolean \*q
Enable or disable the HW cursor. Default: HWCursor is on.
.TP
.BI "Option \*qSWCursor\*q \*q" boolean \*q
The opposite of HWCursor. Default: SWCursor is off.
.TP
.BI "Option \*qRotate\*q \*q" string \*q
Rotate the display clockwise ("CW") or counter-clockwise ("CCW"). This
mode is unaccelerated. Using this option disables XVideo and the Resize
and Rotate extension (RandR). Rotation and reflection (see below) are
mutually exclusive.
Default: no rotation.
.TP
.BI "Option \*qReflect\*q \*q" string \*q
Reflect (mirror) the display horizontally ("X"), vertically ("Y") or
both ("XY"). This mode is unaccelerated. Using this option disables
XVideo and the Resize and Rotate extension (RandR). Rotation (see
above) and reflection are mutually exclusive.
Default: no reflection.
.TP
.BI "Option \*qCRT1Gamma\*q \*q" boolean \*q
Enable or disable gamma correction. (On the 300 and 315/330/340 series,
this option only affects CRT1 output).
Default: Gamma correction is enabled.
.PP
.I "2. Old series specific information"
.PP
The driver will auto-detect the amount of video memory present for all
these chips, but in the case of the 6326, it will limit the memory size
to 4MB. This is because the 6326's 2D engine can only address 4MB. The
remaining memory seems to be intended for 3D texture data, since only
the 3D engine can address RAM above 4MB. However, you can override this
limitation using the
.B \*qVideoRAM\*q
option in the Device section if your board has more than 4MB and you
need to use it. However, 2D acceleration, XVideo and the HWCursor will
be disabled in this case.
.PP
For the 6326, the driver has two built-in modes for high resolutions
which you should use instead of the default ones. These are named
.B \*qSIS1280x1024-75\*q
and
.B \*qSIS1600x1200-60\*q
and they will be added to the list of default modes. To use these modes,
just place them in your Screen section. Example:
.PP
.BI "Modes \*qSIS1600x1200-60\*q \*qSIS1280x1024x75\*q \*q1024x768\*q ...
.PP
Of these modes, 1280x1024 is only available at 8, 15 and 16bpp. 1600x1200
is available at 8bpp only.
.PP
TV support for the 6326
.PP
TV output is supported for the 6326. The driver will auto detect a
connected TV and in this case add the following display modes to the list
of available display modes: "PAL800x600", "PAL800x600U", "PAL720x540",
"PAL640x480", "NTSC640x480", "NTSC640x480U" and "NTSC640x400".
Use these modes like the hi-res modes described above.
.PP
The following driver
.B Options
are supported on the old series:
.TP
.BI "Option \*qTurboQueue\*q \*q" boolean \*q
Enable or disable TurboQueue mode.  Default: off for SIS530/620, on for
the others
.TP
.BI "Option \*qFastVram\*q \*q" boolean \*q
Enable or disable FastVram mode.  Enabling this sets the video RAM timing
to one cycle per read operation instead of two cycles. Disabling this will
set two cycles for read and write operations. Leaving this option out uses
the default, which varies depending on the chipset.
.TP
.BI "Option \*qNoHostBus\*q \*q" boolean \*q
(SiS5597/5598 only). Disable CPU-to-VGA host bus support. This
speeds up CPU to video RAM transfers. Default: Host bus is enabled.
.TP
.BI "Option \*qNoXVideo\*q \*q" boolean \*q
Disable XV (XVideo) extension support. Default: XVideo is on.
.TP
.BI "Option \*qNoYV12\*q \*q" boolean \*q
Disable YV12 Xv support. This might me required due to hardware bugs in some
chipsets. Disabling YV12 support forces Xv-aware applications to use YUV2 or
XShm for video output.
Default: YV12 support is on.
.TP
.BI "Option \*qTVStandard\*q \*q" string \*q
(6326 only) Valid parameters are
.B PAL
or
.B NTSC.
The default is set by a jumper on the card.
.TP
.BI "Option \*qTVXPosOffset\*q \*q" integer \*q
(6326 only) This option allows tuning the horizontal position of the image
for TV output. The range is from -16 to 16. Default: 0
.TP
.BI "Option \*qTVYPosOffset\*q \*q" integer \*q
(6326 only) This option allows tuning the vertical position of the image
for TV output. The range is from -16 to 16. Default: 0
.TP
.BI "Option \*qSIS6326TVEnableYFilter\*q \*q" boolean \*q
(6326 only) This option allows enabling/disabling the Y (chroma) filter for
TV output.
.TP
.BI "Option \*qSIS6326TVAntiFlicker\*q \*q" string \*q
(6326 only) This option allow enabling/disabling the anti flicker facility
for TV output. Possible parameters are
.B OFF, LOW, MED, HIGH
or
.B ADAPTIVE.
By experience,
.B ADAPTIVE
yields the best results, hence it is the default.
.PP
.I "2. 300 and 315/330/340 series specific information"
.PP
The 300 and 315/330/340 series, except the XGI Z7, feature two CRT
controllers and very often come with a video bridge for controlling LCD
and TV output. Hereinafter, the term
.B CRT1
refers to the VGA output of the chip, and
.B CRT2
refers to either LCD, TV or secondary VGA. Due to timing reasons,
only one CRT2 output can be active at the same time. But this
limitation does not apply to using CRT1 and CRT2 at the same time
which makes it possible to run the driver in dual head mode.
.PP
The driver supports the following video bridges:
.PP
.B SiS301
.B SiS301B(-DH)
.B SiS301C
.B SiS301LV
.B SiS302(E)LV
.PP
Instead of a video bridge, some machines have a third party
.B LVDS
transmitter to control LCD panels, and/or a
.B "Chrontel 7005"
or
.B "7019"
for TV output. All these are supported as well.
.PP
About TV output
.PP
The driver fully supports standard (PAL, NTSC, PAL-N, PAL-M) S-video or
composite output as well as high definition TV (HDTV) output via YPbPr plugs.
For more information on HDTV, please consult the author's website.
.PP
As regards S-video and CVBS output, the SiS301 and the Chrontel 7005 only
support resolutions up to 800x600. All others support resolutions up to
1024x768. However, due to a hardware bug, Xvideo might be distorted on SiS
video bridges if running NTSC or PAL-M at 1024x768.
.PP
About XVideo support
.PP
XVideo is supported on all chipsets of both families (except the XGI Volari
Z7 which lacks hardware support for video overlays). However, there
are some differences in hardware features which cause limitations.
The 300 series as well as the SiS55x, M650, 651, 661FX, M661FX, M661MX,
741, 741GX, M741, 76x, M76x support two video overlays. The SiS315/H/PRO,
650/740, 330, 340 and the XGI Volari V3, V5 and V8 chips support only one such
overlay. On chips with two overlays, one overlay is used for CRT1, the other
for CRT2. On the other chipsets, the option
.B \*qXvOnCRT2\*q
can be used to select the desired output device (CRT1 or CRT2).
.PP
About Merged Framebuffer support
.PP
Merged framebuffer mode is similar to dual head/Xinerama mode (for using two
output devices of one card at the same time), but has a few advantages which
make me recommend it strongly over Xinerama. Please see
http://www.winischhofer.at/linuxsisvga.shtml for detailed information.
.PP
About dual-head support
.PP
Dual head mode with or without Xinerama is fully supported, be it with one card
driving two outputs, be it two cards. Note that colordepth 8 is not supported in
dual head mode if run on one card with two outputs.
.PP
The following driver
.B Options
are supported on the 300 and 315/330/340 series:
.TP
.BI "Option \*qNoXVideo\*q \*q" boolean \*q
Disable XV (XVideo) extension support.
Default: XVideo is on.
.TP
.BI "Option \*qXvOnCRT2\*q \*q" boolean \*q
On chipsets with only one video overlay, this option can
used to bind the overlay to CRT1 ( if a monitor is detected
and if this option is either unset or set to
.B false
) or CRT2 ( if a CRT2 device is detected or forced, and if this
option is set to
.B true
). If either only CRT1 or CRT2 is detected, the driver decides
automatically. In Merged Framebuffer mode, this option is ignored.
Default: overlay is used on CRT1
.TP
.BI "Option \*qForceCRT1\*q \*q" boolean \*q
Force CRT1 to be on of off. If a monitor is connected, it will be
detected during server start. However, some old monitors are not
detected correctly. In such cases, you may set this option to
.B on
in order to make the driver initialize CRT1 anyway.
If this option is set to
.B off
, the driver will switch off CRT1.
Default: auto-detect
.TP
.BI "Option \*qForceCRT2Type\*q \*q" string \*q
Force display type to one of:
.B NONE
,
.B TV
,
.B SVIDEO
,
.B COMPOSITE
,
.B SVIDEO+COMPOSITE
,
.B SCART
,
.B LCD
,
.B VGA
;
.B NONE
will disable CRT2. The SVIDEO, COMPOSITE, SVIDEO+COMPOSITE and SCART
parameters are for SiS video bridges only and can be used to force the
driver to use a specific TV output connector (if present). For further
parameters, see the author's website.
Default: auto detect.
.TP
.BI "Option \*qCRT2Gamma\*q \*q" boolean \*q
Enable or disable gamma correction for CRT2. Only supported
for SiS video bridges. Default: Gamma correction for CRT2 is on.
.TP
.BI "Option \*qTVStandard\*q \*q" string \*q
Force the TV standard to either
.B PAL
or
.B NTSC.
On some machines with 630, 730 and the 315/330/340 series,
.B PALM
,
.B PALN
and
.B NTSCJ
are supported as well. Default: BIOS setting.
.TP
.BI "Option \*qTVXPosOffset\*q \*q" integer \*q
This option allows tuning the horizontal position of the image for
TV output. The range is from -32 to 32. Not supported on the Chrontel
7019. Default: 0
.TP
.BI "Option \*qTVYPosOffset\*q \*q" integer \*q
This option allows tuning the vertical position of the image for TV
output. The range is from -32 to 32. Not supported on the Chrontel
7019. Default: 0
.TP
.BI "Option \*qSISTVXScale\*q \*q" integer \*q
This option selects the horizontal zooming level for TV output. The range
is from -16 to 16. Only supported on SiS video bridges. Default: 0
.TP
.BI "Option \*qSISTVYScale\*q \*q" integer \*q
This option selects the vertical zooming level for TV output in the
following modes: 640x480, 800x600. On the 315/330/340 series, also 720x480,
720x576 and 768x576. The range is from -4 to 3. Only supported on
SiS video bridges. Default: 0
.TP
.BI "Option \*qCHTVOverscan\*q \*q" boolean \*q
On machines with a Chrontel TV encoder, this can be used to force the
TV mode to overscan or underscan.
.B on
means overscan,
.B off
means underscan.
Default: BIOS setting.
.TP
.BI "Option \*qCHTVSuperOverscan\*q \*q" boolean \*q
On machines with a Chrontel 7005 TV encoder, this option
enables a super-overscan mode. This is only supported if
the TV standard is PAL. Super overscan will produce an
image on the TV which is larger than the viewable area.
.PP
The driver supports many more options. Please see
http://www.winischhofer.at/linuxsisvga.shtml for
more information.
.PP
.I "3. 300 series specific information"
.PP
DRI is supported on the 300 series only. On Linux, prior to kernel 2.6.3,
DRI requires the kernel's SiS framebuffer driver (
.B sisfb
). The SiS DRM kernel driver as well as the SiS DRI client driver are
required in any case.
.PP
Sisfb, if installed and running, takes care of memory management for
texture data. In order to prevent the X Server and sisfb from overwriting
each other's data, sisfb reserves an amount of video memory for the X driver.
This amount can either be selected using sisfb's mem parameter, or
auto-selected depending on the amount of total video RAM available.
.PP
Sisfb can be used for memory management only, or as a complete framebuffer
driver. If you start sisfb with a valid mode (ie you gain a graphical console),
the X driver can communicate with sisfb and doesn't require any
manual configuration for finding out about the video memory it is allowed
to use.
.PP
However, if you are running a 2.4 series Linux kernel and use sisfb for
video memory management only, ie you started sisfb with mode=none and still
have a text mode console, there is no communication between sisfb and the
X driver. For this purpose,
the
.TP
.BI "Option \*qMaxXFBMem\*q \*q" integer \*q
.PP
exists. This option must be set to the same value as given to sisfb through
its "mem" parameter, ie the amount of memory to use for X in kilobytes.
.PP
If you started sisfb without the mem argument, sisfb will reserve
.TP
12288KB if more than 16MB of total video RAM is available,
.TP
8192KB if between 12 and 16MB of video RAM is available,
.TP
4096KB in all other cases.
.PP
If you intend to use DRI on an integrated chipset (540, 630, 730), I recommend
setting the total video memory in the BIOS setup utility to 64MB.
.PP
PLEASE NOTE: As of Linux 2.6.3 and under *BSD, sisfb is not required for
memory management. Hence, this option is mandatory on such systems not
running sisfb to decide how much memory X should reserve for DRI. If the
option is omitted, DRI will have no memory assigned, and all DRI applications
will quit with errors like "failed to allocate Z-buffer" or the like.
.TP
.BI "Option \*qDRI\*q \*q" boolean \*q
This option allows enabling or disabling DRI. By default, DRI is on.
.TP
.BI "Option \*qAGPSize\*q \*q" integer \*q
This option allows selecting the amount of AGP memory to be used for DRI.
The amount is to be specified in megabyte, the default is 8.
.SH "KNOWN BUGS"
none.
.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__)
.PP
.B "http://www.winischhofer.at/linuxsisvga.shtml"
for more information and updates
.SH AUTHORS
Author: Thomas Winischhofer. Formerly based on code by Alan Hourihane,
Mike Chapman, Juanjo Santamarta, Mitani Hiroshi, David Thomas, Sung-Ching Lin,
Ademar Reis.
