# JaqalMixer - Just Another Qt ALSA Mixer
...is an advanced control panel application that gives you direct access to the low-level controls of your soundcard, such as analog volume controls, signal routing, jack sensor indicators, S/PDIF status codes and several other settings (varies by hardware).

It interfaces directly with ALSA, without going through any higher layers of the audio stack (e.g. pipewire), basically aiming to be a more modern and user-friendly successor to good old `alsamixer`, but with some extended functionality.

Currently it's tested on a few Realtek chips, the CMI8738 and a few generic USB devices, but it should work with any sound device that alsa handles.

![](docs/sshot-out.png)![](docs/sshot-in.png)![](docs/sshot-misc.png)

Please note that *every* parameter reported by your soundcard should be displayed in all cases; the ones not properly sorted will simply go in the Miscellaneous group. So if you see some stuff in the wrong section or you don't see something that you know should be there, or you experience any other bug or anomaly, feel free to drop an issue! :>

## Build dependencies
- Arch-based: `qt6-base alsa-lib`
- Debian-based: `qt6-base-dev libasound2-dev`
## Building and installation
```
mkdir build
cd build
cmake ..
make
sudo make install
```
## Optional runtime dependencies
- `alsa-utils`: for saving settings persistently