/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimppdb_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"
#include "gimppdb_pdb.h"

/**
 * _gimp_pdb_temp_name:
 *
 * Generates a unique temporary PDB name.
 *
 * This procedure generates a temporary PDB entry name that is
 * guaranteed to be unique.
 *
 * Returns: (transfer full): A unique temporary name for a temporary PDB entry.
 *          The returned value must be freed with g_free().
 **/
gchar *
_gimp_pdb_temp_name (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *temp_name = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-temp-name",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    temp_name = GIMP_VALUES_DUP_STRING (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return temp_name;
}

/**
 * _gimp_pdb_dump:
 * @file: The dump filename.
 *
 * Dumps the current contents of the procedural database
 *
 * This procedure dumps the contents of the procedural database to the
 * specified file. The file will contain all of the information
 * provided for each registered procedure.
 *
 * Returns: TRUE on success.
 **/
gboolean
_gimp_pdb_dump (GFile *file)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_FILE, file,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-dump",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_query:
 * @name: The regex for procedure name.
 * @blurb: The regex for procedure blurb.
 * @help: The regex for procedure help.
 * @authors: The regex for procedure authors.
 * @copyright: The regex for procedure copyright.
 * @date: The regex for procedure date.
 * @proc_type: The regex for procedure type: { 'Internal GIMP procedure', 'GIMP Plug-in', 'GIMP Extension', 'Temporary Procedure' }.
 * @procedure_names: (out) (array zero-terminated=1) (transfer full): The list of procedure names.
 *
 * Queries the procedural database for its contents using regular
 * expression matching.
 *
 * This procedure queries the contents of the procedural database. It
 * is supplied with seven arguments matching procedures on { name,
 * blurb, help, authors, copyright, date, procedure type}. This is
 * accomplished using regular expression matching. For instance, to
 * find all procedures with \"jpeg\" listed in the blurb, all seven
 * arguments can be supplied as \".*\", except for the second, which
 * can be supplied as \".*jpeg.*\". There are two return arguments for
 * this procedure. The first is the number of procedures matching the
 * query. The second is a concatenated list of procedure names
 * corresponding to those matching the query. If no matching entries
 * are found, then the returned string is NULL and the number of
 * entries is 0.
 *
 * Returns: TRUE on success.
 **/
gboolean
_gimp_pdb_query (const gchar   *name,
                 const gchar   *blurb,
                 const gchar   *help,
                 const gchar   *authors,
                 const gchar   *copyright,
                 const gchar   *date,
                 const gchar   *proc_type,
                 gchar       ***procedure_names)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, name,
                                          G_TYPE_STRING, blurb,
                                          G_TYPE_STRING, help,
                                          G_TYPE_STRING, authors,
                                          G_TYPE_STRING, copyright,
                                          G_TYPE_STRING, date,
                                          G_TYPE_STRING, proc_type,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-query",
                                               args);
  gimp_value_array_unref (args);

  *procedure_names = NULL;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    *procedure_names = GIMP_VALUES_DUP_STRV (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_proc_exists:
 * @procedure_name: The procedure name.
 *
 * Checks if the specified procedure exists in the procedural database
 *
 * This procedure checks if the specified procedure is registered in
 * the procedural database.
 *
 * Returns: Whether a procedure of that name is registered.
 *
 * Since: 2.6
 **/
gboolean
_gimp_pdb_proc_exists (const gchar *procedure_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean exists = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-proc-exists",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    exists = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return exists;
}

/**
 * _gimp_pdb_get_proc_info:
 * @procedure_name: The procedure name.
 * @proc_type: (out): The procedure type.
 * @num_args: (out): The number of input arguments.
 * @num_values: (out): The number of return values.
 *
 * Queries the procedural database for information on the specified
 * procedure.
 *
 * This procedure returns information on the specified procedure. The
 * procedure type, number of input, and number of return values are
 * returned. For specific information on each input argument and return
 * value, use the gimp_pdb_db_proc_argument() and
 * gimp_pdb_db_proc_return_value() procedures.
 *
 * Returns: TRUE on success.
 **/
gboolean
_gimp_pdb_get_proc_info (const gchar     *procedure_name,
                         GimpPDBProcType *proc_type,
                         gint            *num_args,
                         gint            *num_values)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-get-proc-info",
                                               args);
  gimp_value_array_unref (args);

  *proc_type = 0;
  *num_args = 0;
  *num_values = 0;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *proc_type = GIMP_VALUES_GET_ENUM (return_vals, 1);
      *num_args = GIMP_VALUES_GET_INT (return_vals, 2);
      *num_values = GIMP_VALUES_GET_INT (return_vals, 3);
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_get_proc_argument:
 * @procedure_name: The procedure name.
 * @arg_num: The argument number.
 *
 * Queries the procedural database for information on the specified
 * procedure's argument.
 *
 * This procedure returns the #GParamSpec of procedure_name's argument.
 *
 * Returns: (transfer full): The GParamSpec of the argument.
 *          The returned value must be freed with g_param_spec_unref().
 *
 * Since: 3.0
 **/
GParamSpec *
_gimp_pdb_get_proc_argument (const gchar *procedure_name,
                             gint         arg_num)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GParamSpec *param_spec = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_INT, arg_num,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-get-proc-argument",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    param_spec = GIMP_VALUES_DUP_PARAM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return param_spec;
}

/**
 * _gimp_pdb_get_proc_return_value:
 * @procedure_name: The procedure name.
 * @val_num: The return value number.
 *
 * Queries the procedural database for information on the specified
 * procedure's return value.
 *
 * This procedure returns the #GParamSpec of procedure_name's return
 * value.
 *
 * Returns: (transfer full): The GParamSpec of the return value.
 *          The returned value must be freed with g_param_spec_unref().
 *
 * Since: 3.0
 **/
GParamSpec *
_gimp_pdb_get_proc_return_value (const gchar *procedure_name,
                                 gint         val_num)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GParamSpec *param_spec = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_INT, val_num,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-get-proc-return-value",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    param_spec = GIMP_VALUES_DUP_PARAM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return param_spec;
}

/**
 * _gimp_pdb_set_proc_image_types:
 * @procedure_name: The procedure for which to install the menu path.
 * @image_types: The procedure's supported image types.
 *
 * Set the supported image types for a plug-in procedure.
 *
 * This procedure sets the supported images types for the given
 * procedure.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
_gimp_pdb_set_proc_image_types (const gchar *procedure_name,
                                const gchar *image_types)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_STRING, image_types,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-set-proc-image-types",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_get_proc_image_types:
 * @procedure_name: The procedure name.
 *
 * Queries the procedural database for the image types supported by the
 * specified procedure.
 *
 * This procedure returns the image types supported by the specified
 * procedure.
 *
 * Returns: (transfer full): The image types.
 *          The returned value must be freed with g_free().
 *
 * Since: 3.0
 **/
gchar *
_gimp_pdb_get_proc_image_types (const gchar *procedure_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *image_types = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-get-proc-image-types",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    image_types = GIMP_VALUES_DUP_STRING (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return image_types;
}

/**
 * _gimp_pdb_set_proc_sensitivity_mask:
 * @procedure_name: The procedure.
 * @mask: The procedure's sensitivity mask.
 *
 * Set the sensitivity mask for a plug-in procedure.
 *
 * This procedure sets the sensitivity mask for the given procedure.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
_gimp_pdb_set_proc_sensitivity_mask (const gchar *procedure_name,
                                     gint         mask)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_INT, mask,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-set-proc-sensitivity-mask",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_set_proc_menu_label:
 * @procedure_name: The procedure for which to install the menu path.
 * @menu_label: The procedure's menu label.
 *
 * Set the menu label for a plug-in procedure.
 *
 * This procedure sets the menu label for the given procedure.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
_gimp_pdb_set_proc_menu_label (const gchar *procedure_name,
                               const gchar *menu_label)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_STRING, menu_label,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-set-proc-menu-label",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_get_proc_menu_label:
 * @procedure_name: The procedure name.
 *
 * Queries the procedural database for the procedure's menu label.
 *
 * This procedure returns the menu label of the specified procedure.
 *
 * Returns: (transfer full): The menu_label.
 *          The returned value must be freed with g_free().
 *
 * Since: 3.0
 **/
gchar *
_gimp_pdb_get_proc_menu_label (const gchar *procedure_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *menu_label = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-get-proc-menu-label",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    menu_label = GIMP_VALUES_DUP_STRING (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return menu_label;
}

/**
 * _gimp_pdb_add_proc_menu_path:
 * @procedure_name: The procedure for which to install the menu path.
 * @menu_path: The procedure's additional menu path.
 *
 * Register an additional menu path for a plug-in procedure.
 *
 * This procedure installs an additional menu entry for the given
 * procedure.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
_gimp_pdb_add_proc_menu_path (const gchar *procedure_name,
                              const gchar *menu_path)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_STRING, menu_path,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-add-proc-menu-path",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_get_proc_menu_paths:
 * @procedure_name: The procedure name.
 *
 * Queries the procedural database for the procedure's menu paths.
 *
 * This procedure returns the menu paths of the specified procedure.
 *
 * Returns: (array zero-terminated=1) (transfer full):
 *          The menu paths of the plug-in.
 *          The returned value must be freed with g_strfreev().
 *
 * Since: 3.0
 **/
gchar **
_gimp_pdb_get_proc_menu_paths (const gchar *procedure_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar **menu_paths = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-get-proc-menu-paths",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    menu_paths = GIMP_VALUES_DUP_STRV (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return menu_paths;
}

/**
 * _gimp_pdb_set_proc_icon:
 * @procedure_name: The procedure for which to install the icon.
 * @icon_type: The type of the icon.
 * @icon_data: The procedure's icon. The format depends on the 'icon_type' parameter.
 *
 * Register an icon for a plug-in procedure.
 *
 * This procedure installs an icon for the given procedure.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
_gimp_pdb_set_proc_icon (const gchar  *procedure_name,
                         GimpIconType  icon_type,
                         GBytes       *icon_data)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          GIMP_TYPE_ICON_TYPE, icon_type,
                                          G_TYPE_BYTES, icon_data,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-set-proc-icon",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_set_proc_documentation:
 * @procedure_name: The procedure for which to install the menu path.
 * @blurb: A short blurb.
 * @help: Detailed procedure help.
 * @help_id: The procedure help_id.
 *
 * Set the documentation for a plug-in procedure.
 *
 * This procedure sets the documentation for the given procedure.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
_gimp_pdb_set_proc_documentation (const gchar *procedure_name,
                                  const gchar *blurb,
                                  const gchar *help,
                                  const gchar *help_id)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_STRING, blurb,
                                          G_TYPE_STRING, help,
                                          G_TYPE_STRING, help_id,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-set-proc-documentation",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_get_proc_documentation:
 * @procedure_name: The procedure name.
 * @blurb: (out) (transfer full): A short blurb.
 * @help: (out) (transfer full): Detailed procedure help.
 * @help_id: (out) (transfer full): The procedure help_id.
 *
 * Queries the procedural database for documentation on the specified
 * procedure.
 *
 * This procedure returns documentation on the specified procedure. A
 * short blurb, detailed help and help_id.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
_gimp_pdb_get_proc_documentation (const gchar  *procedure_name,
                                  gchar       **blurb,
                                  gchar       **help,
                                  gchar       **help_id)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-get-proc-documentation",
                                               args);
  gimp_value_array_unref (args);

  *blurb = NULL;
  *help = NULL;
  *help_id = NULL;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *blurb = GIMP_VALUES_DUP_STRING (return_vals, 1);
      *help = GIMP_VALUES_DUP_STRING (return_vals, 2);
      *help_id = GIMP_VALUES_DUP_STRING (return_vals, 3);
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_set_proc_attribution:
 * @procedure_name: The procedure for which to install the menu path.
 * @authors: Authors of the procedure.
 * @copyright: The copyright.
 * @date: Copyright date.
 *
 * Set the attribution for a plug-in procedure.
 *
 * This procedure sets the attribution for the given procedure.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
_gimp_pdb_set_proc_attribution (const gchar *procedure_name,
                                const gchar *authors,
                                const gchar *copyright,
                                const gchar *date)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_STRING, authors,
                                          G_TYPE_STRING, copyright,
                                          G_TYPE_STRING, date,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-set-proc-attribution",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_get_proc_attribution:
 * @procedure_name: The procedure name.
 * @authors: (out) (transfer full): Authors of the procedure.
 * @copyright: (out) (transfer full): The copyright.
 * @date: (out) (transfer full): Copyright date.
 *
 * Queries the procedural database for attribution information on the
 * specified procedure.
 *
 * This procedure returns attribution information on the specified
 * procedure. The authors, copyright information and date are returned.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
_gimp_pdb_get_proc_attribution (const gchar  *procedure_name,
                                gchar       **authors,
                                gchar       **copyright,
                                gchar       **date)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-get-proc-attribution",
                                               args);
  gimp_value_array_unref (args);

  *authors = NULL;
  *copyright = NULL;
  *date = NULL;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *authors = GIMP_VALUES_DUP_STRING (return_vals, 1);
      *copyright = GIMP_VALUES_DUP_STRING (return_vals, 2);
      *date = GIMP_VALUES_DUP_STRING (return_vals, 3);
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_set_file_proc_load_handler:
 * @procedure_name: The name of the procedure to be used for loading.
 * @extensions: comma separated list of extensions this handler can load (i.e. \"jpg,jpeg\").
 * @prefixes: comma separated list of prefixes this handler can load (i.e. \"http:,ftp:\").
 * @magics: comma separated list of magic file information this handler can load (i.e. \"0,string,GIF\").
 *
 * Registers a file load handler procedure.
 *
 * Registers a procedural database procedure to be called to load files
 * of a particular file format using magic file information.
 *
 * Returns: TRUE on success.
 **/
gboolean
_gimp_pdb_set_file_proc_load_handler (const gchar *procedure_name,
                                      const gchar *extensions,
                                      const gchar *prefixes,
                                      const gchar *magics)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_STRING, extensions,
                                          G_TYPE_STRING, prefixes,
                                          G_TYPE_STRING, magics,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-set-file-proc-load-handler",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_set_file_proc_save_handler:
 * @procedure_name: The name of the procedure to be used for saving.
 * @extensions: comma separated list of extensions this handler can save (i.e. \"jpg,jpeg\").
 * @prefixes: comma separated list of prefixes this handler can save (i.e. \"http:,ftp:\").
 *
 * Registers a file save handler procedure.
 *
 * Registers a procedural database procedure to be called to save files
 * in a particular file format.
 *
 * Returns: TRUE on success.
 **/
gboolean
_gimp_pdb_set_file_proc_save_handler (const gchar *procedure_name,
                                      const gchar *extensions,
                                      const gchar *prefixes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_STRING, extensions,
                                          G_TYPE_STRING, prefixes,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-set-file-proc-save-handler",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_set_file_proc_priority:
 * @procedure_name: The name of the procedure to set the priority of.
 * @priority: The procedure priority.
 *
 * Sets the priority of a file handler procedure.
 *
 * Sets the priority of a file handler procedure. When more than one
 * procedure matches a given file, the procedure with the lowest
 * priority is used; if more than one procedure has the lowest
 * priority, it is unspecified which one of them is used. The default
 * priority for file handler procedures is 0.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10.6
 **/
gboolean
_gimp_pdb_set_file_proc_priority (const gchar *procedure_name,
                                  gint         priority)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_INT, priority,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-set-file-proc-priority",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_set_file_proc_mime_types:
 * @procedure_name: The name of the procedure to associate a MIME type with.
 * @mime_types: A comma-separated list of MIME types, such as \"image/jpeg\".
 *
 * Associates MIME types with a file handler procedure.
 *
 * Registers MIME types for a file handler procedure. This allows GIMP
 * to determine the MIME type of the file opened or saved using this
 * procedure. It is recommended that only one MIME type is registered
 * per file procedure; when registering more than one MIME type, GIMP
 * will associate the first one with files opened or saved with this
 * procedure.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
_gimp_pdb_set_file_proc_mime_types (const gchar *procedure_name,
                                    const gchar *mime_types)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_STRING, mime_types,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-set-file-proc-mime-types",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_set_file_proc_handles_remote:
 * @procedure_name: The name of the procedure to enable remote URIs for.
 *
 * Registers a file handler procedure as capable of handling remote
 * URIs.
 *
 * Registers a file handler procedure as capable of handling remote
 * URIs. This allows GIMP to call the procedure directly for all kinds
 * of URIs, not only on local file:// URIs.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
_gimp_pdb_set_file_proc_handles_remote (const gchar *procedure_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-set-file-proc-handles-remote",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_set_file_proc_handles_raw:
 * @procedure_name: The name of the procedure to enable raw handling for.
 *
 * Registers a file handler procedure as capable of handling raw camera
 * files.
 *
 * Registers a file handler procedure as capable of handling raw
 * digital camera files. Use this procedure only to register raw load
 * handlers, calling it on a save handler will generate an error.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
_gimp_pdb_set_file_proc_handles_raw (const gchar *procedure_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-set-file-proc-handles-raw",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_set_file_proc_handles_vector:
 * @procedure_name: The name of the vector load procedure.
 *
 * Registers a load handler procedure as handling vector formats.
 *
 * Registers a file handler procedure as handling vector image formats.
 * Use this procedure only to register a GimpVectorLoadProcedure,
 * calling it on any other handler will generate an error.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
_gimp_pdb_set_file_proc_handles_vector (const gchar *procedure_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-set-file-proc-handles-vector",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_set_file_proc_thumbnail_loader:
 * @load_proc: The name of the file load procedure.
 * @thumb_proc: The name of the thumbnail load procedure.
 *
 * Associates a thumbnail loader with a file load procedure.
 *
 * Some file formats allow for embedded thumbnails, other file formats
 * contain a scalable image or provide the image data in different
 * resolutions. A file plug-in for such a format may register a special
 * procedure that allows GIMP to load a thumbnail preview of the image.
 * This procedure is then associated with the standard load procedure
 * using this function.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
_gimp_pdb_set_file_proc_thumbnail_loader (const gchar *load_proc,
                                          const gchar *thumb_proc)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, load_proc,
                                          G_TYPE_STRING, thumb_proc,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-set-file-proc-thumbnail-loader",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_set_batch_interpreter:
 * @procedure_name: The name of the procedure to be used for running batch commands.
 * @interpreter_name: A public-facing name for the interpreter, such as \"Python 3\".
 *
 * Registers a batch interpreter procedure.
 *
 * Registers a procedural database procedure to be called with the
 * command line interface options --batch-interpreter and --batch.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
_gimp_pdb_set_batch_interpreter (const gchar *procedure_name,
                                 const gchar *interpreter_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, procedure_name,
                                          G_TYPE_STRING, interpreter_name,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-set-batch-interpreter",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_get_data:
 * @identifier: The identifier associated with data.
 * @data: (out) (transfer full): A byte array containing data.
 *
 * Returns data associated with the specified identifier.
 *
 * This procedure returns any data which may have been associated with
 * the specified identifier. The data is a variable length array of
 * bytes. If no data has been associated with the identifier, an error
 * is returned.
 *
 * Returns: TRUE on success.
 **/
gboolean
_gimp_pdb_get_data (const gchar  *identifier,
                    GBytes      **data)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, identifier,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-get-data",
                                               args);
  gimp_value_array_unref (args);

  *data = NULL;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    *data = GIMP_VALUES_DUP_BYTES (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_pdb_set_data:
 * @identifier: The identifier associated with data.
 * @data: A byte array containing data.
 *
 * Associates the specified identifier with the supplied data.
 *
 * This procedure associates the supplied data with the provided
 * identifier. The data may be subsequently retrieved by a call to
 * 'procedural-db-get-data'.
 *
 * Returns: TRUE on success.
 **/
gboolean
_gimp_pdb_set_data (const gchar *identifier,
                    GBytes      *data)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, identifier,
                                          G_TYPE_BYTES, data,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pdb-set-data",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
