/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CryptoFileSystemUri {
    public static final String URI_SCHEME = "cryptomator";
    private static final Pattern UNC_URI_PATTERN = Pattern.compile("^file://[^@/]+(@SSL)?(@[0-9]+)?.*");
    private final Path pathToVault;
    private final String pathInsideVault;

    private CryptoFileSystemUri(URI uri) {
        CryptoFileSystemUri.validate(uri);
        this.pathToVault = CryptoFileSystemUri.uncCompatibleUriToPath(URI.create(uri.getAuthority()));
        this.pathInsideVault = uri.getPath();
    }

    static Path uncCompatibleUriToPath(URI uri) {
        String in = uri.toString();
        Matcher m = UNC_URI_PATTERN.matcher(in);
        if (m.find() && (m.group(1) != null || m.group(2) != null)) {
            String out = in.substring("file:".length()).replace('/', '\\');
            return Paths.get(out, new String[0]);
        }
        return Paths.get(uri);
    }

    public static URI create(Path pathToVault, String ... pathComponentsInsideVault) {
        try {
            return new URI(URI_SCHEME, pathToVault.toUri().toString(), "/" + String.join((CharSequence)"/", pathComponentsInsideVault), null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Can not create URI from given input", e);
        }
    }

    static CryptoFileSystemUri parse(URI uri) throws IllegalArgumentException {
        return new CryptoFileSystemUri(uri);
    }

    private static void validate(URI uri) {
        if (!URI_SCHEME.equals(uri.getScheme())) {
            throw new IllegalArgumentException("URI must have cryptomator scheme");
        }
        if (uri.getAuthority() == null) {
            throw new IllegalArgumentException("URI must have an authority");
        }
        if (uri.getPath() == null || uri.getPath().isEmpty()) {
            throw new IllegalArgumentException("URI must have a path");
        }
        if (uri.getQuery() != null) {
            throw new IllegalArgumentException("URI must not have a query part");
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("URI must not have a fragment part");
        }
    }

    public Path pathToVault() {
        return this.pathToVault;
    }

    public String pathInsideVault() {
        return this.pathInsideVault;
    }
}

