/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.messages;

import java.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class EmptyCollectionHelper {
    EmptyCollectionHelper() {
    }

    static int determineSignatureOffsetDict(byte[] sigb, int currentOffset) {
        return EmptyCollectionHelper.determineEndOfBracketStructure(sigb, currentOffset, '{', '}');
    }

    static int determineSignatureOffsetArray(byte[] sigb, int currentOffset) {
        String sigSubString = EmptyCollectionHelper.determineSubSignature(sigb, currentOffset);
        if (sigSubString.isEmpty()) {
            return currentOffset;
        }
        ECollectionSubType newtype = EmptyCollectionHelper.determineCollectionSubType((char)sigb[currentOffset]);
        switch (newtype) {
            case ARRAY: {
                return EmptyCollectionHelper.determineSignatureOffsetArray(sigb, currentOffset + 1);
            }
            case DICT: {
                return EmptyCollectionHelper.determineSignatureOffsetDict(sigb, currentOffset);
            }
            case STRUCT: {
                return EmptyCollectionHelper.determineSignatureOffsetStruct(sigb, currentOffset);
            }
            case PRIMITIVE: {
                return currentOffset;
            }
        }
        throw new IllegalStateException("Unable to parse signature for empty collection");
    }

    private static int determineSignatureOffsetStruct(byte[] sigb, int currentOffset) {
        return EmptyCollectionHelper.determineEndOfBracketStructure(sigb, currentOffset, '(', ')');
    }

    private static int determineEndOfBracketStructure(byte[] sigb, int currentOffset, char openChar, char closeChar) {
        String sigSubString = EmptyCollectionHelper.determineSubSignature(sigb, currentOffset);
        if (sigSubString.isEmpty()) {
            return currentOffset;
        }
        int i = 0;
        int depth = 0;
        for (char chr : sigSubString.toCharArray()) {
            if (chr == openChar) {
                ++depth;
            } else if (chr == closeChar) {
                --depth;
            }
            if (depth == 0) {
                return currentOffset + i;
            }
            ++i;
        }
        throw new IllegalStateException("Unable to parse signature for empty collection");
    }

    private static String determineSubSignature(byte[] sigb, int currentOffset) {
        byte[] restSigbytes = Arrays.copyOfRange(sigb, currentOffset, sigb.length);
        return new String(restSigbytes);
    }

    private static ECollectionSubType determineCollectionSubType(char sig) {
        switch (sig) {
            case '(': {
                return ECollectionSubType.STRUCT;
            }
            case '{': {
                return ECollectionSubType.DICT;
            }
            case 'a': {
                return ECollectionSubType.ARRAY;
            }
        }
        return ECollectionSubType.PRIMITIVE;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static enum ECollectionSubType {
        STRUCT,
        DICT,
        ARRAY,
        PRIMITIVE;

    }
}

