/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav;

import com.google.common.base.Preconditions;
import dagger.Module;
import dagger.Provides;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Qualifier;
import javax.inject.Singleton;
import javax.servlet.Servlet;
import org.cryptomator.frontend.webdav.DefaultServlet;
import org.cryptomator.frontend.webdav.mount.MounterModule;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

@Module(includes={MounterModule.class})
class WebDavServerModule {
    private static final int MAX_PENDING_REQUESTS = 400;
    private static final int MAX_THREADS = 100;
    private static final int THREAD_IDLE_SECONDS = 60;
    private static final String ROOT_PATH = "/";
    private AtomicInteger threadNum = new AtomicInteger(1);

    WebDavServerModule() {
    }

    @Provides
    @Singleton
    ThreadPoolExecutor provideThreadPoolExecutor() {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(400);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(100, 100, 60L, TimeUnit.SECONDS, queue);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    @Provides
    @Singleton
    ExecutorService provideExecutorService(ThreadPoolExecutor executorService) {
        return executorService;
    }

    @Provides
    @Singleton
    ExecutorThreadPool provideThreadPool(ThreadPoolExecutor executorService) {
        ExecutorThreadPool threadPool = new ExecutorThreadPool(executorService);
        executorService.setThreadFactory(this::createServerThread);
        try {
            threadPool.start();
            return threadPool;
        }
        catch (Exception e) {
            throw new IllegalStateException("Implementation known not to throw an exception.", e);
        }
    }

    private Thread createServerThread(Runnable runnable) {
        Thread t = new Thread(runnable, String.format("webdav-%03d", this.threadNum.getAndIncrement()));
        t.setDaemon(true);
        return t;
    }

    @Provides
    @Singleton
    Server provideServer(ExecutorThreadPool threadPool, ContextHandlerCollection servletCollection) {
        Preconditions.checkState((boolean)threadPool.isStarted());
        Server server = new Server((ThreadPool)threadPool);
        server.setHandler((Handler)servletCollection);
        return server;
    }

    @Provides
    @Singleton
    ServerConnector provideServerConnector(Server server) {
        HttpConfiguration config = new HttpConfiguration();
        config.setUriCompliance(UriCompliance.from((String)"0,AMBIGUOUS_PATH_SEPARATOR,AMBIGUOUS_PATH_ENCODING"));
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(config)});
        server.setConnectors(new Connector[]{connector});
        return connector;
    }

    @Provides
    @Singleton
    ContextHandlerCollection provideContextHandlerCollection(@CatchAll ServletContextHandler catchAllServletHandler) {
        ContextHandlerCollection collection = new ContextHandlerCollection();
        collection.addHandler((Handler)catchAllServletHandler);
        return collection;
    }

    @Provides
    @Singleton
    @CatchAll
    ServletContextHandler provideServletContextHandler(DefaultServlet servlet) {
        ServletContextHandler servletContext = new ServletContextHandler(null, ROOT_PATH, 0);
        ServletHolder servletHolder = new ServletHolder(ROOT_PATH, (Servlet)servlet);
        servletContext.addServlet(servletHolder, ROOT_PATH);
        return servletContext;
    }

    @Provides
    @Singleton
    @ContextPaths
    Collection<String> provideContextPaths() {
        return new HashSet<String>();
    }

    @Qualifier
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface ContextPaths {
    }

    @Qualifier
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface CatchAll {
    }
}

