/*
 * Copyright (C) 2012 Fons Adriaensen <fons@linuxaudio.org>
 * Copyright (C) 2013-2014 Paul Davis <paul@linuxaudiosystems.com>
 * Copyright (C) 2013-2019 Robin Gareus <robin@gareus.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __VUMETERDSP_H
#define __VUMETERDSP_H

#include "ardour/libardour_visibility.h"

class LIBARDOUR_API Vumeterdsp
{
public:

    Vumeterdsp (void);
    ~Vumeterdsp (void);

    void process (float const *p, int n);
    float read (void);
    void reset ();

    static void init (float fsamp);

private:

    float          _z1;          // filter state
    float          _z2;          // filter state
    float          _m;           // max value since last read()
    bool           _res;         // flag to reset m

    static float   _w;           // lowpass filter coefficient
    static float   _g;           // gain factor
};

#endif
