package jiconfont.icons.google_material_design_icons;

import jiconfont.IconCode;
import jiconfont.IconFont;

import java.io.InputStream;

/**
 * Copyright (c) 2016 jIconFont <BR>
 * <BR>
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to the following conditions:<BR>
 * <BR>
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.<BR>
 * <BR>
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
public enum GoogleMaterialDesignIcons implements IconCode {

  ACCESSIBILITY('\uE84E'),
  ACCESSIBLE('\uE914'),
  ACCESS_ALARM('\uE190'),
  ACCESS_ALARMS('\uE191'),
  ACCESS_TIME('\uE192'),
  ACCOUNT_BALANCE('\uE84F'),
  ACCOUNT_BALANCE_WALLET('\uE850'),
  ACCOUNT_BOX('\uE851'),
  ACCOUNT_CIRCLE('\uE853'),
  AC_UNIT('\uEB3B'),
  ADB('\uE60E'),
  ADD('\uE145'),
  ADD_ALARM('\uE193'),
  ADD_ALERT('\uE003'),
  ADD_A_PHOTO('\uE439'),
  ADD_BOX('\uE146'),
  ADD_CIRCLE('\uE147'),
  ADD_CIRCLE_OUTLINE('\uE148'),
  ADD_LOCATION('\uE567'),
  ADD_SHOPPING_CART('\uE854'),
  ADD_TO_PHOTOS('\uE39D'),
  ADD_TO_QUEUE('\uE05C'),
  ADJUST('\uE39E'),
  AIRLINE_SEAT_FLAT('\uE630'),
  AIRLINE_SEAT_FLAT_ANGLED('\uE631'),
  AIRLINE_SEAT_INDIVIDUAL_SUITE('\uE632'),
  AIRLINE_SEAT_LEGROOM_EXTRA('\uE633'),
  AIRLINE_SEAT_LEGROOM_NORMAL('\uE634'),
  AIRLINE_SEAT_LEGROOM_REDUCED('\uE635'),
  AIRLINE_SEAT_RECLINE_EXTRA('\uE636'),
  AIRLINE_SEAT_RECLINE_NORMAL('\uE637'),
  AIRPLANEMODE_ACTIVE('\uE195'),
  AIRPLANEMODE_INACTIVE('\uE194'),
  AIRPLAY('\uE055'),
  AIRPORT_SHUTTLE('\uEB3C'),
  ALARM('\uE855'),
  ALARM_ADD('\uE856'),
  ALARM_OFF('\uE857'),
  ALARM_ON('\uE858'),
  ALBUM('\uE019'),
  ALL_INCLUSIVE('\uEB3D'),
  ALL_OUT('\uE90B'),
  ANDROID('\uE859'),
  ANNOUNCEMENT('\uE85A'),
  APPS('\uE5C3'),
  ARCHIVE('\uE149'),
  ARROW_BACK('\uE5C4'),
  ARROW_DOWNWARD('\uE5DB'),
  ARROW_DROP_DOWN('\uE5C5'),
  ARROW_DROP_DOWN_CIRCLE('\uE5C6'),
  ARROW_DROP_UP('\uE5C7'),
  ARROW_FORWARD('\uE5C8'),
  ARROW_UPWARD('\uE5D8'),
  ART_TRACK('\uE060'),
  ASPECT_RATIO('\uE85B'),
  ASSESSMENT('\uE85C'),
  ASSIGNMENT('\uE85D'),
  ASSIGNMENT_IND('\uE85E'),
  ASSIGNMENT_LATE('\uE85F'),
  ASSIGNMENT_RETURN('\uE860'),
  ASSIGNMENT_RETURNED('\uE861'),
  ASSIGNMENT_TURNED_IN('\uE862'),
  ASSISTANT('\uE39F'),
  ASSISTANT_PHOTO('\uE3A0'),
  ATTACHMENT('\uE2BC'),
  ATTACH_FILE('\uE226'),
  ATTACH_MONEY('\uE227'),
  AUDIOTRACK('\uE3A1'),
  AUTORENEW('\uE863'),
  AV_TIMER('\uE01B'),
  BACKSPACE('\uE14A'),
  BACKUP('\uE864'),
  BATTERY_ALERT('\uE19C'),
  BATTERY_CHARGING_FULL('\uE1A3'),
  BATTERY_FULL('\uE1A4'),
  BATTERY_STD('\uE1A5'),
  BATTERY_UNKNOWN('\uE1A6'),
  BEACH_ACCESS('\uEB3E'),
  BEENHERE('\uE52D'),
  BLOCK('\uE14B'),
  BLUETOOTH('\uE1A7'),
  BLUETOOTH_AUDIO('\uE60F'),
  BLUETOOTH_CONNECTED('\uE1A8'),
  BLUETOOTH_DISABLED('\uE1A9'),
  BLUETOOTH_SEARCHING('\uE1AA'),
  BLUR_CIRCULAR('\uE3A2'),
  BLUR_LINEAR('\uE3A3'),
  BLUR_OFF('\uE3A4'),
  BLUR_ON('\uE3A5'),
  BOOK('\uE865'),
  BOOKMARK('\uE866'),
  BOOKMARK_BORDER('\uE867'),
  BORDER_ALL('\uE228'),
  BORDER_BOTTOM('\uE229'),
  BORDER_CLEAR('\uE22A'),
  BORDER_COLOR('\uE22B'),
  BORDER_HORIZONTAL('\uE22C'),
  BORDER_INNER('\uE22D'),
  BORDER_LEFT('\uE22E'),
  BORDER_OUTER('\uE22F'),
  BORDER_RIGHT('\uE230'),
  BORDER_STYLE('\uE231'),
  BORDER_TOP('\uE232'),
  BORDER_VERTICAL('\uE233'),
  BRANDING_WATERMARK('\uE06B'),
  BRIGHTNESS_1('\uE3A6'),
  BRIGHTNESS_2('\uE3A7'),
  BRIGHTNESS_3('\uE3A8'),
  BRIGHTNESS_4('\uE3A9'),
  BRIGHTNESS_5('\uE3AA'),
  BRIGHTNESS_6('\uE3AB'),
  BRIGHTNESS_7('\uE3AC'),
  BRIGHTNESS_AUTO('\uE1AB'),
  BRIGHTNESS_HIGH('\uE1AC'),
  BRIGHTNESS_LOW('\uE1AD'),
  BRIGHTNESS_MEDIUM('\uE1AE'),
  BROKEN_IMAGE('\uE3AD'),
  BRUSH('\uE3AE'),
  BUBBLE_CHART('\uE6DD'),
  BUG_REPORT('\uE868'),
  BUILD('\uE869'),
  BURST_MODE('\uE43C'),
  BUSINESS('\uE0AF'),
  BUSINESS_CENTER('\uEB3F'),
  CACHED('\uE86A'),
  CAKE('\uE7E9'),
  CALL('\uE0B0'),
  CALL_END('\uE0B1'),
  CALL_MADE('\uE0B2'),
  CALL_MERGE('\uE0B3'),
  CALL_MISSED('\uE0B4'),
  CALL_MISSED_OUTGOING('\uE0E4'),
  CALL_RECEIVED('\uE0B5'),
  CALL_SPLIT('\uE0B6'),
  CALL_TO_ACTION('\uE06C'),
  CAMERA('\uE3AF'),
  CAMERA_ALT('\uE3B0'),
  CAMERA_ENHANCE('\uE8FC'),
  CAMERA_FRONT('\uE3B1'),
  CAMERA_REAR('\uE3B2'),
  CAMERA_ROLL('\uE3B3'),
  CANCEL('\uE5C9'),
  CARD_GIFTCARD('\uE8F6'),
  CARD_MEMBERSHIP('\uE8F7'),
  CARD_TRAVEL('\uE8F8'),
  CASINO('\uEB40'),
  CAST('\uE307'),
  CAST_CONNECTED('\uE308'),
  CENTER_FOCUS_STRONG('\uE3B4'),
  CENTER_FOCUS_WEAK('\uE3B5'),
  CHANGE_HISTORY('\uE86B'),
  CHAT('\uE0B7'),
  CHAT_BUBBLE('\uE0CA'),
  CHAT_BUBBLE_OUTLINE('\uE0CB'),
  CHECK('\uE5CA'),
  CHECK_BOX('\uE834'),
  CHECK_BOX_OUTLINE_BLANK('\uE835'),
  CHECK_CIRCLE('\uE86C'),
  CHEVRON_LEFT('\uE5CB'),
  CHEVRON_RIGHT('\uE5CC'),
  CHILD_CARE('\uEB41'),
  CHILD_FRIENDLY('\uEB42'),
  CHROME_READER_MODE('\uE86D'),
  CLASS('\uE86E'),
  CLEAR('\uE14C'),
  CLEAR_ALL('\uE0B8'),
  CLOSE('\uE5CD'),
  CLOSED_CAPTION('\uE01C'),
  CLOUD('\uE2BD'),
  CLOUD_CIRCLE('\uE2BE'),
  CLOUD_DONE('\uE2BF'),
  CLOUD_DOWNLOAD('\uE2C0'),
  CLOUD_OFF('\uE2C1'),
  CLOUD_QUEUE('\uE2C2'),
  CLOUD_UPLOAD('\uE2C3'),
  CODE('\uE86F'),
  COLLECTIONS('\uE3B6'),
  COLLECTIONS_BOOKMARK('\uE431'),
  COLORIZE('\uE3B8'),
  COLOR_LENS('\uE3B7'),
  COMMENT('\uE0B9'),
  COMPARE('\uE3B9'),
  COMPARE_ARROWS('\uE915'),
  COMPUTER('\uE30A'),
  CONFIRMATION_NUMBER('\uE638'),
  CONTACTS('\uE0BA'),
  CONTACT_MAIL('\uE0D0'),
  CONTACT_PHONE('\uE0CF'),
  CONTENT_COPY('\uE14D'),
  CONTENT_CUT('\uE14E'),
  CONTENT_PASTE('\uE14F'),
  CONTROL_POINT('\uE3BA'),
  CONTROL_POINT_DUPLICATE('\uE3BB'),
  COPYRIGHT('\uE90C'),
  CREATE('\uE150'),
  CREATE_NEW_FOLDER('\uE2CC'),
  CREDIT_CARD('\uE870'),
  CROP('\uE3BE'),
  CROP_16_9('\uE3BC'),
  CROP_3_2('\uE3BD'),
  CROP_5_4('\uE3BF'),
  CROP_7_5('\uE3C0'),
  CROP_DIN('\uE3C1'),
  CROP_FREE('\uE3C2'),
  CROP_LANDSCAPE('\uE3C3'),
  CROP_ORIGINAL('\uE3C4'),
  CROP_PORTRAIT('\uE3C5'),
  CROP_ROTATE('\uE437'),
  CROP_SQUARE('\uE3C6'),
  DASHBOARD('\uE871'),
  DATA_USAGE('\uE1AF'),
  DATE_RANGE('\uE916'),
  DEHAZE('\uE3C7'),
  DELETE('\uE872'),
  DELETE_FOREVER('\uE92B'),
  DELETE_SWEEP('\uE16C'),
  DESCRIPTION('\uE873'),
  DESKTOP_MAC('\uE30B'),
  DESKTOP_WINDOWS('\uE30C'),
  DETAILS('\uE3C8'),
  DEVELOPER_BOARD('\uE30D'),
  DEVELOPER_MODE('\uE1B0'),
  DEVICES('\uE1B1'),
  DEVICES_OTHER('\uE337'),
  DEVICE_HUB('\uE335'),
  DIALER_SIP('\uE0BB'),
  DIALPAD('\uE0BC'),
  DIRECTIONS('\uE52E'),
  DIRECTIONS_BIKE('\uE52F'),
  DIRECTIONS_BOAT('\uE532'),
  DIRECTIONS_BUS('\uE530'),
  DIRECTIONS_CAR('\uE531'),
  DIRECTIONS_RAILWAY('\uE534'),
  DIRECTIONS_RUN('\uE566'),
  DIRECTIONS_SUBWAY('\uE533'),
  DIRECTIONS_TRANSIT('\uE535'),
  DIRECTIONS_WALK('\uE536'),
  DISC_FULL('\uE610'),
  DNS('\uE875'),
  DOCK('\uE30E'),
  DOMAIN('\uE7EE'),
  DONE('\uE876'),
  DONE_ALL('\uE877'),
  DONUT_LARGE('\uE917'),
  DONUT_SMALL('\uE918'),
  DO_NOT_DISTURB('\uE612'),
  DO_NOT_DISTURB_ALT('\uE611'),
  DO_NOT_DISTURB_OFF('\uE643'),
  DO_NOT_DISTURB_ON('\uE644'),
  DRAFTS('\uE151'),
  DRAG_HANDLE('\uE25D'),
  DRIVE_ETA('\uE613'),
  DVR('\uE1B2'),
  EDIT('\uE3C9'),
  EDIT_LOCATION('\uE568'),
  EJECT('\uE8FB'),
  EMAIL('\uE0BE'),
  ENHANCED_ENCRYPTION('\uE63F'),
  EQUALIZER('\uE01D'),
  ERROR('\uE000'),
  ERROR_OUTLINE('\uE001'),
  EURO_SYMBOL('\uE926'),
  EVENT('\uE878'),
  EVENT_AVAILABLE('\uE614'),
  EVENT_BUSY('\uE615'),
  EVENT_NOTE('\uE616'),
  EVENT_SEAT('\uE903'),
  EV_STATION('\uE56D'),
  EXIT_TO_APP('\uE879'),
  EXPAND_LESS('\uE5CE'),
  EXPAND_MORE('\uE5CF'),
  EXPLICIT('\uE01E'),
  EXPLORE('\uE87A'),
  EXPOSURE('\uE3CA'),
  EXPOSURE_NEG_1('\uE3CB'),
  EXPOSURE_NEG_2('\uE3CC'),
  EXPOSURE_PLUS_1('\uE3CD'),
  EXPOSURE_PLUS_2('\uE3CE'),
  EXPOSURE_ZERO('\uE3CF'),
  EXTENSION('\uE87B'),
  FACE('\uE87C'),
  FAST_FORWARD('\uE01F'),
  FAST_REWIND('\uE020'),
  FAVORITE('\uE87D'),
  FAVORITE_BORDER('\uE87E'),
  FEATURED_PLAY_LIST('\uE06D'),
  FEATURED_VIDEO('\uE06E'),
  FEEDBACK('\uE87F'),
  FIBER_DVR('\uE05D'),
  FIBER_MANUAL_RECORD('\uE061'),
  FIBER_NEW('\uE05E'),
  FIBER_PIN('\uE06A'),
  FIBER_SMART_RECORD('\uE062'),
  FILE_DOWNLOAD('\uE2C4'),
  FILE_UPLOAD('\uE2C6'),
  FILTER('\uE3D3'),
  FILTER_1('\uE3D0'),
  FILTER_2('\uE3D1'),
  FILTER_3('\uE3D2'),
  FILTER_4('\uE3D4'),
  FILTER_5('\uE3D5'),
  FILTER_6('\uE3D6'),
  FILTER_7('\uE3D7'),
  FILTER_8('\uE3D8'),
  FILTER_9('\uE3D9'),
  FILTER_9_PLUS('\uE3DA'),
  FILTER_B_AND_W('\uE3DB'),
  FILTER_CENTER_FOCUS('\uE3DC'),
  FILTER_DRAMA('\uE3DD'),
  FILTER_FRAMES('\uE3DE'),
  FILTER_HDR('\uE3DF'),
  FILTER_LIST('\uE152'),
  FILTER_NONE('\uE3E0'),
  FILTER_TILT_SHIFT('\uE3E2'),
  FILTER_VINTAGE('\uE3E3'),
  FIND_IN_PAGE('\uE880'),
  FIND_REPLACE('\uE881'),
  FINGERPRINT('\uE90D'),
  FIRST_PAGE('\uE5DC'),
  FITNESS_CENTER('\uEB43'),
  FLAG('\uE153'),
  FLARE('\uE3E4'),
  FLASH_AUTO('\uE3E5'),
  FLASH_OFF('\uE3E6'),
  FLASH_ON('\uE3E7'),
  FLIGHT('\uE539'),
  FLIGHT_LAND('\uE904'),
  FLIGHT_TAKEOFF('\uE905'),
  FLIP('\uE3E8'),
  FLIP_TO_BACK('\uE882'),
  FLIP_TO_FRONT('\uE883'),
  FOLDER('\uE2C7'),
  FOLDER_OPEN('\uE2C8'),
  FOLDER_SHARED('\uE2C9'),
  FOLDER_SPECIAL('\uE617'),
  FONT_DOWNLOAD('\uE167'),
  FORMAT_ALIGN_CENTER('\uE234'),
  FORMAT_ALIGN_JUSTIFY('\uE235'),
  FORMAT_ALIGN_LEFT('\uE236'),
  FORMAT_ALIGN_RIGHT('\uE237'),
  FORMAT_BOLD('\uE238'),
  FORMAT_CLEAR('\uE239'),
  FORMAT_COLOR_FILL('\uE23A'),
  FORMAT_COLOR_RESET('\uE23B'),
  FORMAT_COLOR_TEXT('\uE23C'),
  FORMAT_INDENT_DECREASE('\uE23D'),
  FORMAT_INDENT_INCREASE('\uE23E'),
  FORMAT_ITALIC('\uE23F'),
  FORMAT_LINE_SPACING('\uE240'),
  FORMAT_LIST_BULLETED('\uE241'),
  FORMAT_LIST_NUMBERED('\uE242'),
  FORMAT_PAINT('\uE243'),
  FORMAT_QUOTE('\uE244'),
  FORMAT_SHAPES('\uE25E'),
  FORMAT_SIZE('\uE245'),
  FORMAT_STRIKETHROUGH('\uE246'),
  FORMAT_TEXTDIRECTION_L_TO_R('\uE247'),
  FORMAT_TEXTDIRECTION_R_TO_L('\uE248'),
  FORMAT_UNDERLINED('\uE249'),
  FORUM('\uE0BF'),
  FORWARD('\uE154'),
  FORWARD_10('\uE056'),
  FORWARD_30('\uE057'),
  FORWARD_5('\uE058'),
  FREE_BREAKFAST('\uEB44'),
  FULLSCREEN('\uE5D0'),
  FULLSCREEN_EXIT('\uE5D1'),
  FUNCTIONS('\uE24A'),
  GAMEPAD('\uE30F'),
  GAMES('\uE021'),
  GAVEL('\uE90E'),
  GESTURE('\uE155'),
  GET_APP('\uE884'),
  GIF('\uE908'),
  GOLF_COURSE('\uEB45'),
  GPS_FIXED('\uE1B3'),
  GPS_NOT_FIXED('\uE1B4'),
  GPS_OFF('\uE1B5'),
  GRADE('\uE885'),
  GRADIENT('\uE3E9'),
  GRAIN('\uE3EA'),
  GRAPHIC_EQ('\uE1B8'),
  GRID_OFF('\uE3EB'),
  GRID_ON('\uE3EC'),
  GROUP('\uE7EF'),
  GROUP_ADD('\uE7F0'),
  GROUP_WORK('\uE886'),
  G_3D_ROTATION('\uE84D'),
  G_TRANSLATE('\uE927'),
  HD('\uE052'),
  HDR_OFF('\uE3ED'),
  HDR_ON('\uE3EE'),
  HDR_STRONG('\uE3F1'),
  HDR_WEAK('\uE3F2'),
  HEADSET('\uE310'),
  HEADSET_MIC('\uE311'),
  HEALING('\uE3F3'),
  HEARING('\uE023'),
  HELP('\uE887'),
  HELP_OUTLINE('\uE8FD'),
  HIGHLIGHT('\uE25F'),
  HIGHLIGHT_OFF('\uE888'),
  HIGH_QUALITY('\uE024'),
  HISTORY('\uE889'),
  HOME('\uE88A'),
  HOTEL('\uE53A'),
  HOT_TUB('\uEB46'),
  HOURGLASS_EMPTY('\uE88B'),
  HOURGLASS_FULL('\uE88C'),
  HTTP('\uE902'),
  HTTPS('\uE88D'),
  IMAGE('\uE3F4'),
  IMAGE_ASPECT_RATIO('\uE3F5'),
  IMPORTANT_DEVICES('\uE912'),
  IMPORT_CONTACTS('\uE0E0'),
  IMPORT_EXPORT('\uE0C3'),
  INBOX('\uE156'),
  INDETERMINATE_CHECK_BOX('\uE909'),
  INFO('\uE88E'),
  INFO_OUTLINE('\uE88F'),
  INPUT('\uE890'),
  INSERT_CHART('\uE24B'),
  INSERT_COMMENT('\uE24C'),
  INSERT_DRIVE_FILE('\uE24D'),
  INSERT_EMOTICON('\uE24E'),
  INSERT_INVITATION('\uE24F'),
  INSERT_LINK('\uE250'),
  INSERT_PHOTO('\uE251'),
  INVERT_COLORS('\uE891'),
  INVERT_COLORS_OFF('\uE0C4'),
  ISO('\uE3F6'),
  KEYBOARD('\uE312'),
  KEYBOARD_ARROW_DOWN('\uE313'),
  KEYBOARD_ARROW_LEFT('\uE314'),
  KEYBOARD_ARROW_RIGHT('\uE315'),
  KEYBOARD_ARROW_UP('\uE316'),
  KEYBOARD_BACKSPACE('\uE317'),
  KEYBOARD_CAPSLOCK('\uE318'),
  KEYBOARD_HIDE('\uE31A'),
  KEYBOARD_RETURN('\uE31B'),
  KEYBOARD_TAB('\uE31C'),
  KEYBOARD_VOICE('\uE31D'),
  KITCHEN('\uEB47'),
  LABEL('\uE892'),
  LABEL_OUTLINE('\uE893'),
  LANDSCAPE('\uE3F7'),
  LANGUAGE('\uE894'),
  LAPTOP('\uE31E'),
  LAPTOP_CHROMEBOOK('\uE31F'),
  LAPTOP_MAC('\uE320'),
  LAPTOP_WINDOWS('\uE321'),
  LAST_PAGE('\uE5DD'),
  LAUNCH('\uE895'),
  LAYERS('\uE53B'),
  LAYERS_CLEAR('\uE53C'),
  LEAK_ADD('\uE3F8'),
  LEAK_REMOVE('\uE3F9'),
  LENS('\uE3FA'),
  LIBRARY_ADD('\uE02E'),
  LIBRARY_BOOKS('\uE02F'),
  LIBRARY_MUSIC('\uE030'),
  LIGHTBULB_OUTLINE('\uE90F'),
  LINEAR_SCALE('\uE260'),
  LINE_STYLE('\uE919'),
  LINE_WEIGHT('\uE91A'),
  LINK('\uE157'),
  LINKED_CAMERA('\uE438'),
  LIST('\uE896'),
  LIVE_HELP('\uE0C6'),
  LIVE_TV('\uE639'),
  LOCAL_ACTIVITY('\uE53F'),
  LOCAL_AIRPORT('\uE53D'),
  LOCAL_ATM('\uE53E'),
  LOCAL_BAR('\uE540'),
  LOCAL_CAFE('\uE541'),
  LOCAL_CAR_WASH('\uE542'),
  LOCAL_CONVENIENCE_STORE('\uE543'),
  LOCAL_DINING('\uE556'),
  LOCAL_DRINK('\uE544'),
  LOCAL_FLORIST('\uE545'),
  LOCAL_GAS_STATION('\uE546'),
  LOCAL_GROCERY_STORE('\uE547'),
  LOCAL_HOSPITAL('\uE548'),
  LOCAL_HOTEL('\uE549'),
  LOCAL_LAUNDRY_SERVICE('\uE54A'),
  LOCAL_LIBRARY('\uE54B'),
  LOCAL_MALL('\uE54C'),
  LOCAL_MOVIES('\uE54D'),
  LOCAL_OFFER('\uE54E'),
  LOCAL_PARKING('\uE54F'),
  LOCAL_PHARMACY('\uE550'),
  LOCAL_PHONE('\uE551'),
  LOCAL_PIZZA('\uE552'),
  LOCAL_PLAY('\uE553'),
  LOCAL_POST_OFFICE('\uE554'),
  LOCAL_PRINTSHOP('\uE555'),
  LOCAL_SEE('\uE557'),
  LOCAL_SHIPPING('\uE558'),
  LOCAL_TAXI('\uE559'),
  LOCATION_CITY('\uE7F1'),
  LOCATION_DISABLED('\uE1B6'),
  LOCATION_OFF('\uE0C7'),
  LOCATION_ON('\uE0C8'),
  LOCATION_SEARCHING('\uE1B7'),
  LOCK('\uE897'),
  LOCK_OPEN('\uE898'),
  LOCK_OUTLINE('\uE899'),
  LOOKS('\uE3FC'),
  LOOKS_3('\uE3FB'),
  LOOKS_4('\uE3FD'),
  LOOKS_5('\uE3FE'),
  LOOKS_6('\uE3FF'),
  LOOKS_ONE('\uE400'),
  LOOKS_TWO('\uE401'),
  LOOP('\uE028'),
  LOUPE('\uE402'),
  LOW_PRIORITY('\uE16D'),
  LOYALTY('\uE89A'),
  MAIL('\uE158'),
  MAIL_OUTLINE('\uE0E1'),
  MAP('\uE55B'),
  MARKUNREAD('\uE159'),
  MARKUNREAD_MAILBOX('\uE89B'),
  MEMORY('\uE322'),
  MENU('\uE5D2'),
  MERGE_TYPE('\uE252'),
  MESSAGE('\uE0C9'),
  MIC('\uE029'),
  MIC_NONE('\uE02A'),
  MIC_OFF('\uE02B'),
  MMS('\uE618'),
  MODE_COMMENT('\uE253'),
  MODE_EDIT('\uE254'),
  MONETIZATION_ON('\uE263'),
  MONEY_OFF('\uE25C'),
  MONOCHROME_PHOTOS('\uE403'),
  MOOD('\uE7F2'),
  MOOD_BAD('\uE7F3'),
  MORE('\uE619'),
  MORE_HORIZ('\uE5D3'),
  MORE_VERT('\uE5D4'),
  MOTORCYCLE('\uE91B'),
  MOUSE('\uE323'),
  MOVE_TO_INBOX('\uE168'),
  MOVIE('\uE02C'),
  MOVIE_CREATION('\uE404'),
  MOVIE_FILTER('\uE43A'),
  MULTILINE_CHART('\uE6DF'),
  MUSIC_NOTE('\uE405'),
  MUSIC_VIDEO('\uE063'),
  MY_LOCATION('\uE55C'),
  NATURE('\uE406'),
  NATURE_PEOPLE('\uE407'),
  NAVIGATE_BEFORE('\uE408'),
  NAVIGATE_NEXT('\uE409'),
  NAVIGATION('\uE55D'),
  NEAR_ME('\uE569'),
  NETWORK_CELL('\uE1B9'),
  NETWORK_CHECK('\uE640'),
  NETWORK_LOCKED('\uE61A'),
  NETWORK_WIFI('\uE1BA'),
  NEW_RELEASES('\uE031'),
  NEXT_WEEK('\uE16A'),
  NFC('\uE1BB'),
  NOTE('\uE06F'),
  NOTE_ADD('\uE89C'),
  NOTIFICATIONS('\uE7F4'),
  NOTIFICATIONS_ACTIVE('\uE7F7'),
  NOTIFICATIONS_NONE('\uE7F5'),
  NOTIFICATIONS_OFF('\uE7F6'),
  NOTIFICATIONS_PAUSED('\uE7F8'),
  NOT_INTERESTED('\uE033'),
  NO_ENCRYPTION('\uE641'),
  NO_SIM('\uE0CC'),
  OFFLINE_PIN('\uE90A'),
  ONDEMAND_VIDEO('\uE63A'),
  OPACITY('\uE91C'),
  OPEN_IN_BROWSER('\uE89D'),
  OPEN_IN_NEW('\uE89E'),
  OPEN_WITH('\uE89F'),
  PAGES('\uE7F9'),
  PAGEVIEW('\uE8A0'),
  PALETTE('\uE40A'),
  PANORAMA('\uE40B'),
  PANORAMA_FISH_EYE('\uE40C'),
  PANORAMA_HORIZONTAL('\uE40D'),
  PANORAMA_VERTICAL('\uE40E'),
  PANORAMA_WIDE_ANGLE('\uE40F'),
  PAN_TOOL('\uE925'),
  PARTY_MODE('\uE7FA'),
  PAUSE('\uE034'),
  PAUSE_CIRCLE_FILLED('\uE035'),
  PAUSE_CIRCLE_OUTLINE('\uE036'),
  PAYMENT('\uE8A1'),
  PEOPLE('\uE7FB'),
  PEOPLE_OUTLINE('\uE7FC'),
  PERM_CAMERA_MIC('\uE8A2'),
  PERM_CONTACT_CALENDAR('\uE8A3'),
  PERM_DATA_SETTING('\uE8A4'),
  PERM_DEVICE_INFORMATION('\uE8A5'),
  PERM_IDENTITY('\uE8A6'),
  PERM_MEDIA('\uE8A7'),
  PERM_PHONE_MSG('\uE8A8'),
  PERM_SCAN_WIFI('\uE8A9'),
  PERSON('\uE7FD'),
  PERSONAL_VIDEO('\uE63B'),
  PERSON_ADD('\uE7FE'),
  PERSON_OUTLINE('\uE7FF'),
  PERSON_PIN('\uE55A'),
  PERSON_PIN_CIRCLE('\uE56A'),
  PETS('\uE91D'),
  PHONE('\uE0CD'),
  PHONELINK('\uE326'),
  PHONELINK_ERASE('\uE0DB'),
  PHONELINK_LOCK('\uE0DC'),
  PHONELINK_OFF('\uE327'),
  PHONELINK_RING('\uE0DD'),
  PHONELINK_SETUP('\uE0DE'),
  PHONE_ANDROID('\uE324'),
  PHONE_BLUETOOTH_SPEAKER('\uE61B'),
  PHONE_FORWARDED('\uE61C'),
  PHONE_IN_TALK('\uE61D'),
  PHONE_IPHONE('\uE325'),
  PHONE_LOCKED('\uE61E'),
  PHONE_MISSED('\uE61F'),
  PHONE_PAUSED('\uE620'),
  PHOTO('\uE410'),
  PHOTO_ALBUM('\uE411'),
  PHOTO_CAMERA('\uE412'),
  PHOTO_FILTER('\uE43B'),
  PHOTO_LIBRARY('\uE413'),
  PHOTO_SIZE_SELECT_ACTUAL('\uE432'),
  PHOTO_SIZE_SELECT_LARGE('\uE433'),
  PHOTO_SIZE_SELECT_SMALL('\uE434'),
  PICTURE_AS_PDF('\uE415'),
  PICTURE_IN_PICTURE('\uE8AA'),
  PICTURE_IN_PICTURE_ALT('\uE911'),
  PIE_CHART('\uE6C4'),
  PIE_CHART_OUTLINED('\uE6C5'),
  PIN_DROP('\uE55E'),
  PLACE('\uE55F'),
  PLAYLIST_ADD('\uE03B'),
  PLAYLIST_ADD_CHECK('\uE065'),
  PLAYLIST_PLAY('\uE05F'),
  PLAY_ARROW('\uE037'),
  PLAY_CIRCLE_FILLED('\uE038'),
  PLAY_CIRCLE_OUTLINE('\uE039'),
  PLAY_FOR_WORK('\uE906'),
  PLUS_ONE('\uE800'),
  POLL('\uE801'),
  POLYMER('\uE8AB'),
  POOL('\uEB48'),
  PORTABLE_WIFI_OFF('\uE0CE'),
  PORTRAIT('\uE416'),
  POWER('\uE63C'),
  POWER_INPUT('\uE336'),
  POWER_SETTINGS_NEW('\uE8AC'),
  PREGNANT_WOMAN('\uE91E'),
  PRESENT_TO_ALL('\uE0DF'),
  PRINT('\uE8AD'),
  PRIORITY_HIGH('\uE645'),
  PUBLIC('\uE80B'),
  PUBLISH('\uE255'),
  QUERY_BUILDER('\uE8AE'),
  QUESTION_ANSWER('\uE8AF'),
  QUEUE('\uE03C'),
  QUEUE_MUSIC('\uE03D'),
  QUEUE_PLAY_NEXT('\uE066'),
  RADIO('\uE03E'),
  RADIO_BUTTON_CHECKED('\uE837'),
  RADIO_BUTTON_UNCHECKED('\uE836'),
  RATE_REVIEW('\uE560'),
  RECEIPT('\uE8B0'),
  RECENT_ACTORS('\uE03F'),
  RECORD_VOICE_OVER('\uE91F'),
  REDEEM('\uE8B1'),
  REDO('\uE15A'),
  REFRESH('\uE5D5'),
  REMOVE('\uE15B'),
  REMOVE_CIRCLE('\uE15C'),
  REMOVE_CIRCLE_OUTLINE('\uE15D'),
  REMOVE_FROM_QUEUE('\uE067'),
  REMOVE_RED_EYE('\uE417'),
  REMOVE_SHOPPING_CART('\uE928'),
  REORDER('\uE8FE'),
  REPEAT('\uE040'),
  REPEAT_ONE('\uE041'),
  REPLAY('\uE042'),
  REPLAY_10('\uE059'),
  REPLAY_30('\uE05A'),
  REPLAY_5('\uE05B'),
  REPLY('\uE15E'),
  REPLY_ALL('\uE15F'),
  REPORT('\uE160'),
  REPORT_PROBLEM('\uE8B2'),
  RESTAURANT('\uE56C'),
  RESTAURANT_MENU('\uE561'),
  RESTORE('\uE8B3'),
  RESTORE_PAGE('\uE929'),
  RING_VOLUME('\uE0D1'),
  ROOM('\uE8B4'),
  ROOM_SERVICE('\uEB49'),
  ROTATE_90_DEGREES_CCW('\uE418'),
  ROTATE_LEFT('\uE419'),
  ROTATE_RIGHT('\uE41A'),
  ROUNDED_CORNER('\uE920'),
  ROUTER('\uE328'),
  ROWING('\uE921'),
  RSS_FEED('\uE0E5'),
  RV_HOOKUP('\uE642'),
  SATELLITE('\uE562'),
  SAVE('\uE161'),
  SCANNER('\uE329'),
  SCHEDULE('\uE8B5'),
  SCHOOL('\uE80C'),
  SCREEN_LOCK_LANDSCAPE('\uE1BE'),
  SCREEN_LOCK_PORTRAIT('\uE1BF'),
  SCREEN_LOCK_ROTATION('\uE1C0'),
  SCREEN_ROTATION('\uE1C1'),
  SCREEN_SHARE('\uE0E2'),
  SD_CARD('\uE623'),
  SD_STORAGE('\uE1C2'),
  SEARCH('\uE8B6'),
  SECURITY('\uE32A'),
  SELECT_ALL('\uE162'),
  SEND('\uE163'),
  SENTIMENT_DISSATISFIED('\uE811'),
  SENTIMENT_NEUTRAL('\uE812'),
  SENTIMENT_SATISFIED('\uE813'),
  SENTIMENT_VERY_DISSATISFIED('\uE814'),
  SENTIMENT_VERY_SATISFIED('\uE815'),
  SETTINGS('\uE8B8'),
  SETTINGS_APPLICATIONS('\uE8B9'),
  SETTINGS_BACKUP_RESTORE('\uE8BA'),
  SETTINGS_BLUETOOTH('\uE8BB'),
  SETTINGS_BRIGHTNESS('\uE8BD'),
  SETTINGS_CELL('\uE8BC'),
  SETTINGS_ETHERNET('\uE8BE'),
  SETTINGS_INPUT_ANTENNA('\uE8BF'),
  SETTINGS_INPUT_COMPONENT('\uE8C0'),
  SETTINGS_INPUT_COMPOSITE('\uE8C1'),
  SETTINGS_INPUT_HDMI('\uE8C2'),
  SETTINGS_INPUT_SVIDEO('\uE8C3'),
  SETTINGS_OVERSCAN('\uE8C4'),
  SETTINGS_PHONE('\uE8C5'),
  SETTINGS_POWER('\uE8C6'),
  SETTINGS_REMOTE('\uE8C7'),
  SETTINGS_SYSTEM_DAYDREAM('\uE1C3'),
  SETTINGS_VOICE('\uE8C8'),
  SHARE('\uE80D'),
  SHOP('\uE8C9'),
  SHOPPING_BASKET('\uE8CB'),
  SHOPPING_CART('\uE8CC'),
  SHOP_TWO('\uE8CA'),
  SHORT_TEXT('\uE261'),
  SHOW_CHART('\uE6E1'),
  SHUFFLE('\uE043'),
  SIGNAL_CELLULAR_4_BAR('\uE1C8'),
  SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_4_BAR('\uE1CD'),
  SIGNAL_CELLULAR_NO_SIM('\uE1CE'),
  SIGNAL_CELLULAR_NULL('\uE1CF'),
  SIGNAL_CELLULAR_OFF('\uE1D0'),
  SIGNAL_WIFI_4_BAR('\uE1D8'),
  SIGNAL_WIFI_4_BAR_LOCK('\uE1D9'),
  SIGNAL_WIFI_OFF('\uE1DA'),
  SIM_CARD('\uE32B'),
  SIM_CARD_ALERT('\uE624'),
  SKIP_NEXT('\uE044'),
  SKIP_PREVIOUS('\uE045'),
  SLIDESHOW('\uE41B'),
  SLOW_MOTION_VIDEO('\uE068'),
  SMARTPHONE('\uE32C'),
  SMOKE_FREE('\uEB4A'),
  SMOKING_ROOMS('\uEB4B'),
  SMS('\uE625'),
  SMS_FAILED('\uE626'),
  SNOOZE('\uE046'),
  SORT('\uE164'),
  SORT_BY_ALPHA('\uE053'),
  SPA('\uEB4C'),
  SPACE_BAR('\uE256'),
  SPEAKER('\uE32D'),
  SPEAKER_GROUP('\uE32E'),
  SPEAKER_NOTES('\uE8CD'),
  SPEAKER_NOTES_OFF('\uE92A'),
  SPEAKER_PHONE('\uE0D2'),
  SPELLCHECK('\uE8CE'),
  STAR('\uE838'),
  STARS('\uE8D0'),
  STAR_BORDER('\uE83A'),
  STAR_HALF('\uE839'),
  STAY_CURRENT_LANDSCAPE('\uE0D3'),
  STAY_CURRENT_PORTRAIT('\uE0D4'),
  STAY_PRIMARY_LANDSCAPE('\uE0D5'),
  STAY_PRIMARY_PORTRAIT('\uE0D6'),
  STOP('\uE047'),
  STOP_SCREEN_SHARE('\uE0E3'),
  STORAGE('\uE1DB'),
  STORE('\uE8D1'),
  STORE_MALL_DIRECTORY('\uE563'),
  STRAIGHTEN('\uE41C'),
  STREETVIEW('\uE56E'),
  STRIKETHROUGH_S('\uE257'),
  STYLE('\uE41D'),
  SUBDIRECTORY_ARROW_LEFT('\uE5D9'),
  SUBDIRECTORY_ARROW_RIGHT('\uE5DA'),
  SUBJECT('\uE8D2'),
  SUBSCRIPTIONS('\uE064'),
  SUBTITLES('\uE048'),
  SUBWAY('\uE56F'),
  SUPERVISOR_ACCOUNT('\uE8D3'),
  SURROUND_SOUND('\uE049'),
  SWAP_CALLS('\uE0D7'),
  SWAP_HORIZ('\uE8D4'),
  SWAP_VERT('\uE8D5'),
  SWAP_VERTICAL_CIRCLE('\uE8D6'),
  SWITCH_CAMERA('\uE41E'),
  SWITCH_VIDEO('\uE41F'),
  SYNC('\uE627'),
  SYNC_DISABLED('\uE628'),
  SYNC_PROBLEM('\uE629'),
  SYSTEM_UPDATE('\uE62A'),
  SYSTEM_UPDATE_ALT('\uE8D7'),
  TAB('\uE8D8'),
  TABLET('\uE32F'),
  TABLET_ANDROID('\uE330'),
  TABLET_MAC('\uE331'),
  TAB_UNSELECTED('\uE8D9'),
  TAG_FACES('\uE420'),
  TAP_AND_PLAY('\uE62B'),
  TERRAIN('\uE564'),
  TEXTSMS('\uE0D8'),
  TEXTURE('\uE421'),
  TEXT_FIELDS('\uE262'),
  TEXT_FORMAT('\uE165'),
  THEATERS('\uE8DA'),
  THUMBS_UP_DOWN('\uE8DD'),
  THUMB_DOWN('\uE8DB'),
  THUMB_UP('\uE8DC'),
  TIMELAPSE('\uE422'),
  TIMELINE('\uE922'),
  TIMER('\uE425'),
  TIMER_10('\uE423'),
  TIMER_3('\uE424'),
  TIMER_OFF('\uE426'),
  TIME_TO_LEAVE('\uE62C'),
  TITLE('\uE264'),
  TOC('\uE8DE'),
  TODAY('\uE8DF'),
  TOLL('\uE8E0'),
  TONALITY('\uE427'),
  TOUCH_APP('\uE913'),
  TOYS('\uE332'),
  TRACK_CHANGES('\uE8E1'),
  TRAFFIC('\uE565'),
  TRAIN('\uE570'),
  TRAM('\uE571'),
  TRANSFER_WITHIN_A_STATION('\uE572'),
  TRANSFORM('\uE428'),
  TRANSLATE('\uE8E2'),
  TRENDING_DOWN('\uE8E3'),
  TRENDING_FLAT('\uE8E4'),
  TRENDING_UP('\uE8E5'),
  TUNE('\uE429'),
  TURNED_IN('\uE8E6'),
  TURNED_IN_NOT('\uE8E7'),
  TV('\uE333'),
  UNARCHIVE('\uE169'),
  UNDO('\uE166'),
  UNFOLD_LESS('\uE5D6'),
  UNFOLD_MORE('\uE5D7'),
  UPDATE('\uE923'),
  USB('\uE1E0'),
  VERIFIED_USER('\uE8E8'),
  VERTICAL_ALIGN_BOTTOM('\uE258'),
  VERTICAL_ALIGN_CENTER('\uE259'),
  VERTICAL_ALIGN_TOP('\uE25A'),
  VIBRATION('\uE62D'),
  VIDEOCAM('\uE04B'),
  VIDEOCAM_OFF('\uE04C'),
  VIDEOGAME_ASSET('\uE338'),
  VIDEO_CALL('\uE070'),
  VIDEO_LABEL('\uE071'),
  VIDEO_LIBRARY('\uE04A'),
  VIEW_AGENDA('\uE8E9'),
  VIEW_ARRAY('\uE8EA'),
  VIEW_CAROUSEL('\uE8EB'),
  VIEW_COLUMN('\uE8EC'),
  VIEW_COMFY('\uE42A'),
  VIEW_COMPACT('\uE42B'),
  VIEW_DAY('\uE8ED'),
  VIEW_HEADLINE('\uE8EE'),
  VIEW_LIST('\uE8EF'),
  VIEW_MODULE('\uE8F0'),
  VIEW_QUILT('\uE8F1'),
  VIEW_STREAM('\uE8F2'),
  VIEW_WEEK('\uE8F3'),
  VIGNETTE('\uE435'),
  VISIBILITY('\uE8F4'),
  VISIBILITY_OFF('\uE8F5'),
  VOICEMAIL('\uE0D9'),
  VOICE_CHAT('\uE62E'),
  VOLUME_DOWN('\uE04D'),
  VOLUME_MUTE('\uE04E'),
  VOLUME_OFF('\uE04F'),
  VOLUME_UP('\uE050'),
  VPN_KEY('\uE0DA'),
  VPN_LOCK('\uE62F'),
  WALLPAPER('\uE1BC'),
  WARNING('\uE002'),
  WATCH('\uE334'),
  WATCH_LATER('\uE924'),
  WB_AUTO('\uE42C'),
  WB_CLOUDY('\uE42D'),
  WB_INCANDESCENT('\uE42E'),
  WB_IRIDESCENT('\uE436'),
  WB_SUNNY('\uE430'),
  WC('\uE63D'),
  WEB('\uE051'),
  WEB_ASSET('\uE069'),
  WEEKEND('\uE16B'),
  WHATSHOT('\uE80E'),
  WIDGETS('\uE1BD'),
  WIFI('\uE63E'),
  WIFI_LOCK('\uE1E1'),
  WIFI_TETHERING('\uE1E2'),
  WORK('\uE8F9'),
  WRAP_TEXT('\uE25B'),
  YOUTUBE_SEARCHED_FOR('\uE8FA'),
  ZOOM_IN('\uE8FF'),
  ZOOM_OUT('\uE900'),
  ZOOM_OUT_MAP('\uE56B');

  private final char character;

  GoogleMaterialDesignIcons(char character) {
    this.character = character;
  }

  @Override
  public char getUnicode() {
    return character;
  }

  @Override
  public String getFontFamily() {
    return "Material Icons";
  }

  public static IconFont getIconFont() {
    return new IconFont() {
      @Override
      public String getFontFamily() {
        return "Material Icons";
      }

      @Override
      public InputStream getFontInputStream() {
        return GoogleMaterialDesignIcons.class.getResourceAsStream("/fonts/google_material_design_icons/MaterialIcons-Regular.ttf");
      }
    };
  }
}
