/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.virtual;

import java.util.ArrayList;
import java.util.Comparator;
import org.apache.commons.jexl3.JexlExpression;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.ui.IHelpContextIdProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.editors.object.struct.BaseObjectEditPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class EditVirtualAttributePage
extends BaseObjectEditPage
implements IHelpContextIdProvider {
    private final ResultSetViewer viewer;
    private final DBVEntityAttribute vAttr;
    private Text nameText;
    private Combo typeCombo;
    private Combo kindCombo;
    private Text expressionText;
    private Text previewText;

    public EditVirtualAttributePage(ResultSetViewer viewer, DBVEntityAttribute vAttr) {
        super("Add virtual column", DBIcon.TREE_COLUMN);
        this.viewer = viewer;
        this.vAttr = vAttr;
    }

    protected Control createPageContents(Composite parent) {
        DBVEntityAttribute vAttr2;
        Composite dialogArea = UIUtils.createComposite((Composite)parent, (int)1);
        dialogArea.setLayoutData((Object)new GridData(1808));
        DBPDataSource dataSource = this.vAttr.getEntity().getDataSource();
        Composite panel = UIUtils.createComposite((Composite)dialogArea, (int)2);
        panel.setLayoutData((Object)new GridData(1808));
        String name = this.vAttr.getName();
        int index = 1;
        while ((vAttr2 = this.vAttr.getEntity().getVirtualAttribute(name)) != null && vAttr2 != this.vAttr) {
            name = String.valueOf(this.vAttr.getName()) + ++index;
        }
        this.nameText = UIUtils.createLabelText((Composite)panel, (String)"Column Name", (String)name);
        this.typeCombo = UIUtils.createLabelCombo((Composite)panel, (String)"Type Name", (String)"Column type name", (int)2052);
        DBPDataTypeProvider dataTypeProvider = (DBPDataTypeProvider)DBUtils.getAdapter(DBPDataTypeProvider.class, (Object)dataSource);
        if (dataTypeProvider != null) {
            ArrayList<DBSDataType> localDataTypes = new ArrayList<DBSDataType>(dataTypeProvider.getLocalDataTypes());
            localDataTypes.sort(Comparator.comparing(DBSTypedObject::getFullTypeName));
            for (DBSDataType dataType : localDataTypes) {
                this.typeCombo.add(dataType.getFullTypeName());
            }
            String defTypeName = this.vAttr.getTypeName();
            if (CommonUtils.isEmpty((String)defTypeName)) {
                defTypeName = dataTypeProvider.getDefaultDataTypeName(DBPDataKind.STRING);
                this.vAttr.setTypeName(defTypeName);
                DBSDataType dataType = dataTypeProvider.getLocalDataType(defTypeName);
                if (dataType != null) {
                    this.vAttr.setDataKind(dataType.getDataKind());
                }
            }
            if (!CommonUtils.isEmpty((String)defTypeName)) {
                this.typeCombo.setText(defTypeName);
            }
            this.typeCombo.addModifyListener(e -> {
                DBSDataType dataType = dataTypeProvider.getLocalDataType(this.typeCombo.getText());
                if (dataType != null) {
                    this.kindCombo.setText(dataType.getDataKind().name());
                }
            });
        } else {
            this.typeCombo.setText(CommonUtils.notEmpty((String)this.vAttr.getTypeName()));
        }
        ContentAssistUtils.installContentProposal((Control)this.typeCombo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider(this.typeCombo.getItems()));
        this.kindCombo = UIUtils.createLabelCombo((Composite)panel, (String)"Data Kind", (String)"Column data kind", (int)2060);
        DBPDataKind[] dBPDataKindArray = DBPDataKind.values();
        int defTypeName = dBPDataKindArray.length;
        int localDataTypes = 0;
        while (localDataTypes < defTypeName) {
            DBPDataKind dataKind = dBPDataKindArray[localDataTypes];
            if (dataKind != DBPDataKind.UNKNOWN) {
                this.kindCombo.add(dataKind.name());
            }
            ++localDataTypes;
        }
        this.kindCombo.setText(this.vAttr.getDataKind().name());
        this.expressionText = UIUtils.createLabelText((Composite)panel, (String)"Expression", (String)CommonUtils.notEmpty((String)this.vAttr.getExpression()), (int)2626);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = this.expressionText.getLineHeight() * 5;
        this.expressionText.setLayoutData((Object)gd);
        ArrayList<String> expressionProposals = new ArrayList<String>();
        if (this.viewer != null) {
            DBDAttributeBinding[] dBDAttributeBindingArray = this.viewer.getModel().getAttributes();
            int n = dBDAttributeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
                expressionProposals.add(attr.getLabel());
                ++n2;
            }
        }
        ContentAssistUtils.installContentProposal((Control)this.expressionText, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider(expressionProposals.toArray(new String[0])));
        this.previewText = UIUtils.createLabelText((Composite)panel, (String)"Preview", (String)"", (int)2056);
        this.previewText.setLayoutData((Object)new GridData(768));
        this.expressionText.addModifyListener(e -> this.generatePreviewValue());
        this.generatePreviewValue();
        return dialogArea;
    }

    private void generatePreviewValue() {
        if (this.viewer == null) {
            return;
        }
        String expression = this.expressionText.getText();
        ResultSetRow currentRow = this.viewer.getCurrentRow();
        if (currentRow == null) {
            this.previewText.setText("Select a row in data viewer to see expression results");
            return;
        }
        try {
            JexlExpression parsedExpression = DBVUtils.parseExpression((String)expression);
            Object result = DBVUtils.evaluateDataExpression((DBDAttributeBinding[])this.viewer.getModel().getAttributes(), (Object[])currentRow.values, (JexlExpression)parsedExpression, (String)this.nameText.getText());
            this.previewText.setText(CommonUtils.toString((Object)result));
        }
        catch (Exception e) {
            this.previewText.setText(GeneralUtils.getExpressionParseMessage((Exception)e));
        }
    }

    public void performFinish() throws DBException {
        this.vAttr.setName(this.nameText.getText());
        this.vAttr.setTypeName(this.typeCombo.getText());
        this.vAttr.setDataKind((DBPDataKind)CommonUtils.valueOf(DBPDataKind.class, (String)this.kindCombo.getText(), (Enum)DBPDataKind.STRING));
        this.vAttr.setExpression(this.expressionText.getText());
        super.performFinish();
    }

    public String getHelpContextId() {
        return "virtual-column-expressions";
    }
}

