/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreDataSourceProvider;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreBackupWizard;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreRestoreWizard;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreScriptExecuteWizard;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigurator;
import org.jkiss.dbeaver.tasks.ui.nativetool.NativeToolConfigPanel;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;

public class PostgreTaskConfigurator
implements DBTTaskConfigurator {
    private static final Log log = Log.getLog(PostgreTaskConfigurator.class);

    public ConfigPanel createInputConfigurator(DBRRunnableContext runnableContext, @NotNull DBTTaskType taskType) {
        return new ConfigPanel(runnableContext, taskType);
    }

    public TaskConfigurationWizard createTaskConfigWizard(@NotNull DBTTask taskConfiguration) {
        switch (taskConfiguration.getType().getId()) {
            case "pgDatabaseBackup": {
                return new PostgreBackupWizard(taskConfiguration);
            }
            case "pgDatabaseRestore": {
                return new PostgreRestoreWizard(taskConfiguration);
            }
            case "pgScriptExecute": {
                return new PostgreScriptExecuteWizard(taskConfiguration);
            }
        }
        return null;
    }

    private static class ConfigPanel
    extends NativeToolConfigPanel<PostgreDatabase> {
        ConfigPanel(DBRRunnableContext runnableContext, DBTTaskType taskType) {
            super(runnableContext, taskType, PostgreDatabase.class, PostgreDataSourceProvider.class);
        }
    }
}

