/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.policy;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.ui.command.AssociationCreateCommand;
import org.jkiss.dbeaver.erd.ui.command.AssociationReconnectSourceCommand;
import org.jkiss.dbeaver.erd.ui.command.AssociationReconnectTargetCommand;
import org.jkiss.dbeaver.erd.ui.part.NodePart;

public class EntityConnectionEditPolicy
extends GraphicalNodeEditPolicy {
    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        AssociationCreateCommand cmd = this.makeCreateCommand();
        NodePart part = (NodePart)this.getHost();
        cmd.setSourceEntity(part.getElement());
        request.setStartCommand((Command)cmd);
        return cmd;
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        AssociationCreateCommand cmd = (AssociationCreateCommand)request.getStartCommand();
        NodePart part = (NodePart)request.getTargetEditPart();
        cmd.setTargetEntity(part.getElement());
        return cmd;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        AssociationReconnectSourceCommand cmd = this.makeReconnectSourceCommand();
        cmd.setAssociation((ERDAssociation)request.getConnectionEditPart().getModel());
        NodePart entityPart = (NodePart)this.getHost();
        cmd.setSourceEntity(entityPart.getElement());
        return cmd;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        AssociationReconnectTargetCommand cmd = this.makeReconnectTargetCommand();
        cmd.setRelationship((ERDAssociation)request.getConnectionEditPart().getModel());
        NodePart entityPart = (NodePart)this.getHost();
        cmd.setTargetEntity(entityPart.getElement());
        return cmd;
    }

    protected AssociationCreateCommand makeCreateCommand() {
        return new AssociationCreateCommand();
    }

    protected AssociationReconnectSourceCommand makeReconnectSourceCommand() {
        return new AssociationReconnectSourceCommand();
    }

    protected AssociationReconnectTargetCommand makeReconnectTargetCommand() {
        return new AssociationReconnectTargetCommand();
    }
}

