/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class TeamCapabilityHelper {
    private Map<String, IPluginContribution> providerIdToPluginId = new HashMap<String, IPluginContribution>();
    private static TeamCapabilityHelper singleton;

    public static TeamCapabilityHelper getInstance() {
        if (singleton == null) {
            singleton = new TeamCapabilityHelper();
        }
        return singleton;
    }

    private TeamCapabilityHelper() {
        this.loadRepositoryProviderIds();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                this.processProject(project, workbenchActivitySupport);
            }
            catch (CoreException coreException) {}
            ++n2;
        }
    }

    public void loadRepositoryProviderIds() {
        this.providerIdToPluginId.clear();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.team.core.repository");
        if (point != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = point.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    String id;
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    final String pluginId = extension.getNamespace();
                    if (element.getName().equals("repository") && (id = element.getAttribute("id")) != null) {
                        this.providerIdToPluginId.put(id, new IPluginContribution(){

                            public String getLocalId() {
                                return id;
                            }

                            public String getPluginId() {
                                return pluginId;
                            }
                        });
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    protected void processProject(IProject project, IWorkbenchActivitySupport workbenchActivitySupport) throws CoreException {
        if (!project.isOpen()) {
            return;
        }
        String id = this.getProviderIdFor(project);
        this.processRepositoryId(id, workbenchActivitySupport);
    }

    public void processRepositoryId(String id, IWorkbenchActivitySupport workbenchActivitySupport) {
        if (id == null) {
            return;
        }
        IActivityManager activityManager = workbenchActivitySupport.getActivityManager();
        HashSet activities = new HashSet(activityManager.getEnabledActivityIds());
        boolean changed = false;
        IPluginContribution contribution = this.providerIdToPluginId.get(id);
        if (contribution == null) {
            return;
        }
        IIdentifier identifier = activityManager.getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)contribution));
        if (activities.addAll(identifier.getActivityIds())) {
            changed = true;
        }
        if (changed) {
            workbenchActivitySupport.setEnabledActivityIds(activities);
        }
    }

    public String getProviderIdFor(IProject project) throws CoreException {
        if (project.isAccessible()) {
            Object prop = project.getSessionProperty(TeamPlugin.PROVIDER_PROP_KEY);
            if (prop != null && prop instanceof RepositoryProvider) {
                RepositoryProvider provider = (RepositoryProvider)prop;
                return provider.getID();
            }
            return project.getPersistentProperty(TeamPlugin.PROVIDER_PROP_KEY);
        }
        return null;
    }
}

