We're proud to announce the new feature release of darktable, 4.2.0!

The github release is here: [https://github.com/darktable-org/darktable/releases/tag/release-4.2.0](https://github.com/darktable-org/darktable/releases/tag/release-4.2.0).

As always, please don't use the autogenerated tarball provided by
github, but only our tar.xz file. The checksums are:

```
$ sha256sum darktable-4.2.0.tar.xz
??? darktable-4.2.0.tar.xz
$ sha256sum darktable-4.2.0.dmg
??? darktable-4.2.0.dmg
$ sha256sum darktable-4.2.0.exe
??? darktable-4.2.0.exe
```

When updating from the stable 4.0.x series, please bear in
mind that your edits will be preserved during this process, but the new
library and configuration will no longer be usable with 4.0.x.

You are strongly advised to take a backup first.

#### Important note: to make sure that darktable can keep on supporting the raw file format for your camera, *please* read [this post](https://discuss.pixls.us/t/raw-samples-wanted/5420?u=lebedevri) on how/what raw samples you can contribute to ensure that we have the *full* raw sample set for your camera under CC0 license!

Since darktable 4.0:

- Almost 1408 commits to darktable+rawspeed
- 408 pull requests handled
- 59 issues closed

## The Big Ones

The following is a summary of the main features added to darktable
4.2. Most of these features are described more fully in the user manual.

- New Sigmoid display transform module, which can be used in place of
  the filmic and base curve modules.

- Two new algorithms are provided in the highlight reconstruction module:
  "inpaint opposed" and "segmentation based". The "inpaint opposed"
  algorithm has proved to be very stable and provides good results in
  many images, so it replaces "clip highlights" as the new default algorithm.

- The pixelpipe used for image display in the darkroom view has been reworked
  so that it can be used elsewhere (darkroom view, second display window,
  duplicate manager, style preview, snapshot routine). This has allowed
  for code de-duplication as well as enhancement of many of these features
  (see below).

- The second darkroom image window has now been enhanced to support both
  the focus peaking and ISO-12646 color assessment modes.

- The snapshot module has been entirely reworked so that, instead of using a
  fixed screen capture it now uses a dynamically generated view using the new
  pixelpipe functionality. This means that it can now be zoomed and panned
  with keyboard/mouse.

- The duplicate manager previously used a different pipe routine to calculate
  its previews (i.e. when long-pressing on a duplicate image thumbnail) which
  often meant that the displayed duplicates differed from the main darkroom
  view in subtle ways. Use of the new pipe routine now means that these previews
  will be identical to those produced during darkroom editing.

- It is now possible to preview the effect of a user-generated style on
  an image before applying it. Simply hover over the style name in either
  the lighttable styles module or the darkroom quick-access menu and a
  new tooltip will appear, showing the image with the style applied along
  with details of the modules that are included.

- Some cameras record lens correction information within the image EXIF metadata.
  The lens correction module has been enhanced so that it can extract this data
  and use it to correct lens distortions.

- darktable is now able to read and write JPEG XL images

- Processing and utility modules have been altered so that if a module is
  not entirely visible when expanded, it will be automatically scrolled
  until the entire UI is visible on screen.

  For users who currently use the "scroll to the top when expanded" preference
  setting to achieve this effect, this change may provide a better alternative.

  As part of this change, a new animation effect has been added when
  expanding/collapsing modules. The speed of the expand/collapse animation
  can be controlled via a preference setting
  (`preferences > miscellaneous > duration of ui transitions`).
  Set this to zero to disable the animation.

- The pixelpipe caching functionality has been completely overhauled. More
  cachelines are used with an improved hit-rate while controlling
  the total amount of memory used, leading to a significantly faster
  interface.

- The slideshow has been rewritten for a better user experience.
  A small preview is displayed while the full image is computed
  to provide feedback to the user that something is being done in
  the background.

- A new drop-down menu has been added to the top filter bar to allow
  filters to be easily added and removed. Some range widgets have been
  removed from this list as they are not easily readable on the top bar.

- The UI of the range rating filter widget has been reworked for better
  readability. This revised widget is designed to be easier to use
  and more efficient.

## Other Changes

- Added support for manipulating shapes without using the mouse scroll-wheel
  (for tablet users). The mask manager has been enhanced with a new collapsible
  section containing controls for changing shapes properties.

  It is also possible to change a property that is shared by a group of shapes.

  The circle and ellipse shapes have also been enhanced with new on-canvas
  controls to change the mask size and feathering.

- WebP read support has been added.

- Embedded ICC profiles are now supported in exported WebP files.

- Double-clicking on a notebook tab now resets all widgets within that tab.

- Regional date/time format is now supported in thumbnail tooltips.

- Lua commands are displayed in a widget's "action" tooltip.

- The SSE code path has been removed from the white balance and
  output color profile modules as compiler defaults now provide a
  similar speed.

- Added support for JFIF (JPEG File Interchange Format) file extension
  (which is an extension of the JPEG standard).

- The preference to auto-apply a sharpening has been removed. For users
  who still require this functionality, it can be easily achieved with a
  user-generated auto-applied preset.

- Added support for updating existing pictures in Piwigo export.

- All white balance presets have been migrated to an external JSON file.
  This should not affect the module's operation.

- The preferences to set the layout of the "color balance module" and the
  colors of the "white balance" module have been removed from the global
  preferences dialog, as these controls are already available directly within
  the respective modules.

- Improved profile support for AVIF & EXR format. Also relax AVIF
  reader support by not requiring full compliance.

- The current collection image count is now shown in the top bar beside
  the image filters meaning that it is available even when the top hinter
  area is hidden.

- Attempt to obtain the color-space for PNG files from the cICP chunk. This was
  added in a recent revision of the PNG spec, so we take advantage of
  it, if present.

- Reading of 16-bit half float for the TIFF format is now undertaken using
  the Imath library.

- The format and storage parameters in the export module can now be mapped
  to shortcuts.

- Introduced balanced "OpenCL vs CPU" tiling. This makes it possible to
  use CPU tiling if there is not enough memory on the OpenCL card
  (which would require a lot of tiles to be handled on the card). In the
  end, the large number of tiles plus the overlapping area would make
  the use of the OpenCL code path slower (or much slower) than
  handling the image without tiling on the CPU.

- In preview mode (when pressing <kbd>Ctrl+w</kbd>) the image information overlay
  display block is no longer shown by default. Moving the cursor within the top
  half of the preview image will cause the overlay to appear, and it will then
  disappear again after a brief period.

- Light patterns are set for Behringer b-control midi rotors
  (BCR2000/BCF2000)

- Fixed reading of EXIF metadata when importing EXR files (if desired,
  existing files must be re-imported, as it is not possible to refresh
  metadata).

- Added support for scrolling through a module's presets using shortcuts.

- Panels now use "natural sizes" by default, meaning that their initial
  size adjusts according to screen resolution.

- The geo-tagging module now better supports narrow side-panels by
  wrapping rather than ellipsizing text.

- More actions have been added to the main help screen (displayed by
  pressing the <kbd>h</kbd> key).

- The lensfun library is now a mandatory dependency. This ensures
  that all darktable builds correctly include the lens correction module.
  This also means that an edit made using this module won't be inadvertently
  lost due to missing build dependencies.

- It is now possible to assign shortcuts to the "currently focused" processing module.
  This allows a common set of shortcuts to be created and reused in multiple
  modules simply by focusing that module. For example a single key shortcut
  applied to the "first slider" will affect the "exposure" slider when the
  exposure module is focused, and the "rotation" slider when the "rotate and
  perspective" module is focused. Similar functionality can be used to affect
  the "nth" slider, combobox, button or tab as well as the focused module
  itself.

- Right-clicking on a module header in the quick access panel now allows
  more widgets from the same module to be quickly added. The tooltip and
  icon show whether those widgets are currently hidden in the full module.

## Bug Fixes

- Properly use the display color profile in the slideshow view. This was
  missing, meaning that images were ignoring the color profile and were
  displayed (very) differently than in the lighttable or darkroom views.

- Properly honor a module's on/off status in a style. This means that styles
  can now be used in the export module to disable a module otherwise
  enabled in the history stack.

- Fix bauhaus popup size and position.

- Fix the name of the "iop order" on reset.

- Do not display deprecated module actions in the shortcuts section of
  the global preferences dialog.

- Fix the positioning of some bauhaus widgets on Wayland.

- Fix performance issue when importing large folders where XMPs contain
  a lot of metadata.

- Fix some missing GUI updates in the liquify module. In some cases,
  changing the strength of a node in a curve or line was not properly
  updating the displacement values.

- Fix bad interaction between the color assessment mode and the side
  panels.

- Fix infinity focus display in the image information module.

- Fix translation of retouch module toast messages.

- When importing images, retain the currently selected folder/filmroll mode
  in the collections module if one of these modes is currently active.
  If another collection mode was active the import switches back
  to filmroll mode (as before).

- Fix Lab conversion in TIFF import.

- Fix highlights visualization in all recovery modes.

- Fix X-Trans highlight reconstruction visual indicator.

- Fix undo/redo after a style is applied via a shortcut.

- Do not rebuild the whole tree when deleting or editing a
  preset in preferences. This provides better UI stability.

- Fix broken refresh of the mask manager when changing images.

- Fix mask selection after continuous mask creation.

- Fix name and tooltip in demosaic preferences so it is correct for all
  types of sensor.

- Remove the automatic check for OpenCL headroom - it was causing
  more problems than it solved.

- Fix non-blinking cursor in the darkroom module search bar. This
  was making the search bar look as if it was inactive.

- Properly record the libraw black level.

- Fix the state of some UI buttons in the retouch module when switching images.

- Fix selection of unaltered images.

- Fix keyboard shortcuts so that they can be applied to widgets in a
  collapsed section of a module.

- Fix typo preventing proper variable expansion `$(FOLDER.PICTURES)`.

- Fix PNM loader (could display broken images and always used wrong colors).

- Fix drawing color picker area at the edge of images so that the editing
  action is no longer lost when the mouse goes outside the edge.

- An old bug in the cache handling has been fixed. This could have
  caused a missing display refresh after parameter changes and even some
  crashes while in the darkroom view.

- Fix some toggle buttons whose UI state was not properly updated.

- Fix check of temperature coefficients for displaying the selected
  presets.

- Fix fast-pipe support in some modules for the second display window.

- In the quick access panel, parameters are now hidden if they are also hidden
  in the full module (for those parameters that conditionally display based on
  the state of other parameters). This even works if those parameters are
  changed from another widget in the quick access panel.

- Slightly improve the blue color label for better visibility in the
  dark theme.

- Fix navigation window zoom indicator label display. It was sometimes
  cut on the right or bottom or displaced within the window.

## Lua

- API version changed to 9.0.0

- `darktable.gui.libs.filter.sort|sort order|rating|rating` comparator
  functions removed

- filename removed from `dt_lua_snapshot_t data` type

- `darktable.gui.libs.snapshot` now updates the screen after changing
  direction or rotation

- lua snapshot datatype correctly retrieves snapshot name

## Notes

- With the support of JXL, AVIF and EXR for export, selecting specific
  metadata (eg. geo tag, creator) is not currently possible. For
  formats JXL, AVIF and EXR, darktable will not include the metadata
  fields unless the user selects all of the checkboxes in the export
  preference options.

## Changed Dependencies

N/A

## RawSpeed changes


## Camera support, compared to 4.0

### Base Support

- Canon EOS M2
- Fujifilm FinePix HS50EXR
- Fujifilm FinePix S6000fd
- Fujifilm X-H2 (compressed)
- Fujifilm X-H2S (compressed)
- Fujifilm X-T30 II (compressed)
- Fujifilm X-T5 (compressed)
- Leica D-LUX 6 (4:3, 3:2, 16:9, 1:1)
- Leica M Monochrom (Typ 246) (dng)
- Nikon 1 J4 (12bit-compressed)
- Nikon 1 S1 (12bit-compressed)
- Nikon Coolpix P7700 (12bit-compressed)
- Nikon D1H (12bit-uncompressed)
- Nikon D2H (12bit-compressed, 12bit-uncompressed)
- Nikon D3S (14bit-compressed, 14bit-uncompressed, 12bit-compressed, 12bit-uncompressed)
- Nikon Z 9 (14bit-compressed)
- Olympus E-10
- Olympus E-M10 Mark IIIs
- Olympus E-P7
- Olympus SP570UZ
- Panasonic DMC-G2 (4:3, 3:2, 16:9, 1:1)
- Pentax K2000
- Pentax K200D
- Ricoh GR II
- Samsung NX mini
- Samsung NX10
- Samsung NX11
- Samsung NX20
- Samsung NX2000
- Samsung NX5
- Sony DSLR-A380
- Sony DSLR-A560
- Sony ILCE-7RM5

### White Balance Presets

   No data for this release.

### Noise Profiles

- Fujifilm X-E4
- Fujifilm X-T5
- Leica M (Typ 240)
- Nikon Z 9
- Olympus E-500
- Panasonic DMC-FZ330

### Missing Compression Mode Support

- Fujifilm "non-lossless"/lossy
- Nikon HE
- Sony lossless

### Suspended Support

No samples on raw.pixls.us

- Canon EOS M2
- Creo/Leaf Aptus 22(LF3779)/Hasselblad H1
- Fujifilm FinePix HS50EXR
- Fujifilm FinePix S6000fd
- Fujifilm FinePix S9600fd
- Fujifilm IS-1
- GoPro FUSION
- Kodak EasyShare Z980
- Leaf Aptus-II 5(LI300059)/Mamiya 645 AFD
- Leaf Credo 60
- Leaf Credo 80
- Leica D-LUX 6
- Minolta DiMAGE 5
- Nikon 1 J4
- Nikon 1 S1
- Nikon Coolpix P7700
- Nikon D1H
- Nikon D2H
- Nikon D3S
- Olympus E-10
- Olympus SP320
- Olympus SP570UZ
- Panasonic DMC-FX150
- Panasonic DMC-G2
- Pentax K200D
- Pentax K2000
- Pentax Q10
- Phase One IQ250
- Samsung GX10
- Samsung GX20
- Samsung NX5
- Samsung NX10
- Samsung NX11
- Samsung NX20
- Samsung NX2000
- Samsung EK-GN120
- Samsung SM-G920F
- Samsung SM-G935F
- Sinar Hy6/ Sinarback eXact
- Sony DSLR-A380
- Sony DSLR-A560
- ST Micro STV680

## Translations

- German
- European Spanish
- Finnish
- French
- Hungarian
- Italian
- Japanese
- Dutch
- Polish
- Brazilian Portuguese
- Russian
- Slovenian
- Albanian
- Turkish (New)
- Ukrainian
- Chinese - Taiwan
