/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.eventsbymonths;

import ancestris.core.TextOptions;
import ancestris.reports.utils.PropUtils;
import genj.chart.Chart;
import genj.chart.IndexedSeries;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.TagPath;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.option.Multiline;
import genj.report.Report;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.IntStream;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ReportEventsByMonths
extends Report {
    private static final String[] EVENTS = (String[])PropUtils.getEventNames().toArray(String[]::new);
    @Multiline
    public int[] eventSelector = IntStream.range(0, EVENTS.length).toArray();
    public String[] eventSelectors = EVENTS;
    public int inferiorYearLimit = 0;
    public int superiorYearLimit = 2100;
    private int calendar;
    public static final Calendar[] CALENDARS = new Calendar[]{PointInTime.GREGORIAN, PointInTime.FRENCHR, PointInTime.JULIAN, PointInTime.HEBREW};

    public int getCalendar() {
        return this.calendar;
    }

    public void setCalendar(int set) {
        this.calendar = Math.max(0, Math.min(CALENDARS.length - 1, set));
    }

    public Calendar[] getCalendars() {
        return CALENDARS;
    }

    public Object start(Indi[] indis) {
        return this.start(indis[0].getGedcom());
    }

    public Object start(Gedcom gedcom) {
        HashMap<CallSite, String> labels = new HashMap<CallSite, String>();
        String[] entityTags = new String[]{"INDI", "FAM"};
        String[] selectedTags = (String[])PropUtils.getTag2NameMap().keySet().toArray(String[]::new);
        ArrayList<IndexedSeries> series = new ArrayList<IndexedSeries>();
        for (int index : this.eventSelector) {
            for (String entityTag : entityTags) {
                String tag = selectedTags[index];
                IndexedSeries tmpSeries = this.analyze(gedcom.getEntities(entityTag), entityTag + ":" + tag);
                if (tmpSeries == null) continue;
                series.add(tmpSeries);
                labels.put((CallSite)((Object)(entityTag + ":" + tag)), this.getLabel(gedcom, entityTag, tag, true));
            }
        }
        String[] categories = CALENDARS[this.calendar].getMonths(false);
        for (int i = 0; i < categories.length; ++i) {
            categories[i] = CALENDARS[this.calendar].getDisplayMonthLocalized(i, false, TextOptions.getInstance().getOutputLocale());
        }
        JTabbedPane charts = new JTabbedPane();
        for (IndexedSeries is : series) {
            String path = is.getName();
            int index = path.indexOf(".");
            String label = (String)labels.get(path);
            String title = "chart.title";
            if (label == null || index > 0) {
                path = path.substring(0, index);
                label = (String)labels.get(path);
                title = "chart.title.none";
            }
            Chart chart = new Chart(this.translate(title, new Object[]{label, Integer.toString(this.inferiorYearLimit), Integer.toString(this.superiorYearLimit)}), is, categories, false);
            charts.addTab(Gedcom.getName((String)new TagPath(path).getLast()), (Component)chart);
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("Center", charts);
        return panel;
    }

    private IndexedSeries analyze(Collection<? extends Entity> entities, String path) {
        int months = CALENDARS[this.calendar].getMonths(true).length;
        IndexedSeries series = new IndexedSeries(path, months);
        boolean empty = true;
        boolean noMonth = true;
        for (Entity entity : entities) {
            PropertyDate date;
            Property event = entity.getPropertyByPath(path);
            if (event == null || (date = event.getWhen()) == null) continue;
            try {
                if (date.getStart().getPointInTime(CALENDARS[this.calendar]).getYear() < this.inferiorYearLimit || date.getStart().getPointInTime(CALENDARS[this.calendar]).getYear() > this.superiorYearLimit) continue;
                int month = date.getStart().getPointInTime(CALENDARS[this.calendar]).getMonth();
                if (month >= 0 && month < months) {
                    series.inc(month);
                    noMonth = false;
                }
                empty = false;
            }
            catch (GedcomException gedcomException) {}
        }
        if (noMonth) {
            series.setName(path + ".none");
        }
        return empty ? null : series;
    }

    private String getLabel(Gedcom gedcom, String entityTag, String tag, boolean plural) {
        Grammar grammar = gedcom.getGrammar();
        String otherEntityTag = entityTag.equals("INDI") ? "FAM" : "INDI";
        MetaProperty meta = grammar.getMeta(new TagPath(otherEntityTag));
        return Gedcom.getName((String)tag, (boolean)plural) + (String)(meta.allows(tag) ? " (" + Gedcom.getName((String)entityTag) + ")" : "");
    }
}

