/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import ancestris.gedcom.privacy.PrivacyPolicy;
import genj.gedcom.Entity;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.openide.util.NbBundle;

public class FilterOptions {
    public boolean reportFilterName = false;
    public boolean reportFilterLine = false;
    public String strFilterInclude = "";
    public String strFilterExclude = "";
    public boolean reportFilterPrivate = false;
    public boolean reportFilterDead = false;
    private PrivacyPolicy policy = PrivacyPolicy.getDefault();

    public boolean matchRecord(Property property, String name, String text) {
        boolean excluded;
        boolean included;
        Pattern patternIn = Pattern.compile(this.strFilterInclude, 2);
        Pattern patternEx = Pattern.compile(this.strFilterExclude, 2);
        if (this.reportFilterName) {
            included = this.strFilterInclude.isBlank() || patternIn.matcher(name).find();
            boolean bl = excluded = !this.strFilterExclude.isBlank() && patternEx.matcher(name).find();
            if (!included || excluded) {
                return false;
            }
        }
        if (this.reportFilterLine) {
            included = this.strFilterInclude.isBlank() || patternIn.matcher(text).find();
            boolean bl = excluded = !this.strFilterExclude.isBlank() && patternEx.matcher(text).find();
            if (!included || excluded) {
                return false;
            }
        }
        if (property != null && this.reportFilterPrivate && this.policy.isPrivate(property)) {
            return false;
        }
        return property == null || !this.reportFilterDead || !this.isDead(property);
    }

    public boolean isFilterOn() {
        return this.reportFilterName || this.reportFilterLine || this.reportFilterPrivate || this.reportFilterDead;
    }

    public String getMainMessage() {
        return NbBundle.getMessage(FilterOptions.class, (String)"filterLabel");
    }

    public List<String[]> getMessages() {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        if (this.reportFilterName) {
            ret.add(this.getInclExclMessage("reportFilterName"));
        }
        if (this.reportFilterLine) {
            ret.add(this.getInclExclMessage("reportFilterLine"));
        }
        if (this.reportFilterPrivate) {
            ret.add(new String[]{NbBundle.getMessage(FilterOptions.class, (String)"reportFilterPrivate"), ""});
        }
        if (this.reportFilterDead) {
            ret.add(new String[]{NbBundle.getMessage(FilterOptions.class, (String)"reportFilterDead"), ""});
        }
        return ret;
    }

    private boolean isDead(Property property) {
        Entity entity = property.getEntity();
        if (entity instanceof Indi) {
            Indi indi = (Indi)entity;
            return indi.isDeceased();
        }
        return false;
    }

    private String[] getInclExclMessage(String filtername) {
        if (!this.strFilterInclude.isBlank() && !this.strFilterExclude.isBlank()) {
            return new String[]{NbBundle.getMessage(FilterOptions.class, (String)filtername), NbBundle.getMessage(FilterOptions.class, (String)"reportFilterInclExcl", (Object)this.strFilterInclude, (Object)this.strFilterExclude)};
        }
        if (!this.strFilterInclude.isBlank()) {
            return new String[]{NbBundle.getMessage(FilterOptions.class, (String)filtername), NbBundle.getMessage(FilterOptions.class, (String)"reportFilterIncl", (Object)this.strFilterInclude)};
        }
        if (!this.strFilterExclude.isBlank()) {
            return new String[]{NbBundle.getMessage(FilterOptions.class, (String)filtername), NbBundle.getMessage(FilterOptions.class, (String)"reportFilterExcl", (Object)this.strFilterExclude)};
        }
        return new String[]{NbBundle.getMessage(FilterOptions.class, (String)filtername), NbBundle.getMessage(FilterOptions.class, (String)"reportFilterInclExclNone")};
    }
}

