/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.utils;

import ancestris.modules.releve.utils.Java2sAutoTextField;
import java.awt.Color;
import java.awt.Insets;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class Java2sAutoComboBox
extends JComboBox<String> {
    private final AutoTextFieldEditor autoTextFieldEditor;

    public Java2sAutoComboBox(List<String> stringList) {
        this.autoTextFieldEditor = new AutoTextFieldEditor(stringList, this);
        this.overideNimbus(this);
        this.setEditable(true);
        this.setModel(new StringListModel(stringList));
        this.setEditor(this.autoTextFieldEditor);
        this.setPrototypeDisplayValue("AAAAAAAAAAA");
    }

    private void overideNimbus(JComboBox<String> component) {
        UIDefaults def;
        if ("javax.swing.plaf.nimbus.NimbusLookAndFeel".equals(UIManager.getSystemLookAndFeelClassName())) {
            def = new UIDefaults();
            def.put("ComboBox.padding", new Insets(0, 0, 0, 0));
            def.put("ComboBox.foreground", Color.RED);
            component.putClientProperty("Nimbus.Overrides", def);
        }
        if ("com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(UIManager.getSystemLookAndFeelClassName())) {
            def = new UIDefaults();
            def.put("ComboBox.padding", new Insets(0, 0, 0, 0));
            def.put("ComboBox.foreground", Color.RED);
            component.putClientProperty("Nimbus.Overrides", def);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.autoTextFieldEditor.getAutoTextFieldEditor().addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.autoTextFieldEditor.getAutoTextFieldEditor().removeChangeListener(l);
    }

    public boolean isCaseSensitive() {
        return this.autoTextFieldEditor.getAutoTextFieldEditor().isCaseSensitive();
    }

    public boolean isStrict() {
        return this.autoTextFieldEditor.getAutoTextFieldEditor().isStrict();
    }

    public void setCaseSensitive(boolean flag) {
        this.autoTextFieldEditor.getAutoTextFieldEditor().setCaseSensitive(flag);
    }

    public void setUpperAllFirstChar(boolean flag) {
        this.autoTextFieldEditor.getAutoTextFieldEditor().setUpperAllFirstChar(flag);
    }

    public void setUpperAllChar(boolean flag) {
        this.autoTextFieldEditor.getAutoTextFieldEditor().setUpperAllChar(flag);
    }

    public void setStrict(boolean flag) {
        this.autoTextFieldEditor.getAutoTextFieldEditor().setStrict(flag);
    }

    protected void setSelectedValue(Object obj) {
        this.setSelectedItem(obj);
    }

    private static class AutoTextFieldEditor
    extends BasicComboBoxEditor {
        private Java2sAutoTextField getAutoTextFieldEditor() {
            return (Java2sAutoTextField)this.editor;
        }

        AutoTextFieldEditor(List<String> list, Java2sAutoComboBox comboBox) {
            this.editor = new Java2sAutoTextField(list, comboBox);
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject == null) {
                this.editor.setText("");
            } else {
                this.editor.setText(anObject.toString());
            }
        }
    }

    static class StringListModel
    extends DefaultComboBoxModel<String> {
        private final List<String> strings;

        public StringListModel(List<String> stringList) {
            this.strings = stringList;
        }

        public String getSelectedString() {
            return (String)this.getSelectedItem();
        }

        @Override
        public String getElementAt(int index) {
            return this.strings.get(index);
        }

        @Override
        public int getSize() {
            return this.strings.size();
        }

        @Override
        public int getIndexOf(Object element) {
            return this.strings.indexOf(element);
        }
    }
}

